/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.diagnostics.AbstractProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationDetails;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationFinder;
import org.gradle.api.tasks.diagnostics.internal.DependencyReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.dependencies.AsciiDependencyReportRenderer;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractDependencyReportTask
extends AbstractProjectBasedReportTask<DependencyReportModel> {
    private DependencyReportRenderer renderer = new AsciiDependencyReportRenderer();
    private transient Set<Configuration> configurations;

    @Override
    public ReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DependencyReportRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    protected DependencyReportModel calculateReportModelFor(Project project) {
        TreeSet<Configuration> sortedConfigurations = new TreeSet<Configuration>(Comparator.comparing(Configuration::getName));
        sortedConfigurations.addAll(this.getReportConfigurations());
        ArrayList<ConfigurationDetails> configurationDetails = new ArrayList<ConfigurationDetails>(sortedConfigurations.size());
        for (Configuration configuration : sortedConfigurations) {
            configurationDetails.add(ConfigurationDetails.of(configuration));
        }
        return new DependencyReportModel(configurationDetails);
    }

    @Override
    protected void generateReportFor(ProjectDetails project, DependencyReportModel model) {
        for (ConfigurationDetails configuration : model.configurations) {
            this.renderer.startConfiguration(configuration);
            this.renderer.render(configuration);
            this.renderer.completeConfiguration(configuration);
        }
    }

    private Set<Configuration> getReportConfigurations() {
        return this.configurations != null ? this.configurations : this.getNonDeprecatedTaskConfigurations();
    }

    @Internal
    public Set<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Set<Configuration> configurations) {
        this.configurations = configurations;
    }

    @Option(option="configuration", description="The configuration to generate the report for.")
    public void setConfiguration(String configurationName) {
        this.configurations = Collections.singleton(ConfigurationFinder.find(this.getTaskConfigurations(), configurationName));
    }

    private Set<Configuration> getNonDeprecatedTaskConfigurations() {
        HashSet<Configuration> filteredConfigurations = new HashSet<Configuration>();
        for (Configuration configuration : this.getTaskConfigurations()) {
            if (((DeprecatableConfiguration)configuration).isFullyDeprecated()) continue;
            filteredConfigurations.add(configuration);
        }
        return filteredConfigurations;
    }

    @Internal
    public abstract ConfigurationContainer getTaskConfigurations();

    @Incubating
    public static final class DependencyReportModel {
        private final List<ConfigurationDetails> configurations;

        private DependencyReportModel(List<ConfigurationDetails> configurations) {
            this.configurations = configurations;
        }
    }
}

