/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.artifacts.DefaultResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenArtifacts;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.EndCollection;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.LocalDependencyFiles;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.AbstractTransformedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public class LocalFileDependencyBackedArtifactSet
implements ResolvedArtifactSet,
LocalDependencyFiles,
VariantSelector.Factory {
    private static final DisplayName LOCAL_FILE = Describables.of((Object)"local file");
    private final LocalFileDependencyMetadata dependencyMetadata;
    private final Spec<? super ComponentIdentifier> componentFilter;
    private final VariantSelector selector;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public LocalFileDependencyBackedArtifactSet(LocalFileDependencyMetadata dependencyMetadata, Spec<? super ComponentIdentifier> componentFilter, VariantSelector selector, ArtifactTypeRegistry artifactTypeRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.dependencyMetadata = dependencyMetadata;
        this.componentFilter = componentFilter;
        this.selector = selector;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    public LocalFileDependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    public ArtifactTypeRegistry getArtifactTypeRegistry() {
        return this.artifactTypeRegistry;
    }

    public Spec<? super ComponentIdentifier> getComponentFilter() {
        return this.componentFilter;
    }

    public VariantSelector getSelector() {
        return this.selector;
    }

    @Override
    public void visit(ResolvedArtifactSet.Visitor listener) {
        Set files;
        FileCollectionStructureVisitor.VisitType visitType = listener.prepareForVisit(this);
        if (visitType == FileCollectionStructureVisitor.VisitType.NoContents) {
            listener.visitArtifacts(new EndCollection(this));
            return;
        }
        ComponentIdentifier componentIdentifier = this.dependencyMetadata.getComponentId();
        if (componentIdentifier != null && !this.componentFilter.isSatisfiedBy((Object)componentIdentifier)) {
            listener.visitArtifacts(new EndCollection(this));
            return;
        }
        FileCollectionInternal fileCollection = this.dependencyMetadata.getFiles();
        try {
            files = fileCollection.getFiles();
        }
        catch (Exception throwable) {
            listener.visitArtifacts(new BrokenArtifacts(throwable));
            return;
        }
        ImmutableList.Builder selectedArtifacts = ImmutableList.builderWithExpectedSize((int)files.size());
        for (File file : files) {
            Object artifactIdentifier;
            if (componentIdentifier == null) {
                artifactIdentifier = new OpaqueComponentArtifactIdentifier(file);
                if (!this.componentFilter.isSatisfiedBy((Object)artifactIdentifier.getComponentIdentifier())) {
                    continue;
                }
            } else {
                artifactIdentifier = new ComponentFileArtifactIdentifier(componentIdentifier, file.getName());
            }
            ImmutableAttributes variantAttributes = this.artifactTypeRegistry.mapAttributesFor(file);
            SingletonFileResolvedVariant variant = new SingletonFileResolvedVariant(file, (ComponentArtifactIdentifier)artifactIdentifier, LOCAL_FILE, variantAttributes, this.dependencyMetadata, this.calculatedValueContainerFactory);
            selectedArtifacts.add((Object)this.selector.select(variant, this));
        }
        CompositeResolvedArtifactSet.of((Collection<? extends ResolvedArtifactSet>)selectedArtifacts.build()).visit(listener);
        if (visitType == FileCollectionStructureVisitor.VisitType.Spec) {
            listener.visitArtifacts(new CollectionSpec(fileCollection));
        }
    }

    @Override
    public ResolvedArtifactSet asTransformed(ResolvedVariant sourceVariant, VariantDefinition variantDefinition, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver, TransformedVariantFactory transformedVariantFactory) {
        return new TransformedLocalFileArtifactSet((SingletonFileResolvedVariant)sourceVariant, variantDefinition.getTargetAttributes(), variantDefinition.getTransformation(), dependenciesResolver, this.calculatedValueContainerFactory);
    }

    @Override
    public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
        throw new UnsupportedOperationException();
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.dependencyMetadata.getFiles().getBuildDependencies());
    }

    private static class CollectionSpec
    implements ResolvedArtifactSet.Artifacts {
        private final FileCollectionInternal fileCollection;

        public CollectionSpec(FileCollectionInternal fileCollection) {
            this.fileCollection = fileCollection;
        }

        @Override
        public void startFinalization(BuildOperationQueue<RunnableBuildOperation> actions, boolean requireFiles) {
        }

        @Override
        public void finalizeNow(boolean requireFiles) {
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            visitor.visitSpec(this.fileCollection);
        }
    }

    private static class TransformedLocalFileArtifactSet
    extends AbstractTransformedArtifactSet
    implements FileCollectionInternal.Source {
        private final SingletonFileResolvedVariant delegate;

        public TransformedLocalFileArtifactSet(SingletonFileResolvedVariant delegate, ImmutableAttributes attributes, Transformation transformation, ExtraExecutionGraphDependenciesResolverFactory dependenciesResolver, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            super(delegate.getComponentId(), delegate, attributes, Collections.emptyList(), transformation, dependenciesResolver, calculatedValueContainerFactory);
            this.delegate = delegate;
        }

        public ComponentIdentifier getOwnerId() {
            return this.delegate.getComponentId();
        }

        public File getFile() {
            return this.delegate.getFile();
        }
    }

    private static class SingletonFileResolvedVariant
    implements ResolvedVariant,
    ResolvedArtifactSet,
    ResolvedArtifactSet.Artifacts,
    ResolvedVariantSet {
        private final ComponentArtifactIdentifier artifactIdentifier;
        private final DisplayName variantName;
        private final ImmutableAttributes variantAttributes;
        private final LocalFileDependencyMetadata dependencyMetadata;
        private final ResolvableArtifact artifact;

        SingletonFileResolvedVariant(File file, ComponentArtifactIdentifier artifactIdentifier, DisplayName variantName, ImmutableAttributes variantAttributes, LocalFileDependencyMetadata dependencyMetadata, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.artifactIdentifier = artifactIdentifier;
            this.variantName = variantName;
            this.variantAttributes = variantAttributes;
            this.dependencyMetadata = dependencyMetadata;
            this.artifact = new DefaultResolvableArtifact(null, DefaultIvyArtifactName.forFile(file, null), this.artifactIdentifier, (TaskDependencyContainer)this.dependencyMetadata.getFiles(), (CalculatedValue<File>)calculatedValueContainerFactory.create(Describables.of((Object)artifactIdentifier), (Object)file), calculatedValueContainerFactory);
        }

        @Override
        public VariantResolveMetadata.Identifier getIdentifier() {
            return null;
        }

        public String toString() {
            return this.asDescribable().getDisplayName();
        }

        public File getFile() {
            return this.artifact.getFile();
        }

        public ComponentIdentifier getComponentId() {
            return this.artifactIdentifier.getComponentIdentifier();
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this;
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of((Object)this.artifactIdentifier);
        }

        @Override
        public Set<ResolvedVariant> getVariants() {
            return Collections.singleton(this);
        }

        @Override
        public Set<ResolvedVariant> getAllVariants() {
            return this.getVariants();
        }

        @Override
        public ImmutableAttributes getOverriddenAttributes() {
            return ImmutableAttributes.EMPTY;
        }

        @Override
        public AttributesSchemaInternal getSchema() {
            return EmptySchema.INSTANCE;
        }

        @Override
        public void visit(ResolvedArtifactSet.Visitor visitor) {
            visitor.visitArtifacts(this);
        }

        @Override
        public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void startFinalization(BuildOperationQueue<RunnableBuildOperation> actions, boolean requireFiles) {
        }

        @Override
        public void finalizeNow(boolean requireFiles) {
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            visitor.visitArtifact(this.variantName, (AttributeContainer)this.variantAttributes, Collections.emptyList(), this.artifact);
            visitor.endVisitCollection(FileCollectionInternal.OTHER);
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add((Object)this.dependencyMetadata.getFiles().getBuildDependencies());
        }

        @Override
        public AttributeContainerInternal getAttributes() {
            return this.variantAttributes;
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            return ImmutableCapabilities.EMPTY;
        }
    }
}

