/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableBufferImpl;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.DirectNonNativeWritableBufferImpl;
import com.yahoo.memory.DirectNonNativeWritableMemoryImpl;
import com.yahoo.memory.DirectWritableBufferImpl;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.StepBoolean;
import com.yahoo.memory.Util;
import com.yahoo.memory.WritableMemoryImpl;
import java.nio.ByteOrder;

final class DirectWritableMemoryImpl
extends WritableMemoryImpl {
    private static final int id = 8;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private MemoryRequestServer memReqSvr = null;
    private final byte typeId;

    DirectWritableMemoryImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid, MemoryRequestServer memReqSvr) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        this.memReqSvr = memReqSvr == null ? defaultMemReqSvr : memReqSvr;
        this.typeId = (byte)(8 | typeId & 7);
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return Util.isNativeOrder(byteOrder) ? new DirectWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr) : new DirectNonNativeWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | (readOnly ? (byte)1 : 0);
        return Util.isNativeOrder(byteOrder) ? new DirectWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr, this) : new DirectNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr, this);
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        this.assertValid();
        return this.memReqSvr;
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

