/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ratelimit;

import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.ratelimit.CheckpointReadWorker;
import org.opensearch.ad.ratelimit.EntityFeatureRequest;
import org.opensearch.ad.ratelimit.RequestPriority;
import org.opensearch.ad.ratelimit.ScheduledWorker;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.threadpool.ThreadPool;

public class ColdEntityWorker
extends ScheduledWorker<EntityFeatureRequest, EntityFeatureRequest> {
    public static final String WORKER_NAME = "cold-entity";

    public ColdEntityWorker(long heapSizeInBytes, int singleRequestSizeInBytes, Setting<Float> maxHeapPercentForQueueSetting, ClusterService clusterService, Random random, ADCircuitBreakerService adCircuitBreakerService, ThreadPool threadPool, Settings settings, float maxQueuedTaskRatio, Clock clock, float mediumSegmentPruneRatio, float lowSegmentPruneRatio, int maintenanceFreqConstant, CheckpointReadWorker checkpointReadQueue, Duration stateTtl, NodeStateManager nodeStateManager) {
        super(WORKER_NAME, heapSizeInBytes, singleRequestSizeInBytes, maxHeapPercentForQueueSetting, clusterService, random, adCircuitBreakerService, threadPool, settings, maxQueuedTaskRatio, clock, mediumSegmentPruneRatio, lowSegmentPruneRatio, maintenanceFreqConstant, checkpointReadQueue, stateTtl, nodeStateManager);
        this.batchSize = (Integer)AnomalyDetectorSettings.CHECKPOINT_READ_QUEUE_BATCH_SIZE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.CHECKPOINT_READ_QUEUE_BATCH_SIZE, it -> {
            this.batchSize = it;
        });
        this.expectedExecutionTimeInMilliSecsPerRequest = (Integer)AnomalyDetectorSettings.EXPECTED_COLD_ENTITY_EXECUTION_TIME_IN_MILLISECS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.EXPECTED_COLD_ENTITY_EXECUTION_TIME_IN_MILLISECS, it -> {
            this.expectedExecutionTimeInMilliSecsPerRequest = it;
        });
    }

    @Override
    protected List<EntityFeatureRequest> transformRequests(List<EntityFeatureRequest> requests) {
        return requests.stream().filter(request -> request.priority == RequestPriority.LOW).collect(Collectors.toList());
    }
}

