/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.ActionRunnable;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.BlobStoreException;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.monitor.jvm.JvmInfo;
import org.opensearch.repositories.RepositoryData;
import org.opensearch.repositories.RepositoryException;
import org.opensearch.repositories.ShardGenerations;
import org.opensearch.repositories.blobstore.MeteredBlobStoreRepository;
import org.opensearch.repositories.s3.S3AsyncService;
import org.opensearch.repositories.s3.S3BlobStore;
import org.opensearch.repositories.s3.S3ClientSettings;
import org.opensearch.repositories.s3.S3Service;
import org.opensearch.repositories.s3.async.AsyncExecutorContainer;
import org.opensearch.repositories.s3.async.AsyncTransferManager;
import org.opensearch.snapshots.SnapshotId;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotsService;
import org.opensearch.threadpool.Scheduler;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.StorageClass;

class S3Repository
extends MeteredBlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(S3Repository.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger((String)logger.getName());
    static final String TYPE = "s3";
    static final Setting<SecureString> ACCESS_KEY_SETTING = SecureSetting.insecureString((String)"access_key");
    static final Setting<SecureString> SECRET_KEY_SETTING = SecureSetting.insecureString((String)"secret_key");
    private static final ByteSizeValue DEFAULT_BUFFER_SIZE = new ByteSizeValue(Math.max(ByteSizeUnit.MB.toBytes(5L), Math.min(ByteSizeUnit.MB.toBytes(100L), JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() / 20L)), ByteSizeUnit.BYTES);
    private static final ByteSizeValue DEFAULT_MULTIPART_UPLOAD_MINIMUM_PART_SIZE = new ByteSizeValue(ByteSizeUnit.MB.toBytes(16L), ByteSizeUnit.BYTES);
    static final Setting<String> BUCKET_SETTING = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[0]);
    static final Setting<Boolean> SERVER_SIDE_ENCRYPTION_SETTING = Setting.boolSetting((String)"server_side_encryption", (boolean)false, (Setting.Property[])new Setting.Property[0]);
    static final ByteSizeValue MAX_FILE_SIZE = new ByteSizeValue(5L, ByteSizeUnit.GB);
    static final ByteSizeValue MIN_PART_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.MB);
    static final ByteSizeValue MAX_PART_SIZE_USING_MULTIPART = MAX_FILE_SIZE;
    static final ByteSizeValue MAX_FILE_SIZE_USING_MULTIPART = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final Setting<Boolean> REDIRECT_LARGE_S3_UPLOAD = Setting.boolSetting((String)"redirect_large_s3_upload", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Boolean> UPLOAD_RETRY_ENABLED = Setting.boolSetting((String)"s3_upload_retry_enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<ByteSizeValue> BUFFER_SIZE_SETTING = Setting.byteSizeSetting((String)"buffer_size", (ByteSizeValue)DEFAULT_BUFFER_SIZE, (ByteSizeValue)MIN_PART_SIZE_USING_MULTIPART, (ByteSizeValue)MAX_PART_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[0]);
    static final Setting<ByteSizeValue> PARALLEL_MULTIPART_UPLOAD_MINIMUM_PART_SIZE_SETTING = Setting.byteSizeSetting((String)"parallel_multipart_upload.minimum_part_size", (ByteSizeValue)DEFAULT_MULTIPART_UPLOAD_MINIMUM_PART_SIZE, (ByteSizeValue)MIN_PART_SIZE_USING_MULTIPART, (ByteSizeValue)MAX_PART_SIZE_USING_MULTIPART, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static Setting<Boolean> PARALLEL_MULTIPART_UPLOAD_ENABLED_SETTING = Setting.boolSetting((String)"parallel_multipart_upload.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.GB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(5L, ByteSizeUnit.TB), (Setting.Property[])new Setting.Property[0]);
    static final Setting<Integer> BULK_DELETE_SIZE = Setting.intSetting((String)"bulk_delete_size", (int)1000, (int)1, (int)1000, (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> STORAGE_CLASS_SETTING = Setting.simpleString((String)"storage_class", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CANNED_ACL_SETTING = Setting.simpleString((String)"canned_acl", (Setting.Property[])new Setting.Property[0]);
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    static final Setting<TimeValue> COOLDOWN_PERIOD = Setting.timeSetting((String)"cooldown_period", (TimeValue)new TimeValue(3L, TimeUnit.MINUTES), (TimeValue)new TimeValue(0L, TimeUnit.MILLISECONDS), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[0]);
    private final S3Service service;
    private volatile String bucket;
    private volatile ByteSizeValue bufferSize;
    private volatile ByteSizeValue chunkSize;
    private volatile BlobPath basePath;
    private volatile boolean serverSideEncryption;
    private volatile String storageClass;
    private volatile String cannedACL;
    private final TimeValue coolDown;
    private final AsyncTransferManager asyncUploadUtils;
    private final S3AsyncService s3AsyncService;
    private final boolean multipartUploadEnabled;
    private final AsyncExecutorContainer urgentExecutorBuilder;
    private final AsyncExecutorContainer priorityExecutorBuilder;
    private final AsyncExecutorContainer normalExecutorBuilder;
    private final Path pluginConfigPath;
    private volatile int bulkDeletesSize;
    private final AtomicReference<Scheduler.Cancellable> finalizationFuture = new AtomicReference();

    S3Repository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, S3Service service, ClusterService clusterService, RecoverySettings recoverySettings, AsyncTransferManager asyncUploadUtils, AsyncExecutorContainer urgentExecutorBuilder, AsyncExecutorContainer priorityExecutorBuilder, AsyncExecutorContainer normalExecutorBuilder, S3AsyncService s3AsyncService, boolean multipartUploadEnabled) {
        this(metadata, namedXContentRegistry, service, clusterService, recoverySettings, asyncUploadUtils, urgentExecutorBuilder, priorityExecutorBuilder, normalExecutorBuilder, s3AsyncService, multipartUploadEnabled, Path.of("", new String[0]));
    }

    S3Repository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, S3Service service, ClusterService clusterService, RecoverySettings recoverySettings, AsyncTransferManager asyncUploadUtils, AsyncExecutorContainer urgentExecutorBuilder, AsyncExecutorContainer priorityExecutorBuilder, AsyncExecutorContainer normalExecutorBuilder, S3AsyncService s3AsyncService, boolean multipartUploadEnabled, Path pluginConfigPath) {
        super(metadata, namedXContentRegistry, clusterService, recoverySettings, S3Repository.buildLocation(metadata));
        this.service = service;
        this.s3AsyncService = s3AsyncService;
        this.multipartUploadEnabled = multipartUploadEnabled;
        this.pluginConfigPath = pluginConfigPath;
        this.asyncUploadUtils = asyncUploadUtils;
        this.urgentExecutorBuilder = urgentExecutorBuilder;
        this.priorityExecutorBuilder = priorityExecutorBuilder;
        this.normalExecutorBuilder = normalExecutorBuilder;
        this.validateRepositoryMetadata(metadata);
        this.readRepositoryMetadata();
        this.coolDown = (TimeValue)COOLDOWN_PERIOD.get(metadata.settings());
    }

    private static Map<String, String> buildLocation(RepositoryMetadata metadata) {
        return Map.of("base_path", (String)BASE_PATH_SETTING.get(metadata.settings()), "bucket", (String)BUCKET_SETTING.get(metadata.settings()));
    }

    public void finalizeSnapshot(ShardGenerations shardGenerations, long repositoryStateId, Metadata clusterMetadata, SnapshotInfo snapshotInfo, Version repositoryMetaVersion, Function<ClusterState, ClusterState> stateTransformer, ActionListener<RepositoryData> listener) {
        if (!SnapshotsService.useShardGenerations((Version)repositoryMetaVersion)) {
            listener = this.delayedListener(listener);
        }
        super.finalizeSnapshot(shardGenerations, repositoryStateId, clusterMetadata, snapshotInfo, repositoryMetaVersion, stateTransformer, listener);
    }

    public void deleteSnapshots(Collection<SnapshotId> snapshotIds, long repositoryStateId, Version repositoryMetaVersion, ActionListener<RepositoryData> listener) {
        if (!SnapshotsService.useShardGenerations((Version)repositoryMetaVersion)) {
            listener = this.delayedListener(listener);
        }
        super.deleteSnapshots(snapshotIds, repositoryStateId, repositoryMetaVersion, listener);
    }

    private <T> ActionListener<T> delayedListener(ActionListener<T> listener) {
        final ActionListener wrappedListener = ActionListener.runBefore(listener, () -> {
            Scheduler.Cancellable cancellable = this.finalizationFuture.getAndSet(null);
            assert (cancellable != null);
        });
        return new ActionListener<T>(){

            public void onResponse(T response) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = S3Repository.this.finalizationFuture.getAndSet((Scheduler.Cancellable)S3Repository.this.threadPool.schedule((Runnable)ActionRunnable.wrap((ActionListener)wrappedListener, l -> l.onResponse(response)), S3Repository.this.coolDown, "snapshot"));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.this.finalizationFuture;
            }

            public void onFailure(Exception e) {
                S3Repository.this.logCooldownInfo();
                Scheduler.Cancellable existing = S3Repository.this.finalizationFuture.getAndSet((Scheduler.Cancellable)S3Repository.this.threadPool.schedule((Runnable)ActionRunnable.wrap((ActionListener)wrappedListener, l -> l.onFailure(e)), S3Repository.this.coolDown, "snapshot"));
                assert (existing == null) : "Already have an ongoing finalization " + S3Repository.this.finalizationFuture;
            }
        };
    }

    private void logCooldownInfo() {
        logger.info("Sleeping for [{}] after modifying repository [{}] because it contains snapshots older than version [{}] and therefore is using a backwards compatible metadata format that requires this cooldown period to avoid repository corruption. To get rid of this message and move to the new repository metadata format, either remove all snapshots older than version [{}] from the repository or create a new repository at an empty location.", (Object)this.coolDown, (Object)this.metadata.name(), (Object)SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION, (Object)SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION);
    }

    protected S3BlobStore createBlobStore() {
        return new S3BlobStore(this.service, this.s3AsyncService, this.multipartUploadEnabled, this.bucket, this.serverSideEncryption, this.bufferSize, this.cannedACL, this.storageClass, this.bulkDeletesSize, this.metadata, this.asyncUploadUtils, this.urgentExecutorBuilder, this.priorityExecutorBuilder, this.normalExecutorBuilder);
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    public BlobPath basePath() {
        return this.basePath;
    }

    public boolean isReloadable() {
        return true;
    }

    public void reload(RepositoryMetadata newRepositoryMetadata) {
        if (!this.isReloadable()) {
            return;
        }
        super.reload(newRepositoryMetadata);
        this.readRepositoryMetadata();
        this.service.settings(this.metadata);
        this.service.releaseCachedClients();
        this.s3AsyncService.settings(this.metadata);
        this.s3AsyncService.releaseCachedClients();
        BlobStore blobStore = this.getBlobStore();
        blobStore.reload(this.metadata);
    }

    private void readRepositoryMetadata() {
        this.bucket = (String)BUCKET_SETTING.get(this.metadata.settings());
        this.bufferSize = (ByteSizeValue)BUFFER_SIZE_SETTING.get(this.metadata.settings());
        this.chunkSize = (ByteSizeValue)CHUNK_SIZE_SETTING.get(this.metadata.settings());
        String basePath = (String)BASE_PATH_SETTING.get(this.metadata.settings());
        this.basePath = Strings.hasLength((String)basePath) ? new BlobPath().add(basePath) : BlobPath.cleanPath();
        this.serverSideEncryption = (Boolean)SERVER_SIDE_ENCRYPTION_SETTING.get(this.metadata.settings());
        this.storageClass = (String)STORAGE_CLASS_SETTING.get(this.metadata.settings());
        this.cannedACL = (String)CANNED_ACL_SETTING.get(this.metadata.settings());
        this.bulkDeletesSize = (Integer)BULK_DELETE_SIZE.get(this.metadata.settings());
        if (S3ClientSettings.checkDeprecatedCredentials(this.metadata.settings())) {
            deprecationLogger.deprecate("s3_repository_secret_settings", "Using s3 access/secret key from repository settings. Instead store these in named clients and the opensearch keystore for secure settings.", new Object[0]);
        }
        logger.debug("using bucket [{}], chunk_size [{}], server_side_encryption [{}], buffer_size [{}], cannedACL [{}], storageClass [{}]", (Object)this.bucket, (Object)this.chunkSize, (Object)this.serverSideEncryption, (Object)this.bufferSize, (Object)this.cannedACL, (Object)this.storageClass);
    }

    public void validateMetadata(RepositoryMetadata newRepositoryMetadata) {
        super.validateMetadata(newRepositoryMetadata);
        this.validateRepositoryMetadata(newRepositoryMetadata);
    }

    private void validateRepositoryMetadata(RepositoryMetadata newRepositoryMetadata) {
        Settings settings = newRepositoryMetadata.settings();
        if (BUCKET_SETTING.get(settings) == null) {
            throw new RepositoryException(newRepositoryMetadata.name(), "No bucket defined for s3 repository");
        }
        if (((ByteSizeValue)CHUNK_SIZE_SETTING.get(settings)).getBytes() < ((ByteSizeValue)BUFFER_SIZE_SETTING.get(settings)).getBytes()) {
            throw new RepositoryException(newRepositoryMetadata.name(), CHUNK_SIZE_SETTING.getKey() + " (" + CHUNK_SIZE_SETTING.get(settings) + ") can't be lower than " + BUFFER_SIZE_SETTING.getKey() + " (" + BUFFER_SIZE_SETTING.get(settings) + ").");
        }
        S3Repository.validateStorageClass((String)STORAGE_CLASS_SETTING.get(settings));
        S3Repository.validateCannedACL((String)CANNED_ACL_SETTING.get(settings));
    }

    private static void validateStorageClass(String storageClassStringValue) {
        if (storageClassStringValue == null || storageClassStringValue.equals("")) {
            return;
        }
        StorageClass storageClass = StorageClass.fromValue((String)storageClassStringValue.toUpperCase(Locale.ENGLISH));
        if (storageClass.equals((Object)StorageClass.GLACIER)) {
            throw new BlobStoreException("Glacier storage class is not supported");
        }
        if (storageClass == StorageClass.UNKNOWN_TO_SDK_VERSION) {
            throw new BlobStoreException("`" + storageClassStringValue + "` is not a valid S3 Storage Class.");
        }
    }

    private static void validateCannedACL(String cannedACLStringValue) {
        if (cannedACLStringValue == null || cannedACLStringValue.equals("")) {
            return;
        }
        for (ObjectCannedACL cur : ObjectCannedACL.values()) {
            if (!cur.toString().equalsIgnoreCase(cannedACLStringValue)) continue;
            return;
        }
        throw new BlobStoreException("cannedACL is not valid: [" + cannedACLStringValue + "]");
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public List<Setting<?>> getRestrictedSystemRepositorySettings() {
        ArrayList restrictedSettings = new ArrayList();
        restrictedSettings.addAll(super.getRestrictedSystemRepositorySettings());
        restrictedSettings.add(BUCKET_SETTING);
        restrictedSettings.add(BASE_PATH_SETTING);
        return restrictedSettings;
    }

    protected void doClose() {
        Scheduler.Cancellable cancellable = this.finalizationFuture.getAndSet(null);
        if (cancellable != null) {
            logger.debug("Repository [{}] closed during cool-down period", (Object)this.metadata.name());
            cancellable.cancel();
        }
        super.doClose();
    }
}

