# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
BRepCheck module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_brepcheck.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _BRepCheck
else:
    import _BRepCheck

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepCheck.delete_SwigPyIterator

    def value(self):
        return _BRepCheck.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _BRepCheck.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _BRepCheck.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _BRepCheck.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _BRepCheck.SwigPyIterator_equal(self, x)

    def copy(self):
        return _BRepCheck.SwigPyIterator_copy(self)

    def next(self):
        return _BRepCheck.SwigPyIterator_next(self)

    def __next__(self):
        return _BRepCheck.SwigPyIterator___next__(self)

    def previous(self):
        return _BRepCheck.SwigPyIterator_previous(self)

    def advance(self, n):
        return _BRepCheck.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _BRepCheck.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _BRepCheck.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _BRepCheck.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _BRepCheck.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _BRepCheck.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _BRepCheck.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _BRepCheck:
_BRepCheck.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _BRepCheck.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TopoDS
import OCC.Core.TopLoc
import OCC.Core.TopTools

from enum import IntEnum
from OCC.Core.Exception import *

BRepCheck_NoError = _BRepCheck.BRepCheck_NoError
BRepCheck_InvalidPointOnCurve = _BRepCheck.BRepCheck_InvalidPointOnCurve
BRepCheck_InvalidPointOnCurveOnSurface = _BRepCheck.BRepCheck_InvalidPointOnCurveOnSurface
BRepCheck_InvalidPointOnSurface = _BRepCheck.BRepCheck_InvalidPointOnSurface
BRepCheck_No3DCurve = _BRepCheck.BRepCheck_No3DCurve
BRepCheck_Multiple3DCurve = _BRepCheck.BRepCheck_Multiple3DCurve
BRepCheck_Invalid3DCurve = _BRepCheck.BRepCheck_Invalid3DCurve
BRepCheck_NoCurveOnSurface = _BRepCheck.BRepCheck_NoCurveOnSurface
BRepCheck_InvalidCurveOnSurface = _BRepCheck.BRepCheck_InvalidCurveOnSurface
BRepCheck_InvalidCurveOnClosedSurface = _BRepCheck.BRepCheck_InvalidCurveOnClosedSurface
BRepCheck_InvalidSameRangeFlag = _BRepCheck.BRepCheck_InvalidSameRangeFlag
BRepCheck_InvalidSameParameterFlag = _BRepCheck.BRepCheck_InvalidSameParameterFlag
BRepCheck_InvalidDegeneratedFlag = _BRepCheck.BRepCheck_InvalidDegeneratedFlag
BRepCheck_FreeEdge = _BRepCheck.BRepCheck_FreeEdge
BRepCheck_InvalidMultiConnexity = _BRepCheck.BRepCheck_InvalidMultiConnexity
BRepCheck_InvalidRange = _BRepCheck.BRepCheck_InvalidRange
BRepCheck_EmptyWire = _BRepCheck.BRepCheck_EmptyWire
BRepCheck_RedundantEdge = _BRepCheck.BRepCheck_RedundantEdge
BRepCheck_SelfIntersectingWire = _BRepCheck.BRepCheck_SelfIntersectingWire
BRepCheck_NoSurface = _BRepCheck.BRepCheck_NoSurface
BRepCheck_InvalidWire = _BRepCheck.BRepCheck_InvalidWire
BRepCheck_RedundantWire = _BRepCheck.BRepCheck_RedundantWire
BRepCheck_IntersectingWires = _BRepCheck.BRepCheck_IntersectingWires
BRepCheck_InvalidImbricationOfWires = _BRepCheck.BRepCheck_InvalidImbricationOfWires
BRepCheck_EmptyShell = _BRepCheck.BRepCheck_EmptyShell
BRepCheck_RedundantFace = _BRepCheck.BRepCheck_RedundantFace
BRepCheck_InvalidImbricationOfShells = _BRepCheck.BRepCheck_InvalidImbricationOfShells
BRepCheck_UnorientableShape = _BRepCheck.BRepCheck_UnorientableShape
BRepCheck_NotClosed = _BRepCheck.BRepCheck_NotClosed
BRepCheck_NotConnected = _BRepCheck.BRepCheck_NotConnected
BRepCheck_SubshapeNotInShape = _BRepCheck.BRepCheck_SubshapeNotInShape
BRepCheck_BadOrientation = _BRepCheck.BRepCheck_BadOrientation
BRepCheck_BadOrientationOfSubshape = _BRepCheck.BRepCheck_BadOrientationOfSubshape
BRepCheck_InvalidPolygonOnTriangulation = _BRepCheck.BRepCheck_InvalidPolygonOnTriangulation
BRepCheck_InvalidToleranceValue = _BRepCheck.BRepCheck_InvalidToleranceValue
BRepCheck_EnclosedRegion = _BRepCheck.BRepCheck_EnclosedRegion
BRepCheck_CheckFail = _BRepCheck.BRepCheck_CheckFail


class BRepCheck_Status(IntEnum):
	BRepCheck_NoError = 0
	BRepCheck_InvalidPointOnCurve = 1
	BRepCheck_InvalidPointOnCurveOnSurface = 2
	BRepCheck_InvalidPointOnSurface = 3
	BRepCheck_No3DCurve = 4
	BRepCheck_Multiple3DCurve = 5
	BRepCheck_Invalid3DCurve = 6
	BRepCheck_NoCurveOnSurface = 7
	BRepCheck_InvalidCurveOnSurface = 8
	BRepCheck_InvalidCurveOnClosedSurface = 9
	BRepCheck_InvalidSameRangeFlag = 10
	BRepCheck_InvalidSameParameterFlag = 11
	BRepCheck_InvalidDegeneratedFlag = 12
	BRepCheck_FreeEdge = 13
	BRepCheck_InvalidMultiConnexity = 14
	BRepCheck_InvalidRange = 15
	BRepCheck_EmptyWire = 16
	BRepCheck_RedundantEdge = 17
	BRepCheck_SelfIntersectingWire = 18
	BRepCheck_NoSurface = 19
	BRepCheck_InvalidWire = 20
	BRepCheck_RedundantWire = 21
	BRepCheck_IntersectingWires = 22
	BRepCheck_InvalidImbricationOfWires = 23
	BRepCheck_EmptyShell = 24
	BRepCheck_RedundantFace = 25
	BRepCheck_InvalidImbricationOfShells = 26
	BRepCheck_UnorientableShape = 27
	BRepCheck_NotClosed = 28
	BRepCheck_NotConnected = 29
	BRepCheck_SubshapeNotInShape = 30
	BRepCheck_BadOrientation = 31
	BRepCheck_BadOrientationOfSubshape = 32
	BRepCheck_InvalidPolygonOnTriangulation = 33
	BRepCheck_InvalidToleranceValue = 34
	BRepCheck_EnclosedRegion = 35
	BRepCheck_CheckFail = 36
BRepCheck_NoError = BRepCheck_Status.BRepCheck_NoError
BRepCheck_InvalidPointOnCurve = BRepCheck_Status.BRepCheck_InvalidPointOnCurve
BRepCheck_InvalidPointOnCurveOnSurface = BRepCheck_Status.BRepCheck_InvalidPointOnCurveOnSurface
BRepCheck_InvalidPointOnSurface = BRepCheck_Status.BRepCheck_InvalidPointOnSurface
BRepCheck_No3DCurve = BRepCheck_Status.BRepCheck_No3DCurve
BRepCheck_Multiple3DCurve = BRepCheck_Status.BRepCheck_Multiple3DCurve
BRepCheck_Invalid3DCurve = BRepCheck_Status.BRepCheck_Invalid3DCurve
BRepCheck_NoCurveOnSurface = BRepCheck_Status.BRepCheck_NoCurveOnSurface
BRepCheck_InvalidCurveOnSurface = BRepCheck_Status.BRepCheck_InvalidCurveOnSurface
BRepCheck_InvalidCurveOnClosedSurface = BRepCheck_Status.BRepCheck_InvalidCurveOnClosedSurface
BRepCheck_InvalidSameRangeFlag = BRepCheck_Status.BRepCheck_InvalidSameRangeFlag
BRepCheck_InvalidSameParameterFlag = BRepCheck_Status.BRepCheck_InvalidSameParameterFlag
BRepCheck_InvalidDegeneratedFlag = BRepCheck_Status.BRepCheck_InvalidDegeneratedFlag
BRepCheck_FreeEdge = BRepCheck_Status.BRepCheck_FreeEdge
BRepCheck_InvalidMultiConnexity = BRepCheck_Status.BRepCheck_InvalidMultiConnexity
BRepCheck_InvalidRange = BRepCheck_Status.BRepCheck_InvalidRange
BRepCheck_EmptyWire = BRepCheck_Status.BRepCheck_EmptyWire
BRepCheck_RedundantEdge = BRepCheck_Status.BRepCheck_RedundantEdge
BRepCheck_SelfIntersectingWire = BRepCheck_Status.BRepCheck_SelfIntersectingWire
BRepCheck_NoSurface = BRepCheck_Status.BRepCheck_NoSurface
BRepCheck_InvalidWire = BRepCheck_Status.BRepCheck_InvalidWire
BRepCheck_RedundantWire = BRepCheck_Status.BRepCheck_RedundantWire
BRepCheck_IntersectingWires = BRepCheck_Status.BRepCheck_IntersectingWires
BRepCheck_InvalidImbricationOfWires = BRepCheck_Status.BRepCheck_InvalidImbricationOfWires
BRepCheck_EmptyShell = BRepCheck_Status.BRepCheck_EmptyShell
BRepCheck_RedundantFace = BRepCheck_Status.BRepCheck_RedundantFace
BRepCheck_InvalidImbricationOfShells = BRepCheck_Status.BRepCheck_InvalidImbricationOfShells
BRepCheck_UnorientableShape = BRepCheck_Status.BRepCheck_UnorientableShape
BRepCheck_NotClosed = BRepCheck_Status.BRepCheck_NotClosed
BRepCheck_NotConnected = BRepCheck_Status.BRepCheck_NotConnected
BRepCheck_SubshapeNotInShape = BRepCheck_Status.BRepCheck_SubshapeNotInShape
BRepCheck_BadOrientation = BRepCheck_Status.BRepCheck_BadOrientation
BRepCheck_BadOrientationOfSubshape = BRepCheck_Status.BRepCheck_BadOrientationOfSubshape
BRepCheck_InvalidPolygonOnTriangulation = BRepCheck_Status.BRepCheck_InvalidPolygonOnTriangulation
BRepCheck_InvalidToleranceValue = BRepCheck_Status.BRepCheck_InvalidToleranceValue
BRepCheck_EnclosedRegion = BRepCheck_Status.BRepCheck_EnclosedRegion
BRepCheck_CheckFail = BRepCheck_Status.BRepCheck_CheckFail


def Handle_BRepCheck_Result_Create():
    return _BRepCheck.Handle_BRepCheck_Result_Create()

def Handle_BRepCheck_Result_DownCast(t):
    return _BRepCheck.Handle_BRepCheck_Result_DownCast(t)

def Handle_BRepCheck_Result_IsNull(t):
    return _BRepCheck.Handle_BRepCheck_Result_IsNull(t)

def Handle_BRepCheck_Edge_Create():
    return _BRepCheck.Handle_BRepCheck_Edge_Create()

def Handle_BRepCheck_Edge_DownCast(t):
    return _BRepCheck.Handle_BRepCheck_Edge_DownCast(t)

def Handle_BRepCheck_Edge_IsNull(t):
    return _BRepCheck.Handle_BRepCheck_Edge_IsNull(t)

def Handle_BRepCheck_Face_Create():
    return _BRepCheck.Handle_BRepCheck_Face_Create()

def Handle_BRepCheck_Face_DownCast(t):
    return _BRepCheck.Handle_BRepCheck_Face_DownCast(t)

def Handle_BRepCheck_Face_IsNull(t):
    return _BRepCheck.Handle_BRepCheck_Face_IsNull(t)

def Handle_BRepCheck_Shell_Create():
    return _BRepCheck.Handle_BRepCheck_Shell_Create()

def Handle_BRepCheck_Shell_DownCast(t):
    return _BRepCheck.Handle_BRepCheck_Shell_DownCast(t)

def Handle_BRepCheck_Shell_IsNull(t):
    return _BRepCheck.Handle_BRepCheck_Shell_IsNull(t)

def Handle_BRepCheck_Solid_Create():
    return _BRepCheck.Handle_BRepCheck_Solid_Create()

def Handle_BRepCheck_Solid_DownCast(t):
    return _BRepCheck.Handle_BRepCheck_Solid_DownCast(t)

def Handle_BRepCheck_Solid_IsNull(t):
    return _BRepCheck.Handle_BRepCheck_Solid_IsNull(t)

def Handle_BRepCheck_Vertex_Create():
    return _BRepCheck.Handle_BRepCheck_Vertex_Create()

def Handle_BRepCheck_Vertex_DownCast(t):
    return _BRepCheck.Handle_BRepCheck_Vertex_DownCast(t)

def Handle_BRepCheck_Vertex_IsNull(t):
    return _BRepCheck.Handle_BRepCheck_Vertex_IsNull(t)

def Handle_BRepCheck_Wire_Create():
    return _BRepCheck.Handle_BRepCheck_Wire_Create()

def Handle_BRepCheck_Wire_DownCast(t):
    return _BRepCheck.Handle_BRepCheck_Wire_DownCast(t)

def Handle_BRepCheck_Wire_IsNull(t):
    return _BRepCheck.Handle_BRepCheck_Wire_IsNull(t)
class BRepCheck_IndexedDataMapOfShapeResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_begin(self)

    def end(self):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_end(self)

    def cbegin(self):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_cbegin(self)

    def cend(self):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_cend(self)

    def __init__(self, *args):
        _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_swiginit(self, _BRepCheck.new_BRepCheck_IndexedDataMapOfShapeResult(*args))

    def Exchange(self, theOther):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Exchange(self, theOther)

    def Assign(self, theOther):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Assign(self, theOther)

    def Set(self, theOther):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Set(self, theOther)

    def ReSize(self, N):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_ReSize(self, N)

    def Add(self, theKey1, theItem):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Add(self, theKey1, theItem)

    def Contains(self, theKey1):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Contains(self, theKey1)

    def Substitute(self, theIndex, theKey1, theItem):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Substitute(self, theIndex, theKey1, theItem)

    def Swap(self, theIndex1, theIndex2):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Swap(self, theIndex1, theIndex2)

    def RemoveLast(self):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_RemoveLast(self)

    def RemoveFromIndex(self, theIndex):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_RemoveFromIndex(self, theIndex)

    def RemoveKey(self, theKey1):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_RemoveKey(self, theKey1)

    def FindKey(self, theIndex):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_FindKey(self, theIndex)

    def FindFromIndex(self, theIndex):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_FindFromIndex(self, theIndex)

    def ChangeFromIndex(self, theIndex):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_ChangeFromIndex(self, theIndex)

    def __call__(self, *args):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult___call__(self, *args)

    def FindIndex(self, theKey1):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_FindIndex(self, theKey1)

    def ChangeFromKey(self, theKey1):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_ChangeFromKey(self, theKey1)

    def Seek(self, theKey1):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Seek(self, theKey1)

    def ChangeSeek(self, theKey1):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_ChangeSeek(self, theKey1)

    def FindFromKey(self, *args):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_FindFromKey(self, *args)

    def Clear(self, *args):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Clear(self, *args)
    __swig_destroy__ = _BRepCheck.delete_BRepCheck_IndexedDataMapOfShapeResult

    def Size(self):
        return _BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_Size(self)

# Register BRepCheck_IndexedDataMapOfShapeResult in _BRepCheck:
_BRepCheck.BRepCheck_IndexedDataMapOfShapeResult_swigregister(BRepCheck_IndexedDataMapOfShapeResult)
class BRepCheck_ListIteratorOfListOfStatus(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _BRepCheck.BRepCheck_ListIteratorOfListOfStatus_swiginit(self, _BRepCheck.new_BRepCheck_ListIteratorOfListOfStatus(*args))

    def More(self):
        return _BRepCheck.BRepCheck_ListIteratorOfListOfStatus_More(self)

    def Next(self):
        return _BRepCheck.BRepCheck_ListIteratorOfListOfStatus_Next(self)

    def Value(self):
        return _BRepCheck.BRepCheck_ListIteratorOfListOfStatus_Value(self)

    def ChangeValue(self):
        return _BRepCheck.BRepCheck_ListIteratorOfListOfStatus_ChangeValue(self)
    __swig_destroy__ = _BRepCheck.delete_BRepCheck_ListIteratorOfListOfStatus

# Register BRepCheck_ListIteratorOfListOfStatus in _BRepCheck:
_BRepCheck.BRepCheck_ListIteratorOfListOfStatus_swigregister(BRepCheck_ListIteratorOfListOfStatus)
class BRepCheck_ListOfStatus(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _BRepCheck.BRepCheck_ListOfStatus_begin(self)

    def end(self):
        return _BRepCheck.BRepCheck_ListOfStatus_end(self)

    def cbegin(self):
        return _BRepCheck.BRepCheck_ListOfStatus_cbegin(self)

    def cend(self):
        return _BRepCheck.BRepCheck_ListOfStatus_cend(self)

    def __init__(self, *args):
        _BRepCheck.BRepCheck_ListOfStatus_swiginit(self, _BRepCheck.new_BRepCheck_ListOfStatus(*args))

    def Size(self):
        return _BRepCheck.BRepCheck_ListOfStatus_Size(self)

    def Assign(self, theOther):
        return _BRepCheck.BRepCheck_ListOfStatus_Assign(self, theOther)

    def Set(self, theOther):
        return _BRepCheck.BRepCheck_ListOfStatus_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _BRepCheck.BRepCheck_ListOfStatus_Clear(self, theAllocator)

    def First(self):
        return _BRepCheck.BRepCheck_ListOfStatus_First(self)

    def Last(self):
        return _BRepCheck.BRepCheck_ListOfStatus_Last(self)

    def Append(self, *args):
        return _BRepCheck.BRepCheck_ListOfStatus_Append(self, *args)

    def Prepend(self, *args):
        return _BRepCheck.BRepCheck_ListOfStatus_Prepend(self, *args)

    def RemoveFirst(self):
        return _BRepCheck.BRepCheck_ListOfStatus_RemoveFirst(self)

    def Remove(self, theIter):
        return _BRepCheck.BRepCheck_ListOfStatus_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _BRepCheck.BRepCheck_ListOfStatus_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _BRepCheck.BRepCheck_ListOfStatus_InsertAfter(self, *args)

    def Reverse(self):
        return _BRepCheck.BRepCheck_ListOfStatus_Reverse(self)
    __swig_destroy__ = _BRepCheck.delete_BRepCheck_ListOfStatus

    def __len__(self):
        return self.Size()


# Register BRepCheck_ListOfStatus in _BRepCheck:
_BRepCheck.BRepCheck_ListOfStatus_swigregister(BRepCheck_ListOfStatus)
class brepcheck(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Add(*args):
        r"""

        Parameters
        ----------
        List: BRepCheck_ListOfStatus
        Stat: BRepCheck_Status

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.brepcheck_Add(*args)

    @staticmethod
    def PrecCurve(*args):
        r"""

        Parameters
        ----------
        aAC3D: Adaptor3d_Curve

        Return
        -------
        float

        Description
        -----------
        Returns the resolution on the 3d curve.

        """
        return _BRepCheck.brepcheck_PrecCurve(*args)

    @staticmethod
    def PrecSurface(*args):
        r"""

        Parameters
        ----------
        aAHSurf: Adaptor3d_Surface

        Return
        -------
        float

        Description
        -----------
        Returns the resolution on the surface.

        """
        return _BRepCheck.brepcheck_PrecSurface(*args)

    @staticmethod
    def SelfIntersection(*args):
        r"""

        Parameters
        ----------
        W: TopoDS_Wire
        F: TopoDS_Face
        E1: TopoDS_Edge
        E2: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.brepcheck_SelfIntersection(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _BRepCheck.brepcheck_swiginit(self, _BRepCheck.new_brepcheck())
    __swig_destroy__ = _BRepCheck.delete_brepcheck

# Register brepcheck in _BRepCheck:
_BRepCheck.brepcheck_swigregister(brepcheck)
class BRepCheck_Analyzer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        GeomControls: bool (optional, default to Standard_True)
        theIsParallel: bool (optional, default to Standard_False)
        theIsExact: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Constructs a shape validation object defined by the shape s. <s> is the shape to control. <geomcontrols> if false only topological informaions are checked. the geometricals controls are for a vertex: brepcheck_invalidtolerancevalue nyi for an edge: brepcheck_invalidcurveonclosedsurface, brepcheck_invalidcurveonsurface, brepcheck_invalidsameparameterflag, brepcheck_invalidtolerancevalue nyi for a face: brepcheck_unorientableshape, brepcheck_intersectingwires, brepcheck_invalidtolerancevalue nyi for a wire: brepcheck_selfintersectingwire.

        """
        _BRepCheck.BRepCheck_Analyzer_swiginit(self, _BRepCheck.new_BRepCheck_Analyzer(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        GeomControls: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        <s> is the shape to control. <geomcontrols> if false only topological informaions are checked. the geometricals controls are for a vertex: brepcheck_invalidtolerance nyi for an edge: brepcheck_invalidcurveonclosedsurface, brepcheck_invalidcurveonsurface, brepcheck_invalidsameparameterflag, brepcheck_invalidtolerance nyi for a face: brepcheck_unorientableshape, brepcheck_intersectingwires, brepcheck_invalidtolerance nyi for a wire: brepcheck_selfintersectingwire.

        """
        return _BRepCheck.BRepCheck_Analyzer_Init(self, *args)

    def IsExactMethod(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if exact method selected.

        """
        return _BRepCheck.BRepCheck_Analyzer_IsExactMethod(self, *args)

    def IsParallel(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if parallel flag is set.

        """
        return _BRepCheck.BRepCheck_Analyzer_IsParallel(self, *args)

    def IsValid(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        <s> is a subshape of the original shape. returns <standard_true> if no default has been detected on <s> and any of its subshape.
        Return
        -------
        bool

        Description
        -----------
        Returns true if no defect is detected on the shape s or any of its subshapes. returns true if the shape s is valid. this function checks whether a given shape is valid by checking that: - the topology is correct - parameterization of edges in particular is correct. for the topology to be correct, the following conditions must be satisfied: - edges should have at least two vertices if they are not degenerate edges. the vertices should be within the range of the bounding edges at the tolerance specified in the vertex, - edges should share at least one face. the representation of the edges should be within the tolerance criterion assigned to them. - wires defining a face should not self-intersect and should be closed, - there should be one wire which contains all other wires inside a face, - wires should be correctly oriented with respect to each of the edges, - faces should be correctly oriented, in particular with respect to adjacent faces if these faces define a solid, - shells defining a solid should be closed. there should be one enclosing shell if the shape is a solid; to check parameterization of edge, there are 2 approaches depending on the edge?s contextual situation. - if the edge is either single, or it is in the context of a wire or a compound, its parameterization is defined by the parameterization of its 3d curve and is considered as valid. - if the edge is in the context of a face, it should have sameparameter and samerange flags set to standard_true. to check these flags, you should call the function brep_tool::sameparameter and brep_tool::samerange for an edge. if at least one of these flags is set to standard_false, the edge is considered as invalid without any additional check. if the edge is contained by a face, and it has sameparameter and samerange flags set to standard_true, isvalid checks whether representation of the edge on face, in context of which the edge is considered, has the same parameterization up to the tolerance value coded on the edge. for a given parameter t on the edge having c as a 3d curve and one pcurve p on a surface s (base surface of the reference face), this checks that |c(t) - s(p(t))| is less than or equal to tolerance, where tolerance is the tolerance value coded on the edge.

        """
        return _BRepCheck.BRepCheck_Analyzer_IsValid(self, *args)

    def Result(self, *args):
        r"""

        Parameters
        ----------
        theSubS: TopoDS_Shape

        Return
        -------
        opencascade::handle<BRepCheck_Result>

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Analyzer_Result(self, *args)

    def SetExactMethod(self, *args):
        r"""

        Parameters
        ----------
        theIsExact: bool

        Return
        -------
        None

        Description
        -----------
        Sets method to calculate distance: calculating in finite number of points (if theisexact is false, faster, but possible not correct result) or exact calculating by using breplib_checkcurveonsurface class (if theisexact is true, slowly, but more correctly). exact method is used only when edge is sameparameter. default method is calculating in finite number of points.

        """
        return _BRepCheck.BRepCheck_Analyzer_SetExactMethod(self, *args)

    def SetParallel(self, *args):
        r"""

        Parameters
        ----------
        theIsParallel: bool

        Return
        -------
        None

        Description
        -----------
        Sets parallel flag.

        """
        return _BRepCheck.BRepCheck_Analyzer_SetParallel(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepCheck.delete_BRepCheck_Analyzer

# Register BRepCheck_Analyzer in _BRepCheck:
_BRepCheck.BRepCheck_Analyzer_swigregister(BRepCheck_Analyzer)
class BRepCheck_Result(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Blind(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_Blind(self, *args)

    def ContextualShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_ContextualShape(self, *args)

    def InContext(self, *args):
        r"""

        Parameters
        ----------
        ContextShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_InContext(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_Init(self, *args)

    def InitContextIterator(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_InitContextIterator(self, *args)

    def IsBlind(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_IsBlind(self, *args)

    def IsMinimum(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_IsMinimum(self, *args)

    def IsStatusOnShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_IsStatusOnShape(self, *args)

    def Minimum(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_Minimum(self, *args)

    def MoreShapeInContext(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_MoreShapeInContext(self, *args)

    def NextShapeInContext(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_NextShapeInContext(self, *args)

    def SetFailStatus(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_SetFailStatus(self, *args)

    def SetParallel(self, *args):
        r"""

        Parameters
        ----------
        theIsParallel: bool

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_SetParallel(self, *args)

    def Status(self, *args):
        r"""
        Return
        -------
        BRepCheck_ListOfStatus

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_Status(self, *args)

    def StatusOnShape(self, *args):
        r"""
        Return
        -------
        BRepCheck_ListOfStatus

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        BRepCheck_ListOfStatus

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Result_StatusOnShape(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepCheck_Result_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepCheck.delete_BRepCheck_Result

# Register BRepCheck_Result in _BRepCheck:
_BRepCheck.BRepCheck_Result_swigregister(BRepCheck_Result)
class BRepCheck_Edge(BRepCheck_Result):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepCheck.BRepCheck_Edge_swiginit(self, _BRepCheck.new_BRepCheck_Edge(*args))

    def CheckPolygonOnTriangulation(self, *args):
        r"""

        Parameters
        ----------
        theEdge: TopoDS_Edge

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        Checks, if polygon on triangulation of heedge is out of 3d-curve of this edge.

        """
        return _BRepCheck.BRepCheck_Edge_CheckPolygonOnTriangulation(self, *args)

    def GeometricControls(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        B: bool

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Edge_GeometricControls(self, *args)

    def IsExactMethod(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if exact method selected.

        """
        return _BRepCheck.BRepCheck_Edge_IsExactMethod(self, *args)

    def SetExactMethod(self, *args):
        r"""

        Parameters
        ----------
        theIsExact: bool

        Return
        -------
        None

        Description
        -----------
        Sets method to calculate distance: calculating in finite number of points (if theisexact is false, faster, but possible not correct result) or exact calculating by using breplib_checkcurveonsurface class (if theisexact is true, slowly, but more correctly). exact method is used only when edge is sameparameter. default method is calculating in finite number of points.

        """
        return _BRepCheck.BRepCheck_Edge_SetExactMethod(self, *args)

    def SetStatus(self, *args):
        r"""

        Parameters
        ----------
        theStatus: BRepCheck_Status

        Return
        -------
        None

        Description
        -----------
        Sets status of edge;.

        """
        return _BRepCheck.BRepCheck_Edge_SetStatus(self, *args)

    def Tolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Edge_Tolerance(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepCheck_Edge_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepCheck.delete_BRepCheck_Edge

# Register BRepCheck_Edge in _BRepCheck:
_BRepCheck.BRepCheck_Edge_swigregister(BRepCheck_Edge)
class BRepCheck_Face(BRepCheck_Result):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepCheck.BRepCheck_Face_swiginit(self, _BRepCheck.new_BRepCheck_Face(*args))

    def ClassifyWires(self, *args):
        r"""

        Parameters
        ----------
        Update: bool (optional, default to Standard_False)

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Face_ClassifyWires(self, *args)

    def GeometricControls(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        B: bool

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Face_GeometricControls(self, *args)

    def IntersectWires(self, *args):
        r"""

        Parameters
        ----------
        Update: bool (optional, default to Standard_False)

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Face_IntersectWires(self, *args)

    def IsUnorientable(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Face_IsUnorientable(self, *args)

    def OrientationOfWires(self, *args):
        r"""

        Parameters
        ----------
        Update: bool (optional, default to Standard_False)

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Face_OrientationOfWires(self, *args)

    def SetStatus(self, *args):
        r"""

        Parameters
        ----------
        theStatus: BRepCheck_Status

        Return
        -------
        None

        Description
        -----------
        Sets status of face;.

        """
        return _BRepCheck.BRepCheck_Face_SetStatus(self, *args)

    def SetUnorientable(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Face_SetUnorientable(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepCheck_Face_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepCheck.delete_BRepCheck_Face

# Register BRepCheck_Face in _BRepCheck:
_BRepCheck.BRepCheck_Face_swigregister(BRepCheck_Face)
class BRepCheck_Shell(BRepCheck_Result):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepCheck.BRepCheck_Shell_swiginit(self, _BRepCheck.new_BRepCheck_Shell(*args))

    def Closed(self, *args):
        r"""

        Parameters
        ----------
        Update: bool (optional, default to Standard_False)

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        Checks if the oriented faces of the shell give a closed shell. if the wire is closed, returns brepcheck_noerror.if <update> is set to standard_true, registers the status in the list.

        """
        return _BRepCheck.BRepCheck_Shell_Closed(self, *args)

    def IsUnorientable(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Shell_IsUnorientable(self, *args)

    def NbConnectedSet(self, *args):
        r"""

        Parameters
        ----------
        theSets: TopTools_ListOfShape

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Shell_NbConnectedSet(self, *args)

    def Orientation(self, *args):
        r"""

        Parameters
        ----------
        Update: bool (optional, default to Standard_False)

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        Checks if the oriented faces of the shell are correctly oriented. an internal call is made to the method closed. if <update> is set to standard_true, registers the status in the list.

        """
        return _BRepCheck.BRepCheck_Shell_Orientation(self, *args)

    def SetUnorientable(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Shell_SetUnorientable(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepCheck_Shell_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepCheck.delete_BRepCheck_Shell

# Register BRepCheck_Shell in _BRepCheck:
_BRepCheck.BRepCheck_Shell_swigregister(BRepCheck_Shell)
class BRepCheck_Solid(BRepCheck_Result):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theS: TopoDS_Solid

        Return
        -------
        None

        Description
        -----------
        Constructor <thes> is the solid to check.

        """
        _BRepCheck.BRepCheck_Solid_swiginit(self, _BRepCheck.new_BRepCheck_Solid(*args))


    @staticmethod
    def DownCast(t):
      return Handle_BRepCheck_Solid_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepCheck.delete_BRepCheck_Solid

# Register BRepCheck_Solid in _BRepCheck:
_BRepCheck.BRepCheck_Solid_swigregister(BRepCheck_Solid)
class BRepCheck_Vertex(BRepCheck_Result):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        V: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepCheck.BRepCheck_Vertex_swiginit(self, _BRepCheck.new_BRepCheck_Vertex(*args))

    def Tolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _BRepCheck.BRepCheck_Vertex_Tolerance(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepCheck_Vertex_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepCheck.delete_BRepCheck_Vertex

# Register BRepCheck_Vertex in _BRepCheck:
_BRepCheck.BRepCheck_Vertex_swigregister(BRepCheck_Vertex)
class BRepCheck_Wire(BRepCheck_Result):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        W: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _BRepCheck.BRepCheck_Wire_swiginit(self, _BRepCheck.new_BRepCheck_Wire(*args))

    def Closed(self, *args):
        r"""

        Parameters
        ----------
        Update: bool (optional, default to Standard_False)

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        Checks if the oriented edges of the wire give a closed wire. if the wire is closed, returns brepcheck_noerror. warning: if the first and last edge are infinite, the wire will be considered as a closed one. if <update> is set to standard_true, registers the status in the list. may return (and registers): **brepcheck_notconnected, if wire is not topologically closed **brepcheck_redundantedge, if an edge is in wire more than 3 times or in case of 2 occurrences if not with forward and reversed orientation. **brepcheck_noerror.

        """
        return _BRepCheck.BRepCheck_Wire_Closed(self, *args)

    def Closed2d(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        Update: bool (optional, default to Standard_False)

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        Checks if edges of the wire give a wire closed in 2d space. returns brepcheck_noerror, or brepcheck_notclosed if <update> is set to standard_true, registers the status in the list.

        """
        return _BRepCheck.BRepCheck_Wire_Closed2d(self, *args)

    def GeometricControls(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Report selfintersect() check would be (is) done.

        Parameters
        ----------
        B: bool

        Return
        -------
        None

        Description
        -----------
        Set selfintersect() to be checked.

        """
        return _BRepCheck.BRepCheck_Wire_GeometricControls(self, *args)

    def Orientation(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        Update: bool (optional, default to Standard_False)

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        Checks if the oriented edges of the wire are correctly oriented. an internal call is made to the method closed. if no face exists, call the method with a null face (topods_face()). if <update> is set to standard_true, registers the status in the list. may return (and registers): brepcheck_invaliddegeneratedflag, brepcheck_badorientationofsubshape, brepcheck_notclosed, brepcheck_noerror.

        """
        return _BRepCheck.BRepCheck_Wire_Orientation(self, *args)

    def SelfIntersect(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        Update: bool (optional, default to Standard_False)

        Return
        -------
        BRepCheck_Status

        Description
        -----------
        Checks if the wire intersect itself on the face <f>. <e1> and <e2> are the first intersecting edges found. <e2> may be a null edge when a self-intersecting edge is found.if <update> is set to standard_true, registers the status in the list. may return (and register): brepcheck_emptywire, brepcheck_selfintersectingwire, brepcheck_nocurveonsurface, brepcheck_noerror.

        """
        return _BRepCheck.BRepCheck_Wire_SelfIntersect(self, *args)

    def SetStatus(self, *args):
        r"""

        Parameters
        ----------
        theStatus: BRepCheck_Status

        Return
        -------
        None

        Description
        -----------
        Sets status of wire;.

        """
        return _BRepCheck.BRepCheck_Wire_SetStatus(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_BRepCheck_Wire_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepCheck.delete_BRepCheck_Wire

# Register BRepCheck_Wire in _BRepCheck:
_BRepCheck.BRepCheck_Wire_swigregister(BRepCheck_Wire)



@deprecated
def brepcheck_Add(*args):
	return brepcheck.Add(*args)

@deprecated
def brepcheck_PrecCurve(*args):
	return brepcheck.PrecCurve(*args)

@deprecated
def brepcheck_PrecSurface(*args):
	return brepcheck.PrecSurface(*args)

@deprecated
def brepcheck_SelfIntersection(*args):
	return brepcheck.SelfIntersection(*args)



