complete -c jwt -n "__fish_use_subcommand" -s h -l help -d 'Print help'
complete -c jwt -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c jwt -n "__fish_use_subcommand" -f -a "encode" -d 'Encode new JWTs'
complete -c jwt -n "__fish_use_subcommand" -f -a "decode" -d 'Decode a JWT'
complete -c jwt -n "__fish_use_subcommand" -f -a "completion" -d 'Print completion'
complete -c jwt -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c jwt -n "__fish_seen_subcommand_from encode" -s A -l alg -d 'the algorithm to use for signing the JWT' -r -f -a "{HS256	'',HS384	'',HS512	'',RS256	'',RS384	'',RS512	'',PS256	'',PS384	'',PS512	'',ES256	'',ES384	'',EDDSA	''}"
complete -c jwt -n "__fish_seen_subcommand_from encode" -s k -l kid -d 'the kid to place in the header' -r
complete -c jwt -n "__fish_seen_subcommand_from encode" -s t -l typ -d 'the type of token being encoded' -r -f -a "{jwt	''}"
complete -c jwt -n "__fish_seen_subcommand_from encode" -s P -l payload -d 'a key=value pair to add to the payload' -r
complete -c jwt -n "__fish_seen_subcommand_from encode" -s e -l exp -d 'the time the token should expire, in seconds or a systemd.time string' -r
complete -c jwt -n "__fish_seen_subcommand_from encode" -s i -l iss -d 'the issuer of the token' -r
complete -c jwt -n "__fish_seen_subcommand_from encode" -s s -l sub -d 'the subject of the token' -r
complete -c jwt -n "__fish_seen_subcommand_from encode" -s a -l aud -d 'the audience of the token' -r
complete -c jwt -n "__fish_seen_subcommand_from encode" -l jti -d 'the jwt id of the token' -r
complete -c jwt -n "__fish_seen_subcommand_from encode" -s n -l nbf -d 'the time the JWT should become valid, in seconds or a systemd.time string' -r
complete -c jwt -n "__fish_seen_subcommand_from encode" -s S -l secret -d 'the secret to sign the JWT with. Prefix with @ to read from a file or b64: to use base-64 encoded bytes' -r
complete -c jwt -n "__fish_seen_subcommand_from encode" -s o -l out -d 'The path of the file to write the result to (suppresses default standard output)' -r -F
complete -c jwt -n "__fish_seen_subcommand_from encode" -l no-iat -d 'prevent an iat claim from being automatically added'
complete -c jwt -n "__fish_seen_subcommand_from encode" -l no-typ -d 'prevent typ from being added to the header'
complete -c jwt -n "__fish_seen_subcommand_from encode" -l keep-payload-order -d 'prevent re-ordering of payload keys'
complete -c jwt -n "__fish_seen_subcommand_from encode" -s h -l help -d 'Print help'
complete -c jwt -n "__fish_seen_subcommand_from encode" -s V -l version -d 'Print version'
complete -c jwt -n "__fish_seen_subcommand_from decode" -s A -l alg -d 'The algorithm used to sign the JWT' -r -f -a "{HS256	'',HS384	'',HS512	'',RS256	'',RS384	'',RS512	'',PS256	'',PS384	'',PS512	'',ES256	'',ES384	'',EDDSA	''}"
complete -c jwt -n "__fish_seen_subcommand_from decode" -l date -d 'Display unix timestamps as ISO 8601 dates [default: UTC] [possible values: UTC, Local, Offset (e.g. -02:00)]' -r
complete -c jwt -n "__fish_seen_subcommand_from decode" -s S -l secret -d 'The secret to validate the JWT with. Prefix with @ to read from a file or b64: to use base-64 encoded bytes' -r
complete -c jwt -n "__fish_seen_subcommand_from decode" -s o -l out -d 'The path of the file to write the result to (suppresses default standard output, implies JSON format)' -r -F
complete -c jwt -n "__fish_seen_subcommand_from decode" -s j -l json -d 'Render the decoded JWT as JSON'
complete -c jwt -n "__fish_seen_subcommand_from decode" -l ignore-exp -d 'Ignore token expiration date (`exp` claim) during validation'
complete -c jwt -n "__fish_seen_subcommand_from decode" -s h -l help -d 'Print help'
complete -c jwt -n "__fish_seen_subcommand_from decode" -s V -l version -d 'Print version'
complete -c jwt -n "__fish_seen_subcommand_from completion" -s h -l help -d 'Print help'
complete -c jwt -n "__fish_seen_subcommand_from completion" -s V -l version -d 'Print version'
complete -c jwt -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encode; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "encode" -d 'Encode new JWTs'
complete -c jwt -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encode; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "decode" -d 'Decode a JWT'
complete -c jwt -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encode; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "completion" -d 'Print completion'
complete -c jwt -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encode; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
