"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const get_timer_1 = __importDefault(require("./get-timer"));
class PingTimer {
    constructor(keepalive, checkPing, variant) {
        this.keepalive = keepalive * 1000;
        this.checkPing = checkPing;
        this.timer = (0, get_timer_1.default)(variant);
        this.reschedule();
    }
    clear() {
        if (this.timerId) {
            this.timer.clear(this.timerId);
            this.timerId = null;
        }
    }
    reschedule() {
        this.clear();
        this.timerId = this.timer.set(() => {
            this.checkPing();
            if (this.timerId) {
                this.reschedule();
            }
        }, this.keepalive);
    }
}
exports.default = PingTimer;
//# sourceMappingURL=PingTimer.js.map