"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = require("chai");
const helper_1 = require("../helper");
function simulateClientSettings(workspaceManager, settings) {
    workspaceManager.clientCapabilities.workspace = {
        configuration: true,
    };
    workspaceManager.connection.workspace.getConfiguration = function () {
        return Promise.resolve(settings);
    };
}
describe("get()", () => {
    describe("Merge settings from client", () => {
        describe("When client provides empty settings", () => {
            let context;
            let mergedSettings;
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                const workspaceManager = (0, helper_1.createTestWorkspaceManager)();
                simulateClientSettings(workspaceManager, {});
                context = workspaceManager.getContext("");
                mergedSettings = yield context.documentSettings.get("");
            }));
            it("should return default value for all settings", () => {
                (0, chai_1.expect)(mergedSettings).to.deep.equal(context.documentSettings.globalSettings);
            });
        });
        describe("When client provides partial settings", () => {
            let context;
            let mergedSettings;
            before(() => __awaiter(void 0, void 0, void 0, function* () {
                const workspaceManager = (0, helper_1.createTestWorkspaceManager)();
                simulateClientSettings(workspaceManager, {
                    validation: { lint: { enabled: false } },
                });
                context = workspaceManager.getContext("");
                mergedSettings = yield context.documentSettings.get("");
            }));
            it("should return setting from client when defined", () => {
                (0, chai_1.expect)(mergedSettings.validation.lint.enabled).to.equal(false);
            });
            it("should return default value otherwise", () => {
                (0, chai_1.expect)(mergedSettings.validation.lint.path).to.equal(context.documentSettings.globalSettings.validation.lint.path);
            });
        });
    });
});
//# sourceMappingURL=settingsManager.test.js.map