#!/usr/bin/env node
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/admin-console/commands/confirm.command.ts":
/*!*******************************************************!*\
  !*** ./src/admin-console/commands/confirm.command.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ConfirmCommand: () => (/* binding */ ConfirmCommand)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_admin_console_abstractions_organization_user_requests__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/admin-console/abstractions/organization-user/requests */ \"../../libs/common/src/admin-console/abstractions/organization-user/requests/index.ts\");\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../models/response */ \"./src/models/response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass ConfirmCommand {\n    constructor(apiService, cryptoService, organizationUserService) {\n        this.apiService = apiService;\n        this.cryptoService = cryptoService;\n        this.organizationUserService = organizationUserService;\n    }\n    run(object, id, cmdOptions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (id != null) {\n                id = id.toLowerCase();\n            }\n            const normalizedOptions = new Options(cmdOptions);\n            switch (object.toLowerCase()) {\n                case \"org-member\":\n                    return yield this.confirmOrganizationMember(id, normalizedOptions);\n                default:\n                    return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.badRequest(\"Unknown object.\");\n            }\n        });\n    }\n    confirmOrganizationMember(id, options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (options.organizationId == null || options.organizationId === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.badRequest(\"--organizationid <organizationid> required.\");\n            }\n            if (!_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.isGuid(id)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.badRequest(\"`\" + id + \"` is not a GUID.\");\n            }\n            if (!_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.isGuid(options.organizationId)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.badRequest(\"`\" + options.organizationId + \"` is not a GUID.\");\n            }\n            try {\n                const orgKey = yield this.cryptoService.getOrgKey(options.organizationId);\n                if (orgKey == null) {\n                    throw new Error(\"No encryption key for this organization.\");\n                }\n                const orgUser = yield this.organizationUserService.getOrganizationUser(options.organizationId, id);\n                if (orgUser == null) {\n                    throw new Error(\"Member id does not exist for this organization.\");\n                }\n                const publicKeyResponse = yield this.apiService.getUserPublicKey(orgUser.userId);\n                const publicKey = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.fromB64ToArray(publicKeyResponse.publicKey);\n                const key = yield this.cryptoService.rsaEncrypt(orgKey.key, publicKey);\n                const req = new _bitwarden_common_admin_console_abstractions_organization_user_requests__WEBPACK_IMPORTED_MODULE_0__.OrganizationUserConfirmRequest();\n                req.key = key.encryptedString;\n                yield this.organizationUserService.postOrganizationUserConfirm(options.organizationId, id, req);\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.success();\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.error(e);\n            }\n        });\n    }\n}\nclass Options {\n    constructor(passedOptions) {\n        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/admin-console/commands/confirm.command.ts\n");

/***/ }),

/***/ "./src/admin-console/commands/share.command.ts":
/*!*****************************************************!*\
  !*** ./src/admin-console/commands/share.command.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ShareCommand: () => (/* binding */ ShareCommand)\n/* harmony export */ });\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils */ \"./src/utils.ts\");\n/* harmony import */ var _vault_models_cipher_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../vault/models/cipher.response */ \"./src/vault/models/cipher.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass ShareCommand {\n    constructor(cipherService) {\n        this.cipherService = cipherService;\n    }\n    run(id, organizationId, requestJson) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (process.env.BW_SERVE !== \"true\" && (requestJson == null || requestJson === \"\")) {\n                requestJson = yield _utils__WEBPACK_IMPORTED_MODULE_1__.CliUtils.readStdin();\n            }\n            if (requestJson == null || requestJson === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.badRequest(\"`requestJson` was not provided.\");\n            }\n            let req = [];\n            if (typeof requestJson !== \"string\") {\n                req = requestJson;\n            }\n            else {\n                try {\n                    const reqJson = Buffer.from(requestJson, \"base64\").toString();\n                    req = JSON.parse(reqJson);\n                    if (req == null || req.length === 0) {\n                        return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.badRequest(\"You must provide at least one collection id for this item.\");\n                    }\n                }\n                catch (e) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.badRequest(\"Error parsing the encoded request data.\");\n                }\n            }\n            if (id != null) {\n                id = id.toLowerCase();\n            }\n            if (organizationId != null) {\n                organizationId = organizationId.toLowerCase();\n            }\n            const cipher = yield this.cipherService.get(id);\n            if (cipher == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.notFound();\n            }\n            if (cipher.organizationId != null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.badRequest(\"This item already belongs to an organization.\");\n            }\n            const cipherView = yield cipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(cipher));\n            try {\n                yield this.cipherService.shareWithServer(cipherView, organizationId, req);\n                const updatedCipher = yield this.cipherService.get(cipher.id);\n                const decCipher = yield updatedCipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(updatedCipher));\n                const res = new _vault_models_cipher_response__WEBPACK_IMPORTED_MODULE_2__.CipherResponse(decCipher);\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.error(e);\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/admin-console/commands/share.command.ts\n");

/***/ }),

/***/ "./src/admin-console/models/request/organization-collection.request.ts":
/*!*****************************************************************************!*\
  !*** ./src/admin-console/models/request/organization-collection.request.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OrganizationCollectionRequest: () => (/* binding */ OrganizationCollectionRequest)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_models_export_collection_export__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/models/export/collection.export */ \"../../libs/common/src/models/export/collection.export.ts\");\n/* harmony import */ var _selection_read_only__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../selection-read-only */ \"./src/admin-console/models/selection-read-only.ts\");\n\n\nclass OrganizationCollectionRequest extends _bitwarden_common_models_export_collection_export__WEBPACK_IMPORTED_MODULE_0__.CollectionExport {\n    static template() {\n        const req = new OrganizationCollectionRequest();\n        req.organizationId = \"00000000-0000-0000-0000-000000000000\";\n        req.name = \"Collection name\";\n        req.externalId = null;\n        req.groups = [_selection_read_only__WEBPACK_IMPORTED_MODULE_1__.SelectionReadOnly.template(), _selection_read_only__WEBPACK_IMPORTED_MODULE_1__.SelectionReadOnly.template()];\n        return req;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvYWRtaW4tY29uc29sZS9tb2RlbHMvcmVxdWVzdC9vcmdhbml6YXRpb24tY29sbGVjdGlvbi5yZXF1ZXN0LnRzIiwibWFwcGluZ3MiOiI7Ozs7OztBQUFxRjtBQUUxQjtBQUVwRCxNQUFNLDZCQUE4QixTQUFRLCtGQUFnQjtJQUNqRSxNQUFNLENBQUMsUUFBUTtRQUNiLE1BQU0sR0FBRyxHQUFHLElBQUksNkJBQTZCLEVBQUUsQ0FBQztRQUNoRCxHQUFHLENBQUMsY0FBYyxHQUFHLHNDQUFzQyxDQUFDO1FBQzVELEdBQUcsQ0FBQyxJQUFJLEdBQUcsaUJBQWlCLENBQUM7UUFDN0IsR0FBRyxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7UUFDdEIsR0FBRyxDQUFDLE1BQU0sR0FBRyxDQUFDLG1FQUFpQixDQUFDLFFBQVEsRUFBRSxFQUFFLG1FQUFpQixDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7UUFDMUUsT0FBTyxHQUFHLENBQUM7SUFDYixDQUFDO0NBR0YiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9AYml0d2FyZGVuL2NsaS8uL3NyYy9hZG1pbi1jb25zb2xlL21vZGVscy9yZXF1ZXN0L29yZ2FuaXphdGlvbi1jb2xsZWN0aW9uLnJlcXVlc3QudHM/MzMxOCJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb2xsZWN0aW9uRXhwb3J0IH0gZnJvbSBcIkBiaXR3YXJkZW4vY29tbW9uL21vZGVscy9leHBvcnQvY29sbGVjdGlvbi5leHBvcnRcIjtcblxuaW1wb3J0IHsgU2VsZWN0aW9uUmVhZE9ubHkgfSBmcm9tIFwiLi4vc2VsZWN0aW9uLXJlYWQtb25seVwiO1xuXG5leHBvcnQgY2xhc3MgT3JnYW5pemF0aW9uQ29sbGVjdGlvblJlcXVlc3QgZXh0ZW5kcyBDb2xsZWN0aW9uRXhwb3J0IHtcbiAgc3RhdGljIHRlbXBsYXRlKCk6IE9yZ2FuaXphdGlvbkNvbGxlY3Rpb25SZXF1ZXN0IHtcbiAgICBjb25zdCByZXEgPSBuZXcgT3JnYW5pemF0aW9uQ29sbGVjdGlvblJlcXVlc3QoKTtcbiAgICByZXEub3JnYW5pemF0aW9uSWQgPSBcIjAwMDAwMDAwLTAwMDAtMDAwMC0wMDAwLTAwMDAwMDAwMDAwMFwiO1xuICAgIHJlcS5uYW1lID0gXCJDb2xsZWN0aW9uIG5hbWVcIjtcbiAgICByZXEuZXh0ZXJuYWxJZCA9IG51bGw7XG4gICAgcmVxLmdyb3VwcyA9IFtTZWxlY3Rpb25SZWFkT25seS50ZW1wbGF0ZSgpLCBTZWxlY3Rpb25SZWFkT25seS50ZW1wbGF0ZSgpXTtcbiAgICByZXR1cm4gcmVxO1xuICB9XG5cbiAgZ3JvdXBzOiBTZWxlY3Rpb25SZWFkT25seVtdO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/admin-console/models/request/organization-collection.request.ts\n");

/***/ }),

/***/ "./src/admin-console/models/response/organization-collection.response.ts":
/*!*******************************************************************************!*\
  !*** ./src/admin-console/models/response/organization-collection.response.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OrganizationCollectionResponse: () => (/* binding */ OrganizationCollectionResponse)\n/* harmony export */ });\n/* harmony import */ var _vault_models_collection_response__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../vault/models/collection.response */ \"./src/vault/models/collection.response.ts\");\n\nclass OrganizationCollectionResponse extends _vault_models_collection_response__WEBPACK_IMPORTED_MODULE_0__.CollectionResponse {\n    constructor(o, groups) {\n        super(o);\n        this.object = \"org-collection\";\n        this.groups = groups;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvYWRtaW4tY29uc29sZS9tb2RlbHMvcmVzcG9uc2Uvb3JnYW5pemF0aW9uLWNvbGxlY3Rpb24ucmVzcG9uc2UudHMiLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFK0U7QUFHeEUsTUFBTSw4QkFBK0IsU0FBUSxpRkFBa0I7SUFHcEUsWUFBWSxDQUFpQixFQUFFLE1BQTJCO1FBQ3hELEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNULElBQUksQ0FBQyxNQUFNLEdBQUcsZ0JBQWdCLENBQUM7UUFDL0IsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7SUFDdkIsQ0FBQztDQUNGIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQGJpdHdhcmRlbi9jbGkvLi9zcmMvYWRtaW4tY29uc29sZS9tb2RlbHMvcmVzcG9uc2Uvb3JnYW5pemF0aW9uLWNvbGxlY3Rpb24ucmVzcG9uc2UudHM/YTQ3YiJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb2xsZWN0aW9uVmlldyB9IGZyb20gXCJAYml0d2FyZGVuL2NvbW1vbi92YXVsdC9tb2RlbHMvdmlldy9jb2xsZWN0aW9uLnZpZXdcIjtcblxuaW1wb3J0IHsgQ29sbGVjdGlvblJlc3BvbnNlIH0gZnJvbSBcIi4uLy4uLy4uL3ZhdWx0L21vZGVscy9jb2xsZWN0aW9uLnJlc3BvbnNlXCI7XG5pbXBvcnQgeyBTZWxlY3Rpb25SZWFkT25seSB9IGZyb20gXCIuLi9zZWxlY3Rpb24tcmVhZC1vbmx5XCI7XG5cbmV4cG9ydCBjbGFzcyBPcmdhbml6YXRpb25Db2xsZWN0aW9uUmVzcG9uc2UgZXh0ZW5kcyBDb2xsZWN0aW9uUmVzcG9uc2Uge1xuICBncm91cHM6IFNlbGVjdGlvblJlYWRPbmx5W107XG5cbiAgY29uc3RydWN0b3IobzogQ29sbGVjdGlvblZpZXcsIGdyb3VwczogU2VsZWN0aW9uUmVhZE9ubHlbXSkge1xuICAgIHN1cGVyKG8pO1xuICAgIHRoaXMub2JqZWN0ID0gXCJvcmctY29sbGVjdGlvblwiO1xuICAgIHRoaXMuZ3JvdXBzID0gZ3JvdXBzO1xuICB9XG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./src/admin-console/models/response/organization-collection.response.ts\n");

/***/ }),

/***/ "./src/admin-console/models/response/organization-user.response.ts":
/*!*************************************************************************!*\
  !*** ./src/admin-console/models/response/organization-user.response.ts ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OrganizationUserResponse: () => (/* binding */ OrganizationUserResponse)\n/* harmony export */ });\nclass OrganizationUserResponse {\n    constructor() {\n        this.object = \"org-member\";\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvYWRtaW4tY29uc29sZS9tb2RlbHMvcmVzcG9uc2Uvb3JnYW5pemF0aW9uLXVzZXIucmVzcG9uc2UudHMiLCJtYXBwaW5ncyI6Ijs7OztBQU9PLE1BQU0sd0JBQXdCO0lBU25DO1FBQ0UsSUFBSSxDQUFDLE1BQU0sR0FBRyxZQUFZLENBQUM7SUFDN0IsQ0FBQztDQUNGIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQGJpdHdhcmRlbi9jbGkvLi9zcmMvYWRtaW4tY29uc29sZS9tb2RlbHMvcmVzcG9uc2Uvb3JnYW5pemF0aW9uLXVzZXIucmVzcG9uc2UudHM/NmNiZSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBPcmdhbml6YXRpb25Vc2VyU3RhdHVzVHlwZSxcbiAgT3JnYW5pemF0aW9uVXNlclR5cGUsXG59IGZyb20gXCJAYml0d2FyZGVuL2NvbW1vbi9hZG1pbi1jb25zb2xlL2VudW1zXCI7XG5cbmltcG9ydCB7IEJhc2VSZXNwb25zZSB9IGZyb20gXCIuLi8uLi8uLi9tb2RlbHMvcmVzcG9uc2UvYmFzZS5yZXNwb25zZVwiO1xuXG5leHBvcnQgY2xhc3MgT3JnYW5pemF0aW9uVXNlclJlc3BvbnNlIGltcGxlbWVudHMgQmFzZVJlc3BvbnNlIHtcbiAgb2JqZWN0OiBzdHJpbmc7XG4gIGlkOiBzdHJpbmc7XG4gIGVtYWlsOiBzdHJpbmc7XG4gIG5hbWU6IHN0cmluZztcbiAgc3RhdHVzOiBPcmdhbml6YXRpb25Vc2VyU3RhdHVzVHlwZTtcbiAgdHlwZTogT3JnYW5pemF0aW9uVXNlclR5cGU7XG4gIHR3b0ZhY3RvckVuYWJsZWQ6IGJvb2xlYW47XG5cbiAgY29uc3RydWN0b3IoKSB7XG4gICAgdGhpcy5vYmplY3QgPSBcIm9yZy1tZW1iZXJcIjtcbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/admin-console/models/response/organization-user.response.ts\n");

/***/ }),

/***/ "./src/admin-console/models/response/organization.response.ts":
/*!********************************************************************!*\
  !*** ./src/admin-console/models/response/organization.response.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   OrganizationResponse: () => (/* binding */ OrganizationResponse)\n/* harmony export */ });\nclass OrganizationResponse {\n    constructor(o) {\n        this.object = \"organization\";\n        this.id = o.id;\n        this.name = o.name;\n        this.status = o.status;\n        this.type = o.type;\n        this.enabled = o.enabled;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvYWRtaW4tY29uc29sZS9tb2RlbHMvcmVzcG9uc2Uvb3JnYW5pemF0aW9uLnJlc3BvbnNlLnRzIiwibWFwcGluZ3MiOiI7Ozs7QUFRTyxNQUFNLG9CQUFvQjtJQVEvQixZQUFZLENBQWU7UUFDekIsSUFBSSxDQUFDLE1BQU0sR0FBRyxjQUFjLENBQUM7UUFDN0IsSUFBSSxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUMsRUFBRSxDQUFDO1FBQ2YsSUFBSSxDQUFDLElBQUksR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ25CLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLE1BQU0sQ0FBQztRQUN2QixJQUFJLENBQUMsSUFBSSxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDbkIsSUFBSSxDQUFDLE9BQU8sR0FBRyxDQUFDLENBQUMsT0FBTyxDQUFDO0lBQzNCLENBQUM7Q0FDRiIsInNvdXJjZXMiOlsid2VicGFjazovL0BiaXR3YXJkZW4vY2xpLy4vc3JjL2FkbWluLWNvbnNvbGUvbW9kZWxzL3Jlc3BvbnNlL29yZ2FuaXphdGlvbi5yZXNwb25zZS50cz9lZDk3Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIE9yZ2FuaXphdGlvblVzZXJTdGF0dXNUeXBlLFxuICBPcmdhbml6YXRpb25Vc2VyVHlwZSxcbn0gZnJvbSBcIkBiaXR3YXJkZW4vY29tbW9uL2FkbWluLWNvbnNvbGUvZW51bXNcIjtcbmltcG9ydCB7IE9yZ2FuaXphdGlvbiB9IGZyb20gXCJAYml0d2FyZGVuL2NvbW1vbi9hZG1pbi1jb25zb2xlL21vZGVscy9kb21haW4vb3JnYW5pemF0aW9uXCI7XG5cbmltcG9ydCB7IEJhc2VSZXNwb25zZSB9IGZyb20gXCIuLi8uLi8uLi9tb2RlbHMvcmVzcG9uc2UvYmFzZS5yZXNwb25zZVwiO1xuXG5leHBvcnQgY2xhc3MgT3JnYW5pemF0aW9uUmVzcG9uc2UgaW1wbGVtZW50cyBCYXNlUmVzcG9uc2Uge1xuICBvYmplY3Q6IHN0cmluZztcbiAgaWQ6IHN0cmluZztcbiAgbmFtZTogc3RyaW5nO1xuICBzdGF0dXM6IE9yZ2FuaXphdGlvblVzZXJTdGF0dXNUeXBlO1xuICB0eXBlOiBPcmdhbml6YXRpb25Vc2VyVHlwZTtcbiAgZW5hYmxlZDogYm9vbGVhbjtcblxuICBjb25zdHJ1Y3RvcihvOiBPcmdhbml6YXRpb24pIHtcbiAgICB0aGlzLm9iamVjdCA9IFwib3JnYW5pemF0aW9uXCI7XG4gICAgdGhpcy5pZCA9IG8uaWQ7XG4gICAgdGhpcy5uYW1lID0gby5uYW1lO1xuICAgIHRoaXMuc3RhdHVzID0gby5zdGF0dXM7XG4gICAgdGhpcy50eXBlID0gby50eXBlO1xuICAgIHRoaXMuZW5hYmxlZCA9IG8uZW5hYmxlZDtcbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/admin-console/models/response/organization.response.ts\n");

/***/ }),

/***/ "./src/admin-console/models/selection-read-only.ts":
/*!*********************************************************!*\
  !*** ./src/admin-console/models/selection-read-only.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SelectionReadOnly: () => (/* binding */ SelectionReadOnly)\n/* harmony export */ });\nclass SelectionReadOnly {\n    static template() {\n        return new SelectionReadOnly(\"00000000-0000-0000-0000-000000000000\", false, false, false);\n    }\n    constructor(id, readOnly, hidePasswords, manage) {\n        this.id = id;\n        this.readOnly = readOnly;\n        this.hidePasswords = hidePasswords || false;\n        this.manage = manage;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvYWRtaW4tY29uc29sZS9tb2RlbHMvc2VsZWN0aW9uLXJlYWQtb25seS50cyIsIm1hcHBpbmdzIjoiOzs7O0FBQU8sTUFBTSxpQkFBaUI7SUFDNUIsTUFBTSxDQUFDLFFBQVE7UUFDYixPQUFPLElBQUksaUJBQWlCLENBQUMsc0NBQXNDLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRSxLQUFLLENBQUMsQ0FBQztJQUM1RixDQUFDO0lBT0QsWUFBWSxFQUFVLEVBQUUsUUFBaUIsRUFBRSxhQUFzQixFQUFFLE1BQWU7UUFDaEYsSUFBSSxDQUFDLEVBQUUsR0FBRyxFQUFFLENBQUM7UUFDYixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztRQUN6QixJQUFJLENBQUMsYUFBYSxHQUFHLGFBQWEsSUFBSSxLQUFLLENBQUM7UUFDNUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7SUFDdkIsQ0FBQztDQUNGIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQGJpdHdhcmRlbi9jbGkvLi9zcmMvYWRtaW4tY29uc29sZS9tb2RlbHMvc2VsZWN0aW9uLXJlYWQtb25seS50cz82NTRmIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBjbGFzcyBTZWxlY3Rpb25SZWFkT25seSB7XG4gIHN0YXRpYyB0ZW1wbGF0ZSgpOiBTZWxlY3Rpb25SZWFkT25seSB7XG4gICAgcmV0dXJuIG5ldyBTZWxlY3Rpb25SZWFkT25seShcIjAwMDAwMDAwLTAwMDAtMDAwMC0wMDAwLTAwMDAwMDAwMDAwMFwiLCBmYWxzZSwgZmFsc2UsIGZhbHNlKTtcbiAgfVxuXG4gIGlkOiBzdHJpbmc7XG4gIHJlYWRPbmx5OiBib29sZWFuO1xuICBoaWRlUGFzc3dvcmRzOiBib29sZWFuO1xuICBtYW5hZ2U6IGJvb2xlYW47XG5cbiAgY29uc3RydWN0b3IoaWQ6IHN0cmluZywgcmVhZE9ubHk6IGJvb2xlYW4sIGhpZGVQYXNzd29yZHM6IGJvb2xlYW4sIG1hbmFnZTogYm9vbGVhbikge1xuICAgIHRoaXMuaWQgPSBpZDtcbiAgICB0aGlzLnJlYWRPbmx5ID0gcmVhZE9ubHk7XG4gICAgdGhpcy5oaWRlUGFzc3dvcmRzID0gaGlkZVBhc3N3b3JkcyB8fCBmYWxzZTtcbiAgICB0aGlzLm1hbmFnZSA9IG1hbmFnZTtcbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/admin-console/models/selection-read-only.ts\n");

/***/ }),

/***/ "./src/auth/commands/lock.command.ts":
/*!*******************************************!*\
  !*** ./src/auth/commands/lock.command.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LockCommand: () => (/* binding */ LockCommand)\n/* harmony export */ });\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/response/message.response */ \"./src/models/response/message.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass LockCommand {\n    constructor(vaultTimeoutService) {\n        this.vaultTimeoutService = vaultTimeoutService;\n    }\n    run() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.vaultTimeoutService.lock();\n            process.env.BW_SESSION = null;\n            const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_1__.MessageResponse(\"Your vault is locked.\", null);\n            return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.success(res);\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvYXV0aC9jb21tYW5kcy9sb2NrLmNvbW1hbmQudHMiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7O0FBRWlEO0FBQ3dCO0FBRWxFLE1BQU0sV0FBVztJQUN0QixZQUFvQixtQkFBd0M7UUFBeEMsd0JBQW1CLEdBQW5CLG1CQUFtQixDQUFxQjtJQUFHLENBQUM7SUFFMUQsR0FBRzs7WUFDUCxNQUFNLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUN0QyxPQUFPLENBQUMsR0FBRyxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7WUFDOUIsTUFBTSxHQUFHLEdBQUcsSUFBSSw4RUFBZSxDQUFDLHVCQUF1QixFQUFFLElBQUksQ0FBQyxDQUFDO1lBQy9ELE9BQU8sc0RBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDL0IsQ0FBQztLQUFBO0NBQ0YiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9AYml0d2FyZGVuL2NsaS8uL3NyYy9hdXRoL2NvbW1hbmRzL2xvY2suY29tbWFuZC50cz80ZmQ0Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFZhdWx0VGltZW91dFNlcnZpY2UgfSBmcm9tIFwiQGJpdHdhcmRlbi9jb21tb24vYWJzdHJhY3Rpb25zL3ZhdWx0LXRpbWVvdXQvdmF1bHQtdGltZW91dC5zZXJ2aWNlXCI7XG5cbmltcG9ydCB7IFJlc3BvbnNlIH0gZnJvbSBcIi4uLy4uL21vZGVscy9yZXNwb25zZVwiO1xuaW1wb3J0IHsgTWVzc2FnZVJlc3BvbnNlIH0gZnJvbSBcIi4uLy4uL21vZGVscy9yZXNwb25zZS9tZXNzYWdlLnJlc3BvbnNlXCI7XG5cbmV4cG9ydCBjbGFzcyBMb2NrQ29tbWFuZCB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgdmF1bHRUaW1lb3V0U2VydmljZTogVmF1bHRUaW1lb3V0U2VydmljZSkge31cblxuICBhc3luYyBydW4oKSB7XG4gICAgYXdhaXQgdGhpcy52YXVsdFRpbWVvdXRTZXJ2aWNlLmxvY2soKTtcbiAgICBwcm9jZXNzLmVudi5CV19TRVNTSU9OID0gbnVsbDtcbiAgICBjb25zdCByZXMgPSBuZXcgTWVzc2FnZVJlc3BvbnNlKFwiWW91ciB2YXVsdCBpcyBsb2NrZWQuXCIsIG51bGwpO1xuICAgIHJldHVybiBSZXNwb25zZS5zdWNjZXNzKHJlcyk7XG4gIH1cbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./src/auth/commands/lock.command.ts\n");

/***/ }),

/***/ "./src/auth/commands/login.command.ts":
/*!********************************************!*\
  !*** ./src/auth/commands/login.command.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LoginCommand: () => (/* binding */ LoginCommand)\n/* harmony export */ });\n/* harmony import */ var http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! http */ \"http\");\n/* harmony import */ var http__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(http__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! inquirer */ \"inquirer\");\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(inquirer__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/auth/common */ \"../../libs/auth/src/common/index.ts\");\n/* harmony import */ var _bitwarden_common_auth_enums_two_factor_provider_type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @bitwarden/common/auth/enums/two-factor-provider-type */ \"../../libs/common/src/auth/enums/two-factor-provider-type.ts\");\n/* harmony import */ var _bitwarden_common_auth_models_domain_force_set_password_reason__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @bitwarden/common/auth/models/domain/force-set-password-reason */ \"../../libs/common/src/auth/models/domain/force-set-password-reason.ts\");\n/* harmony import */ var _bitwarden_common_auth_models_request_identity_token_token_two_factor_request__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @bitwarden/common/auth/models/request/identity-token/token-two-factor.request */ \"../../libs/common/src/auth/models/request/identity-token/token-two-factor.request.ts\");\n/* harmony import */ var _bitwarden_common_auth_models_request_password_request__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @bitwarden/common/auth/models/request/password.request */ \"../../libs/common/src/auth/models/request/password.request.ts\");\n/* harmony import */ var _bitwarden_common_auth_models_request_two_factor_email_request__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @bitwarden/common/auth/models/request/two-factor-email.request */ \"../../libs/common/src/auth/models/request/two-factor-email.request.ts\");\n/* harmony import */ var _bitwarden_common_auth_models_request_update_temp_password_request__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @bitwarden/common/auth/models/request/update-temp-password.request */ \"../../libs/common/src/auth/models/request/update-temp-password.request.ts\");\n/* harmony import */ var _bitwarden_common_models_response_error_response__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @bitwarden/common/models/response/error.response */ \"../../libs/common/src/models/response/error.response.ts\");\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_node_node_utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @bitwarden/node/node-utils */ \"../../libs/node/src/node-utils.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../models/response/message.response */ \"./src/models/response/message.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass LoginCommand {\n    constructor(loginStrategyService, authService, apiService, cryptoFunctionService, environmentService, passwordGenerationService, passwordStrengthService, platformUtilsService, accountService, cryptoService, policyService, twoFactorService, syncService, keyConnectorService, policyApiService, orgService, logoutCallback, kdfConfigService) {\n        this.loginStrategyService = loginStrategyService;\n        this.authService = authService;\n        this.apiService = apiService;\n        this.cryptoFunctionService = cryptoFunctionService;\n        this.environmentService = environmentService;\n        this.passwordGenerationService = passwordGenerationService;\n        this.passwordStrengthService = passwordStrengthService;\n        this.platformUtilsService = platformUtilsService;\n        this.accountService = accountService;\n        this.cryptoService = cryptoService;\n        this.policyService = policyService;\n        this.twoFactorService = twoFactorService;\n        this.syncService = syncService;\n        this.keyConnectorService = keyConnectorService;\n        this.policyApiService = policyApiService;\n        this.orgService = orgService;\n        this.logoutCallback = logoutCallback;\n        this.kdfConfigService = kdfConfigService;\n        this.ssoRedirectUri = null;\n    }\n    run(email, password, options) {\n        var _a;\n        return __awaiter(this, void 0, void 0, function* () {\n            this.options = options;\n            this.email = email;\n            this.canInteract = process.env.BW_NOINTERACTION !== \"true\";\n            let ssoCodeVerifier = null;\n            let ssoCode = null;\n            let orgIdentifier = null;\n            let clientId = null;\n            let clientSecret = null;\n            let selectedProvider = null;\n            if (options.apikey != null) {\n                const apiIdentifiers = yield this.apiIdentifiers();\n                clientId = apiIdentifiers.clientId;\n                clientSecret = apiIdentifiers.clientSecret;\n                if (clientId == null || clientId.trim() === \"\") {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"client_id is required.\");\n                }\n                if (clientSecret == null || clientSecret === \"\") {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"client_secret is required.\");\n                }\n            }\n            else if (options.sso != null && this.canInteract) {\n                const passwordOptions = {\n                    type: \"password\",\n                    length: 64,\n                    uppercase: true,\n                    lowercase: true,\n                    numbers: true,\n                    special: false,\n                };\n                const state = yield this.passwordGenerationService.generatePassword(passwordOptions);\n                ssoCodeVerifier = yield this.passwordGenerationService.generatePassword(passwordOptions);\n                const codeVerifierHash = yield this.cryptoFunctionService.hash(ssoCodeVerifier, \"sha256\");\n                const codeChallenge = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_11__.Utils.fromBufferToUrlB64(codeVerifierHash);\n                try {\n                    const ssoParams = yield this.openSsoPrompt(codeChallenge, state);\n                    ssoCode = ssoParams.ssoCode;\n                    orgIdentifier = ssoParams.orgIdentifier;\n                }\n                catch (_b) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"Something went wrong. Try again.\");\n                }\n            }\n            else {\n                if ((email == null || email === \"\") && this.canInteract) {\n                    const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_1__.createPromptModule({\n                        output: process.stderr,\n                    })({\n                        type: \"input\",\n                        name: \"email\",\n                        message: \"Email address:\",\n                    });\n                    email = answer.email;\n                }\n                if (email == null || email.trim() === \"\") {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"Email address is required.\");\n                }\n                if (email.indexOf(\"@\") === -1) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"Email address is invalid.\");\n                }\n                this.email = email;\n                if (password == null || password === \"\") {\n                    if (options.passwordfile) {\n                        password = yield _bitwarden_node_node_utils__WEBPACK_IMPORTED_MODULE_12__.NodeUtils.readFirstLine(options.passwordfile);\n                    }\n                    else if (options.passwordenv && process.env[options.passwordenv]) {\n                        password = process.env[options.passwordenv];\n                    }\n                    else if (this.canInteract) {\n                        const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_1__.createPromptModule({\n                            output: process.stderr,\n                        })({\n                            type: \"password\",\n                            name: \"password\",\n                            message: \"Master password:\",\n                        });\n                        password = answer.password;\n                    }\n                }\n                if (password == null || password === \"\") {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"Master password is required.\");\n                }\n            }\n            let twoFactorToken = options.code;\n            let twoFactorMethod = null;\n            try {\n                if (options.method != null) {\n                    twoFactorMethod = parseInt(options.method, null);\n                }\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(\"Invalid two-step login method.\");\n            }\n            const twoFactor = twoFactorToken == null\n                ? null\n                : new _bitwarden_common_auth_models_request_identity_token_token_two_factor_request__WEBPACK_IMPORTED_MODULE_6__.TokenTwoFactorRequest(twoFactorMethod, twoFactorToken, false);\n            try {\n                yield this.validatedParams();\n                let response = null;\n                if (clientId != null && clientSecret != null) {\n                    if (!clientId.startsWith(\"user\")) {\n                        return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(\"Invalid API Key; Organization API Key currently not supported\");\n                    }\n                    try {\n                        response = yield this.loginStrategyService.logIn(new _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_3__.UserApiLoginCredentials(clientId, clientSecret));\n                    }\n                    catch (e) {\n                        // handle API key login failures\n                        // Handle invalid client error as server doesn't return a useful message\n                        if (((_a = e === null || e === void 0 ? void 0 : e.response) === null || _a === void 0 ? void 0 : _a.error) &&\n                            typeof e.response.error === \"string\" &&\n                            e.response.error === \"invalid_client\") {\n                            return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"client_id or client_secret is incorrect. Try again.\");\n                        }\n                        // Pass error up to be handled by the outer catch block below\n                        throw e;\n                    }\n                }\n                else if (ssoCode != null && ssoCodeVerifier != null) {\n                    response = yield this.loginStrategyService.logIn(new _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_3__.SsoLoginCredentials(ssoCode, ssoCodeVerifier, this.ssoRedirectUri, orgIdentifier, undefined, // email to look up 2FA token not required as CLI can't remember 2FA token\n                    twoFactor));\n                }\n                else {\n                    response = yield this.loginStrategyService.logIn(new _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_3__.PasswordLoginCredentials(email, password, null, twoFactor));\n                }\n                if (response.requiresEncryptionKeyMigration) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(\"Encryption key migration required. Please login through the web vault to update your encryption key.\");\n                }\n                if (response.captchaSiteKey) {\n                    const credentials = new _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_3__.PasswordLoginCredentials(email, password);\n                    const handledResponse = yield this.handleCaptchaRequired(twoFactor, credentials);\n                    // Error Response\n                    if (handledResponse instanceof _models_response__WEBPACK_IMPORTED_MODULE_13__.Response) {\n                        return handledResponse;\n                    }\n                    else {\n                        response = handledResponse;\n                    }\n                }\n                if (response.requiresTwoFactor) {\n                    const twoFactorProviders = yield this.twoFactorService.getSupportedProviders(null);\n                    if (twoFactorProviders.length === 0) {\n                        return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"No providers available for this client.\");\n                    }\n                    if (twoFactorMethod != null) {\n                        try {\n                            selectedProvider = twoFactorProviders.filter((p) => p.type === twoFactorMethod)[0];\n                        }\n                        catch (e) {\n                            return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(\"Invalid two-step login method.\");\n                        }\n                    }\n                    if (selectedProvider == null) {\n                        if (twoFactorProviders.length === 1) {\n                            selectedProvider = twoFactorProviders[0];\n                        }\n                        else if (this.canInteract) {\n                            const twoFactorOptions = twoFactorProviders.map((p) => p.name);\n                            twoFactorOptions.push(new inquirer__WEBPACK_IMPORTED_MODULE_1__.Separator());\n                            twoFactorOptions.push(\"Cancel\");\n                            const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_1__.createPromptModule({\n                                output: process.stderr,\n                            })({\n                                type: \"list\",\n                                name: \"method\",\n                                message: \"Two-step login method:\",\n                                choices: twoFactorOptions,\n                            });\n                            const i = twoFactorOptions.indexOf(answer.method);\n                            if (i === twoFactorOptions.length - 1) {\n                                return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(\"Login failed.\");\n                            }\n                            selectedProvider = twoFactorProviders[i];\n                        }\n                        if (selectedProvider == null) {\n                            return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(\"Login failed. No provider selected.\");\n                        }\n                    }\n                    if (twoFactorToken == null &&\n                        Object.keys(response.twoFactorProviders).length > 1 &&\n                        selectedProvider.type === _bitwarden_common_auth_enums_two_factor_provider_type__WEBPACK_IMPORTED_MODULE_4__.TwoFactorProviderType.Email) {\n                        const emailReq = new _bitwarden_common_auth_models_request_two_factor_email_request__WEBPACK_IMPORTED_MODULE_8__.TwoFactorEmailRequest();\n                        emailReq.email = yield this.loginStrategyService.getEmail();\n                        emailReq.masterPasswordHash = yield this.loginStrategyService.getMasterPasswordHash();\n                        yield this.apiService.postTwoFactorEmail(emailReq);\n                    }\n                    if (twoFactorToken == null) {\n                        if (this.canInteract) {\n                            const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_1__.createPromptModule({\n                                output: process.stderr,\n                            })({\n                                type: \"input\",\n                                name: \"token\",\n                                message: \"Two-step login code:\",\n                            });\n                            twoFactorToken = answer.token;\n                        }\n                        if (twoFactorToken == null || twoFactorToken === \"\") {\n                            return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"Code is required.\");\n                        }\n                    }\n                    response = yield this.loginStrategyService.logInTwoFactor(new _bitwarden_common_auth_models_request_identity_token_token_two_factor_request__WEBPACK_IMPORTED_MODULE_6__.TokenTwoFactorRequest(selectedProvider.type, twoFactorToken), null);\n                }\n                if (response.captchaSiteKey) {\n                    const twoFactorRequest = new _bitwarden_common_auth_models_request_identity_token_token_two_factor_request__WEBPACK_IMPORTED_MODULE_6__.TokenTwoFactorRequest(selectedProvider.type, twoFactorToken);\n                    const handledResponse = yield this.handleCaptchaRequired(twoFactorRequest);\n                    // Error Response\n                    if (handledResponse instanceof _models_response__WEBPACK_IMPORTED_MODULE_13__.Response) {\n                        return handledResponse;\n                    }\n                    else {\n                        response = handledResponse;\n                    }\n                }\n                if (response.requiresTwoFactor) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(\"Login failed.\");\n                }\n                if (response.resetMasterPassword) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(\"In order to log in with SSO from the CLI, you must first log in\" +\n                        \" through the web vault to set your master password.\");\n                }\n                // Run full sync before handling success response or password reset flows (to get Master Password Policies)\n                yield this.syncService.fullSync(true);\n                // Handle updating passwords if NOT using an API Key for authentication\n                if (response.forcePasswordReset != _bitwarden_common_auth_models_domain_force_set_password_reason__WEBPACK_IMPORTED_MODULE_5__.ForceSetPasswordReason.None &&\n                    clientId == null &&\n                    clientSecret == null) {\n                    if (response.forcePasswordReset === _bitwarden_common_auth_models_domain_force_set_password_reason__WEBPACK_IMPORTED_MODULE_5__.ForceSetPasswordReason.AdminForcePasswordReset) {\n                        return yield this.updateTempPassword();\n                    }\n                    else if (response.forcePasswordReset === _bitwarden_common_auth_models_domain_force_set_password_reason__WEBPACK_IMPORTED_MODULE_5__.ForceSetPasswordReason.WeakMasterPassword) {\n                        return yield this.updateWeakPassword(password);\n                    }\n                }\n                return yield this.handleSuccessResponse();\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(e);\n            }\n        });\n    }\n    validatedParams() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const key = yield this.cryptoFunctionService.randomBytes(64);\n            process.env.BW_SESSION = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_11__.Utils.fromBufferToB64(key);\n        });\n    }\n    handleSuccessResponse() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const usesKeyConnector = yield this.keyConnectorService.getUsesKeyConnector();\n            if ((this.options.sso != null || this.options.apikey != null) &&\n                this.canInteract &&\n                !usesKeyConnector) {\n                const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_14__.MessageResponse(\"You are logged in!\", \"\\n\" + \"To unlock your vault, use the `unlock` command. ex:\\n\" + \"$ bw unlock\");\n                return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.success(res);\n            }\n            const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_14__.MessageResponse(\"You are logged in!\", \"\\n\" +\n                \"To unlock your vault, set your session key to the `BW_SESSION` environment variable. ex:\\n\" +\n                '$ export BW_SESSION=\"' +\n                process.env.BW_SESSION +\n                '\"\\n' +\n                '> $env:BW_SESSION=\"' +\n                process.env.BW_SESSION +\n                '\"\\n\\n' +\n                \"You can also pass the session key to any command with the `--session` option. ex:\\n\" +\n                \"$ bw list items --session \" +\n                process.env.BW_SESSION);\n            res.raw = process.env.BW_SESSION;\n            return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.success(res);\n        });\n    }\n    handleUpdatePasswordSuccessResponse() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.logoutCallback();\n            this.authService.logOut(() => {\n                /* Do nothing */\n            });\n            const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_14__.MessageResponse(\"Your master password has been updated!\", \"\\n\" + \"You have been logged out and must log in again to access the vault.\");\n            return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.success(res);\n        });\n    }\n    updateWeakPassword(currentPassword) {\n        return __awaiter(this, void 0, void 0, function* () {\n            // If no interaction available, alert user to use web vault\n            if (!this.canInteract) {\n                yield this.logoutCallback();\n                this.authService.logOut(() => {\n                    /* Do nothing */\n                });\n                return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(new _models_response_message_response__WEBPACK_IMPORTED_MODULE_14__.MessageResponse(\"Your master password does not meet one or more of your organization policies. In order to access the vault, you must update your master password now via the web vault. You have been logged out.\", null));\n            }\n            try {\n                const { newPasswordHash, newUserKey, hint } = yield this.collectNewMasterPasswordDetails(\"Your master password does not meet one or more of your organization policies. In order to access the vault, you must update your master password now.\");\n                const request = new _bitwarden_common_auth_models_request_password_request__WEBPACK_IMPORTED_MODULE_7__.PasswordRequest();\n                request.masterPasswordHash = yield this.cryptoService.hashMasterKey(currentPassword, null);\n                request.masterPasswordHint = hint;\n                request.newMasterPasswordHash = newPasswordHash;\n                request.key = newUserKey[1].encryptedString;\n                yield this.apiService.postPassword(request);\n                return yield this.handleUpdatePasswordSuccessResponse();\n            }\n            catch (e) {\n                yield this.logoutCallback();\n                this.authService.logOut(() => {\n                    /* Do nothing */\n                });\n                return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(e);\n            }\n        });\n    }\n    updateTempPassword() {\n        return __awaiter(this, void 0, void 0, function* () {\n            // If no interaction available, alert user to use web vault\n            if (!this.canInteract) {\n                yield this.logoutCallback();\n                this.authService.logOut(() => {\n                    /* Do nothing */\n                });\n                return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(new _models_response_message_response__WEBPACK_IMPORTED_MODULE_14__.MessageResponse(\"An organization administrator recently changed your master password. In order to access the vault, you must update your master password now via the web vault. You have been logged out.\", null));\n            }\n            try {\n                const { newPasswordHash, newUserKey, hint } = yield this.collectNewMasterPasswordDetails(\"An organization administrator recently changed your master password. In order to access the vault, you must update your master password now.\");\n                const request = new _bitwarden_common_auth_models_request_update_temp_password_request__WEBPACK_IMPORTED_MODULE_9__.UpdateTempPasswordRequest();\n                request.key = newUserKey[1].encryptedString;\n                request.newMasterPasswordHash = newPasswordHash;\n                request.masterPasswordHint = hint;\n                yield this.apiService.putUpdateTempPassword(request);\n                return yield this.handleUpdatePasswordSuccessResponse();\n            }\n            catch (e) {\n                yield this.logoutCallback();\n                this.authService.logOut(() => {\n                    /* Do nothing */\n                });\n                return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(e);\n            }\n        });\n    }\n    /**\n     * Collect new master password and hint from the CLI. The collected password\n     * is validated against any applicable master password policies, a new master\n     * key is generated, and we use it to re-encrypt the user key\n     * @param prompt - Message that is displayed during the initial prompt\n     * @param error\n     */\n    collectNewMasterPasswordDetails(prompt, error) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.email == null || this.email === \"undefined\") {\n                this.email = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_2__.firstValueFrom)(this.accountService.activeAccount$.pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_2__.map)((a) => a === null || a === void 0 ? void 0 : a.email)));\n            }\n            // Get New Master Password\n            const baseMessage = `${prompt}\\n` + \"Master password: \";\n            const firstMessage = error != null ? error + baseMessage : baseMessage;\n            const mp = yield inquirer__WEBPACK_IMPORTED_MODULE_1__.createPromptModule({ output: process.stderr })({\n                type: \"password\",\n                name: \"password\",\n                message: firstMessage,\n            });\n            const masterPassword = mp.password;\n            // Master Password Validation\n            if (masterPassword == null || masterPassword === \"\") {\n                return this.collectNewMasterPasswordDetails(prompt, \"Master password is required.\\n\");\n            }\n            if (masterPassword.length < _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_11__.Utils.minimumPasswordLength) {\n                return this.collectNewMasterPasswordDetails(prompt, `Master password must be at least ${_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_11__.Utils.minimumPasswordLength} characters long.\\n`);\n            }\n            // Strength & Policy Validation\n            const strengthResult = this.passwordStrengthService.getPasswordStrength(masterPassword, this.email);\n            const enforcedPolicyOptions = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_2__.firstValueFrom)(this.policyService.masterPasswordPolicyOptions$());\n            // Verify master password meets policy requirements\n            if (enforcedPolicyOptions != null &&\n                !this.policyService.evaluateMasterPassword(strengthResult.score, masterPassword, enforcedPolicyOptions)) {\n                return this.collectNewMasterPasswordDetails(prompt, \"Your new master password does not meet the policy requirements.\\n\");\n            }\n            // Get New Master Password Re-type\n            const reTypeMessage = \"Re-type New Master password (Strength: \" + strengthResult.score + \")\";\n            const retype = yield inquirer__WEBPACK_IMPORTED_MODULE_1__.createPromptModule({ output: process.stderr })({\n                type: \"password\",\n                name: \"password\",\n                message: reTypeMessage,\n            });\n            const masterPasswordRetype = retype.password;\n            // Re-type Validation\n            if (masterPassword !== masterPasswordRetype) {\n                return this.collectNewMasterPasswordDetails(prompt, \"Master password confirmation does not match.\\n\");\n            }\n            // Get Hint (optional)\n            const hint = yield inquirer__WEBPACK_IMPORTED_MODULE_1__.createPromptModule({ output: process.stderr })({\n                type: \"input\",\n                name: \"input\",\n                message: \"Master Password Hint (optional):\",\n            });\n            const masterPasswordHint = hint.input;\n            const kdfConfig = yield this.kdfConfigService.getKdfConfig();\n            // Create new key and hash new password\n            const newMasterKey = yield this.cryptoService.makeMasterKey(masterPassword, this.email.trim().toLowerCase(), kdfConfig);\n            const newPasswordHash = yield this.cryptoService.hashMasterKey(masterPassword, newMasterKey);\n            // Grab user key\n            const userKey = yield this.cryptoService.getUserKey();\n            if (!userKey) {\n                throw new Error(\"User key not found.\");\n            }\n            // Re-encrypt user key with new master key\n            const newUserKey = yield this.cryptoService.encryptUserKeyWithMasterKey(newMasterKey, userKey);\n            return { newPasswordHash, newUserKey: newUserKey, hint: masterPasswordHint };\n        });\n    }\n    handleCaptchaRequired(twoFactorRequest, credentials = null) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const badCaptcha = _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.badRequest(\"Your authentication request has been flagged and will require user interaction to proceed.\\n\" +\n                \"Please use your API key to validate this request and ensure BW_CLIENTSECRET is correct, if set.\\n\" +\n                \"(https://bitwarden.com/help/cli-auth-challenges)\");\n            try {\n                const captchaClientSecret = yield this.apiClientSecret(true);\n                if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_11__.Utils.isNullOrWhitespace(captchaClientSecret)) {\n                    return badCaptcha;\n                }\n                let authResultResponse = null;\n                if (credentials != null) {\n                    credentials.captchaToken = captchaClientSecret;\n                    credentials.twoFactor = twoFactorRequest;\n                    authResultResponse = yield this.loginStrategyService.logIn(credentials);\n                }\n                else {\n                    authResultResponse = yield this.loginStrategyService.logInTwoFactor(twoFactorRequest, captchaClientSecret);\n                }\n                return authResultResponse;\n            }\n            catch (e) {\n                if (e instanceof _bitwarden_common_models_response_error_response__WEBPACK_IMPORTED_MODULE_10__.ErrorResponse ||\n                    (e.constructor.name === _bitwarden_common_models_response_error_response__WEBPACK_IMPORTED_MODULE_10__.ErrorResponse.name &&\n                        e.message.includes(\"Captcha is invalid\"))) {\n                    return badCaptcha;\n                }\n                else {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_13__.Response.error(e);\n                }\n            }\n        });\n    }\n    apiClientId() {\n        return __awaiter(this, void 0, void 0, function* () {\n            let clientId = null;\n            const storedClientId = process.env.BW_CLIENTID;\n            if (storedClientId == null) {\n                if (this.canInteract) {\n                    const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_1__.createPromptModule({\n                        output: process.stderr,\n                    })({\n                        type: \"input\",\n                        name: \"clientId\",\n                        message: \"client_id:\",\n                    });\n                    clientId = answer.clientId;\n                }\n                else {\n                    clientId = null;\n                }\n            }\n            else {\n                clientId = storedClientId;\n            }\n            return clientId;\n        });\n    }\n    apiClientSecret(isAdditionalAuthentication = false) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const additionalAuthenticationMessage = \"Additional authentication required.\\nAPI key \";\n            let clientSecret = null;\n            const storedClientSecret = this.clientSecret || process.env.BW_CLIENTSECRET;\n            if (storedClientSecret == null) {\n                if (this.canInteract) {\n                    const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_1__.createPromptModule({\n                        output: process.stderr,\n                    })({\n                        type: \"input\",\n                        name: \"clientSecret\",\n                        message: (isAdditionalAuthentication ? additionalAuthenticationMessage : \"\") + \"client_secret:\",\n                    });\n                    clientSecret = answer.clientSecret;\n                }\n                else {\n                    clientSecret = null;\n                }\n            }\n            else {\n                clientSecret = storedClientSecret;\n            }\n            return clientSecret;\n        });\n    }\n    apiIdentifiers() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return {\n                clientId: yield this.apiClientId(),\n                clientSecret: yield this.apiClientSecret(),\n            };\n        });\n    }\n    openSsoPrompt(codeChallenge, state) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const env = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_2__.firstValueFrom)(this.environmentService.environment$);\n            return new Promise((resolve, reject) => {\n                const callbackServer = http__WEBPACK_IMPORTED_MODULE_0__.createServer((req, res) => {\n                    const urlString = \"http://localhost\" + req.url;\n                    const url = new URL(urlString);\n                    const code = url.searchParams.get(\"code\");\n                    const receivedState = url.searchParams.get(\"state\");\n                    const orgIdentifier = this.getOrgIdentifierFromState(receivedState);\n                    res.setHeader(\"Content-Type\", \"text/html\");\n                    if (code != null && receivedState != null && this.checkState(receivedState, state)) {\n                        res.writeHead(200);\n                        res.end(\"<html><head><title>Success | Bitwarden CLI</title></head><body>\" +\n                            \"<h1>Successfully authenticated with the Bitwarden CLI</h1>\" +\n                            \"<p>You may now close this tab and return to the terminal.</p>\" +\n                            \"</body></html>\");\n                        callbackServer.close(() => resolve({\n                            ssoCode: code,\n                            orgIdentifier: orgIdentifier,\n                        }));\n                    }\n                    else {\n                        res.writeHead(400);\n                        res.end(\"<html><head><title>Failed | Bitwarden CLI</title></head><body>\" +\n                            \"<h1>Something went wrong logging into the Bitwarden CLI</h1>\" +\n                            \"<p>You may now close this tab and return to the terminal.</p>\" +\n                            \"</body></html>\");\n                        callbackServer.close(() => reject());\n                    }\n                });\n                let foundPort = false;\n                const webUrl = env.getWebVaultUrl();\n                for (let port = 8065; port <= 8070; port++) {\n                    try {\n                        this.ssoRedirectUri = \"http://localhost:\" + port;\n                        callbackServer.listen(port, () => {\n                            this.platformUtilsService.launchUri(webUrl +\n                                \"/#/sso?clientId=\" +\n                                \"cli\" +\n                                \"&redirectUri=\" +\n                                encodeURIComponent(this.ssoRedirectUri) +\n                                \"&state=\" +\n                                state +\n                                \"&codeChallenge=\" +\n                                codeChallenge);\n                        });\n                        foundPort = true;\n                        break;\n                    }\n                    catch (_a) {\n                        // Ignore error since we run the same command up to 5 times.\n                    }\n                }\n                if (!foundPort) {\n                    reject();\n                }\n            });\n        });\n    }\n    getOrgIdentifierFromState(state) {\n        if (state === null || state === undefined) {\n            return null;\n        }\n        const stateSplit = state.split(\"_identifier=\");\n        return stateSplit.length > 1 ? stateSplit[1] : null;\n    }\n    checkState(state, checkState) {\n        if (state === null || state === undefined) {\n            return false;\n        }\n        if (checkState === null || checkState === undefined) {\n            return false;\n        }\n        const stateSplit = state.split(\"_identifier=\");\n        const checkStateSplit = checkState.split(\"_identifier=\");\n        return stateSplit[0] === checkStateSplit[0];\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/auth/commands/login.command.ts\n");

/***/ }),

/***/ "./src/auth/commands/logout.command.ts":
/*!*********************************************!*\
  !*** ./src/auth/commands/logout.command.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LogoutCommand: () => (/* binding */ LogoutCommand)\n/* harmony export */ });\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../models/response/message.response */ \"./src/models/response/message.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\nclass LogoutCommand {\n    constructor(authService, i18nService, logoutCallback) {\n        this.authService = authService;\n        this.i18nService = i18nService;\n        this.logoutCallback = logoutCallback;\n    }\n    run() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.logoutCallback();\n            this.authService.logOut(() => {\n                /* Do nothing */\n            });\n            const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_1__.MessageResponse(\"You have logged out.\", null);\n            return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.success(res);\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvYXV0aC9jb21tYW5kcy9sb2dvdXQuY29tbWFuZC50cyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7QUFHaUQ7QUFDd0I7QUFFbEUsTUFBTSxhQUFhO0lBQ3hCLFlBQ1UsV0FBd0IsRUFDeEIsV0FBd0IsRUFDeEIsY0FBbUM7UUFGbkMsZ0JBQVcsR0FBWCxXQUFXLENBQWE7UUFDeEIsZ0JBQVcsR0FBWCxXQUFXLENBQWE7UUFDeEIsbUJBQWMsR0FBZCxjQUFjLENBQXFCO0lBQzFDLENBQUM7SUFFRSxHQUFHOztZQUNQLE1BQU0sSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1lBQzVCLElBQUksQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLEdBQUcsRUFBRTtnQkFDM0IsZ0JBQWdCO1lBQ2xCLENBQUMsQ0FBQyxDQUFDO1lBQ0gsTUFBTSxHQUFHLEdBQUcsSUFBSSw4RUFBZSxDQUFDLHNCQUFzQixFQUFFLElBQUksQ0FBQyxDQUFDO1lBQzlELE9BQU8sc0RBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDL0IsQ0FBQztLQUFBO0NBQ0YiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9AYml0d2FyZGVuL2NsaS8uL3NyYy9hdXRoL2NvbW1hbmRzL2xvZ291dC5jb21tYW5kLnRzPzEwMTYiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXV0aFNlcnZpY2UgfSBmcm9tIFwiQGJpdHdhcmRlbi9jb21tb24vYXV0aC9hYnN0cmFjdGlvbnMvYXV0aC5zZXJ2aWNlXCI7XG5pbXBvcnQgeyBJMThuU2VydmljZSB9IGZyb20gXCJAYml0d2FyZGVuL2NvbW1vbi9wbGF0Zm9ybS9hYnN0cmFjdGlvbnMvaTE4bi5zZXJ2aWNlXCI7XG5cbmltcG9ydCB7IFJlc3BvbnNlIH0gZnJvbSBcIi4uLy4uL21vZGVscy9yZXNwb25zZVwiO1xuaW1wb3J0IHsgTWVzc2FnZVJlc3BvbnNlIH0gZnJvbSBcIi4uLy4uL21vZGVscy9yZXNwb25zZS9tZXNzYWdlLnJlc3BvbnNlXCI7XG5cbmV4cG9ydCBjbGFzcyBMb2dvdXRDb21tYW5kIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSBhdXRoU2VydmljZTogQXV0aFNlcnZpY2UsXG4gICAgcHJpdmF0ZSBpMThuU2VydmljZTogSTE4blNlcnZpY2UsXG4gICAgcHJpdmF0ZSBsb2dvdXRDYWxsYmFjazogKCkgPT4gUHJvbWlzZTx2b2lkPixcbiAgKSB7fVxuXG4gIGFzeW5jIHJ1bigpIHtcbiAgICBhd2FpdCB0aGlzLmxvZ291dENhbGxiYWNrKCk7XG4gICAgdGhpcy5hdXRoU2VydmljZS5sb2dPdXQoKCkgPT4ge1xuICAgICAgLyogRG8gbm90aGluZyAqL1xuICAgIH0pO1xuICAgIGNvbnN0IHJlcyA9IG5ldyBNZXNzYWdlUmVzcG9uc2UoXCJZb3UgaGF2ZSBsb2dnZWQgb3V0LlwiLCBudWxsKTtcbiAgICByZXR1cm4gUmVzcG9uc2Uuc3VjY2VzcyhyZXMpO1xuICB9XG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./src/auth/commands/logout.command.ts\n");

/***/ }),

/***/ "./src/auth/commands/unlock.command.ts":
/*!*********************************************!*\
  !*** ./src/auth/commands/unlock.command.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   UnlockCommand: () => (/* binding */ UnlockCommand)\n/* harmony export */ });\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_auth_models_request_secret_verification_request__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/auth/models/request/secret-verification.request */ \"../../libs/common/src/auth/models/request/secret-verification.request.ts\");\n/* harmony import */ var _bitwarden_common_platform_enums__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/platform/enums */ \"../../libs/common/src/platform/enums/index.ts\");\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _commands_convert_to_key_connector_command__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../commands/convert-to-key-connector.command */ \"./src/commands/convert-to-key-connector.command.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../models/response/message.response */ \"./src/models/response/message.response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils */ \"./src/utils.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\nclass UnlockCommand {\n    constructor(accountService, masterPasswordService, cryptoService, stateService, cryptoFunctionService, apiService, logService, keyConnectorService, environmentService, syncService, organizationApiService, logout, kdfConfigService) {\n        this.accountService = accountService;\n        this.masterPasswordService = masterPasswordService;\n        this.cryptoService = cryptoService;\n        this.stateService = stateService;\n        this.cryptoFunctionService = cryptoFunctionService;\n        this.apiService = apiService;\n        this.logService = logService;\n        this.keyConnectorService = keyConnectorService;\n        this.environmentService = environmentService;\n        this.syncService = syncService;\n        this.organizationApiService = organizationApiService;\n        this.logout = logout;\n        this.kdfConfigService = kdfConfigService;\n    }\n    run(password, cmdOptions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const normalizedOptions = new Options(cmdOptions);\n            const passwordResult = yield _utils__WEBPACK_IMPORTED_MODULE_7__.CliUtils.getPassword(password, normalizedOptions, this.logService);\n            if (passwordResult instanceof _models_response__WEBPACK_IMPORTED_MODULE_5__.Response) {\n                return passwordResult;\n            }\n            else {\n                password = passwordResult;\n            }\n            yield this.setNewSessionKey();\n            const [userId, email] = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.accountService.activeAccount$.pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_0__.map)((a) => [a === null || a === void 0 ? void 0 : a.id, a === null || a === void 0 ? void 0 : a.email])));\n            const kdfConfig = yield this.kdfConfigService.getKdfConfig();\n            const masterKey = yield this.cryptoService.makeMasterKey(password, email, kdfConfig);\n            const storedMasterKeyHash = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.masterPasswordService.masterKeyHash$(userId));\n            let passwordValid = false;\n            if (masterKey != null) {\n                if (storedMasterKeyHash != null) {\n                    passwordValid = yield this.cryptoService.compareAndUpdateKeyHash(password, masterKey);\n                }\n                else {\n                    const serverKeyHash = yield this.cryptoService.hashMasterKey(password, masterKey, _bitwarden_common_platform_enums__WEBPACK_IMPORTED_MODULE_2__.HashPurpose.ServerAuthorization);\n                    const request = new _bitwarden_common_auth_models_request_secret_verification_request__WEBPACK_IMPORTED_MODULE_1__.SecretVerificationRequest();\n                    request.masterPasswordHash = serverKeyHash;\n                    try {\n                        yield this.apiService.postAccountVerifyPassword(request);\n                        passwordValid = true;\n                        const localKeyHash = yield this.cryptoService.hashMasterKey(password, masterKey, _bitwarden_common_platform_enums__WEBPACK_IMPORTED_MODULE_2__.HashPurpose.LocalAuthorization);\n                        yield this.masterPasswordService.setMasterKeyHash(localKeyHash, userId);\n                    }\n                    catch (_a) {\n                        // Ignore\n                    }\n                }\n            }\n            if (passwordValid) {\n                yield this.masterPasswordService.setMasterKey(masterKey, userId);\n                const userKey = yield this.masterPasswordService.decryptUserKeyWithMasterKey(masterKey);\n                yield this.cryptoService.setUserKey(userKey);\n                if (yield this.keyConnectorService.getConvertAccountRequired()) {\n                    const convertToKeyConnectorCommand = new _commands_convert_to_key_connector_command__WEBPACK_IMPORTED_MODULE_4__.ConvertToKeyConnectorCommand(this.keyConnectorService, this.environmentService, this.syncService, this.organizationApiService, this.logout);\n                    const convertResponse = yield convertToKeyConnectorCommand.run();\n                    if (!convertResponse.success) {\n                        return convertResponse;\n                    }\n                }\n                return this.successResponse();\n            }\n            else {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.error(\"Invalid master password.\");\n            }\n        });\n    }\n    setNewSessionKey() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const key = yield this.cryptoFunctionService.randomBytes(64);\n            process.env.BW_SESSION = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_3__.Utils.fromBufferToB64(key);\n        });\n    }\n    successResponse() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_6__.MessageResponse(\"Your vault is now unlocked!\", \"\\n\" +\n                \"To unlock your vault, set your session key to the `BW_SESSION` environment variable. ex:\\n\" +\n                '$ export BW_SESSION=\"' +\n                process.env.BW_SESSION +\n                '\"\\n' +\n                '> $env:BW_SESSION=\"' +\n                process.env.BW_SESSION +\n                '\"\\n\\n' +\n                \"You can also pass the session key to any command with the `--session` option. ex:\\n\" +\n                \"$ bw list items --session \" +\n                process.env.BW_SESSION);\n            res.raw = process.env.BW_SESSION;\n            return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.success(res);\n        });\n    }\n}\nclass Options {\n    constructor(passedOptions) {\n        this.passwordEnv = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordenv) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordEnv);\n        this.passwordFile = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordfile) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passwordFile);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/auth/commands/unlock.command.ts\n");

/***/ }),

/***/ "./src/base-program.ts":
/*!*****************************!*\
  !*** ./src/base-program.ts ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BaseProgram: () => (/* binding */ BaseProgram)\n/* harmony export */ });\n/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! chalk */ \"chalk\");\n/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(chalk__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _bitwarden_common_auth_enums_authentication_status__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/auth/enums/authentication-status */ \"../../libs/common/src/auth/enums/authentication-status.ts\");\n/* harmony import */ var _auth_commands_unlock_command__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./auth/commands/unlock.command */ \"./src/auth/commands/unlock.command.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils */ \"./src/utils.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\nconst writeLn = _utils__WEBPACK_IMPORTED_MODULE_5__.CliUtils.writeLn;\nclass BaseProgram {\n    constructor(serviceContainer) {\n        this.serviceContainer = serviceContainer;\n    }\n    processResponse(response, exitImmediately = false) {\n        if (!response.success) {\n            if (process.env.BW_QUIET !== \"true\") {\n                if (process.env.BW_RESPONSE === \"true\") {\n                    writeLn(this.getJson(response), true, false);\n                }\n                else {\n                    writeLn(chalk__WEBPACK_IMPORTED_MODULE_0__.redBright(response.message), true, true);\n                }\n            }\n            const exitCode = process.env.BW_CLEANEXIT ? 0 : 1;\n            if (exitImmediately) {\n                process.exit(exitCode);\n            }\n            else {\n                process.exitCode = exitCode;\n            }\n            return;\n        }\n        if (process.env.BW_RESPONSE === \"true\") {\n            writeLn(this.getJson(response), true, false);\n        }\n        else if (response.data != null) {\n            let out = null;\n            if (response.data.object === \"template\") {\n                out = this.getJson(response.data.template);\n            }\n            if (out == null) {\n                if (response.data.object === \"string\") {\n                    const data = response.data.data;\n                    if (data != null) {\n                        out = data;\n                    }\n                }\n                else if (response.data.object === \"list\") {\n                    out = this.getJson(response.data.data);\n                }\n                else if (response.data.object === \"message\") {\n                    out = this.getMessage(response);\n                }\n                else {\n                    out = this.getJson(response.data);\n                }\n            }\n            if (out != null && process.env.BW_QUIET !== \"true\") {\n                writeLn(out, true, false);\n            }\n        }\n        if (exitImmediately) {\n            process.exit(0);\n        }\n        else {\n            process.exitCode = 0;\n        }\n    }\n    getJson(obj) {\n        if (process.env.BW_PRETTY === \"true\") {\n            return JSON.stringify(obj, null, \"  \");\n        }\n        else {\n            return JSON.stringify(obj);\n        }\n    }\n    getMessage(response) {\n        const message = response.data;\n        if (process.env.BW_RAW === \"true\") {\n            return message.raw;\n        }\n        let out = \"\";\n        if (message.title != null) {\n            if (message.noColor) {\n                out = message.title;\n            }\n            else {\n                out = chalk__WEBPACK_IMPORTED_MODULE_0__.greenBright(message.title);\n            }\n        }\n        if (message.message != null) {\n            if (message.title != null) {\n                out += \"\\n\";\n            }\n            out += message.message;\n        }\n        return out.trim() === \"\" ? null : out;\n    }\n    exitIfAuthed() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const authed = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.firstValueFrom)(this.serviceContainer.authService.activeAccountStatus$.pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_1__.map)((status) => status > _bitwarden_common_auth_enums_authentication_status__WEBPACK_IMPORTED_MODULE_2__.AuthenticationStatus.LoggedOut)));\n            if (authed) {\n                const email = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.firstValueFrom)(this.serviceContainer.accountService.activeAccount$.pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_1__.map)((a) => a === null || a === void 0 ? void 0 : a.email)));\n                this.processResponse(_models_response__WEBPACK_IMPORTED_MODULE_4__.Response.error(\"You are already logged in as \" + email + \".\"), true);\n            }\n        });\n    }\n    exitIfNotAuthed() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const authed = yield this.serviceContainer.stateService.getIsAuthenticated();\n            if (!authed) {\n                this.processResponse(_models_response__WEBPACK_IMPORTED_MODULE_4__.Response.error(\"You are not logged in.\"), true);\n            }\n        });\n    }\n    exitIfLocked() {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.exitIfNotAuthed();\n            if (yield this.serviceContainer.cryptoService.hasUserKey()) {\n                return;\n            }\n            else if (process.env.BW_NOINTERACTION !== \"true\") {\n                // must unlock\n                if (yield this.serviceContainer.keyConnectorService.getUsesKeyConnector()) {\n                    const response = _models_response__WEBPACK_IMPORTED_MODULE_4__.Response.error(\"Your vault is locked. You must unlock your vault using your session key.\\n\" +\n                        \"If you do not have your session key, you can get a new one by logging out and logging in again.\");\n                    this.processResponse(response, true);\n                }\n                else {\n                    const command = new _auth_commands_unlock_command__WEBPACK_IMPORTED_MODULE_3__.UnlockCommand(this.serviceContainer.accountService, this.serviceContainer.masterPasswordService, this.serviceContainer.cryptoService, this.serviceContainer.stateService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.apiService, this.serviceContainer.logService, this.serviceContainer.keyConnectorService, this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.organizationApiService, this.serviceContainer.logout, this.serviceContainer.kdfConfigService);\n                    const response = yield command.run(null, null);\n                    if (!response.success) {\n                        this.processResponse(response, true);\n                    }\n                }\n            }\n            else {\n                this.processResponse(_models_response__WEBPACK_IMPORTED_MODULE_4__.Response.error(\"Vault is locked.\"), true);\n            }\n        });\n    }\n    exitIfFeatureFlagDisabled(featureFlag) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const enabled = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.firstValueFrom)(this.serviceContainer.configService.getFeatureFlag$(featureFlag));\n            if (!enabled) {\n                this.processResponse(_models_response__WEBPACK_IMPORTED_MODULE_4__.Response.error(\"This command is temporarily unavailable.\"), true);\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/base-program.ts\n");

/***/ }),

/***/ "./src/commands/completion.command.ts":
/*!********************************************!*\
  !*** ./src/commands/completion.command.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CompletionCommand: () => (/* binding */ CompletionCommand)\n/* harmony export */ });\n/* harmony import */ var commander__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! commander */ \"commander\");\n/* harmony import */ var commander__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(commander__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/response/message.response */ \"./src/models/response/message.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nconst validShells = [\"zsh\"];\nclass CompletionCommand {\n    run(options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const shell = options.shell;\n            if (!shell) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(\"`shell` option was not provided.\");\n            }\n            if (!validShells.includes(shell)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(\"Unsupported shell.\");\n            }\n            let content = \"\";\n            if (shell === \"zsh\") {\n                content = this.zshCompletion(\"bw\", commander__WEBPACK_IMPORTED_MODULE_0__.program).render();\n            }\n            const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_2__.MessageResponse(content, null);\n            return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.success(res);\n        });\n    }\n    zshCompletion(rootName, rootCommand) {\n        return {\n            render: () => {\n                return [\n                    `#compdef _${rootName} ${rootName}`,\n                    \"\",\n                    this.renderCommandBlock(rootName, rootCommand),\n                ].join(\"\\n\");\n            },\n        };\n    }\n    renderCommandBlock(name, command) {\n        const { commands = [], options = [] } = command;\n        const hasOptions = options.length > 0;\n        const hasCommands = commands.length > 0;\n        const args = options\n            .map(({ long, short, description }) => {\n            const aliases = [short, long].filter(Boolean);\n            const opts = aliases.join(\",\");\n            const desc = `[${description.replace(`'`, `'\"'\"'`)}]`;\n            return aliases.length > 1\n                ? `'(${aliases.join(\" \")})'{${opts}}'${desc}'`\n                : `'${opts}${desc}'`;\n        })\n            .concat(`'(-h --help)'{-h,--help}'[output usage information]'`, hasCommands ? '\"1: :->cmnds\"' : null, '\"*::arg:->args\"')\n            .filter(Boolean);\n        const commandBlockFunctionParts = [];\n        if (hasCommands) {\n            commandBlockFunctionParts.push(\"local -a commands\");\n        }\n        if (hasOptions) {\n            commandBlockFunctionParts.push(`_arguments -C \\\\\\n    ${args.join(` \\\\\\n    `)}`);\n        }\n        if (hasCommands) {\n            commandBlockFunctionParts.push(`case $state in\n    cmnds)\n      commands=(\n        ${commands\n                .map((command) => `\"${command.name().split(\" \")[0]}:${command.description()}\"`)\n                .join(\"\\n        \")}\n      )\n      _describe \"command\" commands\n      ;;\\n  esac\n\n  case \"$words[1]\" in\n    ${commands\n                .map((command) => {\n                const commandName = command.name().split(\" \")[0];\n                return [`${commandName})`, `_${name}_${commandName}`, \";;\"].join(\"\\n      \");\n            })\n                .join(\"\\n    \")}\\n  esac`);\n        }\n        const commandBlocParts = [\n            `function _${name} {\\n  ${commandBlockFunctionParts.join(\"\\n\\n  \")}\\n}`,\n        ];\n        if (hasCommands) {\n            commandBlocParts.push(commands.map((c) => this.renderCommandBlock(`${name}_${c.name()}`, c)).join(\"\\n\\n\"));\n        }\n        return commandBlocParts.join(\"\\n\\n\");\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/completion.command.ts\n");

/***/ }),

/***/ "./src/commands/config.command.ts":
/*!****************************************!*\
  !*** ./src/commands/config.command.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ConfigCommand: () => (/* binding */ ConfigCommand)\n/* harmony export */ });\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_platform_abstractions_environment_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/platform/abstractions/environment.service */ \"../../libs/common/src/platform/abstractions/environment.service.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/response/message.response */ \"./src/models/response/message.response.ts\");\n/* harmony import */ var _models_response_string_response__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../models/response/string.response */ \"./src/models/response/string.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nclass ConfigCommand {\n    constructor(environmentService) {\n        this.environmentService = environmentService;\n    }\n    run(setting, value, options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            setting = setting.toLowerCase();\n            switch (setting) {\n                case \"server\":\n                    return yield this.getOrSetServer(value, options);\n                default:\n                    return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.badRequest(\"Unknown setting.\");\n            }\n        });\n    }\n    getOrSetServer(url, options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if ((url == null || url.trim() === \"\") &&\n                !options.webVault &&\n                !options.api &&\n                !options.identity &&\n                !options.icons &&\n                !options.notifications &&\n                !options.events) {\n                const env = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.environmentService.environment$);\n                const stringRes = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_4__.StringResponse(env.hasBaseUrl() ? env.getUrls().base : \"https://bitwarden.com\");\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.success(stringRes);\n            }\n            url = url === \"null\" || url === \"bitwarden.com\" || url === \"https://bitwarden.com\" ? null : url;\n            yield this.environmentService.setEnvironment(_bitwarden_common_platform_abstractions_environment_service__WEBPACK_IMPORTED_MODULE_1__.Region.SelfHosted, {\n                base: url,\n                webVault: options.webVault || null,\n                api: options.api || null,\n                identity: options.identity || null,\n                icons: options.icons || null,\n                notifications: options.notifications || null,\n                events: options.events || null,\n                keyConnector: options.keyConnector || null,\n            });\n            const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_3__.MessageResponse(\"Saved setting `config`.\", null);\n            return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.success(res);\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/config.command.ts\n");

/***/ }),

/***/ "./src/commands/convert-to-key-connector.command.ts":
/*!**********************************************************!*\
  !*** ./src/commands/convert-to-key-connector.command.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ConvertToKeyConnectorCommand: () => (/* binding */ ConvertToKeyConnectorCommand)\n/* harmony export */ });\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! inquirer */ \"inquirer\");\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(inquirer__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _bitwarden_common_platform_abstractions_environment_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/platform/abstractions/environment.service */ \"../../libs/common/src/platform/abstractions/environment.service.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../models/response/message.response */ \"./src/models/response/message.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nclass ConvertToKeyConnectorCommand {\n    constructor(keyConnectorService, environmentService, syncService, organizationApiService, logout) {\n        this.keyConnectorService = keyConnectorService;\n        this.environmentService = environmentService;\n        this.syncService = syncService;\n        this.organizationApiService = organizationApiService;\n        this.logout = logout;\n    }\n    run() {\n        return __awaiter(this, void 0, void 0, function* () {\n            // If no interaction available, alert user to use web vault\n            const canInteract = process.env.BW_NOINTERACTION !== \"true\";\n            if (!canInteract) {\n                yield this.logout();\n                return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.error(new _models_response_message_response__WEBPACK_IMPORTED_MODULE_4__.MessageResponse(\"An organization you are a member of is using Key Connector. \" +\n                    \"In order to access the vault, you must opt-in to Key Connector now via the web vault. You have been logged out.\", null));\n            }\n            const organization = yield this.keyConnectorService.getManagingOrganization();\n            const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_0__.createPromptModule({ output: process.stderr })({\n                type: \"list\",\n                name: \"convert\",\n                message: organization.name +\n                    \" is using a self-hosted key server. A master password is no longer required to log in for members of this organization. \",\n                choices: [\n                    {\n                        name: \"Remove master password and unlock\",\n                        value: \"remove\",\n                    },\n                    {\n                        name: \"Leave organization and unlock\",\n                        value: \"leave\",\n                    },\n                    {\n                        name: \"Log out\",\n                        value: \"exit\",\n                    },\n                ],\n            });\n            if (answer.convert === \"remove\") {\n                try {\n                    yield this.keyConnectorService.migrateUser();\n                }\n                catch (e) {\n                    yield this.logout();\n                    throw e;\n                }\n                yield this.keyConnectorService.removeConvertAccountRequired();\n                yield this.keyConnectorService.setUsesKeyConnector(true);\n                // Update environment URL - required for api key login\n                const env = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.firstValueFrom)(this.environmentService.environment$);\n                const urls = env.getUrls();\n                urls.keyConnector = organization.keyConnectorUrl;\n                yield this.environmentService.setEnvironment(_bitwarden_common_platform_abstractions_environment_service__WEBPACK_IMPORTED_MODULE_2__.Region.SelfHosted, urls);\n                return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.success();\n            }\n            else if (answer.convert === \"leave\") {\n                yield this.organizationApiService.leave(organization.id);\n                yield this.keyConnectorService.removeConvertAccountRequired();\n                return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.success();\n            }\n            else {\n                yield this.logout();\n                return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.error(\"You have been logged out.\");\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/convert-to-key-connector.command.ts\n");

/***/ }),

/***/ "./src/commands/download.command.ts":
/*!******************************************!*\
  !*** ./src/commands/download.command.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DownloadCommand: () => (/* binding */ DownloadCommand)\n/* harmony export */ });\n/* harmony import */ var node_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! node-fetch */ \"node-fetch\");\n/* harmony import */ var node_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_fetch__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_platform_models_domain_enc_array_buffer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/platform/models/domain/enc-array-buffer */ \"../../libs/common/src/platform/models/domain/enc-array-buffer.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_file_response__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/response/file.response */ \"./src/models/response/file.response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils */ \"./src/utils.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nclass DownloadCommand {\n    constructor(cryptoService) {\n        this.cryptoService = cryptoService;\n    }\n    saveAttachmentToFile(url, key, fileName, output) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const response = yield node_fetch__WEBPACK_IMPORTED_MODULE_0___default()(new node_fetch__WEBPACK_IMPORTED_MODULE_0__.Request(url, { headers: { cache: \"no-cache\" } }));\n            if (response.status !== 200) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.error(\"A \" + response.status + \" error occurred while downloading the attachment.\");\n            }\n            try {\n                const encBuf = yield _bitwarden_common_platform_models_domain_enc_array_buffer__WEBPACK_IMPORTED_MODULE_1__.EncArrayBuffer.fromResponse(response);\n                const decBuf = yield this.cryptoService.decryptFromBytes(encBuf, key);\n                if (process.env.BW_SERVE === \"true\") {\n                    const res = new _models_response_file_response__WEBPACK_IMPORTED_MODULE_3__.FileResponse(Buffer.from(decBuf), fileName);\n                    return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.success(res);\n                }\n                else {\n                    return yield _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.saveResultToFile(Buffer.from(decBuf), output, fileName);\n                }\n            }\n            catch (e) {\n                if (typeof e === \"string\") {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.error(e);\n                }\n                else {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.error(\"An error occurred while saving the attachment.\");\n                }\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/download.command.ts\n");

/***/ }),

/***/ "./src/commands/edit.command.ts":
/*!**************************************!*\
  !*** ./src/commands/edit.command.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EditCommand: () => (/* binding */ EditCommand)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_admin_console_models_request_selection_read_only_request__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/admin-console/models/request/selection-read-only.request */ \"../../libs/common/src/admin-console/models/request/selection-read-only.request.ts\");\n/* harmony import */ var _bitwarden_common_models_export_cipher_export__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/models/export/cipher.export */ \"../../libs/common/src/models/export/cipher.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_collection_export__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/models/export/collection.export */ \"../../libs/common/src/models/export/collection.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_folder_export__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/models/export/folder.export */ \"../../libs/common/src/models/export/folder.export.ts\");\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_common_vault_models_request_collection_request__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @bitwarden/common/vault/models/request/collection.request */ \"../../libs/common/src/vault/models/request/collection.request.ts\");\n/* harmony import */ var _admin_console_models_response_organization_collection_response__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../admin-console/models/response/organization-collection.response */ \"./src/admin-console/models/response/organization-collection.response.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils */ \"./src/utils.ts\");\n/* harmony import */ var _vault_models_cipher_response__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../vault/models/cipher.response */ \"./src/vault/models/cipher.response.ts\");\n/* harmony import */ var _vault_models_folder_response__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../vault/models/folder.response */ \"./src/vault/models/folder.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\nclass EditCommand {\n    constructor(cipherService, folderService, cryptoService, apiService, folderApiService) {\n        this.cipherService = cipherService;\n        this.folderService = folderService;\n        this.cryptoService = cryptoService;\n        this.apiService = apiService;\n        this.folderApiService = folderApiService;\n    }\n    run(object, id, requestJson, cmdOptions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (process.env.BW_SERVE !== \"true\" && (requestJson == null || requestJson === \"\")) {\n                requestJson = yield _utils__WEBPACK_IMPORTED_MODULE_8__.CliUtils.readStdin();\n            }\n            if (requestJson == null || requestJson === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.badRequest(\"`requestJson` was not provided.\");\n            }\n            let req = null;\n            if (typeof requestJson !== \"string\") {\n                req = requestJson;\n            }\n            else {\n                try {\n                    const reqJson = Buffer.from(requestJson, \"base64\").toString();\n                    req = JSON.parse(reqJson);\n                }\n                catch (e) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.badRequest(\"Error parsing the encoded request data.\");\n                }\n            }\n            if (id != null) {\n                id = id.toLowerCase();\n            }\n            const normalizedOptions = new Options(cmdOptions);\n            switch (object.toLowerCase()) {\n                case \"item\":\n                    return yield this.editCipher(id, req);\n                case \"item-collections\":\n                    return yield this.editCipherCollections(id, req);\n                case \"folder\":\n                    return yield this.editFolder(id, req);\n                case \"org-collection\":\n                    return yield this.editOrganizationCollection(id, req, normalizedOptions);\n                default:\n                    return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.badRequest(\"Unknown object.\");\n            }\n        });\n    }\n    editCipher(id, req) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const cipher = yield this.cipherService.get(id);\n            if (cipher == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.notFound();\n            }\n            let cipherView = yield cipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(cipher));\n            if (cipherView.isDeleted) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.badRequest(\"You may not edit a deleted item. Use the restore command first.\");\n            }\n            cipherView = _bitwarden_common_models_export_cipher_export__WEBPACK_IMPORTED_MODULE_1__.CipherExport.toView(req, cipherView);\n            const encCipher = yield this.cipherService.encrypt(cipherView);\n            try {\n                const updatedCipher = yield this.cipherService.updateWithServer(encCipher);\n                const decCipher = yield updatedCipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(updatedCipher));\n                const res = new _vault_models_cipher_response__WEBPACK_IMPORTED_MODULE_9__.CipherResponse(decCipher);\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.error(e);\n            }\n        });\n    }\n    editCipherCollections(id, req) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const cipher = yield this.cipherService.get(id);\n            if (cipher == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.notFound();\n            }\n            if (cipher.organizationId == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.badRequest(\"Item does not belong to an organization. Consider moving it first.\");\n            }\n            cipher.collectionIds = req;\n            try {\n                const updatedCipher = yield this.cipherService.saveCollectionsWithServer(cipher);\n                const decCipher = yield updatedCipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(updatedCipher));\n                const res = new _vault_models_cipher_response__WEBPACK_IMPORTED_MODULE_9__.CipherResponse(decCipher);\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.error(e);\n            }\n        });\n    }\n    editFolder(id, req) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const folder = yield this.folderService.getFromState(id);\n            if (folder == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.notFound();\n            }\n            let folderView = yield folder.decrypt();\n            folderView = _bitwarden_common_models_export_folder_export__WEBPACK_IMPORTED_MODULE_3__.FolderExport.toView(req, folderView);\n            const encFolder = yield this.folderService.encrypt(folderView);\n            try {\n                yield this.folderApiService.save(encFolder);\n                const updatedFolder = yield this.folderService.get(folder.id);\n                const decFolder = yield updatedFolder.decrypt();\n                const res = new _vault_models_folder_response__WEBPACK_IMPORTED_MODULE_10__.FolderResponse(decFolder);\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.error(e);\n            }\n        });\n    }\n    editOrganizationCollection(id, req, options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (options.organizationId == null || options.organizationId === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.badRequest(\"`organizationid` option is required.\");\n            }\n            if (!_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_4__.Utils.isGuid(id)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.badRequest(\"`\" + id + \"` is not a GUID.\");\n            }\n            if (!_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_4__.Utils.isGuid(options.organizationId)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.badRequest(\"`\" + options.organizationId + \"` is not a GUID.\");\n            }\n            if (options.organizationId !== req.organizationId) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.badRequest(\"`organizationid` option does not match request object.\");\n            }\n            try {\n                const orgKey = yield this.cryptoService.getOrgKey(req.organizationId);\n                if (orgKey == null) {\n                    throw new Error(\"No encryption key for this organization.\");\n                }\n                const groups = req.groups == null\n                    ? null\n                    : req.groups.map((g) => new _bitwarden_common_admin_console_models_request_selection_read_only_request__WEBPACK_IMPORTED_MODULE_0__.SelectionReadOnlyRequest(g.id, g.readOnly, g.hidePasswords, g.manage));\n                const request = new _bitwarden_common_vault_models_request_collection_request__WEBPACK_IMPORTED_MODULE_5__.CollectionRequest();\n                request.name = (yield this.cryptoService.encrypt(req.name, orgKey)).encryptedString;\n                request.externalId = req.externalId;\n                request.groups = groups;\n                const response = yield this.apiService.putCollection(req.organizationId, id, request);\n                const view = _bitwarden_common_models_export_collection_export__WEBPACK_IMPORTED_MODULE_2__.CollectionExport.toView(req);\n                view.id = response.id;\n                const res = new _admin_console_models_response_organization_collection_response__WEBPACK_IMPORTED_MODULE_6__.OrganizationCollectionResponse(view, groups);\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_7__.Response.error(e);\n            }\n        });\n    }\n}\nclass Options {\n    constructor(passedOptions) {\n        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/edit.command.ts\n");

/***/ }),

/***/ "./src/commands/encode.command.ts":
/*!****************************************!*\
  !*** ./src/commands/encode.command.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EncodeCommand: () => (/* binding */ EncodeCommand)\n/* harmony export */ });\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_string_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../models/response/string.response */ \"./src/models/response/string.response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils */ \"./src/utils.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass EncodeCommand {\n    run() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (process.stdin.isTTY) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.badRequest(\"No stdin was piped in.\");\n            }\n            const input = yield _utils__WEBPACK_IMPORTED_MODULE_2__.CliUtils.readStdin();\n            const b64 = Buffer.from(input, \"utf8\").toString(\"base64\");\n            const res = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_1__.StringResponse(b64);\n            return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.success(res);\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvY29tbWFuZHMvZW5jb2RlLmNvbW1hbmQudHMiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7OztBQUE4QztBQUNzQjtBQUNoQztBQUU3QixNQUFNLGFBQWE7SUFDbEIsR0FBRzs7WUFDUCxJQUFJLE9BQU8sQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFO2dCQUN2QixPQUFPLHNEQUFRLENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDLENBQUM7YUFDdEQ7WUFDRCxNQUFNLEtBQUssR0FBRyxNQUFNLDRDQUFRLENBQUMsU0FBUyxFQUFFLENBQUM7WUFDekMsTUFBTSxHQUFHLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQzFELE1BQU0sR0FBRyxHQUFHLElBQUksNEVBQWMsQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUNwQyxPQUFPLHNEQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQy9CLENBQUM7S0FBQTtDQUNGIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQGJpdHdhcmRlbi9jbGkvLi9zcmMvY29tbWFuZHMvZW5jb2RlLmNvbW1hbmQudHM/MDE5OSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBSZXNwb25zZSB9IGZyb20gXCIuLi9tb2RlbHMvcmVzcG9uc2VcIjtcbmltcG9ydCB7IFN0cmluZ1Jlc3BvbnNlIH0gZnJvbSBcIi4uL21vZGVscy9yZXNwb25zZS9zdHJpbmcucmVzcG9uc2VcIjtcbmltcG9ydCB7IENsaVV0aWxzIH0gZnJvbSBcIi4uL3V0aWxzXCI7XG5cbmV4cG9ydCBjbGFzcyBFbmNvZGVDb21tYW5kIHtcbiAgYXN5bmMgcnVuKCk6IFByb21pc2U8UmVzcG9uc2U+IHtcbiAgICBpZiAocHJvY2Vzcy5zdGRpbi5pc1RUWSkge1xuICAgICAgcmV0dXJuIFJlc3BvbnNlLmJhZFJlcXVlc3QoXCJObyBzdGRpbiB3YXMgcGlwZWQgaW4uXCIpO1xuICAgIH1cbiAgICBjb25zdCBpbnB1dCA9IGF3YWl0IENsaVV0aWxzLnJlYWRTdGRpbigpO1xuICAgIGNvbnN0IGI2NCA9IEJ1ZmZlci5mcm9tKGlucHV0LCBcInV0ZjhcIikudG9TdHJpbmcoXCJiYXNlNjRcIik7XG4gICAgY29uc3QgcmVzID0gbmV3IFN0cmluZ1Jlc3BvbnNlKGI2NCk7XG4gICAgcmV0dXJuIFJlc3BvbnNlLnN1Y2Nlc3MocmVzKTtcbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/commands/encode.command.ts\n");

/***/ }),

/***/ "./src/commands/get.command.ts":
/*!*************************************!*\
  !*** ./src/commands/get.command.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   GetCommand: () => (/* binding */ GetCommand)\n/* harmony export */ });\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/enums */ \"../../libs/common/src/enums/index.ts\");\n/* harmony import */ var _bitwarden_common_models_export_card_export__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/models/export/card.export */ \"../../libs/common/src/models/export/card.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_cipher_export__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/models/export/cipher.export */ \"../../libs/common/src/models/export/cipher.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_collection_export__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @bitwarden/common/models/export/collection.export */ \"../../libs/common/src/models/export/collection.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_field_export__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @bitwarden/common/models/export/field.export */ \"../../libs/common/src/models/export/field.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_folder_export__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @bitwarden/common/models/export/folder.export */ \"../../libs/common/src/models/export/folder.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_identity_export__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @bitwarden/common/models/export/identity.export */ \"../../libs/common/src/models/export/identity.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_login_uri_export__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @bitwarden/common/models/export/login-uri.export */ \"../../libs/common/src/models/export/login-uri.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_login_export__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @bitwarden/common/models/export/login.export */ \"../../libs/common/src/models/export/login.export.ts\");\n/* harmony import */ var _bitwarden_common_models_export_secure_note_export__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @bitwarden/common/models/export/secure-note.export */ \"../../libs/common/src/models/export/secure-note.export.ts\");\n/* harmony import */ var _bitwarden_common_models_response_error_response__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @bitwarden/common/models/response/error.response */ \"../../libs/common/src/models/response/error.response.ts\");\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_common_platform_models_domain_enc_string__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @bitwarden/common/platform/models/domain/enc-string */ \"../../libs/common/src/platform/models/domain/enc-string.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @bitwarden/common/tools/send/enums/send-type */ \"../../libs/common/src/tools/send/enums/send-type.ts\");\n/* harmony import */ var _bitwarden_common_vault_enums__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @bitwarden/common/vault/enums */ \"../../libs/common/src/vault/enums/index.ts\");\n/* harmony import */ var _bitwarden_common_vault_models_view_collection_view__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @bitwarden/common/vault/models/view/collection.view */ \"../../libs/common/src/vault/models/view/collection.view.ts\");\n/* harmony import */ var _admin_console_models_request_organization_collection_request__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../admin-console/models/request/organization-collection.request */ \"./src/admin-console/models/request/organization-collection.request.ts\");\n/* harmony import */ var _admin_console_models_response_organization_collection_response__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../admin-console/models/response/organization-collection.response */ \"./src/admin-console/models/response/organization-collection.response.ts\");\n/* harmony import */ var _admin_console_models_response_organization_response__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../admin-console/models/response/organization.response */ \"./src/admin-console/models/response/organization.response.ts\");\n/* harmony import */ var _admin_console_models_selection_read_only__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../admin-console/models/selection-read-only */ \"./src/admin-console/models/selection-read-only.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_string_response__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../models/response/string.response */ \"./src/models/response/string.response.ts\");\n/* harmony import */ var _models_response_template_response__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../models/response/template.response */ \"./src/models/response/template.response.ts\");\n/* harmony import */ var _tools_send_models_send_response__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../tools/send/models/send.response */ \"./src/tools/send/models/send.response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../utils */ \"./src/utils.ts\");\n/* harmony import */ var _vault_models_cipher_response__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../vault/models/cipher.response */ \"./src/vault/models/cipher.response.ts\");\n/* harmony import */ var _vault_models_collection_response__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../vault/models/collection.response */ \"./src/vault/models/collection.response.ts\");\n/* harmony import */ var _vault_models_folder_response__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../vault/models/folder.response */ \"./src/vault/models/folder.response.ts\");\n/* harmony import */ var _download_command__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./download.command */ \"./src/commands/download.command.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass GetCommand extends _download_command__WEBPACK_IMPORTED_MODULE_29__.DownloadCommand {\n    constructor(cipherService, folderService, collectionService, totpService, auditService, cryptoService, stateService, searchService, apiService, organizationService, eventCollectionService, accountProfileService) {\n        super(cryptoService);\n        this.cipherService = cipherService;\n        this.folderService = folderService;\n        this.collectionService = collectionService;\n        this.totpService = totpService;\n        this.auditService = auditService;\n        this.stateService = stateService;\n        this.searchService = searchService;\n        this.apiService = apiService;\n        this.organizationService = organizationService;\n        this.eventCollectionService = eventCollectionService;\n        this.accountProfileService = accountProfileService;\n    }\n    run(object, id, cmdOptions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (id != null) {\n                id = id.toLowerCase();\n            }\n            const normalizedOptions = new Options(cmdOptions);\n            switch (object.toLowerCase()) {\n                case \"item\":\n                    return yield this.getCipher(id);\n                case \"username\":\n                    return yield this.getUsername(id);\n                case \"password\":\n                    return yield this.getPassword(id);\n                case \"uri\":\n                    return yield this.getUri(id);\n                case \"totp\":\n                    return yield this.getTotp(id);\n                case \"notes\":\n                    return yield this.getNotes(id);\n                case \"exposed\":\n                    return yield this.getExposed(id);\n                case \"attachment\":\n                    return yield this.getAttachment(id, normalizedOptions);\n                case \"folder\":\n                    return yield this.getFolder(id);\n                case \"collection\":\n                    return yield this.getCollection(id);\n                case \"org-collection\":\n                    return yield this.getOrganizationCollection(id, normalizedOptions);\n                case \"organization\":\n                    return yield this.getOrganization(id);\n                case \"template\":\n                    return yield this.getTemplate(id);\n                case \"fingerprint\":\n                    return yield this.getFingerprint(id);\n                default:\n                    return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"Unknown object.\");\n            }\n        });\n    }\n    getCipherView(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let decCipher = null;\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isGuid(id)) {\n                const cipher = yield this.cipherService.get(id);\n                if (cipher != null) {\n                    decCipher = yield cipher.decrypt(yield this.cipherService.getKeyForCipherKeyDecryption(cipher));\n                }\n            }\n            else if (id.trim() !== \"\") {\n                let ciphers = yield this.cipherService.getAllDecrypted();\n                ciphers = this.searchService.searchCiphersBasic(ciphers, id);\n                if (ciphers.length > 1) {\n                    return ciphers;\n                }\n                if (ciphers.length > 0) {\n                    decCipher = ciphers[0];\n                }\n            }\n            return decCipher;\n        });\n    }\n    getCipher(id, filter) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let decCipher = yield this.getCipherView(id);\n            if (decCipher == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.notFound();\n            }\n            if (Array.isArray(decCipher)) {\n                if (filter != null) {\n                    decCipher = decCipher.filter(filter);\n                    if (decCipher.length === 1) {\n                        decCipher = decCipher[0];\n                    }\n                }\n                if (Array.isArray(decCipher)) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.multipleResults(decCipher.map((c) => c.id));\n                }\n            }\n            // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.\n            // eslint-disable-next-line @typescript-eslint/no-floating-promises\n            this.eventCollectionService.collect(_bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_1__.EventType.Cipher_ClientViewed, id, true, decCipher.organizationId);\n            const res = new _vault_models_cipher_response__WEBPACK_IMPORTED_MODULE_26__.CipherResponse(decCipher);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getUsername(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const cipherResponse = yield this.getCipher(id, (c) => c.type === _bitwarden_common_vault_enums__WEBPACK_IMPORTED_MODULE_15__.CipherType.Login && !_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isNullOrWhitespace(c.login.username));\n            if (!cipherResponse.success) {\n                return cipherResponse;\n            }\n            const cipher = cipherResponse.data;\n            if (cipher.type !== _bitwarden_common_vault_enums__WEBPACK_IMPORTED_MODULE_15__.CipherType.Login) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"Not a login.\");\n            }\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isNullOrWhitespace(cipher.login.username)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"No username available for this login.\");\n            }\n            const res = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_22__.StringResponse(cipher.login.username);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getPassword(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const cipherResponse = yield this.getCipher(id, (c) => c.type === _bitwarden_common_vault_enums__WEBPACK_IMPORTED_MODULE_15__.CipherType.Login && !_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isNullOrWhitespace(c.login.password));\n            if (!cipherResponse.success) {\n                return cipherResponse;\n            }\n            const cipher = cipherResponse.data;\n            if (cipher.type !== _bitwarden_common_vault_enums__WEBPACK_IMPORTED_MODULE_15__.CipherType.Login) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"Not a login.\");\n            }\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isNullOrWhitespace(cipher.login.password)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"No password available for this login.\");\n            }\n            const res = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_22__.StringResponse(cipher.login.password);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getUri(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const cipherResponse = yield this.getCipher(id, (c) => c.type === _bitwarden_common_vault_enums__WEBPACK_IMPORTED_MODULE_15__.CipherType.Login &&\n                c.login.uris != null &&\n                c.login.uris.length > 0 &&\n                c.login.uris[0].uri !== \"\");\n            if (!cipherResponse.success) {\n                return cipherResponse;\n            }\n            const cipher = cipherResponse.data;\n            if (cipher.type !== _bitwarden_common_vault_enums__WEBPACK_IMPORTED_MODULE_15__.CipherType.Login) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"Not a login.\");\n            }\n            if (cipher.login.uris == null ||\n                cipher.login.uris.length === 0 ||\n                cipher.login.uris[0].uri === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"No uri available for this login.\");\n            }\n            const res = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_22__.StringResponse(cipher.login.uris[0].uri);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getTotp(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const cipherResponse = yield this.getCipher(id, (c) => c.type === _bitwarden_common_vault_enums__WEBPACK_IMPORTED_MODULE_15__.CipherType.Login && !_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isNullOrWhitespace(c.login.totp));\n            if (!cipherResponse.success) {\n                return cipherResponse;\n            }\n            const cipher = cipherResponse.data;\n            if (cipher.type !== _bitwarden_common_vault_enums__WEBPACK_IMPORTED_MODULE_15__.CipherType.Login) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"Not a login.\");\n            }\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isNullOrWhitespace(cipher.login.totp)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"No TOTP available for this login.\");\n            }\n            const totp = yield this.totpService.getCode(cipher.login.totp);\n            if (totp == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"Couldn't generate TOTP code.\");\n            }\n            const canAccessPremium = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$);\n            if (!canAccessPremium) {\n                const originalCipher = yield this.cipherService.get(cipher.id);\n                if (originalCipher == null ||\n                    originalCipher.organizationId == null ||\n                    !originalCipher.organizationUseTotp) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"Premium status is required to use this feature.\");\n                }\n            }\n            const res = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_22__.StringResponse(totp);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getNotes(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const cipherResponse = yield this.getCipher(id, (c) => !_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isNullOrWhitespace(c.notes));\n            if (!cipherResponse.success) {\n                return cipherResponse;\n            }\n            const cipher = cipherResponse.data;\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isNullOrWhitespace(cipher.notes)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"No notes available for this item.\");\n            }\n            const res = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_22__.StringResponse(cipher.notes);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getExposed(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const passwordResponse = yield this.getPassword(id);\n            if (!passwordResponse.success) {\n                return passwordResponse;\n            }\n            const exposedNumber = yield this.auditService.passwordLeaked(passwordResponse.data.data);\n            const res = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_22__.StringResponse(exposedNumber.toString());\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getAttachment(id, options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (options.itemId == null || options.itemId === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"--itemid <itemid> required.\");\n            }\n            const itemId = options.itemId.toLowerCase();\n            const cipherResponse = yield this.getCipher(itemId);\n            if (!cipherResponse.success) {\n                return cipherResponse;\n            }\n            const cipher = yield this.getCipherView(itemId);\n            if (cipher == null ||\n                Array.isArray(cipher) ||\n                cipher.attachments == null ||\n                cipher.attachments.length === 0) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"No attachments available for this item.\");\n            }\n            let attachments = cipher.attachments.filter((a) => a.id.toLowerCase() === id ||\n                (a.fileName != null && a.fileName.toLowerCase().indexOf(id) > -1));\n            if (attachments.length === 0) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"Attachment `\" + id + \"` was not found.\");\n            }\n            const exactMatches = attachments.filter((a) => a.fileName.toLowerCase() === id);\n            if (exactMatches.length === 1) {\n                attachments = exactMatches;\n            }\n            if (attachments.length > 1) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.multipleResults(attachments.map((a) => a.id));\n            }\n            const canAccessPremium = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$);\n            if (!canAccessPremium) {\n                const originalCipher = yield this.cipherService.get(cipher.id);\n                if (originalCipher == null || originalCipher.organizationId == null) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(\"Premium status is required to use this feature.\");\n                }\n            }\n            let url;\n            try {\n                const attachmentDownloadResponse = yield this.apiService.getAttachmentData(cipher.id, attachments[0].id);\n                url = attachmentDownloadResponse.url;\n            }\n            catch (e) {\n                if (e instanceof _bitwarden_common_models_response_error_response__WEBPACK_IMPORTED_MODULE_11__.ErrorResponse && e.statusCode === 404) {\n                    url = attachments[0].url;\n                }\n                else if (e instanceof _bitwarden_common_models_response_error_response__WEBPACK_IMPORTED_MODULE_11__.ErrorResponse) {\n                    throw new Error(e.getSingleMessage());\n                }\n                else {\n                    throw e;\n                }\n            }\n            const key = attachments[0].key != null\n                ? attachments[0].key\n                : yield this.cryptoService.getOrgKey(cipher.organizationId);\n            return yield this.saveAttachmentToFile(url, key, attachments[0].fileName, options.output);\n        });\n    }\n    getFolder(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let decFolder = null;\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isGuid(id)) {\n                const folder = yield this.folderService.getFromState(id);\n                if (folder != null) {\n                    decFolder = yield folder.decrypt();\n                }\n            }\n            else if (id.trim() !== \"\") {\n                let folders = yield this.folderService.getAllDecryptedFromState();\n                folders = _utils__WEBPACK_IMPORTED_MODULE_25__.CliUtils.searchFolders(folders, id);\n                if (folders.length > 1) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.multipleResults(folders.map((f) => f.id));\n                }\n                if (folders.length > 0) {\n                    decFolder = folders[0];\n                }\n            }\n            if (decFolder == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.notFound();\n            }\n            const res = new _vault_models_folder_response__WEBPACK_IMPORTED_MODULE_28__.FolderResponse(decFolder);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getCollection(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let decCollection = null;\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isGuid(id)) {\n                const collection = yield this.collectionService.get(id);\n                if (collection != null) {\n                    const orgKeys = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.cryptoService.activeUserOrgKeys$);\n                    decCollection = yield collection.decrypt(orgKeys[collection.organizationId]);\n                }\n            }\n            else if (id.trim() !== \"\") {\n                let collections = yield this.collectionService.getAllDecrypted();\n                collections = _utils__WEBPACK_IMPORTED_MODULE_25__.CliUtils.searchCollections(collections, id);\n                if (collections.length > 1) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.multipleResults(collections.map((c) => c.id));\n                }\n                if (collections.length > 0) {\n                    decCollection = collections[0];\n                }\n            }\n            if (decCollection == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.notFound();\n            }\n            const res = new _vault_models_collection_response__WEBPACK_IMPORTED_MODULE_27__.CollectionResponse(decCollection);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getOrganizationCollection(id, options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (options.organizationId == null || options.organizationId === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"`organizationid` option is required.\");\n            }\n            if (!_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isGuid(id)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"`\" + id + \"` is not a GUID.\");\n            }\n            if (!_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isGuid(options.organizationId)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"`\" + options.organizationId + \"` is not a GUID.\");\n            }\n            try {\n                const orgKey = yield this.cryptoService.getOrgKey(options.organizationId);\n                if (orgKey == null) {\n                    throw new Error(\"No encryption key for this organization.\");\n                }\n                const response = yield this.apiService.getCollectionAccessDetails(options.organizationId, id);\n                const decCollection = new _bitwarden_common_vault_models_view_collection_view__WEBPACK_IMPORTED_MODULE_16__.CollectionView(response);\n                decCollection.name = yield this.cryptoService.decryptToUtf8(new _bitwarden_common_platform_models_domain_enc_string__WEBPACK_IMPORTED_MODULE_13__.EncString(response.name), orgKey);\n                const groups = response.groups == null\n                    ? null\n                    : response.groups.map((g) => new _admin_console_models_selection_read_only__WEBPACK_IMPORTED_MODULE_20__.SelectionReadOnly(g.id, g.readOnly, g.hidePasswords, g.manage));\n                const res = new _admin_console_models_response_organization_collection_response__WEBPACK_IMPORTED_MODULE_18__.OrganizationCollectionResponse(decCollection, groups);\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.error(e);\n            }\n        });\n    }\n    getOrganization(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let org = null;\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isGuid(id)) {\n                org = yield this.organizationService.getFromState(id);\n            }\n            else if (id.trim() !== \"\") {\n                let orgs = yield this.organizationService.getAll();\n                orgs = _utils__WEBPACK_IMPORTED_MODULE_25__.CliUtils.searchOrganizations(orgs, id);\n                if (orgs.length > 1) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.multipleResults(orgs.map((c) => c.id));\n                }\n                if (orgs.length > 0) {\n                    org = orgs[0];\n                }\n            }\n            if (org == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.notFound();\n            }\n            const res = new _admin_console_models_response_organization_response__WEBPACK_IMPORTED_MODULE_19__.OrganizationResponse(org);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getTemplate(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let template = null;\n            switch (id.toLowerCase()) {\n                case \"item\":\n                    template = _bitwarden_common_models_export_cipher_export__WEBPACK_IMPORTED_MODULE_3__.CipherExport.template();\n                    break;\n                case \"item.field\":\n                    template = _bitwarden_common_models_export_field_export__WEBPACK_IMPORTED_MODULE_5__.FieldExport.template();\n                    break;\n                case \"item.login\":\n                    template = _bitwarden_common_models_export_login_export__WEBPACK_IMPORTED_MODULE_9__.LoginExport.template();\n                    break;\n                case \"item.login.uri\":\n                    template = _bitwarden_common_models_export_login_uri_export__WEBPACK_IMPORTED_MODULE_8__.LoginUriExport.template();\n                    break;\n                case \"item.card\":\n                    template = _bitwarden_common_models_export_card_export__WEBPACK_IMPORTED_MODULE_2__.CardExport.template();\n                    break;\n                case \"item.identity\":\n                    template = _bitwarden_common_models_export_identity_export__WEBPACK_IMPORTED_MODULE_7__.IdentityExport.template();\n                    break;\n                case \"item.securenote\":\n                    template = _bitwarden_common_models_export_secure_note_export__WEBPACK_IMPORTED_MODULE_10__.SecureNoteExport.template();\n                    break;\n                case \"folder\":\n                    template = _bitwarden_common_models_export_folder_export__WEBPACK_IMPORTED_MODULE_6__.FolderExport.template();\n                    break;\n                case \"collection\":\n                    template = _bitwarden_common_models_export_collection_export__WEBPACK_IMPORTED_MODULE_4__.CollectionExport.template();\n                    break;\n                case \"item-collections\":\n                    template = [\"collection-id1\", \"collection-id2\"];\n                    break;\n                case \"org-collection\":\n                    template = _admin_console_models_request_organization_collection_request__WEBPACK_IMPORTED_MODULE_17__.OrganizationCollectionRequest.template();\n                    break;\n                case \"send.text\":\n                    template = _tools_send_models_send_response__WEBPACK_IMPORTED_MODULE_24__.SendResponse.template(_bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_14__.SendType.Text);\n                    break;\n                case \"send.file\":\n                    template = _tools_send_models_send_response__WEBPACK_IMPORTED_MODULE_24__.SendResponse.template(_bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_14__.SendType.File);\n                    break;\n                default:\n                    return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.badRequest(\"Unknown template object.\");\n            }\n            const res = new _models_response_template_response__WEBPACK_IMPORTED_MODULE_23__.TemplateResponse(template);\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n    getFingerprint(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let fingerprint = null;\n            if (id === \"me\") {\n                fingerprint = yield this.cryptoService.getFingerprint(yield this.stateService.getUserId());\n            }\n            else if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.isGuid(id)) {\n                try {\n                    const response = yield this.apiService.getUserPublicKey(id);\n                    const pubKey = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_12__.Utils.fromB64ToArray(response.publicKey);\n                    fingerprint = yield this.cryptoService.getFingerprint(id, pubKey);\n                }\n                catch (_a) {\n                    // eslint-disable-next-line\n                }\n            }\n            if (fingerprint == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.notFound();\n            }\n            const res = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_22__.StringResponse(fingerprint.join(\"-\"));\n            return _models_response__WEBPACK_IMPORTED_MODULE_21__.Response.success(res);\n        });\n    }\n}\nclass Options {\n    constructor(passedOptions) {\n        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);\n        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId);\n        this.output = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.output;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/get.command.ts\n");

/***/ }),

/***/ "./src/commands/list.command.ts":
/*!**************************************!*\
  !*** ./src/commands/list.command.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ListCommand: () => (/* binding */ ListCommand)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/enums */ \"../../libs/common/src/enums/index.ts\");\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_common_vault_models_data_collection_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/vault/models/data/collection.data */ \"../../libs/common/src/vault/models/data/collection.data.ts\");\n/* harmony import */ var _bitwarden_common_vault_models_domain_collection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/vault/models/domain/collection */ \"../../libs/common/src/vault/models/domain/collection.ts\");\n/* harmony import */ var _admin_console_models_response_organization_user_response__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../admin-console/models/response/organization-user.response */ \"./src/admin-console/models/response/organization-user.response.ts\");\n/* harmony import */ var _admin_console_models_response_organization_response__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../admin-console/models/response/organization.response */ \"./src/admin-console/models/response/organization.response.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_list_response__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../models/response/list.response */ \"./src/models/response/list.response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils */ \"./src/utils.ts\");\n/* harmony import */ var _vault_models_cipher_response__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../vault/models/cipher.response */ \"./src/vault/models/cipher.response.ts\");\n/* harmony import */ var _vault_models_collection_response__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../vault/models/collection.response */ \"./src/vault/models/collection.response.ts\");\n/* harmony import */ var _vault_models_folder_response__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../vault/models/folder.response */ \"./src/vault/models/folder.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\nclass ListCommand {\n    constructor(cipherService, folderService, collectionService, organizationService, searchService, organizationUserService, apiService, eventCollectionService) {\n        this.cipherService = cipherService;\n        this.folderService = folderService;\n        this.collectionService = collectionService;\n        this.organizationService = organizationService;\n        this.searchService = searchService;\n        this.organizationUserService = organizationUserService;\n        this.apiService = apiService;\n        this.eventCollectionService = eventCollectionService;\n    }\n    run(object, cmdOptions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const normalizedOptions = new Options(cmdOptions);\n            switch (object.toLowerCase()) {\n                case \"items\":\n                    return yield this.listCiphers(normalizedOptions);\n                case \"folders\":\n                    return yield this.listFolders(normalizedOptions);\n                case \"collections\":\n                    return yield this.listCollections(normalizedOptions);\n                case \"org-collections\":\n                    return yield this.listOrganizationCollections(normalizedOptions);\n                case \"org-members\":\n                    return yield this.listOrganizationMembers(normalizedOptions);\n                case \"organizations\":\n                    return yield this.listOrganizations(normalizedOptions);\n                default:\n                    return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.badRequest(\"Unknown object.\");\n            }\n        });\n    }\n    listCiphers(options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let ciphers;\n            options.trash = options.trash || false;\n            if (options.url != null && options.url.trim() !== \"\") {\n                ciphers = yield this.cipherService.getAllDecryptedForUrl(options.url);\n            }\n            else {\n                ciphers = yield this.cipherService.getAllDecrypted();\n            }\n            if (options.folderId != null ||\n                options.collectionId != null ||\n                options.organizationId != null) {\n                ciphers = ciphers.filter((c) => {\n                    if (options.trash !== c.isDeleted) {\n                        return false;\n                    }\n                    if (options.folderId != null) {\n                        if (options.folderId === \"notnull\" && c.folderId != null) {\n                            return true;\n                        }\n                        const folderId = options.folderId === \"null\" ? null : options.folderId;\n                        if (folderId === c.folderId) {\n                            return true;\n                        }\n                    }\n                    if (options.organizationId != null) {\n                        if (options.organizationId === \"notnull\" && c.organizationId != null) {\n                            return true;\n                        }\n                        const organizationId = options.organizationId === \"null\" ? null : options.organizationId;\n                        if (organizationId === c.organizationId) {\n                            return true;\n                        }\n                    }\n                    if (options.collectionId != null) {\n                        if (options.collectionId === \"notnull\" &&\n                            c.collectionIds != null &&\n                            c.collectionIds.length > 0) {\n                            return true;\n                        }\n                        const collectionId = options.collectionId === \"null\" ? null : options.collectionId;\n                        if (collectionId == null && (c.collectionIds == null || c.collectionIds.length === 0)) {\n                            return true;\n                        }\n                        if (collectionId != null &&\n                            c.collectionIds != null &&\n                            c.collectionIds.indexOf(collectionId) > -1) {\n                            return true;\n                        }\n                    }\n                    return false;\n                });\n            }\n            else if (options.search == null || options.search.trim() === \"\") {\n                ciphers = ciphers.filter((c) => options.trash === c.isDeleted);\n            }\n            if (options.search != null && options.search.trim() !== \"\") {\n                ciphers = this.searchService.searchCiphersBasic(ciphers, options.search, options.trash);\n            }\n            for (let i = 0; i < ciphers.length; i++) {\n                const c = ciphers[i];\n                // Set upload immediately on the last item in the ciphers collection to avoid the event collection\n                // service from uploading each time.\n                yield this.eventCollectionService.collect(_bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_0__.EventType.Cipher_ClientViewed, c.id, i === ciphers.length - 1, c.organizationId);\n            }\n            const res = new _models_response_list_response__WEBPACK_IMPORTED_MODULE_7__.ListResponse(ciphers.map((o) => new _vault_models_cipher_response__WEBPACK_IMPORTED_MODULE_9__.CipherResponse(o)));\n            return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.success(res);\n        });\n    }\n    listFolders(options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let folders = yield this.folderService.getAllDecryptedFromState();\n            if (options.search != null && options.search.trim() !== \"\") {\n                folders = _utils__WEBPACK_IMPORTED_MODULE_8__.CliUtils.searchFolders(folders, options.search);\n            }\n            const res = new _models_response_list_response__WEBPACK_IMPORTED_MODULE_7__.ListResponse(folders.map((o) => new _vault_models_folder_response__WEBPACK_IMPORTED_MODULE_11__.FolderResponse(o)));\n            return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.success(res);\n        });\n    }\n    listCollections(options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let collections = yield this.collectionService.getAllDecrypted();\n            if (options.organizationId != null) {\n                collections = collections.filter((c) => {\n                    if (options.organizationId === c.organizationId) {\n                        return true;\n                    }\n                    return false;\n                });\n            }\n            if (options.search != null && options.search.trim() !== \"\") {\n                collections = _utils__WEBPACK_IMPORTED_MODULE_8__.CliUtils.searchCollections(collections, options.search);\n            }\n            const res = new _models_response_list_response__WEBPACK_IMPORTED_MODULE_7__.ListResponse(collections.map((o) => new _vault_models_collection_response__WEBPACK_IMPORTED_MODULE_10__.CollectionResponse(o)));\n            return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.success(res);\n        });\n    }\n    listOrganizationCollections(options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (options.organizationId == null || options.organizationId === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.badRequest(\"`organizationid` option is required.\");\n            }\n            if (!_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.isGuid(options.organizationId)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.badRequest(\"`\" + options.organizationId + \"` is not a GUID.\");\n            }\n            const organization = yield this.organizationService.getFromState(options.organizationId);\n            if (organization == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.error(\"Organization not found.\");\n            }\n            try {\n                let response;\n                if (organization.canViewAllCollections) {\n                    response = yield this.apiService.getCollections(options.organizationId);\n                }\n                else {\n                    response = yield this.apiService.getUserCollections();\n                }\n                const collections = response.data\n                    .filter((c) => c.organizationId === options.organizationId)\n                    .map((r) => new _bitwarden_common_vault_models_domain_collection__WEBPACK_IMPORTED_MODULE_3__.Collection(new _bitwarden_common_vault_models_data_collection_data__WEBPACK_IMPORTED_MODULE_2__.CollectionData(r)));\n                let decCollections = yield this.collectionService.decryptMany(collections);\n                if (options.search != null && options.search.trim() !== \"\") {\n                    decCollections = _utils__WEBPACK_IMPORTED_MODULE_8__.CliUtils.searchCollections(decCollections, options.search);\n                }\n                const res = new _models_response_list_response__WEBPACK_IMPORTED_MODULE_7__.ListResponse(decCollections.map((o) => new _vault_models_collection_response__WEBPACK_IMPORTED_MODULE_10__.CollectionResponse(o)));\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.error(e);\n            }\n        });\n    }\n    listOrganizationMembers(options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (options.organizationId == null || options.organizationId === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.badRequest(\"`organizationid` option is required.\");\n            }\n            if (!_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.isGuid(options.organizationId)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.badRequest(\"`\" + options.organizationId + \"` is not a GUID.\");\n            }\n            const organization = yield this.organizationService.getFromState(options.organizationId);\n            if (organization == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.error(\"Organization not found.\");\n            }\n            try {\n                const response = yield this.organizationUserService.getAllUsers(options.organizationId);\n                const res = new _models_response_list_response__WEBPACK_IMPORTED_MODULE_7__.ListResponse(response.data.map((r) => {\n                    const u = new _admin_console_models_response_organization_user_response__WEBPACK_IMPORTED_MODULE_4__.OrganizationUserResponse();\n                    u.email = r.email;\n                    u.name = r.name;\n                    u.id = r.id;\n                    u.status = r.status;\n                    u.type = r.type;\n                    u.twoFactorEnabled = r.twoFactorEnabled;\n                    return u;\n                }));\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.error(e);\n            }\n        });\n    }\n    listOrganizations(options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let organizations = yield this.organizationService.getAll();\n            if (options.search != null && options.search.trim() !== \"\") {\n                organizations = _utils__WEBPACK_IMPORTED_MODULE_8__.CliUtils.searchOrganizations(organizations, options.search);\n            }\n            const res = new _models_response_list_response__WEBPACK_IMPORTED_MODULE_7__.ListResponse(organizations.map((o) => new _admin_console_models_response_organization_response__WEBPACK_IMPORTED_MODULE_5__.OrganizationResponse(o)));\n            return _models_response__WEBPACK_IMPORTED_MODULE_6__.Response.success(res);\n        });\n    }\n}\nclass Options {\n    constructor(passedOptions) {\n        this.organizationId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.organizationId);\n        this.collectionId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.collectionid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.collectionId);\n        this.folderId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.folderid) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.folderId);\n        this.search = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.search;\n        this.url = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.url;\n        this.trash = _utils__WEBPACK_IMPORTED_MODULE_8__.CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.trash);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/list.command.ts\n");

/***/ }),

/***/ "./src/commands/restore.command.ts":
/*!*****************************************!*\
  !*** ./src/commands/restore.command.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   RestoreCommand: () => (/* binding */ RestoreCommand)\n/* harmony export */ });\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\nclass RestoreCommand {\n    constructor(cipherService) {\n        this.cipherService = cipherService;\n    }\n    run(object, id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (id != null) {\n                id = id.toLowerCase();\n            }\n            switch (object.toLowerCase()) {\n                case \"item\":\n                    return yield this.restoreCipher(id);\n                default:\n                    return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.badRequest(\"Unknown object.\");\n            }\n        });\n    }\n    restoreCipher(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const cipher = yield this.cipherService.get(id);\n            if (cipher == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.notFound();\n            }\n            if (cipher.deletedDate == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.badRequest(\"Cipher is not in trash.\");\n            }\n            try {\n                yield this.cipherService.restoreWithServer(id);\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.success();\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.error(e);\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvY29tbWFuZHMvcmVzdG9yZS5jb21tYW5kLnRzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7O0FBRThDO0FBRXZDLE1BQU0sY0FBYztJQUN6QixZQUFvQixhQUE0QjtRQUE1QixrQkFBYSxHQUFiLGFBQWEsQ0FBZTtJQUFHLENBQUM7SUFFOUMsR0FBRyxDQUFDLE1BQWMsRUFBRSxFQUFVOztZQUNsQyxJQUFJLEVBQUUsSUFBSSxJQUFJLEVBQUU7Z0JBQ2QsRUFBRSxHQUFHLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQzthQUN2QjtZQUVELFFBQVEsTUFBTSxDQUFDLFdBQVcsRUFBRSxFQUFFO2dCQUM1QixLQUFLLE1BQU07b0JBQ1QsT0FBTyxNQUFNLElBQUksQ0FBQyxhQUFhLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ3RDO29CQUNFLE9BQU8sc0RBQVEsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQzthQUNqRDtRQUNILENBQUM7S0FBQTtJQUVhLGFBQWEsQ0FBQyxFQUFVOztZQUNwQyxNQUFNLE1BQU0sR0FBRyxNQUFNLElBQUksQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDO1lBQ2hELElBQUksTUFBTSxJQUFJLElBQUksRUFBRTtnQkFDbEIsT0FBTyxzREFBUSxDQUFDLFFBQVEsRUFBRSxDQUFDO2FBQzVCO1lBQ0QsSUFBSSxNQUFNLENBQUMsV0FBVyxJQUFJLElBQUksRUFBRTtnQkFDOUIsT0FBTyxzREFBUSxDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO2FBQ3ZEO1lBRUQsSUFBSTtnQkFDRixNQUFNLElBQUksQ0FBQyxhQUFhLENBQUMsaUJBQWlCLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQy9DLE9BQU8sc0RBQVEsQ0FBQyxPQUFPLEVBQUUsQ0FBQzthQUMzQjtZQUFDLE9BQU8sQ0FBQyxFQUFFO2dCQUNWLE9BQU8sc0RBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7YUFDMUI7UUFDSCxDQUFDO0tBQUE7Q0FDRiIsInNvdXJjZXMiOlsid2VicGFjazovL0BiaXR3YXJkZW4vY2xpLy4vc3JjL2NvbW1hbmRzL3Jlc3RvcmUuY29tbWFuZC50cz82OWFlIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENpcGhlclNlcnZpY2UgfSBmcm9tIFwiQGJpdHdhcmRlbi9jb21tb24vdmF1bHQvYWJzdHJhY3Rpb25zL2NpcGhlci5zZXJ2aWNlXCI7XG5cbmltcG9ydCB7IFJlc3BvbnNlIH0gZnJvbSBcIi4uL21vZGVscy9yZXNwb25zZVwiO1xuXG5leHBvcnQgY2xhc3MgUmVzdG9yZUNvbW1hbmQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIGNpcGhlclNlcnZpY2U6IENpcGhlclNlcnZpY2UpIHt9XG5cbiAgYXN5bmMgcnVuKG9iamVjdDogc3RyaW5nLCBpZDogc3RyaW5nKTogUHJvbWlzZTxSZXNwb25zZT4ge1xuICAgIGlmIChpZCAhPSBudWxsKSB7XG4gICAgICBpZCA9IGlkLnRvTG93ZXJDYXNlKCk7XG4gICAgfVxuXG4gICAgc3dpdGNoIChvYmplY3QudG9Mb3dlckNhc2UoKSkge1xuICAgICAgY2FzZSBcIml0ZW1cIjpcbiAgICAgICAgcmV0dXJuIGF3YWl0IHRoaXMucmVzdG9yZUNpcGhlcihpZCk7XG4gICAgICBkZWZhdWx0OlxuICAgICAgICByZXR1cm4gUmVzcG9uc2UuYmFkUmVxdWVzdChcIlVua25vd24gb2JqZWN0LlwiKTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIGFzeW5jIHJlc3RvcmVDaXBoZXIoaWQ6IHN0cmluZykge1xuICAgIGNvbnN0IGNpcGhlciA9IGF3YWl0IHRoaXMuY2lwaGVyU2VydmljZS5nZXQoaWQpO1xuICAgIGlmIChjaXBoZXIgPT0gbnVsbCkge1xuICAgICAgcmV0dXJuIFJlc3BvbnNlLm5vdEZvdW5kKCk7XG4gICAgfVxuICAgIGlmIChjaXBoZXIuZGVsZXRlZERhdGUgPT0gbnVsbCkge1xuICAgICAgcmV0dXJuIFJlc3BvbnNlLmJhZFJlcXVlc3QoXCJDaXBoZXIgaXMgbm90IGluIHRyYXNoLlwiKTtcbiAgICB9XG5cbiAgICB0cnkge1xuICAgICAgYXdhaXQgdGhpcy5jaXBoZXJTZXJ2aWNlLnJlc3RvcmVXaXRoU2VydmVyKGlkKTtcbiAgICAgIHJldHVybiBSZXNwb25zZS5zdWNjZXNzKCk7XG4gICAgfSBjYXRjaCAoZSkge1xuICAgICAgcmV0dXJuIFJlc3BvbnNlLmVycm9yKGUpO1xuICAgIH1cbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/commands/restore.command.ts\n");

/***/ }),

/***/ "./src/commands/serve.command.ts":
/*!***************************************!*\
  !*** ./src/commands/serve.command.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ServeCommand: () => (/* binding */ ServeCommand)\n/* harmony export */ });\n/* harmony import */ var _koa_multer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @koa/multer */ \"@koa/multer\");\n/* harmony import */ var _koa_multer__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_koa_multer__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _koa_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @koa/router */ \"@koa/router\");\n/* harmony import */ var _koa_router__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_koa_router__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var koa__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! koa */ \"koa\");\n/* harmony import */ var koa__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(koa__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var koa_bodyparser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! koa-bodyparser */ \"koa-bodyparser\");\n/* harmony import */ var koa_bodyparser__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(koa_bodyparser__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var koa_json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! koa-json */ \"koa-json\");\n/* harmony import */ var koa_json__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(koa_json__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _admin_console_commands_confirm_command__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../admin-console/commands/confirm.command */ \"./src/admin-console/commands/confirm.command.ts\");\n/* harmony import */ var _admin_console_commands_share_command__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../admin-console/commands/share.command */ \"./src/admin-console/commands/share.command.ts\");\n/* harmony import */ var _auth_commands_lock_command__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../auth/commands/lock.command */ \"./src/auth/commands/lock.command.ts\");\n/* harmony import */ var _auth_commands_unlock_command__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../auth/commands/unlock.command */ \"./src/auth/commands/unlock.command.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_file_response__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../models/response/file.response */ \"./src/models/response/file.response.ts\");\n/* harmony import */ var _tools_generate_command__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../tools/generate.command */ \"./src/tools/generate.command.ts\");\n/* harmony import */ var _tools_send__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../tools/send */ \"./src/tools/send/index.ts\");\n/* harmony import */ var _vault_create_command__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../vault/create.command */ \"./src/vault/create.command.ts\");\n/* harmony import */ var _vault_delete_command__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../vault/delete.command */ \"./src/vault/delete.command.ts\");\n/* harmony import */ var _vault_sync_command__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../vault/sync.command */ \"./src/vault/sync.command.ts\");\n/* harmony import */ var _edit_command__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./edit.command */ \"./src/commands/edit.command.ts\");\n/* harmony import */ var _get_command__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./get.command */ \"./src/commands/get.command.ts\");\n/* harmony import */ var _list_command__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./list.command */ \"./src/commands/list.command.ts\");\n/* harmony import */ var _restore_command__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./restore.command */ \"./src/commands/restore.command.ts\");\n/* harmony import */ var _status_command__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./status.command */ \"./src/commands/status.command.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nclass ServeCommand {\n    constructor(serviceContainer) {\n        this.serviceContainer = serviceContainer;\n        this.getCommand = new _get_command__WEBPACK_IMPORTED_MODULE_18__.GetCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.totpService, this.serviceContainer.auditService, this.serviceContainer.cryptoService, this.serviceContainer.stateService, this.serviceContainer.searchService, this.serviceContainer.apiService, this.serviceContainer.organizationService, this.serviceContainer.eventCollectionService, this.serviceContainer.billingAccountProfileStateService);\n        this.listCommand = new _list_command__WEBPACK_IMPORTED_MODULE_19__.ListCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.organizationService, this.serviceContainer.searchService, this.serviceContainer.organizationUserService, this.serviceContainer.apiService, this.serviceContainer.eventCollectionService);\n        this.createCommand = new _vault_create_command__WEBPACK_IMPORTED_MODULE_14__.CreateCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.cryptoService, this.serviceContainer.apiService, this.serviceContainer.folderApiService, this.serviceContainer.billingAccountProfileStateService);\n        this.editCommand = new _edit_command__WEBPACK_IMPORTED_MODULE_17__.EditCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.cryptoService, this.serviceContainer.apiService, this.serviceContainer.folderApiService);\n        this.generateCommand = new _tools_generate_command__WEBPACK_IMPORTED_MODULE_12__.GenerateCommand(this.serviceContainer.passwordGenerationService, this.serviceContainer.stateService);\n        this.syncCommand = new _vault_sync_command__WEBPACK_IMPORTED_MODULE_16__.SyncCommand(this.serviceContainer.syncService);\n        this.statusCommand = new _status_command__WEBPACK_IMPORTED_MODULE_21__.StatusCommand(this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.accountService, this.serviceContainer.authService);\n        this.deleteCommand = new _vault_delete_command__WEBPACK_IMPORTED_MODULE_15__.DeleteCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.apiService, this.serviceContainer.folderApiService, this.serviceContainer.billingAccountProfileStateService);\n        this.confirmCommand = new _admin_console_commands_confirm_command__WEBPACK_IMPORTED_MODULE_6__.ConfirmCommand(this.serviceContainer.apiService, this.serviceContainer.cryptoService, this.serviceContainer.organizationUserService);\n        this.restoreCommand = new _restore_command__WEBPACK_IMPORTED_MODULE_20__.RestoreCommand(this.serviceContainer.cipherService);\n        this.shareCommand = new _admin_console_commands_share_command__WEBPACK_IMPORTED_MODULE_7__.ShareCommand(this.serviceContainer.cipherService);\n        this.lockCommand = new _auth_commands_lock_command__WEBPACK_IMPORTED_MODULE_8__.LockCommand(this.serviceContainer.vaultTimeoutService);\n        this.unlockCommand = new _auth_commands_unlock_command__WEBPACK_IMPORTED_MODULE_9__.UnlockCommand(this.serviceContainer.accountService, this.serviceContainer.masterPasswordService, this.serviceContainer.cryptoService, this.serviceContainer.stateService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.apiService, this.serviceContainer.logService, this.serviceContainer.keyConnectorService, this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.organizationApiService, () => __awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }), this.serviceContainer.kdfConfigService);\n        this.sendCreateCommand = new _tools_send__WEBPACK_IMPORTED_MODULE_13__.SendCreateCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService);\n        this.sendDeleteCommand = new _tools_send__WEBPACK_IMPORTED_MODULE_13__.SendDeleteCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService);\n        this.sendGetCommand = new _tools_send__WEBPACK_IMPORTED_MODULE_13__.SendGetCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService, this.serviceContainer.cryptoService);\n        this.sendEditCommand = new _tools_send__WEBPACK_IMPORTED_MODULE_13__.SendEditCommand(this.serviceContainer.sendService, this.sendGetCommand, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService);\n        this.sendListCommand = new _tools_send__WEBPACK_IMPORTED_MODULE_13__.SendListCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService);\n        this.sendRemovePasswordCommand = new _tools_send__WEBPACK_IMPORTED_MODULE_13__.SendRemovePasswordCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService, this.serviceContainer.environmentService);\n    }\n    run(options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const protectOrigin = !options.disableOriginProtection;\n            const port = options.port || 8087;\n            const hostname = options.hostname || \"localhost\";\n            this.serviceContainer.logService.info(`Starting server on ${hostname}:${port} with ${protectOrigin ? \"origin protection\" : \"no origin protection\"}`);\n            const server = new koa__WEBPACK_IMPORTED_MODULE_2__();\n            const router = new _koa_router__WEBPACK_IMPORTED_MODULE_1__();\n            process.env.BW_SERVE = \"true\";\n            process.env.BW_NOINTERACTION = \"true\";\n            server\n                .use((ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (protectOrigin && ctx.headers.origin != undefined) {\n                    ctx.status = 403;\n                    this.serviceContainer.logService.warning(`Blocking request from \"${_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_5__.Utils.isNullOrEmpty(ctx.headers.origin)\n                        ? \"(Origin header value missing)\"\n                        : ctx.headers.origin}\"`);\n                    return;\n                }\n                yield next();\n            }))\n                .use(koa_bodyparser__WEBPACK_IMPORTED_MODULE_3__())\n                .use(koa_json__WEBPACK_IMPORTED_MODULE_4__({ pretty: false, param: \"pretty\" }));\n            router.get(\"/generate\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                const response = yield this.generateCommand.run(ctx.request.query);\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.get(\"/status\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                const response = yield this.statusCommand.run();\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.get(\"/list/object/:object\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                let response = null;\n                if (ctx.params.object === \"send\") {\n                    response = yield this.sendListCommand.run(ctx.request.query);\n                }\n                else {\n                    response = yield this.listCommand.run(ctx.params.object, ctx.request.query);\n                }\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.get(\"/send/list\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                const response = yield this.sendListCommand.run(ctx.request.query);\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.post(\"/sync\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                const response = yield this.syncCommand.run(ctx.request.query);\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.post(\"/lock\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                const response = yield this.lockCommand.run();\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.post(\"/unlock\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                // Do not allow guessing password location through serve command\n                delete ctx.request.query.passwordFile;\n                delete ctx.request.query.passwordEnv;\n                const response = yield this.unlockCommand.run(ctx.request.body.password == null ? null : ctx.request.body.password, ctx.request.query);\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.post(\"/confirm/:object/:id\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                const response = yield this.confirmCommand.run(ctx.params.object, ctx.params.id, ctx.request.query);\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.post(\"/restore/:object/:id\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                const response = yield this.restoreCommand.run(ctx.params.object, ctx.params.id);\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.post(\"/move/:id/:organizationId\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                const response = yield this.shareCommand.run(ctx.params.id, ctx.params.organizationId, ctx.request.body);\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.post(\"/attachment\", _koa_multer__WEBPACK_IMPORTED_MODULE_0__().single(\"file\"), (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                const response = yield this.createCommand.run(\"attachment\", ctx.request.body, ctx.request.query, {\n                    fileBuffer: ctx.request.file.buffer,\n                    fileName: ctx.request.file.originalname,\n                });\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.post(\"/send/:id/remove-password\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                const response = yield this.sendRemovePasswordCommand.run(ctx.params.id);\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.post(\"/object/:object\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                let response = null;\n                if (ctx.params.object === \"send\") {\n                    response = yield this.sendCreateCommand.run(ctx.request.body, ctx.request.query);\n                }\n                else {\n                    response = yield this.createCommand.run(ctx.params.object, ctx.request.body, ctx.request.query);\n                }\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.put(\"/object/:object/:id\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                let response = null;\n                if (ctx.params.object === \"send\") {\n                    ctx.request.body.id = ctx.params.id;\n                    response = yield this.sendEditCommand.run(ctx.request.body, ctx.request.query);\n                }\n                else {\n                    response = yield this.editCommand.run(ctx.params.object, ctx.params.id, ctx.request.body, ctx.request.query);\n                }\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.get(\"/object/:object/:id\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                let response = null;\n                if (ctx.params.object === \"send\") {\n                    response = yield this.sendGetCommand.run(ctx.params.id, null);\n                }\n                else {\n                    response = yield this.getCommand.run(ctx.params.object, ctx.params.id, ctx.request.query);\n                }\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            router.delete(\"/object/:object/:id\", (ctx, next) => __awaiter(this, void 0, void 0, function* () {\n                if (yield this.errorIfLocked(ctx.response)) {\n                    yield next();\n                    return;\n                }\n                let response = null;\n                if (ctx.params.object === \"send\") {\n                    response = yield this.sendDeleteCommand.run(ctx.params.id);\n                }\n                else {\n                    response = yield this.deleteCommand.run(ctx.params.object, ctx.params.id, ctx.request.query);\n                }\n                this.processResponse(ctx.response, response);\n                yield next();\n            }));\n            server\n                .use(router.routes())\n                .use(router.allowedMethods())\n                .listen(port, hostname === \"all\" ? null : hostname, () => {\n                this.serviceContainer.logService.info(\"Listening on \" + hostname + \":\" + port);\n            });\n        });\n    }\n    processResponse(res, commandResponse) {\n        if (!commandResponse.success) {\n            res.status = 400;\n        }\n        if (commandResponse.data instanceof _models_response_file_response__WEBPACK_IMPORTED_MODULE_11__.FileResponse) {\n            res.body = commandResponse.data.data;\n            res.attachment(commandResponse.data.fileName);\n            res.set(\"Content-Type\", \"application/octet-stream\");\n            res.set(\"Content-Length\", commandResponse.data.data.length.toString());\n        }\n        else {\n            res.body = commandResponse;\n        }\n    }\n    errorIfLocked(res) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const authed = yield this.serviceContainer.stateService.getIsAuthenticated();\n            if (!authed) {\n                this.processResponse(res, _models_response__WEBPACK_IMPORTED_MODULE_10__.Response.error(\"You are not logged in.\"));\n                return true;\n            }\n            if (yield this.serviceContainer.cryptoService.hasUserKey()) {\n                return false;\n            }\n            this.processResponse(res, _models_response__WEBPACK_IMPORTED_MODULE_10__.Response.error(\"Vault is locked.\"));\n            return true;\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/serve.command.ts\n");

/***/ }),

/***/ "./src/commands/status.command.ts":
/*!****************************************!*\
  !*** ./src/commands/status.command.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   StatusCommand: () => (/* binding */ StatusCommand)\n/* harmony export */ });\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_auth_enums_authentication_status__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/auth/enums/authentication-status */ \"../../libs/common/src/auth/enums/authentication-status.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_template_response__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/response/template.response */ \"./src/models/response/template.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass StatusCommand {\n    constructor(envService, syncService, accountService, authService) {\n        this.envService = envService;\n        this.syncService = syncService;\n        this.accountService = accountService;\n        this.authService = authService;\n    }\n    run() {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const baseUrl = yield this.baseUrl();\n                const status = yield this.status();\n                const lastSync = yield this.syncService.getLastSync();\n                const [userId, email] = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.accountService.activeAccount$.pipe((0,rxjs__WEBPACK_IMPORTED_MODULE_0__.map)((a) => [a === null || a === void 0 ? void 0 : a.id, a === null || a === void 0 ? void 0 : a.email])));\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.success(new _models_response_template_response__WEBPACK_IMPORTED_MODULE_3__.TemplateResponse({\n                    serverUrl: baseUrl,\n                    lastSync: lastSync,\n                    userEmail: email,\n                    userId: userId,\n                    status: status,\n                }));\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.error(e);\n            }\n        });\n    }\n    baseUrl() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const env = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.envService.environment$);\n            return env.getUrls().base;\n        });\n    }\n    status() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const authStatus = yield this.authService.getAuthStatus();\n            if (authStatus === _bitwarden_common_auth_enums_authentication_status__WEBPACK_IMPORTED_MODULE_1__.AuthenticationStatus.Unlocked) {\n                return \"unlocked\";\n            }\n            else if (authStatus === _bitwarden_common_auth_enums_authentication_status__WEBPACK_IMPORTED_MODULE_1__.AuthenticationStatus.Locked) {\n                return \"locked\";\n            }\n            else {\n                return \"unauthenticated\";\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/status.command.ts\n");

/***/ }),

/***/ "./src/commands/update.command.ts":
/*!****************************************!*\
  !*** ./src/commands/update.command.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   UpdateCommand: () => (/* binding */ UpdateCommand)\n/* harmony export */ });\n/* harmony import */ var node_fetch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! node-fetch */ \"node-fetch\");\n/* harmony import */ var node_fetch__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(node_fetch__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/response/message.response */ \"./src/models/response/message.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nconst CLIENTS_RELEASE_LIST_ENDPOINT = \"https://api.github.com/repos/bitwarden/clients/releases\";\nconst DEFAULT_DOWNLOAD_URL = \"https://github.com/bitwarden/clients/releases\";\nconst UPDATE_COMMAND = \"npm install -g @bitwarden/cli\";\nclass UpdateCommand {\n    constructor(platformUtilsService) {\n        this.platformUtilsService = platformUtilsService;\n        this.inPkg = false;\n        this.inPkg = !!process.pkg;\n    }\n    run() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const response = yield node_fetch__WEBPACK_IMPORTED_MODULE_0___default()(CLIENTS_RELEASE_LIST_ENDPOINT);\n            if (response.status !== 200) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.error(\"Error contacting update API: \" + response.status);\n            }\n            const responseJson = yield response.json();\n            const cliRelease = responseJson.find((r) => r.tag_name.includes(\"cli\"));\n            if (cliRelease === undefined || cliRelease === null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.error(\"Could not find latest CLI version.\");\n            }\n            const currentVersion = yield this.platformUtilsService.getApplicationVersion();\n            if (cliRelease.tag_name === \"cli-v\" + currentVersion) {\n                const response = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_2__.MessageResponse(null, null);\n                response.title = \"No update available.\";\n                response.noColor = true;\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.success(response);\n            }\n            const res = this.getFoundUpdateResponse(cliRelease);\n            return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.success(res);\n        });\n    }\n    getFoundUpdateResponse(release) {\n        const downloadUrl = this.getDownloadUrl(release.assets);\n        const response = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_2__.MessageResponse(null, null);\n        response.title = \"A new version is available: \" + release.tag_name;\n        response.raw = downloadUrl;\n        response.message = this.getMessage(release, downloadUrl);\n        return response;\n    }\n    getMessage(release, downloadUrl) {\n        let message = \"\";\n        if (release.body != null && release.body !== \"\") {\n            message = release.body + \"\\n\\n\";\n        }\n        message += \"You can download this update at \" + downloadUrl;\n        if (this.inPkg) {\n            message +=\n                \"\\n\\nIf you installed this CLI through a package manager \" +\n                    \"you should probably update using its update command instead.\";\n        }\n        else {\n            message +=\n                \"\\n\\nIf you installed this CLI through NPM \" +\n                    \"you should update using `\" +\n                    UPDATE_COMMAND +\n                    \"`\";\n        }\n        return message;\n    }\n    getDownloadUrl(assets) {\n        if (assets == null) {\n            return DEFAULT_DOWNLOAD_URL;\n        }\n        let downloadUrl = DEFAULT_DOWNLOAD_URL;\n        for (const a of assets) {\n            const download = a.browser_download_url;\n            if (download == null) {\n                continue;\n            }\n            if (download.indexOf(\".zip\") === -1) {\n                continue;\n            }\n            if (process.platform === \"win32\" && download.indexOf(\"bw-windows\") > -1) {\n                downloadUrl = download;\n                break;\n            }\n            else if (process.platform === \"darwin\" && download.indexOf(\"bw-macos\") > -1) {\n                downloadUrl = download;\n                break;\n            }\n            else if (process.platform === \"linux\" && download.indexOf(\"bw-linux\") > -1) {\n                downloadUrl = download;\n                break;\n            }\n        }\n        return downloadUrl;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/commands/update.command.ts\n");

/***/ }),

/***/ "./src/models/response.ts":
/*!********************************!*\
  !*** ./src/models/response.ts ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Response: () => (/* binding */ Response)\n/* harmony export */ });\nclass Response {\n    static error(error, data) {\n        const res = new Response();\n        res.success = false;\n        if (typeof error === \"string\") {\n            res.message = error;\n        }\n        else {\n            res.message =\n                error.message != null\n                    ? error.message\n                    : error.toString() === \"[object Object]\"\n                        ? JSON.stringify(error)\n                        : error.toString();\n        }\n        res.data = data;\n        return res;\n    }\n    static notFound() {\n        return Response.error(\"Not found.\");\n    }\n    static badRequest(message) {\n        return Response.error(message);\n    }\n    static multipleResults(ids) {\n        let msg = \"More than one result was found. Try getting a specific object by `id` instead. \" +\n            \"The following objects were found:\";\n        ids.forEach((id) => {\n            msg += \"\\n\" + id;\n        });\n        return Response.error(msg, ids);\n    }\n    static success(data) {\n        const res = new Response();\n        res.success = true;\n        res.data = data;\n        return res;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/models/response.ts\n");

/***/ }),

/***/ "./src/models/response/file.response.ts":
/*!**********************************************!*\
  !*** ./src/models/response/file.response.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FileResponse: () => (/* binding */ FileResponse)\n/* harmony export */ });\nclass FileResponse {\n    constructor(data, fileName) {\n        this.object = \"file\";\n        this.data = data;\n        this.fileName = fileName;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvbW9kZWxzL3Jlc3BvbnNlL2ZpbGUucmVzcG9uc2UudHMiLCJtYXBwaW5ncyI6Ijs7OztBQUVPLE1BQU0sWUFBWTtJQUt2QixZQUFZLElBQVksRUFBRSxRQUFnQjtRQUN4QyxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztRQUNyQixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztJQUMzQixDQUFDO0NBQ0YiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9AYml0d2FyZGVuL2NsaS8uL3NyYy9tb2RlbHMvcmVzcG9uc2UvZmlsZS5yZXNwb25zZS50cz9jZDQxIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEJhc2VSZXNwb25zZSB9IGZyb20gXCIuL2Jhc2UucmVzcG9uc2VcIjtcblxuZXhwb3J0IGNsYXNzIEZpbGVSZXNwb25zZSBpbXBsZW1lbnRzIEJhc2VSZXNwb25zZSB7XG4gIG9iamVjdDogc3RyaW5nO1xuICBkYXRhOiBCdWZmZXI7XG4gIGZpbGVOYW1lOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IoZGF0YTogQnVmZmVyLCBmaWxlTmFtZTogc3RyaW5nKSB7XG4gICAgdGhpcy5vYmplY3QgPSBcImZpbGVcIjtcbiAgICB0aGlzLmRhdGEgPSBkYXRhO1xuICAgIHRoaXMuZmlsZU5hbWUgPSBmaWxlTmFtZTtcbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/models/response/file.response.ts\n");

/***/ }),

/***/ "./src/models/response/list.response.ts":
/*!**********************************************!*\
  !*** ./src/models/response/list.response.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ListResponse: () => (/* binding */ ListResponse)\n/* harmony export */ });\nclass ListResponse {\n    constructor(data) {\n        this.object = \"list\";\n        this.data = data;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvbW9kZWxzL3Jlc3BvbnNlL2xpc3QucmVzcG9uc2UudHMiLCJtYXBwaW5ncyI6Ijs7OztBQUVPLE1BQU0sWUFBWTtJQUl2QixZQUFZLElBQW9CO1FBQzlCLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO0lBQ25CLENBQUM7Q0FDRiIsInNvdXJjZXMiOlsid2VicGFjazovL0BiaXR3YXJkZW4vY2xpLy4vc3JjL21vZGVscy9yZXNwb25zZS9saXN0LnJlc3BvbnNlLnRzPzAxMjYiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQmFzZVJlc3BvbnNlIH0gZnJvbSBcIi4vYmFzZS5yZXNwb25zZVwiO1xuXG5leHBvcnQgY2xhc3MgTGlzdFJlc3BvbnNlIGltcGxlbWVudHMgQmFzZVJlc3BvbnNlIHtcbiAgb2JqZWN0OiBzdHJpbmc7XG4gIGRhdGE6IEJhc2VSZXNwb25zZVtdO1xuXG4gIGNvbnN0cnVjdG9yKGRhdGE6IEJhc2VSZXNwb25zZVtdKSB7XG4gICAgdGhpcy5vYmplY3QgPSBcImxpc3RcIjtcbiAgICB0aGlzLmRhdGEgPSBkYXRhO1xuICB9XG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./src/models/response/list.response.ts\n");

/***/ }),

/***/ "./src/models/response/login.response.ts":
/*!***********************************************!*\
  !*** ./src/models/response/login.response.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LoginResponse: () => (/* binding */ LoginResponse)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_models_export_login_export__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/models/export/login.export */ \"../../libs/common/src/models/export/login.export.ts\");\n\nclass LoginResponse extends _bitwarden_common_models_export_login_export__WEBPACK_IMPORTED_MODULE_0__.LoginExport {\n    constructor(o) {\n        super(o);\n        this.passwordRevisionDate = o.passwordRevisionDate != null ? o.passwordRevisionDate : null;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvbW9kZWxzL3Jlc3BvbnNlL2xvZ2luLnJlc3BvbnNlLnRzIiwibWFwcGluZ3MiOiI7Ozs7O0FBQTJFO0FBR3BFLE1BQU0sYUFBYyxTQUFRLHFGQUFXO0lBRzVDLFlBQVksQ0FBWTtRQUN0QixLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDVCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsQ0FBQyxDQUFDLG9CQUFvQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7SUFDN0YsQ0FBQztDQUNGIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQGJpdHdhcmRlbi9jbGkvLi9zcmMvbW9kZWxzL3Jlc3BvbnNlL2xvZ2luLnJlc3BvbnNlLnRzPzk5OTkiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgTG9naW5FeHBvcnQgfSBmcm9tIFwiQGJpdHdhcmRlbi9jb21tb24vbW9kZWxzL2V4cG9ydC9sb2dpbi5leHBvcnRcIjtcbmltcG9ydCB7IExvZ2luVmlldyB9IGZyb20gXCJAYml0d2FyZGVuL2NvbW1vbi92YXVsdC9tb2RlbHMvdmlldy9sb2dpbi52aWV3XCI7XG5cbmV4cG9ydCBjbGFzcyBMb2dpblJlc3BvbnNlIGV4dGVuZHMgTG9naW5FeHBvcnQge1xuICBwYXNzd29yZFJldmlzaW9uRGF0ZTogRGF0ZTtcblxuICBjb25zdHJ1Y3RvcihvOiBMb2dpblZpZXcpIHtcbiAgICBzdXBlcihvKTtcbiAgICB0aGlzLnBhc3N3b3JkUmV2aXNpb25EYXRlID0gby5wYXNzd29yZFJldmlzaW9uRGF0ZSAhPSBudWxsID8gby5wYXNzd29yZFJldmlzaW9uRGF0ZSA6IG51bGw7XG4gIH1cbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./src/models/response/login.response.ts\n");

/***/ }),

/***/ "./src/models/response/message.response.ts":
/*!*************************************************!*\
  !*** ./src/models/response/message.response.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   MessageResponse: () => (/* binding */ MessageResponse)\n/* harmony export */ });\nclass MessageResponse {\n    constructor(title, message) {\n        this.noColor = false;\n        this.object = \"message\";\n        this.title = title;\n        this.message = message;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvbW9kZWxzL3Jlc3BvbnNlL21lc3NhZ2UucmVzcG9uc2UudHMiLCJtYXBwaW5ncyI6Ijs7OztBQUVPLE1BQU0sZUFBZTtJQU8xQixZQUFZLEtBQWEsRUFBRSxPQUFlO1FBRjFDLFlBQU8sR0FBRyxLQUFLLENBQUM7UUFHZCxJQUFJLENBQUMsTUFBTSxHQUFHLFNBQVMsQ0FBQztRQUN4QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztJQUN6QixDQUFDO0NBQ0YiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9AYml0d2FyZGVuL2NsaS8uL3NyYy9tb2RlbHMvcmVzcG9uc2UvbWVzc2FnZS5yZXNwb25zZS50cz9mZWZmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEJhc2VSZXNwb25zZSB9IGZyb20gXCIuL2Jhc2UucmVzcG9uc2VcIjtcblxuZXhwb3J0IGNsYXNzIE1lc3NhZ2VSZXNwb25zZSBpbXBsZW1lbnRzIEJhc2VSZXNwb25zZSB7XG4gIG9iamVjdDogc3RyaW5nO1xuICB0aXRsZTogc3RyaW5nO1xuICBtZXNzYWdlOiBzdHJpbmc7XG4gIHJhdzogc3RyaW5nO1xuICBub0NvbG9yID0gZmFsc2U7XG5cbiAgY29uc3RydWN0b3IodGl0bGU6IHN0cmluZywgbWVzc2FnZTogc3RyaW5nKSB7XG4gICAgdGhpcy5vYmplY3QgPSBcIm1lc3NhZ2VcIjtcbiAgICB0aGlzLnRpdGxlID0gdGl0bGU7XG4gICAgdGhpcy5tZXNzYWdlID0gbWVzc2FnZTtcbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/models/response/message.response.ts\n");

/***/ }),

/***/ "./src/models/response/string.response.ts":
/*!************************************************!*\
  !*** ./src/models/response/string.response.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   StringResponse: () => (/* binding */ StringResponse)\n/* harmony export */ });\nclass StringResponse {\n    constructor(data) {\n        this.object = \"string\";\n        this.data = data;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvbW9kZWxzL3Jlc3BvbnNlL3N0cmluZy5yZXNwb25zZS50cyIsIm1hcHBpbmdzIjoiOzs7O0FBRU8sTUFBTSxjQUFjO0lBSXpCLFlBQVksSUFBWTtRQUN0QixJQUFJLENBQUMsTUFBTSxHQUFHLFFBQVEsQ0FBQztRQUN2QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUNuQixDQUFDO0NBQ0YiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9AYml0d2FyZGVuL2NsaS8uL3NyYy9tb2RlbHMvcmVzcG9uc2Uvc3RyaW5nLnJlc3BvbnNlLnRzP2E0Y2IiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQmFzZVJlc3BvbnNlIH0gZnJvbSBcIi4vYmFzZS5yZXNwb25zZVwiO1xuXG5leHBvcnQgY2xhc3MgU3RyaW5nUmVzcG9uc2UgaW1wbGVtZW50cyBCYXNlUmVzcG9uc2Uge1xuICBvYmplY3Q6IHN0cmluZztcbiAgZGF0YTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKGRhdGE6IHN0cmluZykge1xuICAgIHRoaXMub2JqZWN0ID0gXCJzdHJpbmdcIjtcbiAgICB0aGlzLmRhdGEgPSBkYXRhO1xuICB9XG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./src/models/response/string.response.ts\n");

/***/ }),

/***/ "./src/models/response/template.response.ts":
/*!**************************************************!*\
  !*** ./src/models/response/template.response.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TemplateResponse: () => (/* binding */ TemplateResponse)\n/* harmony export */ });\nclass TemplateResponse {\n    constructor(template) {\n        this.object = \"template\";\n        this.template = template;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvbW9kZWxzL3Jlc3BvbnNlL3RlbXBsYXRlLnJlc3BvbnNlLnRzIiwibWFwcGluZ3MiOiI7Ozs7QUFFTyxNQUFNLGdCQUFnQjtJQUkzQixZQUFZLFFBQWE7UUFDdkIsSUFBSSxDQUFDLE1BQU0sR0FBRyxVQUFVLENBQUM7UUFDekIsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7SUFDM0IsQ0FBQztDQUNGIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQGJpdHdhcmRlbi9jbGkvLi9zcmMvbW9kZWxzL3Jlc3BvbnNlL3RlbXBsYXRlLnJlc3BvbnNlLnRzP2UxZTkiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQmFzZVJlc3BvbnNlIH0gZnJvbSBcIi4vYmFzZS5yZXNwb25zZVwiO1xuXG5leHBvcnQgY2xhc3MgVGVtcGxhdGVSZXNwb25zZSBpbXBsZW1lbnRzIEJhc2VSZXNwb25zZSB7XG4gIG9iamVjdDogc3RyaW5nO1xuICB0ZW1wbGF0ZTogYW55O1xuXG4gIGNvbnN0cnVjdG9yKHRlbXBsYXRlOiBhbnkpIHtcbiAgICB0aGlzLm9iamVjdCA9IFwidGVtcGxhdGVcIjtcbiAgICB0aGlzLnRlbXBsYXRlID0gdGVtcGxhdGU7XG4gIH1cbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./src/models/response/template.response.ts\n");

/***/ }),

/***/ "./src/platform/services/cli-platform-utils.service.ts":
/*!*************************************************************!*\
  !*** ./src/platform/services/cli-platform-utils.service.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CliPlatformUtilsService: () => (/* binding */ CliPlatformUtilsService)\n/* harmony export */ });\n/* harmony import */ var child_process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! child_process */ \"child_process\");\n/* harmony import */ var child_process__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(child_process__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/enums */ \"../../libs/common/src/enums/index.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n// eslint-disable-next-line\nconst open = __webpack_require__(/*! open */ \"open\");\nclass CliPlatformUtilsService {\n    constructor(clientType, packageJson) {\n        this.packageJson = packageJson;\n        this.deviceCache = null;\n        this.clientType = clientType;\n    }\n    getDevice() {\n        if (!this.deviceCache) {\n            switch (process.platform) {\n                case \"win32\":\n                    this.deviceCache = _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_1__.DeviceType.WindowsCLI;\n                    break;\n                case \"darwin\":\n                    this.deviceCache = _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_1__.DeviceType.MacOsCLI;\n                    break;\n                case \"linux\":\n                default:\n                    this.deviceCache = _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_1__.DeviceType.LinuxCLI;\n                    break;\n            }\n        }\n        return this.deviceCache;\n    }\n    getDeviceString() {\n        const device = _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_1__.DeviceType[this.getDevice()].toLowerCase();\n        return device.replace(\"cli\", \"\");\n    }\n    getClientType() {\n        return this.clientType;\n    }\n    isFirefox() {\n        return false;\n    }\n    isChrome() {\n        return false;\n    }\n    isEdge() {\n        return false;\n    }\n    isOpera() {\n        return false;\n    }\n    isVivaldi() {\n        return false;\n    }\n    isSafari() {\n        return false;\n    }\n    isMacAppStore() {\n        return false;\n    }\n    isViewOpen() {\n        return Promise.resolve(false);\n    }\n    launchUri(uri, options) {\n        if (process.platform === \"linux\") {\n            child_process__WEBPACK_IMPORTED_MODULE_0__.spawnSync(\"xdg-open\", [uri]);\n        }\n        else {\n            open(uri);\n        }\n    }\n    getApplicationVersion() {\n        return Promise.resolve(this.packageJson.version);\n    }\n    getApplicationVersionNumber() {\n        return __awaiter(this, void 0, void 0, function* () {\n            return (yield this.getApplicationVersion()).split(RegExp(\"[+|-]\"))[0].trim();\n        });\n    }\n    getApplicationVersionSync() {\n        return this.packageJson.version;\n    }\n    supportsWebAuthn(win) {\n        return false;\n    }\n    supportsDuo() {\n        return false;\n    }\n    showToast(type, title, text, options) {\n        throw new Error(\"Not implemented.\");\n    }\n    isDev() {\n        return \"development\" === \"development\";\n    }\n    isSelfHost() {\n        return false;\n    }\n    copyToClipboard(text, options) {\n        throw new Error(\"Not implemented.\");\n    }\n    readFromClipboard(options) {\n        throw new Error(\"Not implemented.\");\n    }\n    supportsBiometric() {\n        return Promise.resolve(false);\n    }\n    authenticateBiometric() {\n        return Promise.resolve(false);\n    }\n    supportsSecureStorage() {\n        return false;\n    }\n    getAutofillKeyboardShortcut() {\n        return null;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/platform/services/cli-platform-utils.service.ts\n");

/***/ }),

/***/ "./src/platform/services/console-log.service.ts":
/*!******************************************************!*\
  !*** ./src/platform/services/console-log.service.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ConsoleLogService: () => (/* binding */ ConsoleLogService)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_platform_services_console_log_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/platform/services/console-log.service */ \"../../libs/common/src/platform/services/console-log.service.ts\");\n\nclass ConsoleLogService extends _bitwarden_common_platform_services_console_log_service__WEBPACK_IMPORTED_MODULE_0__.ConsoleLogService {\n    constructor(isDev, filter = null) {\n        super(isDev, filter);\n    }\n    write(level, message, ...optionalParams) {\n        if (this.filter != null && this.filter(level)) {\n            return;\n        }\n        if (process.env.BW_RESPONSE === \"true\") {\n            // eslint-disable-next-line\n            console.error(message, ...optionalParams);\n            return;\n        }\n        super.write(level, message, ...optionalParams);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvcGxhdGZvcm0vc2VydmljZXMvY29uc29sZS1sb2cuc2VydmljZS50cyIsIm1hcHBpbmdzIjoiOzs7OztBQUNxSDtBQUU5RyxNQUFNLGlCQUFrQixTQUFRLHNHQUFxQjtJQUMxRCxZQUFZLEtBQWMsRUFBRSxTQUEyQyxJQUFJO1FBQ3pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDLENBQUM7SUFDdkIsQ0FBQztJQUVELEtBQUssQ0FBQyxLQUFtQixFQUFFLE9BQWEsRUFBRSxHQUFHLGNBQXFCO1FBQ2hFLElBQUksSUFBSSxDQUFDLE1BQU0sSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUM3QyxPQUFPO1NBQ1I7UUFFRCxJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMsV0FBVyxLQUFLLE1BQU0sRUFBRTtZQUN0QywyQkFBMkI7WUFDM0IsT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLEVBQUUsR0FBRyxjQUFjLENBQUMsQ0FBQztZQUMxQyxPQUFPO1NBQ1I7UUFFRCxLQUFLLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUUsR0FBRyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0NBQ0YiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9AYml0d2FyZGVuL2NsaS8uL3NyYy9wbGF0Zm9ybS9zZXJ2aWNlcy9jb25zb2xlLWxvZy5zZXJ2aWNlLnRzPzMxMTAiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgTG9nTGV2ZWxUeXBlIH0gZnJvbSBcIkBiaXR3YXJkZW4vY29tbW9uL3BsYXRmb3JtL2VudW1zL2xvZy1sZXZlbC10eXBlLmVudW1cIjtcbmltcG9ydCB7IENvbnNvbGVMb2dTZXJ2aWNlIGFzIEJhc2VDb25zb2xlTG9nU2VydmljZSB9IGZyb20gXCJAYml0d2FyZGVuL2NvbW1vbi9wbGF0Zm9ybS9zZXJ2aWNlcy9jb25zb2xlLWxvZy5zZXJ2aWNlXCI7XG5cbmV4cG9ydCBjbGFzcyBDb25zb2xlTG9nU2VydmljZSBleHRlbmRzIEJhc2VDb25zb2xlTG9nU2VydmljZSB7XG4gIGNvbnN0cnVjdG9yKGlzRGV2OiBib29sZWFuLCBmaWx0ZXI6IChsZXZlbDogTG9nTGV2ZWxUeXBlKSA9PiBib29sZWFuID0gbnVsbCkge1xuICAgIHN1cGVyKGlzRGV2LCBmaWx0ZXIpO1xuICB9XG5cbiAgd3JpdGUobGV2ZWw6IExvZ0xldmVsVHlwZSwgbWVzc2FnZT86IGFueSwgLi4ub3B0aW9uYWxQYXJhbXM6IGFueVtdKSB7XG4gICAgaWYgKHRoaXMuZmlsdGVyICE9IG51bGwgJiYgdGhpcy5maWx0ZXIobGV2ZWwpKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgaWYgKHByb2Nlc3MuZW52LkJXX1JFU1BPTlNFID09PSBcInRydWVcIikge1xuICAgICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lXG4gICAgICBjb25zb2xlLmVycm9yKG1lc3NhZ2UsIC4uLm9wdGlvbmFsUGFyYW1zKTtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBzdXBlci53cml0ZShsZXZlbCwgbWVzc2FnZSwgLi4ub3B0aW9uYWxQYXJhbXMpO1xuICB9XG59XG4iXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./src/platform/services/console-log.service.ts\n");

/***/ }),

/***/ "./src/platform/services/i18n.service.ts":
/*!***********************************************!*\
  !*** ./src/platform/services/i18n.service.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   I18nService: () => (/* binding */ I18nService)\n/* harmony export */ });\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fs */ \"fs\");\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! path */ \"path\");\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _bitwarden_common_platform_services_i18n_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/platform/services/i18n.service */ \"../../libs/common/src/platform/services/i18n.service.ts\");\n\n\n\nclass I18nService extends _bitwarden_common_platform_services_i18n_service__WEBPACK_IMPORTED_MODULE_2__.I18nService {\n    constructor(systemLanguage, localesDirectory, globalStateProvider) {\n        super(systemLanguage, localesDirectory, (formattedLocale) => {\n            const filePath = path__WEBPACK_IMPORTED_MODULE_1__.join(__dirname, this.localesDirectory + \"/\" + formattedLocale + \"/messages.json\");\n            const localesJson = fs__WEBPACK_IMPORTED_MODULE_0__.readFileSync(filePath, \"utf8\");\n            const locales = JSON.parse(localesJson.replace(/^\\uFEFF/, \"\")); // strip the BOM\n            return Promise.resolve(locales);\n        }, globalStateProvider);\n        this.supportedTranslationLocales = [\"en\"];\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/platform/services/i18n.service.ts\n");

/***/ }),

/***/ "./src/platform/services/lowdb-storage.service.ts":
/*!********************************************************!*\
  !*** ./src/platform/services/lowdb-storage.service.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   LowdbStorageService: () => (/* binding */ LowdbStorageService)\n/* harmony export */ });\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fs */ \"fs\");\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! path */ \"path\");\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var lowdb__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lowdb */ \"lowdb\");\n/* harmony import */ var lowdb__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lowdb__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var lowdb_adapters_FileSync__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lowdb/adapters/FileSync */ \"lowdb/adapters/FileSync\");\n/* harmony import */ var lowdb_adapters_FileSync__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lowdb_adapters_FileSync__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var proper_lockfile__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! proper-lockfile */ \"proper-lockfile\");\n/* harmony import */ var proper_lockfile__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(proper_lockfile__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var _bitwarden_common_platform_misc_sequentialize__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @bitwarden/common/platform/misc/sequentialize */ \"../../libs/common/src/platform/misc/sequentialize.ts\");\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_node_node_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @bitwarden/node/node-utils */ \"../../libs/node/src/node-utils.ts\");\nvar __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nvar __metadata = (undefined && undefined.__metadata) || function (k, v) {\n    if (typeof Reflect === \"object\" && typeof Reflect.metadata === \"function\") return Reflect.metadata(k, v);\n};\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\nconst retries = {\n    retries: 50,\n    minTimeout: 100,\n    maxTimeout: 250,\n    factor: 2,\n};\nclass LowdbStorageService {\n    constructor(logService, defaults, dir, allowCache = false, requireLock = false) {\n        this.logService = logService;\n        this.dir = dir;\n        this.allowCache = allowCache;\n        this.requireLock = requireLock;\n        this.ready = false;\n        this.updatesSubject = new rxjs__WEBPACK_IMPORTED_MODULE_5__.Subject();\n        this.defaults = defaults;\n        this.updates$ = this.updatesSubject.asObservable();\n    }\n    init() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.ready) {\n                return;\n            }\n            this.logService.info(\"Initializing lowdb storage service.\");\n            let adapter;\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_7__.Utils.isNode && this.dir != null) {\n                if (!fs__WEBPACK_IMPORTED_MODULE_0__.existsSync(this.dir)) {\n                    this.logService.warning(`Could not find dir, \"${this.dir}\"; creating it instead.`);\n                    _bitwarden_node_node_utils__WEBPACK_IMPORTED_MODULE_8__.NodeUtils.mkdirpSync(this.dir, \"700\");\n                    this.logService.info(`Created dir \"${this.dir}\".`);\n                }\n                this.dataFilePath = path__WEBPACK_IMPORTED_MODULE_1__.join(this.dir, \"data.json\");\n                if (!fs__WEBPACK_IMPORTED_MODULE_0__.existsSync(this.dataFilePath)) {\n                    this.logService.warning(`Could not find data file, \"${this.dataFilePath}\"; creating it instead.`);\n                    fs__WEBPACK_IMPORTED_MODULE_0__.writeFileSync(this.dataFilePath, \"\", { mode: 0o600 });\n                    fs__WEBPACK_IMPORTED_MODULE_0__.chmodSync(this.dataFilePath, 0o600);\n                    this.logService.info(`Created data file \"${this.dataFilePath}\" with chmod 600.`);\n                }\n                else {\n                    this.logService.info(`db file \"${this.dataFilePath} already exists\"; using existing db`);\n                }\n                yield this.lockDbFile(() => {\n                    adapter = new lowdb_adapters_FileSync__WEBPACK_IMPORTED_MODULE_3__(this.dataFilePath);\n                });\n            }\n            try {\n                this.logService.info(\"Attempting to create lowdb storage adapter.\");\n                this.db = lowdb__WEBPACK_IMPORTED_MODULE_2__(adapter);\n                this.logService.info(\"Successfully created lowdb storage adapter.\");\n            }\n            catch (e) {\n                if (e instanceof SyntaxError) {\n                    this.logService.warning(`Error creating lowdb storage adapter, \"${e.message}\"; emptying data file.`);\n                    if (fs__WEBPACK_IMPORTED_MODULE_0__.existsSync(this.dataFilePath)) {\n                        const backupPath = this.dataFilePath + \".bak\";\n                        this.logService.warning(`Writing backup of data file to ${backupPath}`);\n                        yield fs__WEBPACK_IMPORTED_MODULE_0__.copyFile(this.dataFilePath, backupPath, () => {\n                            this.logService.warning(`Error while creating data file backup, \"${e.message}\". No backup may have been created.`);\n                        });\n                    }\n                    adapter.write({});\n                    this.db = lowdb__WEBPACK_IMPORTED_MODULE_2__(adapter);\n                }\n                else {\n                    this.logService.error(`Error creating lowdb storage adapter, \"${e.message}\".`);\n                    throw e;\n                }\n            }\n            if (this.defaults != null) {\n                // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.\n                // eslint-disable-next-line @typescript-eslint/no-floating-promises\n                this.lockDbFile(() => {\n                    this.logService.info(\"Writing defaults.\");\n                    this.readForNoCache();\n                    this.db.defaults(this.defaults).write();\n                    this.logService.info(\"Successfully wrote defaults to db.\");\n                });\n            }\n            this.ready = true;\n        });\n    }\n    get valuesRequireDeserialization() {\n        return true;\n    }\n    get(key) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.waitForReady();\n            return this.lockDbFile(() => {\n                this.readForNoCache();\n                const val = this.db.get(key).value();\n                this.logService.debug(`Successfully read ${key} from db`);\n                if (val == null) {\n                    return null;\n                }\n                return val;\n            });\n        });\n    }\n    has(key) {\n        return this.get(key).then((v) => v != null);\n    }\n    save(key, obj) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.waitForReady();\n            return this.lockDbFile(() => {\n                this.readForNoCache();\n                // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.\n                // eslint-disable-next-line @typescript-eslint/no-floating-promises\n                this.db.set(key, obj).write();\n                this.updatesSubject.next({ key, updateType: \"save\" });\n                this.logService.debug(`Successfully wrote ${key} to db`);\n                return;\n            });\n        });\n    }\n    remove(key) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.waitForReady();\n            return this.lockDbFile(() => {\n                this.readForNoCache();\n                // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.\n                // eslint-disable-next-line @typescript-eslint/no-floating-promises\n                this.db.unset(key).write();\n                this.updatesSubject.next({ key, updateType: \"remove\" });\n                this.logService.debug(`Successfully removed ${key} from db`);\n                return;\n            });\n        });\n    }\n    lockDbFile(action) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.requireLock && !_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_7__.Utils.isNullOrWhitespace(this.dataFilePath)) {\n                this.logService.info(\"acquiring db file lock\");\n                return yield proper_lockfile__WEBPACK_IMPORTED_MODULE_4__.lock(this.dataFilePath, { retries: retries }).then((release) => {\n                    try {\n                        return action();\n                    }\n                    finally {\n                        // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.\n                        // eslint-disable-next-line @typescript-eslint/no-floating-promises\n                        release();\n                    }\n                });\n            }\n            else {\n                return action();\n            }\n        });\n    }\n    readForNoCache() {\n        if (!this.allowCache) {\n            this.db.read();\n        }\n    }\n    waitForReady() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (!this.ready) {\n                yield this.init();\n            }\n        });\n    }\n}\n__decorate([\n    (0,_bitwarden_common_platform_misc_sequentialize__WEBPACK_IMPORTED_MODULE_6__.sequentialize)(() => \"lowdbStorageInit\"),\n    __metadata(\"design:type\", Function),\n    __metadata(\"design:paramtypes\", []),\n    __metadata(\"design:returntype\", Promise)\n], LowdbStorageService.prototype, \"init\", null);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/platform/services/lowdb-storage.service.ts\n");

/***/ }),

/***/ "./src/platform/services/node-api.service.ts":
/*!***************************************************!*\
  !*** ./src/platform/services/node-api.service.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   NodeApiService: () => (/* binding */ NodeApiService)\n/* harmony export */ });\n/* harmony import */ var form_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! form-data */ \"form-data\");\n/* harmony import */ var form_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(form_data__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var https_proxy_agent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! https-proxy-agent */ \"https-proxy-agent\");\n/* harmony import */ var https_proxy_agent__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(https_proxy_agent__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var node_fetch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! node-fetch */ \"node-fetch\");\n/* harmony import */ var node_fetch__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(node_fetch__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _bitwarden_common_services_api_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/services/api.service */ \"../../libs/common/src/services/api.service.ts\");\n\n\n\n\nglobal.fetch = (node_fetch__WEBPACK_IMPORTED_MODULE_2___default());\nglobal.Request = node_fetch__WEBPACK_IMPORTED_MODULE_2__.Request;\nglobal.Response = node_fetch__WEBPACK_IMPORTED_MODULE_2__.Response;\nglobal.Headers = node_fetch__WEBPACK_IMPORTED_MODULE_2__.Headers;\nglobal.FormData = form_data__WEBPACK_IMPORTED_MODULE_0__;\nclass NodeApiService extends _bitwarden_common_services_api_service__WEBPACK_IMPORTED_MODULE_3__.ApiService {\n    constructor(tokenService, platformUtilsService, environmentService, appIdService, refreshAccessTokenErrorCallback, logService, logoutCallback, vaultTimeoutSettingsService, customUserAgent = null) {\n        super(tokenService, platformUtilsService, environmentService, appIdService, refreshAccessTokenErrorCallback, logService, logoutCallback, vaultTimeoutSettingsService, customUserAgent);\n    }\n    nativeFetch(request) {\n        const proxy = process.env.http_proxy || process.env.https_proxy;\n        if (proxy) {\n            request.agent = new https_proxy_agent__WEBPACK_IMPORTED_MODULE_1__.HttpsProxyAgent(proxy);\n        }\n        return fetch(request);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/platform/services/node-api.service.ts\n");

/***/ }),

/***/ "./src/platform/services/node-env-secure-storage.service.ts":
/*!******************************************************************!*\
  !*** ./src/platform/services/node-env-secure-storage.service.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   NodeEnvSecureStorageService: () => (/* binding */ NodeEnvSecureStorageService)\n/* harmony export */ });\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_common_platform_models_domain_enc_array_buffer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/platform/models/domain/enc-array-buffer */ \"../../libs/common/src/platform/models/domain/enc-array-buffer.ts\");\n/* harmony import */ var _bitwarden_common_platform_models_domain_symmetric_crypto_key__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/platform/models/domain/symmetric-crypto-key */ \"../../libs/common/src/platform/models/domain/symmetric-crypto-key.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass NodeEnvSecureStorageService {\n    constructor(storageService, logService, encryptService) {\n        this.storageService = storageService;\n        this.logService = logService;\n        this.encryptService = encryptService;\n    }\n    get valuesRequireDeserialization() {\n        return true;\n    }\n    get updates$() {\n        return (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.throwError)(() => new Error(\"Secure storage implementations cannot have their updates subscribed to.\"));\n    }\n    get(key) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const value = yield this.storageService.get(this.makeProtectedStorageKey(key));\n            if (value == null) {\n                return null;\n            }\n            const obj = yield this.decrypt(value);\n            return obj;\n        });\n    }\n    has(key) {\n        return __awaiter(this, void 0, void 0, function* () {\n            return (yield this.get(key)) != null;\n        });\n    }\n    save(key, obj) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (obj == null) {\n                return this.remove(key);\n            }\n            if (obj !== null && typeof obj !== \"string\") {\n                throw new Error(\"Only string storage is allowed.\");\n            }\n            const protectedObj = yield this.encrypt(obj);\n            yield this.storageService.save(this.makeProtectedStorageKey(key), protectedObj);\n        });\n    }\n    remove(key) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.storageService.remove(this.makeProtectedStorageKey(key));\n            return;\n        });\n    }\n    encrypt(plainValue) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const sessionKey = this.getSessionKey();\n            if (sessionKey == null) {\n                throw new Error(\"No session key available.\");\n            }\n            const encValue = yield this.encryptService.encryptToBytes(_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.fromB64ToArray(plainValue), sessionKey);\n            if (encValue == null) {\n                throw new Error(\"Value didn't encrypt.\");\n            }\n            return _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.fromBufferToB64(encValue.buffer);\n        });\n    }\n    decrypt(encValue) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const sessionKey = this.getSessionKey();\n                if (sessionKey == null) {\n                    return null;\n                }\n                const encBuf = _bitwarden_common_platform_models_domain_enc_array_buffer__WEBPACK_IMPORTED_MODULE_2__.EncArrayBuffer.fromB64(encValue);\n                const decValue = yield this.encryptService.decryptToBytes(encBuf, sessionKey);\n                if (decValue == null) {\n                    this.logService.info(\"Failed to decrypt.\");\n                    return null;\n                }\n                return _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.fromBufferToB64(decValue);\n            }\n            catch (e) {\n                this.logService.info(\"Decrypt error.\");\n                return null;\n            }\n        });\n    }\n    getSessionKey() {\n        try {\n            if (process.env.BW_SESSION != null) {\n                const sessionBuffer = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.fromB64ToArray(process.env.BW_SESSION);\n                if (sessionBuffer != null) {\n                    const sessionKey = new _bitwarden_common_platform_models_domain_symmetric_crypto_key__WEBPACK_IMPORTED_MODULE_3__.SymmetricCryptoKey(sessionBuffer);\n                    if (sessionBuffer != null) {\n                        return sessionKey;\n                    }\n                }\n            }\n        }\n        catch (e) {\n            this.logService.info(\"Session key is invalid.\");\n        }\n        return null;\n    }\n    makeProtectedStorageKey(key) {\n        return \"__PROTECTED__\" + key;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/platform/services/node-env-secure-storage.service.ts\n");

/***/ }),

/***/ "./src/program.ts":
/*!************************!*\
  !*** ./src/program.ts ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Program: () => (/* binding */ Program)\n/* harmony export */ });\n/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! chalk */ \"chalk\");\n/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(chalk__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var commander__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commander */ \"commander\");\n/* harmony import */ var commander__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(commander__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _bitwarden_common_auth_enums_authentication_status__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/auth/enums/authentication-status */ \"../../libs/common/src/auth/enums/authentication-status.ts\");\n/* harmony import */ var _auth_commands_lock_command__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./auth/commands/lock.command */ \"./src/auth/commands/lock.command.ts\");\n/* harmony import */ var _auth_commands_login_command__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./auth/commands/login.command */ \"./src/auth/commands/login.command.ts\");\n/* harmony import */ var _auth_commands_logout_command__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./auth/commands/logout.command */ \"./src/auth/commands/logout.command.ts\");\n/* harmony import */ var _auth_commands_unlock_command__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./auth/commands/unlock.command */ \"./src/auth/commands/unlock.command.ts\");\n/* harmony import */ var _base_program__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./base-program */ \"./src/base-program.ts\");\n/* harmony import */ var _commands_completion_command__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./commands/completion.command */ \"./src/commands/completion.command.ts\");\n/* harmony import */ var _commands_config_command__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./commands/config.command */ \"./src/commands/config.command.ts\");\n/* harmony import */ var _commands_encode_command__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./commands/encode.command */ \"./src/commands/encode.command.ts\");\n/* harmony import */ var _commands_serve_command__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./commands/serve.command */ \"./src/commands/serve.command.ts\");\n/* harmony import */ var _commands_status_command__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./commands/status.command */ \"./src/commands/status.command.ts\");\n/* harmony import */ var _commands_update_command__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./commands/update.command */ \"./src/commands/update.command.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./models/response/message.response */ \"./src/models/response/message.response.ts\");\n/* harmony import */ var _tools_generate_command__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./tools/generate.command */ \"./src/tools/generate.command.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./utils */ \"./src/utils.ts\");\n/* harmony import */ var _vault_sync_command__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./vault/sync.command */ \"./src/vault/sync.command.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nconst writeLn = _utils__WEBPACK_IMPORTED_MODULE_18__.CliUtils.writeLn;\nclass Program extends _base_program__WEBPACK_IMPORTED_MODULE_8__.BaseProgram {\n    register() {\n        return __awaiter(this, void 0, void 0, function* () {\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .option(\"--pretty\", \"Format output. JSON is tabbed with two spaces.\")\n                .option(\"--raw\", \"Return raw output instead of a descriptive message.\")\n                .option(\"--response\", \"Return a JSON formatted version of response output.\")\n                .option(\"--cleanexit\", \"Exit with a success exit code (0) unless an error is thrown.\")\n                .option(\"--quiet\", \"Don't return anything to stdout.\")\n                .option(\"--nointeraction\", \"Do not prompt for interactive user input.\")\n                .option(\"--session <session>\", \"Pass session key instead of reading from env.\")\n                .version(yield this.serviceContainer.platformUtilsService.getApplicationVersion(), \"-v, --version\");\n            commander__WEBPACK_IMPORTED_MODULE_1__.program.on(\"option:pretty\", () => {\n                process.env.BW_PRETTY = \"true\";\n            });\n            commander__WEBPACK_IMPORTED_MODULE_1__.program.on(\"option:raw\", () => {\n                process.env.BW_RAW = \"true\";\n            });\n            commander__WEBPACK_IMPORTED_MODULE_1__.program.on(\"option:quiet\", () => {\n                process.env.BW_QUIET = \"true\";\n            });\n            commander__WEBPACK_IMPORTED_MODULE_1__.program.on(\"option:response\", () => {\n                process.env.BW_RESPONSE = \"true\";\n            });\n            commander__WEBPACK_IMPORTED_MODULE_1__.program.on(\"option:cleanexit\", () => {\n                process.env.BW_CLEANEXIT = \"true\";\n            });\n            commander__WEBPACK_IMPORTED_MODULE_1__.program.on(\"option:nointeraction\", () => {\n                process.env.BW_NOINTERACTION = \"true\";\n            });\n            commander__WEBPACK_IMPORTED_MODULE_1__.program.on(\"option:session\", (key) => __awaiter(this, void 0, void 0, function* () {\n                process.env.BW_SESSION = key;\n                // once we have the session key, we can set the user key in memory\n                const activeAccount = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_2__.firstValueFrom)(this.serviceContainer.accountService.activeAccount$);\n                if (activeAccount) {\n                    yield this.serviceContainer.userAutoUnlockKeyService.setUserKeyInMemoryIfAutoUserKeySet(activeAccount.id);\n                }\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program.on(\"command:*\", () => {\n                writeLn(chalk__WEBPACK_IMPORTED_MODULE_0__.redBright(\"Invalid command: \" + commander__WEBPACK_IMPORTED_MODULE_1__.program.args.join(\" \")), false, true);\n                writeLn(\"See --help for a list of available commands.\", true, true);\n                process.exitCode = 1;\n            });\n            commander__WEBPACK_IMPORTED_MODULE_1__.program.on(\"--help\", () => {\n                writeLn(\"\\n  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw login\");\n                writeLn(\"    bw lock\");\n                writeLn(\"    bw unlock myPassword321\");\n                writeLn(\"    bw list --help\");\n                writeLn(\"    bw list items --search google\");\n                writeLn(\"    bw get item 99ee88d2-6046-4ea7-92c2-acac464b1412\");\n                writeLn(\"    bw get password google.com\");\n                writeLn('    echo \\'{\"name\":\"My Folder\"}\\' | bw encode');\n                writeLn(\"    bw create folder eyJuYW1lIjoiTXkgRm9sZGVyIn0K\");\n                writeLn(\"    bw edit folder c7c7b60b-9c61-40f2-8ccd-36c49595ed72 eyJuYW1lIjoiTXkgRm9sZGVyMiJ9Cg==\");\n                writeLn(\"    bw delete item 99ee88d2-6046-4ea7-92c2-acac464b1412\");\n                writeLn(\"    bw generate -lusn --length 18\");\n                writeLn(\"    bw config server https://bitwarden.example.com\");\n                writeLn(\"    bw send -f ./file.ext\");\n                writeLn('    bw send \"text to send\"');\n                writeLn('    echo \"text to send\" | bw send');\n                writeLn(\"    bw receive https://vault.bitwarden.com/#/send/rg3iuoS_Akm2gqy6ADRHmg/Ht7dYjsqjmgqUM3rjzZDSQ\");\n                writeLn(\"\", true);\n            });\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"login [email] [password]\")\n                .description(\"Log into a user account.\")\n                .option(\"--method <method>\", \"Two-step login method.\")\n                .option(\"--code <code>\", \"Two-step login code.\")\n                .option(\"--sso\", \"Log in with Single-Sign On.\")\n                .option(\"--apikey\", \"Log in with an Api Key.\")\n                .option(\"--passwordenv <passwordenv>\", \"Environment variable storing your password\")\n                .option(\"--passwordfile <passwordfile>\", \"Path to a file containing your password as its first line\")\n                .option(\"--check\", \"Check login status.\", () => __awaiter(this, void 0, void 0, function* () {\n                const authed = yield this.serviceContainer.stateService.getIsAuthenticated();\n                if (authed) {\n                    const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_16__.MessageResponse(\"You are logged in!\", null);\n                    this.processResponse(_models_response__WEBPACK_IMPORTED_MODULE_15__.Response.success(res), true);\n                }\n                this.processResponse(_models_response__WEBPACK_IMPORTED_MODULE_15__.Response.error(\"You are not logged in.\"), true);\n            }))\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Notes:\");\n                writeLn(\"\");\n                writeLn(\"    See docs for valid `method` enum values.\");\n                writeLn(\"\");\n                writeLn(\"    Pass `--raw` option to only return the session key.\");\n                writeLn(\"\");\n                writeLn(\"  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw login\");\n                writeLn(\"    bw login john@example.com myPassword321 --raw\");\n                writeLn(\"    bw login john@example.com myPassword321 --method 1 --code 249213\");\n                writeLn(\"    bw login --sso\");\n                writeLn(\"\", true);\n            })\n                .action((email, password, options) => __awaiter(this, void 0, void 0, function* () {\n                if (!options.check) {\n                    yield this.exitIfAuthed();\n                    const command = new _auth_commands_login_command__WEBPACK_IMPORTED_MODULE_5__.LoginCommand(this.serviceContainer.loginStrategyService, this.serviceContainer.authService, this.serviceContainer.apiService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.environmentService, this.serviceContainer.passwordGenerationService, this.serviceContainer.passwordStrengthService, this.serviceContainer.platformUtilsService, this.serviceContainer.accountService, this.serviceContainer.cryptoService, this.serviceContainer.policyService, this.serviceContainer.twoFactorService, this.serviceContainer.syncService, this.serviceContainer.keyConnectorService, this.serviceContainer.policyApiService, this.serviceContainer.organizationService, () => __awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }), this.serviceContainer.kdfConfigService);\n                    const response = yield command.run(email, password, options);\n                    this.processResponse(response, true);\n                }\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"logout\")\n                .description(\"Log out of the current user account.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw logout\");\n                writeLn(\"\", true);\n            })\n                .action((cmd) => __awaiter(this, void 0, void 0, function* () {\n                yield this.exitIfNotAuthed();\n                const command = new _auth_commands_logout_command__WEBPACK_IMPORTED_MODULE_6__.LogoutCommand(this.serviceContainer.authService, this.serviceContainer.i18nService, () => __awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }));\n                const response = yield command.run();\n                this.processResponse(response);\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"lock\")\n                .description(\"Lock the vault and destroy active session keys.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw lock\");\n                writeLn(\"\", true);\n            })\n                .action((cmd) => __awaiter(this, void 0, void 0, function* () {\n                yield this.exitIfNotAuthed();\n                if (yield this.serviceContainer.keyConnectorService.getUsesKeyConnector()) {\n                    const logoutCommand = new _auth_commands_logout_command__WEBPACK_IMPORTED_MODULE_6__.LogoutCommand(this.serviceContainer.authService, this.serviceContainer.i18nService, () => __awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }));\n                    yield logoutCommand.run();\n                    this.processResponse(_models_response__WEBPACK_IMPORTED_MODULE_15__.Response.error(\"You cannot lock your vault because you are using Key Connector. \" +\n                        \"To protect your vault, you have been logged out.\"), true);\n                    return;\n                }\n                const command = new _auth_commands_lock_command__WEBPACK_IMPORTED_MODULE_4__.LockCommand(this.serviceContainer.vaultTimeoutService);\n                const response = yield command.run();\n                this.processResponse(response);\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"unlock [password]\")\n                .description(\"Unlock the vault and return a new session key.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Notes:\");\n                writeLn(\"\");\n                writeLn(\"    After unlocking, any previous session keys will no longer be valid.\");\n                writeLn(\"\");\n                writeLn(\"    Pass `--raw` option to only return the session key.\");\n                writeLn(\"\");\n                writeLn(\"  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw unlock\");\n                writeLn(\"    bw unlock myPassword321\");\n                writeLn(\"    bw unlock myPassword321 --raw\");\n                writeLn(\"\", true);\n            })\n                .option(\"--check\", \"Check lock status.\", () => __awaiter(this, void 0, void 0, function* () {\n                yield this.exitIfNotAuthed();\n                const authStatus = yield this.serviceContainer.authService.getAuthStatus();\n                if (authStatus === _bitwarden_common_auth_enums_authentication_status__WEBPACK_IMPORTED_MODULE_3__.AuthenticationStatus.Unlocked) {\n                    const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_16__.MessageResponse(\"Vault is unlocked!\", null);\n                    this.processResponse(_models_response__WEBPACK_IMPORTED_MODULE_15__.Response.success(res), true);\n                }\n                else {\n                    this.processResponse(_models_response__WEBPACK_IMPORTED_MODULE_15__.Response.error(\"Vault is locked.\"), true);\n                }\n            }))\n                .option(\"--passwordenv <passwordenv>\", \"Environment variable storing your password\")\n                .option(\"--passwordfile <passwordfile>\", \"Path to a file containing your password as its first line\")\n                .action((password, cmd) => __awaiter(this, void 0, void 0, function* () {\n                if (!cmd.check) {\n                    yield this.exitIfNotAuthed();\n                    const command = new _auth_commands_unlock_command__WEBPACK_IMPORTED_MODULE_7__.UnlockCommand(this.serviceContainer.accountService, this.serviceContainer.masterPasswordService, this.serviceContainer.cryptoService, this.serviceContainer.stateService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.apiService, this.serviceContainer.logService, this.serviceContainer.keyConnectorService, this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.organizationApiService, () => __awaiter(this, void 0, void 0, function* () { return yield this.serviceContainer.logout(); }), this.serviceContainer.kdfConfigService);\n                    const response = yield command.run(password, cmd);\n                    this.processResponse(response);\n                }\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"sync\")\n                .description(\"Pull the latest vault data from server.\")\n                .option(\"-f, --force\", \"Force a full sync.\")\n                .option(\"--last\", \"Get the last sync date.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw sync\");\n                writeLn(\"    bw sync -f\");\n                writeLn(\"    bw sync --last\");\n                writeLn(\"\", true);\n            })\n                .action((cmd) => __awaiter(this, void 0, void 0, function* () {\n                yield this.exitIfNotAuthed();\n                const command = new _vault_sync_command__WEBPACK_IMPORTED_MODULE_19__.SyncCommand(this.serviceContainer.syncService);\n                const response = yield command.run(cmd);\n                this.processResponse(response);\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"generate\")\n                .description(\"Generate a password/passphrase.\")\n                .option(\"-u, --uppercase\", \"Include uppercase characters.\")\n                .option(\"-l, --lowercase\", \"Include lowercase characters.\")\n                .option(\"-n, --number\", \"Include numeric characters.\")\n                .option(\"-s, --special\", \"Include special characters.\")\n                .option(\"-p, --passphrase\", \"Generate a passphrase.\")\n                .option(\"--length <length>\", \"Length of the password.\")\n                .option(\"--words <words>\", \"Number of words.\")\n                .option(\"--minNumber <count>\", \"Minimum number of numeric characters.\")\n                .option(\"--minSpecial <count>\", \"Minimum number of special characters.\")\n                .option(\"--separator <separator>\", \"Word separator.\")\n                .option(\"-c, --capitalize\", \"Title case passphrase.\")\n                .option(\"--includeNumber\", \"Passphrase includes number.\")\n                .option(\"--ambiguous\", \"Avoid ambiguous characters.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Notes:\");\n                writeLn(\"\");\n                writeLn(\"    Default options are `-uln --length 14`.\");\n                writeLn(\"\");\n                writeLn(\"    Minimum `length` is 5.\");\n                writeLn(\"\");\n                writeLn(\"    Minimum `words` is 3.\");\n                writeLn(\"\");\n                writeLn(\"  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw generate\");\n                writeLn(\"    bw generate -u -l --length 18\");\n                writeLn(\"    bw generate -ulns --length 25\");\n                writeLn(\"    bw generate -ul\");\n                writeLn(\"    bw generate -p --separator _\");\n                writeLn(\"    bw generate -p --words 5 --separator space\");\n                writeLn(\"    bw generate -p --words 5 --separator empty\");\n                writeLn(\"\", true);\n            })\n                .action((options) => __awaiter(this, void 0, void 0, function* () {\n                const command = new _tools_generate_command__WEBPACK_IMPORTED_MODULE_17__.GenerateCommand(this.serviceContainer.passwordGenerationService, this.serviceContainer.stateService);\n                const response = yield command.run(options);\n                this.processResponse(response);\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"encode\")\n                .description(\"Base 64 encode stdin.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Notes:\");\n                writeLn(\"\");\n                writeLn(\"    Use to create `encodedJson` for `create` and `edit` commands.\");\n                writeLn(\"\");\n                writeLn(\"  Examples:\");\n                writeLn(\"\");\n                writeLn('    echo \\'{\"name\":\"My Folder\"}\\' | bw encode');\n                writeLn(\"\", true);\n            })\n                .action(() => __awaiter(this, void 0, void 0, function* () {\n                const command = new _commands_encode_command__WEBPACK_IMPORTED_MODULE_11__.EncodeCommand();\n                const response = yield command.run();\n                this.processResponse(response);\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"config <setting> [value]\")\n                .description(\"Configure CLI settings.\")\n                .option(\"--web-vault <url>\", \"Provides a custom web vault URL that differs from the base URL.\")\n                .option(\"--api <url>\", \"Provides a custom API URL that differs from the base URL.\")\n                .option(\"--identity <url>\", \"Provides a custom identity URL that differs from the base URL.\")\n                .option(\"--icons <url>\", \"Provides a custom icons service URL that differs from the base URL.\")\n                .option(\"--notifications <url>\", \"Provides a custom notifications URL that differs from the base URL.\")\n                .option(\"--events <url>\", \"Provides a custom events URL that differs from the base URL.\")\n                .option(\"--key-connector <url>\", \"Provides the URL for your Key Connector server.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Settings:\");\n                writeLn(\"\");\n                writeLn(\"    server - On-premises hosted installation URL.\");\n                writeLn(\"\");\n                writeLn(\"  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw config server\");\n                writeLn(\"    bw config server https://bw.company.com\");\n                writeLn(\"    bw config server bitwarden.com\");\n                writeLn(\"    bw config server --api http://localhost:4000 --identity http://localhost:33656\");\n                writeLn(\"\", true);\n            })\n                .action((setting, value, options) => __awaiter(this, void 0, void 0, function* () {\n                const command = new _commands_config_command__WEBPACK_IMPORTED_MODULE_10__.ConfigCommand(this.serviceContainer.environmentService);\n                const response = yield command.run(setting, value, options);\n                this.processResponse(response);\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"update\")\n                .description(\"Check for updates.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Notes:\");\n                writeLn(\"\");\n                writeLn(\"    Returns the URL to download the newest version of this CLI tool.\");\n                writeLn(\"\");\n                writeLn(\"    Use the `--raw` option to return only the download URL for the update.\");\n                writeLn(\"\");\n                writeLn(\"  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw update\");\n                writeLn(\"    bw update --raw\");\n                writeLn(\"\", true);\n            })\n                .action(() => __awaiter(this, void 0, void 0, function* () {\n                const command = new _commands_update_command__WEBPACK_IMPORTED_MODULE_14__.UpdateCommand(this.serviceContainer.platformUtilsService);\n                const response = yield command.run();\n                this.processResponse(response);\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"completion\")\n                .description(\"Generate shell completions.\")\n                .option(\"--shell <shell>\", \"Shell to generate completions for.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Notes:\");\n                writeLn(\"\");\n                writeLn(\"    Valid shells are `zsh`.\");\n                writeLn(\"\");\n                writeLn(\"  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw completion --shell zsh\");\n                writeLn(\"\", true);\n            })\n                .action((options, cmd) => __awaiter(this, void 0, void 0, function* () {\n                const command = new _commands_completion_command__WEBPACK_IMPORTED_MODULE_9__.CompletionCommand();\n                const response = yield command.run(options);\n                this.processResponse(response);\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"status\")\n                .description(\"Show server, last sync, user information, and vault status.\")\n                .on(\"--help\", () => {\n                writeLn(\"\");\n                writeLn(\"\");\n                writeLn(\"  Example return value:\");\n                writeLn(\"\");\n                writeLn(\"    {\");\n                writeLn('      \"serverUrl\": \"https://bitwarden.example.com\",');\n                writeLn('      \"lastSync\": \"2020-06-16T06:33:51.419Z\",');\n                writeLn('      \"userEmail\": \"user@example.com,');\n                writeLn('      \"userId\": \"00000000-0000-0000-0000-000000000000\",');\n                writeLn('      \"status\": \"locked\"');\n                writeLn(\"    }\");\n                writeLn(\"\");\n                writeLn(\"  Notes:\");\n                writeLn(\"\");\n                writeLn(\"  `status` is one of:\");\n                writeLn(\"    - `unauthenticated` when you are not logged in\");\n                writeLn(\"    - `locked` when you are logged in and the vault is locked\");\n                writeLn(\"    - `unlocked` when you are logged in and the vault is unlocked\");\n                writeLn(\"\", true);\n            })\n                .action(() => __awaiter(this, void 0, void 0, function* () {\n                const command = new _commands_status_command__WEBPACK_IMPORTED_MODULE_13__.StatusCommand(this.serviceContainer.environmentService, this.serviceContainer.syncService, this.serviceContainer.accountService, this.serviceContainer.authService);\n                const response = yield command.run();\n                this.processResponse(response);\n            }));\n            commander__WEBPACK_IMPORTED_MODULE_1__.program\n                .command(\"serve\")\n                .description(\"Start a RESTful API webserver.\")\n                .option(\"--hostname <hostname>\", \"The hostname to bind your API webserver to.\")\n                .option(\"--port <port>\", \"The port to run your API webserver on.\")\n                .option(\"--disable-origin-protection\", \"If set, allows requests with origin header. Warning, this option exists for backwards compatibility reasons and exposes your environment to known CSRF attacks.\")\n                .on(\"--help\", () => {\n                writeLn(\"\\n  Notes:\");\n                writeLn(\"\");\n                writeLn(\"    Default hostname is `localhost`.\");\n                writeLn(\"    Use hostname `all` for no hostname binding.\");\n                writeLn(\"    Default port is `8087`.\");\n                writeLn(\"\");\n                writeLn(\"  Examples:\");\n                writeLn(\"\");\n                writeLn(\"    bw serve\");\n                writeLn(\"    bw serve --port 8080\");\n                writeLn(\"    bw serve --hostname bwapi.mydomain.com --port 80\");\n                writeLn(\"\", true);\n            })\n                .action((cmd) => __awaiter(this, void 0, void 0, function* () {\n                yield this.exitIfNotAuthed();\n                const command = new _commands_serve_command__WEBPACK_IMPORTED_MODULE_12__.ServeCommand(this.serviceContainer);\n                yield command.run(cmd);\n            }));\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvcHJvZ3JhbS50cyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBK0I7QUFDNEI7QUFDckI7QUFFb0Q7QUFFL0I7QUFDRTtBQUNFO0FBQ0E7QUFDbEI7QUFDcUI7QUFDUjtBQUNBO0FBQ0Y7QUFDRTtBQUNBO0FBQ2I7QUFDd0I7QUFDVjtBQUN4QjtBQUNnQjtBQUVuRCxNQUFNLE9BQU8sR0FBRyw2Q0FBUSxDQUFDLE9BQU8sQ0FBQztBQUUxQixNQUFNLE9BQVEsU0FBUSxzREFBVztJQUNoQyxRQUFROztZQUNaLDhDQUFPO2lCQUNKLE1BQU0sQ0FBQyxVQUFVLEVBQUUsZ0RBQWdELENBQUM7aUJBQ3BFLE1BQU0sQ0FBQyxPQUFPLEVBQUUscURBQXFELENBQUM7aUJBQ3RFLE1BQU0sQ0FBQyxZQUFZLEVBQUUscURBQXFELENBQUM7aUJBQzNFLE1BQU0sQ0FBQyxhQUFhLEVBQUUsOERBQThELENBQUM7aUJBQ3JGLE1BQU0sQ0FBQyxTQUFTLEVBQUUsa0NBQWtDLENBQUM7aUJBQ3JELE1BQU0sQ0FBQyxpQkFBaUIsRUFBRSwyQ0FBMkMsQ0FBQztpQkFDdEUsTUFBTSxDQUFDLHFCQUFxQixFQUFFLCtDQUErQyxDQUFDO2lCQUM5RSxPQUFPLENBQ04sTUFBTSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsb0JBQW9CLENBQUMscUJBQXFCLEVBQUUsRUFDeEUsZUFBZSxDQUNoQixDQUFDO1lBRUosOENBQU8sQ0FBQyxFQUFFLENBQUMsZUFBZSxFQUFFLEdBQUcsRUFBRTtnQkFDL0IsT0FBTyxDQUFDLEdBQUcsQ0FBQyxTQUFTLEdBQUcsTUFBTSxDQUFDO1lBQ2pDLENBQUMsQ0FBQyxDQUFDO1lBRUgsOENBQU8sQ0FBQyxFQUFFLENBQUMsWUFBWSxFQUFFLEdBQUcsRUFBRTtnQkFDNUIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDO1lBQzlCLENBQUMsQ0FBQyxDQUFDO1lBRUgsOENBQU8sQ0FBQyxFQUFFLENBQUMsY0FBYyxFQUFFLEdBQUcsRUFBRTtnQkFDOUIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDO1lBQ2hDLENBQUMsQ0FBQyxDQUFDO1lBRUgsOENBQU8sQ0FBQyxFQUFFLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxFQUFFO2dCQUNqQyxPQUFPLENBQUMsR0FBRyxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUM7WUFDbkMsQ0FBQyxDQUFDLENBQUM7WUFFSCw4Q0FBTyxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLEVBQUU7Z0JBQ2xDLE9BQU8sQ0FBQyxHQUFHLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQztZQUNwQyxDQUFDLENBQUMsQ0FBQztZQUVILDhDQUFPLENBQUMsRUFBRSxDQUFDLHNCQUFzQixFQUFFLEdBQUcsRUFBRTtnQkFDdEMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUM7WUFDeEMsQ0FBQyxDQUFDLENBQUM7WUFFSCw4Q0FBTyxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsRUFBRSxDQUFPLEdBQUcsRUFBRSxFQUFFO2dCQUN6QyxPQUFPLENBQUMsR0FBRyxDQUFDLFVBQVUsR0FBRyxHQUFHLENBQUM7Z0JBRTdCLGtFQUFrRTtnQkFDbEUsTUFBTSxhQUFhLEdBQUcsTUFBTSxvREFBYyxDQUN4QyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsY0FBYyxDQUFDLGNBQWMsQ0FDcEQsQ0FBQztnQkFDRixJQUFJLGFBQWEsRUFBRTtvQkFDakIsTUFBTSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsd0JBQXdCLENBQUMsa0NBQWtDLENBQ3JGLGFBQWEsQ0FBQyxFQUFFLENBQ2pCLENBQUM7aUJBQ0g7WUFDSCxDQUFDLEVBQUMsQ0FBQztZQUVILDhDQUFPLENBQUMsRUFBRSxDQUFDLFdBQVcsRUFBRSxHQUFHLEVBQUU7Z0JBQzNCLE9BQU8sQ0FBQyw0Q0FBZSxDQUFDLG1CQUFtQixHQUFHLDhDQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLEtBQUssRUFBRSxJQUFJLENBQUMsQ0FBQztnQkFDcEYsT0FBTyxDQUFDLDhDQUE4QyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztnQkFDcEUsT0FBTyxDQUFDLFFBQVEsR0FBRyxDQUFDLENBQUM7WUFDdkIsQ0FBQyxDQUFDLENBQUM7WUFFSCw4Q0FBTyxDQUFDLEVBQUUsQ0FBQyxRQUFRLEVBQUUsR0FBRyxFQUFFO2dCQUN4QixPQUFPLENBQUMsZUFBZSxDQUFDLENBQUM7Z0JBQ3pCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsY0FBYyxDQUFDLENBQUM7Z0JBQ3hCLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQztnQkFDdkIsT0FBTyxDQUFDLDZCQUE2QixDQUFDLENBQUM7Z0JBQ3ZDLE9BQU8sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO2dCQUM5QixPQUFPLENBQUMsbUNBQW1DLENBQUMsQ0FBQztnQkFDN0MsT0FBTyxDQUFDLHNEQUFzRCxDQUFDLENBQUM7Z0JBQ2hFLE9BQU8sQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO2dCQUMxQyxPQUFPLENBQUMsK0NBQStDLENBQUMsQ0FBQztnQkFDekQsT0FBTyxDQUFDLG1EQUFtRCxDQUFDLENBQUM7Z0JBQzdELE9BQU8sQ0FDTCwwRkFBMEYsQ0FDM0YsQ0FBQztnQkFDRixPQUFPLENBQUMseURBQXlELENBQUMsQ0FBQztnQkFDbkUsT0FBTyxDQUFDLG1DQUFtQyxDQUFDLENBQUM7Z0JBQzdDLE9BQU8sQ0FBQyxvREFBb0QsQ0FBQyxDQUFDO2dCQUM5RCxPQUFPLENBQUMsMkJBQTJCLENBQUMsQ0FBQztnQkFDckMsT0FBTyxDQUFDLDRCQUE0QixDQUFDLENBQUM7Z0JBQ3RDLE9BQU8sQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO2dCQUM3QyxPQUFPLENBQ0wsaUdBQWlHLENBQ2xHLENBQUM7Z0JBQ0YsT0FBTyxDQUFDLEVBQUUsRUFBRSxJQUFJLENBQUMsQ0FBQztZQUNwQixDQUFDLENBQUMsQ0FBQztZQUVILDhDQUFPO2lCQUNKLE9BQU8sQ0FBQywwQkFBMEIsQ0FBQztpQkFDbkMsV0FBVyxDQUFDLDBCQUEwQixDQUFDO2lCQUN2QyxNQUFNLENBQUMsbUJBQW1CLEVBQUUsd0JBQXdCLENBQUM7aUJBQ3JELE1BQU0sQ0FBQyxlQUFlLEVBQUUsc0JBQXNCLENBQUM7aUJBQy9DLE1BQU0sQ0FBQyxPQUFPLEVBQUUsNkJBQTZCLENBQUM7aUJBQzlDLE1BQU0sQ0FBQyxVQUFVLEVBQUUseUJBQXlCLENBQUM7aUJBQzdDLE1BQU0sQ0FBQyw2QkFBNkIsRUFBRSw0Q0FBNEMsQ0FBQztpQkFDbkYsTUFBTSxDQUNMLCtCQUErQixFQUMvQiwyREFBMkQsQ0FDNUQ7aUJBQ0EsTUFBTSxDQUFDLFNBQVMsRUFBRSxxQkFBcUIsRUFBRSxHQUFTLEVBQUU7Z0JBQ25ELE1BQU0sTUFBTSxHQUFHLE1BQU0sSUFBSSxDQUFDLGdCQUFnQixDQUFDLFlBQVksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO2dCQUM3RSxJQUFJLE1BQU0sRUFBRTtvQkFDVixNQUFNLEdBQUcsR0FBRyxJQUFJLCtFQUFlLENBQUMsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLENBQUM7b0JBQzVELElBQUksQ0FBQyxlQUFlLENBQUMsdURBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLEVBQUUsSUFBSSxDQUFDLENBQUM7aUJBQ25EO2dCQUNELElBQUksQ0FBQyxlQUFlLENBQUMsdURBQVEsQ0FBQyxLQUFLLENBQUMsd0JBQXdCLENBQUMsRUFBRSxJQUFJLENBQUMsQ0FBQztZQUN2RSxDQUFDLEVBQUM7aUJBQ0QsRUFBRSxDQUFDLFFBQVEsRUFBRSxHQUFHLEVBQUU7Z0JBQ2pCLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztnQkFDdEIsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2dCQUNaLE9BQU8sQ0FBQyw4Q0FBOEMsQ0FBQyxDQUFDO2dCQUN4RCxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLHlEQUF5RCxDQUFDLENBQUM7Z0JBQ25FLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsYUFBYSxDQUFDLENBQUM7Z0JBQ3ZCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsY0FBYyxDQUFDLENBQUM7Z0JBQ3hCLE9BQU8sQ0FBQyxtREFBbUQsQ0FBQyxDQUFDO2dCQUM3RCxPQUFPLENBQUMsc0VBQXNFLENBQUMsQ0FBQztnQkFDaEYsT0FBTyxDQUFDLG9CQUFvQixDQUFDLENBQUM7Z0JBQzlCLE9BQU8sQ0FBQyxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDcEIsQ0FBQyxDQUFDO2lCQUNELE1BQU0sQ0FBQyxDQUFPLEtBQWEsRUFBRSxRQUFnQixFQUFFLE9BQXFCLEVBQUUsRUFBRTtnQkFDdkUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUU7b0JBQ2xCLE1BQU0sSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO29CQUMxQixNQUFNLE9BQU8sR0FBRyxJQUFJLHNFQUFZLENBQzlCLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxvQkFBb0IsRUFDMUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFdBQVcsRUFDakMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsRUFDaEMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHFCQUFxQixFQUMzQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsa0JBQWtCLEVBQ3hDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyx5QkFBeUIsRUFDL0MsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHVCQUF1QixFQUM3QyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsb0JBQW9CLEVBQzFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFjLEVBQ3BDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLEVBQ25DLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLEVBQ25DLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxnQkFBZ0IsRUFDdEMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFdBQVcsRUFDakMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLG1CQUFtQixFQUN6QyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZ0JBQWdCLEVBQ3RDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxtQkFBbUIsRUFDekMsR0FBUyxFQUFFLGdEQUFDLGFBQU0sSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sRUFBRSxNQUNoRCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZ0JBQWdCLENBQ3ZDLENBQUM7b0JBQ0YsTUFBTSxRQUFRLEdBQUcsTUFBTSxPQUFPLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUUsT0FBTyxDQUFDLENBQUM7b0JBQzdELElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxDQUFDO2lCQUN0QztZQUNILENBQUMsRUFBQyxDQUFDO1lBRUwsOENBQU87aUJBQ0osT0FBTyxDQUFDLFFBQVEsQ0FBQztpQkFDakIsV0FBVyxDQUFDLHNDQUFzQyxDQUFDO2lCQUNuRCxFQUFFLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRTtnQkFDakIsT0FBTyxDQUFDLGVBQWUsQ0FBQyxDQUFDO2dCQUN6QixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLGVBQWUsQ0FBQyxDQUFDO2dCQUN6QixPQUFPLENBQUMsRUFBRSxFQUFFLElBQUksQ0FBQyxDQUFDO1lBQ3BCLENBQUMsQ0FBQztpQkFDRCxNQUFNLENBQUMsQ0FBTyxHQUFHLEVBQUUsRUFBRTtnQkFDcEIsTUFBTSxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7Z0JBQzdCLE1BQU0sT0FBTyxHQUFHLElBQUksd0VBQWEsQ0FDL0IsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFdBQVcsRUFDakMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFdBQVcsRUFDakMsR0FBUyxFQUFFLGdEQUFDLGFBQU0sSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sRUFBRSxLQUNqRCxDQUFDO2dCQUNGLE1BQU0sUUFBUSxHQUFHLE1BQU0sT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO2dCQUNyQyxJQUFJLENBQUMsZUFBZSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ2pDLENBQUMsRUFBQyxDQUFDO1lBRUwsOENBQU87aUJBQ0osT0FBTyxDQUFDLE1BQU0sQ0FBQztpQkFDZixXQUFXLENBQUMsaURBQWlELENBQUM7aUJBQzlELEVBQUUsQ0FBQyxRQUFRLEVBQUUsR0FBRyxFQUFFO2dCQUNqQixPQUFPLENBQUMsZUFBZSxDQUFDLENBQUM7Z0JBQ3pCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsYUFBYSxDQUFDLENBQUM7Z0JBQ3ZCLE9BQU8sQ0FBQyxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDcEIsQ0FBQyxDQUFDO2lCQUNELE1BQU0sQ0FBQyxDQUFPLEdBQUcsRUFBRSxFQUFFO2dCQUNwQixNQUFNLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztnQkFFN0IsSUFBSSxNQUFNLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxtQkFBbUIsQ0FBQyxtQkFBbUIsRUFBRSxFQUFFO29CQUN6RSxNQUFNLGFBQWEsR0FBRyxJQUFJLHdFQUFhLENBQ3JDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQ2pDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQ2pDLEdBQVMsRUFBRSxnREFBQyxhQUFNLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLEVBQUUsS0FDakQsQ0FBQztvQkFDRixNQUFNLGFBQWEsQ0FBQyxHQUFHLEVBQUUsQ0FBQztvQkFDMUIsSUFBSSxDQUFDLGVBQWUsQ0FDbEIsdURBQVEsQ0FBQyxLQUFLLENBQ1osa0VBQWtFO3dCQUNoRSxrREFBa0QsQ0FDckQsRUFDRCxJQUFJLENBQ0wsQ0FBQztvQkFDRixPQUFPO2lCQUNSO2dCQUVELE1BQU0sT0FBTyxHQUFHLElBQUksb0VBQVcsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsbUJBQW1CLENBQUMsQ0FBQztnQkFDM0UsTUFBTSxRQUFRLEdBQUcsTUFBTSxPQUFPLENBQUMsR0FBRyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxDQUFDLENBQUM7WUFDakMsQ0FBQyxFQUFDLENBQUM7WUFFTCw4Q0FBTztpQkFDSixPQUFPLENBQUMsbUJBQW1CLENBQUM7aUJBQzVCLFdBQVcsQ0FBQyxnREFBZ0QsQ0FBQztpQkFDN0QsRUFBRSxDQUFDLFFBQVEsRUFBRSxHQUFHLEVBQUU7Z0JBQ2pCLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztnQkFDdEIsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2dCQUNaLE9BQU8sQ0FBQyx5RUFBeUUsQ0FBQyxDQUFDO2dCQUNuRixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLHlEQUF5RCxDQUFDLENBQUM7Z0JBQ25FLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsYUFBYSxDQUFDLENBQUM7Z0JBQ3ZCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsZUFBZSxDQUFDLENBQUM7Z0JBQ3pCLE9BQU8sQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO2dCQUN2QyxPQUFPLENBQUMsbUNBQW1DLENBQUMsQ0FBQztnQkFDN0MsT0FBTyxDQUFDLEVBQUUsRUFBRSxJQUFJLENBQUMsQ0FBQztZQUNwQixDQUFDLENBQUM7aUJBQ0QsTUFBTSxDQUFDLFNBQVMsRUFBRSxvQkFBb0IsRUFBRSxHQUFTLEVBQUU7Z0JBQ2xELE1BQU0sSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO2dCQUU3QixNQUFNLFVBQVUsR0FBRyxNQUFNLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsYUFBYSxFQUFFLENBQUM7Z0JBQzNFLElBQUksVUFBVSxLQUFLLG9HQUFvQixDQUFDLFFBQVEsRUFBRTtvQkFDaEQsTUFBTSxHQUFHLEdBQUcsSUFBSSwrRUFBZSxDQUFDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxDQUFDO29CQUM1RCxJQUFJLENBQUMsZUFBZSxDQUFDLHVEQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFDO2lCQUNuRDtxQkFBTTtvQkFDTCxJQUFJLENBQUMsZUFBZSxDQUFDLHVEQUFRLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLEVBQUUsSUFBSSxDQUFDLENBQUM7aUJBQ2hFO1lBQ0gsQ0FBQyxFQUFDO2lCQUNELE1BQU0sQ0FBQyw2QkFBNkIsRUFBRSw0Q0FBNEMsQ0FBQztpQkFDbkYsTUFBTSxDQUNMLCtCQUErQixFQUMvQiwyREFBMkQsQ0FDNUQ7aUJBQ0EsTUFBTSxDQUFDLENBQU8sUUFBUSxFQUFFLEdBQUcsRUFBRSxFQUFFO2dCQUM5QixJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRTtvQkFDZCxNQUFNLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztvQkFDN0IsTUFBTSxPQUFPLEdBQUcsSUFBSSx3RUFBYSxDQUMvQixJQUFJLENBQUMsZ0JBQWdCLENBQUMsY0FBYyxFQUNwQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMscUJBQXFCLEVBQzNDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLEVBQ25DLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxZQUFZLEVBQ2xDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxxQkFBcUIsRUFDM0MsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsRUFDaEMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFVBQVUsRUFDaEMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLG1CQUFtQixFQUN6QyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsa0JBQWtCLEVBQ3hDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQ2pDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxzQkFBc0IsRUFDNUMsR0FBUyxFQUFFLGdEQUFDLGFBQU0sSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sRUFBRSxNQUNoRCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZ0JBQWdCLENBQ3ZDLENBQUM7b0JBQ0YsTUFBTSxRQUFRLEdBQUcsTUFBTSxPQUFPLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsQ0FBQztvQkFDbEQsSUFBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQztpQkFDaEM7WUFDSCxDQUFDLEVBQUMsQ0FBQztZQUVMLDhDQUFPO2lCQUNKLE9BQU8sQ0FBQyxNQUFNLENBQUM7aUJBQ2YsV0FBVyxDQUFDLHlDQUF5QyxDQUFDO2lCQUN0RCxNQUFNLENBQUMsYUFBYSxFQUFFLG9CQUFvQixDQUFDO2lCQUMzQyxNQUFNLENBQUMsUUFBUSxFQUFFLHlCQUF5QixDQUFDO2lCQUMzQyxFQUFFLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRTtnQkFDakIsT0FBTyxDQUFDLGVBQWUsQ0FBQyxDQUFDO2dCQUN6QixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDO2dCQUN2QixPQUFPLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztnQkFDMUIsT0FBTyxDQUFDLG9CQUFvQixDQUFDLENBQUM7Z0JBQzlCLE9BQU8sQ0FBQyxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDcEIsQ0FBQyxDQUFDO2lCQUNELE1BQU0sQ0FBQyxDQUFPLEdBQUcsRUFBRSxFQUFFO2dCQUNwQixNQUFNLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztnQkFDN0IsTUFBTSxPQUFPLEdBQUcsSUFBSSw2REFBVyxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztnQkFDbkUsTUFBTSxRQUFRLEdBQUcsTUFBTSxPQUFPLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2dCQUN4QyxJQUFJLENBQUMsZUFBZSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ2pDLENBQUMsRUFBQyxDQUFDO1lBRUwsOENBQU87aUJBQ0osT0FBTyxDQUFDLFVBQVUsQ0FBQztpQkFDbkIsV0FBVyxDQUFDLGlDQUFpQyxDQUFDO2lCQUM5QyxNQUFNLENBQUMsaUJBQWlCLEVBQUUsK0JBQStCLENBQUM7aUJBQzFELE1BQU0sQ0FBQyxpQkFBaUIsRUFBRSwrQkFBK0IsQ0FBQztpQkFDMUQsTUFBTSxDQUFDLGNBQWMsRUFBRSw2QkFBNkIsQ0FBQztpQkFDckQsTUFBTSxDQUFDLGVBQWUsRUFBRSw2QkFBNkIsQ0FBQztpQkFDdEQsTUFBTSxDQUFDLGtCQUFrQixFQUFFLHdCQUF3QixDQUFDO2lCQUNwRCxNQUFNLENBQUMsbUJBQW1CLEVBQUUseUJBQXlCLENBQUM7aUJBQ3RELE1BQU0sQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQztpQkFDN0MsTUFBTSxDQUFDLHFCQUFxQixFQUFFLHVDQUF1QyxDQUFDO2lCQUN0RSxNQUFNLENBQUMsc0JBQXNCLEVBQUUsdUNBQXVDLENBQUM7aUJBQ3ZFLE1BQU0sQ0FBQyx5QkFBeUIsRUFBRSxpQkFBaUIsQ0FBQztpQkFDcEQsTUFBTSxDQUFDLGtCQUFrQixFQUFFLHdCQUF3QixDQUFDO2lCQUNwRCxNQUFNLENBQUMsaUJBQWlCLEVBQUUsNkJBQTZCLENBQUM7aUJBQ3hELE1BQU0sQ0FBQyxhQUFhLEVBQUUsNkJBQTZCLENBQUM7aUJBQ3BELEVBQUUsQ0FBQyxRQUFRLEVBQUUsR0FBRyxFQUFFO2dCQUNqQixPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7Z0JBQ3RCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsNkNBQTZDLENBQUMsQ0FBQztnQkFDdkQsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2dCQUNaLE9BQU8sQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO2dCQUN0QyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLDJCQUEyQixDQUFDLENBQUM7Z0JBQ3JDLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsYUFBYSxDQUFDLENBQUM7Z0JBQ3ZCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsaUJBQWlCLENBQUMsQ0FBQztnQkFDM0IsT0FBTyxDQUFDLG1DQUFtQyxDQUFDLENBQUM7Z0JBQzdDLE9BQU8sQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO2dCQUM3QyxPQUFPLENBQUMscUJBQXFCLENBQUMsQ0FBQztnQkFDL0IsT0FBTyxDQUFDLGtDQUFrQyxDQUFDLENBQUM7Z0JBQzVDLE9BQU8sQ0FBQyxnREFBZ0QsQ0FBQyxDQUFDO2dCQUMxRCxPQUFPLENBQUMsZ0RBQWdELENBQUMsQ0FBQztnQkFDMUQsT0FBTyxDQUFDLEVBQUUsRUFBRSxJQUFJLENBQUMsQ0FBQztZQUNwQixDQUFDLENBQUM7aUJBQ0QsTUFBTSxDQUFDLENBQU8sT0FBTyxFQUFFLEVBQUU7Z0JBQ3hCLE1BQU0sT0FBTyxHQUFHLElBQUkscUVBQWUsQ0FDakMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHlCQUF5QixFQUMvQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxDQUNuQyxDQUFDO2dCQUNGLE1BQU0sUUFBUSxHQUFHLE1BQU0sT0FBTyxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQztnQkFDNUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUNqQyxDQUFDLEVBQUMsQ0FBQztZQUVMLDhDQUFPO2lCQUNKLE9BQU8sQ0FBQyxRQUFRLENBQUM7aUJBQ2pCLFdBQVcsQ0FBQyx1QkFBdUIsQ0FBQztpQkFDcEMsRUFBRSxDQUFDLFFBQVEsRUFBRSxHQUFHLEVBQUU7Z0JBQ2pCLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztnQkFDdEIsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2dCQUNaLE9BQU8sQ0FBQyxtRUFBbUUsQ0FBQyxDQUFDO2dCQUM3RSxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDO2dCQUN2QixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLCtDQUErQyxDQUFDLENBQUM7Z0JBQ3pELE9BQU8sQ0FBQyxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDcEIsQ0FBQyxDQUFDO2lCQUNELE1BQU0sQ0FBQyxHQUFTLEVBQUU7Z0JBQ2pCLE1BQU0sT0FBTyxHQUFHLElBQUksb0VBQWEsRUFBRSxDQUFDO2dCQUNwQyxNQUFNLFFBQVEsR0FBRyxNQUFNLE9BQU8sQ0FBQyxHQUFHLEVBQUUsQ0FBQztnQkFDckMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUNqQyxDQUFDLEVBQUMsQ0FBQztZQUVMLDhDQUFPO2lCQUNKLE9BQU8sQ0FBQywwQkFBMEIsQ0FBQztpQkFDbkMsV0FBVyxDQUFDLHlCQUF5QixDQUFDO2lCQUN0QyxNQUFNLENBQ0wsbUJBQW1CLEVBQ25CLGlFQUFpRSxDQUNsRTtpQkFDQSxNQUFNLENBQUMsYUFBYSxFQUFFLDJEQUEyRCxDQUFDO2lCQUNsRixNQUFNLENBQUMsa0JBQWtCLEVBQUUsZ0VBQWdFLENBQUM7aUJBQzVGLE1BQU0sQ0FDTCxlQUFlLEVBQ2YscUVBQXFFLENBQ3RFO2lCQUNBLE1BQU0sQ0FDTCx1QkFBdUIsRUFDdkIscUVBQXFFLENBQ3RFO2lCQUNBLE1BQU0sQ0FBQyxnQkFBZ0IsRUFBRSw4REFBOEQsQ0FBQztpQkFDeEYsTUFBTSxDQUFDLHVCQUF1QixFQUFFLGlEQUFpRCxDQUFDO2lCQUNsRixFQUFFLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRTtnQkFDakIsT0FBTyxDQUFDLGVBQWUsQ0FBQyxDQUFDO2dCQUN6QixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLG1EQUFtRCxDQUFDLENBQUM7Z0JBQzdELE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsYUFBYSxDQUFDLENBQUM7Z0JBQ3ZCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsc0JBQXNCLENBQUMsQ0FBQztnQkFDaEMsT0FBTyxDQUFDLDZDQUE2QyxDQUFDLENBQUM7Z0JBQ3ZELE9BQU8sQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDO2dCQUM5QyxPQUFPLENBQ0wsb0ZBQW9GLENBQ3JGLENBQUM7Z0JBQ0YsT0FBTyxDQUFDLEVBQUUsRUFBRSxJQUFJLENBQUMsQ0FBQztZQUNwQixDQUFDLENBQUM7aUJBQ0QsTUFBTSxDQUFDLENBQU8sT0FBTyxFQUFFLEtBQUssRUFBRSxPQUFPLEVBQUUsRUFBRTtnQkFDeEMsTUFBTSxPQUFPLEdBQUcsSUFBSSxvRUFBYSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO2dCQUM1RSxNQUFNLFFBQVEsR0FBRyxNQUFNLE9BQU8sQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztnQkFDNUQsSUFBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUNqQyxDQUFDLEVBQUMsQ0FBQztZQUVMLDhDQUFPO2lCQUNKLE9BQU8sQ0FBQyxRQUFRLENBQUM7aUJBQ2pCLFdBQVcsQ0FBQyxvQkFBb0IsQ0FBQztpQkFDakMsRUFBRSxDQUFDLFFBQVEsRUFBRSxHQUFHLEVBQUU7Z0JBQ2pCLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztnQkFDdEIsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2dCQUNaLE9BQU8sQ0FBQyxzRUFBc0UsQ0FBQyxDQUFDO2dCQUNoRixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLDRFQUE0RSxDQUFDLENBQUM7Z0JBQ3RGLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsYUFBYSxDQUFDLENBQUM7Z0JBQ3ZCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsZUFBZSxDQUFDLENBQUM7Z0JBQ3pCLE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO2dCQUMvQixPQUFPLENBQUMsRUFBRSxFQUFFLElBQUksQ0FBQyxDQUFDO1lBQ3BCLENBQUMsQ0FBQztpQkFDRCxNQUFNLENBQUMsR0FBUyxFQUFFO2dCQUNqQixNQUFNLE9BQU8sR0FBRyxJQUFJLG9FQUFhLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLG9CQUFvQixDQUFDLENBQUM7Z0JBQzlFLE1BQU0sUUFBUSxHQUFHLE1BQU0sT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO2dCQUNyQyxJQUFJLENBQUMsZUFBZSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ2pDLENBQUMsRUFBQyxDQUFDO1lBRUwsOENBQU87aUJBQ0osT0FBTyxDQUFDLFlBQVksQ0FBQztpQkFDckIsV0FBVyxDQUFDLDZCQUE2QixDQUFDO2lCQUMxQyxNQUFNLENBQUMsaUJBQWlCLEVBQUUsb0NBQW9DLENBQUM7aUJBQy9ELEVBQUUsQ0FBQyxRQUFRLEVBQUUsR0FBRyxFQUFFO2dCQUNqQixPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7Z0JBQ3RCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsNkJBQTZCLENBQUMsQ0FBQztnQkFDdkMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2dCQUNaLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQztnQkFDdkIsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2dCQUNaLE9BQU8sQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO2dCQUN6QyxPQUFPLENBQUMsRUFBRSxFQUFFLElBQUksQ0FBQyxDQUFDO1lBQ3BCLENBQUMsQ0FBQztpQkFDRCxNQUFNLENBQUMsQ0FBTyxPQUFxQixFQUFFLEdBQVksRUFBRSxFQUFFO2dCQUNwRCxNQUFNLE9BQU8sR0FBRyxJQUFJLDJFQUFpQixFQUFFLENBQUM7Z0JBQ3hDLE1BQU0sUUFBUSxHQUFHLE1BQU0sT0FBTyxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQztnQkFDNUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUNqQyxDQUFDLEVBQUMsQ0FBQztZQUVMLDhDQUFPO2lCQUNKLE9BQU8sQ0FBQyxRQUFRLENBQUM7aUJBQ2pCLFdBQVcsQ0FBQyw2REFBNkQsQ0FBQztpQkFDMUUsRUFBRSxDQUFDLFFBQVEsRUFBRSxHQUFHLEVBQUU7Z0JBQ2pCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLHlCQUF5QixDQUFDLENBQUM7Z0JBQ25DLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsT0FBTyxDQUFDLENBQUM7Z0JBQ2pCLE9BQU8sQ0FBQyxxREFBcUQsQ0FBQyxDQUFDO2dCQUMvRCxPQUFPLENBQUMsK0NBQStDLENBQUMsQ0FBQztnQkFDekQsT0FBTyxDQUFDLHVDQUF1QyxDQUFDLENBQUM7Z0JBQ2pELE9BQU8sQ0FBQyx5REFBeUQsQ0FBQyxDQUFDO2dCQUNuRSxPQUFPLENBQUMsMEJBQTBCLENBQUMsQ0FBQztnQkFDcEMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO2dCQUNqQixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDO2dCQUNwQixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLHVCQUF1QixDQUFDLENBQUM7Z0JBQ2pDLE9BQU8sQ0FBQyxvREFBb0QsQ0FBQyxDQUFDO2dCQUM5RCxPQUFPLENBQUMsK0RBQStELENBQUMsQ0FBQztnQkFDekUsT0FBTyxDQUFDLG1FQUFtRSxDQUFDLENBQUM7Z0JBQzdFLE9BQU8sQ0FBQyxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDcEIsQ0FBQyxDQUFDO2lCQUNELE1BQU0sQ0FBQyxHQUFTLEVBQUU7Z0JBQ2pCLE1BQU0sT0FBTyxHQUFHLElBQUksb0VBQWEsQ0FDL0IsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGtCQUFrQixFQUN4QyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsV0FBVyxFQUNqQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsY0FBYyxFQUNwQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsV0FBVyxDQUNsQyxDQUFDO2dCQUNGLE1BQU0sUUFBUSxHQUFHLE1BQU0sT0FBTyxDQUFDLEdBQUcsRUFBRSxDQUFDO2dCQUNyQyxJQUFJLENBQUMsZUFBZSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ2pDLENBQUMsRUFBQyxDQUFDO1lBRUwsOENBQU87aUJBQ0osT0FBTyxDQUFDLE9BQU8sQ0FBQztpQkFDaEIsV0FBVyxDQUFDLGdDQUFnQyxDQUFDO2lCQUM3QyxNQUFNLENBQUMsdUJBQXVCLEVBQUUsNkNBQTZDLENBQUM7aUJBQzlFLE1BQU0sQ0FBQyxlQUFlLEVBQUUsd0NBQXdDLENBQUM7aUJBQ2pFLE1BQU0sQ0FDTCw2QkFBNkIsRUFDN0IsaUtBQWlLLENBQ2xLO2lCQUNBLEVBQUUsQ0FBQyxRQUFRLEVBQUUsR0FBRyxFQUFFO2dCQUNqQixPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7Z0JBQ3RCLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztnQkFDWixPQUFPLENBQUMsc0NBQXNDLENBQUMsQ0FBQztnQkFDaEQsT0FBTyxDQUFDLGlEQUFpRCxDQUFDLENBQUM7Z0JBQzNELE9BQU8sQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO2dCQUN2QyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLGFBQWEsQ0FBQyxDQUFDO2dCQUN2QixPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ1osT0FBTyxDQUFDLGNBQWMsQ0FBQyxDQUFDO2dCQUN4QixPQUFPLENBQUMsMEJBQTBCLENBQUMsQ0FBQztnQkFDcEMsT0FBTyxDQUFDLHNEQUFzRCxDQUFDLENBQUM7Z0JBQ2hFLE9BQU8sQ0FBQyxFQUFFLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDcEIsQ0FBQyxDQUFDO2lCQUNELE1BQU0sQ0FBQyxDQUFPLEdBQUcsRUFBRSxFQUFFO2dCQUNwQixNQUFNLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQztnQkFDN0IsTUFBTSxPQUFPLEdBQUcsSUFBSSxrRUFBWSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO2dCQUN4RCxNQUFNLE9BQU8sQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDekIsQ0FBQyxFQUFDLENBQUM7UUFDUCxDQUFDO0tBQUE7Q0FDRiIsInNvdXJjZXMiOlsid2VicGFjazovL0BiaXR3YXJkZW4vY2xpLy4vc3JjL3Byb2dyYW0udHM/YzQ4NyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjaGFsayBmcm9tIFwiY2hhbGtcIjtcbmltcG9ydCB7IHByb2dyYW0sIENvbW1hbmQsIE9wdGlvblZhbHVlcyB9IGZyb20gXCJjb21tYW5kZXJcIjtcbmltcG9ydCB7IGZpcnN0VmFsdWVGcm9tIH0gZnJvbSBcInJ4anNcIjtcblxuaW1wb3J0IHsgQXV0aGVudGljYXRpb25TdGF0dXMgfSBmcm9tIFwiQGJpdHdhcmRlbi9jb21tb24vYXV0aC9lbnVtcy9hdXRoZW50aWNhdGlvbi1zdGF0dXNcIjtcblxuaW1wb3J0IHsgTG9ja0NvbW1hbmQgfSBmcm9tIFwiLi9hdXRoL2NvbW1hbmRzL2xvY2suY29tbWFuZFwiO1xuaW1wb3J0IHsgTG9naW5Db21tYW5kIH0gZnJvbSBcIi4vYXV0aC9jb21tYW5kcy9sb2dpbi5jb21tYW5kXCI7XG5pbXBvcnQgeyBMb2dvdXRDb21tYW5kIH0gZnJvbSBcIi4vYXV0aC9jb21tYW5kcy9sb2dvdXQuY29tbWFuZFwiO1xuaW1wb3J0IHsgVW5sb2NrQ29tbWFuZCB9IGZyb20gXCIuL2F1dGgvY29tbWFuZHMvdW5sb2NrLmNvbW1hbmRcIjtcbmltcG9ydCB7IEJhc2VQcm9ncmFtIH0gZnJvbSBcIi4vYmFzZS1wcm9ncmFtXCI7XG5pbXBvcnQgeyBDb21wbGV0aW9uQ29tbWFuZCB9IGZyb20gXCIuL2NvbW1hbmRzL2NvbXBsZXRpb24uY29tbWFuZFwiO1xuaW1wb3J0IHsgQ29uZmlnQ29tbWFuZCB9IGZyb20gXCIuL2NvbW1hbmRzL2NvbmZpZy5jb21tYW5kXCI7XG5pbXBvcnQgeyBFbmNvZGVDb21tYW5kIH0gZnJvbSBcIi4vY29tbWFuZHMvZW5jb2RlLmNvbW1hbmRcIjtcbmltcG9ydCB7IFNlcnZlQ29tbWFuZCB9IGZyb20gXCIuL2NvbW1hbmRzL3NlcnZlLmNvbW1hbmRcIjtcbmltcG9ydCB7IFN0YXR1c0NvbW1hbmQgfSBmcm9tIFwiLi9jb21tYW5kcy9zdGF0dXMuY29tbWFuZFwiO1xuaW1wb3J0IHsgVXBkYXRlQ29tbWFuZCB9IGZyb20gXCIuL2NvbW1hbmRzL3VwZGF0ZS5jb21tYW5kXCI7XG5pbXBvcnQgeyBSZXNwb25zZSB9IGZyb20gXCIuL21vZGVscy9yZXNwb25zZVwiO1xuaW1wb3J0IHsgTWVzc2FnZVJlc3BvbnNlIH0gZnJvbSBcIi4vbW9kZWxzL3Jlc3BvbnNlL21lc3NhZ2UucmVzcG9uc2VcIjtcbmltcG9ydCB7IEdlbmVyYXRlQ29tbWFuZCB9IGZyb20gXCIuL3Rvb2xzL2dlbmVyYXRlLmNvbW1hbmRcIjtcbmltcG9ydCB7IENsaVV0aWxzIH0gZnJvbSBcIi4vdXRpbHNcIjtcbmltcG9ydCB7IFN5bmNDb21tYW5kIH0gZnJvbSBcIi4vdmF1bHQvc3luYy5jb21tYW5kXCI7XG5cbmNvbnN0IHdyaXRlTG4gPSBDbGlVdGlscy53cml0ZUxuO1xuXG5leHBvcnQgY2xhc3MgUHJvZ3JhbSBleHRlbmRzIEJhc2VQcm9ncmFtIHtcbiAgYXN5bmMgcmVnaXN0ZXIoKSB7XG4gICAgcHJvZ3JhbVxuICAgICAgLm9wdGlvbihcIi0tcHJldHR5XCIsIFwiRm9ybWF0IG91dHB1dC4gSlNPTiBpcyB0YWJiZWQgd2l0aCB0d28gc3BhY2VzLlwiKVxuICAgICAgLm9wdGlvbihcIi0tcmF3XCIsIFwiUmV0dXJuIHJhdyBvdXRwdXQgaW5zdGVhZCBvZiBhIGRlc2NyaXB0aXZlIG1lc3NhZ2UuXCIpXG4gICAgICAub3B0aW9uKFwiLS1yZXNwb25zZVwiLCBcIlJldHVybiBhIEpTT04gZm9ybWF0dGVkIHZlcnNpb24gb2YgcmVzcG9uc2Ugb3V0cHV0LlwiKVxuICAgICAgLm9wdGlvbihcIi0tY2xlYW5leGl0XCIsIFwiRXhpdCB3aXRoIGEgc3VjY2VzcyBleGl0IGNvZGUgKDApIHVubGVzcyBhbiBlcnJvciBpcyB0aHJvd24uXCIpXG4gICAgICAub3B0aW9uKFwiLS1xdWlldFwiLCBcIkRvbid0IHJldHVybiBhbnl0aGluZyB0byBzdGRvdXQuXCIpXG4gICAgICAub3B0aW9uKFwiLS1ub2ludGVyYWN0aW9uXCIsIFwiRG8gbm90IHByb21wdCBmb3IgaW50ZXJhY3RpdmUgdXNlciBpbnB1dC5cIilcbiAgICAgIC5vcHRpb24oXCItLXNlc3Npb24gPHNlc3Npb24+XCIsIFwiUGFzcyBzZXNzaW9uIGtleSBpbnN0ZWFkIG9mIHJlYWRpbmcgZnJvbSBlbnYuXCIpXG4gICAgICAudmVyc2lvbihcbiAgICAgICAgYXdhaXQgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLnBsYXRmb3JtVXRpbHNTZXJ2aWNlLmdldEFwcGxpY2F0aW9uVmVyc2lvbigpLFxuICAgICAgICBcIi12LCAtLXZlcnNpb25cIixcbiAgICAgICk7XG5cbiAgICBwcm9ncmFtLm9uKFwib3B0aW9uOnByZXR0eVwiLCAoKSA9PiB7XG4gICAgICBwcm9jZXNzLmVudi5CV19QUkVUVFkgPSBcInRydWVcIjtcbiAgICB9KTtcblxuICAgIHByb2dyYW0ub24oXCJvcHRpb246cmF3XCIsICgpID0+IHtcbiAgICAgIHByb2Nlc3MuZW52LkJXX1JBVyA9IFwidHJ1ZVwiO1xuICAgIH0pO1xuXG4gICAgcHJvZ3JhbS5vbihcIm9wdGlvbjpxdWlldFwiLCAoKSA9PiB7XG4gICAgICBwcm9jZXNzLmVudi5CV19RVUlFVCA9IFwidHJ1ZVwiO1xuICAgIH0pO1xuXG4gICAgcHJvZ3JhbS5vbihcIm9wdGlvbjpyZXNwb25zZVwiLCAoKSA9PiB7XG4gICAgICBwcm9jZXNzLmVudi5CV19SRVNQT05TRSA9IFwidHJ1ZVwiO1xuICAgIH0pO1xuXG4gICAgcHJvZ3JhbS5vbihcIm9wdGlvbjpjbGVhbmV4aXRcIiwgKCkgPT4ge1xuICAgICAgcHJvY2Vzcy5lbnYuQldfQ0xFQU5FWElUID0gXCJ0cnVlXCI7XG4gICAgfSk7XG5cbiAgICBwcm9ncmFtLm9uKFwib3B0aW9uOm5vaW50ZXJhY3Rpb25cIiwgKCkgPT4ge1xuICAgICAgcHJvY2Vzcy5lbnYuQldfTk9JTlRFUkFDVElPTiA9IFwidHJ1ZVwiO1xuICAgIH0pO1xuXG4gICAgcHJvZ3JhbS5vbihcIm9wdGlvbjpzZXNzaW9uXCIsIGFzeW5jIChrZXkpID0+IHtcbiAgICAgIHByb2Nlc3MuZW52LkJXX1NFU1NJT04gPSBrZXk7XG5cbiAgICAgIC8vIG9uY2Ugd2UgaGF2ZSB0aGUgc2Vzc2lvbiBrZXksIHdlIGNhbiBzZXQgdGhlIHVzZXIga2V5IGluIG1lbW9yeVxuICAgICAgY29uc3QgYWN0aXZlQWNjb3VudCA9IGF3YWl0IGZpcnN0VmFsdWVGcm9tKFxuICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIuYWNjb3VudFNlcnZpY2UuYWN0aXZlQWNjb3VudCQsXG4gICAgICApO1xuICAgICAgaWYgKGFjdGl2ZUFjY291bnQpIHtcbiAgICAgICAgYXdhaXQgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLnVzZXJBdXRvVW5sb2NrS2V5U2VydmljZS5zZXRVc2VyS2V5SW5NZW1vcnlJZkF1dG9Vc2VyS2V5U2V0KFxuICAgICAgICAgIGFjdGl2ZUFjY291bnQuaWQsXG4gICAgICAgICk7XG4gICAgICB9XG4gICAgfSk7XG5cbiAgICBwcm9ncmFtLm9uKFwiY29tbWFuZDoqXCIsICgpID0+IHtcbiAgICAgIHdyaXRlTG4oY2hhbGsucmVkQnJpZ2h0KFwiSW52YWxpZCBjb21tYW5kOiBcIiArIHByb2dyYW0uYXJncy5qb2luKFwiIFwiKSksIGZhbHNlLCB0cnVlKTtcbiAgICAgIHdyaXRlTG4oXCJTZWUgLS1oZWxwIGZvciBhIGxpc3Qgb2YgYXZhaWxhYmxlIGNvbW1hbmRzLlwiLCB0cnVlLCB0cnVlKTtcbiAgICAgIHByb2Nlc3MuZXhpdENvZGUgPSAxO1xuICAgIH0pO1xuXG4gICAgcHJvZ3JhbS5vbihcIi0taGVscFwiLCAoKSA9PiB7XG4gICAgICB3cml0ZUxuKFwiXFxuICBFeGFtcGxlczpcIik7XG4gICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgd3JpdGVMbihcIiAgICBidyBsb2dpblwiKTtcbiAgICAgIHdyaXRlTG4oXCIgICAgYncgbG9ja1wiKTtcbiAgICAgIHdyaXRlTG4oXCIgICAgYncgdW5sb2NrIG15UGFzc3dvcmQzMjFcIik7XG4gICAgICB3cml0ZUxuKFwiICAgIGJ3IGxpc3QgLS1oZWxwXCIpO1xuICAgICAgd3JpdGVMbihcIiAgICBidyBsaXN0IGl0ZW1zIC0tc2VhcmNoIGdvb2dsZVwiKTtcbiAgICAgIHdyaXRlTG4oXCIgICAgYncgZ2V0IGl0ZW0gOTllZTg4ZDItNjA0Ni00ZWE3LTkyYzItYWNhYzQ2NGIxNDEyXCIpO1xuICAgICAgd3JpdGVMbihcIiAgICBidyBnZXQgcGFzc3dvcmQgZ29vZ2xlLmNvbVwiKTtcbiAgICAgIHdyaXRlTG4oJyAgICBlY2hvIFxcJ3tcIm5hbWVcIjpcIk15IEZvbGRlclwifVxcJyB8IGJ3IGVuY29kZScpO1xuICAgICAgd3JpdGVMbihcIiAgICBidyBjcmVhdGUgZm9sZGVyIGV5SnVZVzFsSWpvaVRYa2dSbTlzWkdWeUluMEtcIik7XG4gICAgICB3cml0ZUxuKFxuICAgICAgICBcIiAgICBidyBlZGl0IGZvbGRlciBjN2M3YjYwYi05YzYxLTQwZjItOGNjZC0zNmM0OTU5NWVkNzIgZXlKdVlXMWxJam9pVFhrZ1JtOXNaR1Z5TWlKOUNnPT1cIixcbiAgICAgICk7XG4gICAgICB3cml0ZUxuKFwiICAgIGJ3IGRlbGV0ZSBpdGVtIDk5ZWU4OGQyLTYwNDYtNGVhNy05MmMyLWFjYWM0NjRiMTQxMlwiKTtcbiAgICAgIHdyaXRlTG4oXCIgICAgYncgZ2VuZXJhdGUgLWx1c24gLS1sZW5ndGggMThcIik7XG4gICAgICB3cml0ZUxuKFwiICAgIGJ3IGNvbmZpZyBzZXJ2ZXIgaHR0cHM6Ly9iaXR3YXJkZW4uZXhhbXBsZS5jb21cIik7XG4gICAgICB3cml0ZUxuKFwiICAgIGJ3IHNlbmQgLWYgLi9maWxlLmV4dFwiKTtcbiAgICAgIHdyaXRlTG4oJyAgICBidyBzZW5kIFwidGV4dCB0byBzZW5kXCInKTtcbiAgICAgIHdyaXRlTG4oJyAgICBlY2hvIFwidGV4dCB0byBzZW5kXCIgfCBidyBzZW5kJyk7XG4gICAgICB3cml0ZUxuKFxuICAgICAgICBcIiAgICBidyByZWNlaXZlIGh0dHBzOi8vdmF1bHQuYml0d2FyZGVuLmNvbS8jL3NlbmQvcmczaXVvU19Ba20yZ3F5NkFEUkhtZy9IdDdkWWpzcWptZ3FVTTNyanpaRFNRXCIsXG4gICAgICApO1xuICAgICAgd3JpdGVMbihcIlwiLCB0cnVlKTtcbiAgICB9KTtcblxuICAgIHByb2dyYW1cbiAgICAgIC5jb21tYW5kKFwibG9naW4gW2VtYWlsXSBbcGFzc3dvcmRdXCIpXG4gICAgICAuZGVzY3JpcHRpb24oXCJMb2cgaW50byBhIHVzZXIgYWNjb3VudC5cIilcbiAgICAgIC5vcHRpb24oXCItLW1ldGhvZCA8bWV0aG9kPlwiLCBcIlR3by1zdGVwIGxvZ2luIG1ldGhvZC5cIilcbiAgICAgIC5vcHRpb24oXCItLWNvZGUgPGNvZGU+XCIsIFwiVHdvLXN0ZXAgbG9naW4gY29kZS5cIilcbiAgICAgIC5vcHRpb24oXCItLXNzb1wiLCBcIkxvZyBpbiB3aXRoIFNpbmdsZS1TaWduIE9uLlwiKVxuICAgICAgLm9wdGlvbihcIi0tYXBpa2V5XCIsIFwiTG9nIGluIHdpdGggYW4gQXBpIEtleS5cIilcbiAgICAgIC5vcHRpb24oXCItLXBhc3N3b3JkZW52IDxwYXNzd29yZGVudj5cIiwgXCJFbnZpcm9ubWVudCB2YXJpYWJsZSBzdG9yaW5nIHlvdXIgcGFzc3dvcmRcIilcbiAgICAgIC5vcHRpb24oXG4gICAgICAgIFwiLS1wYXNzd29yZGZpbGUgPHBhc3N3b3JkZmlsZT5cIixcbiAgICAgICAgXCJQYXRoIHRvIGEgZmlsZSBjb250YWluaW5nIHlvdXIgcGFzc3dvcmQgYXMgaXRzIGZpcnN0IGxpbmVcIixcbiAgICAgIClcbiAgICAgIC5vcHRpb24oXCItLWNoZWNrXCIsIFwiQ2hlY2sgbG9naW4gc3RhdHVzLlwiLCBhc3luYyAoKSA9PiB7XG4gICAgICAgIGNvbnN0IGF1dGhlZCA9IGF3YWl0IHRoaXMuc2VydmljZUNvbnRhaW5lci5zdGF0ZVNlcnZpY2UuZ2V0SXNBdXRoZW50aWNhdGVkKCk7XG4gICAgICAgIGlmIChhdXRoZWQpIHtcbiAgICAgICAgICBjb25zdCByZXMgPSBuZXcgTWVzc2FnZVJlc3BvbnNlKFwiWW91IGFyZSBsb2dnZWQgaW4hXCIsIG51bGwpO1xuICAgICAgICAgIHRoaXMucHJvY2Vzc1Jlc3BvbnNlKFJlc3BvbnNlLnN1Y2Nlc3MocmVzKSwgdHJ1ZSk7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5wcm9jZXNzUmVzcG9uc2UoUmVzcG9uc2UuZXJyb3IoXCJZb3UgYXJlIG5vdCBsb2dnZWQgaW4uXCIpLCB0cnVlKTtcbiAgICAgIH0pXG4gICAgICAub24oXCItLWhlbHBcIiwgKCkgPT4ge1xuICAgICAgICB3cml0ZUxuKFwiXFxuICBOb3RlczpcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgU2VlIGRvY3MgZm9yIHZhbGlkIGBtZXRob2RgIGVudW0gdmFsdWVzLlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBQYXNzIGAtLXJhd2Agb3B0aW9uIHRvIG9ubHkgcmV0dXJuIHRoZSBzZXNzaW9uIGtleS5cIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgIEV4YW1wbGVzOlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyBsb2dpblwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyBsb2dpbiBqb2huQGV4YW1wbGUuY29tIG15UGFzc3dvcmQzMjEgLS1yYXdcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgbG9naW4gam9obkBleGFtcGxlLmNvbSBteVBhc3N3b3JkMzIxIC0tbWV0aG9kIDEgLS1jb2RlIDI0OTIxM1wiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyBsb2dpbiAtLXNzb1wiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiLCB0cnVlKTtcbiAgICAgIH0pXG4gICAgICAuYWN0aW9uKGFzeW5jIChlbWFpbDogc3RyaW5nLCBwYXNzd29yZDogc3RyaW5nLCBvcHRpb25zOiBPcHRpb25WYWx1ZXMpID0+IHtcbiAgICAgICAgaWYgKCFvcHRpb25zLmNoZWNrKSB7XG4gICAgICAgICAgYXdhaXQgdGhpcy5leGl0SWZBdXRoZWQoKTtcbiAgICAgICAgICBjb25zdCBjb21tYW5kID0gbmV3IExvZ2luQ29tbWFuZChcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5sb2dpblN0cmF0ZWd5U2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5hdXRoU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5hcGlTZXJ2aWNlLFxuICAgICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmNyeXB0b0Z1bmN0aW9uU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5lbnZpcm9ubWVudFNlcnZpY2UsXG4gICAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIucGFzc3dvcmRHZW5lcmF0aW9uU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5wYXNzd29yZFN0cmVuZ3RoU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5wbGF0Zm9ybVV0aWxzU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5hY2NvdW50U2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5jcnlwdG9TZXJ2aWNlLFxuICAgICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLnBvbGljeVNlcnZpY2UsXG4gICAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIudHdvRmFjdG9yU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5zeW5jU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5rZXlDb25uZWN0b3JTZXJ2aWNlLFxuICAgICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLnBvbGljeUFwaVNlcnZpY2UsXG4gICAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIub3JnYW5pemF0aW9uU2VydmljZSxcbiAgICAgICAgICAgIGFzeW5jICgpID0+IGF3YWl0IHRoaXMuc2VydmljZUNvbnRhaW5lci5sb2dvdXQoKSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5rZGZDb25maWdTZXJ2aWNlLFxuICAgICAgICAgICk7XG4gICAgICAgICAgY29uc3QgcmVzcG9uc2UgPSBhd2FpdCBjb21tYW5kLnJ1bihlbWFpbCwgcGFzc3dvcmQsIG9wdGlvbnMpO1xuICAgICAgICAgIHRoaXMucHJvY2Vzc1Jlc3BvbnNlKHJlc3BvbnNlLCB0cnVlKTtcbiAgICAgICAgfVxuICAgICAgfSk7XG5cbiAgICBwcm9ncmFtXG4gICAgICAuY29tbWFuZChcImxvZ291dFwiKVxuICAgICAgLmRlc2NyaXB0aW9uKFwiTG9nIG91dCBvZiB0aGUgY3VycmVudCB1c2VyIGFjY291bnQuXCIpXG4gICAgICAub24oXCItLWhlbHBcIiwgKCkgPT4ge1xuICAgICAgICB3cml0ZUxuKFwiXFxuICBFeGFtcGxlczpcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgbG9nb3V0XCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIsIHRydWUpO1xuICAgICAgfSlcbiAgICAgIC5hY3Rpb24oYXN5bmMgKGNtZCkgPT4ge1xuICAgICAgICBhd2FpdCB0aGlzLmV4aXRJZk5vdEF1dGhlZCgpO1xuICAgICAgICBjb25zdCBjb21tYW5kID0gbmV3IExvZ291dENvbW1hbmQoXG4gICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmF1dGhTZXJ2aWNlLFxuICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5pMThuU2VydmljZSxcbiAgICAgICAgICBhc3luYyAoKSA9PiBhd2FpdCB0aGlzLnNlcnZpY2VDb250YWluZXIubG9nb3V0KCksXG4gICAgICAgICk7XG4gICAgICAgIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgY29tbWFuZC5ydW4oKTtcbiAgICAgICAgdGhpcy5wcm9jZXNzUmVzcG9uc2UocmVzcG9uc2UpO1xuICAgICAgfSk7XG5cbiAgICBwcm9ncmFtXG4gICAgICAuY29tbWFuZChcImxvY2tcIilcbiAgICAgIC5kZXNjcmlwdGlvbihcIkxvY2sgdGhlIHZhdWx0IGFuZCBkZXN0cm95IGFjdGl2ZSBzZXNzaW9uIGtleXMuXCIpXG4gICAgICAub24oXCItLWhlbHBcIiwgKCkgPT4ge1xuICAgICAgICB3cml0ZUxuKFwiXFxuICBFeGFtcGxlczpcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgbG9ja1wiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiLCB0cnVlKTtcbiAgICAgIH0pXG4gICAgICAuYWN0aW9uKGFzeW5jIChjbWQpID0+IHtcbiAgICAgICAgYXdhaXQgdGhpcy5leGl0SWZOb3RBdXRoZWQoKTtcblxuICAgICAgICBpZiAoYXdhaXQgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmtleUNvbm5lY3RvclNlcnZpY2UuZ2V0VXNlc0tleUNvbm5lY3RvcigpKSB7XG4gICAgICAgICAgY29uc3QgbG9nb3V0Q29tbWFuZCA9IG5ldyBMb2dvdXRDb21tYW5kKFxuICAgICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmF1dGhTZXJ2aWNlLFxuICAgICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmkxOG5TZXJ2aWNlLFxuICAgICAgICAgICAgYXN5bmMgKCkgPT4gYXdhaXQgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmxvZ291dCgpLFxuICAgICAgICAgICk7XG4gICAgICAgICAgYXdhaXQgbG9nb3V0Q29tbWFuZC5ydW4oKTtcbiAgICAgICAgICB0aGlzLnByb2Nlc3NSZXNwb25zZShcbiAgICAgICAgICAgIFJlc3BvbnNlLmVycm9yKFxuICAgICAgICAgICAgICBcIllvdSBjYW5ub3QgbG9jayB5b3VyIHZhdWx0IGJlY2F1c2UgeW91IGFyZSB1c2luZyBLZXkgQ29ubmVjdG9yLiBcIiArXG4gICAgICAgICAgICAgICAgXCJUbyBwcm90ZWN0IHlvdXIgdmF1bHQsIHlvdSBoYXZlIGJlZW4gbG9nZ2VkIG91dC5cIixcbiAgICAgICAgICAgICksXG4gICAgICAgICAgICB0cnVlLFxuICAgICAgICAgICk7XG4gICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgY29uc3QgY29tbWFuZCA9IG5ldyBMb2NrQ29tbWFuZCh0aGlzLnNlcnZpY2VDb250YWluZXIudmF1bHRUaW1lb3V0U2VydmljZSk7XG4gICAgICAgIGNvbnN0IHJlc3BvbnNlID0gYXdhaXQgY29tbWFuZC5ydW4oKTtcbiAgICAgICAgdGhpcy5wcm9jZXNzUmVzcG9uc2UocmVzcG9uc2UpO1xuICAgICAgfSk7XG5cbiAgICBwcm9ncmFtXG4gICAgICAuY29tbWFuZChcInVubG9jayBbcGFzc3dvcmRdXCIpXG4gICAgICAuZGVzY3JpcHRpb24oXCJVbmxvY2sgdGhlIHZhdWx0IGFuZCByZXR1cm4gYSBuZXcgc2Vzc2lvbiBrZXkuXCIpXG4gICAgICAub24oXCItLWhlbHBcIiwgKCkgPT4ge1xuICAgICAgICB3cml0ZUxuKFwiXFxuICBOb3RlczpcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgQWZ0ZXIgdW5sb2NraW5nLCBhbnkgcHJldmlvdXMgc2Vzc2lvbiBrZXlzIHdpbGwgbm8gbG9uZ2VyIGJlIHZhbGlkLlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBQYXNzIGAtLXJhd2Agb3B0aW9uIHRvIG9ubHkgcmV0dXJuIHRoZSBzZXNzaW9uIGtleS5cIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgIEV4YW1wbGVzOlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyB1bmxvY2tcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgdW5sb2NrIG15UGFzc3dvcmQzMjFcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgdW5sb2NrIG15UGFzc3dvcmQzMjEgLS1yYXdcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIiwgdHJ1ZSk7XG4gICAgICB9KVxuICAgICAgLm9wdGlvbihcIi0tY2hlY2tcIiwgXCJDaGVjayBsb2NrIHN0YXR1cy5cIiwgYXN5bmMgKCkgPT4ge1xuICAgICAgICBhd2FpdCB0aGlzLmV4aXRJZk5vdEF1dGhlZCgpO1xuXG4gICAgICAgIGNvbnN0IGF1dGhTdGF0dXMgPSBhd2FpdCB0aGlzLnNlcnZpY2VDb250YWluZXIuYXV0aFNlcnZpY2UuZ2V0QXV0aFN0YXR1cygpO1xuICAgICAgICBpZiAoYXV0aFN0YXR1cyA9PT0gQXV0aGVudGljYXRpb25TdGF0dXMuVW5sb2NrZWQpIHtcbiAgICAgICAgICBjb25zdCByZXMgPSBuZXcgTWVzc2FnZVJlc3BvbnNlKFwiVmF1bHQgaXMgdW5sb2NrZWQhXCIsIG51bGwpO1xuICAgICAgICAgIHRoaXMucHJvY2Vzc1Jlc3BvbnNlKFJlc3BvbnNlLnN1Y2Nlc3MocmVzKSwgdHJ1ZSk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgdGhpcy5wcm9jZXNzUmVzcG9uc2UoUmVzcG9uc2UuZXJyb3IoXCJWYXVsdCBpcyBsb2NrZWQuXCIpLCB0cnVlKTtcbiAgICAgICAgfVxuICAgICAgfSlcbiAgICAgIC5vcHRpb24oXCItLXBhc3N3b3JkZW52IDxwYXNzd29yZGVudj5cIiwgXCJFbnZpcm9ubWVudCB2YXJpYWJsZSBzdG9yaW5nIHlvdXIgcGFzc3dvcmRcIilcbiAgICAgIC5vcHRpb24oXG4gICAgICAgIFwiLS1wYXNzd29yZGZpbGUgPHBhc3N3b3JkZmlsZT5cIixcbiAgICAgICAgXCJQYXRoIHRvIGEgZmlsZSBjb250YWluaW5nIHlvdXIgcGFzc3dvcmQgYXMgaXRzIGZpcnN0IGxpbmVcIixcbiAgICAgIClcbiAgICAgIC5hY3Rpb24oYXN5bmMgKHBhc3N3b3JkLCBjbWQpID0+IHtcbiAgICAgICAgaWYgKCFjbWQuY2hlY2spIHtcbiAgICAgICAgICBhd2FpdCB0aGlzLmV4aXRJZk5vdEF1dGhlZCgpO1xuICAgICAgICAgIGNvbnN0IGNvbW1hbmQgPSBuZXcgVW5sb2NrQ29tbWFuZChcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5hY2NvdW50U2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5tYXN0ZXJQYXNzd29yZFNlcnZpY2UsXG4gICAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIuY3J5cHRvU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5zdGF0ZVNlcnZpY2UsXG4gICAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIuY3J5cHRvRnVuY3Rpb25TZXJ2aWNlLFxuICAgICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmFwaVNlcnZpY2UsXG4gICAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIubG9nU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5rZXlDb25uZWN0b3JTZXJ2aWNlLFxuICAgICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmVudmlyb25tZW50U2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5zeW5jU2VydmljZSxcbiAgICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5vcmdhbml6YXRpb25BcGlTZXJ2aWNlLFxuICAgICAgICAgICAgYXN5bmMgKCkgPT4gYXdhaXQgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmxvZ291dCgpLFxuICAgICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmtkZkNvbmZpZ1NlcnZpY2UsXG4gICAgICAgICAgKTtcbiAgICAgICAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IGNvbW1hbmQucnVuKHBhc3N3b3JkLCBjbWQpO1xuICAgICAgICAgIHRoaXMucHJvY2Vzc1Jlc3BvbnNlKHJlc3BvbnNlKTtcbiAgICAgICAgfVxuICAgICAgfSk7XG5cbiAgICBwcm9ncmFtXG4gICAgICAuY29tbWFuZChcInN5bmNcIilcbiAgICAgIC5kZXNjcmlwdGlvbihcIlB1bGwgdGhlIGxhdGVzdCB2YXVsdCBkYXRhIGZyb20gc2VydmVyLlwiKVxuICAgICAgLm9wdGlvbihcIi1mLCAtLWZvcmNlXCIsIFwiRm9yY2UgYSBmdWxsIHN5bmMuXCIpXG4gICAgICAub3B0aW9uKFwiLS1sYXN0XCIsIFwiR2V0IHRoZSBsYXN0IHN5bmMgZGF0ZS5cIilcbiAgICAgIC5vbihcIi0taGVscFwiLCAoKSA9PiB7XG4gICAgICAgIHdyaXRlTG4oXCJcXG4gIEV4YW1wbGVzOlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyBzeW5jXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIGJ3IHN5bmMgLWZcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgc3luYyAtLWxhc3RcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIiwgdHJ1ZSk7XG4gICAgICB9KVxuICAgICAgLmFjdGlvbihhc3luYyAoY21kKSA9PiB7XG4gICAgICAgIGF3YWl0IHRoaXMuZXhpdElmTm90QXV0aGVkKCk7XG4gICAgICAgIGNvbnN0IGNvbW1hbmQgPSBuZXcgU3luY0NvbW1hbmQodGhpcy5zZXJ2aWNlQ29udGFpbmVyLnN5bmNTZXJ2aWNlKTtcbiAgICAgICAgY29uc3QgcmVzcG9uc2UgPSBhd2FpdCBjb21tYW5kLnJ1bihjbWQpO1xuICAgICAgICB0aGlzLnByb2Nlc3NSZXNwb25zZShyZXNwb25zZSk7XG4gICAgICB9KTtcblxuICAgIHByb2dyYW1cbiAgICAgIC5jb21tYW5kKFwiZ2VuZXJhdGVcIilcbiAgICAgIC5kZXNjcmlwdGlvbihcIkdlbmVyYXRlIGEgcGFzc3dvcmQvcGFzc3BocmFzZS5cIilcbiAgICAgIC5vcHRpb24oXCItdSwgLS11cHBlcmNhc2VcIiwgXCJJbmNsdWRlIHVwcGVyY2FzZSBjaGFyYWN0ZXJzLlwiKVxuICAgICAgLm9wdGlvbihcIi1sLCAtLWxvd2VyY2FzZVwiLCBcIkluY2x1ZGUgbG93ZXJjYXNlIGNoYXJhY3RlcnMuXCIpXG4gICAgICAub3B0aW9uKFwiLW4sIC0tbnVtYmVyXCIsIFwiSW5jbHVkZSBudW1lcmljIGNoYXJhY3RlcnMuXCIpXG4gICAgICAub3B0aW9uKFwiLXMsIC0tc3BlY2lhbFwiLCBcIkluY2x1ZGUgc3BlY2lhbCBjaGFyYWN0ZXJzLlwiKVxuICAgICAgLm9wdGlvbihcIi1wLCAtLXBhc3NwaHJhc2VcIiwgXCJHZW5lcmF0ZSBhIHBhc3NwaHJhc2UuXCIpXG4gICAgICAub3B0aW9uKFwiLS1sZW5ndGggPGxlbmd0aD5cIiwgXCJMZW5ndGggb2YgdGhlIHBhc3N3b3JkLlwiKVxuICAgICAgLm9wdGlvbihcIi0td29yZHMgPHdvcmRzPlwiLCBcIk51bWJlciBvZiB3b3Jkcy5cIilcbiAgICAgIC5vcHRpb24oXCItLW1pbk51bWJlciA8Y291bnQ+XCIsIFwiTWluaW11bSBudW1iZXIgb2YgbnVtZXJpYyBjaGFyYWN0ZXJzLlwiKVxuICAgICAgLm9wdGlvbihcIi0tbWluU3BlY2lhbCA8Y291bnQ+XCIsIFwiTWluaW11bSBudW1iZXIgb2Ygc3BlY2lhbCBjaGFyYWN0ZXJzLlwiKVxuICAgICAgLm9wdGlvbihcIi0tc2VwYXJhdG9yIDxzZXBhcmF0b3I+XCIsIFwiV29yZCBzZXBhcmF0b3IuXCIpXG4gICAgICAub3B0aW9uKFwiLWMsIC0tY2FwaXRhbGl6ZVwiLCBcIlRpdGxlIGNhc2UgcGFzc3BocmFzZS5cIilcbiAgICAgIC5vcHRpb24oXCItLWluY2x1ZGVOdW1iZXJcIiwgXCJQYXNzcGhyYXNlIGluY2x1ZGVzIG51bWJlci5cIilcbiAgICAgIC5vcHRpb24oXCItLWFtYmlndW91c1wiLCBcIkF2b2lkIGFtYmlndW91cyBjaGFyYWN0ZXJzLlwiKVxuICAgICAgLm9uKFwiLS1oZWxwXCIsICgpID0+IHtcbiAgICAgICAgd3JpdGVMbihcIlxcbiAgTm90ZXM6XCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIERlZmF1bHQgb3B0aW9ucyBhcmUgYC11bG4gLS1sZW5ndGggMTRgLlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBNaW5pbXVtIGBsZW5ndGhgIGlzIDUuXCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIE1pbmltdW0gYHdvcmRzYCBpcyAzLlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgRXhhbXBsZXM6XCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIGJ3IGdlbmVyYXRlXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIGJ3IGdlbmVyYXRlIC11IC1sIC0tbGVuZ3RoIDE4XCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIGJ3IGdlbmVyYXRlIC11bG5zIC0tbGVuZ3RoIDI1XCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIGJ3IGdlbmVyYXRlIC11bFwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyBnZW5lcmF0ZSAtcCAtLXNlcGFyYXRvciBfXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIGJ3IGdlbmVyYXRlIC1wIC0td29yZHMgNSAtLXNlcGFyYXRvciBzcGFjZVwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyBnZW5lcmF0ZSAtcCAtLXdvcmRzIDUgLS1zZXBhcmF0b3IgZW1wdHlcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIiwgdHJ1ZSk7XG4gICAgICB9KVxuICAgICAgLmFjdGlvbihhc3luYyAob3B0aW9ucykgPT4ge1xuICAgICAgICBjb25zdCBjb21tYW5kID0gbmV3IEdlbmVyYXRlQ29tbWFuZChcbiAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIucGFzc3dvcmRHZW5lcmF0aW9uU2VydmljZSxcbiAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIuc3RhdGVTZXJ2aWNlLFxuICAgICAgICApO1xuICAgICAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IGNvbW1hbmQucnVuKG9wdGlvbnMpO1xuICAgICAgICB0aGlzLnByb2Nlc3NSZXNwb25zZShyZXNwb25zZSk7XG4gICAgICB9KTtcblxuICAgIHByb2dyYW1cbiAgICAgIC5jb21tYW5kKFwiZW5jb2RlXCIpXG4gICAgICAuZGVzY3JpcHRpb24oXCJCYXNlIDY0IGVuY29kZSBzdGRpbi5cIilcbiAgICAgIC5vbihcIi0taGVscFwiLCAoKSA9PiB7XG4gICAgICAgIHdyaXRlTG4oXCJcXG4gIE5vdGVzOlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBVc2UgdG8gY3JlYXRlIGBlbmNvZGVkSnNvbmAgZm9yIGBjcmVhdGVgIGFuZCBgZWRpdGAgY29tbWFuZHMuXCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICBFeGFtcGxlczpcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oJyAgICBlY2hvIFxcJ3tcIm5hbWVcIjpcIk15IEZvbGRlclwifVxcJyB8IGJ3IGVuY29kZScpO1xuICAgICAgICB3cml0ZUxuKFwiXCIsIHRydWUpO1xuICAgICAgfSlcbiAgICAgIC5hY3Rpb24oYXN5bmMgKCkgPT4ge1xuICAgICAgICBjb25zdCBjb21tYW5kID0gbmV3IEVuY29kZUNvbW1hbmQoKTtcbiAgICAgICAgY29uc3QgcmVzcG9uc2UgPSBhd2FpdCBjb21tYW5kLnJ1bigpO1xuICAgICAgICB0aGlzLnByb2Nlc3NSZXNwb25zZShyZXNwb25zZSk7XG4gICAgICB9KTtcblxuICAgIHByb2dyYW1cbiAgICAgIC5jb21tYW5kKFwiY29uZmlnIDxzZXR0aW5nPiBbdmFsdWVdXCIpXG4gICAgICAuZGVzY3JpcHRpb24oXCJDb25maWd1cmUgQ0xJIHNldHRpbmdzLlwiKVxuICAgICAgLm9wdGlvbihcbiAgICAgICAgXCItLXdlYi12YXVsdCA8dXJsPlwiLFxuICAgICAgICBcIlByb3ZpZGVzIGEgY3VzdG9tIHdlYiB2YXVsdCBVUkwgdGhhdCBkaWZmZXJzIGZyb20gdGhlIGJhc2UgVVJMLlwiLFxuICAgICAgKVxuICAgICAgLm9wdGlvbihcIi0tYXBpIDx1cmw+XCIsIFwiUHJvdmlkZXMgYSBjdXN0b20gQVBJIFVSTCB0aGF0IGRpZmZlcnMgZnJvbSB0aGUgYmFzZSBVUkwuXCIpXG4gICAgICAub3B0aW9uKFwiLS1pZGVudGl0eSA8dXJsPlwiLCBcIlByb3ZpZGVzIGEgY3VzdG9tIGlkZW50aXR5IFVSTCB0aGF0IGRpZmZlcnMgZnJvbSB0aGUgYmFzZSBVUkwuXCIpXG4gICAgICAub3B0aW9uKFxuICAgICAgICBcIi0taWNvbnMgPHVybD5cIixcbiAgICAgICAgXCJQcm92aWRlcyBhIGN1c3RvbSBpY29ucyBzZXJ2aWNlIFVSTCB0aGF0IGRpZmZlcnMgZnJvbSB0aGUgYmFzZSBVUkwuXCIsXG4gICAgICApXG4gICAgICAub3B0aW9uKFxuICAgICAgICBcIi0tbm90aWZpY2F0aW9ucyA8dXJsPlwiLFxuICAgICAgICBcIlByb3ZpZGVzIGEgY3VzdG9tIG5vdGlmaWNhdGlvbnMgVVJMIHRoYXQgZGlmZmVycyBmcm9tIHRoZSBiYXNlIFVSTC5cIixcbiAgICAgIClcbiAgICAgIC5vcHRpb24oXCItLWV2ZW50cyA8dXJsPlwiLCBcIlByb3ZpZGVzIGEgY3VzdG9tIGV2ZW50cyBVUkwgdGhhdCBkaWZmZXJzIGZyb20gdGhlIGJhc2UgVVJMLlwiKVxuICAgICAgLm9wdGlvbihcIi0ta2V5LWNvbm5lY3RvciA8dXJsPlwiLCBcIlByb3ZpZGVzIHRoZSBVUkwgZm9yIHlvdXIgS2V5IENvbm5lY3RvciBzZXJ2ZXIuXCIpXG4gICAgICAub24oXCItLWhlbHBcIiwgKCkgPT4ge1xuICAgICAgICB3cml0ZUxuKFwiXFxuICBTZXR0aW5nczpcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgc2VydmVyIC0gT24tcHJlbWlzZXMgaG9zdGVkIGluc3RhbGxhdGlvbiBVUkwuXCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICBFeGFtcGxlczpcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgY29uZmlnIHNlcnZlclwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyBjb25maWcgc2VydmVyIGh0dHBzOi8vYncuY29tcGFueS5jb21cIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgY29uZmlnIHNlcnZlciBiaXR3YXJkZW4uY29tXCIpO1xuICAgICAgICB3cml0ZUxuKFxuICAgICAgICAgIFwiICAgIGJ3IGNvbmZpZyBzZXJ2ZXIgLS1hcGkgaHR0cDovL2xvY2FsaG9zdDo0MDAwIC0taWRlbnRpdHkgaHR0cDovL2xvY2FsaG9zdDozMzY1NlwiLFxuICAgICAgICApO1xuICAgICAgICB3cml0ZUxuKFwiXCIsIHRydWUpO1xuICAgICAgfSlcbiAgICAgIC5hY3Rpb24oYXN5bmMgKHNldHRpbmcsIHZhbHVlLCBvcHRpb25zKSA9PiB7XG4gICAgICAgIGNvbnN0IGNvbW1hbmQgPSBuZXcgQ29uZmlnQ29tbWFuZCh0aGlzLnNlcnZpY2VDb250YWluZXIuZW52aXJvbm1lbnRTZXJ2aWNlKTtcbiAgICAgICAgY29uc3QgcmVzcG9uc2UgPSBhd2FpdCBjb21tYW5kLnJ1bihzZXR0aW5nLCB2YWx1ZSwgb3B0aW9ucyk7XG4gICAgICAgIHRoaXMucHJvY2Vzc1Jlc3BvbnNlKHJlc3BvbnNlKTtcbiAgICAgIH0pO1xuXG4gICAgcHJvZ3JhbVxuICAgICAgLmNvbW1hbmQoXCJ1cGRhdGVcIilcbiAgICAgIC5kZXNjcmlwdGlvbihcIkNoZWNrIGZvciB1cGRhdGVzLlwiKVxuICAgICAgLm9uKFwiLS1oZWxwXCIsICgpID0+IHtcbiAgICAgICAgd3JpdGVMbihcIlxcbiAgTm90ZXM6XCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIFJldHVybnMgdGhlIFVSTCB0byBkb3dubG9hZCB0aGUgbmV3ZXN0IHZlcnNpb24gb2YgdGhpcyBDTEkgdG9vbC5cIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgVXNlIHRoZSBgLS1yYXdgIG9wdGlvbiB0byByZXR1cm4gb25seSB0aGUgZG93bmxvYWQgVVJMIGZvciB0aGUgdXBkYXRlLlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgRXhhbXBsZXM6XCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIGJ3IHVwZGF0ZVwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyB1cGRhdGUgLS1yYXdcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIiwgdHJ1ZSk7XG4gICAgICB9KVxuICAgICAgLmFjdGlvbihhc3luYyAoKSA9PiB7XG4gICAgICAgIGNvbnN0IGNvbW1hbmQgPSBuZXcgVXBkYXRlQ29tbWFuZCh0aGlzLnNlcnZpY2VDb250YWluZXIucGxhdGZvcm1VdGlsc1NlcnZpY2UpO1xuICAgICAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IGNvbW1hbmQucnVuKCk7XG4gICAgICAgIHRoaXMucHJvY2Vzc1Jlc3BvbnNlKHJlc3BvbnNlKTtcbiAgICAgIH0pO1xuXG4gICAgcHJvZ3JhbVxuICAgICAgLmNvbW1hbmQoXCJjb21wbGV0aW9uXCIpXG4gICAgICAuZGVzY3JpcHRpb24oXCJHZW5lcmF0ZSBzaGVsbCBjb21wbGV0aW9ucy5cIilcbiAgICAgIC5vcHRpb24oXCItLXNoZWxsIDxzaGVsbD5cIiwgXCJTaGVsbCB0byBnZW5lcmF0ZSBjb21wbGV0aW9ucyBmb3IuXCIpXG4gICAgICAub24oXCItLWhlbHBcIiwgKCkgPT4ge1xuICAgICAgICB3cml0ZUxuKFwiXFxuICBOb3RlczpcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgVmFsaWQgc2hlbGxzIGFyZSBgenNoYC5cIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgIEV4YW1wbGVzOlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBidyBjb21wbGV0aW9uIC0tc2hlbGwgenNoXCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIsIHRydWUpO1xuICAgICAgfSlcbiAgICAgIC5hY3Rpb24oYXN5bmMgKG9wdGlvbnM6IE9wdGlvblZhbHVlcywgY21kOiBDb21tYW5kKSA9PiB7XG4gICAgICAgIGNvbnN0IGNvbW1hbmQgPSBuZXcgQ29tcGxldGlvbkNvbW1hbmQoKTtcbiAgICAgICAgY29uc3QgcmVzcG9uc2UgPSBhd2FpdCBjb21tYW5kLnJ1bihvcHRpb25zKTtcbiAgICAgICAgdGhpcy5wcm9jZXNzUmVzcG9uc2UocmVzcG9uc2UpO1xuICAgICAgfSk7XG5cbiAgICBwcm9ncmFtXG4gICAgICAuY29tbWFuZChcInN0YXR1c1wiKVxuICAgICAgLmRlc2NyaXB0aW9uKFwiU2hvdyBzZXJ2ZXIsIGxhc3Qgc3luYywgdXNlciBpbmZvcm1hdGlvbiwgYW5kIHZhdWx0IHN0YXR1cy5cIilcbiAgICAgIC5vbihcIi0taGVscFwiLCAoKSA9PiB7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgIEV4YW1wbGUgcmV0dXJuIHZhbHVlOlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICB7XCIpO1xuICAgICAgICB3cml0ZUxuKCcgICAgICBcInNlcnZlclVybFwiOiBcImh0dHBzOi8vYml0d2FyZGVuLmV4YW1wbGUuY29tXCIsJyk7XG4gICAgICAgIHdyaXRlTG4oJyAgICAgIFwibGFzdFN5bmNcIjogXCIyMDIwLTA2LTE2VDA2OjMzOjUxLjQxOVpcIiwnKTtcbiAgICAgICAgd3JpdGVMbignICAgICAgXCJ1c2VyRW1haWxcIjogXCJ1c2VyQGV4YW1wbGUuY29tLCcpO1xuICAgICAgICB3cml0ZUxuKCcgICAgICBcInVzZXJJZFwiOiBcIjAwMDAwMDAwLTAwMDAtMDAwMC0wMDAwLTAwMDAwMDAwMDAwMFwiLCcpO1xuICAgICAgICB3cml0ZUxuKCcgICAgICBcInN0YXR1c1wiOiBcImxvY2tlZFwiJyk7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgfVwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgTm90ZXM6XCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICBgc3RhdHVzYCBpcyBvbmUgb2Y6XCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIC0gYHVuYXV0aGVudGljYXRlZGAgd2hlbiB5b3UgYXJlIG5vdCBsb2dnZWQgaW5cIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgLSBgbG9ja2VkYCB3aGVuIHlvdSBhcmUgbG9nZ2VkIGluIGFuZCB0aGUgdmF1bHQgaXMgbG9ja2VkXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIC0gYHVubG9ja2VkYCB3aGVuIHlvdSBhcmUgbG9nZ2VkIGluIGFuZCB0aGUgdmF1bHQgaXMgdW5sb2NrZWRcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIiwgdHJ1ZSk7XG4gICAgICB9KVxuICAgICAgLmFjdGlvbihhc3luYyAoKSA9PiB7XG4gICAgICAgIGNvbnN0IGNvbW1hbmQgPSBuZXcgU3RhdHVzQ29tbWFuZChcbiAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIuZW52aXJvbm1lbnRTZXJ2aWNlLFxuICAgICAgICAgIHRoaXMuc2VydmljZUNvbnRhaW5lci5zeW5jU2VydmljZSxcbiAgICAgICAgICB0aGlzLnNlcnZpY2VDb250YWluZXIuYWNjb3VudFNlcnZpY2UsXG4gICAgICAgICAgdGhpcy5zZXJ2aWNlQ29udGFpbmVyLmF1dGhTZXJ2aWNlLFxuICAgICAgICApO1xuICAgICAgICBjb25zdCByZXNwb25zZSA9IGF3YWl0IGNvbW1hbmQucnVuKCk7XG4gICAgICAgIHRoaXMucHJvY2Vzc1Jlc3BvbnNlKHJlc3BvbnNlKTtcbiAgICAgIH0pO1xuXG4gICAgcHJvZ3JhbVxuICAgICAgLmNvbW1hbmQoXCJzZXJ2ZVwiKVxuICAgICAgLmRlc2NyaXB0aW9uKFwiU3RhcnQgYSBSRVNUZnVsIEFQSSB3ZWJzZXJ2ZXIuXCIpXG4gICAgICAub3B0aW9uKFwiLS1ob3N0bmFtZSA8aG9zdG5hbWU+XCIsIFwiVGhlIGhvc3RuYW1lIHRvIGJpbmQgeW91ciBBUEkgd2Vic2VydmVyIHRvLlwiKVxuICAgICAgLm9wdGlvbihcIi0tcG9ydCA8cG9ydD5cIiwgXCJUaGUgcG9ydCB0byBydW4geW91ciBBUEkgd2Vic2VydmVyIG9uLlwiKVxuICAgICAgLm9wdGlvbihcbiAgICAgICAgXCItLWRpc2FibGUtb3JpZ2luLXByb3RlY3Rpb25cIixcbiAgICAgICAgXCJJZiBzZXQsIGFsbG93cyByZXF1ZXN0cyB3aXRoIG9yaWdpbiBoZWFkZXIuIFdhcm5pbmcsIHRoaXMgb3B0aW9uIGV4aXN0cyBmb3IgYmFja3dhcmRzIGNvbXBhdGliaWxpdHkgcmVhc29ucyBhbmQgZXhwb3NlcyB5b3VyIGVudmlyb25tZW50IHRvIGtub3duIENTUkYgYXR0YWNrcy5cIixcbiAgICAgIClcbiAgICAgIC5vbihcIi0taGVscFwiLCAoKSA9PiB7XG4gICAgICAgIHdyaXRlTG4oXCJcXG4gIE5vdGVzOlwiKTtcbiAgICAgICAgd3JpdGVMbihcIlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBEZWZhdWx0IGhvc3RuYW1lIGlzIGBsb2NhbGhvc3RgLlwiKTtcbiAgICAgICAgd3JpdGVMbihcIiAgICBVc2UgaG9zdG5hbWUgYGFsbGAgZm9yIG5vIGhvc3RuYW1lIGJpbmRpbmcuXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICAgIERlZmF1bHQgcG9ydCBpcyBgODA4N2AuXCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIpO1xuICAgICAgICB3cml0ZUxuKFwiICBFeGFtcGxlczpcIik7XG4gICAgICAgIHdyaXRlTG4oXCJcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgc2VydmVcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgc2VydmUgLS1wb3J0IDgwODBcIik7XG4gICAgICAgIHdyaXRlTG4oXCIgICAgYncgc2VydmUgLS1ob3N0bmFtZSBid2FwaS5teWRvbWFpbi5jb20gLS1wb3J0IDgwXCIpO1xuICAgICAgICB3cml0ZUxuKFwiXCIsIHRydWUpO1xuICAgICAgfSlcbiAgICAgIC5hY3Rpb24oYXN5bmMgKGNtZCkgPT4ge1xuICAgICAgICBhd2FpdCB0aGlzLmV4aXRJZk5vdEF1dGhlZCgpO1xuICAgICAgICBjb25zdCBjb21tYW5kID0gbmV3IFNlcnZlQ29tbWFuZCh0aGlzLnNlcnZpY2VDb250YWluZXIpO1xuICAgICAgICBhd2FpdCBjb21tYW5kLnJ1bihjbWQpO1xuICAgICAgfSk7XG4gIH1cbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./src/program.ts\n");

/***/ }),

/***/ "./src/register-oss-programs.ts":
/*!**************************************!*\
  !*** ./src/register-oss-programs.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   registerOssPrograms: () => (/* binding */ registerOssPrograms)\n/* harmony export */ });\n/* harmony import */ var _program__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./program */ \"./src/program.ts\");\n/* harmony import */ var _tools_send_send_program__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tools/send/send.program */ \"./src/tools/send/send.program.ts\");\n/* harmony import */ var _vault_program__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./vault.program */ \"./src/vault.program.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n/**\n * All OSS licensed programs should be registered here.\n * @example\n * const myProgram = new myProgram(serviceContainer);\n * myProgram.register();\n * @param serviceContainer A class that instantiates services and makes them available for dependency injection\n */\nfunction registerOssPrograms(serviceContainer) {\n    return __awaiter(this, void 0, void 0, function* () {\n        const program = new _program__WEBPACK_IMPORTED_MODULE_0__.Program(serviceContainer);\n        yield program.register();\n        const vaultProgram = new _vault_program__WEBPACK_IMPORTED_MODULE_2__.VaultProgram(serviceContainer);\n        vaultProgram.register();\n        const sendProgram = new _tools_send_send_program__WEBPACK_IMPORTED_MODULE_1__.SendProgram(serviceContainer);\n        sendProgram.register();\n    });\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvcmVnaXN0ZXItb3NzLXByb2dyYW1zLnRzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBb0M7QUFFb0I7QUFDVDtBQUUvQzs7Ozs7O0dBTUc7QUFDSSxTQUFlLG1CQUFtQixDQUFDLGdCQUFrQzs7UUFDMUUsTUFBTSxPQUFPLEdBQUcsSUFBSSw2Q0FBTyxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDOUMsTUFBTSxPQUFPLENBQUMsUUFBUSxFQUFFLENBQUM7UUFFekIsTUFBTSxZQUFZLEdBQUcsSUFBSSx3REFBWSxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDeEQsWUFBWSxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBRXhCLE1BQU0sV0FBVyxHQUFHLElBQUksaUVBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBQ3RELFdBQVcsQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUN6QixDQUFDO0NBQUEiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9AYml0d2FyZGVuL2NsaS8uL3NyYy9yZWdpc3Rlci1vc3MtcHJvZ3JhbXMudHM/MmE4MyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQcm9ncmFtIH0gZnJvbSBcIi4vcHJvZ3JhbVwiO1xuaW1wb3J0IHsgU2VydmljZUNvbnRhaW5lciB9IGZyb20gXCIuL3NlcnZpY2UtY29udGFpbmVyXCI7XG5pbXBvcnQgeyBTZW5kUHJvZ3JhbSB9IGZyb20gXCIuL3Rvb2xzL3NlbmQvc2VuZC5wcm9ncmFtXCI7XG5pbXBvcnQgeyBWYXVsdFByb2dyYW0gfSBmcm9tIFwiLi92YXVsdC5wcm9ncmFtXCI7XG5cbi8qKlxuICogQWxsIE9TUyBsaWNlbnNlZCBwcm9ncmFtcyBzaG91bGQgYmUgcmVnaXN0ZXJlZCBoZXJlLlxuICogQGV4YW1wbGVcbiAqIGNvbnN0IG15UHJvZ3JhbSA9IG5ldyBteVByb2dyYW0oc2VydmljZUNvbnRhaW5lcik7XG4gKiBteVByb2dyYW0ucmVnaXN0ZXIoKTtcbiAqIEBwYXJhbSBzZXJ2aWNlQ29udGFpbmVyIEEgY2xhc3MgdGhhdCBpbnN0YW50aWF0ZXMgc2VydmljZXMgYW5kIG1ha2VzIHRoZW0gYXZhaWxhYmxlIGZvciBkZXBlbmRlbmN5IGluamVjdGlvblxuICovXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gcmVnaXN0ZXJPc3NQcm9ncmFtcyhzZXJ2aWNlQ29udGFpbmVyOiBTZXJ2aWNlQ29udGFpbmVyKSB7XG4gIGNvbnN0IHByb2dyYW0gPSBuZXcgUHJvZ3JhbShzZXJ2aWNlQ29udGFpbmVyKTtcbiAgYXdhaXQgcHJvZ3JhbS5yZWdpc3RlcigpO1xuXG4gIGNvbnN0IHZhdWx0UHJvZ3JhbSA9IG5ldyBWYXVsdFByb2dyYW0oc2VydmljZUNvbnRhaW5lcik7XG4gIHZhdWx0UHJvZ3JhbS5yZWdpc3RlcigpO1xuXG4gIGNvbnN0IHNlbmRQcm9ncmFtID0gbmV3IFNlbmRQcm9ncmFtKHNlcnZpY2VDb250YWluZXIpO1xuICBzZW5kUHJvZ3JhbS5yZWdpc3RlcigpO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/register-oss-programs.ts\n");

/***/ }),

/***/ "./src/service-container.ts":
/*!**********************************!*\
  !*** ./src/service-container.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ServiceContainer: () => (/* binding */ ServiceContainer)\n/* harmony export */ });\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fs */ \"fs\");\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! path */ \"path\");\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var jsdom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! jsdom */ \"jsdom\");\n/* harmony import */ var jsdom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(jsdom__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @bitwarden/auth/common */ \"../../libs/auth/src/common/index.ts\");\n/* harmony import */ var _bitwarden_common_admin_console_services_organization_organization_api_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @bitwarden/common/admin-console/services/organization/organization-api.service */ \"../../libs/common/src/admin-console/services/organization/organization-api.service.ts\");\n/* harmony import */ var _bitwarden_common_admin_console_services_organization_organization_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @bitwarden/common/admin-console/services/organization/organization.service */ \"../../libs/common/src/admin-console/services/organization/organization.service.ts\");\n/* harmony import */ var _bitwarden_common_admin_console_services_organization_user_organization_user_service_implementation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @bitwarden/common/admin-console/services/organization-user/organization-user.service.implementation */ \"../../libs/common/src/admin-console/services/organization-user/organization-user.service.implementation.ts\");\n/* harmony import */ var _bitwarden_common_admin_console_services_policy_policy_api_service__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @bitwarden/common/admin-console/services/policy/policy-api.service */ \"../../libs/common/src/admin-console/services/policy/policy-api.service.ts\");\n/* harmony import */ var _bitwarden_common_admin_console_services_policy_policy_service__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @bitwarden/common/admin-console/services/policy/policy.service */ \"../../libs/common/src/admin-console/services/policy/policy.service.ts\");\n/* harmony import */ var _bitwarden_common_admin_console_services_provider_provider_api_service__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @bitwarden/common/admin-console/services/provider/provider-api.service */ \"../../libs/common/src/admin-console/services/provider/provider-api.service.ts\");\n/* harmony import */ var _bitwarden_common_admin_console_services_provider_service__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @bitwarden/common/admin-console/services/provider.service */ \"../../libs/common/src/admin-console/services/provider.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_account_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @bitwarden/common/auth/services/account.service */ \"../../libs/common/src/auth/services/account.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_auth_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @bitwarden/common/auth/services/auth.service */ \"../../libs/common/src/auth/services/auth.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_avatar_service__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @bitwarden/common/auth/services/avatar.service */ \"../../libs/common/src/auth/services/avatar.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_device_trust_service_implementation__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @bitwarden/common/auth/services/device-trust.service.implementation */ \"../../libs/common/src/auth/services/device-trust.service.implementation.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_devices_api_service_implementation__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @bitwarden/common/auth/services/devices-api.service.implementation */ \"../../libs/common/src/auth/services/devices-api.service.implementation.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_kdf_config_service__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @bitwarden/common/auth/services/kdf-config.service */ \"../../libs/common/src/auth/services/kdf-config.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_key_connector_service__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @bitwarden/common/auth/services/key-connector.service */ \"../../libs/common/src/auth/services/key-connector.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_master_password_master_password_service__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @bitwarden/common/auth/services/master-password/master-password.service */ \"../../libs/common/src/auth/services/master-password/master-password.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_token_service__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @bitwarden/common/auth/services/token.service */ \"../../libs/common/src/auth/services/token.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_two_factor_service__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @bitwarden/common/auth/services/two-factor.service */ \"../../libs/common/src/auth/services/two-factor.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_user_verification_user_verification_api_service__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @bitwarden/common/auth/services/user-verification/user-verification-api.service */ \"../../libs/common/src/auth/services/user-verification/user-verification-api.service.ts\");\n/* harmony import */ var _bitwarden_common_auth_services_user_verification_user_verification_service__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @bitwarden/common/auth/services/user-verification/user-verification.service */ \"../../libs/common/src/auth/services/user-verification/user-verification.service.ts\");\n/* harmony import */ var _bitwarden_common_autofill_services_domain_settings_service__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @bitwarden/common/autofill/services/domain-settings.service */ \"../../libs/common/src/autofill/services/domain-settings.service.ts\");\n/* harmony import */ var _bitwarden_common_billing_services_account_billing_account_profile_state_service__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @bitwarden/common/billing/services/account/billing-account-profile-state.service */ \"../../libs/common/src/billing/services/account/billing-account-profile-state.service.ts\");\n/* harmony import */ var _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @bitwarden/common/enums */ \"../../libs/common/src/enums/index.ts\");\n/* harmony import */ var _bitwarden_common_platform_biometrics_biometric_state_service__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! @bitwarden/common/platform/biometrics/biometric-state.service */ \"../../libs/common/src/platform/biometrics/biometric-state.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_enums__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! @bitwarden/common/platform/enums */ \"../../libs/common/src/platform/enums/index.ts\");\n/* harmony import */ var _bitwarden_common_platform_factories_state_factory__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @bitwarden/common/platform/factories/state-factory */ \"../../libs/common/src/platform/factories/state-factory.ts\");\n/* harmony import */ var _bitwarden_common_platform_messaging__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! @bitwarden/common/platform/messaging */ \"../../libs/common/src/platform/messaging/index.ts\");\n/* harmony import */ var _bitwarden_common_platform_models_domain_account__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! @bitwarden/common/platform/models/domain/account */ \"../../libs/common/src/platform/models/domain/account.ts\");\n/* harmony import */ var _bitwarden_common_platform_models_domain_global_state__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! @bitwarden/common/platform/models/domain/global-state */ \"../../libs/common/src/platform/models/domain/global-state.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_app_id_service__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! @bitwarden/common/platform/services/app-id.service */ \"../../libs/common/src/platform/services/app-id.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_config_config_api_service__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! @bitwarden/common/platform/services/config/config-api.service */ \"../../libs/common/src/platform/services/config/config-api.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_config_default_config_service__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! @bitwarden/common/platform/services/config/default-config.service */ \"../../libs/common/src/platform/services/config/default-config.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_container_service__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! @bitwarden/common/platform/services/container.service */ \"../../libs/common/src/platform/services/container.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_crypto_service__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! @bitwarden/common/platform/services/crypto.service */ \"../../libs/common/src/platform/services/crypto.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_cryptography_encrypt_service_implementation__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! @bitwarden/common/platform/services/cryptography/encrypt.service.implementation */ \"../../libs/common/src/platform/services/cryptography/encrypt.service.implementation.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_default_environment_service__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! @bitwarden/common/platform/services/default-environment.service */ \"../../libs/common/src/platform/services/default-environment.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_file_upload_file_upload_service__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! @bitwarden/common/platform/services/file-upload/file-upload.service */ \"../../libs/common/src/platform/services/file-upload/file-upload.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_key_generation_service__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! @bitwarden/common/platform/services/key-generation.service */ \"../../libs/common/src/platform/services/key-generation.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_memory_storage_service__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! @bitwarden/common/platform/services/memory-storage.service */ \"../../libs/common/src/platform/services/memory-storage.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_migration_builder_service__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! @bitwarden/common/platform/services/migration-builder.service */ \"../../libs/common/src/platform/services/migration-builder.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_migration_runner__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! @bitwarden/common/platform/services/migration-runner */ \"../../libs/common/src/platform/services/migration-runner.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_state_service__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! @bitwarden/common/platform/services/state.service */ \"../../libs/common/src/platform/services/state.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_storage_service_provider__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! @bitwarden/common/platform/services/storage-service.provider */ \"../../libs/common/src/platform/services/storage-service.provider.ts\");\n/* harmony import */ var _bitwarden_common_platform_services_user_auto_unlock_key_service__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! @bitwarden/common/platform/services/user-auto-unlock-key.service */ \"../../libs/common/src/platform/services/user-auto-unlock-key.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_state__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! @bitwarden/common/platform/state */ \"../../libs/common/src/platform/state/index.ts\");\n/* harmony import */ var _bitwarden_common_platform_state_implementations_default_active_user_state_provider__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! @bitwarden/common/platform/state/implementations/default-active-user-state.provider */ \"../../libs/common/src/platform/state/implementations/default-active-user-state.provider.ts\");\n/* harmony import */ var _bitwarden_common_platform_state_implementations_default_derived_state_provider__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! @bitwarden/common/platform/state/implementations/default-derived-state.provider */ \"../../libs/common/src/platform/state/implementations/default-derived-state.provider.ts\");\n/* harmony import */ var _bitwarden_common_platform_state_implementations_default_global_state_provider__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! @bitwarden/common/platform/state/implementations/default-global-state.provider */ \"../../libs/common/src/platform/state/implementations/default-global-state.provider.ts\");\n/* harmony import */ var _bitwarden_common_platform_state_implementations_default_single_user_state_provider__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! @bitwarden/common/platform/state/implementations/default-single-user-state.provider */ \"../../libs/common/src/platform/state/implementations/default-single-user-state.provider.ts\");\n/* harmony import */ var _bitwarden_common_platform_state_implementations_default_state_provider__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! @bitwarden/common/platform/state/implementations/default-state.provider */ \"../../libs/common/src/platform/state/implementations/default-state.provider.ts\");\n/* harmony import */ var _bitwarden_common_platform_state_state_event_registrar_service__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! @bitwarden/common/platform/state/state-event-registrar.service */ \"../../libs/common/src/platform/state/state-event-registrar.service.ts\");\n/* harmony import */ var _bitwarden_common_platform_state_storage_memory_storage_service__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! @bitwarden/common/platform/state/storage/memory-storage.service */ \"../../libs/common/src/platform/state/storage/memory-storage.service.ts\");\n/* harmony import */ var _bitwarden_common_services_audit_service__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! @bitwarden/common/services/audit.service */ \"../../libs/common/src/services/audit.service.ts\");\n/* harmony import */ var _bitwarden_common_services_event_event_collection_service__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! @bitwarden/common/services/event/event-collection.service */ \"../../libs/common/src/services/event/event-collection.service.ts\");\n/* harmony import */ var _bitwarden_common_services_event_event_upload_service__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! @bitwarden/common/services/event/event-upload.service */ \"../../libs/common/src/services/event/event-upload.service.ts\");\n/* harmony import */ var _bitwarden_common_services_search_service__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! @bitwarden/common/services/search.service */ \"../../libs/common/src/services/search.service.ts\");\n/* harmony import */ var _bitwarden_common_services_vault_timeout_vault_timeout_settings_service__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! @bitwarden/common/services/vault-timeout/vault-timeout-settings.service */ \"../../libs/common/src/services/vault-timeout/vault-timeout-settings.service.ts\");\n/* harmony import */ var _bitwarden_common_services_vault_timeout_vault_timeout_service__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! @bitwarden/common/services/vault-timeout/vault-timeout.service */ \"../../libs/common/src/services/vault-timeout/vault-timeout.service.ts\");\n/* harmony import */ var _bitwarden_common_tools_generator__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! @bitwarden/common/tools/generator */ \"../../libs/common/src/tools/generator/index.ts\");\n/* harmony import */ var _bitwarden_common_tools_password_strength__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! @bitwarden/common/tools/password-strength */ \"../../libs/common/src/tools/password-strength/index.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_services_send_api_service__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! @bitwarden/common/tools/send/services/send-api.service */ \"../../libs/common/src/tools/send/services/send-api.service.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_services_send_state_provider__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! @bitwarden/common/tools/send/services/send-state.provider */ \"../../libs/common/src/tools/send/services/send-state.provider.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_services_send_service__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! @bitwarden/common/tools/send/services/send.service */ \"../../libs/common/src/tools/send/services/send.service.ts\");\n/* harmony import */ var _bitwarden_common_types_vault_timeout_type__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! @bitwarden/common/types/vault-timeout.type */ \"../../libs/common/src/types/vault-timeout.type.ts\");\n/* harmony import */ var _bitwarden_common_vault_services_cipher_service__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! @bitwarden/common/vault/services/cipher.service */ \"../../libs/common/src/vault/services/cipher.service.ts\");\n/* harmony import */ var _bitwarden_common_vault_services_collection_service__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! @bitwarden/common/vault/services/collection.service */ \"../../libs/common/src/vault/services/collection.service.ts\");\n/* harmony import */ var _bitwarden_common_vault_services_file_upload_cipher_file_upload_service__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! @bitwarden/common/vault/services/file-upload/cipher-file-upload.service */ \"../../libs/common/src/vault/services/file-upload/cipher-file-upload.service.ts\");\n/* harmony import */ var _bitwarden_common_vault_services_folder_folder_api_service__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! @bitwarden/common/vault/services/folder/folder-api.service */ \"../../libs/common/src/vault/services/folder/folder-api.service.ts\");\n/* harmony import */ var _bitwarden_common_vault_services_folder_folder_service__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! @bitwarden/common/vault/services/folder/folder.service */ \"../../libs/common/src/vault/services/folder/folder.service.ts\");\n/* harmony import */ var _bitwarden_common_vault_services_sync_sync_notifier_service__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! @bitwarden/common/vault/services/sync/sync-notifier.service */ \"../../libs/common/src/vault/services/sync/sync-notifier.service.ts\");\n/* harmony import */ var _bitwarden_common_vault_services_sync_sync_service__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(/*! @bitwarden/common/vault/services/sync/sync.service */ \"../../libs/common/src/vault/services/sync/sync.service.ts\");\n/* harmony import */ var _bitwarden_common_vault_services_totp_service__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(/*! @bitwarden/common/vault/services/totp.service */ \"../../libs/common/src/vault/services/totp.service.ts\");\n/* harmony import */ var _bitwarden_importer_core__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(/*! @bitwarden/importer/core */ \"../../libs/importer/src/index.ts\");\n/* harmony import */ var _bitwarden_node_services_node_crypto_function_service__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(/*! @bitwarden/node/services/node-crypto-function.service */ \"../../libs/node/src/services/node-crypto-function.service.ts\");\n/* harmony import */ var _bitwarden_vault_export_core__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(/*! @bitwarden/vault-export-core */ \"../../libs/tools/export/vault-export/vault-export-core/src/index.ts\");\n/* harmony import */ var _platform_services_cli_platform_utils_service__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(/*! ./platform/services/cli-platform-utils.service */ \"./src/platform/services/cli-platform-utils.service.ts\");\n/* harmony import */ var _platform_services_console_log_service__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(/*! ./platform/services/console-log.service */ \"./src/platform/services/console-log.service.ts\");\n/* harmony import */ var _platform_services_i18n_service__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(/*! ./platform/services/i18n.service */ \"./src/platform/services/i18n.service.ts\");\n/* harmony import */ var _platform_services_lowdb_storage_service__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(/*! ./platform/services/lowdb-storage.service */ \"./src/platform/services/lowdb-storage.service.ts\");\n/* harmony import */ var _platform_services_node_api_service__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(/*! ./platform/services/node-api.service */ \"./src/platform/services/node-api.service.ts\");\n/* harmony import */ var _platform_services_node_env_secure_storage_service__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(/*! ./platform/services/node-env-secure-storage.service */ \"./src/platform/services/node-env-secure-storage.service.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/* eslint-disable import/no-restricted-paths -- We need the implementation to inject, but generally these should not be accessed */\n\n\n\n\n\n\n\n/* eslint-enable import/no-restricted-paths */\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n// Polyfills\nglobal.DOMParser = new jsdom__WEBPACK_IMPORTED_MODULE_2__.JSDOM().window.DOMParser;\n// eslint-disable-next-line\nconst packageJson = __webpack_require__(/*! ../package.json */ \"./package.json\");\n/**\n * Instantiates services and makes them available for dependency injection.\n * Any Bitwarden-licensed services should be registered here.\n */\nclass ServiceContainer {\n    constructor() {\n        this.inited = false;\n        let p = null;\n        const relativeDataDir = path__WEBPACK_IMPORTED_MODULE_1__.join(path__WEBPACK_IMPORTED_MODULE_1__.dirname(process.execPath), \"bw-data\");\n        if (fs__WEBPACK_IMPORTED_MODULE_0__.existsSync(relativeDataDir)) {\n            p = relativeDataDir;\n        }\n        else if (process.env.BITWARDENCLI_APPDATA_DIR) {\n            p = path__WEBPACK_IMPORTED_MODULE_1__.resolve(process.env.BITWARDENCLI_APPDATA_DIR);\n        }\n        else if (process.platform === \"darwin\") {\n            p = path__WEBPACK_IMPORTED_MODULE_1__.join(process.env.HOME, \"Library/Application Support/Bitwarden CLI\");\n        }\n        else if (process.platform === \"win32\") {\n            p = path__WEBPACK_IMPORTED_MODULE_1__.join(process.env.APPDATA, \"Bitwarden CLI\");\n        }\n        else if (process.env.XDG_CONFIG_HOME) {\n            p = path__WEBPACK_IMPORTED_MODULE_1__.join(process.env.XDG_CONFIG_HOME, \"Bitwarden CLI\");\n        }\n        else {\n            p = path__WEBPACK_IMPORTED_MODULE_1__.join(process.env.HOME, \".config/Bitwarden CLI\");\n        }\n        const logoutCallback = () => __awaiter(this, void 0, void 0, function* () { return yield this.logout(); });\n        this.platformUtilsService = new _platform_services_cli_platform_utils_service__WEBPACK_IMPORTED_MODULE_79__.CliPlatformUtilsService(_bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_26__.ClientType.Cli, packageJson);\n        this.logService = new _platform_services_console_log_service__WEBPACK_IMPORTED_MODULE_80__.ConsoleLogService(this.platformUtilsService.isDev(), (level) => process.env.BITWARDENCLI_DEBUG !== \"true\" && level <= _bitwarden_common_platform_enums__WEBPACK_IMPORTED_MODULE_28__.LogLevelType.Info);\n        this.cryptoFunctionService = new _bitwarden_node_services_node_crypto_function_service__WEBPACK_IMPORTED_MODULE_77__.NodeCryptoFunctionService();\n        this.encryptService = new _bitwarden_common_platform_services_cryptography_encrypt_service_implementation__WEBPACK_IMPORTED_MODULE_38__.EncryptServiceImplementation(this.cryptoFunctionService, this.logService, true);\n        this.storageService = new _platform_services_lowdb_storage_service__WEBPACK_IMPORTED_MODULE_82__.LowdbStorageService(this.logService, null, p, false, true);\n        this.secureStorageService = new _platform_services_node_env_secure_storage_service__WEBPACK_IMPORTED_MODULE_84__.NodeEnvSecureStorageService(this.storageService, this.logService, this.encryptService);\n        this.memoryStorageService = new _bitwarden_common_platform_services_memory_storage_service__WEBPACK_IMPORTED_MODULE_42__.MemoryStorageService();\n        this.memoryStorageForStateProviders = new _bitwarden_common_platform_state_storage_memory_storage_service__WEBPACK_IMPORTED_MODULE_55__.MemoryStorageService();\n        const storageServiceProvider = new _bitwarden_common_platform_services_storage_service_provider__WEBPACK_IMPORTED_MODULE_46__.StorageServiceProvider(this.storageService, this.memoryStorageForStateProviders);\n        this.globalStateProvider = new _bitwarden_common_platform_state_implementations_default_global_state_provider__WEBPACK_IMPORTED_MODULE_51__.DefaultGlobalStateProvider(storageServiceProvider);\n        const stateEventRegistrarService = new _bitwarden_common_platform_state_state_event_registrar_service__WEBPACK_IMPORTED_MODULE_54__.StateEventRegistrarService(this.globalStateProvider, storageServiceProvider);\n        this.stateEventRunnerService = new _bitwarden_common_platform_state__WEBPACK_IMPORTED_MODULE_48__.StateEventRunnerService(this.globalStateProvider, storageServiceProvider);\n        this.i18nService = new _platform_services_i18n_service__WEBPACK_IMPORTED_MODULE_81__.I18nService(\"en\", \"./locales\", this.globalStateProvider);\n        this.singleUserStateProvider = new _bitwarden_common_platform_state_implementations_default_single_user_state_provider__WEBPACK_IMPORTED_MODULE_52__.DefaultSingleUserStateProvider(storageServiceProvider, stateEventRegistrarService);\n        this.messagingService = _bitwarden_common_platform_messaging__WEBPACK_IMPORTED_MODULE_30__.MessageSender.EMPTY;\n        this.accountService = new _bitwarden_common_auth_services_account_service__WEBPACK_IMPORTED_MODULE_12__.AccountServiceImplementation(this.messagingService, this.logService, this.globalStateProvider);\n        this.activeUserStateProvider = new _bitwarden_common_platform_state_implementations_default_active_user_state_provider__WEBPACK_IMPORTED_MODULE_49__.DefaultActiveUserStateProvider(this.accountService, this.singleUserStateProvider);\n        this.derivedStateProvider = new _bitwarden_common_platform_state_implementations_default_derived_state_provider__WEBPACK_IMPORTED_MODULE_50__.DefaultDerivedStateProvider();\n        this.stateProvider = new _bitwarden_common_platform_state_implementations_default_state_provider__WEBPACK_IMPORTED_MODULE_53__.DefaultStateProvider(this.activeUserStateProvider, this.singleUserStateProvider, this.globalStateProvider, this.derivedStateProvider);\n        this.environmentService = new _bitwarden_common_platform_services_default_environment_service__WEBPACK_IMPORTED_MODULE_39__.DefaultEnvironmentService(this.stateProvider, this.accountService);\n        this.keyGenerationService = new _bitwarden_common_platform_services_key_generation_service__WEBPACK_IMPORTED_MODULE_41__.KeyGenerationService(this.cryptoFunctionService);\n        this.tokenService = new _bitwarden_common_auth_services_token_service__WEBPACK_IMPORTED_MODULE_20__.TokenService(this.singleUserStateProvider, this.globalStateProvider, this.platformUtilsService.supportsSecureStorage(), this.secureStorageService, this.keyGenerationService, this.encryptService, this.logService, logoutCallback);\n        const migrationRunner = new _bitwarden_common_platform_services_migration_runner__WEBPACK_IMPORTED_MODULE_44__.MigrationRunner(this.storageService, this.logService, new _bitwarden_common_platform_services_migration_builder_service__WEBPACK_IMPORTED_MODULE_43__.MigrationBuilderService(), _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_26__.ClientType.Cli);\n        this.stateService = new _bitwarden_common_platform_services_state_service__WEBPACK_IMPORTED_MODULE_45__.StateService(this.storageService, this.secureStorageService, this.memoryStorageService, this.logService, new _bitwarden_common_platform_factories_state_factory__WEBPACK_IMPORTED_MODULE_29__.StateFactory(_bitwarden_common_platform_models_domain_global_state__WEBPACK_IMPORTED_MODULE_32__.GlobalState, _bitwarden_common_platform_models_domain_account__WEBPACK_IMPORTED_MODULE_31__.Account), this.accountService, this.environmentService, this.tokenService, migrationRunner);\n        this.masterPasswordService = new _bitwarden_common_auth_services_master_password_master_password_service__WEBPACK_IMPORTED_MODULE_19__.MasterPasswordService(this.stateProvider, this.stateService, this.keyGenerationService, this.encryptService);\n        this.kdfConfigService = new _bitwarden_common_auth_services_kdf_config_service__WEBPACK_IMPORTED_MODULE_17__.KdfConfigService(this.stateProvider);\n        this.pinService = new _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_4__.PinService(this.accountService, this.cryptoFunctionService, this.encryptService, this.kdfConfigService, this.keyGenerationService, this.logService, this.masterPasswordService, this.stateProvider, this.stateService);\n        this.cryptoService = new _bitwarden_common_platform_services_crypto_service__WEBPACK_IMPORTED_MODULE_37__.CryptoService(this.pinService, this.masterPasswordService, this.keyGenerationService, this.cryptoFunctionService, this.encryptService, this.platformUtilsService, this.logService, this.stateService, this.accountService, this.stateProvider, this.kdfConfigService);\n        this.appIdService = new _bitwarden_common_platform_services_app_id_service__WEBPACK_IMPORTED_MODULE_33__.AppIdService(this.globalStateProvider);\n        const customUserAgent = \"Bitwarden_CLI/\" +\n            this.platformUtilsService.getApplicationVersionSync() +\n            \" (\" +\n            this.platformUtilsService.getDeviceString().toUpperCase() +\n            \")\";\n        this.biometricStateService = new _bitwarden_common_platform_biometrics_biometric_state_service__WEBPACK_IMPORTED_MODULE_27__.DefaultBiometricStateService(this.stateProvider);\n        this.userDecryptionOptionsService = new _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_4__.UserDecryptionOptionsService(this.stateProvider);\n        this.organizationService = new _bitwarden_common_admin_console_services_organization_organization_service__WEBPACK_IMPORTED_MODULE_6__.OrganizationService(this.stateProvider);\n        this.policyService = new _bitwarden_common_admin_console_services_policy_policy_service__WEBPACK_IMPORTED_MODULE_9__.PolicyService(this.stateProvider, this.organizationService);\n        this.vaultTimeoutSettingsService = new _bitwarden_common_services_vault_timeout_vault_timeout_settings_service__WEBPACK_IMPORTED_MODULE_60__.VaultTimeoutSettingsService(this.accountService, this.pinService, this.userDecryptionOptionsService, this.cryptoService, this.tokenService, this.policyService, this.biometricStateService, this.stateProvider, this.logService, _bitwarden_common_types_vault_timeout_type__WEBPACK_IMPORTED_MODULE_67__.VaultTimeoutStringType.Never);\n        const refreshAccessTokenErrorCallback = () => {\n            throw new Error(\"Refresh Access token error\");\n        };\n        this.apiService = new _platform_services_node_api_service__WEBPACK_IMPORTED_MODULE_83__.NodeApiService(this.tokenService, this.platformUtilsService, this.environmentService, this.appIdService, refreshAccessTokenErrorCallback, this.logService, logoutCallback, this.vaultTimeoutSettingsService, customUserAgent);\n        this.syncNotifierService = new _bitwarden_common_vault_services_sync_sync_notifier_service__WEBPACK_IMPORTED_MODULE_73__.SyncNotifierService();\n        this.organizationApiService = new _bitwarden_common_admin_console_services_organization_organization_api_service__WEBPACK_IMPORTED_MODULE_5__.OrganizationApiService(this.apiService, this.syncService);\n        this.containerService = new _bitwarden_common_platform_services_container_service__WEBPACK_IMPORTED_MODULE_36__.ContainerService(this.cryptoService, this.encryptService);\n        this.domainSettingsService = new _bitwarden_common_autofill_services_domain_settings_service__WEBPACK_IMPORTED_MODULE_24__.DefaultDomainSettingsService(this.stateProvider);\n        this.fileUploadService = new _bitwarden_common_platform_services_file_upload_file_upload_service__WEBPACK_IMPORTED_MODULE_40__.FileUploadService(this.logService);\n        this.sendStateProvider = new _bitwarden_common_tools_send_services_send_state_provider__WEBPACK_IMPORTED_MODULE_65__.SendStateProvider(this.stateProvider);\n        this.sendService = new _bitwarden_common_tools_send_services_send_service__WEBPACK_IMPORTED_MODULE_66__.SendService(this.cryptoService, this.i18nService, this.keyGenerationService, this.sendStateProvider, this.encryptService);\n        this.cipherFileUploadService = new _bitwarden_common_vault_services_file_upload_cipher_file_upload_service__WEBPACK_IMPORTED_MODULE_70__.CipherFileUploadService(this.apiService, this.fileUploadService);\n        this.sendApiService = this.sendApiService = new _bitwarden_common_tools_send_services_send_api_service__WEBPACK_IMPORTED_MODULE_64__.SendApiService(this.apiService, this.fileUploadService, this.sendService);\n        this.searchService = new _bitwarden_common_services_search_service__WEBPACK_IMPORTED_MODULE_59__.SearchService(this.logService, this.i18nService, this.stateProvider);\n        this.collectionService = new _bitwarden_common_vault_services_collection_service__WEBPACK_IMPORTED_MODULE_69__.CollectionService(this.cryptoService, this.i18nService, this.stateProvider);\n        this.providerService = new _bitwarden_common_admin_console_services_provider_service__WEBPACK_IMPORTED_MODULE_11__.ProviderService(this.stateProvider);\n        this.organizationUserService = new _bitwarden_common_admin_console_services_organization_user_organization_user_service_implementation__WEBPACK_IMPORTED_MODULE_7__.OrganizationUserServiceImplementation(this.apiService);\n        this.policyApiService = new _bitwarden_common_admin_console_services_policy_policy_api_service__WEBPACK_IMPORTED_MODULE_8__.PolicyApiService(this.policyService, this.apiService);\n        this.keyConnectorService = new _bitwarden_common_auth_services_key_connector_service__WEBPACK_IMPORTED_MODULE_18__.KeyConnectorService(this.accountService, this.masterPasswordService, this.cryptoService, this.apiService, this.tokenService, this.logService, this.organizationService, this.keyGenerationService, logoutCallback, this.stateProvider);\n        this.twoFactorService = new _bitwarden_common_auth_services_two_factor_service__WEBPACK_IMPORTED_MODULE_21__.TwoFactorService(this.i18nService, this.platformUtilsService, this.globalStateProvider);\n        this.passwordStrengthService = new _bitwarden_common_tools_password_strength__WEBPACK_IMPORTED_MODULE_63__.PasswordStrengthService();\n        this.passwordGenerationService = (0,_bitwarden_common_tools_generator__WEBPACK_IMPORTED_MODULE_62__.legacyPasswordGenerationServiceFactory)(this.encryptService, this.cryptoService, this.policyService, this.accountService, this.stateProvider);\n        this.devicesApiService = new _bitwarden_common_auth_services_devices_api_service_implementation__WEBPACK_IMPORTED_MODULE_16__.DevicesApiServiceImplementation(this.apiService);\n        this.deviceTrustService = new _bitwarden_common_auth_services_device_trust_service_implementation__WEBPACK_IMPORTED_MODULE_15__.DeviceTrustService(this.keyGenerationService, this.cryptoFunctionService, this.cryptoService, this.encryptService, this.appIdService, this.devicesApiService, this.i18nService, this.platformUtilsService, this.stateProvider, this.secureStorageService, this.userDecryptionOptionsService, this.logService);\n        this.authRequestService = new _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_4__.AuthRequestService(this.appIdService, this.accountService, this.masterPasswordService, this.cryptoService, this.apiService, this.stateProvider);\n        this.billingAccountProfileStateService = new _bitwarden_common_billing_services_account_billing_account_profile_state_service__WEBPACK_IMPORTED_MODULE_25__.DefaultBillingAccountProfileStateService(this.stateProvider);\n        this.loginStrategyService = new _bitwarden_auth_common__WEBPACK_IMPORTED_MODULE_4__.LoginStrategyService(this.accountService, this.masterPasswordService, this.cryptoService, this.apiService, this.tokenService, this.appIdService, this.platformUtilsService, this.messagingService, this.logService, this.keyConnectorService, this.environmentService, this.stateService, this.twoFactorService, this.i18nService, this.encryptService, this.passwordStrengthService, this.policyService, this.deviceTrustService, this.authRequestService, this.userDecryptionOptionsService, this.globalStateProvider, this.billingAccountProfileStateService, this.vaultTimeoutSettingsService, this.kdfConfigService);\n        this.authService = new _bitwarden_common_auth_services_auth_service__WEBPACK_IMPORTED_MODULE_13__.AuthService(this.accountService, this.messagingService, this.cryptoService, this.apiService, this.stateService, this.tokenService);\n        this.configApiService = new _bitwarden_common_platform_services_config_config_api_service__WEBPACK_IMPORTED_MODULE_34__.ConfigApiService(this.apiService, this.tokenService);\n        this.configService = new _bitwarden_common_platform_services_config_default_config_service__WEBPACK_IMPORTED_MODULE_35__.DefaultConfigService(this.configApiService, this.environmentService, this.logService, this.stateProvider);\n        this.cipherService = new _bitwarden_common_vault_services_cipher_service__WEBPACK_IMPORTED_MODULE_68__.CipherService(this.cryptoService, this.domainSettingsService, this.apiService, this.i18nService, this.searchService, this.stateService, this.autofillSettingsService, this.encryptService, this.cipherFileUploadService, this.configService, this.stateProvider);\n        this.folderService = new _bitwarden_common_vault_services_folder_folder_service__WEBPACK_IMPORTED_MODULE_72__.FolderService(this.cryptoService, this.i18nService, this.cipherService, this.stateProvider);\n        this.folderApiService = new _bitwarden_common_vault_services_folder_folder_api_service__WEBPACK_IMPORTED_MODULE_71__.FolderApiService(this.folderService, this.apiService);\n        const lockedCallback = (userId) => __awaiter(this, void 0, void 0, function* () { return yield this.cryptoService.clearStoredUserKey(_bitwarden_common_platform_enums__WEBPACK_IMPORTED_MODULE_28__.KeySuffixOptions.Auto); });\n        this.userVerificationService = new _bitwarden_common_auth_services_user_verification_user_verification_service__WEBPACK_IMPORTED_MODULE_23__.UserVerificationService(this.stateService, this.cryptoService, this.accountService, this.masterPasswordService, this.i18nService, this.userVerificationApiService, this.userDecryptionOptionsService, this.pinService, this.logService, this.vaultTimeoutSettingsService, this.platformUtilsService, this.kdfConfigService);\n        this.vaultTimeoutService = new _bitwarden_common_services_vault_timeout_vault_timeout_service__WEBPACK_IMPORTED_MODULE_61__.VaultTimeoutService(this.accountService, this.masterPasswordService, this.cipherService, this.folderService, this.collectionService, this.platformUtilsService, this.messagingService, this.searchService, this.stateService, this.authService, this.vaultTimeoutSettingsService, this.stateEventRunnerService, lockedCallback, null);\n        this.avatarService = new _bitwarden_common_auth_services_avatar_service__WEBPACK_IMPORTED_MODULE_14__.AvatarService(this.apiService, this.stateProvider);\n        this.syncService = new _bitwarden_common_vault_services_sync_sync_service__WEBPACK_IMPORTED_MODULE_74__.SyncService(this.masterPasswordService, this.accountService, this.apiService, this.domainSettingsService, this.folderService, this.cipherService, this.cryptoService, this.collectionService, this.messagingService, this.policyService, this.sendService, this.logService, this.keyConnectorService, this.stateService, this.providerService, this.folderApiService, this.organizationService, this.sendApiService, this.userDecryptionOptionsService, this.avatarService, logoutCallback, this.billingAccountProfileStateService, this.tokenService, this.authService);\n        this.totpService = new _bitwarden_common_vault_services_totp_service__WEBPACK_IMPORTED_MODULE_75__.TotpService(this.cryptoFunctionService, this.logService);\n        this.importApiService = new _bitwarden_importer_core__WEBPACK_IMPORTED_MODULE_76__.ImportApiService(this.apiService);\n        this.importService = new _bitwarden_importer_core__WEBPACK_IMPORTED_MODULE_76__.ImportService(this.cipherService, this.folderService, this.importApiService, this.i18nService, this.collectionService, this.cryptoService, this.pinService);\n        this.individualExportService = new _bitwarden_vault_export_core__WEBPACK_IMPORTED_MODULE_78__.IndividualVaultExportService(this.folderService, this.cipherService, this.pinService, this.cryptoService, this.cryptoFunctionService, this.kdfConfigService);\n        this.organizationExportService = new _bitwarden_vault_export_core__WEBPACK_IMPORTED_MODULE_78__.OrganizationVaultExportService(this.cipherService, this.apiService, this.pinService, this.cryptoService, this.cryptoFunctionService, this.collectionService, this.kdfConfigService);\n        this.exportService = new _bitwarden_vault_export_core__WEBPACK_IMPORTED_MODULE_78__.VaultExportService(this.individualExportService, this.organizationExportService);\n        this.userAutoUnlockKeyService = new _bitwarden_common_platform_services_user_auto_unlock_key_service__WEBPACK_IMPORTED_MODULE_47__.UserAutoUnlockKeyService(this.cryptoService);\n        this.auditService = new _bitwarden_common_services_audit_service__WEBPACK_IMPORTED_MODULE_56__.AuditService(this.cryptoFunctionService, this.apiService);\n        this.userVerificationApiService = new _bitwarden_common_auth_services_user_verification_user_verification_api_service__WEBPACK_IMPORTED_MODULE_22__.UserVerificationApiService(this.apiService);\n        this.eventUploadService = new _bitwarden_common_services_event_event_upload_service__WEBPACK_IMPORTED_MODULE_58__.EventUploadService(this.apiService, this.stateProvider, this.logService, this.authService);\n        this.eventCollectionService = new _bitwarden_common_services_event_event_collection_service__WEBPACK_IMPORTED_MODULE_57__.EventCollectionService(this.cipherService, this.stateProvider, this.organizationService, this.eventUploadService, this.authService);\n        this.providerApiService = new _bitwarden_common_admin_console_services_provider_provider_api_service__WEBPACK_IMPORTED_MODULE_10__.ProviderApiService(this.apiService);\n    }\n    logout() {\n        return __awaiter(this, void 0, void 0, function* () {\n            this.authService.logOut(() => {\n                /* Do nothing */\n            });\n            const userId = (yield this.stateService.getUserId());\n            yield Promise.all([\n                this.eventUploadService.uploadEvents(userId),\n                this.syncService.setLastSync(new Date(0)),\n                this.cryptoService.clearKeys(),\n                this.cipherService.clear(userId),\n                this.folderService.clear(userId),\n                this.collectionService.clear(userId),\n            ]);\n            yield this.stateEventRunnerService.handleEvent(\"logout\", userId);\n            yield this.stateService.clean();\n            yield this.accountService.clean(userId);\n            process.env.BW_SESSION = null;\n        });\n    }\n    init() {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (this.inited) {\n                this.logService.warning(\"ServiceContainer.init called more than once\");\n                return;\n            }\n            yield this.storageService.init();\n            yield this.stateService.init();\n            this.containerService.attachToGlobal(global);\n            yield this.i18nService.init();\n            this.twoFactorService.init();\n            const activeAccount = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_3__.firstValueFrom)(this.accountService.activeAccount$);\n            if (activeAccount) {\n                yield this.userAutoUnlockKeyService.setUserKeyInMemoryIfAutoUserKeySet(activeAccount.id);\n            }\n            this.inited = true;\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/service-container.ts\n");

/***/ }),

/***/ "./src/tools/export.command.ts":
/*!*************************************!*\
  !*** ./src/tools/export.command.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ExportCommand: () => (/* binding */ ExportCommand)\n/* harmony export */ });\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! inquirer */ \"inquirer\");\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(inquirer__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_admin_console_enums__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/admin-console/enums */ \"../../libs/common/src/admin-console/enums/index.ts\");\n/* harmony import */ var _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/enums */ \"../../libs/common/src/enums/index.ts\");\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_vault_export_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @bitwarden/vault-export-core */ \"../../libs/tools/export/vault-export/vault-export-core/src/index.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils */ \"./src/utils.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\nclass ExportCommand {\n    constructor(exportService, policyService, eventCollectionService) {\n        this.exportService = exportService;\n        this.policyService = policyService;\n        this.eventCollectionService = eventCollectionService;\n    }\n    run(options) {\n        var _a;\n        return __awaiter(this, void 0, void 0, function* () {\n            if (options.organizationid == null &&\n                (yield this.policyService.policyAppliesToUser(_bitwarden_common_admin_console_enums__WEBPACK_IMPORTED_MODULE_1__.PolicyType.DisablePersonalVaultExport))) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.badRequest(\"One or more organization policies prevents you from exporting your personal vault.\");\n            }\n            let password = options.password;\n            // has password and format is 'json' => should have the same behaviour as 'encrypted_json'\n            // format is 'undefined' => Defaults to 'csv'\n            // Any other case => returns the options.format\n            const format = password && options.format == \"json\" ? \"encrypted_json\" : (_a = options.format) !== null && _a !== void 0 ? _a : \"csv\";\n            if (!this.isSupportedExportFormat(format)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.badRequest(`'${format}' is not a supported export format. Supported formats: ${_bitwarden_vault_export_core__WEBPACK_IMPORTED_MODULE_4__.EXPORT_FORMATS.join(\", \")}.`);\n            }\n            if (options.organizationid != null && !_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_3__.Utils.isGuid(options.organizationid)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.error(\"`\" + options.organizationid + \"` is not a GUID.\");\n            }\n            let exportContent = null;\n            try {\n                if (format === \"encrypted_json\") {\n                    password = yield this.promptPassword(password);\n                }\n                exportContent =\n                    options.organizationid == null\n                        ? yield this.exportService.getExport(format, password)\n                        : yield this.exportService.getOrganizationExport(options.organizationid, format, password);\n                const eventType = options.organizationid\n                    ? _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_2__.EventType.Organization_ClientExportedVault\n                    : _bitwarden_common_enums__WEBPACK_IMPORTED_MODULE_2__.EventType.User_ClientExportedVault;\n                // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.\n                // eslint-disable-next-line @typescript-eslint/no-floating-promises\n                this.eventCollectionService.collect(eventType, null, true, options.organizationid);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.error(e);\n            }\n            return yield this.saveFile(exportContent, options, format);\n        });\n    }\n    saveFile(exportContent, options, format) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const fileName = this.getFileName(format, options.organizationid != null ? \"org\" : null);\n                return yield _utils__WEBPACK_IMPORTED_MODULE_6__.CliUtils.saveResultToFile(exportContent, options.output, fileName);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.error(e.toString());\n            }\n        });\n    }\n    getFileName(format, prefix) {\n        if (format === \"encrypted_json\") {\n            if (prefix == null) {\n                prefix = \"encrypted\";\n            }\n            else {\n                prefix = \"encrypted_\" + prefix;\n            }\n            format = \"json\";\n        }\n        return this.exportService.getFileName(prefix, format);\n    }\n    promptPassword(password) {\n        return __awaiter(this, void 0, void 0, function* () {\n            // boolean => flag set with no value, we need to prompt for password\n            // string => flag set with value, use this value for password\n            // undefined/null/false => account protect, not password, no password needed\n            if (typeof password === \"string\") {\n                return password;\n            }\n            else if (password) {\n                const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_0__.createPromptModule({\n                    output: process.stderr,\n                })({\n                    type: \"password\",\n                    name: \"password\",\n                    message: \"Export file password:\",\n                });\n                return answer.password;\n            }\n            return null;\n        });\n    }\n    isSupportedExportFormat(format) {\n        return _bitwarden_vault_export_core__WEBPACK_IMPORTED_MODULE_4__.EXPORT_FORMATS.includes(format);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/export.command.ts\n");

/***/ }),

/***/ "./src/tools/generate.command.ts":
/*!***************************************!*\
  !*** ./src/tools/generate.command.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   GenerateCommand: () => (/* binding */ GenerateCommand)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_tools_generator_passphrase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/tools/generator/passphrase */ \"../../libs/common/src/tools/generator/passphrase/index.ts\");\n/* harmony import */ var _bitwarden_common_tools_generator_password__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/tools/generator/password */ \"../../libs/common/src/tools/generator/password/index.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_string_response__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/response/string.response */ \"./src/models/response/string.response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils */ \"./src/utils.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nclass GenerateCommand {\n    constructor(passwordGenerationService, stateService) {\n        this.passwordGenerationService = passwordGenerationService;\n        this.stateService = stateService;\n    }\n    run(cmdOptions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const normalizedOptions = new Options(cmdOptions);\n            const options = {\n                uppercase: normalizedOptions.uppercase,\n                lowercase: normalizedOptions.lowercase,\n                number: normalizedOptions.number,\n                special: normalizedOptions.special,\n                length: normalizedOptions.length,\n                type: normalizedOptions.type,\n                wordSeparator: normalizedOptions.separator,\n                numWords: normalizedOptions.words,\n                capitalize: normalizedOptions.capitalize,\n                includeNumber: normalizedOptions.includeNumber,\n                minNumber: normalizedOptions.minNumber,\n                minSpecial: normalizedOptions.minSpecial,\n                ambiguous: normalizedOptions.ambiguous,\n            };\n            const enforcedOptions = (yield this.stateService.getIsAuthenticated())\n                ? (yield this.passwordGenerationService.enforcePasswordGeneratorPoliciesOnOptions(options))[0]\n                : options;\n            const password = yield this.passwordGenerationService.generatePassword(enforcedOptions);\n            const res = new _models_response_string_response__WEBPACK_IMPORTED_MODULE_3__.StringResponse(password);\n            return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.success(res);\n        });\n    }\n}\nclass Options {\n    constructor(passedOptions) {\n        this.uppercase = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.uppercase);\n        this.lowercase = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.lowercase);\n        this.number = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.number);\n        this.special = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.special);\n        this.capitalize = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.capitalize);\n        this.includeNumber = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.includeNumber);\n        this.ambiguous = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.ambiguous);\n        this.length = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.length, _bitwarden_common_tools_generator_password__WEBPACK_IMPORTED_MODULE_1__.DefaultPasswordGenerationOptions.length);\n        this.type = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.passphrase) ? \"passphrase\" : \"password\";\n        this.separator = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertStringOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.separator, _bitwarden_common_tools_generator_passphrase__WEBPACK_IMPORTED_MODULE_0__.DefaultPassphraseGenerationOptions.wordSeparator);\n        this.words = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.words, _bitwarden_common_tools_generator_passphrase__WEBPACK_IMPORTED_MODULE_0__.DefaultPassphraseGenerationOptions.numWords);\n        this.minNumber = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.minNumber, _bitwarden_common_tools_generator_password__WEBPACK_IMPORTED_MODULE_1__.DefaultPasswordGenerationOptions.minNumber);\n        this.minSpecial = _utils__WEBPACK_IMPORTED_MODULE_4__.CliUtils.convertNumberOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.minSpecial, _bitwarden_common_tools_generator_password__WEBPACK_IMPORTED_MODULE_1__.DefaultPasswordGenerationOptions.minSpecial);\n        if (!this.uppercase && !this.lowercase && !this.special && !this.number) {\n            this.lowercase = true;\n            this.uppercase = true;\n            this.number = true;\n        }\n        if (this.length < 5) {\n            this.length = 5;\n        }\n        if (this.words < 3) {\n            this.words = 3;\n        }\n        if (this.separator === \"space\") {\n            this.separator = \" \";\n        }\n        else if (this.separator === \"empty\") {\n            this.separator = \"\";\n        }\n        else if (this.separator != null && this.separator.length > 1) {\n            this.separator = this.separator[0];\n        }\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvdG9vbHMvZ2VuZXJhdGUuY29tbWFuZC50cyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFDa0c7QUFJOUM7QUFHTjtBQUNzQjtBQUNoQztBQUU3QixNQUFNLGVBQWU7SUFDMUIsWUFDVSx5QkFBK0QsRUFDL0QsWUFBMEI7UUFEMUIsOEJBQXlCLEdBQXpCLHlCQUF5QixDQUFzQztRQUMvRCxpQkFBWSxHQUFaLFlBQVksQ0FBYztJQUNqQyxDQUFDO0lBRUUsR0FBRyxDQUFDLFVBQStCOztZQUN2QyxNQUFNLGlCQUFpQixHQUFHLElBQUksT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1lBQ2xELE1BQU0sT0FBTyxHQUE2QjtnQkFDeEMsU0FBUyxFQUFFLGlCQUFpQixDQUFDLFNBQVM7Z0JBQ3RDLFNBQVMsRUFBRSxpQkFBaUIsQ0FBQyxTQUFTO2dCQUN0QyxNQUFNLEVBQUUsaUJBQWlCLENBQUMsTUFBTTtnQkFDaEMsT0FBTyxFQUFFLGlCQUFpQixDQUFDLE9BQU87Z0JBQ2xDLE1BQU0sRUFBRSxpQkFBaUIsQ0FBQyxNQUFNO2dCQUNoQyxJQUFJLEVBQUUsaUJBQWlCLENBQUMsSUFBSTtnQkFDNUIsYUFBYSxFQUFFLGlCQUFpQixDQUFDLFNBQVM7Z0JBQzFDLFFBQVEsRUFBRSxpQkFBaUIsQ0FBQyxLQUFLO2dCQUNqQyxVQUFVLEVBQUUsaUJBQWlCLENBQUMsVUFBVTtnQkFDeEMsYUFBYSxFQUFFLGlCQUFpQixDQUFDLGFBQWE7Z0JBQzlDLFNBQVMsRUFBRSxpQkFBaUIsQ0FBQyxTQUFTO2dCQUN0QyxVQUFVLEVBQUUsaUJBQWlCLENBQUMsVUFBVTtnQkFDeEMsU0FBUyxFQUFFLGlCQUFpQixDQUFDLFNBQVM7YUFDdkMsQ0FBQztZQUVGLE1BQU0sZUFBZSxHQUFHLENBQUMsTUFBTSxJQUFJLENBQUMsWUFBWSxDQUFDLGtCQUFrQixFQUFFLENBQUM7Z0JBQ3BFLENBQUMsQ0FBQyxDQUFDLE1BQU0sSUFBSSxDQUFDLHlCQUF5QixDQUFDLHlDQUF5QyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUM5RixDQUFDLENBQUMsT0FBTyxDQUFDO1lBRVosTUFBTSxRQUFRLEdBQUcsTUFBTSxJQUFJLENBQUMseUJBQXlCLENBQUMsZ0JBQWdCLENBQUMsZUFBZSxDQUFDLENBQUM7WUFDeEYsTUFBTSxHQUFHLEdBQUcsSUFBSSw0RUFBYyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ3pDLE9BQU8sc0RBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDL0IsQ0FBQztLQUFBO0NBQ0Y7QUFFRCxNQUFNLE9BQU87SUFlWCxZQUFZLGFBQWtDO1FBQzVDLElBQUksQ0FBQyxTQUFTLEdBQUcsNENBQVEsQ0FBQyxvQkFBb0IsQ0FBQyxhQUFhLGFBQWIsYUFBYSx1QkFBYixhQUFhLENBQUUsU0FBUyxDQUFDLENBQUM7UUFDekUsSUFBSSxDQUFDLFNBQVMsR0FBRyw0Q0FBUSxDQUFDLG9CQUFvQixDQUFDLGFBQWEsYUFBYixhQUFhLHVCQUFiLGFBQWEsQ0FBRSxTQUFTLENBQUMsQ0FBQztRQUN6RSxJQUFJLENBQUMsTUFBTSxHQUFHLDRDQUFRLENBQUMsb0JBQW9CLENBQUMsYUFBYSxhQUFiLGFBQWEsdUJBQWIsYUFBYSxDQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQ25FLElBQUksQ0FBQyxPQUFPLEdBQUcsNENBQVEsQ0FBQyxvQkFBb0IsQ0FBQyxhQUFhLGFBQWIsYUFBYSx1QkFBYixhQUFhLENBQUUsT0FBTyxDQUFDLENBQUM7UUFDckUsSUFBSSxDQUFDLFVBQVUsR0FBRyw0Q0FBUSxDQUFDLG9CQUFvQixDQUFDLGFBQWEsYUFBYixhQUFhLHVCQUFiLGFBQWEsQ0FBRSxVQUFVLENBQUMsQ0FBQztRQUMzRSxJQUFJLENBQUMsYUFBYSxHQUFHLDRDQUFRLENBQUMsb0JBQW9CLENBQUMsYUFBYSxhQUFiLGFBQWEsdUJBQWIsYUFBYSxDQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQ2pGLElBQUksQ0FBQyxTQUFTLEdBQUcsNENBQVEsQ0FBQyxvQkFBb0IsQ0FBQyxhQUFhLGFBQWIsYUFBYSx1QkFBYixhQUFhLENBQUUsU0FBUyxDQUFDLENBQUM7UUFDekUsSUFBSSxDQUFDLE1BQU0sR0FBRyw0Q0FBUSxDQUFDLG1CQUFtQixDQUN4QyxhQUFhLGFBQWIsYUFBYSx1QkFBYixhQUFhLENBQUUsTUFBTSxFQUNyQix3R0FBZ0MsQ0FBQyxNQUFNLENBQ3hDLENBQUM7UUFDRixJQUFJLENBQUMsSUFBSSxHQUFHLGNBQWEsYUFBYixhQUFhLHVCQUFiLGFBQWEsQ0FBRSxVQUFVLEVBQUMsQ0FBQyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO1FBQ2xFLElBQUksQ0FBQyxTQUFTLEdBQUcsNENBQVEsQ0FBQyxtQkFBbUIsQ0FDM0MsYUFBYSxhQUFiLGFBQWEsdUJBQWIsYUFBYSxDQUFFLFNBQVMsRUFDeEIsNEdBQWtDLENBQUMsYUFBYSxDQUNqRCxDQUFDO1FBQ0YsSUFBSSxDQUFDLEtBQUssR0FBRyw0Q0FBUSxDQUFDLG1CQUFtQixDQUN2QyxhQUFhLGFBQWIsYUFBYSx1QkFBYixhQUFhLENBQUUsS0FBSyxFQUNwQiw0R0FBa0MsQ0FBQyxRQUFRLENBQzVDLENBQUM7UUFDRixJQUFJLENBQUMsU0FBUyxHQUFHLDRDQUFRLENBQUMsbUJBQW1CLENBQzNDLGFBQWEsYUFBYixhQUFhLHVCQUFiLGFBQWEsQ0FBRSxTQUFTLEVBQ3hCLHdHQUFnQyxDQUFDLFNBQVMsQ0FDM0MsQ0FBQztRQUNGLElBQUksQ0FBQyxVQUFVLEdBQUcsNENBQVEsQ0FBQyxtQkFBbUIsQ0FDNUMsYUFBYSxhQUFiLGFBQWEsdUJBQWIsYUFBYSxDQUFFLFVBQVUsRUFDekIsd0dBQWdDLENBQUMsVUFBVSxDQUM1QyxDQUFDO1FBRUYsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUU7WUFDdkUsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUM7WUFDdEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUM7WUFDdEIsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUM7U0FDcEI7UUFDRCxJQUFJLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO1lBQ25CLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDO1NBQ2pCO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxHQUFHLENBQUMsRUFBRTtZQUNsQixJQUFJLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztTQUNoQjtRQUNELElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxPQUFPLEVBQUU7WUFDOUIsSUFBSSxDQUFDLFNBQVMsR0FBRyxHQUFHLENBQUM7U0FDdEI7YUFBTSxJQUFJLElBQUksQ0FBQyxTQUFTLEtBQUssT0FBTyxFQUFFO1lBQ3JDLElBQUksQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFDO1NBQ3JCO2FBQU0sSUFBSSxJQUFJLENBQUMsU0FBUyxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDOUQsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ3BDO0lBQ0gsQ0FBQztDQUNGIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vQGJpdHdhcmRlbi9jbGkvLi9zcmMvdG9vbHMvZ2VuZXJhdGUuY29tbWFuZC50cz9hOGJhIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0YXRlU2VydmljZSB9IGZyb20gXCJAYml0d2FyZGVuL2NvbW1vbi9wbGF0Zm9ybS9hYnN0cmFjdGlvbnMvc3RhdGUuc2VydmljZVwiO1xuaW1wb3J0IHsgRGVmYXVsdFBhc3NwaHJhc2VHZW5lcmF0aW9uT3B0aW9ucyB9IGZyb20gXCJAYml0d2FyZGVuL2NvbW1vbi90b29scy9nZW5lcmF0b3IvcGFzc3BocmFzZVwiO1xuaW1wb3J0IHtcbiAgRGVmYXVsdFBhc3N3b3JkR2VuZXJhdGlvbk9wdGlvbnMsXG4gIFBhc3N3b3JkR2VuZXJhdGlvblNlcnZpY2VBYnN0cmFjdGlvbixcbn0gZnJvbSBcIkBiaXR3YXJkZW4vY29tbW9uL3Rvb2xzL2dlbmVyYXRvci9wYXNzd29yZFwiO1xuaW1wb3J0IHsgUGFzc3dvcmRHZW5lcmF0b3JPcHRpb25zIH0gZnJvbSBcIkBiaXR3YXJkZW4vY29tbW9uL3Rvb2xzL2dlbmVyYXRvci9wYXNzd29yZC9wYXNzd29yZC1nZW5lcmF0b3Itb3B0aW9uc1wiO1xuXG5pbXBvcnQgeyBSZXNwb25zZSB9IGZyb20gXCIuLi9tb2RlbHMvcmVzcG9uc2VcIjtcbmltcG9ydCB7IFN0cmluZ1Jlc3BvbnNlIH0gZnJvbSBcIi4uL21vZGVscy9yZXNwb25zZS9zdHJpbmcucmVzcG9uc2VcIjtcbmltcG9ydCB7IENsaVV0aWxzIH0gZnJvbSBcIi4uL3V0aWxzXCI7XG5cbmV4cG9ydCBjbGFzcyBHZW5lcmF0ZUNvbW1hbmQge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHBhc3N3b3JkR2VuZXJhdGlvblNlcnZpY2U6IFBhc3N3b3JkR2VuZXJhdGlvblNlcnZpY2VBYnN0cmFjdGlvbixcbiAgICBwcml2YXRlIHN0YXRlU2VydmljZTogU3RhdGVTZXJ2aWNlLFxuICApIHt9XG5cbiAgYXN5bmMgcnVuKGNtZE9wdGlvbnM6IFJlY29yZDxzdHJpbmcsIGFueT4pOiBQcm9taXNlPFJlc3BvbnNlPiB7XG4gICAgY29uc3Qgbm9ybWFsaXplZE9wdGlvbnMgPSBuZXcgT3B0aW9ucyhjbWRPcHRpb25zKTtcbiAgICBjb25zdCBvcHRpb25zOiBQYXNzd29yZEdlbmVyYXRvck9wdGlvbnMgPSB7XG4gICAgICB1cHBlcmNhc2U6IG5vcm1hbGl6ZWRPcHRpb25zLnVwcGVyY2FzZSxcbiAgICAgIGxvd2VyY2FzZTogbm9ybWFsaXplZE9wdGlvbnMubG93ZXJjYXNlLFxuICAgICAgbnVtYmVyOiBub3JtYWxpemVkT3B0aW9ucy5udW1iZXIsXG4gICAgICBzcGVjaWFsOiBub3JtYWxpemVkT3B0aW9ucy5zcGVjaWFsLFxuICAgICAgbGVuZ3RoOiBub3JtYWxpemVkT3B0aW9ucy5sZW5ndGgsXG4gICAgICB0eXBlOiBub3JtYWxpemVkT3B0aW9ucy50eXBlLFxuICAgICAgd29yZFNlcGFyYXRvcjogbm9ybWFsaXplZE9wdGlvbnMuc2VwYXJhdG9yLFxuICAgICAgbnVtV29yZHM6IG5vcm1hbGl6ZWRPcHRpb25zLndvcmRzLFxuICAgICAgY2FwaXRhbGl6ZTogbm9ybWFsaXplZE9wdGlvbnMuY2FwaXRhbGl6ZSxcbiAgICAgIGluY2x1ZGVOdW1iZXI6IG5vcm1hbGl6ZWRPcHRpb25zLmluY2x1ZGVOdW1iZXIsXG4gICAgICBtaW5OdW1iZXI6IG5vcm1hbGl6ZWRPcHRpb25zLm1pbk51bWJlcixcbiAgICAgIG1pblNwZWNpYWw6IG5vcm1hbGl6ZWRPcHRpb25zLm1pblNwZWNpYWwsXG4gICAgICBhbWJpZ3VvdXM6IG5vcm1hbGl6ZWRPcHRpb25zLmFtYmlndW91cyxcbiAgICB9O1xuXG4gICAgY29uc3QgZW5mb3JjZWRPcHRpb25zID0gKGF3YWl0IHRoaXMuc3RhdGVTZXJ2aWNlLmdldElzQXV0aGVudGljYXRlZCgpKVxuICAgICAgPyAoYXdhaXQgdGhpcy5wYXNzd29yZEdlbmVyYXRpb25TZXJ2aWNlLmVuZm9yY2VQYXNzd29yZEdlbmVyYXRvclBvbGljaWVzT25PcHRpb25zKG9wdGlvbnMpKVswXVxuICAgICAgOiBvcHRpb25zO1xuXG4gICAgY29uc3QgcGFzc3dvcmQgPSBhd2FpdCB0aGlzLnBhc3N3b3JkR2VuZXJhdGlvblNlcnZpY2UuZ2VuZXJhdGVQYXNzd29yZChlbmZvcmNlZE9wdGlvbnMpO1xuICAgIGNvbnN0IHJlcyA9IG5ldyBTdHJpbmdSZXNwb25zZShwYXNzd29yZCk7XG4gICAgcmV0dXJuIFJlc3BvbnNlLnN1Y2Nlc3MocmVzKTtcbiAgfVxufVxuXG5jbGFzcyBPcHRpb25zIHtcbiAgdXBwZXJjYXNlOiBib29sZWFuO1xuICBsb3dlcmNhc2U6IGJvb2xlYW47XG4gIG51bWJlcjogYm9vbGVhbjtcbiAgc3BlY2lhbDogYm9vbGVhbjtcbiAgbGVuZ3RoOiBudW1iZXI7XG4gIHR5cGU6IFwicGFzc3BocmFzZVwiIHwgXCJwYXNzd29yZFwiO1xuICBzZXBhcmF0b3I6IHN0cmluZztcbiAgd29yZHM6IG51bWJlcjtcbiAgY2FwaXRhbGl6ZTogYm9vbGVhbjtcbiAgaW5jbHVkZU51bWJlcjogYm9vbGVhbjtcbiAgbWluTnVtYmVyOiBudW1iZXI7XG4gIG1pblNwZWNpYWw6IG51bWJlcjtcbiAgYW1iaWd1b3VzOiBib29sZWFuO1xuXG4gIGNvbnN0cnVjdG9yKHBhc3NlZE9wdGlvbnM6IFJlY29yZDxzdHJpbmcsIGFueT4pIHtcbiAgICB0aGlzLnVwcGVyY2FzZSA9IENsaVV0aWxzLmNvbnZlcnRCb29sZWFuT3B0aW9uKHBhc3NlZE9wdGlvbnM/LnVwcGVyY2FzZSk7XG4gICAgdGhpcy5sb3dlcmNhc2UgPSBDbGlVdGlscy5jb252ZXJ0Qm9vbGVhbk9wdGlvbihwYXNzZWRPcHRpb25zPy5sb3dlcmNhc2UpO1xuICAgIHRoaXMubnVtYmVyID0gQ2xpVXRpbHMuY29udmVydEJvb2xlYW5PcHRpb24ocGFzc2VkT3B0aW9ucz8ubnVtYmVyKTtcbiAgICB0aGlzLnNwZWNpYWwgPSBDbGlVdGlscy5jb252ZXJ0Qm9vbGVhbk9wdGlvbihwYXNzZWRPcHRpb25zPy5zcGVjaWFsKTtcbiAgICB0aGlzLmNhcGl0YWxpemUgPSBDbGlVdGlscy5jb252ZXJ0Qm9vbGVhbk9wdGlvbihwYXNzZWRPcHRpb25zPy5jYXBpdGFsaXplKTtcbiAgICB0aGlzLmluY2x1ZGVOdW1iZXIgPSBDbGlVdGlscy5jb252ZXJ0Qm9vbGVhbk9wdGlvbihwYXNzZWRPcHRpb25zPy5pbmNsdWRlTnVtYmVyKTtcbiAgICB0aGlzLmFtYmlndW91cyA9IENsaVV0aWxzLmNvbnZlcnRCb29sZWFuT3B0aW9uKHBhc3NlZE9wdGlvbnM/LmFtYmlndW91cyk7XG4gICAgdGhpcy5sZW5ndGggPSBDbGlVdGlscy5jb252ZXJ0TnVtYmVyT3B0aW9uKFxuICAgICAgcGFzc2VkT3B0aW9ucz8ubGVuZ3RoLFxuICAgICAgRGVmYXVsdFBhc3N3b3JkR2VuZXJhdGlvbk9wdGlvbnMubGVuZ3RoLFxuICAgICk7XG4gICAgdGhpcy50eXBlID0gcGFzc2VkT3B0aW9ucz8ucGFzc3BocmFzZSA/IFwicGFzc3BocmFzZVwiIDogXCJwYXNzd29yZFwiO1xuICAgIHRoaXMuc2VwYXJhdG9yID0gQ2xpVXRpbHMuY29udmVydFN0cmluZ09wdGlvbihcbiAgICAgIHBhc3NlZE9wdGlvbnM/LnNlcGFyYXRvcixcbiAgICAgIERlZmF1bHRQYXNzcGhyYXNlR2VuZXJhdGlvbk9wdGlvbnMud29yZFNlcGFyYXRvcixcbiAgICApO1xuICAgIHRoaXMud29yZHMgPSBDbGlVdGlscy5jb252ZXJ0TnVtYmVyT3B0aW9uKFxuICAgICAgcGFzc2VkT3B0aW9ucz8ud29yZHMsXG4gICAgICBEZWZhdWx0UGFzc3BocmFzZUdlbmVyYXRpb25PcHRpb25zLm51bVdvcmRzLFxuICAgICk7XG4gICAgdGhpcy5taW5OdW1iZXIgPSBDbGlVdGlscy5jb252ZXJ0TnVtYmVyT3B0aW9uKFxuICAgICAgcGFzc2VkT3B0aW9ucz8ubWluTnVtYmVyLFxuICAgICAgRGVmYXVsdFBhc3N3b3JkR2VuZXJhdGlvbk9wdGlvbnMubWluTnVtYmVyLFxuICAgICk7XG4gICAgdGhpcy5taW5TcGVjaWFsID0gQ2xpVXRpbHMuY29udmVydE51bWJlck9wdGlvbihcbiAgICAgIHBhc3NlZE9wdGlvbnM/Lm1pblNwZWNpYWwsXG4gICAgICBEZWZhdWx0UGFzc3dvcmRHZW5lcmF0aW9uT3B0aW9ucy5taW5TcGVjaWFsLFxuICAgICk7XG5cbiAgICBpZiAoIXRoaXMudXBwZXJjYXNlICYmICF0aGlzLmxvd2VyY2FzZSAmJiAhdGhpcy5zcGVjaWFsICYmICF0aGlzLm51bWJlcikge1xuICAgICAgdGhpcy5sb3dlcmNhc2UgPSB0cnVlO1xuICAgICAgdGhpcy51cHBlcmNhc2UgPSB0cnVlO1xuICAgICAgdGhpcy5udW1iZXIgPSB0cnVlO1xuICAgIH1cbiAgICBpZiAodGhpcy5sZW5ndGggPCA1KSB7XG4gICAgICB0aGlzLmxlbmd0aCA9IDU7XG4gICAgfVxuICAgIGlmICh0aGlzLndvcmRzIDwgMykge1xuICAgICAgdGhpcy53b3JkcyA9IDM7XG4gICAgfVxuICAgIGlmICh0aGlzLnNlcGFyYXRvciA9PT0gXCJzcGFjZVwiKSB7XG4gICAgICB0aGlzLnNlcGFyYXRvciA9IFwiIFwiO1xuICAgIH0gZWxzZSBpZiAodGhpcy5zZXBhcmF0b3IgPT09IFwiZW1wdHlcIikge1xuICAgICAgdGhpcy5zZXBhcmF0b3IgPSBcIlwiO1xuICAgIH0gZWxzZSBpZiAodGhpcy5zZXBhcmF0b3IgIT0gbnVsbCAmJiB0aGlzLnNlcGFyYXRvci5sZW5ndGggPiAxKSB7XG4gICAgICB0aGlzLnNlcGFyYXRvciA9IHRoaXMuc2VwYXJhdG9yWzBdO1xuICAgIH1cbiAgfVxufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/tools/generate.command.ts\n");

/***/ }),

/***/ "./src/tools/import.command.ts":
/*!*************************************!*\
  !*** ./src/tools/import.command.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ImportCommand: () => (/* binding */ ImportCommand)\n/* harmony export */ });\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! inquirer */ \"inquirer\");\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(inquirer__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_message_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/response/message.response */ \"./src/models/response/message.response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils */ \"./src/utils.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass ImportCommand {\n    constructor(importService, organizationService, syncService) {\n        this.importService = importService;\n        this.organizationService = organizationService;\n        this.syncService = syncService;\n    }\n    run(format, filepath, options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const organizationId = options.organizationid;\n            if (organizationId != null) {\n                const organization = yield this.organizationService.getFromState(organizationId);\n                if (organization == null) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(`You do not belong to an organization with the ID of ${organizationId}. Check the organization ID and sync your vault.`);\n                }\n                if (!organization.canAccessImportExport) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(\"You are not authorized to import into the provided organization.\");\n                }\n            }\n            if (options.formats || false) {\n                return yield this.list();\n            }\n            else {\n                return yield this.import(format, filepath, organizationId);\n            }\n        });\n    }\n    import(format, filepath, organizationId) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (format == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(\"`format` was not provided.\");\n            }\n            if (filepath == null || filepath === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(\"`filepath` was not provided.\");\n            }\n            const promptForPassword_callback = () => __awaiter(this, void 0, void 0, function* () {\n                return yield this.promptPassword();\n            });\n            const importer = yield this.importService.getImporter(format, promptForPassword_callback, organizationId);\n            if (importer === null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(\"Proper importer type required.\");\n            }\n            try {\n                let contents;\n                if (format === \"1password1pux\" && filepath.endsWith(\".1pux\")) {\n                    contents = yield _utils__WEBPACK_IMPORTED_MODULE_3__.CliUtils.extractZipContent(filepath, \"export.data\");\n                }\n                else if (format === \"protonpass\" && filepath.endsWith(\".zip\")) {\n                    contents = yield _utils__WEBPACK_IMPORTED_MODULE_3__.CliUtils.extractZipContent(filepath, \"Proton Pass/data.json\");\n                }\n                else {\n                    contents = yield _utils__WEBPACK_IMPORTED_MODULE_3__.CliUtils.readFile(filepath);\n                }\n                if (contents === null || contents === \"\") {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(\"Import file was empty.\");\n                }\n                const response = yield this.importService.import(importer, contents, organizationId);\n                if (response.success) {\n                    // FIXME: Verify that this floating promise is intentional. If it is, add an explanatory comment and ensure there is proper error handling.\n                    // eslint-disable-next-line @typescript-eslint/no-floating-promises\n                    this.syncService.fullSync(true);\n                    return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.success(new _models_response_message_response__WEBPACK_IMPORTED_MODULE_2__.MessageResponse(\"Imported \" + filepath, null));\n                }\n            }\n            catch (err) {\n                if (err.message) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(err.message);\n                }\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.badRequest(err);\n            }\n        });\n    }\n    list() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const options = this.importService\n                .getImportOptions()\n                .sort((a, b) => {\n                return a.id < b.id ? -1 : a.id > b.id ? 1 : 0;\n            })\n                .map((option) => option.id)\n                .join(\"\\n\");\n            const res = new _models_response_message_response__WEBPACK_IMPORTED_MODULE_2__.MessageResponse(\"Supported input formats:\", options);\n            res.raw = options;\n            return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.success(res);\n        });\n    }\n    promptPassword() {\n        return __awaiter(this, void 0, void 0, function* () {\n            const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_0__.createPromptModule({\n                output: process.stderr,\n            })({\n                type: \"password\",\n                name: \"password\",\n                message: \"Import file password:\",\n            });\n            return answer.password;\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/import.command.ts\n");

/***/ }),

/***/ "./src/tools/send/commands/create.command.ts":
/*!***************************************************!*\
  !*** ./src/tools/send/commands/create.command.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendCreateCommand: () => (/* binding */ SendCreateCommand)\n/* harmony export */ });\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fs */ \"fs\");\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! path */ \"path\");\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/tools/send/enums/send-type */ \"../../libs/common/src/tools/send/enums/send-type.ts\");\n/* harmony import */ var _bitwarden_node_node_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @bitwarden/node/node-utils */ \"../../libs/node/src/node-utils.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../utils */ \"./src/utils.ts\");\n/* harmony import */ var _models_send_text_response__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../models/send-text.response */ \"./src/tools/send/models/send-text.response.ts\");\n/* harmony import */ var _models_send_response__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../models/send.response */ \"./src/tools/send/models/send.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\nclass SendCreateCommand {\n    constructor(sendService, environmentService, sendApiService, accountProfileService) {\n        this.sendService = sendService;\n        this.environmentService = environmentService;\n        this.sendApiService = sendApiService;\n        this.accountProfileService = accountProfileService;\n    }\n    run(requestJson, cmdOptions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let req = null;\n            if (process.env.BW_SERVE !== \"true\" && (requestJson == null || requestJson === \"\")) {\n                requestJson = yield _utils__WEBPACK_IMPORTED_MODULE_6__.CliUtils.readStdin();\n            }\n            if (requestJson == null || requestJson === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.badRequest(\"`requestJson` was not provided.\");\n            }\n            if (typeof requestJson !== \"string\") {\n                req = requestJson;\n                req.deletionDate = req.deletionDate == null ? null : new Date(req.deletionDate);\n                req.expirationDate = req.expirationDate == null ? null : new Date(req.expirationDate);\n            }\n            else {\n                try {\n                    const reqJson = Buffer.from(requestJson, \"base64\").toString();\n                    req = _models_send_response__WEBPACK_IMPORTED_MODULE_8__.SendResponse.fromJson(reqJson);\n                    if (req == null) {\n                        throw new Error(\"Null request\");\n                    }\n                }\n                catch (e) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.badRequest(\"Error parsing the encoded request data.\");\n                }\n            }\n            if (req.deletionDate == null ||\n                isNaN(new Date(req.deletionDate).getTime()) ||\n                new Date(req.deletionDate) <= new Date()) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.badRequest(\"Must specify a valid deletion date after the current time\");\n            }\n            if (req.expirationDate != null && isNaN(new Date(req.expirationDate).getTime())) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.badRequest(\"Unable to parse expirationDate: \" + req.expirationDate);\n            }\n            const normalizedOptions = new Options(cmdOptions);\n            return this.createSend(req, normalizedOptions);\n        });\n    }\n    createSend(req, options) {\n        var _a, _b, _c, _d, _e, _f, _g, _h;\n        return __awaiter(this, void 0, void 0, function* () {\n            const filePath = (_b = (_a = req.file) === null || _a === void 0 ? void 0 : _a.fileName) !== null && _b !== void 0 ? _b : options.file;\n            const text = (_d = (_c = req.text) === null || _c === void 0 ? void 0 : _c.text) !== null && _d !== void 0 ? _d : options.text;\n            const hidden = (_f = (_e = req.text) === null || _e === void 0 ? void 0 : _e.hidden) !== null && _f !== void 0 ? _f : options.hidden;\n            const password = (_g = req.password) !== null && _g !== void 0 ? _g : options.password;\n            const maxAccessCount = (_h = req.maxAccessCount) !== null && _h !== void 0 ? _h : options.maxAccessCount;\n            req.key = null;\n            req.maxAccessCount = maxAccessCount;\n            switch (req.type) {\n                case _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_3__.SendType.File:\n                    if (process.env.BW_SERVE === \"true\") {\n                        return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.error(\"Creating a file-based Send is unsupported through the `serve` command at this time.\");\n                    }\n                    if (!(yield (0,rxjs__WEBPACK_IMPORTED_MODULE_2__.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$))) {\n                        return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.error(\"Premium status is required to use this feature.\");\n                    }\n                    if (filePath == null) {\n                        return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.badRequest(\"Must specify a file to Send either with the --file option or in the request JSON.\");\n                    }\n                    req.file.fileName = path__WEBPACK_IMPORTED_MODULE_1__.basename(filePath);\n                    break;\n                case _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_3__.SendType.Text:\n                    if (text == null) {\n                        return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.badRequest(\"Must specify text content to Send either with the --text option or in the request JSON.\");\n                    }\n                    req.text = new _models_send_text_response__WEBPACK_IMPORTED_MODULE_7__.SendTextResponse();\n                    req.text.text = text;\n                    req.text.hidden = hidden;\n                    break;\n                default:\n                    return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.badRequest(\"Unknown Send type \" + _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_3__.SendType[req.type] + \". Valid types are: file, text\");\n            }\n            try {\n                let fileBuffer = null;\n                if (req.type === _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_3__.SendType.File) {\n                    fileBuffer = _bitwarden_node_node_utils__WEBPACK_IMPORTED_MODULE_4__.NodeUtils.bufferToArrayBuffer(fs__WEBPACK_IMPORTED_MODULE_0__.readFileSync(filePath));\n                }\n                const sendView = _models_send_response__WEBPACK_IMPORTED_MODULE_8__.SendResponse.toView(req);\n                const [encSend, fileData] = yield this.sendService.encrypt(sendView, fileBuffer, password);\n                // Add dates from template\n                encSend.deletionDate = sendView.deletionDate;\n                encSend.expirationDate = sendView.expirationDate;\n                yield this.sendApiService.save([encSend, fileData]);\n                const newSend = yield this.sendService.getFromState(encSend.id);\n                const decSend = yield newSend.decrypt();\n                const env = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_2__.firstValueFrom)(this.environmentService.environment$);\n                const res = new _models_send_response__WEBPACK_IMPORTED_MODULE_8__.SendResponse(decSend, env.getWebVaultUrl());\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_5__.Response.error(e);\n            }\n        });\n    }\n}\nclass Options {\n    constructor(passedOptions) {\n        this.file = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.file;\n        this.text = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.text;\n        this.password = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.password;\n        this.hidden = _utils__WEBPACK_IMPORTED_MODULE_6__.CliUtils.convertBooleanOption(passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.hidden);\n        this.maxAccessCount =\n            (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.maxAccessCount) != null ? parseInt(passedOptions.maxAccessCount, null) : null;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/commands/create.command.ts\n");

/***/ }),

/***/ "./src/tools/send/commands/delete.command.ts":
/*!***************************************************!*\
  !*** ./src/tools/send/commands/delete.command.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendDeleteCommand: () => (/* binding */ SendDeleteCommand)\n/* harmony export */ });\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../models/response */ \"./src/models/response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\nclass SendDeleteCommand {\n    constructor(sendService, sendApiService) {\n        this.sendService = sendService;\n        this.sendApiService = sendApiService;\n    }\n    run(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const send = yield this.sendService.getFromState(id);\n            if (send == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.notFound();\n            }\n            try {\n                yield this.sendApiService.delete(id);\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.success();\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_0__.Response.error(e);\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvdG9vbHMvc2VuZC9jb21tYW5kcy9kZWxldGUuY29tbWFuZC50cyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7OztBQUdvRDtBQUU3QyxNQUFNLGlCQUFpQjtJQUM1QixZQUNVLFdBQXdCLEVBQ3hCLGNBQThCO1FBRDlCLGdCQUFXLEdBQVgsV0FBVyxDQUFhO1FBQ3hCLG1CQUFjLEdBQWQsY0FBYyxDQUFnQjtJQUNyQyxDQUFDO0lBRUUsR0FBRyxDQUFDLEVBQVU7O1lBQ2xCLE1BQU0sSUFBSSxHQUFHLE1BQU0sSUFBSSxDQUFDLFdBQVcsQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDLENBQUM7WUFFckQsSUFBSSxJQUFJLElBQUksSUFBSSxFQUFFO2dCQUNoQixPQUFPLHNEQUFRLENBQUMsUUFBUSxFQUFFLENBQUM7YUFDNUI7WUFFRCxJQUFJO2dCQUNGLE1BQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDLENBQUM7Z0JBQ3JDLE9BQU8sc0RBQVEsQ0FBQyxPQUFPLEVBQUUsQ0FBQzthQUMzQjtZQUFDLE9BQU8sQ0FBQyxFQUFFO2dCQUNWLE9BQU8sc0RBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7YUFDMUI7UUFDSCxDQUFDO0tBQUE7Q0FDRiIsInNvdXJjZXMiOlsid2VicGFjazovL0BiaXR3YXJkZW4vY2xpLy4vc3JjL3Rvb2xzL3NlbmQvY29tbWFuZHMvZGVsZXRlLmNvbW1hbmQudHM/MzNkNiJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTZW5kQXBpU2VydmljZSB9IGZyb20gXCJAYml0d2FyZGVuL2NvbW1vbi90b29scy9zZW5kL3NlcnZpY2VzL3NlbmQtYXBpLnNlcnZpY2UuYWJzdHJhY3Rpb25cIjtcbmltcG9ydCB7IFNlbmRTZXJ2aWNlIH0gZnJvbSBcIkBiaXR3YXJkZW4vY29tbW9uL3Rvb2xzL3NlbmQvc2VydmljZXMvc2VuZC5zZXJ2aWNlLmFic3RyYWN0aW9uXCI7XG5cbmltcG9ydCB7IFJlc3BvbnNlIH0gZnJvbSBcIi4uLy4uLy4uL21vZGVscy9yZXNwb25zZVwiO1xuXG5leHBvcnQgY2xhc3MgU2VuZERlbGV0ZUNvbW1hbmQge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHNlbmRTZXJ2aWNlOiBTZW5kU2VydmljZSxcbiAgICBwcml2YXRlIHNlbmRBcGlTZXJ2aWNlOiBTZW5kQXBpU2VydmljZSxcbiAgKSB7fVxuXG4gIGFzeW5jIHJ1bihpZDogc3RyaW5nKSB7XG4gICAgY29uc3Qgc2VuZCA9IGF3YWl0IHRoaXMuc2VuZFNlcnZpY2UuZ2V0RnJvbVN0YXRlKGlkKTtcblxuICAgIGlmIChzZW5kID09IG51bGwpIHtcbiAgICAgIHJldHVybiBSZXNwb25zZS5ub3RGb3VuZCgpO1xuICAgIH1cblxuICAgIHRyeSB7XG4gICAgICBhd2FpdCB0aGlzLnNlbmRBcGlTZXJ2aWNlLmRlbGV0ZShpZCk7XG4gICAgICByZXR1cm4gUmVzcG9uc2Uuc3VjY2VzcygpO1xuICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgIHJldHVybiBSZXNwb25zZS5lcnJvcihlKTtcbiAgICB9XG4gIH1cbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./src/tools/send/commands/delete.command.ts\n");

/***/ }),

/***/ "./src/tools/send/commands/edit.command.ts":
/*!*************************************************!*\
  !*** ./src/tools/send/commands/edit.command.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendEditCommand: () => (/* binding */ SendEditCommand)\n/* harmony export */ });\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/tools/send/enums/send-type */ \"../../libs/common/src/tools/send/enums/send-type.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils */ \"./src/utils.ts\");\n/* harmony import */ var _models_send_response__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../models/send.response */ \"./src/tools/send/models/send.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nclass SendEditCommand {\n    constructor(sendService, getCommand, sendApiService, accountProfileService) {\n        this.sendService = sendService;\n        this.getCommand = getCommand;\n        this.sendApiService = sendApiService;\n        this.accountProfileService = accountProfileService;\n    }\n    run(requestJson, cmdOptions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (process.env.BW_SERVE !== \"true\" && (requestJson == null || requestJson === \"\")) {\n                requestJson = yield _utils__WEBPACK_IMPORTED_MODULE_3__.CliUtils.readStdin();\n            }\n            if (requestJson == null || requestJson === \"\") {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.badRequest(\"`requestJson` was not provided.\");\n            }\n            let req = null;\n            if (typeof requestJson !== \"string\") {\n                req = requestJson;\n                req.deletionDate = req.deletionDate == null ? null : new Date(req.deletionDate);\n                req.expirationDate = req.expirationDate == null ? null : new Date(req.expirationDate);\n            }\n            else {\n                try {\n                    const reqJson = Buffer.from(requestJson, \"base64\").toString();\n                    req = _models_send_response__WEBPACK_IMPORTED_MODULE_4__.SendResponse.fromJson(reqJson);\n                }\n                catch (e) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.badRequest(\"Error parsing the encoded request data.\");\n                }\n            }\n            const normalizedOptions = new Options(cmdOptions);\n            req.id = normalizedOptions.itemId || req.id;\n            if (req.id != null) {\n                req.id = req.id.toLowerCase();\n            }\n            const send = yield this.sendService.getFromState(req.id);\n            if (send == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.notFound();\n            }\n            if (send.type !== req.type) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.badRequest(\"Cannot change a Send's type\");\n            }\n            const canAccessPremium = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.accountProfileService.hasPremiumFromAnySource$);\n            if (send.type === _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__.SendType.File && !canAccessPremium) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.error(\"Premium status is required to use this feature.\");\n            }\n            let sendView = yield send.decrypt();\n            sendView = _models_send_response__WEBPACK_IMPORTED_MODULE_4__.SendResponse.toView(req, sendView);\n            if (typeof req.password !== \"string\" || req.password === \"\") {\n                req.password = null;\n            }\n            try {\n                const [encSend, encFileData] = yield this.sendService.encrypt(sendView, null, req.password);\n                // Add dates from template\n                encSend.deletionDate = sendView.deletionDate;\n                encSend.expirationDate = sendView.expirationDate;\n                yield this.sendApiService.save([encSend, encFileData]);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_2__.Response.error(e);\n            }\n            return yield this.getCommand.run(send.id, {});\n        });\n    }\n}\nclass Options {\n    constructor(passedOptions) {\n        this.itemId = (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemId) || (passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.itemid);\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/commands/edit.command.ts\n");

/***/ }),

/***/ "./src/tools/send/commands/get.command.ts":
/*!************************************************!*\
  !*** ./src/tools/send/commands/get.command.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendGetCommand: () => (/* binding */ SendGetCommand)\n/* harmony export */ });\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _commands_download_command__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../commands/download.command */ \"./src/commands/download.command.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_send_response__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../models/send.response */ \"./src/tools/send/models/send.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\nclass SendGetCommand extends _commands_download_command__WEBPACK_IMPORTED_MODULE_2__.DownloadCommand {\n    constructor(sendService, environmentService, searchService, cryptoService) {\n        super(cryptoService);\n        this.sendService = sendService;\n        this.environmentService = environmentService;\n        this.searchService = searchService;\n    }\n    run(id, options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const serveCommand = process.env.BW_SERVE === \"true\";\n            if (serveCommand && !_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.isGuid(id)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.badRequest(\"`\" + id + \"` is not a GUID.\");\n            }\n            let sends = yield this.getSendView(id);\n            if (sends == null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.notFound();\n            }\n            const env = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.environmentService.environment$);\n            const webVaultUrl = env.getWebVaultUrl();\n            let filter = (s) => true;\n            let selector = (s) => __awaiter(this, void 0, void 0, function* () { return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.success(new _models_send_response__WEBPACK_IMPORTED_MODULE_4__.SendResponse(s, webVaultUrl)); });\n            if (!serveCommand && (options === null || options === void 0 ? void 0 : options.text) != null) {\n                filter = (s) => {\n                    return filter(s) && s.text != null;\n                };\n                selector = (s) => __awaiter(this, void 0, void 0, function* () {\n                    // Write to stdout and response success so we get the text string only to stdout\n                    process.stdout.write(s.text.text);\n                    return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.success();\n                });\n            }\n            if (Array.isArray(sends)) {\n                if (filter != null) {\n                    sends = sends.filter(filter);\n                }\n                if (sends.length > 1) {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.multipleResults(sends.map((s) => s.id));\n                }\n                if (sends.length > 0) {\n                    return selector(sends[0]);\n                }\n                else {\n                    return _models_response__WEBPACK_IMPORTED_MODULE_3__.Response.notFound();\n                }\n            }\n            return selector(sends);\n        });\n    }\n    getSendView(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_1__.Utils.isGuid(id)) {\n                const send = yield this.sendService.getFromState(id);\n                if (send != null) {\n                    return yield send.decrypt();\n                }\n            }\n            else if (id.trim() !== \"\") {\n                let sends = yield this.sendService.getAllDecryptedFromState();\n                sends = this.searchService.searchSends(sends, id);\n                if (sends.length > 1) {\n                    return sends;\n                }\n                else if (sends.length > 0) {\n                    return sends[0];\n                }\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/commands/get.command.ts\n");

/***/ }),

/***/ "./src/tools/send/commands/index.ts":
/*!******************************************!*\
  !*** ./src/tools/send/commands/index.ts ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendCreateCommand: () => (/* reexport safe */ _create_command__WEBPACK_IMPORTED_MODULE_0__.SendCreateCommand),\n/* harmony export */   SendDeleteCommand: () => (/* reexport safe */ _delete_command__WEBPACK_IMPORTED_MODULE_1__.SendDeleteCommand),\n/* harmony export */   SendEditCommand: () => (/* reexport safe */ _edit_command__WEBPACK_IMPORTED_MODULE_2__.SendEditCommand),\n/* harmony export */   SendGetCommand: () => (/* reexport safe */ _get_command__WEBPACK_IMPORTED_MODULE_3__.SendGetCommand),\n/* harmony export */   SendListCommand: () => (/* reexport safe */ _list_command__WEBPACK_IMPORTED_MODULE_4__.SendListCommand),\n/* harmony export */   SendReceiveCommand: () => (/* reexport safe */ _receive_command__WEBPACK_IMPORTED_MODULE_5__.SendReceiveCommand),\n/* harmony export */   SendRemovePasswordCommand: () => (/* reexport safe */ _remove_password_command__WEBPACK_IMPORTED_MODULE_6__.SendRemovePasswordCommand)\n/* harmony export */ });\n/* harmony import */ var _create_command__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./create.command */ \"./src/tools/send/commands/create.command.ts\");\n/* harmony import */ var _delete_command__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./delete.command */ \"./src/tools/send/commands/delete.command.ts\");\n/* harmony import */ var _edit_command__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./edit.command */ \"./src/tools/send/commands/edit.command.ts\");\n/* harmony import */ var _get_command__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./get.command */ \"./src/tools/send/commands/get.command.ts\");\n/* harmony import */ var _list_command__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./list.command */ \"./src/tools/send/commands/list.command.ts\");\n/* harmony import */ var _receive_command__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./receive.command */ \"./src/tools/send/commands/receive.command.ts\");\n/* harmony import */ var _remove_password_command__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./remove-password.command */ \"./src/tools/send/commands/remove-password.command.ts\");\n\n\n\n\n\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvdG9vbHMvc2VuZC9jb21tYW5kcy9pbmRleC50cyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7OztBQUFpQztBQUNBO0FBQ0Y7QUFDRDtBQUNDO0FBQ0c7QUFDUSIsInNvdXJjZXMiOlsid2VicGFjazovL0BiaXR3YXJkZW4vY2xpLy4vc3JjL3Rvb2xzL3NlbmQvY29tbWFuZHMvaW5kZXgudHM/NzYxNiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgKiBmcm9tIFwiLi9jcmVhdGUuY29tbWFuZFwiO1xuZXhwb3J0ICogZnJvbSBcIi4vZGVsZXRlLmNvbW1hbmRcIjtcbmV4cG9ydCAqIGZyb20gXCIuL2VkaXQuY29tbWFuZFwiO1xuZXhwb3J0ICogZnJvbSBcIi4vZ2V0LmNvbW1hbmRcIjtcbmV4cG9ydCAqIGZyb20gXCIuL2xpc3QuY29tbWFuZFwiO1xuZXhwb3J0ICogZnJvbSBcIi4vcmVjZWl2ZS5jb21tYW5kXCI7XG5leHBvcnQgKiBmcm9tIFwiLi9yZW1vdmUtcGFzc3dvcmQuY29tbWFuZFwiO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/tools/send/commands/index.ts\n");

/***/ }),

/***/ "./src/tools/send/commands/list.command.ts":
/*!*************************************************!*\
  !*** ./src/tools/send/commands/list.command.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendListCommand: () => (/* binding */ SendListCommand)\n/* harmony export */ });\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_response_list_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../models/response/list.response */ \"./src/models/response/list.response.ts\");\n/* harmony import */ var _models_send_response__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/send.response */ \"./src/tools/send/models/send.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\nclass SendListCommand {\n    constructor(sendService, environmentService, searchService) {\n        this.sendService = sendService;\n        this.environmentService = environmentService;\n        this.searchService = searchService;\n    }\n    run(cmdOptions) {\n        return __awaiter(this, void 0, void 0, function* () {\n            let sends = yield this.sendService.getAllDecryptedFromState();\n            const normalizedOptions = new Options(cmdOptions);\n            if (normalizedOptions.search != null && normalizedOptions.search.trim() !== \"\") {\n                sends = this.searchService.searchSends(sends, normalizedOptions.search);\n            }\n            const env = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.environmentService.environment$);\n            const webVaultUrl = env.getWebVaultUrl();\n            const res = new _models_response_list_response__WEBPACK_IMPORTED_MODULE_2__.ListResponse(sends.map((s) => new _models_send_response__WEBPACK_IMPORTED_MODULE_3__.SendResponse(s, webVaultUrl)));\n            return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.success(res);\n        });\n    }\n}\nclass Options {\n    constructor(passedOptions) {\n        this.search = passedOptions === null || passedOptions === void 0 ? void 0 : passedOptions.search;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/commands/list.command.ts\n");

/***/ }),

/***/ "./src/tools/send/commands/receive.command.ts":
/*!****************************************************!*\
  !*** ./src/tools/send/commands/receive.command.ts ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendReceiveCommand: () => (/* binding */ SendReceiveCommand)\n/* harmony export */ });\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! inquirer */ \"inquirer\");\n/* harmony import */ var inquirer__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(inquirer__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _bitwarden_common_models_response_error_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/models/response/error.response */ \"../../libs/common/src/models/response/error.response.ts\");\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @bitwarden/common/tools/send/enums/send-type */ \"../../libs/common/src/tools/send/enums/send-type.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_models_domain_send_access__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @bitwarden/common/tools/send/models/domain/send-access */ \"../../libs/common/src/tools/send/models/domain/send-access.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_models_request_send_access_request__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @bitwarden/common/tools/send/models/request/send-access.request */ \"../../libs/common/src/tools/send/models/request/send-access.request.ts\");\n/* harmony import */ var _bitwarden_node_node_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @bitwarden/node/node-utils */ \"../../libs/node/src/node-utils.ts\");\n/* harmony import */ var _commands_download_command__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../commands/download.command */ \"./src/commands/download.command.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_send_access_response__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../models/send-access.response */ \"./src/tools/send/models/send-access.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\nclass SendReceiveCommand extends _commands_download_command__WEBPACK_IMPORTED_MODULE_8__.DownloadCommand {\n    constructor(apiService, cryptoService, cryptoFunctionService, platformUtilsService, environmentService, sendApiService) {\n        super(cryptoService);\n        this.apiService = apiService;\n        this.cryptoFunctionService = cryptoFunctionService;\n        this.platformUtilsService = platformUtilsService;\n        this.environmentService = environmentService;\n        this.sendApiService = sendApiService;\n    }\n    run(url, options) {\n        var _a, _b;\n        return __awaiter(this, void 0, void 0, function* () {\n            this.canInteract = process.env.BW_NOINTERACTION !== \"true\";\n            let urlObject;\n            try {\n                urlObject = new URL(url);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_9__.Response.badRequest(\"Failed to parse the provided Send url\");\n            }\n            const apiUrl = yield this.getApiUrl(urlObject);\n            const [id, key] = this.getIdAndKey(urlObject);\n            if (_bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_3__.Utils.isNullOrWhitespace(id) || _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_3__.Utils.isNullOrWhitespace(key)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_9__.Response.badRequest(\"Failed to parse url, the url provided is not a valid Send url\");\n            }\n            const keyArray = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_3__.Utils.fromUrlB64ToArray(key);\n            this.sendAccessRequest = new _bitwarden_common_tools_send_models_request_send_access_request__WEBPACK_IMPORTED_MODULE_6__.SendAccessRequest();\n            let password = options.password;\n            if (password == null || password === \"\") {\n                if (options.passwordfile) {\n                    password = yield _bitwarden_node_node_utils__WEBPACK_IMPORTED_MODULE_7__.NodeUtils.readFirstLine(options.passwordfile);\n                }\n                else if (options.passwordenv && process.env[options.passwordenv]) {\n                    password = process.env[options.passwordenv];\n                }\n            }\n            if (password != null && password !== \"\") {\n                this.sendAccessRequest.password = yield this.getUnlockedPassword(password, keyArray);\n            }\n            const response = yield this.sendRequest(apiUrl, id, keyArray);\n            if (response instanceof _models_response__WEBPACK_IMPORTED_MODULE_9__.Response) {\n                // Error scenario\n                return response;\n            }\n            if (options.obj != null) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_9__.Response.success(new _models_send_access_response__WEBPACK_IMPORTED_MODULE_10__.SendAccessResponse(response));\n            }\n            switch (response.type) {\n                case _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_4__.SendType.Text:\n                    // Write to stdout and response success so we get the text string only to stdout\n                    process.stdout.write((_a = response === null || response === void 0 ? void 0 : response.text) === null || _a === void 0 ? void 0 : _a.text);\n                    return _models_response__WEBPACK_IMPORTED_MODULE_9__.Response.success();\n                case _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_4__.SendType.File: {\n                    const downloadData = yield this.sendApiService.getSendFileDownloadData(response, this.sendAccessRequest, apiUrl);\n                    return yield this.saveAttachmentToFile(downloadData.url, this.decKey, (_b = response === null || response === void 0 ? void 0 : response.file) === null || _b === void 0 ? void 0 : _b.fileName, options.output);\n                }\n                default:\n                    return _models_response__WEBPACK_IMPORTED_MODULE_9__.Response.success(new _models_send_access_response__WEBPACK_IMPORTED_MODULE_10__.SendAccessResponse(response));\n            }\n        });\n    }\n    getIdAndKey(url) {\n        const result = url.hash.slice(1).split(\"/\").slice(-2);\n        return [result[0], result[1]];\n    }\n    getApiUrl(url) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const env = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_1__.firstValueFrom)(this.environmentService.environment$);\n            const urls = env.getUrls();\n            if (url.origin === \"https://send.bitwarden.com\") {\n                return \"https://api.bitwarden.com\";\n            }\n            else if (url.origin === urls.api) {\n                return url.origin;\n            }\n            else if (this.platformUtilsService.isDev() && url.origin === urls.webVault) {\n                return urls.api;\n            }\n            else {\n                return url.origin + \"/api\";\n            }\n        });\n    }\n    getUnlockedPassword(password, keyArray) {\n        return __awaiter(this, void 0, void 0, function* () {\n            const passwordHash = yield this.cryptoFunctionService.pbkdf2(password, keyArray, \"sha256\", 100000);\n            return _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_3__.Utils.fromBufferToB64(passwordHash);\n        });\n    }\n    sendRequest(url, id, key) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                const sendResponse = yield this.sendApiService.postSendAccess(id, this.sendAccessRequest, url);\n                const sendAccess = new _bitwarden_common_tools_send_models_domain_send_access__WEBPACK_IMPORTED_MODULE_5__.SendAccess(sendResponse);\n                this.decKey = yield this.cryptoService.makeSendKey(key);\n                return yield sendAccess.decrypt(this.decKey);\n            }\n            catch (e) {\n                if (e instanceof _bitwarden_common_models_response_error_response__WEBPACK_IMPORTED_MODULE_2__.ErrorResponse) {\n                    if (e.statusCode === 401) {\n                        if (this.canInteract) {\n                            const answer = yield inquirer__WEBPACK_IMPORTED_MODULE_0__.createPromptModule({\n                                output: process.stderr,\n                            })({\n                                type: \"password\",\n                                name: \"password\",\n                                message: \"Send password:\",\n                            });\n                            // reattempt with new password\n                            this.sendAccessRequest.password = yield this.getUnlockedPassword(answer.password, key);\n                            return yield this.sendRequest(url, id, key);\n                        }\n                        return _models_response__WEBPACK_IMPORTED_MODULE_9__.Response.badRequest(\"Incorrect or missing password\");\n                    }\n                    else if (e.statusCode === 405) {\n                        return _models_response__WEBPACK_IMPORTED_MODULE_9__.Response.badRequest(\"Bad Request\");\n                    }\n                    else if (e.statusCode === 404) {\n                        return _models_response__WEBPACK_IMPORTED_MODULE_9__.Response.notFound();\n                    }\n                }\n                return _models_response__WEBPACK_IMPORTED_MODULE_9__.Response.error(e);\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/commands/receive.command.ts\n");

/***/ }),

/***/ "./src/tools/send/commands/remove-password.command.ts":
/*!************************************************************!*\
  !*** ./src/tools/send/commands/remove-password.command.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendRemovePasswordCommand: () => (/* binding */ SendRemovePasswordCommand)\n/* harmony export */ });\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs */ \"rxjs\");\n/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _models_send_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../models/send.response */ \"./src/tools/send/models/send.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\nclass SendRemovePasswordCommand {\n    constructor(sendService, sendApiService, environmentService) {\n        this.sendService = sendService;\n        this.sendApiService = sendApiService;\n        this.environmentService = environmentService;\n    }\n    run(id) {\n        return __awaiter(this, void 0, void 0, function* () {\n            try {\n                yield this.sendApiService.removePassword(id);\n                const updatedSend = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.sendService.get$(id));\n                const decSend = yield updatedSend.decrypt();\n                const env = yield (0,rxjs__WEBPACK_IMPORTED_MODULE_0__.firstValueFrom)(this.environmentService.environment$);\n                const webVaultUrl = env.getWebVaultUrl();\n                const res = new _models_send_response__WEBPACK_IMPORTED_MODULE_2__.SendResponse(decSend, webVaultUrl);\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.success(res);\n            }\n            catch (e) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_1__.Response.error(e);\n            }\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/commands/remove-password.command.ts\n");

/***/ }),

/***/ "./src/tools/send/index.ts":
/*!*********************************!*\
  !*** ./src/tools/send/index.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendCreateCommand: () => (/* reexport safe */ _commands__WEBPACK_IMPORTED_MODULE_0__.SendCreateCommand),\n/* harmony export */   SendDeleteCommand: () => (/* reexport safe */ _commands__WEBPACK_IMPORTED_MODULE_0__.SendDeleteCommand),\n/* harmony export */   SendEditCommand: () => (/* reexport safe */ _commands__WEBPACK_IMPORTED_MODULE_0__.SendEditCommand),\n/* harmony export */   SendGetCommand: () => (/* reexport safe */ _commands__WEBPACK_IMPORTED_MODULE_0__.SendGetCommand),\n/* harmony export */   SendListCommand: () => (/* reexport safe */ _commands__WEBPACK_IMPORTED_MODULE_0__.SendListCommand),\n/* harmony export */   SendReceiveCommand: () => (/* reexport safe */ _commands__WEBPACK_IMPORTED_MODULE_0__.SendReceiveCommand),\n/* harmony export */   SendRemovePasswordCommand: () => (/* reexport safe */ _commands__WEBPACK_IMPORTED_MODULE_0__.SendRemovePasswordCommand)\n/* harmony export */ });\n/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./commands */ \"./src/tools/send/commands/index.ts\");\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvdG9vbHMvc2VuZC9pbmRleC50cyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUEyQiIsInNvdXJjZXMiOlsid2VicGFjazovL0BiaXR3YXJkZW4vY2xpLy4vc3JjL3Rvb2xzL3NlbmQvaW5kZXgudHM/Mjg1MiJdLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgKiBmcm9tIFwiLi9jb21tYW5kc1wiO1xuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./src/tools/send/index.ts\n");

/***/ }),

/***/ "./src/tools/send/models/send-access.response.ts":
/*!*******************************************************!*\
  !*** ./src/tools/send/models/send-access.response.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendAccessResponse: () => (/* binding */ SendAccessResponse)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/tools/send/enums/send-type */ \"../../libs/common/src/tools/send/enums/send-type.ts\");\n/* harmony import */ var _send_file_response__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./send-file.response */ \"./src/tools/send/models/send-file.response.ts\");\n/* harmony import */ var _send_text_response__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./send-text.response */ \"./src/tools/send/models/send-text.response.ts\");\n\n\n\nclass SendAccessResponse {\n    static template() {\n        const req = new SendAccessResponse();\n        req.name = \"Send name\";\n        req.type = _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_0__.SendType.Text;\n        req.text = null;\n        req.file = null;\n        return req;\n    }\n    constructor(o) {\n        this.object = \"send-access\";\n        if (o == null) {\n            return;\n        }\n        this.id = o.id;\n        this.name = o.name;\n        this.type = o.type;\n        if (o.type === _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_0__.SendType.Text && o.text != null) {\n            this.text = new _send_text_response__WEBPACK_IMPORTED_MODULE_2__.SendTextResponse(o.text);\n        }\n        if (o.type === _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_0__.SendType.File && o.file != null) {\n            this.file = new _send_file_response__WEBPACK_IMPORTED_MODULE_1__.SendFileResponse(o.file);\n        }\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/models/send-access.response.ts\n");

/***/ }),

/***/ "./src/tools/send/models/send-file.response.ts":
/*!*****************************************************!*\
  !*** ./src/tools/send/models/send-file.response.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendFileResponse: () => (/* binding */ SendFileResponse)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_tools_send_models_view_send_file_view__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/tools/send/models/view/send-file.view */ \"../../libs/common/src/tools/send/models/view/send-file.view.ts\");\n\nclass SendFileResponse {\n    static template(fileName = \"file attachment location\") {\n        const req = new SendFileResponse();\n        req.fileName = fileName;\n        return req;\n    }\n    static toView(file, view = new _bitwarden_common_tools_send_models_view_send_file_view__WEBPACK_IMPORTED_MODULE_0__.SendFileView()) {\n        if (file == null) {\n            return null;\n        }\n        view.id = file.id;\n        view.size = file.size;\n        view.sizeName = file.sizeName;\n        view.fileName = file.fileName;\n        return view;\n    }\n    constructor(o) {\n        if (o == null) {\n            return;\n        }\n        this.id = o.id;\n        this.size = o.size;\n        this.sizeName = o.sizeName;\n        this.fileName = o.fileName;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/models/send-file.response.ts\n");

/***/ }),

/***/ "./src/tools/send/models/send-text.response.ts":
/*!*****************************************************!*\
  !*** ./src/tools/send/models/send-text.response.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendTextResponse: () => (/* binding */ SendTextResponse)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_tools_send_models_view_send_text_view__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/tools/send/models/view/send-text.view */ \"../../libs/common/src/tools/send/models/view/send-text.view.ts\");\n\nclass SendTextResponse {\n    static template(text = \"Text contained in the send.\", hidden = false) {\n        const req = new SendTextResponse();\n        req.text = text;\n        req.hidden = hidden;\n        return req;\n    }\n    static toView(text, view = new _bitwarden_common_tools_send_models_view_send_text_view__WEBPACK_IMPORTED_MODULE_0__.SendTextView()) {\n        if (text == null) {\n            return null;\n        }\n        view.text = text.text;\n        view.hidden = text.hidden;\n        return view;\n    }\n    constructor(o) {\n        if (o == null) {\n            return;\n        }\n        this.text = o.text;\n        this.hidden = o.hidden;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/models/send-text.response.ts\n");

/***/ }),

/***/ "./src/tools/send/models/send.response.ts":
/*!************************************************!*\
  !*** ./src/tools/send/models/send.response.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendResponse: () => (/* binding */ SendResponse)\n/* harmony export */ });\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @bitwarden/common/tools/send/enums/send-type */ \"../../libs/common/src/tools/send/enums/send-type.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_models_view_send_view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @bitwarden/common/tools/send/models/view/send.view */ \"../../libs/common/src/tools/send/models/view/send.view.ts\");\n/* harmony import */ var _send_file_response__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./send-file.response */ \"./src/tools/send/models/send-file.response.ts\");\n/* harmony import */ var _send_text_response__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./send-text.response */ \"./src/tools/send/models/send-text.response.ts\");\n\n\n\n\n\nconst dateProperties = [\n    _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_0__.Utils.nameOf(\"deletionDate\"),\n    _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_0__.Utils.nameOf(\"expirationDate\"),\n];\nclass SendResponse {\n    static template(sendType, deleteInDays = 7) {\n        const req = new SendResponse();\n        req.name = \"Send name\";\n        req.notes = \"Some notes about this send.\";\n        req.type = sendType === _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__.SendType.File ? _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__.SendType.File : _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__.SendType.Text;\n        req.text = sendType === _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__.SendType.Text ? _send_text_response__WEBPACK_IMPORTED_MODULE_4__.SendTextResponse.template() : null;\n        req.file = sendType === _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__.SendType.File ? _send_file_response__WEBPACK_IMPORTED_MODULE_3__.SendFileResponse.template() : null;\n        req.maxAccessCount = null;\n        req.deletionDate = this.getStandardDeletionDate(deleteInDays);\n        req.expirationDate = null;\n        req.password = null;\n        req.disabled = false;\n        req.hideEmail = false;\n        return req;\n    }\n    static toView(send, view = new _bitwarden_common_tools_send_models_view_send_view__WEBPACK_IMPORTED_MODULE_2__.SendView()) {\n        if (send == null) {\n            return null;\n        }\n        view.id = send.id;\n        view.accessId = send.accessId;\n        view.name = send.name;\n        view.notes = send.notes;\n        view.key = send.key == null ? null : _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_0__.Utils.fromB64ToArray(send.key);\n        view.type = send.type;\n        view.file = _send_file_response__WEBPACK_IMPORTED_MODULE_3__.SendFileResponse.toView(send.file);\n        view.text = _send_text_response__WEBPACK_IMPORTED_MODULE_4__.SendTextResponse.toView(send.text);\n        view.maxAccessCount = send.maxAccessCount;\n        view.accessCount = send.accessCount;\n        view.revisionDate = send.revisionDate;\n        view.deletionDate = send.deletionDate;\n        view.expirationDate = send.expirationDate;\n        view.password = send.password;\n        view.disabled = send.disabled;\n        view.hideEmail = send.hideEmail;\n        return view;\n    }\n    static fromJson(json) {\n        return JSON.parse(json, (key, value) => {\n            if (dateProperties.includes(key)) {\n                return value == null ? null : new Date(value);\n            }\n            return value;\n        });\n    }\n    static getStandardDeletionDate(days) {\n        const d = new Date();\n        d.setTime(d.getTime() + days * 86400000); // ms per day\n        return d;\n    }\n    constructor(o, webVaultUrl) {\n        this.object = \"send\";\n        if (o == null) {\n            return;\n        }\n        this.id = o.id;\n        this.accessId = o.accessId;\n        let sendLinkBaseUrl = webVaultUrl;\n        if (sendLinkBaseUrl == null) {\n            sendLinkBaseUrl = \"https://send.bitwarden.com/#\";\n        }\n        else {\n            sendLinkBaseUrl += \"/#/send/\";\n        }\n        this.accessUrl = sendLinkBaseUrl + this.accessId + \"/\" + o.urlB64Key;\n        this.name = o.name;\n        this.notes = o.notes;\n        this.key = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_0__.Utils.fromBufferToB64(o.key);\n        this.type = o.type;\n        this.maxAccessCount = o.maxAccessCount;\n        this.accessCount = o.accessCount;\n        this.revisionDate = o.revisionDate;\n        this.deletionDate = o.deletionDate;\n        this.expirationDate = o.expirationDate;\n        this.passwordSet = o.password != null;\n        this.disabled = o.disabled;\n        this.hideEmail = o.hideEmail;\n        if (o.type === _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__.SendType.Text && o.text != null) {\n            this.text = new _send_text_response__WEBPACK_IMPORTED_MODULE_4__.SendTextResponse(o.text);\n        }\n        if (o.type === _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_1__.SendType.File && o.file != null) {\n            this.file = new _send_file_response__WEBPACK_IMPORTED_MODULE_3__.SendFileResponse(o.file);\n        }\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/tools/send/models/send.response.ts\n");

/***/ }),

/***/ "./src/tools/send/send.program.ts":
/*!****************************************!*\
  !*** ./src/tools/send/send.program.ts ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SendProgram: () => (/* binding */ SendProgram)\n/* harmony export */ });\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fs */ \"fs\");\n/* harmony import */ var fs__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(fs__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! path */ \"path\");\n/* harmony import */ var path__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(path__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! chalk */ \"chalk\");\n/* harmony import */ var chalk__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(chalk__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var commander__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commander */ \"commander\");\n/* harmony import */ var commander__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(commander__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @bitwarden/common/platform/misc/utils */ \"../../libs/common/src/platform/misc/utils.ts\");\n/* harmony import */ var _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @bitwarden/common/tools/send/enums/send-type */ \"../../libs/common/src/tools/send/enums/send-type.ts\");\n/* harmony import */ var _base_program__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../base-program */ \"./src/base-program.ts\");\n/* harmony import */ var _commands_get_command__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../commands/get.command */ \"./src/commands/get.command.ts\");\n/* harmony import */ var _models_response__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../models/response */ \"./src/models/response.ts\");\n/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils */ \"./src/utils.ts\");\n/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./commands */ \"./src/tools/send/commands/index.ts\");\n/* harmony import */ var _models_send_file_response__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./models/send-file.response */ \"./src/tools/send/models/send-file.response.ts\");\n/* harmony import */ var _models_send_text_response__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./models/send-text.response */ \"./src/tools/send/models/send-text.response.ts\");\n/* harmony import */ var _models_send_response__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./models/send.response */ \"./src/tools/send/models/send.response.ts\");\nvar __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nconst writeLn = _utils__WEBPACK_IMPORTED_MODULE_9__.CliUtils.writeLn;\nclass SendProgram extends _base_program__WEBPACK_IMPORTED_MODULE_6__.BaseProgram {\n    register() {\n        commander__WEBPACK_IMPORTED_MODULE_3__.program.addCommand(this.sendCommand());\n        // receive is accessible both at `bw receive` and `bw send receive`\n        commander__WEBPACK_IMPORTED_MODULE_3__.program.addCommand(this.receiveCommand());\n    }\n    sendCommand() {\n        return new commander__WEBPACK_IMPORTED_MODULE_3__.Command(\"send\")\n            .argument(\"<data>\", \"The data to Send. Specify as a filepath with the --file option\")\n            .description(\"Work with Bitwarden sends. A Send can be quickly created using this command or subcommands can be used to fine-tune the Send\")\n            .option(\"-f, --file\", \"Specifies that <data> is a filepath\")\n            .option(\"-d, --deleteInDays <days>\", \"The number of days in the future to set deletion date, defaults to 7\", \"7\")\n            .option(\"-a, --maxAccessCount <amount>\", \"The amount of max possible accesses.\")\n            .option(\"--hidden\", \"Hide <data> in web by default. Valid only if --file is not set.\")\n            .option(\"-n, --name <name>\", \"The name of the Send. Defaults to a guid for text Sends and the filename for files.\")\n            .option(\"--notes <notes>\", \"Notes to add to the Send.\")\n            .option(\"--fullObject\", \"Specifies that the full Send object should be returned rather than just the access url.\")\n            .addCommand(this.listCommand())\n            .addCommand(this.templateCommand())\n            .addCommand(this.getCommand())\n            .addCommand(this.receiveCommand())\n            .addCommand(this.createCommand())\n            .addCommand(this.editCommand())\n            .addCommand(this.removePasswordCommand())\n            .addCommand(this.deleteCommand())\n            .action((data, options) => __awaiter(this, void 0, void 0, function* () {\n            const encodedJson = this.makeSendJson(data, options);\n            let response;\n            if (encodedJson instanceof _models_response__WEBPACK_IMPORTED_MODULE_8__.Response) {\n                response = encodedJson;\n            }\n            else {\n                response = yield this.runCreate(encodedJson, options);\n            }\n            this.processResponse(response);\n        }));\n    }\n    receiveCommand() {\n        return new commander__WEBPACK_IMPORTED_MODULE_3__.Command(\"receive\")\n            .arguments(\"<url>\")\n            .description(\"Access a Bitwarden Send from a url\")\n            .option(\"--password <password>\", \"Password needed to access the Send.\")\n            .option(\"--passwordenv <passwordenv>\", \"Environment variable storing the Send's password\")\n            .option(\"--passwordfile <passwordfile>\", \"Path to a file containing the Sends password as its first line\")\n            .option(\"--obj\", \"Return the Send's json object rather than the Send's content\")\n            .option(\"--output <location>\", \"Specify a file path to save a File-type Send to\")\n            .on(\"--help\", () => {\n            writeLn(\"\");\n            writeLn(\"If a password is required, the provided password is used or the user is prompted.\");\n            writeLn(\"\", true);\n        })\n            .action((url, options) => __awaiter(this, void 0, void 0, function* () {\n            const cmd = new _commands__WEBPACK_IMPORTED_MODULE_10__.SendReceiveCommand(this.serviceContainer.apiService, this.serviceContainer.cryptoService, this.serviceContainer.cryptoFunctionService, this.serviceContainer.platformUtilsService, this.serviceContainer.environmentService, this.serviceContainer.sendApiService);\n            const response = yield cmd.run(url, options);\n            this.processResponse(response);\n        }));\n    }\n    listCommand() {\n        return new commander__WEBPACK_IMPORTED_MODULE_3__.Command(\"list\")\n            .description(\"List all the Sends owned by you\")\n            .on(\"--help\", () => {\n            writeLn(chalk__WEBPACK_IMPORTED_MODULE_2__(\"This is in the list command\"));\n        })\n            .action((options) => __awaiter(this, void 0, void 0, function* () {\n            yield this.exitIfLocked();\n            const cmd = new _commands__WEBPACK_IMPORTED_MODULE_10__.SendListCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService);\n            const response = yield cmd.run(options);\n            this.processResponse(response);\n        }));\n    }\n    templateCommand() {\n        return new commander__WEBPACK_IMPORTED_MODULE_3__.Command(\"template\")\n            .argument(\"<object>\", \"Valid objects are: send.text, send.file\")\n            .description(\"Get json templates for send objects\")\n            .action((object) => __awaiter(this, void 0, void 0, function* () {\n            const cmd = new _commands_get_command__WEBPACK_IMPORTED_MODULE_7__.GetCommand(this.serviceContainer.cipherService, this.serviceContainer.folderService, this.serviceContainer.collectionService, this.serviceContainer.totpService, this.serviceContainer.auditService, this.serviceContainer.cryptoService, this.serviceContainer.stateService, this.serviceContainer.searchService, this.serviceContainer.apiService, this.serviceContainer.organizationService, this.serviceContainer.eventCollectionService, this.serviceContainer.billingAccountProfileStateService);\n            const response = yield cmd.run(\"template\", object, null);\n            this.processResponse(response);\n        }));\n    }\n    getCommand() {\n        return new commander__WEBPACK_IMPORTED_MODULE_3__.Command(\"get\")\n            .arguments(\"<id>\")\n            .description(\"Get Sends owned by you.\")\n            .option(\"--output <output>\", \"Output directory or filename for attachment.\")\n            .option(\"--text\", \"Specifies to return the text content of a Send\")\n            .on(\"--help\", () => {\n            writeLn(\"\");\n            writeLn(\"  Id:\");\n            writeLn(\"\");\n            writeLn(\"    Search term or Send's globally unique `id`.\");\n            writeLn(\"\");\n            writeLn(\"    If raw output is specified and no output filename or directory is given for\");\n            writeLn(\"    an attachment query, the attachment content is written to stdout.\");\n            writeLn(\"\");\n            writeLn(\"  Examples:\");\n            writeLn(\"\");\n            writeLn(\"    bw send get searchText\");\n            writeLn(\"    bw send get id\");\n            writeLn(\"    bw send get searchText --text\");\n            writeLn(\"    bw send get searchText --file\");\n            writeLn(\"    bw send get searchText --file --output ../Photos/photo.jpg\");\n            writeLn(\"    bw send get searchText --file --raw\");\n            writeLn(\"\", true);\n        })\n            .action((id, options) => __awaiter(this, void 0, void 0, function* () {\n            yield this.exitIfLocked();\n            const cmd = new _commands__WEBPACK_IMPORTED_MODULE_10__.SendGetCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService, this.serviceContainer.cryptoService);\n            const response = yield cmd.run(id, options);\n            this.processResponse(response);\n        }));\n    }\n    createCommand() {\n        return new commander__WEBPACK_IMPORTED_MODULE_3__.Command(\"create\")\n            .argument(\"[encodedJson]\", \"JSON object to upload. Can also be piped in through stdin.\")\n            .description(\"create a Send\")\n            .option(\"--file <path>\", \"file to Send. Can also be specified in parent's JSON.\")\n            .option(\"--text <text>\", \"text to Send. Can also be specified in parent's JSON.\")\n            .option(\"--hidden\", \"text hidden flag. Valid only with the --text option.\")\n            .option(\"--password <password>\", \"optional password to access this Send. Can also be specified in JSON\")\n            .on(\"--help\", () => {\n            writeLn(\"\");\n            writeLn(\"Note:\");\n            writeLn(\"  Options specified in JSON take precedence over command options\");\n            writeLn(\"\", true);\n        })\n            .action((encodedJson, options, args) => __awaiter(this, void 0, void 0, function* () {\n            // Work-around to support `--fullObject` option for `send create --fullObject`\n            // Calling `option('--fullObject', ...)` above won't work due to Commander doesn't like same option\n            // to be defind on both parent-command and sub-command\n            const { fullObject = false } = args.parent.opts();\n            const mergedOptions = Object.assign(Object.assign({}, options), { fullObject: fullObject });\n            const response = yield this.runCreate(encodedJson, mergedOptions);\n            this.processResponse(response);\n        }));\n    }\n    editCommand() {\n        return new commander__WEBPACK_IMPORTED_MODULE_3__.Command(\"edit\")\n            .argument(\"[encodedJson]\", \"Updated JSON object to save. If not provided, encodedJson is read from stdin.\")\n            .description(\"edit a Send\")\n            .option(\"--itemid <itemid>\", \"Overrides the itemId provided in [encodedJson]\")\n            .on(\"--help\", () => {\n            writeLn(\"\");\n            writeLn(\"Note:\");\n            writeLn(\"  You cannot update a File-type Send's file. Just delete and remake it\");\n            writeLn(\"\", true);\n        })\n            .action((encodedJson, options) => __awaiter(this, void 0, void 0, function* () {\n            yield this.exitIfLocked();\n            const getCmd = new _commands__WEBPACK_IMPORTED_MODULE_10__.SendGetCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.searchService, this.serviceContainer.cryptoService);\n            const cmd = new _commands__WEBPACK_IMPORTED_MODULE_10__.SendEditCommand(this.serviceContainer.sendService, getCmd, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService);\n            const response = yield cmd.run(encodedJson, options);\n            this.processResponse(response);\n        }));\n    }\n    deleteCommand() {\n        return new commander__WEBPACK_IMPORTED_MODULE_3__.Command(\"delete\")\n            .argument(\"<id>\", \"The id of the Send to delete.\")\n            .description(\"delete a Send\")\n            .action((id) => __awaiter(this, void 0, void 0, function* () {\n            yield this.exitIfLocked();\n            const cmd = new _commands__WEBPACK_IMPORTED_MODULE_10__.SendDeleteCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService);\n            const response = yield cmd.run(id);\n            this.processResponse(response);\n        }));\n    }\n    removePasswordCommand() {\n        return new commander__WEBPACK_IMPORTED_MODULE_3__.Command(\"remove-password\")\n            .argument(\"<id>\", \"The id of the Send to alter.\")\n            .description(\"removes the saved password from a Send.\")\n            .action((id) => __awaiter(this, void 0, void 0, function* () {\n            yield this.exitIfLocked();\n            const cmd = new _commands__WEBPACK_IMPORTED_MODULE_10__.SendRemovePasswordCommand(this.serviceContainer.sendService, this.serviceContainer.sendApiService, this.serviceContainer.environmentService);\n            const response = yield cmd.run(id);\n            this.processResponse(response);\n        }));\n    }\n    makeSendJson(data, options) {\n        var _a;\n        let sendFile = null;\n        let sendText = null;\n        let name = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_4__.Utils.newGuid();\n        let type = _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_5__.SendType.Text;\n        if (options.file != null) {\n            data = path__WEBPACK_IMPORTED_MODULE_1__.resolve(data);\n            if (!fs__WEBPACK_IMPORTED_MODULE_0__.existsSync(data)) {\n                return _models_response__WEBPACK_IMPORTED_MODULE_8__.Response.badRequest(\"data path does not exist\");\n            }\n            sendFile = _models_send_file_response__WEBPACK_IMPORTED_MODULE_11__.SendFileResponse.template(data);\n            name = path__WEBPACK_IMPORTED_MODULE_1__.basename(data);\n            type = _bitwarden_common_tools_send_enums_send_type__WEBPACK_IMPORTED_MODULE_5__.SendType.File;\n        }\n        else {\n            sendText = _models_send_text_response__WEBPACK_IMPORTED_MODULE_12__.SendTextResponse.template(data, options.hidden);\n        }\n        const template = _bitwarden_common_platform_misc_utils__WEBPACK_IMPORTED_MODULE_4__.Utils.assign(_models_send_response__WEBPACK_IMPORTED_MODULE_13__.SendResponse.template(null, options.deleteInDays), {\n            name: (_a = options.name) !== null && _a !== void 0 ? _a : name,\n            notes: options.notes,\n            file: sendFile,\n            text: sendText,\n            type: type,\n        });\n        return Buffer.from(JSON.stringify(template), \"utf8\").toString(\"base64\");\n    }\n    runCreate(encodedJson, options) {\n        return __awaiter(this, void 0, void 0, function* () {\n            yield this.exitIfLocked();\n            const cmd = new _commands__WEBPACK_IMPORTED_MODULE_10__.SendCreateCommand(this.serviceContainer.sendService, this.serviceContainer.environmentService, this.serviceContainer.sendApiService, this.serviceContainer.billingAccountProfileStateService);\n            return yield cmd.run(encodedJson, options);\n        });\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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