/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.SpeedValue;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;

public abstract class SpeedCalculator {
    public static void calculateSpeed(Track track, int n, SpeedValue speedValue) {
        if (speedValue != null) {
            speedValue.setInvalid();
        }
        if (track == null || n < 0 || speedValue == null) {
            System.err.println("Cannot calculate speed for index " + n);
            return;
        }
        DataPoint dataPoint = track.getPoint(n);
        if (dataPoint == null) {
            return;
        }
        boolean bl = false;
        double d = 0.0;
        if (dataPoint.hasHSpeed()) {
            d = dataPoint.getHSpeed().getValue(Config.getUnitSet().getSpeedUnit());
            bl = true;
        }
        if (!bl && dataPoint.hasTimestamp() && !dataPoint.isWaypoint()) {
            boolean bl2;
            Object object;
            double d2 = 0.0;
            int n2 = n - 1;
            Object object2 = dataPoint;
            Timestamp timestamp = dataPoint.getTimestamp();
            boolean bl3 = false;
            if (!dataPoint.getSegmentStart()) {
                do {
                    boolean bl4 = (object = track.getPoint(n2)) != null && ((DataPoint)object).hasTimestamp() && ((DataPoint)object).getTimestamp().isBefore(dataPoint.getTimestamp());
                    boolean bl5 = bl2 = bl4 && !((DataPoint)object).isWaypoint();
                    if (bl2) {
                        d2 += DataPoint.calculateRadiansBetween((DataPoint)object, (DataPoint)object2);
                        timestamp = ((DataPoint)object).getTimestamp();
                    }
                    bl3 = object == null || ((DataPoint)object).getSegmentStart() || SpeedCalculator.hasSufficientTimeDifference((DataPoint)object, dataPoint);
                    --n2;
                    if (object == null || ((DataPoint)object).isWaypoint()) continue;
                    object2 = object;
                } while (!bl3);
            }
            object = dataPoint.getTimestamp();
            object2 = dataPoint;
            n2 = n + 1;
            do {
                boolean bl6;
                DataPoint dataPoint2;
                bl2 = (dataPoint2 = track.getPoint(n2)) != null && dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isBefore(dataPoint.getTimestamp());
                boolean bl7 = bl6 = bl2 && !dataPoint2.isWaypoint() && !dataPoint2.getSegmentStart();
                if (bl6) {
                    d2 += DataPoint.calculateRadiansBetween(dataPoint2, (DataPoint)object2);
                    object = dataPoint2.getTimestamp();
                }
                bl3 = dataPoint2 == null || dataPoint2.getSegmentStart() || SpeedCalculator.hasSufficientTimeDifference(dataPoint, dataPoint2);
                ++n2;
                if (dataPoint2 == null || dataPoint2.isWaypoint()) continue;
                object2 = dataPoint2;
            } while (!bl3);
            long l = ((Timestamp)object).getMillisecondsSince(timestamp);
            if (l >= 1000L) {
                double d3 = Distance.convertRadiansToDistance(d2);
                d = d3 / (double)l * 1000.0 * 60.0 * 60.0;
                bl = true;
            }
        }
        if (bl) {
            speedValue.setValue(d);
        }
    }

    public static void calculateVerticalSpeed(Track track, int n, SpeedValue speedValue) {
        if (track == null || n < 0 || speedValue == null) {
            System.err.println("Cannot calculate vert speed for index " + n);
            return;
        }
        speedValue.setInvalid();
        DataPoint dataPoint = track.getPoint(n);
        boolean bl = false;
        double d = 0.0;
        if (dataPoint != null && dataPoint.hasVSpeed()) {
            d = dataPoint.getVSpeed().getValue(Config.getUnitSet().getVerticalSpeedUnit());
            bl = true;
        }
        if (!bl && dataPoint != null && dataPoint.hasTimestamp() && dataPoint.hasAltitude() && !dataPoint.isWaypoint()) {
            Object object;
            int n2 = n - 1;
            Timestamp timestamp = dataPoint.getTimestamp();
            Altitude altitude = dataPoint.getAltitude();
            boolean bl2 = false;
            if (!dataPoint.getSegmentStart()) {
                do {
                    boolean bl3;
                    boolean bl4 = (object = track.getPoint(n2)) != null && ((DataPoint)object).hasTimestamp() && ((DataPoint)object).getTimestamp().isBefore(dataPoint.getTimestamp());
                    boolean bl5 = bl3 = bl4 && !((DataPoint)object).isWaypoint();
                    if (bl3) {
                        timestamp = ((DataPoint)object).getTimestamp();
                        if (((DataPoint)object).hasAltitude()) {
                            altitude = ((DataPoint)object).getAltitude();
                        }
                    }
                    bl2 = object == null || ((DataPoint)object).getSegmentStart() || SpeedCalculator.hasSufficientTimeDifference((DataPoint)object, dataPoint);
                    --n2;
                } while (!bl2);
            }
            object = dataPoint.getTimestamp();
            Altitude altitude2 = dataPoint.getAltitude();
            n2 = n + 1;
            do {
                boolean bl6;
                DataPoint dataPoint2;
                boolean bl7 = (dataPoint2 = track.getPoint(n2)) != null && dataPoint2.hasTimestamp() && !dataPoint2.getTimestamp().isBefore(dataPoint.getTimestamp());
                boolean bl8 = bl6 = bl7 && !dataPoint2.isWaypoint() && !dataPoint2.getSegmentStart();
                if (bl6) {
                    object = dataPoint2.getTimestamp();
                    if (dataPoint2.hasAltitude()) {
                        altitude2 = dataPoint2.getAltitude();
                    }
                }
                bl2 = dataPoint2 == null || dataPoint2.getSegmentStart() || SpeedCalculator.hasSufficientTimeDifference(dataPoint, dataPoint2);
                ++n2;
            } while (!bl2);
            long l = ((Timestamp)object).getMillisecondsSince(timestamp);
            if (l >= 1000L) {
                double d2 = (altitude2.getMetricValue() - altitude.getMetricValue()) * Config.getUnitSet().getVerticalSpeedUnit().getMultFactorFromStd();
                d = d2 / (double)l * 1000.0;
                bl = true;
            }
        }
        if (bl) {
            speedValue.setValue(d);
        }
    }

    private static boolean hasSufficientTimeDifference(DataPoint dataPoint, DataPoint dataPoint2) {
        if (dataPoint == null || dataPoint2 == null) {
            return true;
        }
        if (!dataPoint.hasTimestamp() || !dataPoint2.hasTimestamp()) {
            return false;
        }
        return dataPoint2.getTimestamp().getMillisecondsSince(dataPoint.getTimestamp()) >= 1000L;
    }
}

