/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.lifetime;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.lifetime.KtAlwaysAccessibleLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactoryKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/lifetime/KtAlwaysAccessibleLifetimeToken;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "onCreatedTimeStamp", "", "isValid", "", "getInvalidationReason", "", "isAccessible", "getInaccessibilityReason", "factory", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "getFactory", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "analysis-api"})
public final class KtAlwaysAccessibleLifetimeToken
extends KtLifetimeToken {
    @NotNull
    private final ModificationTracker modificationTracker;
    private final long onCreatedTimeStamp;
    @NotNull
    private final KtLifetimeTokenFactory factory;

    public KtAlwaysAccessibleLifetimeToken(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.modificationTracker = KotlinModificationTrackerFactoryKt.createProjectWideOutOfBlockModificationTracker((Project)project);
        this.onCreatedTimeStamp = this.modificationTracker.getModificationCount();
        this.factory = KtAlwaysAccessibleLifetimeTokenFactory.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.onCreatedTimeStamp == this.modificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public String getInvalidationReason() {
        if (this.onCreatedTimeStamp != this.modificationTracker.getModificationCount()) {
            return "PSI has changed since creation";
        }
        throw new IllegalStateException("Getting invalidation reason for valid validity token".toString());
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    @NotNull
    public String getInaccessibilityReason() {
        throw new IllegalStateException("Getting inaccessibility reason for validity token when it is accessible".toString());
    }

    @Override
    @NotNull
    public KtLifetimeTokenFactory getFactory() {
        return this.factory;
    }
}

