/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.LastComputedIconCache;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.CoreAwareIconManager;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PsiIconUtil;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance(ElementBase.class);
    public static final int FLAGS_LOCKED = 2048;
    private static final Function<ElementIconRequest, Icon> ICON_COMPUTE = request -> {
        Object element = ((ElementIconRequest)request).myPointer.getElement();
        if (element == null) {
            return null;
        }
        Icon icon = ElementBase.computeIconNow(element, ((ElementIconRequest)request).myFlags);
        LastComputedIconCache.put(element, icon, ((ElementIconRequest)request).myFlags);
        return icon;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = NotNullLazyValue.createValue(() -> IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON));

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(int flags) {
        PsiElement psiElement = (PsiElement)((Object)this);
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is("psi.deferIconLoading", true)) {
            Icon baseIcon = LastComputedIconCache.get(psiElement, flags);
            if (baseIcon == null) {
                baseIcon = AstLoadingFilter.disallowTreeLoading(() -> this.computeBaseIcon(flags));
            }
            return baseIcon == null ? null : IconManager.getInstance().createDeferredIcon(baseIcon, new ElementIconRequest(psiElement, psiElement.getProject(), flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element, int flags) {
        if (element == null) {
            ElementBase.$$$reportNull$$$0(0);
        }
        return AstLoadingFilter.disallowTreeLoading(() -> ElementBase.doComputeIconNow(element, flags));
    }

    private static Icon doComputeIconNow(@NotNull PsiElement element, int flags) {
        Icon providersIcon;
        if (element == null) {
            ElementBase.$$$reportNull$$$0(1);
        }
        if ((providersIcon = PsiIconUtil.getProvidersIcon(element, flags)) != null) {
            if (providersIcon instanceof RowIcon) {
                return providersIcon;
            }
            return IconManager.getInstance().createLayeredIcon(element, providersIcon, flags);
        }
        return ((ElementBase)((Object)element)).getElementIcon(flags);
    }

    protected Icon computeBaseIcon(int flags) {
        PsiFile file2;
        Icon baseIcon;
        Icon icon = baseIcon = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
        if (this instanceof PsiElement && (file2 = ((PsiElement)((Object)this)).getContainingFile()) != null) {
            return IconManager.getInstance().createLayeredIcon(file2, baseIcon, flags);
        }
        return baseIcon;
    }

    protected Icon getBaseIcon() {
        PsiFile file2;
        if (this instanceof PsiElement && (file2 = ((PsiElement)((Object)this)).getContainingFile()) != null && !ElementBase.isNativeFileType(file2.getFileType())) {
            try {
                return file2.getFileType().getIcon();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return AllIcons.Nodes.NodePlaceholder;
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(Icon icon, int flags) {
        if (BitUtil.isSet(flags, 1)) {
            return IconManager.getInstance().createRowIcon(icon, VISIBILITY_ICON_PLACEHOLDER.getValue());
        }
        return icon;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = IconManager.getInstance().createRowIcon(baseIcon, visibilityIcon);
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(2);
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet(flags, 1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(int flags) {
        Icon baseIcon;
        int elementFlags;
        PsiElement element = (PsiElement)((Object)this);
        if (!element.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(flags, 2) && !element.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (element instanceof ItemPresentation && (baseIcon = ((ItemPresentation)((Object)element)).getIcon(false)) != null) {
            return IconManager.getInstance().createLayeredIcon(this, baseIcon, elementFlags);
        }
        if (element instanceof PsiFile) {
            Icon baseIcon2;
            PsiFile psiFile = (PsiFile)element;
            VirtualFile vFile = psiFile.getVirtualFile();
            if (vFile == null) {
                baseIcon2 = psiFile.getFileType().getIcon();
            } else {
                IconManager iconManager = IconManager.getInstance();
                if (iconManager instanceof CoreAwareIconManager) {
                    baseIcon2 = ((CoreAwareIconManager)((Object)iconManager)).getIcon(vFile, flags & 0xFFFFFFFD, psiFile.getProject());
                } else {
                    return null;
                }
            }
            return IconManager.getInstance().createLayeredIcon(this, baseIcon2, elementFlags);
        }
        return null;
    }

    public static int transformFlags(PsiElement element, int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear(_flags, 2);
        boolean bl = isLocked = BitUtil.isSet(_flags, 2) && !element.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/ElementBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/ElementBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRowIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeIconNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconNow";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element, @NotNull Project project, int flags) {
            if (element == null) {
                ElementIconRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ElementIconRequest.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(element);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer.equals(request.myPointer);
        }

        public int hashCode() {
            int result2 = this.myPointer.hashCode();
            result2 = 31 * result2 + this.myFlags;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/ElementBase$ElementIconRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

