/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.library.metadata.DeserializedSourceFile;
import org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializedPackageFragment;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.library.metadata.KlibModuleOriginKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassConstructorDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0007\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\n\u0010\r\u001a\u00020\b*\u00020\n\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\u00a8\u0006\u0010"}, d2={"isExpectMember", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isSerializableExpectClass", "findPackage", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "sourceByIndex", "Lorg/jetbrains/kotlin/descriptors/SourceFile;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "index", "", "findSourceFile", "extractSerializedKdocString", "", "ir.serialization.common"})
public final class LegacyDescriptorUtilsKt {
    public static final boolean isExpectMember(@NotNull DeclarationDescriptor $this$isExpectMember) {
        Intrinsics.checkNotNullParameter($this$isExpectMember, "<this>");
        return $this$isExpectMember instanceof MemberDescriptor && ((MemberDescriptor)$this$isExpectMember).isExpect();
    }

    public static final boolean isSerializableExpectClass(@NotNull DeclarationDescriptor $this$isSerializableExpectClass) {
        Intrinsics.checkNotNullParameter($this$isSerializableExpectClass, "<this>");
        return $this$isSerializableExpectClass instanceof ClassDescriptor && OptionalAnnotationUtil.shouldGenerateExpectClass((ClassDescriptor)$this$isSerializableExpectClass);
    }

    @Deprecated(message="Moved to the ':core:descriptors' module", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ PackageFragmentDescriptor findPackage(DeclarationDescriptor $this$findPackage) {
        Intrinsics.checkNotNullParameter($this$findPackage, "<this>");
        return DescriptorUtilKt.findPackage($this$findPackage);
    }

    private static final SourceFile sourceByIndex(CallableMemberDescriptor descriptor, int index) {
        PackageFragmentDescriptor packageFragmentDescriptor = DescriptorUtilKt.findPackage(descriptor);
        Intrinsics.checkNotNull(packageFragmentDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.library.metadata.KlibMetadataDeserializedPackageFragment");
        KlibMetadataDeserializedPackageFragment fragment = (KlibMetadataDeserializedPackageFragment)packageFragmentDescriptor;
        String fileName = (String)fragment.getProto().getStrings().getStringList().get(index);
        Intrinsics.checkNotNull(fileName);
        return new DeserializedSourceFile(fileName, KlibModuleOriginKt.getKotlinLibrary(DescriptorUtilsKt.getModule(descriptor)));
    }

    @NotNull
    public static final SourceFile findSourceFile(@NotNull CallableMemberDescriptor $this$findSourceFile) {
        SourceFile sourceFile;
        Intrinsics.checkNotNullParameter($this$findSourceFile, "<this>");
        SourceFile sourceFile2 = $this$findSourceFile.getSource().getContainingFile();
        Intrinsics.checkNotNullExpressionValue(sourceFile2, "getContainingFile(...)");
        SourceFile source = sourceFile2;
        if (!Intrinsics.areEqual(source, SourceFile.NO_SOURCE_FILE)) {
            return source;
        }
        if ($this$findSourceFile instanceof DeserializedSimpleFunctionDescriptor && ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.functionFile)) {
            Integer n = ((DeserializedSimpleFunctionDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.functionFile);
            Intrinsics.checkNotNullExpressionValue(n, "getExtension(...)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)n).intValue());
        } else if ($this$findSourceFile instanceof DeserializedPropertyDescriptor && ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().hasExtension(KlibMetadataProtoBuf.propertyFile)) {
            Integer n = ((DeserializedPropertyDescriptor)$this$findSourceFile).getProto().getExtension(KlibMetadataProtoBuf.propertyFile);
            Intrinsics.checkNotNullExpressionValue(n, "getExtension(...)");
            sourceFile = LegacyDescriptorUtilsKt.sourceByIndex($this$findSourceFile, ((Number)n).intValue());
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return sourceFile;
    }

    @Nullable
    public static final String extractSerializedKdocString(@NotNull DeclarationDescriptor $this$extractSerializedKdocString) {
        Intrinsics.checkNotNullParameter($this$extractSerializedKdocString, "<this>");
        DeclarationDescriptor declarationDescriptor = $this$extractSerializedKdocString;
        return declarationDescriptor instanceof DeserializedClassDescriptor ? ((DeserializedClassDescriptor)$this$extractSerializedKdocString).getClassProto().getExtension(KlibMetadataProtoBuf.classKdoc) : (declarationDescriptor instanceof DeserializedSimpleFunctionDescriptor ? ((DeserializedSimpleFunctionDescriptor)$this$extractSerializedKdocString).getProto().getExtension(KlibMetadataProtoBuf.functionKdoc) : (declarationDescriptor instanceof DeserializedPropertyDescriptor ? ((DeserializedPropertyDescriptor)$this$extractSerializedKdocString).getProto().getExtension(KlibMetadataProtoBuf.propertyKdoc) : (declarationDescriptor instanceof DeserializedClassConstructorDescriptor ? ((DeserializedClassConstructorDescriptor)$this$extractSerializedKdocString).getProto().getExtension(KlibMetadataProtoBuf.constructorKdoc) : null)));
    }
}

