/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.backend.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.generators.FirBasedFakeOverrideGenerator;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0001\u001a\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"generateOverriddenAccessorSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "containingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "isGetter", "", "c", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "generateOverriddenPropertySymbols", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "generateOverriddenFunctionSymbols", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "getSuperTypesAsIrClasses", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFakeOverrideGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeOverrideGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGeneratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,746:1\n1611#2,9:747\n1863#2:756\n1864#2:758\n1620#2:759\n1#3:757\n1#3:760\n*S KotlinDebug\n*F\n+ 1 FakeOverrideGenerator.kt\norg/jetbrains/kotlin/fir/backend/generators/FakeOverrideGeneratorKt\n*L\n744#1:747,9\n744#1:756\n744#1:758\n744#1:759\n744#1:757\n*E\n"})
public final class FakeOverrideGeneratorKt {
    @FirBasedFakeOverrideGenerator
    @NotNull
    public static final List<IrSimpleFunctionSymbol> generateOverriddenAccessorSymbols(@NotNull FirProperty $this$generateOverriddenAccessorSymbols, @NotNull FirClass containingClass, boolean isGetter, @NotNull Fir2IrComponents c) {
        Intrinsics.checkNotNullParameter($this$generateOverriddenAccessorSymbols, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(c, "c");
        FirTypeScope scope2 = ConversionUtilsKt.unsubstitutedScope(containingClass, c);
        scope2.processPropertiesByName($this$generateOverriddenAccessorSymbols.getName(), FakeOverrideGeneratorKt::generateOverriddenAccessorSymbols$lambda$0);
        Set overriddenSet = new LinkedHashSet();
        Set<IrClass> superClasses = FakeOverrideGeneratorKt.getSuperTypesAsIrClasses(containingClass, c);
        ConversionUtilsKt.processOverriddenPropertiesFromSuperClasses(scope2, $this$generateOverriddenAccessorSymbols.getSymbol(), containingClass, arg_0 -> FakeOverrideGeneratorKt.generateOverriddenAccessorSymbols$lambda$2(c, $this$generateOverriddenAccessorSymbols, superClasses, isGetter, overriddenSet, arg_0));
        return CollectionsKt.toList(overriddenSet);
    }

    @FirBasedFakeOverrideGenerator
    @NotNull
    public static final List<IrPropertySymbol> generateOverriddenPropertySymbols(@NotNull FirProperty $this$generateOverriddenPropertySymbols, @NotNull FirClass containingClass, @NotNull Fir2IrComponents c) {
        Intrinsics.checkNotNullParameter($this$generateOverriddenPropertySymbols, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(c, "c");
        Set<IrClass> superClasses = FakeOverrideGeneratorKt.getSuperTypesAsIrClasses(containingClass, c);
        Set overriddenSet = new LinkedHashSet();
        ConversionUtilsKt.processOverriddenPropertySymbols($this$generateOverriddenPropertySymbols, containingClass, c, arg_0 -> FakeOverrideGeneratorKt.generateOverriddenPropertySymbols$lambda$4(c, superClasses, $this$generateOverriddenPropertySymbols, overriddenSet, arg_0));
        return CollectionsKt.toList(overriddenSet);
    }

    @FirBasedFakeOverrideGenerator
    @NotNull
    public static final List<IrSimpleFunctionSymbol> generateOverriddenFunctionSymbols(@NotNull FirSimpleFunction $this$generateOverriddenFunctionSymbols, @NotNull FirClass containingClass, @NotNull Fir2IrComponents c) {
        Intrinsics.checkNotNullParameter($this$generateOverriddenFunctionSymbols, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(c, "c");
        Set<IrClass> superClasses = FakeOverrideGeneratorKt.getSuperTypesAsIrClasses(containingClass, c);
        Set overriddenSet = new LinkedHashSet();
        ConversionUtilsKt.processOverriddenFunctionSymbols($this$generateOverriddenFunctionSymbols, containingClass, c, arg_0 -> FakeOverrideGeneratorKt.generateOverriddenFunctionSymbols$lambda$6(c, superClasses, $this$generateOverriddenFunctionSymbols, overriddenSet, arg_0));
        return CollectionsKt.toList(overriddenSet);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<IrClass> getSuperTypesAsIrClasses(FirClass $this$getSuperTypesAsIrClasses, Fir2IrComponents c) {
        void $this$mapNotNullTo$iv$iv;
        IrClass irClass = (IrClass)c.getDeclarationStorage().getClassifierStorage().getIrClassSymbol($this$getSuperTypesAsIrClasses.getSymbol()).getOwner();
        Iterable $this$mapNotNull$iv = irClass.getSuperTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrClass it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrType it = (IrType)element$iv$iv;
            boolean bl2 = false;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(it);
            IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
            if ((irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private static final Unit generateOverriddenAccessorSymbols$lambda$0(FirVariableSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final ProcessorAction generateOverriddenAccessorSymbols$lambda$2(Fir2IrComponents $c, FirProperty $this_generateOverriddenAccessorSymbols, Set $superClasses, boolean $isGetter, Set $overriddenSet, FirPropertySymbol overriddenSymbol) {
        Intrinsics.checkNotNullParameter($c, "$c");
        Intrinsics.checkNotNullParameter($this_generateOverriddenAccessorSymbols, "$this_generateOverriddenAccessorSymbols");
        Intrinsics.checkNotNullParameter($superClasses, "$superClasses");
        Intrinsics.checkNotNullParameter($overriddenSet, "$overriddenSet");
        Intrinsics.checkNotNullParameter(overriddenSymbol, "overriddenSymbol");
        if (!FirVisibilityCheckerKt.getVisibilityChecker($c.getSession()).isVisibleForOverriding((FirCallableDeclaration)$this_generateOverriddenAccessorSymbols.getSymbol().getFir(), (FirCallableDeclaration)overriddenSymbol.getFir())) {
            return ProcessorAction.NEXT;
        }
        for (IrPropertySymbol overriddenIrPropertySymbol : $c.getFakeOverrideGenerator().getOverriddenSymbolsInSupertypes$fir2ir(overriddenSymbol, (Set<? extends IrClass>)$superClasses)) {
            boolean bl;
            IrSimpleFunctionSymbol overriddenIrAccessorSymbol = $isGetter ? $c.getDeclarationStorage().findGetterOfProperty(overriddenIrPropertySymbol) : $c.getDeclarationStorage().findSetterOfProperty(overriddenIrPropertySymbol);
            if (overriddenIrAccessorSymbol == null) continue;
            boolean bl2 = bl = !Intrinsics.areEqual(overriddenIrAccessorSymbol, $this_generateOverriddenAccessorSymbols.getSymbol());
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Cannot add property " + overriddenIrAccessorSymbol + " to its own overriddenSymbols";
                throw new AssertionError((Object)string2);
            }
            ((Collection)$overriddenSet).add(overriddenIrAccessorSymbol);
        }
        return ProcessorAction.NEXT;
    }

    private static final Unit generateOverriddenPropertySymbols$lambda$4(Fir2IrComponents $c, Set $superClasses, FirProperty $this_generateOverriddenPropertySymbols, Set $overriddenSet, FirPropertySymbol it) {
        Intrinsics.checkNotNullParameter($c, "$c");
        Intrinsics.checkNotNullParameter($superClasses, "$superClasses");
        Intrinsics.checkNotNullParameter($this_generateOverriddenPropertySymbols, "$this_generateOverriddenPropertySymbols");
        Intrinsics.checkNotNullParameter($overriddenSet, "$overriddenSet");
        Intrinsics.checkNotNullParameter(it, "it");
        for (IrPropertySymbol overridden : $c.getFakeOverrideGenerator().getOverriddenSymbolsInSupertypes$fir2ir(it, (Set<? extends IrClass>)$superClasses)) {
            boolean bl;
            boolean bl2 = bl = !Intrinsics.areEqual(overridden, $this_generateOverriddenPropertySymbols.getSymbol());
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Cannot add property " + overridden + " to its own overriddenSymbols";
                throw new AssertionError((Object)string2);
            }
            ((Collection)$overriddenSet).add(overridden);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateOverriddenFunctionSymbols$lambda$6(Fir2IrComponents $c, Set $superClasses, FirSimpleFunction $this_generateOverriddenFunctionSymbols, Set $overriddenSet, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter($c, "$c");
        Intrinsics.checkNotNullParameter($superClasses, "$superClasses");
        Intrinsics.checkNotNullParameter($this_generateOverriddenFunctionSymbols, "$this_generateOverriddenFunctionSymbols");
        Intrinsics.checkNotNullParameter($overriddenSet, "$overriddenSet");
        Intrinsics.checkNotNullParameter(it, "it");
        for (IrSimpleFunctionSymbol overridden : $c.getFakeOverrideGenerator().getOverriddenSymbolsInSupertypes$fir2ir(it, (Set<? extends IrClass>)$superClasses)) {
            boolean bl;
            boolean bl2 = bl = !Intrinsics.areEqual(overridden, $this_generateOverriddenFunctionSymbols.getSymbol());
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Cannot add function " + overridden + " to its own overriddenSymbols";
                throw new AssertionError((Object)string2);
            }
            ((Collection)$overriddenSet).add(overridden);
        }
        return Unit.INSTANCE;
    }
}

