/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/NotFixedTypeToVariableSubstitutorForDelegateInference;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "bindings", "", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;)V", "getBindings", "()Ljava/util/Map;", "substituteType", "type", "toString", "", "providers"})
public final class NotFixedTypeToVariableSubstitutorForDelegateInference
extends AbstractConeSubstitutor {
    @NotNull
    private final Map<TypeVariableMarker, ConeKotlinType> bindings;

    public NotFixedTypeToVariableSubstitutorForDelegateInference(@NotNull Map<TypeVariableMarker, ? extends ConeKotlinType> bindings, @NotNull ConeTypeContext typeContext2) {
        Intrinsics.checkNotNullParameter(bindings, "bindings");
        Intrinsics.checkNotNullParameter(typeContext2, "typeContext");
        super(typeContext2);
        this.bindings = bindings;
    }

    @NotNull
    public final Map<TypeVariableMarker, ConeKotlinType> getBindings() {
        return this.bindings;
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!(type2 instanceof ConeStubType)) {
            return null;
        }
        if (((ConeStubType)type2).getConstructor().isTypeVariableInSubtyping()) {
            return null;
        }
        return this.updateNullabilityIfNeeded(this.bindings.get(((ConeStubType)type2).getConstructor().getVariable()), type2);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(this.bindings.entrySet(), " | ", "{", "}", 0, null, NotFixedTypeToVariableSubstitutorForDelegateInference::toString$lambda$0, 24, null);
    }

    private static final CharSequence toString$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "<destruct>");
        TypeVariableMarker variable = (TypeVariableMarker)entry.getKey();
        ConeKotlinType type2 = (ConeKotlinType)entry.getValue();
        if (!(variable instanceof ConeTypeVariable)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return "TV(" + ((ConeTypeVariable)variable).getTypeConstructor().getDebugName() + ") -> " + ConeTypeUtilsKt.renderForDebugging(type2);
    }
}

