# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
AppDef module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_appdef.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _AppDef
else:
    import _AppDef

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _AppDef.delete_SwigPyIterator

    def value(self):
        return _AppDef.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _AppDef.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _AppDef.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _AppDef.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _AppDef.SwigPyIterator_equal(self, x)

    def copy(self):
        return _AppDef.SwigPyIterator_copy(self)

    def next(self):
        return _AppDef.SwigPyIterator_next(self)

    def __next__(self):
        return _AppDef.SwigPyIterator___next__(self)

    def previous(self):
        return _AppDef.SwigPyIterator_previous(self)

    def advance(self, n):
        return _AppDef.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _AppDef.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _AppDef.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _AppDef.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _AppDef.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _AppDef.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _AppDef.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _AppDef:
_AppDef.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _AppDef.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.math
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.gp
import OCC.Core.AppParCurves
import OCC.Core.TColgp
import OCC.Core.Approx
import OCC.Core.Adaptor3d
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.AppCont
import OCC.Core.FEmTool
import OCC.Core.PLib

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_AppDef_SmoothCriterion_Create():
    return _AppDef.Handle_AppDef_SmoothCriterion_Create()

def Handle_AppDef_SmoothCriterion_DownCast(t):
    return _AppDef.Handle_AppDef_SmoothCriterion_DownCast(t)

def Handle_AppDef_SmoothCriterion_IsNull(t):
    return _AppDef.Handle_AppDef_SmoothCriterion_IsNull(t)

def Handle_AppDef_LinearCriteria_Create():
    return _AppDef.Handle_AppDef_LinearCriteria_Create()

def Handle_AppDef_LinearCriteria_DownCast(t):
    return _AppDef.Handle_AppDef_LinearCriteria_DownCast(t)

def Handle_AppDef_LinearCriteria_IsNull(t):
    return _AppDef.Handle_AppDef_LinearCriteria_IsNull(t)

def Handle_AppDef_HArray1OfMultiPointConstraint_Create():
    return _AppDef.Handle_AppDef_HArray1OfMultiPointConstraint_Create()

def Handle_AppDef_HArray1OfMultiPointConstraint_DownCast(t):
    return _AppDef.Handle_AppDef_HArray1OfMultiPointConstraint_DownCast(t)

def Handle_AppDef_HArray1OfMultiPointConstraint_IsNull(t):
    return _AppDef.Handle_AppDef_HArray1OfMultiPointConstraint_IsNull(t)
class AppDef_Array1OfMultiPointConstraint(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_begin(self)

    def end(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_end(self)

    def cbegin(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_cbegin(self)

    def cend(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_cend(self)

    def __init__(self, *args):
        _AppDef.AppDef_Array1OfMultiPointConstraint_swiginit(self, _AppDef.new_AppDef_Array1OfMultiPointConstraint(*args))

    def Init(self, theValue):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Init(self, theValue)

    def Size(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Size(self)

    def Length(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Length(self)

    def IsEmpty(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_IsEmpty(self)

    def Lower(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Lower(self)

    def Upper(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Upper(self)

    def IsDeletable(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_IsDeletable(self)

    def IsAllocated(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_IsAllocated(self)

    def Assign(self, theOther):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Assign(self, theOther)

    def Move(self, theOther):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Move(self, theOther)

    def Set(self, *args):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Set(self, *args)

    def First(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_First(self)

    def ChangeFirst(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_ChangeFirst(self)

    def Last(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Last(self)

    def ChangeLast(self):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_ChangeLast(self)

    def Value(self, theIndex):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _AppDef.AppDef_Array1OfMultiPointConstraint___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_SetValue(self, theIndex, theItem)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _AppDef.AppDef_Array1OfMultiPointConstraint_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _AppDef.delete_AppDef_Array1OfMultiPointConstraint

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register AppDef_Array1OfMultiPointConstraint in _AppDef:
_AppDef.AppDef_Array1OfMultiPointConstraint_swigregister(AppDef_Array1OfMultiPointConstraint)
class AppDef_BSpGradient_BFGSOfMyBSplGradientOfBSplineCompute(OCC.Core.math.math_BFGS):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        F: math_MultipleVarFunctionWithGradient
        StartingPoint: math_Vector
        Tolerance3d: float
        Tolerance2d: float
        Eps: float
        NbIterations: int (optional, default to 200)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _AppDef.AppDef_BSpGradient_BFGSOfMyBSplGradientOfBSplineCompute_swiginit(self, _AppDef.new_AppDef_BSpGradient_BFGSOfMyBSplGradientOfBSplineCompute(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_BSpGradient_BFGSOfMyBSplGradientOfBSplineCompute

# Register AppDef_BSpGradient_BFGSOfMyBSplGradientOfBSplineCompute in _AppDef:
_AppDef.AppDef_BSpGradient_BFGSOfMyBSplGradientOfBSplineCompute_swigregister(AppDef_BSpGradient_BFGSOfMyBSplGradientOfBSplineCompute)
class AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute(OCC.Core.math.math_MultipleVarFunctionWithGradient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the function. the approximating curve has <nbpol> control points.

        """
        _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_swiginit(self, _AppDef.new_AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute(*args))

    def CurveValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns the multibspcurve approximating the set after computing the value f or grad(f).

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_CurveValue(self, *args)

    def DerivativeFunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative function matrix used to approximate the multiline.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_DerivativeFunctionMatrix(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        IPoint: int
        CurveIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the distance between the multipoint of range ipoint and the curve curveindex.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_Error(self, *args)

    def FirstConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        FirstPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_FirstConstraint(self, *args)

    def FunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the function matrix used to approximate the multiline.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_FunctionMatrix(self, *args)

    def Index(self, *args):
        r"""
        Return
        -------
        math_IntegerVector

        Description
        -----------
        Returns the indexes of the first non null values of a and da. the values are non null from index(ieme point) +1 to index(ieme point) + degree +1.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_Index(self, *args)

    def LastConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        LastPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_LastConstraint(self, *args)

    def MaxError2d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multibspcurve.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_MaxError2d(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multibspcurve.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_MaxError3d(self, *args)

    def NewParameters(self, *args):
        r"""
        Return
        -------
        math_Vector

        Description
        -----------
        Returns the new parameters of the multiline.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_NewParameters(self, *args)

    def SetFirstLambda(self, *args):
        r"""

        Parameters
        ----------
        l1: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_SetFirstLambda(self, *args)

    def SetLastLambda(self, *args):
        r"""

        Parameters
        ----------
        l2: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_SetLastLambda(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute

# Register AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute in _AppDef:
_AppDef.AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute_swigregister(AppDef_BSpParFunctionOfMyBSplGradientOfBSplineCompute)
class AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. nbpol is the number of control points wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bernstein matrix computed with the parameters, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. deg is the degree wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bspline functions matrix computed with <parameters>, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        """
        _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_swiginit(self, _AppDef.new_AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute(*args))

    def BSplineValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_BSplineValue(self, *args)

    def BezierValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_BezierValue(self, *args)

    def DerivativeFunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative function matrix used to approximate the set.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_DerivativeFunctionMatrix(self, *args)

    def Distance(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the distances between the points of the multiline and the approximation curves.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_Distance(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_Error(self, *args)

    def ErrorGradient(self, *args):
        r"""

        Parameters
        ----------
        Grad: math_Vector

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances. grad is the derivative vector of the function f.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_ErrorGradient(self, *args)

    def FirstLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (p2 - p1)/ v1 if the first point was a tangency point.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_FirstLambda(self, *args)

    def FunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the function matrix used to approximate the set.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_FunctionMatrix(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_IsDone(self, *args)

    def KIndex(self, *args):
        r"""
        Return
        -------
        math_IntegerVector

        Description
        -----------
        Returns the indexes of the first non null values of a and da. the values are non null from index(ieme point) +1 to index(ieme point) + degree +1.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_KIndex(self, *args)

    def LastLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (pn - pn-1)/ vn if the last point was a tangency point.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_LastLambda(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Parameters: math_Vector

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. the case 'curvaturepoint' is not treated in this method.

        Parameters
        ----------
        Parameters: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        V1c: math_Vector
        V2c: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point. <v1c> is the tangent vector at the first point. <v2c> is the tangent vector at the last point.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_Perform(self, *args)

    def Points(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of points value.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_Points(self, *args)

    def Poles(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of resulting control points value.

        """
        return _AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute

# Register AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute in _AppDef:
_AppDef.AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute_swigregister(AppDef_BSpParLeastSquareOfMyBSplGradientOfBSplineCompute)
class AppDef_BSplineCompute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Line: AppDef_MultiLine
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-3)
        Tolerance2d: float (optional, default to 1.0e-6)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        parametrization: Approx_ParametrizationType (optional, default to Approx_ChordLength)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        The multiline <line> will be approximated until tolerances will be reached. the approximation will be done from degreemin to degreemax with a cutting if the corresponding boolean is true. if <squares> is true, the computation will be done with no iteration at all. //! the multiplicities of the internal knots is set by default.

        Parameters
        ----------
        Line: AppDef_MultiLine
        Parameters: math_Vector
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-03)
        Tolerance2d: float (optional, default to 1.0e-06)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        The multiline <line> will be approximated until tolerances will be reached. the approximation will be done from degreemin to degreemax with a cutting if the corresponding boolean is true. if <squares> is true, the computation will be done with no iteration at all.

        Parameters
        ----------
        Parameters: math_Vector
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-03)
        Tolerance2d: float (optional, default to 1.0e-06)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the algorithm.

        Parameters
        ----------
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-03)
        Tolerance2d: float (optional, default to 1.0e-06)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        parametrization: Approx_ParametrizationType (optional, default to Approx_ChordLength)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the algorithm.

        """
        _AppDef.AppDef_BSplineCompute_swiginit(self, _AppDef.new_AppDef_BSplineCompute(*args))

    def ChangeValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns the result of the approximation.

        """
        return _AppDef.AppDef_BSplineCompute_ChangeValue(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        tol3d: float
        tol2d: float

        Description
        -----------
        Returns the tolerances 2d and 3d of the multibspcurve.

        """
        return _AppDef.AppDef_BSplineCompute_Error(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-03)
        Tolerance2d: float (optional, default to 1.0e-06)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        parametrization: Approx_ParametrizationType (optional, default to Approx_ChordLength)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the algorithm.

        """
        return _AppDef.AppDef_BSplineCompute_Init(self, *args)

    def Interpol(self, *args):
        r"""

        Parameters
        ----------
        Line: AppDef_MultiLine

        Return
        -------
        None

        Description
        -----------
        Constructs an interpolation of the multiline <line> the result will be a c2 curve of degree 3.

        """
        return _AppDef.AppDef_BSplineCompute_Interpol(self, *args)

    def IsAllApproximated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if at a moment of the approximation, the status noapproximation has been sent by the user when more points were needed.

        """
        return _AppDef.AppDef_BSplineCompute_IsAllApproximated(self, *args)

    def IsToleranceReached(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if the status nopointsadded has been sent.

        """
        return _AppDef.AppDef_BSplineCompute_IsToleranceReached(self, *args)

    def Parameters(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the new parameters of the approximation corresponding to the points of the multibspcurve.

        """
        return _AppDef.AppDef_BSplineCompute_Parameters(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Line: AppDef_MultiLine

        Return
        -------
        None

        Description
        -----------
        Runs the algorithm after having initialized the fields.

        """
        return _AppDef.AppDef_BSplineCompute_Perform(self, *args)

    def SetConstraints(self, *args):
        r"""

        Parameters
        ----------
        firstC: AppParCurves_Constraint
        lastC: AppParCurves_Constraint

        Return
        -------
        None

        Description
        -----------
        Changes the first and the last constraint points.

        """
        return _AppDef.AppDef_BSplineCompute_SetConstraints(self, *args)

    def SetContinuity(self, *args):
        r"""

        Parameters
        ----------
        C: int

        Return
        -------
        None

        Description
        -----------
        Sets the continuity of the spline. if c = 2, the spline will be c2.

        """
        return _AppDef.AppDef_BSplineCompute_SetContinuity(self, *args)

    def SetDegrees(self, *args):
        r"""

        Parameters
        ----------
        degreemin: int
        degreemax: int

        Return
        -------
        None

        Description
        -----------
        Changes the degrees of the approximation.

        """
        return _AppDef.AppDef_BSplineCompute_SetDegrees(self, *args)

    def SetKnots(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        The approximation will be done with the set of knots <knots>. the multiplicities will be set with the degree and the desired continuity.

        """
        return _AppDef.AppDef_BSplineCompute_SetKnots(self, *args)

    def SetKnotsAndMultiplicities(self, *args):
        r"""

        Parameters
        ----------
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        The approximation will be done with the set of knots <knots> and the multiplicities <mults>.

        """
        return _AppDef.AppDef_BSplineCompute_SetKnotsAndMultiplicities(self, *args)

    def SetParameters(self, *args):
        r"""

        Parameters
        ----------
        ThePar: math_Vector

        Return
        -------
        None

        Description
        -----------
        The approximation will begin with the set of parameters <thepar>.

        """
        return _AppDef.AppDef_BSplineCompute_SetParameters(self, *args)

    def SetPeriodic(self, *args):
        r"""

        Parameters
        ----------
        thePeriodic: bool

        Return
        -------
        None

        Description
        -----------
        Sets periodic flag. if theperiodic = standard_true, algorithm tries to build periodic multicurve using corresponding c1 boundary condition for first and last multipoints. multiline must be closed.

        """
        return _AppDef.AppDef_BSplineCompute_SetPeriodic(self, *args)

    def SetTolerances(self, *args):
        r"""

        Parameters
        ----------
        Tolerance3d: float
        Tolerance2d: float

        Return
        -------
        None

        Description
        -----------
        Changes the tolerances of the approximation.

        """
        return _AppDef.AppDef_BSplineCompute_SetTolerances(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns the result of the approximation.

        """
        return _AppDef.AppDef_BSplineCompute_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_BSplineCompute

# Register AppDef_BSplineCompute in _AppDef:
_AppDef.AppDef_BSplineCompute_swigregister(AppDef_BSplineCompute)
class AppDef_Compute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Line: AppDef_MultiLine
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-3)
        Tolerance2d: float (optional, default to 1.0e-6)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        parametrization: Approx_ParametrizationType (optional, default to Approx_ChordLength)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        The multiline <line> will be approximated until tolerances will be reached. the approximation will be done from degreemin to degreemax with a cutting if the corresponding boolean is true. if <squares> is true, the computation will be done with no iteration at all.

        Parameters
        ----------
        Line: AppDef_MultiLine
        Parameters: math_Vector
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-03)
        Tolerance2d: float (optional, default to 1.0e-06)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        The multiline <line> will be approximated until tolerances will be reached. the approximation will be done from degreemin to degreemax with a cutting if the corresponding boolean is true. if <squares> is true, the computation will be done with no iteration at all.

        Parameters
        ----------
        Parameters: math_Vector
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-03)
        Tolerance2d: float (optional, default to 1.0e-06)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the algorithm.

        Parameters
        ----------
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-03)
        Tolerance2d: float (optional, default to 1.0e-06)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        parametrization: Approx_ParametrizationType (optional, default to Approx_ChordLength)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the algorithm.

        """
        _AppDef.AppDef_Compute_swiginit(self, _AppDef.new_AppDef_Compute(*args))

    def ChangeValue(self, *args):
        r"""

        Parameters
        ----------
        Index: int (optional, default to 1)

        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the result of the approximation.

        """
        return _AppDef.AppDef_Compute_ChangeValue(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        tol3d: float
        tol2d: float

        Description
        -----------
        Returns the tolerances 2d and 3d of the <index> multicurve.

        """
        return _AppDef.AppDef_Compute_Error(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        degreemin: int (optional, default to 4)
        degreemax: int (optional, default to 8)
        Tolerance3d: float (optional, default to 1.0e-03)
        Tolerance2d: float (optional, default to 1.0e-06)
        NbIterations: int (optional, default to 5)
        cutting: bool (optional, default to Standard_True)
        parametrization: Approx_ParametrizationType (optional, default to Approx_ChordLength)
        Squares: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the algorithm.

        """
        return _AppDef.AppDef_Compute_Init(self, *args)

    def IsAllApproximated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if at a moment of the approximation, the status noapproximation has been sent by the user when more points were needed.

        """
        return _AppDef.AppDef_Compute_IsAllApproximated(self, *args)

    def IsToleranceReached(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns false if the status nopointsadded has been sent.

        """
        return _AppDef.AppDef_Compute_IsToleranceReached(self, *args)

    def NbMultiCurves(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of multicurve doing the approximation of the multiline.

        """
        return _AppDef.AppDef_Compute_NbMultiCurves(self, *args)

    def Parameters(self, *args):
        r"""

        Parameters
        ----------
        Index: int (optional, default to 1)

        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the new parameters of the approximation corresponding to the points of the multicurve <index>.

        """
        return _AppDef.AppDef_Compute_Parameters(self, *args)

    def Parametrization(self, *args):
        r"""
        Return
        -------
        Approx_ParametrizationType

        Description
        -----------
        Returns the type of parametrization.

        """
        return _AppDef.AppDef_Compute_Parametrization(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Line: AppDef_MultiLine

        Return
        -------
        None

        Description
        -----------
        Runs the algorithm after having initialized the fields.

        """
        return _AppDef.AppDef_Compute_Perform(self, *args)

    def SetConstraints(self, *args):
        r"""

        Parameters
        ----------
        firstC: AppParCurves_Constraint
        lastC: AppParCurves_Constraint

        Return
        -------
        None

        Description
        -----------
        Changes the first and the last constraint points.

        """
        return _AppDef.AppDef_Compute_SetConstraints(self, *args)

    def SetDegrees(self, *args):
        r"""

        Parameters
        ----------
        degreemin: int
        degreemax: int

        Return
        -------
        None

        Description
        -----------
        Changes the degrees of the approximation.

        """
        return _AppDef.AppDef_Compute_SetDegrees(self, *args)

    def SetTolerances(self, *args):
        r"""

        Parameters
        ----------
        Tolerance3d: float
        Tolerance2d: float

        Return
        -------
        None

        Description
        -----------
        Changes the tolerances of the approximation.

        """
        return _AppDef.AppDef_Compute_SetTolerances(self, *args)

    def SplineValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns the result of the approximation.

        """
        return _AppDef.AppDef_Compute_SplineValue(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        Index: int (optional, default to 1)

        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the result of the approximation.

        """
        return _AppDef.AppDef_Compute_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_Compute

# Register AppDef_Compute in _AppDef:
_AppDef.AppDef_Compute_swigregister(AppDef_Compute)
class AppDef_Gradient_BFGSOfMyGradientOfCompute(OCC.Core.math.math_BFGS):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        F: math_MultipleVarFunctionWithGradient
        StartingPoint: math_Vector
        Tolerance3d: float
        Tolerance2d: float
        Eps: float
        NbIterations: int (optional, default to 200)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _AppDef.AppDef_Gradient_BFGSOfMyGradientOfCompute_swiginit(self, _AppDef.new_AppDef_Gradient_BFGSOfMyGradientOfCompute(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_Gradient_BFGSOfMyGradientOfCompute

# Register AppDef_Gradient_BFGSOfMyGradientOfCompute in _AppDef:
_AppDef.AppDef_Gradient_BFGSOfMyGradientOfCompute_swigregister(AppDef_Gradient_BFGSOfMyGradientOfCompute)
class AppDef_Gradient_BFGSOfMyGradientbisOfBSplineCompute(OCC.Core.math.math_BFGS):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        F: math_MultipleVarFunctionWithGradient
        StartingPoint: math_Vector
        Tolerance3d: float
        Tolerance2d: float
        Eps: float
        NbIterations: int (optional, default to 200)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _AppDef.AppDef_Gradient_BFGSOfMyGradientbisOfBSplineCompute_swiginit(self, _AppDef.new_AppDef_Gradient_BFGSOfMyGradientbisOfBSplineCompute(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_Gradient_BFGSOfMyGradientbisOfBSplineCompute

# Register AppDef_Gradient_BFGSOfMyGradientbisOfBSplineCompute in _AppDef:
_AppDef.AppDef_Gradient_BFGSOfMyGradientbisOfBSplineCompute_swigregister(AppDef_Gradient_BFGSOfMyGradientbisOfBSplineCompute)
class AppDef_Gradient_BFGSOfTheGradient(OCC.Core.math.math_BFGS):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        F: math_MultipleVarFunctionWithGradient
        StartingPoint: math_Vector
        Tolerance3d: float
        Tolerance2d: float
        Eps: float
        NbIterations: int (optional, default to 200)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _AppDef.AppDef_Gradient_BFGSOfTheGradient_swiginit(self, _AppDef.new_AppDef_Gradient_BFGSOfTheGradient(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_Gradient_BFGSOfTheGradient

# Register AppDef_Gradient_BFGSOfTheGradient in _AppDef:
_AppDef.AppDef_Gradient_BFGSOfTheGradient_swigregister(AppDef_Gradient_BFGSOfTheGradient)
class AppDef_MultiLine(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an undefined multiline.

        Parameters
        ----------
        NbMult: int

        Return
        -------
        None

        Description
        -----------
        Given the number nbmult of multipointconstraints of this multiline , it initializes all the fields.setvalue must be called in order for the values of the multipoint constraint to be taken into account. an exception is raised if nbmult < 0.

        Parameters
        ----------
        tabMultiP: AppDef_Array1OfMultiPointConstraint

        Return
        -------
        None

        Description
        -----------
        Constructs a multiline with an array of multipointconstraints.

        Parameters
        ----------
        tabP3d: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        The multiline constructed will have one line of 3d points without their tangencies.

        Parameters
        ----------
        tabP2d: TColgp_Array1OfPnt2d

        Return
        -------
        None

        Description
        -----------
        The multiline constructed will have one line of 2d points without their tangencies.

        """
        _AppDef.AppDef_MultiLine_swiginit(self, _AppDef.new_AppDef_MultiLine(*args))

    def DumpToString(self):
        r"""DumpToString(AppDef_MultiLine self) -> std::string"""
        return _AppDef.AppDef_MultiLine_DumpToString(self)

    def NbMultiPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of multipointconstraints of the multiline.

        """
        return _AppDef.AppDef_MultiLine_NbMultiPoints(self, *args)

    def NbPoints(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of points from multipoints composing the multiline.

        """
        return _AppDef.AppDef_MultiLine_NbPoints(self, *args)

    def SetValue(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        MPoint: AppDef_MultiPointConstraint

        Return
        -------
        None

        Description
        -----------
        It sets the multipointconstraint of range index to the value mpoint. an exception is raised if index < 0 or index> mpoint. an exception is raised if the dimensions of the multipoints are different.

        """
        return _AppDef.AppDef_MultiLine_SetValue(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        AppDef_MultiPointConstraint

        Description
        -----------
        Returns the multipointconstraint of range index an exception is raised if index<0 or index>mpoint.

        """
        return _AppDef.AppDef_MultiLine_Value(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def SetParameter(self):
    	pass

    __swig_destroy__ = _AppDef.delete_AppDef_MultiLine

# Register AppDef_MultiLine in _AppDef:
_AppDef.AppDef_MultiLine_swigregister(AppDef_MultiLine)
class AppDef_MultiPointConstraint(OCC.Core.AppParCurves.AppParCurves_MultiPoint):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an undefined multipointconstraint.

        Parameters
        ----------
        NbPoints: int
        NbPoints2d: int

        Return
        -------
        None

        Description
        -----------
        Constructs a set of points used to approximate a multiline. these points can be of 2 or 3 dimensions. points will be initialized with setpoint and setpoint2d.

        Parameters
        ----------
        tabP: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Creates a multipoint only composed of 3d points.

        Parameters
        ----------
        tabP: TColgp_Array1OfPnt2d

        Return
        -------
        None

        Description
        -----------
        Creates a multipoint only composed of 2d points.

        Parameters
        ----------
        tabP: TColgp_Array1OfPnt
        tabP2d: TColgp_Array1OfPnt2d

        Return
        -------
        None

        Description
        -----------
        Constructs a set of points used to approximate a multiline. these points can be of 2 or 3 dimensions. points will be initialized with setpoint and setpoint2d.

        Parameters
        ----------
        tabP: TColgp_Array1OfPnt
        tabP2d: TColgp_Array1OfPnt2d
        tabVec: TColgp_Array1OfVec
        tabVec2d: TColgp_Array1OfVec2d
        tabCur: TColgp_Array1OfVec
        tabCur2d: TColgp_Array1OfVec2d

        Return
        -------
        None

        Description
        -----------
        Creates a multipointconstraint with a constraint of curvature. an exception is raised if (length of <tabp> + length of <tabp2d> ) is different from (length of <tabvec> + length of <tabvec2d> ) or from (length of <tabcur> + length of <tabcur2d> ).

        Parameters
        ----------
        tabP: TColgp_Array1OfPnt
        tabP2d: TColgp_Array1OfPnt2d
        tabVec: TColgp_Array1OfVec
        tabVec2d: TColgp_Array1OfVec2d

        Return
        -------
        None

        Description
        -----------
        Creates a multipointconstraint with a constraint of tangency. an exception is raised if (length of <tabp> + length of <tabp2d> ) is different from (length of <tabvec> + length of <tabvec2d> ).

        Parameters
        ----------
        tabP: TColgp_Array1OfPnt
        tabVec: TColgp_Array1OfVec
        tabCur: TColgp_Array1OfVec

        Return
        -------
        None

        Description
        -----------
        Creates a multipointconstraint only composed of 3d points with constraints of curvature. an exception is raised if the length of tabp is different from the length of tabvec or from tabcur.

        Parameters
        ----------
        tabP: TColgp_Array1OfPnt
        tabVec: TColgp_Array1OfVec

        Return
        -------
        None

        Description
        -----------
        Creates a multipointconstraint only composed of 3d points with constraints of tangency. an exception is raised if the length of tabp is different from the length of tabvec.

        Parameters
        ----------
        tabP2d: TColgp_Array1OfPnt2d
        tabVec2d: TColgp_Array1OfVec2d

        Return
        -------
        None

        Description
        -----------
        Creates a multipointconstraint only composed of 2d points with constraints of tangency. an exception is raised if the length of tabp is different from the length of tabvec2d.

        Parameters
        ----------
        tabP2d: TColgp_Array1OfPnt2d
        tabVec2d: TColgp_Array1OfVec2d
        tabCur2d: TColgp_Array1OfVec2d

        Return
        -------
        None

        Description
        -----------
        Creates a multipointconstraint only composed of 2d points with constraints of curvature. an exception is raised if the length of tabp is different from the length of tabvec2d or from tabcur2d.

        """
        _AppDef.AppDef_MultiPointConstraint_swiginit(self, _AppDef.new_AppDef_MultiPointConstraint(*args))

    def Curv(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Vec

        Description
        -----------
        Returns the normal vector at the point of range index. an exception is raised if index < 0 or if index > number of 3d points.

        """
        return _AppDef.AppDef_MultiPointConstraint_Curv(self, *args)

    def Curv2d(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Returns the normal vector at the point of range index. an exception is raised if index < 0 or if index > number of 3d points.

        """
        return _AppDef.AppDef_MultiPointConstraint_Curv2d(self, *args)

    def DumpToString(self):
        r"""DumpToString(AppDef_MultiPointConstraint self) -> std::string"""
        return _AppDef.AppDef_MultiPointConstraint_DumpToString(self)

    def IsCurvaturePoint(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the multipoint has a curvature value.

        """
        return _AppDef.AppDef_MultiPointConstraint_IsCurvaturePoint(self, *args)

    def IsTangencyPoint(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the multipoint has a tangency value.

        """
        return _AppDef.AppDef_MultiPointConstraint_IsTangencyPoint(self, *args)

    def SetCurv(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Curv: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Vec sets the value of the normal vector at the point of index index. the norm of the normal vector at the point of position index is set to the normal curvature. an exception is raised if index <0 or if index > number of 3d points. an exception is raised if curv has an incorrect number of dimensions.

        """
        return _AppDef.AppDef_MultiPointConstraint_SetCurv(self, *args)

    def SetCurv2d(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Curv2d: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Vec sets the value of the normal vector at the point of index index. the norm of the normal vector at the point of position index is set to the normal curvature. an exception is raised if index <0 or if index > number of 3d points. an exception is raised if curv has an incorrect number of dimensions.

        """
        return _AppDef.AppDef_MultiPointConstraint_SetCurv2d(self, *args)

    def SetTang(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Tang: gp_Vec

        Return
        -------
        None

        Description
        -----------
        Sets the value of the tangency of the point of range index. an exception is raised if index <0 or if index > number of 3d points. an exception is raised if tang has an incorrect number of dimensions.

        """
        return _AppDef.AppDef_MultiPointConstraint_SetTang(self, *args)

    def SetTang2d(self, *args):
        r"""

        Parameters
        ----------
        Index: int
        Tang2d: gp_Vec2d

        Return
        -------
        None

        Description
        -----------
        Sets the value of the tangency of the point of range index. an exception is raised if index <number of 3d points or if index > total number of points an exception is raised if tang has an incorrect number of dimensions.

        """
        return _AppDef.AppDef_MultiPointConstraint_SetTang2d(self, *args)

    def Tang(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Vec

        Description
        -----------
        Returns the tangency value of the point of range index. an exception is raised if index < 0 or if index > number of 3d points.

        """
        return _AppDef.AppDef_MultiPointConstraint_Tang(self, *args)

    def Tang2d(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        gp_Vec2d

        Description
        -----------
        Returns the tangency value of the point of range index. an exception is raised if index < number of 3d points or if index > total number of points.

        """
        return _AppDef.AppDef_MultiPointConstraint_Tang2d(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_MultiPointConstraint

# Register AppDef_MultiPointConstraint in _AppDef:
_AppDef.AppDef_MultiPointConstraint_swigregister(AppDef_MultiPointConstraint)
class AppDef_MyBSplGradientOfBSplineCompute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        Deg: int
        Tol3d: float
        Tol2d: float
        NbIterations: int (optional, default to 1)

        Return
        -------
        None

        Description
        -----------
        Tries to minimize the sum (square(||qui - bi*pi||)) where pui describe the approximating bspline curves'poles and qi the multiline points with a parameter ui. in this algorithm, the parameters ui are the unknowns. the tolerance required on this sum is given by tol. the desired degree of the resulting curve is deg.

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        Deg: int
        Tol3d: float
        Tol2d: float
        NbIterations: int
        lambda1: float
        lambda2: float

        Return
        -------
        None

        Description
        -----------
        Tries to minimize the sum (square(||qui - bi*pi||)) where pui describe the approximating bspline curves'poles and qi the multiline points with a parameter ui. in this algorithm, the parameters ui are the unknowns. the tolerance required on this sum is given by tol. the desired degree of the resulting curve is deg.

        """
        _AppDef.AppDef_MyBSplGradientOfBSplineCompute_swiginit(self, _AppDef.new_AppDef_MyBSplGradientOfBSplineCompute(*args))

    def AverageError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the average error between the old and the new approximation.

        """
        return _AppDef.AppDef_MyBSplGradientOfBSplineCompute_AverageError(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the difference between the old and the new approximation. an exception is raised if notdone. an exception is raised if index<1 or index>nbparameters.

        """
        return _AppDef.AppDef_MyBSplGradientOfBSplineCompute_Error(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_MyBSplGradientOfBSplineCompute_IsDone(self, *args)

    def MaxError2d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum difference between the old and the new approximation.

        """
        return _AppDef.AppDef_MyBSplGradientOfBSplineCompute_MaxError2d(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum difference between the old and the new approximation.

        """
        return _AppDef.AppDef_MyBSplGradientOfBSplineCompute_MaxError3d(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns all the bspline curves approximating the multiline ssp after minimization of the parameter.

        """
        return _AppDef.AppDef_MyBSplGradientOfBSplineCompute_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_MyBSplGradientOfBSplineCompute

# Register AppDef_MyBSplGradientOfBSplineCompute in _AppDef:
_AppDef.AppDef_MyBSplGradientOfBSplineCompute_swigregister(AppDef_MyBSplGradientOfBSplineCompute)
class AppDef_MyGradientOfCompute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Deg: int
        Tol3d: float
        Tol2d: float
        NbIterations: int (optional, default to 200)

        Return
        -------
        None

        Description
        -----------
        Tries to minimize the sum (square(||qui - bi*pi||)) where pui describe the approximating bezier curves'poles and qi the multiline points with a parameter ui. in this algorithm, the parameters ui are the unknowns. the tolerance required on this sum is given by tol. the desired degree of the resulting curve is deg.

        """
        _AppDef.AppDef_MyGradientOfCompute_swiginit(self, _AppDef.new_AppDef_MyGradientOfCompute(*args))

    def AverageError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the average error between the old and the new approximation.

        """
        return _AppDef.AppDef_MyGradientOfCompute_AverageError(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the difference between the old and the new approximation. an exception is raised if notdone. an exception is raised if index<1 or index>nbparameters.

        """
        return _AppDef.AppDef_MyGradientOfCompute_Error(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_MyGradientOfCompute_IsDone(self, *args)

    def MaxError2d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum difference between the old and the new approximation.

        """
        return _AppDef.AppDef_MyGradientOfCompute_MaxError2d(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum difference between the old and the new approximation.

        """
        return _AppDef.AppDef_MyGradientOfCompute_MaxError3d(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns all the bezier curves approximating the multiline ssp after minimization of the parameter.

        """
        return _AppDef.AppDef_MyGradientOfCompute_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_MyGradientOfCompute

# Register AppDef_MyGradientOfCompute in _AppDef:
_AppDef.AppDef_MyGradientOfCompute_swigregister(AppDef_MyGradientOfCompute)
class AppDef_MyGradientbisOfBSplineCompute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Deg: int
        Tol3d: float
        Tol2d: float
        NbIterations: int (optional, default to 200)

        Return
        -------
        None

        Description
        -----------
        Tries to minimize the sum (square(||qui - bi*pi||)) where pui describe the approximating bezier curves'poles and qi the multiline points with a parameter ui. in this algorithm, the parameters ui are the unknowns. the tolerance required on this sum is given by tol. the desired degree of the resulting curve is deg.

        """
        _AppDef.AppDef_MyGradientbisOfBSplineCompute_swiginit(self, _AppDef.new_AppDef_MyGradientbisOfBSplineCompute(*args))

    def AverageError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the average error between the old and the new approximation.

        """
        return _AppDef.AppDef_MyGradientbisOfBSplineCompute_AverageError(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the difference between the old and the new approximation. an exception is raised if notdone. an exception is raised if index<1 or index>nbparameters.

        """
        return _AppDef.AppDef_MyGradientbisOfBSplineCompute_Error(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_MyGradientbisOfBSplineCompute_IsDone(self, *args)

    def MaxError2d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum difference between the old and the new approximation.

        """
        return _AppDef.AppDef_MyGradientbisOfBSplineCompute_MaxError2d(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum difference between the old and the new approximation.

        """
        return _AppDef.AppDef_MyGradientbisOfBSplineCompute_MaxError3d(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns all the bezier curves approximating the multiline ssp after minimization of the parameter.

        """
        return _AppDef.AppDef_MyGradientbisOfBSplineCompute_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_MyGradientbisOfBSplineCompute

# Register AppDef_MyGradientbisOfBSplineCompute in _AppDef:
_AppDef.AppDef_MyGradientbisOfBSplineCompute_swigregister(AppDef_MyGradientbisOfBSplineCompute)
class AppDef_MyLineTool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Curvature(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine
        MPointIndex: int
        tabV: TColgp_Array1OfVec

        Return
        -------
        bool

        Description
        -----------
        Returns the 3d curvatures of the multipoint <mpointindex> when only 3d points exist.

        Parameters
        ----------
        ML: AppDef_MultiLine
        MPointIndex: int
        tabV2d: TColgp_Array1OfVec2d

        Return
        -------
        bool

        Description
        -----------
        Returns the 2d curvatures of the multipoint <mpointindex> only when 2d points exist.

        Parameters
        ----------
        ML: AppDef_MultiLine
        MPointIndex: int
        tabV: TColgp_Array1OfVec
        tabV2d: TColgp_Array1OfVec2d

        Return
        -------
        bool

        Description
        -----------
        Returns the 3d and 2d curvatures of the multipoint <mpointindex>.

        """
        return _AppDef.AppDef_MyLineTool_Curvature(*args)

    @staticmethod
    def FirstPoint(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine

        Return
        -------
        int

        Description
        -----------
        Returns the first index of multipoints of the multiline.

        """
        return _AppDef.AppDef_MyLineTool_FirstPoint(*args)

    @staticmethod
    def LastPoint(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine

        Return
        -------
        int

        Description
        -----------
        Returns the last index of multipoints of the multiline.

        """
        return _AppDef.AppDef_MyLineTool_LastPoint(*args)

    @staticmethod
    def MakeMLBetween(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine
        I1: int
        I2: int
        NbPMin: int

        Return
        -------
        AppDef_MultiLine

        Description
        -----------
        Is never called in the algorithms. nothing is done.

        """
        return _AppDef.AppDef_MyLineTool_MakeMLBetween(*args)

    @staticmethod
    def MakeMLOneMorePoint(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine
        I1: int
        I2: int
        indbad: int
        OtherLine: AppDef_MultiLine

        Return
        -------
        bool

        Description
        -----------
        Is never called in the algorithms. nothing is done.

        """
        return _AppDef.AppDef_MyLineTool_MakeMLOneMorePoint(*args)

    @staticmethod
    def NbP2d(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine

        Return
        -------
        int

        Description
        -----------
        Returns the number of 2d points of a multiline.

        """
        return _AppDef.AppDef_MyLineTool_NbP2d(*args)

    @staticmethod
    def NbP3d(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine

        Return
        -------
        int

        Description
        -----------
        Returns the number of 3d points of a multiline.

        """
        return _AppDef.AppDef_MyLineTool_NbP3d(*args)

    @staticmethod
    def Tangency(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine
        MPointIndex: int
        tabV: TColgp_Array1OfVec

        Return
        -------
        bool

        Description
        -----------
        Returns the 3d points of the multipoint <mpointindex> when only 3d points exist.

        Parameters
        ----------
        ML: AppDef_MultiLine
        MPointIndex: int
        tabV2d: TColgp_Array1OfVec2d

        Return
        -------
        bool

        Description
        -----------
        Returns the 2d tangency points of the multipoint <mpointindex> only when 2d points exist.

        Parameters
        ----------
        ML: AppDef_MultiLine
        MPointIndex: int
        tabV: TColgp_Array1OfVec
        tabV2d: TColgp_Array1OfVec2d

        Return
        -------
        bool

        Description
        -----------
        Returns the 3d and 2d points of the multipoint <mpointindex>.

        """
        return _AppDef.AppDef_MyLineTool_Tangency(*args)

    @staticmethod
    def Value(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine
        MPointIndex: int
        tabPt: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Returns the 3d points of the multipoint <mpointindex> when only 3d points exist.

        Parameters
        ----------
        ML: AppDef_MultiLine
        MPointIndex: int
        tabPt2d: TColgp_Array1OfPnt2d

        Return
        -------
        None

        Description
        -----------
        Returns the 2d points of the multipoint <mpointindex> when only 2d points exist.

        Parameters
        ----------
        ML: AppDef_MultiLine
        MPointIndex: int
        tabPt: TColgp_Array1OfPnt
        tabPt2d: TColgp_Array1OfPnt2d

        Return
        -------
        None

        Description
        -----------
        Returns the 3d and 2d points of the multipoint <mpointindex>.

        """
        return _AppDef.AppDef_MyLineTool_Value(*args)

    @staticmethod
    def WhatStatus(*args):
        r"""

        Parameters
        ----------
        ML: AppDef_MultiLine
        I1: int
        I2: int

        Return
        -------
        Approx_Status

        Description
        -----------
        Returns nopointsadded.

        """
        return _AppDef.AppDef_MyLineTool_WhatStatus(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _AppDef.AppDef_MyLineTool_swiginit(self, _AppDef.new_AppDef_MyLineTool())
    __swig_destroy__ = _AppDef.delete_AppDef_MyLineTool

# Register AppDef_MyLineTool in _AppDef:
_AppDef.AppDef_MyLineTool_swigregister(AppDef_MyLineTool)
class AppDef_ParFunctionOfMyGradientOfCompute(OCC.Core.math.math_MultipleVarFunctionWithGradient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Deg: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the function. the approximating curve has the desired degree deg.

        """
        _AppDef.AppDef_ParFunctionOfMyGradientOfCompute_swiginit(self, _AppDef.new_AppDef_ParFunctionOfMyGradientOfCompute(*args))

    def CurveValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the multicurve approximating the set after computing the value f or grad(f).

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientOfCompute_CurveValue(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        IPoint: int
        CurveIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the distance between the multipoint of range ipoint and the curve curveindex.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientOfCompute_Error(self, *args)

    def FirstConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        FirstPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientOfCompute_FirstConstraint(self, *args)

    def LastConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        LastPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientOfCompute_LastConstraint(self, *args)

    def MaxError2d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multicurve.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientOfCompute_MaxError2d(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multicurve.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientOfCompute_MaxError3d(self, *args)

    def NewParameters(self, *args):
        r"""
        Return
        -------
        math_Vector

        Description
        -----------
        Returns the new parameters of the multiline.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientOfCompute_NewParameters(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_ParFunctionOfMyGradientOfCompute

# Register AppDef_ParFunctionOfMyGradientOfCompute in _AppDef:
_AppDef.AppDef_ParFunctionOfMyGradientOfCompute_swigregister(AppDef_ParFunctionOfMyGradientOfCompute)
class AppDef_ParFunctionOfMyGradientbisOfBSplineCompute(OCC.Core.math.math_MultipleVarFunctionWithGradient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Deg: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the function. the approximating curve has the desired degree deg.

        """
        _AppDef.AppDef_ParFunctionOfMyGradientbisOfBSplineCompute_swiginit(self, _AppDef.new_AppDef_ParFunctionOfMyGradientbisOfBSplineCompute(*args))

    def CurveValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the multicurve approximating the set after computing the value f or grad(f).

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientbisOfBSplineCompute_CurveValue(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        IPoint: int
        CurveIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the distance between the multipoint of range ipoint and the curve curveindex.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientbisOfBSplineCompute_Error(self, *args)

    def FirstConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        FirstPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientbisOfBSplineCompute_FirstConstraint(self, *args)

    def LastConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        LastPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientbisOfBSplineCompute_LastConstraint(self, *args)

    def MaxError2d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multicurve.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientbisOfBSplineCompute_MaxError2d(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multicurve.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientbisOfBSplineCompute_MaxError3d(self, *args)

    def NewParameters(self, *args):
        r"""
        Return
        -------
        math_Vector

        Description
        -----------
        Returns the new parameters of the multiline.

        """
        return _AppDef.AppDef_ParFunctionOfMyGradientbisOfBSplineCompute_NewParameters(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_ParFunctionOfMyGradientbisOfBSplineCompute

# Register AppDef_ParFunctionOfMyGradientbisOfBSplineCompute in _AppDef:
_AppDef.AppDef_ParFunctionOfMyGradientbisOfBSplineCompute_swigregister(AppDef_ParFunctionOfMyGradientbisOfBSplineCompute)
class AppDef_ParFunctionOfTheGradient(OCC.Core.math.math_MultipleVarFunctionWithGradient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Deg: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the function. the approximating curve has the desired degree deg.

        """
        _AppDef.AppDef_ParFunctionOfTheGradient_swiginit(self, _AppDef.new_AppDef_ParFunctionOfTheGradient(*args))

    def CurveValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the multicurve approximating the set after computing the value f or grad(f).

        """
        return _AppDef.AppDef_ParFunctionOfTheGradient_CurveValue(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        IPoint: int
        CurveIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the distance between the multipoint of range ipoint and the curve curveindex.

        """
        return _AppDef.AppDef_ParFunctionOfTheGradient_Error(self, *args)

    def FirstConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        FirstPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_ParFunctionOfTheGradient_FirstConstraint(self, *args)

    def LastConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        LastPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_ParFunctionOfTheGradient_LastConstraint(self, *args)

    def MaxError2d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multicurve.

        """
        return _AppDef.AppDef_ParFunctionOfTheGradient_MaxError2d(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multicurve.

        """
        return _AppDef.AppDef_ParFunctionOfTheGradient_MaxError3d(self, *args)

    def NewParameters(self, *args):
        r"""
        Return
        -------
        math_Vector

        Description
        -----------
        Returns the new parameters of the multiline.

        """
        return _AppDef.AppDef_ParFunctionOfTheGradient_NewParameters(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_ParFunctionOfTheGradient

# Register AppDef_ParFunctionOfTheGradient in _AppDef:
_AppDef.AppDef_ParFunctionOfTheGradient_swigregister(AppDef_ParFunctionOfTheGradient)
class AppDef_ParLeastSquareOfMyGradientOfCompute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. nbpol is the number of control points wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bernstein matrix computed with the parameters, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. deg is the degree wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bspline functions matrix computed with <parameters>, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        """
        _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_swiginit(self, _AppDef.new_AppDef_ParLeastSquareOfMyGradientOfCompute(*args))

    def BSplineValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_BSplineValue(self, *args)

    def BezierValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_BezierValue(self, *args)

    def DerivativeFunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative function matrix used to approximate the set.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_DerivativeFunctionMatrix(self, *args)

    def Distance(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the distances between the points of the multiline and the approximation curves.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_Distance(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_Error(self, *args)

    def ErrorGradient(self, *args):
        r"""

        Parameters
        ----------
        Grad: math_Vector

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances. grad is the derivative vector of the function f.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_ErrorGradient(self, *args)

    def FirstLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (p2 - p1)/ v1 if the first point was a tangency point.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_FirstLambda(self, *args)

    def FunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the function matrix used to approximate the set.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_FunctionMatrix(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_IsDone(self, *args)

    def KIndex(self, *args):
        r"""
        Return
        -------
        math_IntegerVector

        Description
        -----------
        Returns the indexes of the first non null values of a and da. the values are non null from index(ieme point) +1 to index(ieme point) + degree +1.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_KIndex(self, *args)

    def LastLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (pn - pn-1)/ vn if the last point was a tangency point.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_LastLambda(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Parameters: math_Vector

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. the case 'curvaturepoint' is not treated in this method.

        Parameters
        ----------
        Parameters: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        V1c: math_Vector
        V2c: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point. <v1c> is the tangent vector at the first point. <v2c> is the tangent vector at the last point.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_Perform(self, *args)

    def Points(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of points value.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_Points(self, *args)

    def Poles(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of resulting control points value.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_ParLeastSquareOfMyGradientOfCompute

# Register AppDef_ParLeastSquareOfMyGradientOfCompute in _AppDef:
_AppDef.AppDef_ParLeastSquareOfMyGradientOfCompute_swigregister(AppDef_ParLeastSquareOfMyGradientOfCompute)
class AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. nbpol is the number of control points wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bernstein matrix computed with the parameters, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. deg is the degree wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bspline functions matrix computed with <parameters>, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        """
        _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_swiginit(self, _AppDef.new_AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute(*args))

    def BSplineValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_BSplineValue(self, *args)

    def BezierValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_BezierValue(self, *args)

    def DerivativeFunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative function matrix used to approximate the set.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_DerivativeFunctionMatrix(self, *args)

    def Distance(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the distances between the points of the multiline and the approximation curves.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_Distance(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_Error(self, *args)

    def ErrorGradient(self, *args):
        r"""

        Parameters
        ----------
        Grad: math_Vector

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances. grad is the derivative vector of the function f.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_ErrorGradient(self, *args)

    def FirstLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (p2 - p1)/ v1 if the first point was a tangency point.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_FirstLambda(self, *args)

    def FunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the function matrix used to approximate the set.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_FunctionMatrix(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_IsDone(self, *args)

    def KIndex(self, *args):
        r"""
        Return
        -------
        math_IntegerVector

        Description
        -----------
        Returns the indexes of the first non null values of a and da. the values are non null from index(ieme point) +1 to index(ieme point) + degree +1.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_KIndex(self, *args)

    def LastLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (pn - pn-1)/ vn if the last point was a tangency point.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_LastLambda(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Parameters: math_Vector

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. the case 'curvaturepoint' is not treated in this method.

        Parameters
        ----------
        Parameters: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        V1c: math_Vector
        V2c: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point. <v1c> is the tangent vector at the first point. <v2c> is the tangent vector at the last point.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_Perform(self, *args)

    def Points(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of points value.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_Points(self, *args)

    def Poles(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of resulting control points value.

        """
        return _AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute

# Register AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute in _AppDef:
_AppDef.AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute_swigregister(AppDef_ParLeastSquareOfMyGradientbisOfBSplineCompute)
class AppDef_ParLeastSquareOfTheGradient(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. nbpol is the number of control points wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bernstein matrix computed with the parameters, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. deg is the degree wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bspline functions matrix computed with <parameters>, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        """
        _AppDef.AppDef_ParLeastSquareOfTheGradient_swiginit(self, _AppDef.new_AppDef_ParLeastSquareOfTheGradient(*args))

    def BSplineValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_BSplineValue(self, *args)

    def BezierValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_BezierValue(self, *args)

    def DerivativeFunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative function matrix used to approximate the set.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_DerivativeFunctionMatrix(self, *args)

    def Distance(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the distances between the points of the multiline and the approximation curves.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_Distance(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_Error(self, *args)

    def ErrorGradient(self, *args):
        r"""

        Parameters
        ----------
        Grad: math_Vector

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances. grad is the derivative vector of the function f.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_ErrorGradient(self, *args)

    def FirstLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (p2 - p1)/ v1 if the first point was a tangency point.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_FirstLambda(self, *args)

    def FunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the function matrix used to approximate the set.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_FunctionMatrix(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_IsDone(self, *args)

    def KIndex(self, *args):
        r"""
        Return
        -------
        math_IntegerVector

        Description
        -----------
        Returns the indexes of the first non null values of a and da. the values are non null from index(ieme point) +1 to index(ieme point) + degree +1.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_KIndex(self, *args)

    def LastLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (pn - pn-1)/ vn if the last point was a tangency point.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_LastLambda(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Parameters: math_Vector

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. the case 'curvaturepoint' is not treated in this method.

        Parameters
        ----------
        Parameters: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        V1c: math_Vector
        V2c: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point. <v1c> is the tangent vector at the first point. <v2c> is the tangent vector at the last point.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_Perform(self, *args)

    def Points(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of points value.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_Points(self, *args)

    def Poles(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of resulting control points value.

        """
        return _AppDef.AppDef_ParLeastSquareOfTheGradient_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_ParLeastSquareOfTheGradient

# Register AppDef_ParLeastSquareOfTheGradient in _AppDef:
_AppDef.AppDef_ParLeastSquareOfTheGradient_swigregister(AppDef_ParLeastSquareOfTheGradient)
class AppDef_ResConstraintOfMyGradientOfCompute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        SCurv: AppParCurves_MultiCurve
        FirstPoint: int
        LastPoint: int
        Constraints: AppParCurves_HArray1OfConstraintCouple
        Bern: math_Matrix
        DerivativeBern: math_Matrix
        Tolerance: float (optional, default to 1.0e-10)

        Return
        -------
        None

        Description
        -----------
        Given a multiline ssp with constraints points, this algorithm finds the best curve solution to approximate it. the poles from scurv issued for example from the least squares are used as a guess solution for the uzawa algorithm. the tolerance used in the uzawa algorithms is tolerance. a is the bernstein matrix associated to the multiline and da is the derivative bernstein matrix.(they can come from an approximation with parleastsquare.) the multicurve is modified. new multipoles are given.

        """
        _AppDef.AppDef_ResConstraintOfMyGradientOfCompute_swiginit(self, _AppDef.new_AppDef_ResConstraintOfMyGradientOfCompute(*args))

    def ConstraintDerivative(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Parameters: math_Vector
        Deg: int
        DA: math_Matrix

        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative of the constraint matrix.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientOfCompute_ConstraintDerivative(self, *args)

    def ConstraintMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientOfCompute_ConstraintMatrix(self, *args)

    def Duale(self, *args):
        r"""
        Return
        -------
        math_Vector

        Description
        -----------
        Returns the duale variables of the system.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientOfCompute_Duale(self, *args)

    def InverseMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the inverse of cont*transposed(cont), where cont is the constraint matrix for the algorithm.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientOfCompute_InverseMatrix(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientOfCompute_IsDone(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Error(self):
    	pass

    __swig_destroy__ = _AppDef.delete_AppDef_ResConstraintOfMyGradientOfCompute

# Register AppDef_ResConstraintOfMyGradientOfCompute in _AppDef:
_AppDef.AppDef_ResConstraintOfMyGradientOfCompute_swigregister(AppDef_ResConstraintOfMyGradientOfCompute)
class AppDef_ResConstraintOfMyGradientbisOfBSplineCompute(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        SCurv: AppParCurves_MultiCurve
        FirstPoint: int
        LastPoint: int
        Constraints: AppParCurves_HArray1OfConstraintCouple
        Bern: math_Matrix
        DerivativeBern: math_Matrix
        Tolerance: float (optional, default to 1.0e-10)

        Return
        -------
        None

        Description
        -----------
        Given a multiline ssp with constraints points, this algorithm finds the best curve solution to approximate it. the poles from scurv issued for example from the least squares are used as a guess solution for the uzawa algorithm. the tolerance used in the uzawa algorithms is tolerance. a is the bernstein matrix associated to the multiline and da is the derivative bernstein matrix.(they can come from an approximation with parleastsquare.) the multicurve is modified. new multipoles are given.

        """
        _AppDef.AppDef_ResConstraintOfMyGradientbisOfBSplineCompute_swiginit(self, _AppDef.new_AppDef_ResConstraintOfMyGradientbisOfBSplineCompute(*args))

    def ConstraintDerivative(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Parameters: math_Vector
        Deg: int
        DA: math_Matrix

        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative of the constraint matrix.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientbisOfBSplineCompute_ConstraintDerivative(self, *args)

    def ConstraintMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientbisOfBSplineCompute_ConstraintMatrix(self, *args)

    def Duale(self, *args):
        r"""
        Return
        -------
        math_Vector

        Description
        -----------
        Returns the duale variables of the system.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientbisOfBSplineCompute_Duale(self, *args)

    def InverseMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the inverse of cont*transposed(cont), where cont is the constraint matrix for the algorithm.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientbisOfBSplineCompute_InverseMatrix(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_ResConstraintOfMyGradientbisOfBSplineCompute_IsDone(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Error(self):
    	pass

    __swig_destroy__ = _AppDef.delete_AppDef_ResConstraintOfMyGradientbisOfBSplineCompute

# Register AppDef_ResConstraintOfMyGradientbisOfBSplineCompute in _AppDef:
_AppDef.AppDef_ResConstraintOfMyGradientbisOfBSplineCompute_swigregister(AppDef_ResConstraintOfMyGradientbisOfBSplineCompute)
class AppDef_ResConstraintOfTheGradient(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        SCurv: AppParCurves_MultiCurve
        FirstPoint: int
        LastPoint: int
        Constraints: AppParCurves_HArray1OfConstraintCouple
        Bern: math_Matrix
        DerivativeBern: math_Matrix
        Tolerance: float (optional, default to 1.0e-10)

        Return
        -------
        None

        Description
        -----------
        Given a multiline ssp with constraints points, this algorithm finds the best curve solution to approximate it. the poles from scurv issued for example from the least squares are used as a guess solution for the uzawa algorithm. the tolerance used in the uzawa algorithms is tolerance. a is the bernstein matrix associated to the multiline and da is the derivative bernstein matrix.(they can come from an approximation with parleastsquare.) the multicurve is modified. new multipoles are given.

        """
        _AppDef.AppDef_ResConstraintOfTheGradient_swiginit(self, _AppDef.new_AppDef_ResConstraintOfTheGradient(*args))

    def ConstraintDerivative(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Parameters: math_Vector
        Deg: int
        DA: math_Matrix

        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative of the constraint matrix.

        """
        return _AppDef.AppDef_ResConstraintOfTheGradient_ConstraintDerivative(self, *args)

    def ConstraintMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_ResConstraintOfTheGradient_ConstraintMatrix(self, *args)

    def Duale(self, *args):
        r"""
        Return
        -------
        math_Vector

        Description
        -----------
        Returns the duale variables of the system.

        """
        return _AppDef.AppDef_ResConstraintOfTheGradient_Duale(self, *args)

    def InverseMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the inverse of cont*transposed(cont), where cont is the constraint matrix for the algorithm.

        """
        return _AppDef.AppDef_ResConstraintOfTheGradient_InverseMatrix(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_ResConstraintOfTheGradient_IsDone(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Error(self):
    	pass

    __swig_destroy__ = _AppDef.delete_AppDef_ResConstraintOfTheGradient

# Register AppDef_ResConstraintOfTheGradient in _AppDef:
_AppDef.AppDef_ResConstraintOfTheGradient_swigregister(AppDef_ResConstraintOfTheGradient)
class AppDef_SmoothCriterion(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def AssemblyTable(self, *args):
        r"""
        Return
        -------
        opencascade::handle<FEmTool_HAssemblyTable>

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_AssemblyTable(self, *args)

    def DependenceTable(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray2OfInteger>

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_DependenceTable(self, *args)

    def ErrorValues(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        MaxError: float
        QuadraticError: float
        AverageError: float

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_ErrorValues(self, *args)

    def EstLength(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_EstLength(self, *args)

    def GetCurve(self, *args):
        r"""

        Parameters
        ----------
        C: FEmTool_Curve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_GetCurve(self, *args)

    def GetEstimation(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        E1: float
        E2: float
        E3: float

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_GetEstimation(self, *args)

    def GetWeight(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        QuadraticWeight: float
        QualityWeight: float

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_GetWeight(self, *args)

    def Gradient(self, *args):
        r"""

        Parameters
        ----------
        Element: int
        Dimension: int
        G: math_Vector

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_Gradient(self, *args)

    def Hessian(self, *args):
        r"""

        Parameters
        ----------
        Element: int
        Dimension1: int
        Dimension2: int
        H: math_Matrix

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_Hessian(self, *args)

    def InputVector(self, *args):
        r"""

        Parameters
        ----------
        X: math_Vector
        AssTable: FEmTool_HAssemblyTable

        Return
        -------
        None

        Description
        -----------
        Convert the assembly vector in an curve;.

        """
        return _AppDef.AppDef_SmoothCriterion_InputVector(self, *args)

    def QualityValues(self, *args):
        r"""

        Parameters
        ----------
        J1min: float
        J2min: float
        J3min: float

        Return
        -------
        J1: float
        J2: float
        J3: float

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_QualityValues(self, *args)

    def SetCurve(self, *args):
        r"""

        Parameters
        ----------
        C: FEmTool_Curve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_SetCurve(self, *args)

    def SetEstimation(self, *args):
        r"""

        Parameters
        ----------
        E1: float
        E2: float
        E3: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_SetEstimation(self, *args)

    def SetParameters(self, *args):
        r"""

        Parameters
        ----------
        Parameters: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_SetParameters(self, *args)

    def SetWeight(self, *args):
        r"""

        Parameters
        ----------
        QuadraticWeight: float
        QualityWeight: float
        percentJ1: float
        percentJ2: float
        percentJ3: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Weight: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_SmoothCriterion_SetWeight(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_AppDef_SmoothCriterion_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_SmoothCriterion

# Register AppDef_SmoothCriterion in _AppDef:
_AppDef.AppDef_SmoothCriterion_swigregister(AppDef_SmoothCriterion)
class AppDef_TheFunction(OCC.Core.math.math_MultipleVarFunctionWithGradient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Deg: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the function. the approximating curve has the desired degree deg.

        """
        _AppDef.AppDef_TheFunction_swiginit(self, _AppDef.new_AppDef_TheFunction(*args))

    def CurveValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the multicurve approximating the set after computing the value f or grad(f).

        """
        return _AppDef.AppDef_TheFunction_CurveValue(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        IPoint: int
        CurveIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns the distance between the multipoint of range ipoint and the curve curveindex.

        """
        return _AppDef.AppDef_TheFunction_Error(self, *args)

    def FirstConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        FirstPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_TheFunction_FirstConstraint(self, *args)

    def LastConstraint(self, *args):
        r"""

        Parameters
        ----------
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        LastPoint: int

        Return
        -------
        AppParCurves_Constraint

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_TheFunction_LastConstraint(self, *args)

    def MaxError2d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multicurve.

        """
        return _AppDef.AppDef_TheFunction_MaxError2d(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum distance between the points and the multicurve.

        """
        return _AppDef.AppDef_TheFunction_MaxError3d(self, *args)

    def NewParameters(self, *args):
        r"""
        Return
        -------
        math_Vector

        Description
        -----------
        Returns the new parameters of the multiline.

        """
        return _AppDef.AppDef_TheFunction_NewParameters(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_TheFunction

# Register AppDef_TheFunction in _AppDef:
_AppDef.AppDef_TheFunction_swigregister(AppDef_TheFunction)
class AppDef_TheGradient(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        Parameters: math_Vector
        Deg: int
        Tol3d: float
        Tol2d: float
        NbIterations: int (optional, default to 200)

        Return
        -------
        None

        Description
        -----------
        Tries to minimize the sum (square(||qui - bi*pi||)) where pui describe the approximating bezier curves'poles and qi the multiline points with a parameter ui. in this algorithm, the parameters ui are the unknowns. the tolerance required on this sum is given by tol. the desired degree of the resulting curve is deg.

        """
        _AppDef.AppDef_TheGradient_swiginit(self, _AppDef.new_AppDef_TheGradient(*args))

    def AverageError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the average error between the old and the new approximation.

        """
        return _AppDef.AppDef_TheGradient_AverageError(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        float

        Description
        -----------
        Returns the difference between the old and the new approximation. an exception is raised if notdone. an exception is raised if index<1 or index>nbparameters.

        """
        return _AppDef.AppDef_TheGradient_Error(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_TheGradient_IsDone(self, *args)

    def MaxError2d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum difference between the old and the new approximation.

        """
        return _AppDef.AppDef_TheGradient_MaxError2d(self, *args)

    def MaxError3d(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum difference between the old and the new approximation.

        """
        return _AppDef.AppDef_TheGradient_MaxError3d(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns all the bezier curves approximating the multiline ssp after minimization of the parameter.

        """
        return _AppDef.AppDef_TheGradient_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_TheGradient

# Register AppDef_TheGradient in _AppDef:
_AppDef.AppDef_TheGradient_swigregister(AppDef_TheGradient)
class AppDef_TheLeastSquares(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. nbpol is the number of control points wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bernstein matrix computed with the parameters, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        Parameters: math_Vector
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Given a multiline, this algorithm computes the least square resolution using the householder-qr method. if the first and/or the last point is a constraint point, the value of the tangency or curvature is computed in the resolution. deg is the degree wanted for the approximating curves. the system to solve is the following: a x = b. where a is the bspline functions matrix computed with <parameters>, b the points coordinates and x the poles solutions. the matrix a is the same for each coordinate x, y and z and is also the same for each multiline point because they are approximated in parallel(so with the same parameter, only the vector b changes).

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Knots: TColStd_Array1OfReal
        Mults: TColStd_Array1OfInteger
        FirstPoint: int
        LastPoint: int
        FirstCons: AppParCurves_Constraint
        LastCons: AppParCurves_Constraint
        NbPol: int

        Return
        -------
        None

        Description
        -----------
        Initializes the fields of the object.

        """
        _AppDef.AppDef_TheLeastSquares_swiginit(self, _AppDef.new_AppDef_TheLeastSquares(*args))

    def BSplineValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_TheLeastSquares_BSplineValue(self, *args)

    def BezierValue(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiCurve

        Description
        -----------
        Returns the result of the approximation, i.e. all the curves. an exception is raised if notdone.

        """
        return _AppDef.AppDef_TheLeastSquares_BezierValue(self, *args)

    def DerivativeFunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative function matrix used to approximate the set.

        """
        return _AppDef.AppDef_TheLeastSquares_DerivativeFunctionMatrix(self, *args)

    def Distance(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the distances between the points of the multiline and the approximation curves.

        """
        return _AppDef.AppDef_TheLeastSquares_Distance(self, *args)

    def Error(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances.

        """
        return _AppDef.AppDef_TheLeastSquares_Error(self, *args)

    def ErrorGradient(self, *args):
        r"""

        Parameters
        ----------
        Grad: math_Vector

        Return
        -------
        F: float
        MaxE3d: float
        MaxE2d: float

        Description
        -----------
        Returns the maximum errors between the multiline and the approximation curves. f is the sum of the square distances. grad is the derivative vector of the function f.

        """
        return _AppDef.AppDef_TheLeastSquares_ErrorGradient(self, *args)

    def FirstLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (p2 - p1)/ v1 if the first point was a tangency point.

        """
        return _AppDef.AppDef_TheLeastSquares_FirstLambda(self, *args)

    def FunctionMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the function matrix used to approximate the set.

        """
        return _AppDef.AppDef_TheLeastSquares_FunctionMatrix(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_TheLeastSquares_IsDone(self, *args)

    def KIndex(self, *args):
        r"""
        Return
        -------
        math_IntegerVector

        Description
        -----------
        Returns the indexes of the first non null values of a and da. the values are non null from index(ieme point) +1 to index(ieme point) + degree +1.

        """
        return _AppDef.AppDef_TheLeastSquares_KIndex(self, *args)

    def LastLambda(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the value (pn - pn-1)/ vn if the last point was a tangency point.

        """
        return _AppDef.AppDef_TheLeastSquares_LastLambda(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        Parameters: math_Vector

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. the case 'curvaturepoint' is not treated in this method.

        Parameters
        ----------
        Parameters: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point.

        Parameters
        ----------
        Parameters: math_Vector
        V1t: math_Vector
        V2t: math_Vector
        V1c: math_Vector
        V2c: math_Vector
        l1: float
        l2: float

        Return
        -------
        None

        Description
        -----------
        Is used after having initialized the fields. <v1t> is the tangent vector at the first point. <v2t> is the tangent vector at the last point. <v1c> is the tangent vector at the first point. <v2c> is the tangent vector at the last point.

        """
        return _AppDef.AppDef_TheLeastSquares_Perform(self, *args)

    def Points(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of points value.

        """
        return _AppDef.AppDef_TheLeastSquares_Points(self, *args)

    def Poles(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the matrix of resulting control points value.

        """
        return _AppDef.AppDef_TheLeastSquares_Poles(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_TheLeastSquares

# Register AppDef_TheLeastSquares in _AppDef:
_AppDef.AppDef_TheLeastSquares_swigregister(AppDef_TheLeastSquares)
class AppDef_TheResol(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        SCurv: AppParCurves_MultiCurve
        FirstPoint: int
        LastPoint: int
        Constraints: AppParCurves_HArray1OfConstraintCouple
        Bern: math_Matrix
        DerivativeBern: math_Matrix
        Tolerance: float (optional, default to 1.0e-10)

        Return
        -------
        None

        Description
        -----------
        Given a multiline ssp with constraints points, this algorithm finds the best curve solution to approximate it. the poles from scurv issued for example from the least squares are used as a guess solution for the uzawa algorithm. the tolerance used in the uzawa algorithms is tolerance. a is the bernstein matrix associated to the multiline and da is the derivative bernstein matrix.(they can come from an approximation with parleastsquare.) the multicurve is modified. new multipoles are given.

        """
        _AppDef.AppDef_TheResol_swiginit(self, _AppDef.new_AppDef_TheResol(*args))

    def ConstraintDerivative(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        Parameters: math_Vector
        Deg: int
        DA: math_Matrix

        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the derivative of the constraint matrix.

        """
        return _AppDef.AppDef_TheResol_ConstraintDerivative(self, *args)

    def ConstraintMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_TheResol_ConstraintMatrix(self, *args)

    def Duale(self, *args):
        r"""
        Return
        -------
        math_Vector

        Description
        -----------
        Returns the duale variables of the system.

        """
        return _AppDef.AppDef_TheResol_Duale(self, *args)

    def InverseMatrix(self, *args):
        r"""
        Return
        -------
        math_Matrix

        Description
        -----------
        Returns the inverse of cont*transposed(cont), where cont is the constraint matrix for the algorithm.

        """
        return _AppDef.AppDef_TheResol_InverseMatrix(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if all has been correctly done.

        """
        return _AppDef.AppDef_TheResol_IsDone(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Error(self):
    	pass

    __swig_destroy__ = _AppDef.delete_AppDef_TheResol

# Register AppDef_TheResol in _AppDef:
_AppDef.AppDef_TheResol_swigregister(AppDef_TheResol)
class AppDef_Variational(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int
        TheConstraints: AppParCurves_HArray1OfConstraintCouple
        MaxDegree: int (optional, default to 14)
        MaxSegment: int (optional, default to 100)
        Continuity: GeomAbs_Shape (optional, default to GeomAbs_C2)
        WithMinMax: bool (optional, default to Standard_False)
        WithCutting: bool (optional, default to Standard_True)
        Tolerance: float (optional, default to 1.0)
        NbIterations: int (optional, default to 2)

        Return
        -------
        None

        Description
        -----------
        Constructor. initialization of the fields. warning: nc0: number of passagepoint consraints nc2: number of tangencypoint constraints nc3: number of curvaturepoint constraints if ((maxdegree-continuity)*maxsegment -nc0 - 2*nc1 -3*nc2) is negative the problem is over-constrained. //! limitation: the multiline from appdef has to be composed by only one line ( dimension 2 or 3).

        """
        _AppDef.AppDef_Variational_swiginit(self, _AppDef.new_AppDef_Variational(*args))

    def Approximate(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Makes the approximation with the current fields.

        """
        return _AppDef.AppDef_Variational_Approximate(self, *args)

    def AverageError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the average error between the multiline from appdef and the approximation.

        """
        return _AppDef.AppDef_Variational_AverageError(self, *args)

    def Continuity(self, *args):
        r"""
        Return
        -------
        GeomAbs_Shape

        Description
        -----------
        Returns the continuity used in the approximation.

        """
        return _AppDef.AppDef_Variational_Continuity(self, *args)

    def Criterium(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        VFirstOrder: float
        VSecondOrder: float
        VThirdOrder: float

        Description
        -----------
        Returns the values of the quality criterium.

        """
        return _AppDef.AppDef_Variational_Criterium(self, *args)

    def CriteriumWeight(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        Percent1: float
        Percent2: float
        Percent3: float

        Description
        -----------
        Returns the weights (as percent) associed to the criterium used in the optimization.

        """
        return _AppDef.AppDef_Variational_CriteriumWeight(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        mat: math_Matrix

        Return
        -------
        None

        Description
        -----------
        Returns the distances between the points of the multiline and the approximation curves.

        """
        return _AppDef.AppDef_Variational_Distance(self, *args)

    def DumpToString(self):
        r"""DumpToString(AppDef_Variational self) -> std::string"""
        return _AppDef.AppDef_Variational_DumpToString(self)

    def IsCreated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the creation is done and correspond to the current fields.

        """
        return _AppDef.AppDef_Variational_IsCreated(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the approximation is ok and correspond to the current fields.

        """
        return _AppDef.AppDef_Variational_IsDone(self, *args)

    def IsOverConstrained(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the problem is overconstrained in this case, approximation cannot be done.

        """
        return _AppDef.AppDef_Variational_IsOverConstrained(self, *args)

    def Knots(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        Description
        -----------
        Returns the knots uses to the approximations.

        """
        return _AppDef.AppDef_Variational_Knots(self, *args)

    def MaxDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the maximum degree used in the approximation.

        """
        return _AppDef.AppDef_Variational_MaxDegree(self, *args)

    def MaxError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the maximum of the distances between the points of the multiline and the approximation curves.

        """
        return _AppDef.AppDef_Variational_MaxError(self, *args)

    def MaxErrorIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the index of the multipoint of errormax.

        """
        return _AppDef.AppDef_Variational_MaxErrorIndex(self, *args)

    def MaxSegment(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the maximum of segment used in the approximation.

        """
        return _AppDef.AppDef_Variational_MaxSegment(self, *args)

    def NbIterations(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of iterations used in the approximation.

        """
        return _AppDef.AppDef_Variational_NbIterations(self, *args)

    def Parameters(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        Description
        -----------
        Returns the parameters uses to the approximations.

        """
        return _AppDef.AppDef_Variational_Parameters(self, *args)

    def QuadraticError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the quadratic average of the distances between the points of the multiline and the approximation curves.

        """
        return _AppDef.AppDef_Variational_QuadraticError(self, *args)

    def SetConstraints(self, *args):
        r"""

        Parameters
        ----------
        aConstrainst: AppParCurves_HArray1OfConstraintCouple

        Return
        -------
        bool

        Description
        -----------
        Define the constraints to approximate if this value is incompatible with the others fields this method modify nothing and returns false.

        """
        return _AppDef.AppDef_Variational_SetConstraints(self, *args)

    def SetContinuity(self, *args):
        r"""

        Parameters
        ----------
        C: GeomAbs_Shape

        Return
        -------
        bool

        Description
        -----------
        Define the continuity used in the approximation if this value is incompatible with the others fields this method modify nothing and returns false.

        """
        return _AppDef.AppDef_Variational_SetContinuity(self, *args)

    def SetCriteriumWeight(self, *args):
        r"""

        Parameters
        ----------
        Percent1: float
        Percent2: float
        Percent3: float

        Return
        -------
        None

        Description
        -----------
        Define the weights (as percent) associed to the criterium used in the optimization. //! if percent <= 0.

        Parameters
        ----------
        Order: int
        Percent: float

        Return
        -------
        None

        Description
        -----------
        Define the weight (as percent) associed to the criterium order used in the optimization: others weights are updated. if percent < 0 if order < 1 or order > 3.

        """
        return _AppDef.AppDef_Variational_SetCriteriumWeight(self, *args)

    def SetKnots(self, *args):
        r"""

        Parameters
        ----------
        knots: TColStd_HArray1OfReal

        Return
        -------
        bool

        Description
        -----------
        Defines the knots used by the approximations if this value is incompatible with the others fields this method modify nothing and returns false.

        """
        return _AppDef.AppDef_Variational_SetKnots(self, *args)

    def SetMaxDegree(self, *args):
        r"""

        Parameters
        ----------
        Degree: int

        Return
        -------
        bool

        Description
        -----------
        Define the maximum degree used in the approximation if this value is incompatible with the others fields this method modify nothing and returns false.

        """
        return _AppDef.AppDef_Variational_SetMaxDegree(self, *args)

    def SetMaxSegment(self, *args):
        r"""

        Parameters
        ----------
        NbSegment: int

        Return
        -------
        bool

        Description
        -----------
        Define the maximum number of segments used in the approximation if this value is incompatible with the others fields this method modify nothing and returns false.

        """
        return _AppDef.AppDef_Variational_SetMaxSegment(self, *args)

    def SetNbIterations(self, *args):
        r"""

        Parameters
        ----------
        Iter: int

        Return
        -------
        None

        Description
        -----------
        Define the number of iterations used in the approximation. if iter < 1.

        """
        return _AppDef.AppDef_Variational_SetNbIterations(self, *args)

    def SetParameters(self, *args):
        r"""

        Parameters
        ----------
        param: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        Defines the parameters used by the approximations.

        """
        return _AppDef.AppDef_Variational_SetParameters(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Define the tolerance used in the approximation.

        """
        return _AppDef.AppDef_Variational_SetTolerance(self, *args)

    def SetWithCutting(self, *args):
        r"""

        Parameters
        ----------
        Cutting: bool

        Return
        -------
        bool

        Description
        -----------
        Define if the approximation can insert new knots or not. if this value is incompatible with the others fields this method modify nothing and returns false.

        """
        return _AppDef.AppDef_Variational_SetWithCutting(self, *args)

    def SetWithMinMax(self, *args):
        r"""

        Parameters
        ----------
        MinMax: bool

        Return
        -------
        None

        Description
        -----------
        Define if the approximation search to minimize the maximum error or not.

        """
        return _AppDef.AppDef_Variational_SetWithMinMax(self, *args)

    def Tolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the tolerance used in the approximation.

        """
        return _AppDef.AppDef_Variational_Tolerance(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        AppParCurves_MultiBSpCurve

        Description
        -----------
        Returns all the bspline curves approximating the multiline from appdef ssp after minimization of the parameter.

        """
        return _AppDef.AppDef_Variational_Value(self, *args)

    def WithCutting(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns if the approximation can insert new knots or not.

        """
        return _AppDef.AppDef_Variational_WithCutting(self, *args)

    def WithMinMax(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns if the approximation search to minimize the maximum error or not.

        """
        return _AppDef.AppDef_Variational_WithMinMax(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_Variational

# Register AppDef_Variational in _AppDef:
_AppDef.AppDef_Variational_swigregister(AppDef_Variational)
class AppDef_LinearCriteria(AppDef_SmoothCriterion):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        SSP: AppDef_MultiLine
        FirstPoint: int
        LastPoint: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _AppDef.AppDef_LinearCriteria_swiginit(self, _AppDef.new_AppDef_LinearCriteria(*args))

    def GetEstLength(self):
        r"""GetEstLength(AppDef_LinearCriteria self) -> Standard_Real"""
        return _AppDef.AppDef_LinearCriteria_GetEstLength(self)

    def SetEstLength(self, value):
        r"""SetEstLength(AppDef_LinearCriteria self, Standard_Real value)"""
        return _AppDef.AppDef_LinearCriteria_SetEstLength(self, value)

    def SetWeight(self, *args):
        r"""

        Parameters
        ----------
        QuadraticWeight: float
        QualityWeight: float
        percentJ1: float
        percentJ2: float
        percentJ3: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        Weight: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _AppDef.AppDef_LinearCriteria_SetWeight(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_AppDef_LinearCriteria_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _AppDef.delete_AppDef_LinearCriteria

# Register AppDef_LinearCriteria in _AppDef:
_AppDef.AppDef_LinearCriteria_swigregister(AppDef_LinearCriteria)
class AppDef_HArray1OfMultiPointConstraint(AppDef_Array1OfMultiPointConstraint, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _AppDef.AppDef_HArray1OfMultiPointConstraint_swiginit(self, _AppDef.new_AppDef_HArray1OfMultiPointConstraint(*args))

    def Array1(self):
        return _AppDef.AppDef_HArray1OfMultiPointConstraint_Array1(self)

    def ChangeArray1(self):
        return _AppDef.AppDef_HArray1OfMultiPointConstraint_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_AppDef_HArray1OfMultiPointConstraint_DownCast(t)

    __swig_destroy__ = _AppDef.delete_AppDef_HArray1OfMultiPointConstraint

# Register AppDef_HArray1OfMultiPointConstraint in _AppDef:
_AppDef.AppDef_HArray1OfMultiPointConstraint_swigregister(AppDef_HArray1OfMultiPointConstraint)



@deprecated
def AppDef_MyLineTool_Curvature(*args):
	return AppDef_MyLineTool.Curvature(*args)

@deprecated
def AppDef_MyLineTool_Curvature(*args):
	return AppDef_MyLineTool.Curvature(*args)

@deprecated
def AppDef_MyLineTool_Curvature(*args):
	return AppDef_MyLineTool.Curvature(*args)

@deprecated
def AppDef_MyLineTool_FirstPoint(*args):
	return AppDef_MyLineTool.FirstPoint(*args)

@deprecated
def AppDef_MyLineTool_LastPoint(*args):
	return AppDef_MyLineTool.LastPoint(*args)

@deprecated
def AppDef_MyLineTool_MakeMLBetween(*args):
	return AppDef_MyLineTool.MakeMLBetween(*args)

@deprecated
def AppDef_MyLineTool_MakeMLOneMorePoint(*args):
	return AppDef_MyLineTool.MakeMLOneMorePoint(*args)

@deprecated
def AppDef_MyLineTool_NbP2d(*args):
	return AppDef_MyLineTool.NbP2d(*args)

@deprecated
def AppDef_MyLineTool_NbP3d(*args):
	return AppDef_MyLineTool.NbP3d(*args)

@deprecated
def AppDef_MyLineTool_Tangency(*args):
	return AppDef_MyLineTool.Tangency(*args)

@deprecated
def AppDef_MyLineTool_Tangency(*args):
	return AppDef_MyLineTool.Tangency(*args)

@deprecated
def AppDef_MyLineTool_Tangency(*args):
	return AppDef_MyLineTool.Tangency(*args)

@deprecated
def AppDef_MyLineTool_Value(*args):
	return AppDef_MyLineTool.Value(*args)

@deprecated
def AppDef_MyLineTool_Value(*args):
	return AppDef_MyLineTool.Value(*args)

@deprecated
def AppDef_MyLineTool_Value(*args):
	return AppDef_MyLineTool.Value(*args)

@deprecated
def AppDef_MyLineTool_WhatStatus(*args):
	return AppDef_MyLineTool.WhatStatus(*args)



