/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.idrange;

import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.owl.model.entity.EntityCreationPreferences;
import org.protege.editor.owl.model.idrange.IdRangesPolicy;
import org.protege.editor.owl.model.idrange.NoRangeForUserNameHandler;
import org.protege.editor.owl.model.idrange.NoRangeFoundForUserNamePanel;
import org.protege.editor.owl.model.idrange.UserIdRange;

public class NoRangeForUserNameHandlerUi
implements NoRangeForUserNameHandler {
    private static final String UPDATE = "Use Selected User";
    private static final String CANCEL = "Cancel";

    @Override
    public void handleNoRangeForUserName(@Nonnull String userName, @Nonnull IdRangesPolicy policy) {
        Frame owner = Arrays.stream(Frame.getFrames()).findFirst().orElse(null);
        NoRangeFoundForUserNamePanel userNamePanel = new NoRangeFoundForUserNamePanel();
        userNamePanel.setUserName(userName);
        userNamePanel.setIdRangesPolicy(policy);
        Object[] options = new Object[]{UPDATE, CANCEL};
        int ret = JOptionPaneEx.showConfirmDialog((Component)owner, (String)"No Id Range Found For Current User", (JComponent)userNamePanel, (int)-1, (int)2, (JComponent)userNamePanel, (Object[])options, (Object)UPDATE);
        if (ret != 0) {
            return;
        }
        userNamePanel.getSelectedRange().ifPresent(this::updateIdRange);
    }

    private void updateIdRange(@Nonnull UserIdRange rng) {
        EntityCreationPreferences.setAutoIDStart(rng.getIdRange().getLowerBound());
        EntityCreationPreferences.setAutoIDEnd(rng.getIdRange().getUpperBound());
    }
}

