#include "backend/drm/util.h"

#define PNP_ID(a, b, c) ((a & 0x1f) << 10) | ((b & 0x1f) << 5) | (c & 0x1f)
const char *get_pnp_manufacturer(const char code[static 3]) {
	switch (PNP_ID(code[0], code[1], code[2])) {
	case PNP_ID('A', 'A', 'A'): return "Avolites Ltd";
	case PNP_ID('A', 'A', 'E'): return "Anatek Electronics Inc.";
	case PNP_ID('A', 'A', 'M'): return "Aava Mobile Oy";
	case PNP_ID('A', 'A', 'N'): return "AAEON Technology Inc.";
	case PNP_ID('A', 'A', 'T'): return "Ann Arbor Technologies";
	case PNP_ID('A', 'B', 'A'): return "ABBAHOME INC.";
	case PNP_ID('A', 'B', 'C'): return "AboCom System Inc.";
	case PNP_ID('A', 'B', 'D'): return "Allen Bradley Company";
	case PNP_ID('A', 'B', 'E'): return "Alcatel Bell";
	case PNP_ID('A', 'B', 'O'): return "D-Link Systems Inc";
	case PNP_ID('A', 'B', 'S'): return "Abaco Systems, Inc.";
	case PNP_ID('A', 'B', 'T'): return "Anchor Bay Technologies, Inc.";
	case PNP_ID('A', 'B', 'V'): return "Advanced Research Technology";
	case PNP_ID('A', 'C', 'A'): return "Ariel Corporation";
	case PNP_ID('A', 'C', 'B'): return "Aculab Ltd";
	case PNP_ID('A', 'C', 'C'): return "Accton Technology Corporation";
	case PNP_ID('A', 'C', 'D'): return "AWETA BV";
	case PNP_ID('A', 'C', 'E'): return "Actek Engineering Pty Ltd";
	case PNP_ID('A', 'C', 'G'): return "A&R Cambridge Ltd.";
	case PNP_ID('A', 'C', 'H'): return "Archtek Telecom Corporation";
	case PNP_ID('A', 'C', 'I'): return "Ancor Communications Inc";
	case PNP_ID('A', 'C', 'K'): return "Acksys";
	case PNP_ID('A', 'C', 'L'): return "Apricot Computers";
	case PNP_ID('A', 'C', 'M'): return "Acroloop Motion Control Systems Inc";
	case PNP_ID('A', 'C', 'O'): return "Allion Computer Inc.";
	case PNP_ID('A', 'C', 'P'): return "Aspen Tech Inc";
	case PNP_ID('A', 'C', 'R'): return "Acer Technologies";
	case PNP_ID('A', 'C', 'S'): return "Altos Computer Systems";
	case PNP_ID('A', 'C', 'T'): return "Applied Creative Technology";
	case PNP_ID('A', 'C', 'U'): return "Acculogic";
	case PNP_ID('A', 'C', 'V'): return "ActivCard S.A";
	case PNP_ID('A', 'D', 'A'): return "Addi-Data GmbH";
	case PNP_ID('A', 'D', 'B'): return "Aldebbaron";
	case PNP_ID('A', 'D', 'C'): return "Acnhor Datacomm";
	case PNP_ID('A', 'D', 'D'): return "Advanced Peripheral Devices Inc";
	case PNP_ID('A', 'D', 'E'): return "Arithmos, Inc.";
	case PNP_ID('A', 'D', 'H'): return "Aerodata Holdings Ltd";
	case PNP_ID('A', 'D', 'I'): return "ADI Systems Inc";
	case PNP_ID('A', 'D', 'K'): return "Adtek System Science Company Ltd";
	case PNP_ID('A', 'D', 'L'): return "ASTRA Security Products Ltd";
	case PNP_ID('A', 'D', 'M'): return "Ad Lib MultiMedia Inc";
	case PNP_ID('A', 'D', 'N'): return "Analog & Digital Devices Tel. Inc";
	case PNP_ID('A', 'D', 'P'): return "Adaptec Inc";
	case PNP_ID('A', 'D', 'R'): return "Nasa Ames Research Center";
	case PNP_ID('A', 'D', 'S'): return "Analog Devices Inc";
	case PNP_ID('A', 'D', 'T'): return "Adtek";
	case PNP_ID('A', 'D', 'V'): return "Advanced Micro Devices Inc";
	case PNP_ID('A', 'D', 'X'): return "Adax Inc";
	case PNP_ID('A', 'D', 'Z'): return "ADDER TECHNOLOGY LTD";
	case PNP_ID('A', 'E', 'C'): return "Antex Electronics Corporation";
	case PNP_ID('A', 'E', 'D'): return "Advanced Electronic Designs, Inc.";
	case PNP_ID('A', 'E', 'I'): return "Actiontec Electric Inc";
	case PNP_ID('A', 'E', 'J'): return "Alpha Electronics Company";
	case PNP_ID('A', 'E', 'M'): return "ASEM S.p.A.";
	case PNP_ID('A', 'E', 'N'): return "Avencall";
	case PNP_ID('A', 'E', 'P'): return "Aetas Peripheral International";
	case PNP_ID('A', 'E', 'T'): return "Aethra Telecomunicazioni S.r.l.";
	case PNP_ID('A', 'F', 'A'): return "Alfa Inc";
	case PNP_ID('A', 'G', 'C'): return "Beijing Aerospace Golden Card Electronic Engineering Co.,Ltd.";
	case PNP_ID('A', 'G', 'I'): return "Artish Graphics Inc";
	case PNP_ID('A', 'G', 'L'): return "Argolis";
	case PNP_ID('A', 'G', 'M'): return "Advan Int'l Corporation";
	case PNP_ID('A', 'G', 'O'): return "AlgolTek, Inc.";
	case PNP_ID('A', 'G', 'T'): return "Agilent Technologies";
	case PNP_ID('A', 'H', 'C'): return "Advantech Co., Ltd.";
	case PNP_ID('A', 'H', 'Q'): return "Astro HQ LLC";
	case PNP_ID('A', 'H', 'S'): return "Beijing AnHeng SecoTech Information Technology Co., Ltd.";
	case PNP_ID('A', 'I', 'C'): return "Arnos Insturments & Computer Systems";
	case PNP_ID('A', 'I', 'E'): return "Altmann Industrieelektronik";
	case PNP_ID('A', 'I', 'I'): return "Amptron International Inc.";
	case PNP_ID('A', 'I', 'K'): return "Dongguan Alllike Electronics Co., Ltd.";
	case PNP_ID('A', 'I', 'L'): return "Altos India Ltd";
	case PNP_ID('A', 'I', 'M'): return "AIMS Lab Inc";
	case PNP_ID('A', 'I', 'R'): return "Advanced Integ. Research Inc";
	case PNP_ID('A', 'I', 'S'): return "Alien Internet Services";
	case PNP_ID('A', 'I', 'W'): return "Aiwa Company Ltd";
	case PNP_ID('A', 'I', 'X'): return "ALTINEX, INC.";
	case PNP_ID('A', 'J', 'A'): return "AJA Video Systems, Inc.";
	case PNP_ID('A', 'K', 'B'): return "Akebia Ltd";
	case PNP_ID('A', 'K', 'E'): return "AKAMI Electric Co.,Ltd";
	case PNP_ID('A', 'K', 'I'): return "AKIA Corporation";
	case PNP_ID('A', 'K', 'L'): return "AMiT Ltd";
	case PNP_ID('A', 'K', 'M'): return "Asahi Kasei Microsystems Company Ltd";
	case PNP_ID('A', 'K', 'P'): return "Atom Komplex Prylad";
	case PNP_ID('A', 'K', 'R'): return "Anker Innovations Limited";
	case PNP_ID('A', 'K', 'Y'): return "Askey Computer Corporation";
	case PNP_ID('A', 'L', 'A'): return "Alacron Inc";
	case PNP_ID('A', 'L', 'C'): return "Altec Corporation";
	case PNP_ID('A', 'L', 'D'): return "In4S Inc";
	case PNP_ID('A', 'L', 'E'): return "Alenco BV";
	case PNP_ID('A', 'L', 'G'): return "Realtek Semiconductor Corp.";
	case PNP_ID('A', 'L', 'H'): return "AL Systems";
	case PNP_ID('A', 'L', 'I'): return "Acer Labs";
	case PNP_ID('A', 'L', 'J'): return "Altec Lansing";
	case PNP_ID('A', 'L', 'K'): return "Acrolink Inc";
	case PNP_ID('A', 'L', 'L'): return "Alliance Semiconductor Corporation";
	case PNP_ID('A', 'L', 'M'): return "Acutec Ltd.";
	case PNP_ID('A', 'L', 'N'): return "Alana Technologies";
	case PNP_ID('A', 'L', 'O'): return "Algolith Inc.";
	case PNP_ID('A', 'L', 'P'): return "ALPS ALPINE CO., LTD.";
	case PNP_ID('A', 'L', 'R'): return "Advanced Logic";
	case PNP_ID('A', 'L', 'S'): return "Avance Logic Inc";
	case PNP_ID('A', 'L', 'T'): return "Altra";
	case PNP_ID('A', 'L', 'V'): return "AlphaView LCD";
	case PNP_ID('A', 'L', 'X'): return "ALEXON Co.,Ltd.";
	case PNP_ID('A', 'M', 'A'): return "Asia Microelectronic Development Inc";
	case PNP_ID('A', 'M', 'B'): return "Ambient Technologies, Inc.";
	case PNP_ID('A', 'M', 'C'): return "Attachmate Corporation";
	case PNP_ID('A', 'M', 'D'): return "Amdek Corporation";
	case PNP_ID('A', 'M', 'I'): return "American Megatrends Inc";
	case PNP_ID('A', 'M', 'L'): return "Anderson Multimedia Communications (HK) Limited";
	case PNP_ID('A', 'M', 'N'): return "Amimon LTD.";
	case PNP_ID('A', 'M', 'O'): return "Amino Technologies PLC and Amino Communications Limited";
	case PNP_ID('A', 'M', 'P'): return "AMP Inc";
	case PNP_ID('A', 'M', 'R'): return "AmTRAN Technology Co., Ltd.";
	case PNP_ID('A', 'M', 'S'): return "ARMSTEL, Inc.";
	case PNP_ID('A', 'M', 'T'): return "AMT International Industry";
	case PNP_ID('A', 'M', 'X'): return "AMX LLC";
	case PNP_ID('A', 'N', 'A'): return "Anakron";
	case PNP_ID('A', 'N', 'C'): return "Ancot";
	case PNP_ID('A', 'N', 'D'): return "Adtran Inc";
	case PNP_ID('A', 'N', 'I'): return "Anigma Inc";
	case PNP_ID('A', 'N', 'K'): return "Anko Electronic Company Ltd";
	case PNP_ID('A', 'N', 'L'): return "Analogix Semiconductor, Inc";
	case PNP_ID('A', 'N', 'O'): return "Anorad Corporation";
	case PNP_ID('A', 'N', 'P'): return "Andrew Network Production";
	case PNP_ID('A', 'N', 'R'): return "ANR Ltd";
	case PNP_ID('A', 'N', 'S'): return "Ansel Communication Company";
	case PNP_ID('A', 'N', 'T'): return "Ace CAD Enterprise Company Ltd";
	case PNP_ID('A', 'N', 'V'): return "Beijing ANTVR Technology Co., Ltd.";
	case PNP_ID('A', 'N', 'W'): return "Analog Way SAS";
	case PNP_ID('A', 'N', 'X'): return "Acer Netxus Inc";
	case PNP_ID('A', 'O', 'A'): return "AOpen Inc.";
	case PNP_ID('A', 'O', 'E'): return "Advanced Optics Electronics, Inc.";
	case PNP_ID('A', 'O', 'L'): return "America OnLine";
	case PNP_ID('A', 'O', 'T'): return "Alcatel";
	case PNP_ID('A', 'P', 'C'): return "American Power Conversion";
	case PNP_ID('A', 'P', 'D'): return "AppliAdata";
	case PNP_ID('A', 'P', 'E'): return "ALPS ALPINE CO., LTD.";
	case PNP_ID('A', 'P', 'G'): return "Horner Electric Inc";
	case PNP_ID('A', 'P', 'I'): return "A Plus Info Corporation";
	case PNP_ID('A', 'P', 'L'): return "Aplicom Oy";
	case PNP_ID('A', 'P', 'M'): return "Applied Memory Tech";
	case PNP_ID('A', 'P', 'N'): return "Appian Tech Inc";
	case PNP_ID('A', 'P', 'P'): return "Apple Computer Inc";
	case PNP_ID('A', 'P', 'R'): return "Aprilia s.p.a.";
	case PNP_ID('A', 'P', 'S'): return "Autologic Inc";
	case PNP_ID('A', 'P', 'T'): return "Audio Processing Technology  Ltd";
	case PNP_ID('A', 'P', 'V'): return "A+V Link";
	case PNP_ID('A', 'P', 'X'): return "AP Designs Ltd";
	case PNP_ID('A', 'R', 'C'): return "Alta Research Corporation";
	case PNP_ID('A', 'R', 'D'): return "AREC Inc.";
	case PNP_ID('A', 'R', 'E'): return "ICET S.p.A.";
	case PNP_ID('A', 'R', 'G'): return "Argus Electronics Co., LTD";
	case PNP_ID('A', 'R', 'I'): return "Argosy Research Inc";
	case PNP_ID('A', 'R', 'K'): return "Ark Logic Inc";
	case PNP_ID('A', 'R', 'L'): return "Arlotto Comnet Inc";
	case PNP_ID('A', 'R', 'M'): return "Arima";
	case PNP_ID('A', 'R', 'O'): return "Poso International B.V.";
	case PNP_ID('A', 'R', 'R'): return "ARRIS Group, Inc.";
	case PNP_ID('A', 'R', 'S'): return "Arescom Inc";
	case PNP_ID('A', 'R', 'T'): return "Corion Industrial Corporation";
	case PNP_ID('A', 'S', 'C'): return "Ascom Strategic Technology Unit";
	case PNP_ID('A', 'S', 'D'): return "USC Information Sciences Institute";
	case PNP_ID('A', 'S', 'E'): return "AseV Display Labs";
	case PNP_ID('A', 'S', 'H'): return "Ashton Bentley Concepts";
	case PNP_ID('A', 'S', 'I'): return "Ahead Systems";
	case PNP_ID('A', 'S', 'K'): return "Ask A/S";
	case PNP_ID('A', 'S', 'L'): return "AccuScene Corporation Ltd";
	case PNP_ID('A', 'S', 'M'): return "ASEM S.p.A.";
	case PNP_ID('A', 'S', 'N'): return "Asante Tech Inc";
	case PNP_ID('A', 'S', 'P'): return "ASP Microelectronics Ltd";
	case PNP_ID('A', 'S', 'T'): return "AST Research Inc";
	case PNP_ID('A', 'S', 'U'): return "Asuscom Network Inc";
	case PNP_ID('A', 'S', 'X'): return "AudioScience";
	case PNP_ID('A', 'S', 'Y'): return "Rockwell Collins / Airshow Systems";
	case PNP_ID('A', 'T', 'A'): return "Allied Telesyn International (Asia) Pte Ltd";
	case PNP_ID('A', 'T', 'C'): return "Ably-Tech Corporation";
	case PNP_ID('A', 'T', 'D'): return "Alpha Telecom Inc";
	case PNP_ID('A', 'T', 'E'): return "Innovate Ltd";
	case PNP_ID('A', 'T', 'H'): return "Athena Informatica S.R.L.";
	case PNP_ID('A', 'T', 'I'): return "Allied Telesis KK";
	case PNP_ID('A', 'T', 'J'): return "ArchiTek Corporation";
	case PNP_ID('A', 'T', 'K'): return "Allied Telesyn Int'l";
	case PNP_ID('A', 'T', 'L'): return "Arcus Technology Ltd";
	case PNP_ID('A', 'T', 'M'): return "ATM Ltd";
	case PNP_ID('A', 'T', 'N'): return "Athena Smartcard Solutions Ltd.";
	case PNP_ID('A', 'T', 'O'): return "ASTRO DESIGN, INC.";
	case PNP_ID('A', 'T', 'P'): return "Alpha-Top Corporation";
	case PNP_ID('A', 'T', 'T'): return "AT&T";
	case PNP_ID('A', 'T', 'U'): return "Avocor Technologies USA, Inc";
	case PNP_ID('A', 'T', 'V'): return "Office Depot, Inc.";
	case PNP_ID('A', 'T', 'X'): return "Athenix Corporation";
	case PNP_ID('A', 'U', 'D'): return "AudioControl";
	case PNP_ID('A', 'U', 'G'): return "August Home, Inc.";
	case PNP_ID('A', 'U', 'I'): return "ALPS ALPINE CO., LTD.";
	case PNP_ID('A', 'U', 'O'): return "AU Optronics";
	case PNP_ID('A', 'U', 'R'): return "Aureal Semiconductor";
	case PNP_ID('A', 'U', 'S'): return "ASUSTek COMPUTER INC";
	case PNP_ID('A', 'U', 'T'): return "Autotime Corporation";
	case PNP_ID('A', 'U', 'V'): return "Auvidea GmbH";
	case PNP_ID('A', 'V', 'A'): return "Avaya Communication";
	case PNP_ID('A', 'V', 'C'): return "Auravision Corporation";
	case PNP_ID('A', 'V', 'D'): return "Avid Electronics Corporation";
	case PNP_ID('A', 'V', 'E'): return "Add Value Enterpises (Asia) Pte Ltd";
	case PNP_ID('A', 'V', 'G'): return "Avegant Corporation";
	case PNP_ID('A', 'V', 'I'): return "Nippon Avionics Co.,Ltd";
	case PNP_ID('A', 'V', 'J'): return "Atelier Vision Corporation";
	case PNP_ID('A', 'V', 'L'): return "Avalue Technology Inc.";
	case PNP_ID('A', 'V', 'M'): return "AVM GmbH";
	case PNP_ID('A', 'V', 'N'): return "Advance Computer Corporation";
	case PNP_ID('A', 'V', 'O'): return "Avocent Corporation";
	case PNP_ID('A', 'V', 'R'): return "AVer Information Inc.";
	case PNP_ID('A', 'V', 'S'): return "Avatron Software Inc.";
	case PNP_ID('A', 'V', 'T'): return "Avtek (Electronics) Pty Ltd";
	case PNP_ID('A', 'V', 'V'): return "SBS Technologies (Canada), Inc. (was Avvida Systems, Inc.)";
	case PNP_ID('A', 'V', 'X'): return "A/Vaux Electronics";
	case PNP_ID('A', 'W', 'C'): return "Access Works Comm Inc";
	case PNP_ID('A', 'W', 'L'): return "Aironet Wireless Communications, Inc";
	case PNP_ID('A', 'W', 'S'): return "Wave Systems";
	case PNP_ID('A', 'X', 'B'): return "Adrienne Electronics Corporation";
	case PNP_ID('A', 'X', 'C'): return "AXIOMTEK CO., LTD.";
	case PNP_ID('A', 'X', 'E'): return "Axell Corporation";
	case PNP_ID('A', 'X', 'I'): return "American Magnetics";
	case PNP_ID('A', 'X', 'L'): return "Axel";
	case PNP_ID('A', 'X', 'O'): return "Axonic Labs LLC";
	case PNP_ID('A', 'X', 'P'): return "American Express";
	case PNP_ID('A', 'X', 'T'): return "Axtend Technologies Inc";
	case PNP_ID('A', 'X', 'X'): return "Axxon Computer Corporation";
	case PNP_ID('A', 'X', 'Y'): return "AXYZ Automation Services, Inc";
	case PNP_ID('A', 'Y', 'D'): return "Aydin Displays";
	case PNP_ID('A', 'Y', 'R'): return "Airlib, Inc";
	case PNP_ID('A', 'Z', 'H'): return "Shenzhen three Connaught Information Technology Co., Ltd. (3nod Group)";
	case PNP_ID('A', 'Z', 'M'): return "AZ Middelheim - Radiotherapy";
	case PNP_ID('A', 'Z', 'T'): return "Aztech Systems Ltd";
	case PNP_ID('B', 'A', 'C'): return "Biometric Access Corporation";
	case PNP_ID('B', 'A', 'N'): return "Banyan";
	case PNP_ID('B', 'B', 'B'): return "an-najah university";
	case PNP_ID('B', 'B', 'H'): return "B&Bh";
	case PNP_ID('B', 'B', 'L'): return "Brain Boxes Limited";
	case PNP_ID('B', 'B', 'V'): return "BlueBox Video Limited";
	case PNP_ID('B', 'B', 'X'): return "Black Box Corporation";
	case PNP_ID('B', 'C', 'C'): return "Beaver Computer Corporaton";
	case PNP_ID('B', 'C', 'D'): return "Barco GmbH";
	case PNP_ID('B', 'C', 'I'): return "Broadata Communications Inc.";
	case PNP_ID('B', 'C', 'K'): return "Beck GmbH & Co. Elektronik Bauelemente KG";
	case PNP_ID('B', 'C', 'M'): return "Broadcom";
	case PNP_ID('B', 'C', 'Q'): return "Deutsche Telekom Berkom GmbH";
	case PNP_ID('B', 'C', 'S'): return "Booria CAD/CAM systems";
	case PNP_ID('B', 'D', 'O'): return "Brahler ICS";
	case PNP_ID('B', 'D', 'R'): return "Blonder Tongue Labs, Inc.";
	case PNP_ID('B', 'D', 'S'): return "Barco Display Systems";
	case PNP_ID('B', 'E', 'C'): return "Beckhoff Automation";
	case PNP_ID('B', 'E', 'I'): return "Beckworth Enterprises Inc";
	case PNP_ID('B', 'E', 'K'): return "Beko Elektronik A.S.";
	case PNP_ID('B', 'E', 'L'): return "Beltronic Industrieelektronik GmbH";
	case PNP_ID('B', 'E', 'O'): return "Baug & Olufsen";
	case PNP_ID('B', 'F', 'E'): return "B.F. Engineering Corporation";
	case PNP_ID('B', 'G', 'B'): return "Barco Graphics N.V";
	case PNP_ID('B', 'G', 'T'): return "Budzetron Inc";
	case PNP_ID('B', 'H', 'Z'): return "BitHeadz, Inc.";
	case PNP_ID('B', 'I', 'A'): return "Biamp Systems Corporation";
	case PNP_ID('B', 'I', 'C'): return "Big Island Communications";
	case PNP_ID('B', 'I', 'G'): return "Bigscreen, Inc.";
	case PNP_ID('B', 'I', 'I'): return "Boeckeler Instruments Inc";
	case PNP_ID('B', 'I', 'L'): return "Billion Electric Company Ltd";
	case PNP_ID('B', 'I', 'O'): return "BioLink Technologies International, Inc.";
	case PNP_ID('B', 'I', 'T'): return "Bit 3 Computer";
	case PNP_ID('B', 'L', 'D'): return "BILD INNOVATIVE TECHNOLOGY LLC";
	case PNP_ID('B', 'L', 'I'): return "Busicom";
	case PNP_ID('B', 'L', 'N'): return "BioLink Technologies";
	case PNP_ID('B', 'L', 'P'): return "Bloomberg L.P.";
	case PNP_ID('B', 'M', 'D'): return "Blackmagic Design";
	case PNP_ID('B', 'M', 'I'): return "Benson Medical Instruments Company";
	case PNP_ID('B', 'M', 'L'): return "BIOMED Lab";
	case PNP_ID('B', 'M', 'S'): return "BIOMEDISYS";
	case PNP_ID('B', 'N', 'E'): return "Bull AB";
	case PNP_ID('B', 'N', 'K'): return "Banksia Tech Pty Ltd";
	case PNP_ID('B', 'N', 'O'): return "Bang & Olufsen";
	case PNP_ID('B', 'N', 'S'): return "Boulder Nonlinear Systems";
	case PNP_ID('B', 'O', 'B'): return "Rainy Orchard";
	case PNP_ID('B', 'O', 'E'): return "BOE";
	case PNP_ID('B', 'O', 'I'): return "NINGBO BOIGLE DIGITAL TECHNOLOGY CO.,LTD";
	case PNP_ID('B', 'O', 'S'): return "BOS";
	case PNP_ID('B', 'P', 'D'): return "Micro Solutions, Inc.";
	case PNP_ID('B', 'P', 'S'): return "Barco, N.V.";
	case PNP_ID('B', 'P', 'U'): return "Best Power";
	case PNP_ID('B', 'R', 'A'): return "Braemac Pty Ltd";
	case PNP_ID('B', 'R', 'C'): return "BARC";
	case PNP_ID('B', 'R', 'G'): return "Bridge Information Co., Ltd";
	case PNP_ID('B', 'R', 'I'): return "Boca Research Inc";
	case PNP_ID('B', 'R', 'L'): return "Brainlab AG";
	case PNP_ID('B', 'R', 'M'): return "Braemar Inc";
	case PNP_ID('B', 'R', 'O'): return "BROTHER INDUSTRIES,LTD.";
	case PNP_ID('B', 'S', 'E'): return "Bose Corporation";
	case PNP_ID('B', 'S', 'G'): return "Robert Bosch GmbH";
	case PNP_ID('B', 'S', 'L'): return "Biomedical Systems Laboratory";
	case PNP_ID('B', 'S', 'N'): return "BRIGHTSIGN, LLC";
	case PNP_ID('B', 'S', 'T'): return "BodySound Technologies, Inc.";
	case PNP_ID('B', 'T', 'C'): return "Bit 3 Computer";
	case PNP_ID('B', 'T', 'E'): return "Brilliant Technology";
	case PNP_ID('B', 'T', 'F'): return "Bitfield Oy";
	case PNP_ID('B', 'T', 'I'): return "BusTech Inc";
	case PNP_ID('B', 'T', 'O'): return "BioTao Ltd";
	case PNP_ID('B', 'U', 'F'): return "Yasuhiko Shirai Melco Inc";
	case PNP_ID('B', 'U', 'G'): return "B.U.G., Inc.";
	case PNP_ID('B', 'U', 'J'): return "ATI Tech Inc";
	case PNP_ID('B', 'U', 'L'): return "Bull";
	case PNP_ID('B', 'U', 'R'): return "B&R Industrial Automation GmbH";
	case PNP_ID('B', 'U', 'S'): return "BusTek";
	case PNP_ID('B', 'U', 'T'): return "21ST CENTURY ENTERTAINMENT";
	case PNP_ID('B', 'W', 'K'): return "Bitworks Inc.";
	case PNP_ID('B', 'X', 'E'): return "Buxco Electronics";
	case PNP_ID('B', 'Y', 'D'): return "byd:sign corporation";
	case PNP_ID('C', 'A', 'A'): return "Castles Automation Co., Ltd";
	case PNP_ID('C', 'A', 'C'): return "CA & F Elettronica";
	case PNP_ID('C', 'A', 'G'): return "CalComp";
	case PNP_ID('C', 'A', 'I'): return "Canon Inc.";
	case PNP_ID('C', 'A', 'L'): return "Acon";
	case PNP_ID('C', 'A', 'M'): return "Cambridge Audio";
	case PNP_ID('C', 'A', 'N'): return "Canopus Company Ltd";
	case PNP_ID('C', 'A', 'R'): return "Cardinal Company Ltd";
	case PNP_ID('C', 'A', 'S'): return "CASIO COMPUTER CO.,LTD";
	case PNP_ID('C', 'A', 'T'): return "Consultancy in Advanced Technology";
	case PNP_ID('C', 'A', 'V'): return "Cavium Networks, Inc";
	case PNP_ID('C', 'B', 'I'): return "ComputerBoards Inc";
	case PNP_ID('C', 'B', 'R'): return "Cebra Tech A/S";
	case PNP_ID('C', 'B', 'T'): return "Cabletime Ltd";
	case PNP_ID('C', 'B', 'X'): return "Cybex Computer Products Corporation";
	case PNP_ID('C', 'C', 'C'): return "C-Cube Microsystems";
	case PNP_ID('C', 'C', 'I'): return "Cache";
	case PNP_ID('C', 'C', 'J'): return "CONTEC CO.,LTD.";
	case PNP_ID('C', 'C', 'L'): return "CCL/ITRI";
	case PNP_ID('C', 'C', 'P'): return "Capetronic USA Inc";
	case PNP_ID('C', 'D', 'C'): return "Core Dynamics Corporation";
	case PNP_ID('C', 'D', 'D'): return "Convergent Data Devices";
	case PNP_ID('C', 'D', 'E'): return "Colin.de";
	case PNP_ID('C', 'D', 'G'): return "Christie Digital Systems Inc";
	case PNP_ID('C', 'D', 'I'): return "Concept Development Inc";
	case PNP_ID('C', 'D', 'K'): return "Cray Communications";
	case PNP_ID('C', 'D', 'N'): return "Codenoll Technical Corporation";
	case PNP_ID('C', 'D', 'P'): return "CalComp";
	case PNP_ID('C', 'D', 'S'): return "Computer Diagnostic Systems";
	case PNP_ID('C', 'D', 'T'): return "IBM Corporation";
	case PNP_ID('C', 'D', 'V'): return "Convergent Design Inc.";
	case PNP_ID('C', 'E', 'A'): return "Consumer Electronics Association";
	case PNP_ID('C', 'E', 'C'): return "Chicony Electronics Company Ltd";
	case PNP_ID('C', 'E', 'D'): return "Cambridge Electronic Design Ltd";
	case PNP_ID('C', 'E', 'F'): return "Cefar Digital Vision";
	case PNP_ID('C', 'E', 'I'): return "Crestron Electronics, Inc.";
	case PNP_ID('C', 'E', 'M'): return "MEC Electronics GmbH";
	case PNP_ID('C', 'E', 'N'): return "Centurion Technologies P/L";
	case PNP_ID('C', 'E', 'P'): return "C-DAC";
	case PNP_ID('C', 'E', 'R'): return "Ceronix";
	case PNP_ID('C', 'E', 'T'): return "TEC CORPORATION";
	case PNP_ID('C', 'F', 'G'): return "Atlantis";
	case PNP_ID('C', 'F', 'R'): return "Meta View, Inc.";
	case PNP_ID('C', 'G', 'A'): return "Chunghwa Picture Tubes, LTD";
	case PNP_ID('C', 'G', 'S'): return "Chyron Corp";
	case PNP_ID('C', 'G', 'T'): return "congatec AG";
	case PNP_ID('C', 'H', 'A'): return "Chase Research PLC";
	case PNP_ID('C', 'H', 'D'): return "ChangHong Electric Co.,Ltd";
	case PNP_ID('C', 'H', 'E'): return "Acer Inc";
	case PNP_ID('C', 'H', 'G'): return "Sichuan Changhong Electric CO, LTD.";
	case PNP_ID('C', 'H', 'I'): return "Chrontel Inc";
	case PNP_ID('C', 'H', 'L'): return "Chloride-R&D";
	case PNP_ID('C', 'H', 'M'): return "CHIC TECHNOLOGY CORP.";
	case PNP_ID('C', 'H', 'O'): return "Sichuang Changhong Corporation";
	case PNP_ID('C', 'H', 'P'): return "CH Products";
	case PNP_ID('C', 'H', 'R'): return "christmann informationstechnik + medien GmbH & Co. KG";
	case PNP_ID('C', 'H', 'S'): return "Agentur Chairos";
	case PNP_ID('C', 'H', 'T'): return "Chunghwa Picture Tubes,LTD.";
	case PNP_ID('C', 'H', 'Y'): return "Cherry GmbH";
	case PNP_ID('C', 'I', 'C'): return "Comm. Intelligence Corporation";
	case PNP_ID('C', 'I', 'E'): return "Convergent Engineering, Inc.";
	case PNP_ID('C', 'I', 'I'): return "Cromack Industries Inc";
	case PNP_ID('C', 'I', 'L'): return "Citicom Infotech Private Limited";
	case PNP_ID('C', 'I', 'N'): return "Citron GmbH";
	case PNP_ID('C', 'I', 'P'): return "Ciprico Inc";
	case PNP_ID('C', 'I', 'R'): return "Cirrus Logic Inc";
	case PNP_ID('C', 'I', 'S'): return "Cisco Systems Inc";
	case PNP_ID('C', 'I', 'T'): return "Citifax Limited";
	case PNP_ID('C', 'K', 'C'): return "The Concept Keyboard Company Ltd";
	case PNP_ID('C', 'K', 'J'): return "Carina System Co., Ltd.";
	case PNP_ID('C', 'L', 'A'): return "Clarion Company Ltd";
	case PNP_ID('C', 'L', 'D'): return "COMMAT L.t.d.";
	case PNP_ID('C', 'L', 'E'): return "Classe Audio";
	case PNP_ID('C', 'L', 'G'): return "CoreLogic";
	case PNP_ID('C', 'L', 'I'): return "Cirrus Logic Inc";
	case PNP_ID('C', 'L', 'M'): return "CrystaLake Multimedia";
	case PNP_ID('C', 'L', 'O'): return "Clone Computers";
	case PNP_ID('C', 'L', 'R'): return "Clover Electronics";
	case PNP_ID('C', 'L', 'T'): return "automated computer control systems";
	case PNP_ID('C', 'L', 'V'): return "Clevo Company";
	case PNP_ID('C', 'L', 'X'): return "CardLogix";
	case PNP_ID('C', 'M', 'C'): return "CMC Ltd";
	case PNP_ID('C', 'M', 'D'): return "Colorado MicroDisplay, Inc.";
	case PNP_ID('C', 'M', 'G'): return "Chenming Mold Ind. Corp.";
	case PNP_ID('C', 'M', 'I'): return "C-Media Electronics";
	case PNP_ID('C', 'M', 'K'): return "Comark LLC";
	case PNP_ID('C', 'M', 'M'): return "Comtime GmbH";
	case PNP_ID('C', 'M', 'N'): return "Chimei Innolux Corporation";
	case PNP_ID('C', 'M', 'O'): return "Chi Mei Optoelectronics corp.";
	case PNP_ID('C', 'M', 'R'): return "Cambridge Research Systems Ltd";
	case PNP_ID('C', 'M', 'S'): return "CompuMaster Srl";
	case PNP_ID('C', 'M', 'X'): return "Comex Electronics AB";
	case PNP_ID('C', 'N', 'B'): return "American Power Conversion";
	case PNP_ID('C', 'N', 'C'): return "Alvedon Computers Ltd";
	case PNP_ID('C', 'N', 'D'): return "Micro-Star Int'l Co., Ltd.";
	case PNP_ID('C', 'N', 'E'): return "Cine-tal";
	case PNP_ID('C', 'N', 'I'): return "Connect Int'l A/S";
	case PNP_ID('C', 'N', 'N'): return "Canon Inc";
	case PNP_ID('C', 'N', 'T'): return "COINT Multimedia Systems";
	case PNP_ID('C', 'O', 'B'): return "COBY Electronics Co., Ltd";
	case PNP_ID('C', 'O', 'D'): return "CODAN Pty. Ltd.";
	case PNP_ID('C', 'O', 'I'): return "Codec Inc.";
	case PNP_ID('C', 'O', 'L'): return "Rockwell Collins, Inc.";
	case PNP_ID('C', 'O', 'M'): return "Comtrol Corporation";
	case PNP_ID('C', 'O', 'N'): return "Contec Company Ltd";
	case PNP_ID('C', 'O', 'O'): return "coolux GmbH";
	case PNP_ID('C', 'O', 'R'): return "Corollary Inc";
	case PNP_ID('C', 'O', 'S'): return "CoStar Corporation";
	case PNP_ID('C', 'O', 'T'): return "Core Technology Inc";
	case PNP_ID('C', 'O', 'W'): return "Polycow Productions";
	case PNP_ID('C', 'O', 'X'): return "Comrex";
	case PNP_ID('C', 'P', 'C'): return "Ciprico Inc";
	case PNP_ID('C', 'P', 'D'): return "CompuAdd";
	case PNP_ID('C', 'P', 'I'): return "Computer Peripherals Inc";
	case PNP_ID('C', 'P', 'L'): return "Compal Electronics Inc";
	case PNP_ID('C', 'P', 'M'): return "Capella Microsystems Inc.";
	case PNP_ID('C', 'P', 'P'): return "Compound Photonics";
	case PNP_ID('C', 'P', 'Q'): return "Compaq Computer Company";
	case PNP_ID('C', 'P', 'T'): return "cPATH";
	case PNP_ID('C', 'P', 'X'): return "Powermatic Data Systems";
	case PNP_ID('C', 'R', 'A'): return "CRALTECH ELECTRONICA, S.L.";
	case PNP_ID('C', 'R', 'C'): return "CONRAC GmbH";
	case PNP_ID('C', 'R', 'D'): return "Cardinal Technical Inc";
	case PNP_ID('C', 'R', 'E'): return "Creative Labs Inc";
	case PNP_ID('C', 'R', 'H'): return "Contemporary Research Corp.";
	case PNP_ID('C', 'R', 'I'): return "Crio Inc.";
	case PNP_ID('C', 'R', 'L'): return "Creative Logic";
	case PNP_ID('C', 'R', 'M'): return "CORSAIR MEMORY Inc.";
	case PNP_ID('C', 'R', 'N'): return "Cornerstone Imaging";
	case PNP_ID('C', 'R', 'O'): return "Extraordinary Technologies PTY Limited";
	case PNP_ID('C', 'R', 'Q'): return "Cirque Corporation";
	case PNP_ID('C', 'R', 'S'): return "Crescendo Communication Inc";
	case PNP_ID('C', 'R', 'V'): return "Cerevo Inc.";
	case PNP_ID('C', 'R', 'W'): return "Cammegh Limited";
	case PNP_ID('C', 'R', 'X'): return "Cyrix Corporation";
	case PNP_ID('C', 'S', 'B'): return "Transtex SA";
	case PNP_ID('C', 'S', 'C'): return "Crystal Semiconductor";
	case PNP_ID('C', 'S', 'D'): return "Cresta Systems Inc";
	case PNP_ID('C', 'S', 'E'): return "Concept Solutions & Engineering";
	case PNP_ID('C', 'S', 'I'): return "Cabletron System Inc";
	case PNP_ID('C', 'S', 'L'): return "Cloudium Systems Ltd.";
	case PNP_ID('C', 'S', 'M'): return "Cosmic Engineering Inc.";
	case PNP_ID('C', 'S', 'O'): return "California Institute of Technology";
	case PNP_ID('C', 'S', 'S'): return "CSS Laboratories";
	case PNP_ID('C', 'S', 'T'): return "CSTI Inc";
	case PNP_ID('C', 'S', 'W'): return "China Star Optoelectronics Technology Co., Ltd";
	case PNP_ID('C', 'T', 'A'): return "CoSystems Inc";
	case PNP_ID('C', 'T', 'C'): return "CTC Communication Development Company Ltd";
	case PNP_ID('C', 'T', 'E'): return "Chunghwa Telecom Co., Ltd.";
	case PNP_ID('C', 'T', 'L'): return "Creative Technology Ltd";
	case PNP_ID('C', 'T', 'M'): return "Computerm Corporation";
	case PNP_ID('C', 'T', 'N'): return "Computone Products";
	case PNP_ID('C', 'T', 'P'): return "Computer Technology Corporation";
	case PNP_ID('C', 'T', 'R'): return "Control4 Corporation";
	case PNP_ID('C', 'T', 'S'): return "Comtec Systems Co., Ltd.";
	case PNP_ID('C', 'T', 'X'): return "Creatix Polymedia GmbH";
	case PNP_ID('C', 'U', 'B'): return "Cubix Corporation";
	case PNP_ID('C', 'U', 'K'): return "Calibre UK Ltd";
	case PNP_ID('C', 'V', 'A'): return "Covia Inc.";
	case PNP_ID('C', 'V', 'I'): return "Colorado Video, Inc.";
	case PNP_ID('C', 'V', 'P'): return "Chromatec Video Products Ltd";
	case PNP_ID('C', 'V', 'S'): return "Clarity Visual Systems";
	case PNP_ID('C', 'W', 'C'): return "Curtiss-Wright Controls, Inc.";
	case PNP_ID('C', 'W', 'R'): return "Connectware Inc";
	case PNP_ID('C', 'X', 'T'): return "Conexant Systems";
	case PNP_ID('C', 'Y', 'B'): return "CyberVision";
	case PNP_ID('C', 'Y', 'C'): return "Cylink Corporation";
	case PNP_ID('C', 'Y', 'D'): return "Cyclades Corporation";
	case PNP_ID('C', 'Y', 'L'): return "Cyberlabs";
	case PNP_ID('C', 'Y', 'P'): return "CYPRESS SEMICONDUCTOR CORPORATION";
	case PNP_ID('C', 'Y', 'T'): return "Cytechinfo Inc";
	case PNP_ID('C', 'Y', 'V'): return "Cyviz AS";
	case PNP_ID('C', 'Y', 'W'): return "Cyberware";
	case PNP_ID('C', 'Y', 'X'): return "Cyrix Corporation";
	case PNP_ID('C', 'Z', 'C'): return "Shenzhen ChuangZhiCheng Technology Co., Ltd.";
	case PNP_ID('C', 'Z', 'E'): return "Carl Zeiss AG";
	case PNP_ID('D', 'A', 'C'): return "Digital Acoustics Corporation";
	case PNP_ID('D', 'A', 'E'): return "Digatron Industrie Elektronik GmbH";
	case PNP_ID('D', 'A', 'I'): return "DAIS SET Ltd.";
	case PNP_ID('D', 'A', 'K'): return "Daktronics";
	case PNP_ID('D', 'A', 'L'): return "Digital Audio Labs Inc";
	case PNP_ID('D', 'A', 'N'): return "Danelec Marine A/S";
	case PNP_ID('D', 'A', 'S'): return "DAVIS AS";
	case PNP_ID('D', 'A', 'T'): return "Datel Inc";
	case PNP_ID('D', 'A', 'U'): return "Daou Tech Inc";
	case PNP_ID('D', 'A', 'V'): return "Davicom Semiconductor Inc";
	case PNP_ID('D', 'A', 'W'): return "DA2 Technologies Inc";
	case PNP_ID('D', 'A', 'X'): return "Data Apex Ltd";
	case PNP_ID('D', 'B', 'D'): return "Diebold Inc.";
	case PNP_ID('D', 'B', 'I'): return "DigiBoard Inc";
	case PNP_ID('D', 'B', 'K'): return "Databook Inc";
	case PNP_ID('D', 'B', 'L'): return "Doble Engineering Company";
	case PNP_ID('D', 'B', 'N'): return "DB Networks Inc";
	case PNP_ID('D', 'C', 'A'): return "Digital Communications Association";
	case PNP_ID('D', 'C', 'C'): return "Dale Computer Corporation";
	case PNP_ID('D', 'C', 'D'): return "Datacast LLC";
	case PNP_ID('D', 'C', 'E'): return "dSPACE GmbH";
	case PNP_ID('D', 'C', 'I'): return "Concepts Inc";
	case PNP_ID('D', 'C', 'L'): return "Dynamic Controls Ltd";
	case PNP_ID('D', 'C', 'M'): return "DCM Data Products";
	case PNP_ID('D', 'C', 'O'): return "Dialogue Technology Corporation";
	case PNP_ID('D', 'C', 'R'): return "Decros Ltd";
	case PNP_ID('D', 'C', 'S'): return "Diamond Computer Systems Inc";
	case PNP_ID('D', 'C', 'T'): return "Dancall Telecom A/S";
	case PNP_ID('D', 'C', 'V'): return "Datatronics Technology Inc";
	case PNP_ID('D', 'D', 'A'): return "DA2 Technologies Corporation";
	case PNP_ID('D', 'D', 'D'): return "Danka Data Devices";
	case PNP_ID('D', 'D', 'E'): return "Datasat Digital Entertainment";
	case PNP_ID('D', 'D', 'I'): return "Data Display AG";
	case PNP_ID('D', 'D', 'S'): return "Barco, N.V.";
	case PNP_ID('D', 'D', 'T'): return "Datadesk Technologies Inc";
	case PNP_ID('D', 'D', 'V'): return "Delta Information Systems, Inc";
	case PNP_ID('D', 'E', 'C'): return "Digital Equipment Corporation";
	case PNP_ID('D', 'E', 'F'): return "DEIF A/S";
	case PNP_ID('D', 'E', 'I'): return "Deico Electronics";
	case PNP_ID('D', 'E', 'L'): return "Dell Inc.";
	case PNP_ID('D', 'E', 'M'): return "DemoPad Software Ltd";
	case PNP_ID('D', 'E', 'N'): return "Densitron Computers Ltd";
	case PNP_ID('D', 'E', 'X'): return "idex displays";
	case PNP_ID('D', 'F', 'I'): return "DFI";
	case PNP_ID('D', 'F', 'K'): return "SharkTec A/S";
	case PNP_ID('D', 'F', 'T'): return "DEI Holdings dba Definitive Technology";
	case PNP_ID('D', 'G', 'A'): return "Digiital Arts Inc";
	case PNP_ID('D', 'G', 'C'): return "Data General Corporation";
	case PNP_ID('D', 'G', 'I'): return "DIGI International";
	case PNP_ID('D', 'G', 'K'): return "DugoTech Co., LTD";
	case PNP_ID('D', 'G', 'P'): return "Digicorp European sales S.A.";
	case PNP_ID('D', 'G', 'S'): return "Diagsoft Inc";
	case PNP_ID('D', 'G', 'T'): return "Dearborn Group Technology";
	case PNP_ID('D', 'H', 'D'): return "Dension Audio Systems";
	case PNP_ID('D', 'H', 'P'): return "DH Print";
	case PNP_ID('D', 'H', 'Q'): return "Quadram";
	case PNP_ID('D', 'H', 'T'): return "Projectavision Inc";
	case PNP_ID('D', 'I', 'A'): return "Diadem";
	case PNP_ID('D', 'I', 'G'): return "Digicom S.p.A.";
	case PNP_ID('D', 'I', 'I'): return "Dataq Instruments Inc";
	case PNP_ID('D', 'I', 'M'): return "dPict Imaging, Inc.";
	case PNP_ID('D', 'I', 'N'): return "Daintelecom Co., Ltd";
	case PNP_ID('D', 'I', 'S'): return "Diseda S.A.";
	case PNP_ID('D', 'I', 'T'): return "Dragon Information Technology";
	case PNP_ID('D', 'J', 'E'): return "Capstone Visual Product Development";
	case PNP_ID('D', 'J', 'P'): return "Maygay Machines, Ltd";
	case PNP_ID('D', 'K', 'Y'): return "Datakey Inc";
	case PNP_ID('D', 'L', 'B'): return "Dolby Laboratories Inc.";
	case PNP_ID('D', 'L', 'C'): return "Diamond Lane Comm. Corporation";
	case PNP_ID('D', 'L', 'D'): return "Delem";
	case PNP_ID('D', 'L', 'G'): return "Digital-Logic GmbH";
	case PNP_ID('D', 'L', 'K'): return "D-Link Systems Inc";
	case PNP_ID('D', 'L', 'L'): return "Dell Inc";
	case PNP_ID('D', 'L', 'M'): return "DLOGIC Ltd.";
	case PNP_ID('D', 'L', 'O'): return "Shenzhen Dlodlo Technologies Co., Ltd.";
	case PNP_ID('D', 'L', 'T'): return "Digitelec Informatique Park Cadera";
	case PNP_ID('D', 'M', 'B'): return "Digicom Systems Inc";
	case PNP_ID('D', 'M', 'C'): return "Dune Microsystems Corporation";
	case PNP_ID('D', 'M', 'G'): return "Monoprice.Inc";
	case PNP_ID('D', 'M', 'M'): return "Dimond Multimedia Systems Inc";
	case PNP_ID('D', 'M', 'N'): return "Dimension Engineering LLC";
	case PNP_ID('D', 'M', 'O'): return "Data Modul AG";
	case PNP_ID('D', 'M', 'P'): return "D&M Holdings Inc, Professional Business Company";
	case PNP_ID('D', 'M', 'S'): return "DOME imaging systems";
	case PNP_ID('D', 'M', 'T'): return "Distributed Management Task Force, Inc. (DMTF)";
	case PNP_ID('D', 'M', 'V'): return "NDS Ltd";
	case PNP_ID('D', 'N', 'A'): return "DNA Enterprises, Inc.";
	case PNP_ID('D', 'N', 'G'): return "Apache Micro Peripherals Inc";
	case PNP_ID('D', 'N', 'I'): return "Deterministic Networks Inc.";
	case PNP_ID('D', 'N', 'T'): return "Dr. Neuhous Telekommunikation GmbH";
	case PNP_ID('D', 'N', 'V'): return "DiCon";
	case PNP_ID('D', 'O', 'L'): return "Dolman Technologies Group Inc";
	case PNP_ID('D', 'O', 'M'): return "Dome Imaging Systems";
	case PNP_ID('D', 'O', 'N'): return "DENON, Ltd.";
	case PNP_ID('D', 'O', 'T'): return "Dotronic Mikroelektronik GmbH";
	case PNP_ID('D', 'P', 'A'): return "DigiTalk Pro AV";
	case PNP_ID('D', 'P', 'C'): return "Delta Electronics Inc";
	case PNP_ID('D', 'P', 'H'): return "Delphi Automotive LLP";
	case PNP_ID('D', 'P', 'I'): return "DocuPoint";
	case PNP_ID('D', 'P', 'L'): return "Digital Projection Limited";
	case PNP_ID('D', 'P', 'M'): return "ADPM Synthesis sas";
	case PNP_ID('D', 'P', 'N'): return "Shanghai Lexiang Technology Limited";
	case PNP_ID('D', 'P', 'S'): return "Digital Processing Systems";
	case PNP_ID('D', 'P', 'T'): return "DPT";
	case PNP_ID('D', 'P', 'X'): return "DpiX, Inc.";
	case PNP_ID('D', 'Q', 'B'): return "Datacube Inc";
	case PNP_ID('D', 'R', 'B'): return "Dr. Bott KG";
	case PNP_ID('D', 'R', 'C'): return "Data Ray Corp.";
	case PNP_ID('D', 'R', 'D'): return "DIGITAL REFLECTION INC.";
	case PNP_ID('D', 'R', 'I'): return "Data Race Inc";
	case PNP_ID('D', 'R', 'S'): return "DRS Defense Solutions, LLC";
	case PNP_ID('D', 'S', 'A'): return "Display Solution AG";
	case PNP_ID('D', 'S', 'D'): return "DS Multimedia Pte Ltd";
	case PNP_ID('D', 'S', 'G'): return "Disguise Technologies";
	case PNP_ID('D', 'S', 'I'): return "Digitan Systems Inc";
	case PNP_ID('D', 'S', 'J'): return "VR Technology Holdings Limited";
	case PNP_ID('D', 'S', 'M'): return "DSM Digital Services GmbH";
	case PNP_ID('D', 'S', 'P'): return "Domain Technology Inc";
	case PNP_ID('D', 'T', 'A'): return "DELTATEC";
	case PNP_ID('D', 'T', 'C'): return "DTC Tech Corporation";
	case PNP_ID('D', 'T', 'E'): return "Dimension Technologies, Inc.";
	case PNP_ID('D', 'T', 'I'): return "Diversified Technology, Inc.";
	case PNP_ID('D', 'T', 'K'): return "Dynax Electronics (HK) Ltd";
	case PNP_ID('D', 'T', 'L'): return "e-Net Inc";
	case PNP_ID('D', 'T', 'N'): return "Datang  Telephone Co";
	case PNP_ID('D', 'T', 'O'): return "Deutsche Thomson OHG";
	case PNP_ID('D', 'T', 'T'): return "Design & Test Technology, Inc.";
	case PNP_ID('D', 'T', 'X'): return "Data Translation";
	case PNP_ID('D', 'U', 'A'): return "Dosch & Amand GmbH & Company KG";
	case PNP_ID('D', 'U', 'N'): return "NCR Corporation";
	case PNP_ID('D', 'V', 'D'): return "Dictaphone Corporation";
	case PNP_ID('D', 'V', 'L'): return "Devolo AG";
	case PNP_ID('D', 'V', 'S'): return "Digital Video System";
	case PNP_ID('D', 'V', 'T'): return "Data Video";
	case PNP_ID('D', 'W', 'E'): return "Daewoo Electronics Company Ltd";
	case PNP_ID('D', 'X', 'C'): return "Digipronix Control Systems";
	case PNP_ID('D', 'X', 'D'): return "DECIMATOR DESIGN PTY LTD";
	case PNP_ID('D', 'X', 'L'): return "Dextera Labs Inc";
	case PNP_ID('D', 'X', 'N'): return "Dixon Technologies (India) Limited";
	case PNP_ID('D', 'X', 'P'): return "Data Expert Corporation";
	case PNP_ID('D', 'X', 'S'): return "Signet";
	case PNP_ID('D', 'Y', 'C'): return "Dycam Inc";
	case PNP_ID('D', 'Y', 'M'): return "Dymo-CoStar Corporation";
	case PNP_ID('D', 'Y', 'N'): return "Askey Computer Corporation";
	case PNP_ID('D', 'Y', 'X'): return "Dynax Electronics (HK) Ltd";
	case PNP_ID('E', 'A', 'C'): return "Emotiva Audio Corp.";
	case PNP_ID('E', 'A', 'G'): return "ELTEC Elektronik AG";
	case PNP_ID('E', 'A', 'S'): return "Evans and Sutherland Computer";
	case PNP_ID('E', 'B', 'H'): return "Data Price Informatica";
	case PNP_ID('E', 'B', 'S'): return "EBS Euchner Büro- und Schulsysteme GmbH";
	case PNP_ID('E', 'B', 'T'): return "HUALONG TECHNOLOGY CO., LTD";
	case PNP_ID('E', 'C', 'A'): return "Electro Cam Corp.";
	case PNP_ID('E', 'C', 'C'): return "ESSential Comm. Corporation";
	case PNP_ID('E', 'C', 'H'): return "EchoStar Corporation";
	case PNP_ID('E', 'C', 'I'): return "Enciris Technologies";
	case PNP_ID('E', 'C', 'K'): return "Eugene Chukhlomin Sole Proprietorship, d.b.a.";
	case PNP_ID('E', 'C', 'L'): return "Excel Company Ltd";
	case PNP_ID('E', 'C', 'M'): return "E-Cmos Tech Corporation";
	case PNP_ID('E', 'C', 'O'): return "Echo Speech Corporation";
	case PNP_ID('E', 'C', 'P'): return "Elecom Company Ltd";
	case PNP_ID('E', 'C', 'S'): return "Elitegroup Computer Systems Company Ltd";
	case PNP_ID('E', 'C', 'T'): return "Enciris Technologies";
	case PNP_ID('E', 'D', 'C'): return "e.Digital Corporation";
	case PNP_ID('E', 'D', 'G'): return "Electronic-Design GmbH";
	case PNP_ID('E', 'D', 'I'): return "Edimax Tech. Company Ltd";
	case PNP_ID('E', 'D', 'M'): return "EDMI";
	case PNP_ID('E', 'D', 'T'): return "Emerging Display Technologies Corp";
	case PNP_ID('E', 'E', 'E'): return "ET&T Technology Company Ltd";
	case PNP_ID('E', 'E', 'H'): return "EEH Datalink GmbH";
	case PNP_ID('E', 'E', 'I'): return "ELARABY COMPANY FOR ENGINEERING INDUSTRIES";
	case PNP_ID('E', 'E', 'P'): return "E.E.P.D. GmbH";
	case PNP_ID('E', 'E', 'S'): return "EE Solutions, Inc.";
	case PNP_ID('E', 'G', 'A'): return "Elgato Systems LLC";
	case PNP_ID('E', 'G', 'D'): return "EIZO GmbH Display Technologies";
	case PNP_ID('E', 'G', 'L'): return "Eagle Technology";
	case PNP_ID('E', 'G', 'N'): return "Egenera, Inc.";
	case PNP_ID('E', 'G', 'O'): return "Ergo Electronics";
	case PNP_ID('E', 'H', 'J'): return "Epson Research";
	case PNP_ID('E', 'H', 'N'): return "Enhansoft";
	case PNP_ID('E', 'I', 'C'): return "Eicon Technology Corporation";
	case PNP_ID('E', 'I', 'N'): return "Elegant Invention";
	case PNP_ID('E', 'K', 'A'): return "MagTek Inc.";
	case PNP_ID('E', 'K', 'C'): return "Eastman Kodak Company";
	case PNP_ID('E', 'K', 'S'): return "EKSEN YAZILIM";
	case PNP_ID('E', 'L', 'A'): return "ELAD srl";
	case PNP_ID('E', 'L', 'C'): return "Electro Scientific Ind";
	case PNP_ID('E', 'L', 'D'): return "Express Luck, Inc.";
	case PNP_ID('E', 'L', 'E'): return "Elecom Company Ltd";
	case PNP_ID('E', 'L', 'G'): return "Elmeg GmbH Kommunikationstechnik";
	case PNP_ID('E', 'L', 'I'): return "Edsun Laboratories";
	case PNP_ID('E', 'L', 'L'): return "Electrosonic Ltd";
	case PNP_ID('E', 'L', 'M'): return "Elmic Systems Inc";
	case PNP_ID('E', 'L', 'O'): return "Elo TouchSystems Inc";
	case PNP_ID('E', 'L', 'S'): return "ELSA GmbH";
	case PNP_ID('E', 'L', 'T'): return "Element Labs, Inc.";
	case PNP_ID('E', 'L', 'U'): return "Express Industrial, Ltd.";
	case PNP_ID('E', 'L', 'X'): return "Elonex PLC";
	case PNP_ID('E', 'M', 'B'): return "Embedded computing inc ltd";
	case PNP_ID('E', 'M', 'C'): return "eMicro Corporation";
	case PNP_ID('E', 'M', 'D'): return "Embrionix Design Inc.";
	case PNP_ID('E', 'M', 'E'): return "EMiNE TECHNOLOGY COMPANY, LTD.";
	case PNP_ID('E', 'M', 'G'): return "EMG Consultants Inc";
	case PNP_ID('E', 'M', 'I'): return "Ex Machina Inc";
	case PNP_ID('E', 'M', 'K'): return "Emcore Corporation";
	case PNP_ID('E', 'M', 'O'): return "ELMO COMPANY, LIMITED";
	case PNP_ID('E', 'M', 'R'): return "ICC Intelligent Platforms GmbH";
	case PNP_ID('E', 'M', 'U'): return "Emulex Corporation";
	case PNP_ID('E', 'N', 'C'): return "Eizo Nanao Corporation";
	case PNP_ID('E', 'N', 'D'): return "ENIDAN Technologies Ltd";
	case PNP_ID('E', 'N', 'E'): return "ENE Technology Inc.";
	case PNP_ID('E', 'N', 'I'): return "Efficient Networks";
	case PNP_ID('E', 'N', 'S'): return "Ensoniq Corporation";
	case PNP_ID('E', 'N', 'T'): return "Enterprise Comm. & Computing Inc";
	case PNP_ID('E', 'O', 'N'): return "Eon Instrumentation, Inc.";
	case PNP_ID('E', 'P', 'C'): return "Empac";
	case PNP_ID('E', 'P', 'H'): return "Epiphan Systems Inc.";
	case PNP_ID('E', 'P', 'I'): return "Envision Peripherals, Inc";
	case PNP_ID('E', 'P', 'N'): return "EPiCON Inc.";
	case PNP_ID('E', 'P', 'S'): return "KEPS";
	case PNP_ID('E', 'Q', 'P'): return "Equipe Electronics Ltd.";
	case PNP_ID('E', 'Q', 'X'): return "Equinox Systems Inc";
	case PNP_ID('E', 'R', 'G'): return "Ergo System";
	case PNP_ID('E', 'R', 'I'): return "Ericsson Mobile Communications AB";
	case PNP_ID('E', 'R', 'N'): return "Ericsson, Inc.";
	case PNP_ID('E', 'R', 'P'): return "Euraplan GmbH";
	case PNP_ID('E', 'R', 'S'): return "Eizo Rugged Solutions";
	case PNP_ID('E', 'R', 'T'): return "Escort Insturments Corporation";
	case PNP_ID('E', 'S', 'A'): return "Elbit Systems of America";
	case PNP_ID('E', 'S', 'B'): return "ScioTeq";
	case PNP_ID('E', 'S', 'C'): return "Eden Sistemas de Computacao S/A";
	case PNP_ID('E', 'S', 'D'): return "Ensemble Designs, Inc";
	case PNP_ID('E', 'S', 'G'): return "ELCON Systemtechnik GmbH";
	case PNP_ID('E', 'S', 'I'): return "Extended Systems, Inc.";
	case PNP_ID('E', 'S', 'K'): return "ES&S";
	case PNP_ID('E', 'S', 'L'): return "Esterline Technologies";
	case PNP_ID('E', 'S', 'N'): return "eSATURNUS";
	case PNP_ID('E', 'S', 'S'): return "ESS Technology Inc";
	case PNP_ID('E', 'S', 'T'): return "Embedded Solution Technology";
	case PNP_ID('E', 'S', 'Y'): return "E-Systems Inc";
	case PNP_ID('E', 'T', 'C'): return "Everton Technology Company Ltd";
	case PNP_ID('E', 'T', 'D'): return "ELAN MICROELECTRONICS CORPORATION";
	case PNP_ID('E', 'T', 'G'): return "Eizo Technologies GmbH";
	case PNP_ID('E', 'T', 'H'): return "Etherboot Project";
	case PNP_ID('E', 'T', 'I'): return "Eclipse Tech Inc";
	case PNP_ID('E', 'T', 'K'): return "eTEK Labs Inc.";
	case PNP_ID('E', 'T', 'L'): return "Evertz Microsystems Ltd.";
	case PNP_ID('E', 'T', 'S'): return "Electronic Trade Solutions Ltd";
	case PNP_ID('E', 'T', 'T'): return "E-Tech Inc";
	case PNP_ID('E', 'U', 'T'): return "Ericsson Mobile Networks B.V.";
	case PNP_ID('E', 'V', 'E'): return "Advanced Micro Peripherals Ltd";
	case PNP_ID('E', 'V', 'I'): return "eviateg GmbH";
	case PNP_ID('E', 'V', 'P'): return "EverPro Technologies Company Limited";
	case PNP_ID('E', 'V', 'X'): return "Everex";
	case PNP_ID('E', 'X', 'A'): return "Exabyte";
	case PNP_ID('E', 'X', 'C'): return "Excession Audio";
	case PNP_ID('E', 'X', 'I'): return "Exide Electronics";
	case PNP_ID('E', 'X', 'N'): return "RGB Systems, Inc. dba Extron Electronics";
	case PNP_ID('E', 'X', 'P'): return "Data Export Corporation";
	case PNP_ID('E', 'X', 'R'): return "Explorer Inc.";
	case PNP_ID('E', 'X', 'T'): return "Exatech Computadores & Servicos Ltda";
	case PNP_ID('E', 'X', 'X'): return "Exxact GmbH";
	case PNP_ID('E', 'X', 'Y'): return "Exterity Ltd";
	case PNP_ID('E', 'Y', 'E'): return "eyevis GmbH";
	case PNP_ID('E', 'Y', 'F'): return "eyefactive Gmbh";
	case PNP_ID('E', 'Z', 'E'): return "EzE Technologies";
	case PNP_ID('E', 'Z', 'P'): return "Storm Technology";
	case PNP_ID('F', 'A', 'N'): return "Fantalooks Co., Ltd.";
	case PNP_ID('F', 'A', 'R'): return "Farallon Computing";
	case PNP_ID('F', 'B', 'I'): return "Interface Corporation";
	case PNP_ID('F', 'C', 'B'): return "Furukawa Electric Company Ltd";
	case PNP_ID('F', 'C', 'G'): return "First International Computer Ltd";
	case PNP_ID('F', 'C', 'S'): return "Focus Enhancements, Inc.";
	case PNP_ID('F', 'D', 'C'): return "Future Domain";
	case PNP_ID('F', 'D', 'D'): return "Forth Dimension Displays Ltd";
	case PNP_ID('F', 'D', 'I'): return "Future Designs, Inc.";
	case PNP_ID('F', 'D', 'T'): return "Fujitsu Display Technologies Corp.";
	case PNP_ID('F', 'D', 'X'): return "Findex, Inc.";
	case PNP_ID('F', 'E', 'C'): return "FURUNO ELECTRIC CO., LTD.";
	case PNP_ID('F', 'E', 'L'): return "Fellowes & Questec";
	case PNP_ID('F', 'E', 'N'): return "Fen Systems Ltd.";
	case PNP_ID('F', 'E', 'R'): return "Ferranti Int'L";
	case PNP_ID('F', 'F', 'C'): return "FUJIFILM Corporation";
	case PNP_ID('F', 'F', 'I'): return "Fairfield Industries";
	case PNP_ID('F', 'G', 'D'): return "Lisa Draexlmaier GmbH";
	case PNP_ID('F', 'G', 'L'): return "Fujitsu General Limited.";
	case PNP_ID('F', 'H', 'L'): return "FHLP";
	case PNP_ID('F', 'I', 'C'): return "Formosa Industrial Computing Inc";
	case PNP_ID('F', 'I', 'L'): return "Forefront Int'l Ltd";
	case PNP_ID('F', 'I', 'N'): return "Finecom Co., Ltd.";
	case PNP_ID('F', 'I', 'R'): return "Chaplet Systems Inc";
	case PNP_ID('F', 'I', 'S'): return "FLY-IT Simulators";
	case PNP_ID('F', 'I', 'T'): return "Feature Integration Technology Inc.";
	case PNP_ID('F', 'J', 'C'): return "FCL COMPONENTS LIMITED";
	case PNP_ID('F', 'J', 'S'): return "Fujitsu Spain";
	case PNP_ID('F', 'J', 'T'): return "F.J. Tieman BV";
	case PNP_ID('F', 'L', 'E'): return "ADTI Media, Inc";
	case PNP_ID('F', 'L', 'I'): return "Faroudja Laboratories";
	case PNP_ID('F', 'L', 'Y'): return "Butterfly Communications";
	case PNP_ID('F', 'M', 'A'): return "Fast Multimedia AG";
	case PNP_ID('F', 'M', 'C'): return "Ford Microelectronics Inc";
	case PNP_ID('F', 'M', 'I'): return "Fellowes, Inc.";
	case PNP_ID('F', 'M', 'L'): return "Fujitsu Microelect Ltd";
	case PNP_ID('F', 'M', 'Z'): return "Formoza-Altair";
	case PNP_ID('F', 'N', 'C'): return "Fanuc LTD";
	case PNP_ID('F', 'N', 'I'): return "Funai Electric Co., Ltd.";
	case PNP_ID('F', 'O', 'A'): return "FOR-A Company Limited";
	case PNP_ID('F', 'O', 'K'): return "Fokus Technologies GmbH";
	case PNP_ID('F', 'O', 'S'): return "Foss Tecator";
	case PNP_ID('F', 'O', 'V'): return "FOVE INC";
	case PNP_ID('F', 'O', 'X'): return "HON HAI PRECISION IND.CO.,LTD.";
	case PNP_ID('F', 'P', 'C'): return "Fingerprint Cards AB";
	case PNP_ID('F', 'P', 'E'): return "Fujitsu Peripherals Ltd";
	case PNP_ID('F', 'P', 'S'): return "Deltec Corporation";
	case PNP_ID('F', 'P', 'X'): return "Cirel Systemes";
	case PNP_ID('F', 'R', 'C'): return "Force Computers";
	case PNP_ID('F', 'R', 'D'): return "Freedom Scientific BLV";
	case PNP_ID('F', 'R', 'E'): return "Forvus Research Inc";
	case PNP_ID('F', 'R', 'I'): return "Fibernet Research Inc";
	case PNP_ID('F', 'R', 'O'): return "FARO Technologies";
	case PNP_ID('F', 'R', 'S'): return "South Mountain Technologies, LTD";
	case PNP_ID('F', 'S', 'C'): return "Future Systems Consulting KK";
	case PNP_ID('F', 'S', 'I'): return "Fore Systems Inc";
	case PNP_ID('F', 'S', 'T'): return "Modesto PC Inc";
	case PNP_ID('F', 'T', 'C'): return "Futuretouch Corporation";
	case PNP_ID('F', 'T', 'E'): return "Frontline Test Equipment Inc.";
	case PNP_ID('F', 'T', 'G'): return "FTG Data Systems";
	case PNP_ID('F', 'T', 'I'): return "FastPoint Technologies, Inc.";
	case PNP_ID('F', 'T', 'L'): return "FUJITSU TEN LIMITED";
	case PNP_ID('F', 'T', 'N'): return "Fountain Technologies Inc";
	case PNP_ID('F', 'T', 'R'): return "Mediasonic";
	case PNP_ID('F', 'T', 'S'): return "FocalTech Systems Co., Ltd.";
	case PNP_ID('F', 'T', 'W'): return "MindTribe Product Engineering, Inc.";
	case PNP_ID('F', 'U', 'J'): return "Fujitsu Ltd";
	case PNP_ID('F', 'U', 'L'): return "Fun Technology Innovation INC.";
	case PNP_ID('F', 'U', 'N'): return "sisel muhendislik";
	case PNP_ID('F', 'U', 'S'): return "Fujitsu Siemens Computers GmbH";
	case PNP_ID('F', 'V', 'C'): return "First Virtual Corporation";
	case PNP_ID('F', 'V', 'X'): return "C-C-C Group Plc";
	case PNP_ID('F', 'W', 'A'): return "Attero Tech, LLC";
	case PNP_ID('F', 'W', 'R'): return "Flat Connections Inc";
	case PNP_ID('F', 'X', 'X'): return "Fuji Xerox";
	case PNP_ID('F', 'Z', 'C'): return "Founder Group Shenzhen Co.";
	case PNP_ID('F', 'Z', 'I'): return "FZI Forschungszentrum Informatik";
	case PNP_ID('G', 'A', 'C'): return "GreenArrays, Inc.";
	case PNP_ID('G', 'A', 'G'): return "Gage Applied Sciences Inc";
	case PNP_ID('G', 'A', 'L'): return "Galil Motion Control";
	case PNP_ID('G', 'A', 'U'): return "Gaudi Co., Ltd.";
	case PNP_ID('G', 'B', 'T'): return "GIGA-BYTE TECHNOLOGY CO., LTD.";
	case PNP_ID('G', 'C', 'C'): return "GCC Technologies Inc";
	case PNP_ID('G', 'C', 'I'): return "Gateway Comm. Inc";
	case PNP_ID('G', 'C', 'S'): return "Grey Cell Systems Ltd";
	case PNP_ID('G', 'D', 'C'): return "General Datacom";
	case PNP_ID('G', 'D', 'I'): return "G. Diehl ISDN GmbH";
	case PNP_ID('G', 'D', 'S'): return "GDS";
	case PNP_ID('G', 'D', 'T'): return "Vortex Computersysteme GmbH";
	case PNP_ID('G', 'E', 'C'): return "Gechic Corporation";
	case PNP_ID('G', 'E', 'D'): return "General Dynamics C4 Systems";
	case PNP_ID('G', 'E', 'F'): return "GE Fanuc Embedded Systems";
	case PNP_ID('G', 'E', 'H'): return "Abaco Systems, Inc.";
	case PNP_ID('G', 'E', 'M'): return "Gem Plus";
	case PNP_ID('G', 'E', 'N'): return "Genesys ATE Inc";
	case PNP_ID('G', 'E', 'O'): return "GEO Sense";
	case PNP_ID('G', 'E', 'R'): return "GERMANEERS GmbH";
	case PNP_ID('G', 'E', 'S'): return "GES Singapore Pte Ltd";
	case PNP_ID('G', 'E', 'T'): return "Getac Technology Corporation";
	case PNP_ID('G', 'F', 'M'): return "GFMesstechnik GmbH";
	case PNP_ID('G', 'F', 'N'): return "Gefen Inc.";
	case PNP_ID('G', 'G', 'L'): return "Google Inc.";
	case PNP_ID('G', 'G', 'T'): return "G2TOUCH KOREA";
	case PNP_ID('G', 'I', 'C'): return "General Inst. Corporation";
	case PNP_ID('G', 'I', 'M'): return "Guillemont International";
	case PNP_ID('G', 'I', 'P'): return "GI Provision Ltd";
	case PNP_ID('G', 'I', 'S'): return "AT&T Global Info Solutions";
	case PNP_ID('G', 'J', 'N'): return "Grand Junction Networks";
	case PNP_ID('G', 'L', 'D'): return "Goldmund - Digital Audio SA";
	case PNP_ID('G', 'L', 'E'): return "AD electronics";
	case PNP_ID('G', 'L', 'M'): return "Genesys Logic";
	case PNP_ID('G', 'L', 'S'): return "Gadget Labs LLC";
	case PNP_ID('G', 'M', 'K'): return "GMK Electronic Design GmbH";
	case PNP_ID('G', 'M', 'L'): return "General Information Systems";
	case PNP_ID('G', 'M', 'M'): return "GMM Research Inc";
	case PNP_ID('G', 'M', 'N'): return "GEMINI 2000 Ltd";
	case PNP_ID('G', 'M', 'X'): return "GMX Inc";
	case PNP_ID('G', 'N', 'D'): return "Gennum Corporation";
	case PNP_ID('G', 'N', 'N'): return "GN Nettest Inc";
	case PNP_ID('G', 'N', 'Z'): return "Gunze Ltd";
	case PNP_ID('G', 'O', 'E'): return "GOEPEL electronic GmbH";
	case PNP_ID('G', 'P', 'R'): return "GoPro, Inc.";
	case PNP_ID('G', 'R', 'A'): return "Graphica Computer";
	case PNP_ID('G', 'R', 'E'): return "GOLD RAIN ENTERPRISES CORP.";
	case PNP_ID('G', 'R', 'H'): return "Granch Ltd";
	case PNP_ID('G', 'R', 'M'): return "Garmin International";
	case PNP_ID('G', 'R', 'V'): return "Advanced Gravis";
	case PNP_ID('G', 'R', 'Y'): return "Robert Gray Company";
	case PNP_ID('G', 'S', 'B'): return "NIPPONDENCHI CO,.LTD";
	case PNP_ID('G', 'S', 'C'): return "General Standards Corporation";
	case PNP_ID('G', 'S', 'M'): return "LG Electronics";
	case PNP_ID('G', 'S', 'N'): return "Grandstream Networks, Inc.";
	case PNP_ID('G', 'S', 'T'): return "Graphic SystemTechnology";
	case PNP_ID('G', 'S', 'Y'): return "Grossenbacher Systeme AG";
	case PNP_ID('G', 'T', 'C'): return "Graphtec Corporation";
	case PNP_ID('G', 'T', 'I'): return "Goldtouch";
	case PNP_ID('G', 'T', 'K'): return "G-Tech Corporation";
	case PNP_ID('G', 'T', 'M'): return "Garnet System Company Ltd";
	case PNP_ID('G', 'T', 'S'): return "Geotest Marvin Test Systems Inc";
	case PNP_ID('G', 'T', 'T'): return "General Touch Technology Co., Ltd.";
	case PNP_ID('G', 'U', 'D'): return "Guntermann & Drunck GmbH";
	case PNP_ID('G', 'U', 'P'): return "GoUp Co.,Ltd";
	case PNP_ID('G', 'U', 'Z'): return "Guzik Technical Enterprises";
	case PNP_ID('G', 'V', 'C'): return "GVC Corporation";
	case PNP_ID('G', 'V', 'L'): return "Global Village Communication";
	case PNP_ID('G', 'V', 'S'): return "G.VISION";
	case PNP_ID('G', 'W', 'I'): return "GW Instruments";
	case PNP_ID('G', 'W', 'K'): return "Gateworks Corporation";
	case PNP_ID('G', 'W', 'Y'): return "Gateway 2000";
	case PNP_ID('G', 'X', 'L'): return "Galaxy Microsystems Ltd.";
	case PNP_ID('G', 'Z', 'E'): return "GUNZE Limited";
	case PNP_ID('H', 'A', 'E'): return "Haider electronics";
	case PNP_ID('H', 'A', 'I'): return "Haivision Systems Inc.";
	case PNP_ID('H', 'A', 'L'): return "Halberthal";
	case PNP_ID('H', 'A', 'N'): return "Hanchang System Corporation";
	case PNP_ID('H', 'A', 'R'): return "Harris Corporation";
	case PNP_ID('H', 'A', 'Y'): return "Hayes Microcomputer Products Inc";
	case PNP_ID('H', 'C', 'A'): return "DAT";
	case PNP_ID('H', 'C', 'E'): return "Hitachi Consumer Electronics Co., Ltd";
	case PNP_ID('H', 'C', 'L'): return "HCL America Inc";
	case PNP_ID('H', 'C', 'M'): return "HCL Peripherals";
	case PNP_ID('H', 'C', 'P'): return "Hitachi Computer Products Inc";
	case PNP_ID('H', 'C', 'W'): return "Hauppauge Computer Works Inc";
	case PNP_ID('H', 'D', 'C'): return "HardCom Elektronik & Datateknik";
	case PNP_ID('H', 'D', 'I'): return "HD-INFO d.o.o.";
	case PNP_ID('H', 'D', 'V'): return "Holografika kft.";
	case PNP_ID('H', 'E', 'C'): return "Hisense Electric Co., Ltd.";
	case PNP_ID('H', 'E', 'L'): return "Hitachi Micro Systems Europe Ltd";
	case PNP_ID('H', 'E', 'R'): return "Ascom Business Systems";
	case PNP_ID('H', 'E', 'T'): return "HETEC Datensysteme GmbH";
	case PNP_ID('H', 'H', 'C'): return "HIRAKAWA HEWTECH CORP.";
	case PNP_ID('H', 'H', 'I'): return "Fraunhofer Heinrich-Hertz-Institute";
	case PNP_ID('H', 'H', 'T'): return "Hitevision Group";
	case PNP_ID('H', 'I', 'B'): return "Hibino Corporation";
	case PNP_ID('H', 'I', 'C'): return "Hitachi Information Technology Co., Ltd.";
	case PNP_ID('H', 'I', 'I'): return "Harman International Industries, Inc";
	case PNP_ID('H', 'I', 'K'): return "Hikom Co., Ltd.";
	case PNP_ID('H', 'I', 'L'): return "Hilevel Technology";
	case PNP_ID('H', 'I', 'Q'): return "Kaohsiung Opto Electronics Americas, Inc.";
	case PNP_ID('H', 'I', 'S'): return "Hope Industrial Systems, Inc.";
	case PNP_ID('H', 'I', 'T'): return "Hitachi America Ltd";
	case PNP_ID('H', 'J', 'I'): return "Harris & Jeffries Inc";
	case PNP_ID('H', 'K', 'A'): return "HONKO MFG. CO., LTD.";
	case PNP_ID('H', 'K', 'C'): return "HKC OVERSEAS LIMITED";
	case PNP_ID('H', 'K', 'G'): return "Josef Heim KG";
	case PNP_ID('H', 'L', 'G'): return "China Hualu Group Co., Ltd.";
	case PNP_ID('H', 'M', 'C'): return "Hualon Microelectric Corporation";
	case PNP_ID('H', 'M', 'K'): return "hmk Daten-System-Technik BmbH";
	case PNP_ID('H', 'M', 'X'): return "HUMAX Co., Ltd.";
	case PNP_ID('H', 'N', 'M'): return "HONOR Device Co., Ltd.";
	case PNP_ID('H', 'N', 'S'): return "Hughes Network Systems";
	case PNP_ID('H', 'O', 'B'): return "HOB Electronic GmbH";
	case PNP_ID('H', 'O', 'E'): return "Hosiden Corporation";
	case PNP_ID('H', 'O', 'L'): return "Holoeye Photonics AG";
	case PNP_ID('H', 'O', 'N'): return "Sonitronix";
	case PNP_ID('H', 'P', 'A'): return "Zytor Communications";
	case PNP_ID('H', 'P', 'C'): return "Hewlett-Packard Co.";
	case PNP_ID('H', 'P', 'D'): return "Hewlett Packard";
	case PNP_ID('H', 'P', 'E'): return "Hewlett Packard Enterprise";
	case PNP_ID('H', 'P', 'I'): return "Headplay, Inc.";
	case PNP_ID('H', 'P', 'K'): return "HAMAMATSU PHOTONICS K.K.";
	case PNP_ID('H', 'P', 'N'): return "HP Inc.";
	case PNP_ID('H', 'P', 'Q'): return "Hewlett-Packard Co.";
	case PNP_ID('H', 'P', 'R'): return "H.P.R. Electronics GmbH";
	case PNP_ID('H', 'R', 'C'): return "Hercules";
	case PNP_ID('H', 'R', 'E'): return "Qingdao Haier Electronics Co., Ltd.";
	case PNP_ID('H', 'R', 'I'): return "Hall Research";
	case PNP_ID('H', 'R', 'L'): return "Herolab GmbH";
	case PNP_ID('H', 'R', 'S'): return "Harris Semiconductor";
	case PNP_ID('H', 'R', 'T'): return "HERCULES";
	case PNP_ID('H', 'S', 'C'): return "Hagiwara Sys-Com Company Ltd";
	case PNP_ID('H', 'S', 'D'): return "HannStar Display Corp";
	case PNP_ID('H', 'S', 'M'): return "AT&T Microelectronics";
	case PNP_ID('H', 'S', 'N'): return "Hansung Co., Ltd";
	case PNP_ID('H', 'S', 'P'): return "HannStar Display Corp";
	case PNP_ID('H', 'S', 'T'): return "Horsent Technology Co., Ltd.";
	case PNP_ID('H', 'T', 'C'): return "Hitachi Ltd";
	case PNP_ID('H', 'T', 'I'): return "Hampshire Company, Inc.";
	case PNP_ID('H', 'T', 'K'): return "Holtek Microelectronics Inc";
	case PNP_ID('H', 'T', 'L'): return "HTBLuVA Mödling";
	case PNP_ID('H', 'T', 'R'): return "Shenzhen ZhuoYi HengTong Computer Technology Limited";
	case PNP_ID('H', 'T', 'X'): return "Hitex Systementwicklung GmbH";
	case PNP_ID('H', 'U', 'B'): return "GAI-Tronics, A Hubbell Company";
	case PNP_ID('H', 'U', 'K'): return "Hoffmann + Krippner GmbH";
	case PNP_ID('H', 'U', 'M'): return "IMP Electronics Ltd.";
	case PNP_ID('H', 'V', 'R'): return "HTC Corportation";
	case PNP_ID('H', 'W', 'A'): return "Harris Canada Inc";
	case PNP_ID('H', 'W', 'C'): return "DBA Hans Wedemeyer";
	case PNP_ID('H', 'W', 'D'): return "Highwater Designs Ltd";
	case PNP_ID('H', 'W', 'P'): return "Hewlett Packard";
	case PNP_ID('H', 'W', 'V'): return "Huawei Technologies Co., Inc.";
	case PNP_ID('H', 'X', 'M'): return "Hexium Ltd.";
	case PNP_ID('H', 'Y', 'C'): return "Hypercope Gmbh Aachen";
	case PNP_ID('H', 'Y', 'D'): return "Hydis Technologies.Co.,LTD";
	case PNP_ID('H', 'Y', 'L'): return "Shanghai Chai Ming Huang Info&Tech Co, Ltd";
	case PNP_ID('H', 'Y', 'O'): return "HYC CO., LTD.";
	case PNP_ID('H', 'Y', 'P'): return "Hyphen Ltd";
	case PNP_ID('H', 'Y', 'R'): return "Hypertec Pty Ltd";
	case PNP_ID('H', 'Y', 'T'): return "Heng Yu Technology (HK) Limited";
	case PNP_ID('H', 'Y', 'V'): return "Hynix Semiconductor";
	case PNP_ID('I', 'A', 'D'): return "IAdea Corporation";
	case PNP_ID('I', 'A', 'F'): return "Institut f r angewandte Funksystemtechnik GmbH";
	case PNP_ID('I', 'A', 'I'): return "Integration Associates, Inc.";
	case PNP_ID('I', 'A', 'T'): return "IAT Germany GmbH";
	case PNP_ID('I', 'B', 'C'): return "Integrated Business Systems";
	case PNP_ID('I', 'B', 'I'): return "INBINE.CO.LTD";
	case PNP_ID('I', 'B', 'M'): return "IBM Brasil";
	case PNP_ID('I', 'B', 'P'): return "IBP Instruments GmbH";
	case PNP_ID('I', 'B', 'R'): return "IBR GmbH";
	case PNP_ID('I', 'C', 'A'): return "ICA Inc";
	case PNP_ID('I', 'C', 'C'): return "BICC Data Networks Ltd";
	case PNP_ID('I', 'C', 'D'): return "ICD Inc";
	case PNP_ID('I', 'C', 'E'): return "IC Ensemble";
	case PNP_ID('I', 'C', 'I'): return "Infotek Communication Inc";
	case PNP_ID('I', 'C', 'M'): return "Intracom SA";
	case PNP_ID('I', 'C', 'N'): return "Sanyo Icon";
	case PNP_ID('I', 'C', 'O'): return "Intel Corp";
	case PNP_ID('I', 'C', 'P'): return "ICP Electronics, Inc./iEi Technology Corp.";
	case PNP_ID('I', 'C', 'R'): return "Icron";
	case PNP_ID('I', 'C', 'S'): return "Integrated Circuit Systems";
	case PNP_ID('I', 'C', 'V'): return "Inside Contactless";
	case PNP_ID('I', 'C', 'X'): return "ICCC A/S";
	case PNP_ID('I', 'D', 'C'): return "International Datacasting Corporation";
	case PNP_ID('I', 'D', 'E'): return "IDE Associates";
	case PNP_ID('I', 'D', 'K'): return "IDK Corporation";
	case PNP_ID('I', 'D', 'N'): return "Idneo Technologies";
	case PNP_ID('I', 'D', 'O'): return "IDEO Product Development";
	case PNP_ID('I', 'D', 'P'): return "Integrated Device Technology, Inc.";
	case PNP_ID('I', 'D', 'S'): return "Interdigital Sistemas de Informacao";
	case PNP_ID('I', 'D', 'T'): return "International Display Technology";
	case PNP_ID('I', 'D', 'X'): return "IDEXX Labs";
	case PNP_ID('I', 'E', 'C'): return "Interlace Engineering Corporation";
	case PNP_ID('I', 'E', 'E'): return "IEE";
	case PNP_ID('I', 'E', 'I'): return "Interlink Electronics";
	case PNP_ID('I', 'F', 'S'): return "In Focus Systems Inc";
	case PNP_ID('I', 'F', 'T'): return "Informtech";
	case PNP_ID('I', 'F', 'X'): return "Infineon Technologies AG";
	case PNP_ID('I', 'F', 'Z'): return "Infinite Z";
	case PNP_ID('I', 'G', 'C'): return "Intergate Pty Ltd";
	case PNP_ID('I', 'G', 'M'): return "IGM Communi";
	case PNP_ID('I', 'H', 'E'): return "InHand Electronics";
	case PNP_ID('I', 'I', 'C'): return "ISIC Innoscan Industrial Computers A/S";
	case PNP_ID('I', 'I', 'I'): return "Intelligent Instrumentation";
	case PNP_ID('I', 'I', 'N'): return "IINFRA Co., Ltd";
	case PNP_ID('I', 'I', 'T'): return "Informatik Information Technologies";
	case PNP_ID('I', 'K', 'E'): return "Ikegami Tsushinki Co. Ltd.";
	case PNP_ID('I', 'K', 'S'): return "Ikos Systems Inc";
	case PNP_ID('I', 'L', 'C'): return "Image Logic Corporation";
	case PNP_ID('I', 'L', 'S'): return "Innotech Corporation";
	case PNP_ID('I', 'M', 'A'): return "Imagraph";
	case PNP_ID('I', 'M', 'B'): return "ART s.r.l.";
	case PNP_ID('I', 'M', 'C'): return "IMC Networks";
	case PNP_ID('I', 'M', 'D'): return "ImasDe Canarias S.A.";
	case PNP_ID('I', 'M', 'E'): return "Imagraph";
	case PNP_ID('I', 'M', 'F'): return "Immersive Audio Technologies France";
	case PNP_ID('I', 'M', 'G'): return "IMAGENICS Co., Ltd.";
	case PNP_ID('I', 'M', 'I'): return "International Microsystems Inc";
	case PNP_ID('I', 'M', 'M'): return "Immersion Corporation";
	case PNP_ID('I', 'M', 'N'): return "Impossible Production";
	case PNP_ID('I', 'M', 'P'): return "Impinj";
	case PNP_ID('I', 'M', 'T'): return "Inmax Technology Corporation";
	case PNP_ID('I', 'M', 'X'): return "arpara Technology Co., Ltd.";
	case PNP_ID('I', 'N', 'A'): return "Inventec Corporation";
	case PNP_ID('I', 'N', 'C'): return "Home Row Inc";
	case PNP_ID('I', 'N', 'D'): return "ILC";
	case PNP_ID('I', 'N', 'E'): return "Inventec Electronics (M) Sdn. Bhd.";
	case PNP_ID('I', 'N', 'F'): return "Inframetrics Inc";
	case PNP_ID('I', 'N', 'G'): return "Integraph Corporation";
	case PNP_ID('I', 'N', 'I'): return "Initio Corporation";
	case PNP_ID('I', 'N', 'K'): return "Indtek Co., Ltd.";
	case PNP_ID('I', 'N', 'L'): return "InnoLux Display Corporation";
	case PNP_ID('I', 'N', 'M'): return "InnoMedia Inc";
	case PNP_ID('I', 'N', 'N'): return "Innovent Systems, Inc.";
	case PNP_ID('I', 'N', 'O'): return "Innolab Pte Ltd";
	case PNP_ID('I', 'N', 'P'): return "Interphase Corporation";
	case PNP_ID('I', 'N', 'S'): return "Ines GmbH";
	case PNP_ID('I', 'N', 'T'): return "Interphase Corporation";
	case PNP_ID('i', 'n', 'u'): return "Inovatec S.p.A.";
	case PNP_ID('I', 'N', 'V'): return "Inviso, Inc.";
	case PNP_ID('I', 'N', 'X'): return "Communications Supply Corporation (A division of WESCO)";
	case PNP_ID('I', 'N', 'Z'): return "Best Buy";
	case PNP_ID('I', 'O', 'A'): return "CRE Technology Corporation";
	case PNP_ID('I', 'O', 'C'): return "Guangxi Century Innovation Display Electronics Co., Ltd";
	case PNP_ID('I', 'O', 'D'): return "I-O Data Device Inc";
	case PNP_ID('I', 'O', 'M'): return "Iomega";
	case PNP_ID('I', 'O', 'N'): return "Inside Out Networks";
	case PNP_ID('I', 'O', 'S'): return "i-O Display System";
	case PNP_ID('I', 'O', 'T'): return "I/OTech Inc";
	case PNP_ID('I', 'P', 'C'): return "IPC Corporation";
	case PNP_ID('I', 'P', 'D'): return "Industrial Products Design, Inc.";
	case PNP_ID('I', 'P', 'I'): return "Intelligent Platform Management Interface (IPMI) forum (Intel, HP, NEC, Dell)";
	case PNP_ID('I', 'P', 'M'): return "IPM Industria Politecnica Meridionale SpA";
	case PNP_ID('I', 'P', 'N'): return "Performance Technologies";
	case PNP_ID('I', 'P', 'P'): return "IP Power Technologies GmbH";
	case PNP_ID('I', 'P', 'Q'): return "IP3 Technology Ltd.";
	case PNP_ID('I', 'P', 'R'): return "Ithaca Peripherals";
	case PNP_ID('I', 'P', 'S'): return "IPS, Inc. (Intellectual Property Solutions, Inc.)";
	case PNP_ID('I', 'P', 'T'): return "International Power Technologies";
	case PNP_ID('I', 'P', 'W'): return "IPWireless, Inc";
	case PNP_ID('I', 'Q', 'I'): return "IneoQuest Technologies, Inc";
	case PNP_ID('I', 'Q', 'T'): return "IMAGEQUEST Co., Ltd";
	case PNP_ID('I', 'R', 'D'): return "Irdata";
	case PNP_ID('I', 'S', 'A'): return "Symbol Technologies";
	case PNP_ID('I', 'S', 'C'): return "Id3 Semiconductors";
	case PNP_ID('I', 'S', 'G'): return "Insignia Solutions Inc";
	case PNP_ID('I', 'S', 'I'): return "Interface Solutions";
	case PNP_ID('I', 'S', 'L'): return "Isolation Systems";
	case PNP_ID('I', 'S', 'M'): return "Image Stream Medical";
	case PNP_ID('I', 'S', 'P'): return "IntreSource Systems Pte Ltd";
	case PNP_ID('I', 'S', 'R'): return "INSIS Co., LTD.";
	case PNP_ID('I', 'S', 'S'): return "ISS Inc";
	case PNP_ID('I', 'S', 'T'): return "Intersolve Technologies";
	case PNP_ID('I', 'S', 'Y'): return "International Integrated Systems,Inc.(IISI)";
	case PNP_ID('I', 'T', 'A'): return "Itausa Export North America";
	case PNP_ID('I', 'T', 'C'): return "Intercom Inc";
	case PNP_ID('I', 'T', 'D'): return "Internet Technology Corporation";
	case PNP_ID('I', 'T', 'E'): return "Integrated Tech Express Inc";
	case PNP_ID('I', 'T', 'I'): return "VanErum Group";
	case PNP_ID('I', 'T', 'K'): return "ITK Telekommunikation AG";
	case PNP_ID('I', 'T', 'L'): return "Inter-Tel";
	case PNP_ID('I', 'T', 'M'): return "ITM inc.";
	case PNP_ID('I', 'T', 'N'): return "The NTI Group";
	case PNP_ID('I', 'T', 'P'): return "IT-PRO Consulting und Systemhaus GmbH";
	case PNP_ID('I', 'T', 'R'): return "Infotronic America, Inc.";
	case PNP_ID('I', 'T', 'S'): return "IDTECH";
	case PNP_ID('I', 'T', 'T'): return "I&T Telecom.";
	case PNP_ID('I', 'T', 'X'): return "integrated Technology Express Inc";
	case PNP_ID('I', 'U', 'C'): return "ICSL";
	case PNP_ID('I', 'V', 'I'): return "Intervoice Inc";
	case PNP_ID('I', 'V', 'M'): return "Iiyama North America";
	case PNP_ID('I', 'V', 'O'): return "InfoVision Optoelectronics (Kunshan) Co.,Ltd China";
	case PNP_ID('I', 'V', 'R'): return "Inlife-Handnet Co., Ltd.";
	case PNP_ID('I', 'V', 'S'): return "Intevac Photonics Inc.";
	case PNP_ID('I', 'W', 'R'): return "Icuiti Corporation";
	case PNP_ID('I', 'W', 'X'): return "Intelliworxx, Inc.";
	case PNP_ID('I', 'X', 'D'): return "Intertex Data AB";
	case PNP_ID('I', 'X', 'N'): return "Shenzhen Inet Mobile Internet Technology Co., LTD";
	case PNP_ID('J', 'A', 'C'): return "Astec Inc";
	case PNP_ID('J', 'A', 'E'): return "Japan Aviation Electronics Industry, Limited";
	case PNP_ID('J', 'A', 'S'): return "Janz Automationssysteme AG";
	case PNP_ID('J', 'A', 'T'): return "Jaton Corporation";
	case PNP_ID('J', 'A', 'Z'): return "Carrera Computer Inc";
	case PNP_ID('J', 'C', 'E'): return "Jace Tech Inc";
	case PNP_ID('J', 'D', 'I'): return "Japan Display Inc.";
	case PNP_ID('J', 'D', 'L'): return "Japan Digital Laboratory Co.,Ltd.";
	case PNP_ID('J', 'E', 'M'): return "Japan E.M.Solutions Co., Ltd.";
	case PNP_ID('J', 'E', 'N'): return "N-Vision";
	case PNP_ID('J', 'E', 'T'): return "JET POWER TECHNOLOGY CO., LTD.";
	case PNP_ID('J', 'F', 'X'): return "Jones Futurex Inc";
	case PNP_ID('J', 'G', 'D'): return "University College";
	case PNP_ID('J', 'I', 'C'): return "Jaeik Information & Communication Co., Ltd.";
	case PNP_ID('J', 'K', 'C'): return "JVC KENWOOD Corporation";
	case PNP_ID('J', 'L', 'K'): return "UNIONMAN TECHNOLOGY CO., LTD";
	case PNP_ID('J', 'M', 'T'): return "Micro Technical Company Ltd";
	case PNP_ID('J', 'P', 'C'): return "JPC Technology Limited";
	case PNP_ID('J', 'P', 'W'): return "Wallis Hamilton Industries";
	case PNP_ID('J', 'Q', 'E'): return "CNet Technical Inc";
	case PNP_ID('J', 'S', 'D'): return "JS DigiTech, Inc";
	case PNP_ID('J', 'S', 'I'): return "Jupiter Systems, Inc.";
	case PNP_ID('J', 'S', 'K'): return "SANKEN ELECTRIC CO., LTD";
	case PNP_ID('J', 'T', 'S'): return "JS Motorsports";
	case PNP_ID('J', 'T', 'Y'): return "jetway security micro,inc";
	case PNP_ID('J', 'U', 'K'): return "Janich & Klass Computertechnik GmbH";
	case PNP_ID('J', 'U', 'P'): return "Jupiter Systems";
	case PNP_ID('J', 'V', 'C'): return "JVC";
	case PNP_ID('J', 'W', 'D'): return "Video International Inc.";
	case PNP_ID('J', 'W', 'L'): return "Jewell Instruments, LLC";
	case PNP_ID('J', 'W', 'S'): return "JWSpencer & Co.";
	case PNP_ID('J', 'W', 'Y'): return "Jetway Information Co., Ltd";
	case PNP_ID('K', 'A', 'R'): return "Karna";
	case PNP_ID('K', 'B', 'I'): return "Kidboard Inc";
	case PNP_ID('K', 'B', 'L'): return "Kobil Systems GmbH";
	case PNP_ID('K', 'C', 'D'): return "Chunichi Denshi Co.,LTD.";
	case PNP_ID('K', 'C', 'L'): return "Keycorp Ltd";
	case PNP_ID('K', 'D', 'E'): return "KDE";
	case PNP_ID('K', 'D', 'K'): return "Kodiak Tech";
	case PNP_ID('K', 'D', 'M'): return "Korea Data Systems Co., Ltd.";
	case PNP_ID('K', 'D', 'S'): return "KDS USA";
	case PNP_ID('K', 'D', 'T'): return "KDDI Technology Corporation";
	case PNP_ID('K', 'E', 'C'): return "Kyushu Electronics Systems Inc";
	case PNP_ID('K', 'E', 'M'): return "Kontron Embedded Modules GmbH";
	case PNP_ID('K', 'E', 'S'): return "Kesa Corporation";
	case PNP_ID('K', 'E', 'U'): return "Kontron Europe GmbH";
	case PNP_ID('K', 'E', 'Y'): return "Key Tech Inc";
	case PNP_ID('K', 'F', 'C'): return "SCD Tech";
	case PNP_ID('K', 'F', 'E'): return "Komatsu Forest";
	case PNP_ID('K', 'F', 'X'): return "Kofax Image Products";
	case PNP_ID('K', 'G', 'I'): return "Klipsch Group, Inc";
	case PNP_ID('K', 'G', 'L'): return "KEISOKU GIKEN Co.,Ltd.";
	case PNP_ID('K', 'G', 'N'): return "KOGAN AUSTRALIA PTY LTD";
	case PNP_ID('K', 'I', 'O'): return "Kionix, Inc.";
	case PNP_ID('K', 'I', 'S'): return "KiSS Technology A/S";
	case PNP_ID('K', 'L', 'T'): return "Colorlight";
	case PNP_ID('K', 'M', 'C'): return "Mitsumi Company Ltd";
	case PNP_ID('K', 'M', 'E'): return "KIMIN Electronics Co., Ltd.";
	case PNP_ID('K', 'M', 'L'): return "Kensington Microware Ltd";
	case PNP_ID('K', 'M', 'R'): return "Kramer Electronics Ltd. International";
	case PNP_ID('K', 'N', 'C'): return "Konica corporation";
	case PNP_ID('K', 'N', 'X'): return "Nutech Marketing PTL";
	case PNP_ID('K', 'O', 'B'): return "Kobil Systems GmbH";
	case PNP_ID('K', 'O', 'D'): return "Eastman Kodak Company";
	case PNP_ID('K', 'O', 'E'): return "KOLTER ELECTRONIC";
	case PNP_ID('K', 'O', 'L'): return "Kollmorgen Motion Technologies Group";
	case PNP_ID('K', 'O', 'M'): return "Kontron GmbH";
	case PNP_ID('K', 'O', 'P'): return "Kopin Corporation";
	case PNP_ID('K', 'O', 'U'): return "KOUZIRO Co.,Ltd.";
	case PNP_ID('K', 'O', 'W'): return "KOWA Company,LTD.";
	case PNP_ID('K', 'P', 'C'): return "King Phoenix Company";
	case PNP_ID('K', 'P', 'T'): return "TPK Holding Co., Ltd";
	case PNP_ID('K', 'R', 'L'): return "Krell Industries Inc.";
	case PNP_ID('K', 'R', 'M'): return "Kroma Telecom";
	case PNP_ID('K', 'R', 'Y'): return "Kroy LLC";
	case PNP_ID('K', 'S', 'C'): return "Kinetic Systems Corporation";
	case PNP_ID('K', 'S', 'G'): return "KUPA China Shenzhen Micro Technology Co., Ltd. Gold Institute";
	case PNP_ID('K', 'S', 'L'): return "Karn Solutions Ltd.";
	case PNP_ID('K', 'S', 'X'): return "King Tester Corporation";
	case PNP_ID('K', 'T', 'C'): return "Kingston Tech Corporation";
	case PNP_ID('K', 'T', 'D'): return "Takahata Electronics Co.,Ltd.";
	case PNP_ID('K', 'T', 'E'): return "K-Tech";
	case PNP_ID('K', 'T', 'G'): return "Kayser-Threde GmbH";
	case PNP_ID('K', 'T', 'I'): return "Konica Technical Inc";
	case PNP_ID('K', 'T', 'K'): return "Key Tronic Corporation";
	case PNP_ID('K', 'T', 'N'): return "Katron Tech Inc";
	case PNP_ID('K', 'T', 'S'): return "Kyokko Communication System Co., Ltd.";
	case PNP_ID('K', 'U', 'R'): return "Kurta Corporation";
	case PNP_ID('K', 'V', 'A'): return "Kvaser AB";
	case PNP_ID('K', 'V', 'X'): return "KeyView";
	case PNP_ID('K', 'W', 'D'): return "Kenwood Corporation";
	case PNP_ID('K', 'Y', 'C'): return "Kyocera Corporation";
	case PNP_ID('K', 'Y', 'E'): return "KYE Syst Corporation";
	case PNP_ID('K', 'Y', 'K'): return "Samsung Electronics America Inc";
	case PNP_ID('K', 'Y', 'N'): return "KEYENCE CORPORATION";
	case PNP_ID('K', 'Z', 'I'): return "K-Zone International co. Ltd.";
	case PNP_ID('K', 'Z', 'N'): return "K-Zone International";
	case PNP_ID('L', 'A', 'B'): return "ACT Labs Ltd";
	case PNP_ID('L', 'A', 'C'): return "LaCie";
	case PNP_ID('L', 'A', 'F'): return "Microline";
	case PNP_ID('L', 'A', 'G'): return "Laguna Systems";
	case PNP_ID('L', 'A', 'N'): return "Sodeman Lancom Inc";
	case PNP_ID('L', 'A', 'S'): return "LASAT Comm. A/S";
	case PNP_ID('L', 'A', 'V'): return "Lava Computer MFG Inc";
	case PNP_ID('L', 'B', 'O'): return "Lubosoft";
	case PNP_ID('L', 'C', 'C'): return "LCI";
	case PNP_ID('L', 'C', 'D'): return "Toshiba Matsushita Display Technology Co., Ltd";
	case PNP_ID('L', 'C', 'E'): return "La Commande Electronique";
	case PNP_ID('L', 'C', 'I'): return "Lite-On Communication Inc";
	case PNP_ID('L', 'C', 'M'): return "Latitude Comm.";
	case PNP_ID('L', 'C', 'N'): return "LEXICON";
	case PNP_ID('L', 'C', 'P'): return "Silent Power Electronics GmbH";
	case PNP_ID('L', 'C', 'S'): return "Longshine Electronics Company";
	case PNP_ID('L', 'C', 'T'): return "Labcal Technologies";
	case PNP_ID('L', 'D', 'N'): return "Laserdyne Technologies";
	case PNP_ID('L', 'D', 'T'): return "LogiDataTech Electronic GmbH";
	case PNP_ID('L', 'E', 'C'): return "Lectron Company Ltd";
	case PNP_ID('L', 'E', 'D'): return "Long Engineering Design Inc";
	case PNP_ID('L', 'E', 'G'): return "Legerity, Inc";
	case PNP_ID('L', 'E', 'N'): return "Lenovo Group Limited";
	case PNP_ID('L', 'E', 'O'): return "First International Computer Inc";
	case PNP_ID('L', 'E', 'X'): return "Lexical Ltd";
	case PNP_ID('L', 'G', 'C'): return "Logic Ltd";
	case PNP_ID('L', 'G', 'D'): return "LG Display";
	case PNP_ID('L', 'G', 'I'): return "Logitech Inc";
	case PNP_ID('L', 'G', 'S'): return "LG Semicom Company Ltd";
	case PNP_ID('L', 'G', 'X'): return "Lasergraphics, Inc.";
	case PNP_ID('L', 'H', 'A'): return "Lars Haagh ApS";
	case PNP_ID('L', 'H', 'C'): return "Beihai Century Joint Innovation Technology Co.,Ltd";
	case PNP_ID('L', 'H', 'E'): return "Lung Hwa Electronics Company Ltd";
	case PNP_ID('L', 'H', 'T'): return "Lighthouse Technologies Limited";
	case PNP_ID('L', 'I', 'N'): return "Lenovo Beijing Co. Ltd.";
	case PNP_ID('L', 'I', 'P'): return "Linked IP GmbH";
	case PNP_ID('L', 'I', 'S'): return "Life is Style Inc.";
	case PNP_ID('L', 'I', 'T'): return "Lithics Silicon Technology";
	case PNP_ID('L', 'J', 'X'): return "Datalogic Corporation";
	case PNP_ID('L', 'K', 'M'): return "Likom Technology Sdn. Bhd.";
	case PNP_ID('L', 'L', 'L'): return "L-3 Communications";
	case PNP_ID('L', 'L', 'T'): return "LUMINO Licht Elektronik GmbH";
	case PNP_ID('L', 'M', 'G'): return "Lucent Technologies";
	case PNP_ID('L', 'M', 'I'): return "Lexmark Int'l Inc";
	case PNP_ID('L', 'M', 'P'): return "Leda Media Products";
	case PNP_ID('L', 'M', 'S'): return "Lumens Digital Optics Inc.";
	case PNP_ID('L', 'M', 'T'): return "Laser Master";
	case PNP_ID('L', 'N', 'C'): return "Lincoln Technology Solutions";
	case PNP_ID('L', 'N', 'D'): return "Land Computer Company Ltd";
	case PNP_ID('L', 'N', 'K'): return "Link Tech Inc";
	case PNP_ID('L', 'N', 'R'): return "Linear Systems Ltd.";
	case PNP_ID('L', 'N', 'T'): return "LANETCO International";
	case PNP_ID('L', 'N', 'V'): return "Lenovo";
	case PNP_ID('L', 'N', 'X'): return "The Linux Foundation";
	case PNP_ID('L', 'O', 'C'): return "Locamation B.V.";
	case PNP_ID('L', 'O', 'E'): return "Loewe Opta GmbH";
	case PNP_ID('L', 'O', 'G'): return "Logicode Technology Inc";
	case PNP_ID('L', 'O', 'L'): return "Litelogic Operations Ltd";
	case PNP_ID('L', 'P', 'E'): return "El-PUSK Co., Ltd.";
	case PNP_ID('L', 'P', 'I'): return "Design Technology";
	case PNP_ID('L', 'P', 'L'): return "LG Philips";
	case PNP_ID('L', 'S', 'C'): return "LifeSize Communications";
	case PNP_ID('L', 'S', 'D'): return "Intersil Corporation";
	case PNP_ID('L', 'S', 'I'): return "Loughborough Sound Images";
	case PNP_ID('L', 'S', 'J'): return "LSI Japan Company Ltd";
	case PNP_ID('L', 'S', 'L'): return "Logical Solutions";
	case PNP_ID('L', 'S', 'P'): return "Lightspace Technologies";
	case PNP_ID('L', 'S', 'Y'): return "LSI Systems Inc";
	case PNP_ID('L', 'T', 'C'): return "Labtec Inc";
	case PNP_ID('L', 'T', 'I'): return "Jongshine Tech Inc";
	case PNP_ID('L', 'T', 'K'): return "Lucidity Technology Company Ltd";
	case PNP_ID('L', 'T', 'N'): return "Litronic Inc";
	case PNP_ID('L', 'T', 'S'): return "LTS Scale LLC";
	case PNP_ID('L', 'T', 'V'): return "Leitch Technology International Inc.";
	case PNP_ID('L', 'T', 'W'): return "Lightware, Inc";
	case PNP_ID('L', 'U', 'C'): return "Lucent Technologies";
	case PNP_ID('L', 'U', 'M'): return "Lumagen, Inc.";
	case PNP_ID('L', 'U', 'X'): return "Luxxell Research Inc";
	case PNP_ID('L', 'V', 'I'): return "LVI Low Vision International AB";
	case PNP_ID('L', 'W', 'C'): return "Labway Corporation";
	case PNP_ID('L', 'W', 'R'): return "Lightware Visual Engineering";
	case PNP_ID('L', 'W', 'W'): return "Lanier Worldwide";
	case PNP_ID('L', 'X', 'C'): return "LXCO Technologies AG";
	case PNP_ID('L', 'X', 'N'): return "Luxeon";
	case PNP_ID('L', 'X', 'S'): return "ELEA CardWare";
	case PNP_ID('L', 'Z', 'X'): return "Lightwell Company Ltd";
	case PNP_ID('M', 'A', 'C'): return "MAC System Company Ltd";
	case PNP_ID('M', 'A', 'D'): return "Xedia Corporation";
	case PNP_ID('M', 'A', 'E'): return "Maestro Pty Ltd";
	case PNP_ID('M', 'A', 'G'): return "MAG InnoVision";
	case PNP_ID('M', 'A', 'I'): return "Mutoh America Inc";
	case PNP_ID('M', 'A', 'L'): return "Meridian Audio Ltd";
	case PNP_ID('M', 'A', 'N'): return "LGIC";
	case PNP_ID('M', 'A', 'S'): return "Mass Inc.";
	case PNP_ID('M', 'A', 'T'): return "Panasonic Connect Co.,Ltd.";
	case PNP_ID('M', 'A', 'X'): return "Rogen Tech Distribution Inc";
	case PNP_ID('M', 'A', 'Y'): return "Maynard Electronics";
	case PNP_ID('M', 'A', 'Z'): return "MAZeT GmbH";
	case PNP_ID('M', 'B', 'C'): return "MBC";
	case PNP_ID('M', 'B', 'D'): return "Microbus PLC";
	case PNP_ID('M', 'B', 'M'): return "Marshall Electronics";
	case PNP_ID('M', 'B', 'V'): return "Moreton Bay";
	case PNP_ID('M', 'C', 'A'): return "American Nuclear Systems Inc";
	case PNP_ID('M', 'C', 'C'): return "Micro Industries";
	case PNP_ID('M', 'C', 'D'): return "McDATA Corporation";
	case PNP_ID('M', 'C', 'E'): return "Metz-Werke GmbH & Co KG";
	case PNP_ID('M', 'C', 'G'): return "Motorola Computer Group";
	case PNP_ID('M', 'C', 'I'): return "Micronics Computers";
	case PNP_ID('M', 'C', 'J'): return "Medicaroid Corporation";
	case PNP_ID('M', 'C', 'L'): return "Motorola Communications Israel";
	case PNP_ID('M', 'C', 'M'): return "Metricom Inc";
	case PNP_ID('M', 'C', 'N'): return "Micron Electronics Inc";
	case PNP_ID('M', 'C', 'O'): return "Motion Computing Inc.";
	case PNP_ID('M', 'C', 'P'): return "Magni Systems Inc";
	case PNP_ID('M', 'C', 'Q'): return "Mat's Computers";
	case PNP_ID('M', 'C', 'R'): return "Marina Communicaitons";
	case PNP_ID('M', 'C', 'S'): return "Micro Computer Systems";
	case PNP_ID('M', 'C', 'T'): return "Microtec";
	case PNP_ID('M', 'C', 'X'): return "Millson Custom Solutions Inc.";
	case PNP_ID('M', 'D', 'A'): return "Media4 Inc";
	case PNP_ID('M', 'D', 'C'): return "Midori Electronics";
	case PNP_ID('M', 'D', 'D'): return "MODIS";
	case PNP_ID('M', 'D', 'F'): return "MILDEF AB";
	case PNP_ID('M', 'D', 'G'): return "Madge Networks";
	case PNP_ID('M', 'D', 'I'): return "Micro Design Inc";
	case PNP_ID('M', 'D', 'K'): return "Mediatek Corporation";
	case PNP_ID('M', 'D', 'O'): return "Panasonic";
	case PNP_ID('M', 'D', 'R'): return "Medar Inc";
	case PNP_ID('M', 'D', 'S'): return "Micro Display Systems Inc";
	case PNP_ID('M', 'D', 'T'): return "Magus Data Tech";
	case PNP_ID('M', 'D', 'V'): return "MET Development Inc";
	case PNP_ID('M', 'D', 'X'): return "MicroDatec GmbH";
	case PNP_ID('M', 'D', 'Y'): return "Microdyne Inc";
	case PNP_ID('M', 'E', 'C'): return "Mega System Technologies Inc";
	case PNP_ID('M', 'E', 'D'): return "Messeltronik Dresden GmbH";
	case PNP_ID('M', 'E', 'E'): return "Mitsubishi Electric Engineering Co., Ltd.";
	case PNP_ID('M', 'E', 'G'): return "Abeam Tech Ltd.";
	case PNP_ID('M', 'E', 'I'): return "Panasonic Industry Company";
	case PNP_ID('M', 'E', 'J'): return "Mac-Eight Co., LTD.";
	case PNP_ID('M', 'E', 'K'): return "Mediaedge Corporation";
	case PNP_ID('M', 'E', 'L'): return "Mitsubishi Electric Corporation";
	case PNP_ID('M', 'E', 'N'): return "MEN Mikroelectronik Nueruberg GmbH";
	case PNP_ID('M', 'E', 'P'): return "Meld Technology";
	case PNP_ID('M', 'E', 'Q'): return "Matelect Ltd.";
	case PNP_ID('M', 'E', 'T'): return "Metheus Corporation";
	case PNP_ID('M', 'E', 'U'): return "MPL AG, Elektronik-Unternehmen";
	case PNP_ID('M', 'E', 'X'): return "MSC Vertriebs GmbH";
	case PNP_ID('M', 'F', 'G'): return "MicroField Graphics Inc";
	case PNP_ID('M', 'F', 'I'): return "Micro Firmware";
	case PNP_ID('M', 'F', 'R'): return "MediaFire Corp.";
	case PNP_ID('M', 'G', 'A'): return "Mega System Technologies, Inc.";
	case PNP_ID('M', 'G', 'C'): return "Mentor Graphics Corporation";
	case PNP_ID('M', 'G', 'E'): return "Schneider Electric S.A.";
	case PNP_ID('M', 'G', 'L'): return "M-G Technology Ltd";
	case PNP_ID('M', 'G', 'T'): return "Megatech R & D Company";
	case PNP_ID('M', 'H', 'Q'): return "Moxa Inc.";
	case PNP_ID('M', 'I', 'C'): return "Micom Communications Inc";
	case PNP_ID('M', 'I', 'D'): return "miro Displays";
	case PNP_ID('M', 'I', 'I'): return "Mitec Inc";
	case PNP_ID('M', 'I', 'L'): return "Marconi Instruments Ltd";
	case PNP_ID('M', 'I', 'M'): return "Mimio – A Newell Rubbermaid Company";
	case PNP_ID('M', 'I', 'N'): return "Minicom Digital Signage";
	case PNP_ID('M', 'I', 'P'): return "micronpc.com";
	case PNP_ID('M', 'I', 'R'): return "Miro Computer Prod.";
	case PNP_ID('M', 'I', 'S'): return "Modular Industrial Solutions Inc";
	case PNP_ID('M', 'I', 'T'): return "MCM Industrial Technology GmbH";
	case PNP_ID('M', 'I', 'V'): return "MicroImage Video Systems";
	case PNP_ID('M', 'J', 'I'): return "MARANTZ JAPAN, INC.";
	case PNP_ID('M', 'J', 'S'): return "MJS Designs";
	case PNP_ID('M', 'K', 'C'): return "Media Tek Inc.";
	case PNP_ID('M', 'K', 'S'): return "MK Seiko Co., Ltd.";
	case PNP_ID('M', 'K', 'T'): return "MICROTEK Inc.";
	case PNP_ID('M', 'K', 'V'): return "Trtheim Technology";
	case PNP_ID('M', 'L', 'C'): return "MILCOTS";
	case PNP_ID('M', 'L', 'D'): return "Deep Video Imaging Ltd";
	case PNP_ID('M', 'L', 'G'): return "Micrologica AG";
	case PNP_ID('M', 'L', 'I'): return "McIntosh Laboratory Inc.";
	case PNP_ID('M', 'L', 'L'): return "Millogic Ltd.";
	case PNP_ID('M', 'L', 'M'): return "Millennium Engineering Inc";
	case PNP_ID('M', 'L', 'N'): return "Mark Levinson";
	case PNP_ID('M', 'L', 'P'): return "Magic Leap";
	case PNP_ID('M', 'L', 'S'): return "Milestone EPE";
	case PNP_ID('M', 'L', 'T'): return "Wanlida Group Co., Ltd.";
	case PNP_ID('M', 'L', 'X'): return "Mylex Corporation";
	case PNP_ID('M', 'M', 'A'): return "Micromedia AG";
	case PNP_ID('M', 'M', 'D'): return "Micromed Biotecnologia Ltd";
	case PNP_ID('M', 'M', 'F'): return "Minnesota Mining and Manufacturing";
	case PNP_ID('M', 'M', 'I'): return "Multimax";
	case PNP_ID('M', 'M', 'M'): return "Electronic Measurements";
	case PNP_ID('M', 'M', 'N'): return "MiniMan Inc";
	case PNP_ID('M', 'M', 'S'): return "MMS Electronics";
	case PNP_ID('M', 'M', 'T'): return "MIMO Monitors";
	case PNP_ID('M', 'N', 'C'): return "Mini Micro Methods Ltd";
	case PNP_ID('M', 'N', 'I'): return "Marseille, Inc.";
	case PNP_ID('M', 'N', 'L'): return "Monorail Inc";
	case PNP_ID('M', 'N', 'P'): return "Microcom";
	case PNP_ID('M', 'N', 'S'): return "Maxnerva Technology Services Limited";
	case PNP_ID('M', 'O', 'C'): return "Matrix Orbital Corporation";
	case PNP_ID('M', 'O', 'D'): return "Modular Technology";
	case PNP_ID('M', 'O', 'K'): return "Moka International limited";
	case PNP_ID('M', 'O', 'M'): return "Momentum Data Systems";
	case PNP_ID('M', 'O', 'S'): return "Moses Corporation";
	case PNP_ID('M', 'O', 'T'): return "Motorola UDS";
	case PNP_ID('M', 'P', 'C'): return "M-Pact Inc";
	case PNP_ID('M', 'P', 'I'): return "Mediatrix Peripherals Inc";
	case PNP_ID('M', 'P', 'J'): return "Microlab";
	case PNP_ID('M', 'P', 'L'): return "Maple Research Inst. Company Ltd";
	case PNP_ID('M', 'P', 'N'): return "Mainpine Limited";
	case PNP_ID('M', 'P', 'S'): return "mps Software GmbH";
	case PNP_ID('M', 'P', 'V'): return "Megapixel Visual Realty";
	case PNP_ID('M', 'P', 'X'): return "Micropix Technologies, Ltd.";
	case PNP_ID('M', 'Q', 'P'): return "MultiQ Products AB";
	case PNP_ID('M', 'R', 'A'): return "Miranda Technologies Inc";
	case PNP_ID('M', 'R', 'C'): return "Marconi Simulation & Ty-Coch Way Training";
	case PNP_ID('M', 'R', 'D'): return "MicroDisplay Corporation";
	case PNP_ID('M', 'R', 'G'): return "Nreal";
	case PNP_ID('M', 'R', 'K'): return "Maruko & Company Ltd";
	case PNP_ID('M', 'R', 'L'): return "Miratel";
	case PNP_ID('M', 'R', 'O'): return "Medikro Oy";
	case PNP_ID('M', 'R', 'T'): return "Merging Technologies";
	case PNP_ID('M', 'S', 'A'): return "Micro Systemation AB";
	case PNP_ID('M', 'S', 'C'): return "Mouse Systems Corporation";
	case PNP_ID('M', 'S', 'D'): return "Datenerfassungs- und Informationssysteme";
	case PNP_ID('M', 'S', 'F'): return "M-Systems Flash Disk Pioneers";
	case PNP_ID('M', 'S', 'G'): return "MSI GmbH";
	case PNP_ID('M', 'S', 'H'): return "Microsoft";
	case PNP_ID('M', 'S', 'I'): return "Microstep";
	case PNP_ID('M', 'S', 'K'): return "Megasoft Inc";
	case PNP_ID('M', 'S', 'L'): return "MicroSlate Inc.";
	case PNP_ID('M', 'S', 'M'): return "Advanced Digital Systems";
	case PNP_ID('M', 'S', 'P'): return "Mistral Solutions [P] Ltd.";
	case PNP_ID('M', 'S', 'R'): return "MASPRO DENKOH Corp.";
	case PNP_ID('M', 'S', 'T'): return "MS Telematica";
	case PNP_ID('M', 'S', 'U'): return "motorola";
	case PNP_ID('M', 'S', 'V'): return "Mosgi Corporation";
	case PNP_ID('M', 'S', 'X'): return "Micomsoft Co., Ltd.";
	case PNP_ID('M', 'S', 'Y'): return "MicroTouch Systems Inc";
	case PNP_ID('M', 'T', 'A'): return "Meta Watch Ltd";
	case PNP_ID('M', 'T', 'B'): return "Media Technologies Ltd.";
	case PNP_ID('M', 'T', 'C'): return "Mars-Tech Corporation";
	case PNP_ID('M', 'T', 'D'): return "MindTech Display Co. Ltd";
	case PNP_ID('M', 'T', 'E'): return "MediaTec GmbH";
	case PNP_ID('M', 'T', 'H'): return "Micro-Tech Hearing Instruments";
	case PNP_ID('M', 'T', 'I'): return "MaxCom Technical Inc";
	case PNP_ID('M', 'T', 'J'): return "MicroTechnica Co.,Ltd.";
	case PNP_ID('M', 'T', 'K'): return "Microtek International Inc.";
	case PNP_ID('M', 'T', 'L'): return "Mitel Corporation";
	case PNP_ID('M', 'T', 'M'): return "Motium";
	case PNP_ID('M', 'T', 'N'): return "Mtron Storage Technology Co., Ltd.";
	case PNP_ID('M', 'T', 'R'): return "Mitron computer Inc";
	case PNP_ID('M', 'T', 'S'): return "Multi-Tech Systems";
	case PNP_ID('M', 'T', 'T'): return "Moore Threads Virtual Display";
	case PNP_ID('M', 'T', 'U'): return "Mark of the Unicorn Inc";
	case PNP_ID('M', 'T', 'X'): return "Matrox";
	case PNP_ID('M', 'U', 'D'): return "Multi-Dimension Institute";
	case PNP_ID('M', 'U', 'K'): return "Mainpine Limited";
	case PNP_ID('M', 'V', 'D'): return "Microvitec PLC";
	case PNP_ID('M', 'V', 'I'): return "Media Vision Inc";
	case PNP_ID('M', 'V', 'M'): return "SOBO VISION";
	case PNP_ID('M', 'V', 'N'): return "Meta Company";
	case PNP_ID('M', 'V', 'R'): return "MediCapture, Inc.";
	case PNP_ID('M', 'V', 'S'): return "Microvision";
	case PNP_ID('M', 'V', 'X'): return "COM 1";
	case PNP_ID('M', 'W', 'I'): return "Multiwave Innovation Pte Ltd";
	case PNP_ID('M', 'W', 'R'): return "mware";
	case PNP_ID('M', 'W', 'Y'): return "Microway Inc";
	case PNP_ID('M', 'X', 'D'): return "MaxData Computer GmbH & Co.KG";
	case PNP_ID('M', 'X', 'I'): return "Macronix Inc";
	case PNP_ID('M', 'X', 'L'): return "Hitachi Maxell, Ltd.";
	case PNP_ID('M', 'X', 'M'): return "C&T Solution Inc.";
	case PNP_ID('M', 'X', 'P'): return "Maxpeed Corporation";
	case PNP_ID('M', 'X', 'T'): return "Maxtech Corporation";
	case PNP_ID('M', 'X', 'V'): return "MaxVision Corporation";
	case PNP_ID('M', 'Y', 'A'): return "Monydata";
	case PNP_ID('M', 'Y', 'R'): return "Myriad Solutions Ltd";
	case PNP_ID('M', 'Y', 'X'): return "Micronyx Inc";
	case PNP_ID('N', 'A', 'C'): return "Ncast Corporation";
	case PNP_ID('N', 'A', 'D'): return "NAD Electronics";
	case PNP_ID('N', 'A', 'F'): return "NAFASAE INDIA Pvt. Ltd";
	case PNP_ID('N', 'A', 'K'): return "Nakano Engineering Co.,Ltd.";
	case PNP_ID('N', 'A', 'L'): return "Network Alchemy";
	case PNP_ID('N', 'A', 'T'): return "NaturalPoint Inc.";
	case PNP_ID('N', 'A', 'V'): return "Navigation Corporation";
	case PNP_ID('N', 'A', 'X'): return "Naxos Tecnologia";
	case PNP_ID('N', 'B', 'L'): return "N*Able Technologies Inc";
	case PNP_ID('N', 'B', 'S'): return "National Key Lab. on ISN";
	case PNP_ID('N', 'B', 'T'): return "NingBo Bestwinning Technology CO., Ltd";
	case PNP_ID('N', 'C', 'A'): return "Nixdorf Company";
	case PNP_ID('N', 'C', 'C'): return "NCR Corporation";
	case PNP_ID('N', 'C', 'E'): return "Norcent Technology, Inc.";
	case PNP_ID('N', 'C', 'I'): return "NewCom Inc";
	case PNP_ID('N', 'C', 'L'): return "NetComm Ltd";
	case PNP_ID('N', 'C', 'P'): return "Najing CEC Panda FPD Technology CO. ltd";
	case PNP_ID('N', 'C', 'R'): return "NCR Electronics";
	case PNP_ID('N', 'C', 'S'): return "Northgate Computer Systems";
	case PNP_ID('N', 'C', 'T'): return "NEC CustomTechnica, Ltd.";
	case PNP_ID('N', 'C', 'V'): return "NewCoSemi (Beijing) Technology CO.,Ltd.";
	case PNP_ID('N', 'D', 'C'): return "National DataComm Corporaiton";
	case PNP_ID('N', 'D', 'F'): return "NDF Special Light Products B.V.";
	case PNP_ID('N', 'D', 'I'): return "National Display Systems";
	case PNP_ID('N', 'D', 'K'): return "Naitoh Densei CO., LTD.";
	case PNP_ID('N', 'D', 'L'): return "Network Designers";
	case PNP_ID('N', 'D', 'S'): return "Nokia Data";
	case PNP_ID('N', 'E', 'C'): return "NEC Corporation";
	case PNP_ID('N', 'E', 'O'): return "NEO TELECOM CO.,LTD.";
	case PNP_ID('N', 'E', 'S'): return "INNES";
	case PNP_ID('N', 'E', 'T'): return "Mettler Toledo";
	case PNP_ID('N', 'E', 'U'): return "NEUROTEC - EMPRESA DE PESQUISA E DESENVOLVIMENTO EM BIOMEDICINA";
	case PNP_ID('N', 'E', 'X'): return "Nexgen Mediatech Inc.,";
	case PNP_ID('N', 'F', 'C'): return "BTC Korea Co., Ltd";
	case PNP_ID('N', 'F', 'S'): return "Number Five Software";
	case PNP_ID('N', 'G', 'C'): return "Network General";
	case PNP_ID('N', 'G', 'S'): return "A D S Exports";
	case PNP_ID('N', 'H', 'C'): return "New H3C Technology Co., Ltd.";
	case PNP_ID('N', 'H', 'T'): return "Vinci Labs";
	case PNP_ID('N', 'I', 'C'): return "National Instruments Corporation";
	case PNP_ID('N', 'I', 'S'): return "Nissei Electric Company";
	case PNP_ID('N', 'I', 'T'): return "Network Info Technology";
	case PNP_ID('N', 'I', 'X'): return "Seanix Technology Inc";
	case PNP_ID('N', 'L', 'C'): return "Next Level Communications";
	case PNP_ID('N', 'M', 'E'): return "Navico, Inc.";
	case PNP_ID('N', 'M', 'P'): return "Nokia Mobile Phones";
	case PNP_ID('N', 'M', 'S'): return "Natural Micro System";
	case PNP_ID('N', 'M', 'V'): return "NEC-Mitsubishi Electric Visual Systems Corporation";
	case PNP_ID('N', 'M', 'X'): return "Neomagic";
	case PNP_ID('N', 'N', 'C'): return "NNC";
	case PNP_ID('N', 'O', 'D'): return "3NOD Digital Technology Co. Ltd.";
	case PNP_ID('N', 'O', 'E'): return "NordicEye AB";
	case PNP_ID('N', 'O', 'I'): return "North Invent A/S";
	case PNP_ID('N', 'O', 'K'): return "Nokia Display Products";
	case PNP_ID('N', 'O', 'R'): return "Norand Corporation";
	case PNP_ID('N', 'O', 'T'): return "Not Limited Inc";
	case PNP_ID('N', 'P', 'A'): return "Arvanics";
	case PNP_ID('N', 'P', 'I'): return "Network Peripherals Inc";
	case PNP_ID('N', 'R', 'I'): return "Noritake Itron Corporation";
	case PNP_ID('N', 'R', 'L'): return "U.S. Naval Research Lab";
	case PNP_ID('N', 'R', 'T'): return "Beijing Northern Radiantelecom Co.";
	case PNP_ID('N', 'R', 'V'): return "Taugagreining hf";
	case PNP_ID('N', 'S', 'A'): return "NeuroSky, Inc.";
	case PNP_ID('N', 'S', 'C'): return "National Semiconductor Corporation";
	case PNP_ID('N', 'S', 'I'): return "NISSEI ELECTRIC CO.,LTD";
	case PNP_ID('N', 'S', 'P'): return "Nspire System Inc.";
	case PNP_ID('N', 'S', 'S'): return "Newport Systems Solutions";
	case PNP_ID('N', 'S', 'T'): return "Network Security Technology Co";
	case PNP_ID('N', 'T', 'C'): return "NeoTech S.R.L";
	case PNP_ID('N', 'T', 'I'): return "New Tech Int'l Company";
	case PNP_ID('N', 'T', 'K'): return "NewTek";
	case PNP_ID('N', 'T', 'L'): return "National Transcomm. Ltd";
	case PNP_ID('N', 'T', 'N'): return "Nuvoton Technology Corporation";
	case PNP_ID('N', 'T', 'R'): return "N-trig Innovative Technologies, Inc.";
	case PNP_ID('N', 'T', 'S'): return "Nits Technology Inc.";
	case PNP_ID('N', 'T', 'T'): return "NTT Advanced Technology Corporation";
	case PNP_ID('N', 'T', 'W'): return "Networth Inc";
	case PNP_ID('N', 'T', 'X'): return "Netaccess Inc";
	case PNP_ID('N', 'U', 'G'): return "NU Technology, Inc.";
	case PNP_ID('N', 'U', 'I'): return "NU Inc.";
	case PNP_ID('N', 'V', 'C'): return "NetVision Corporation";
	case PNP_ID('N', 'V', 'D'): return "Nvidia";
	case PNP_ID('N', 'V', 'I'): return "NuVision US, Inc.";
	case PNP_ID('N', 'V', 'L'): return "Novell Inc";
	case PNP_ID('N', 'V', 'O'): return "Netvio Ltd.";
	case PNP_ID('N', 'V', 'R'): return "NOLO CO., LTD.";
	case PNP_ID('N', 'V', 'T'): return "Navatek Engineering Corporation";
	case PNP_ID('N', 'W', 'C'): return "NW Computer Engineering";
	case PNP_ID('N', 'W', 'L'): return "Newline Interactive Inc.";
	case PNP_ID('N', 'W', 'P'): return "NovaWeb Technologies Inc";
	case PNP_ID('N', 'W', 'S'): return "Newisys, Inc.";
	case PNP_ID('N', 'X', 'C'): return "NextCom K.K.";
	case PNP_ID('N', 'X', 'E'): return "Norxe AS";
	case PNP_ID('N', 'X', 'G'): return "Nexgen";
	case PNP_ID('N', 'X', 'P'): return "NXP Semiconductors bv.";
	case PNP_ID('N', 'X', 'Q'): return "Nexiq Technologies, Inc.";
	case PNP_ID('N', 'X', 'R'): return "Nextorage Corporation";
	case PNP_ID('N', 'X', 'S'): return "Technology Nexus Secure Open Systems AB";
	case PNP_ID('N', 'X', 'T'): return "NZXT (PNP same EDID)_";
	case PNP_ID('N', 'Y', 'C'): return "Nakayo Relecommunications, Inc.";
	case PNP_ID('O', 'A', 'K'): return "Oak Tech Inc";
	case PNP_ID('O', 'A', 'S'): return "Oasys Technology Company";
	case PNP_ID('O', 'B', 'S'): return "Optibase Technologies";
	case PNP_ID('O', 'C', 'D'): return "Macraigor Systems Inc";
	case PNP_ID('O', 'C', 'N'): return "Olfan";
	case PNP_ID('O', 'C', 'S'): return "Open Connect Solutions";
	case PNP_ID('O', 'D', 'M'): return "ODME Inc.";
	case PNP_ID('O', 'D', 'R'): return "Odrac";
	case PNP_ID('O', 'E', 'C'): return "ORION ELECTRIC CO.,LTD";
	case PNP_ID('O', 'E', 'I'): return "Optum Engineering Inc.";
	case PNP_ID('O', 'F', 'I'): return "Jiangxi Jinghao Optical Co., Ltd.";
	case PNP_ID('O', 'H', 'W'): return "M-Labs Limited";
	case PNP_ID('O', 'I', 'C'): return "Option Industrial Computers";
	case PNP_ID('O', 'I', 'M'): return "Option International";
	case PNP_ID('O', 'I', 'N'): return "Option International";
	case PNP_ID('O', 'K', 'I'): return "OKI Electric Industrial Company Ltd";
	case PNP_ID('O', 'L', 'C'): return "Olicom A/S";
	case PNP_ID('O', 'L', 'D'): return "Olidata S.p.A.";
	case PNP_ID('O', 'L', 'I'): return "Olivetti";
	case PNP_ID('O', 'L', 'T'): return "Olitec S.A.";
	case PNP_ID('O', 'L', 'V'): return "Olitec S.A.";
	case PNP_ID('O', 'L', 'Y'): return "OLYMPUS CORPORATION";
	case PNP_ID('O', 'M', 'C'): return "OBJIX Multimedia Corporation";
	case PNP_ID('O', 'M', 'G'): return "RODE";
	case PNP_ID('O', 'M', 'N'): return "Omnitel";
	case PNP_ID('O', 'M', 'R'): return "Omron Corporation";
	case PNP_ID('O', 'N', 'E'): return "Oneac Corporation";
	case PNP_ID('O', 'N', 'K'): return "ONKYO Corporation";
	case PNP_ID('O', 'N', 'L'): return "OnLive, Inc";
	case PNP_ID('O', 'N', 'S'): return "On Systems Inc";
	case PNP_ID('O', 'N', 'W'): return "OPEN Networks Ltd";
	case PNP_ID('O', 'N', 'X'): return "SOMELEC Z.I. Du Vert Galanta";
	case PNP_ID('O', 'O', 'S'): return "OSRAM";
	case PNP_ID('O', 'P', 'C'): return "Opcode Inc";
	case PNP_ID('O', 'P', 'I'): return "D.N.S. Corporation";
	case PNP_ID('O', 'P', 'P'): return "OPPO Digital, Inc.";
	case PNP_ID('O', 'P', 'T'): return "OPTi Inc";
	case PNP_ID('O', 'P', 'V'): return "Optivision Inc";
	case PNP_ID('O', 'Q', 'I'): return "Oksori Company Ltd";
	case PNP_ID('O', 'R', 'G'): return "ORGA Kartensysteme GmbH";
	case PNP_ID('O', 'R', 'I'): return "OSR Open Systems Resources, Inc.";
	case PNP_ID('O', 'R', 'N'): return "ORION ELECTRIC CO., LTD.";
	case PNP_ID('O', 'S', 'A'): return "OSAKA Micro Computer, Inc.";
	case PNP_ID('O', 'S', 'D'): return "Optical Systems Design Pty Ltd";
	case PNP_ID('O', 'S', 'I'): return "Open Stack, Inc.";
	case PNP_ID('O', 'S', 'P'): return "OPTI-UPS Corporation";
	case PNP_ID('O', 'S', 'R'): return "Oksori Company Ltd";
	case PNP_ID('O', 'T', 'B'): return "outsidetheboxstuff.com";
	case PNP_ID('O', 'T', 'I'): return "Orchid Technology";
	case PNP_ID('O', 'T', 'K'): return "OmniTek";
	case PNP_ID('O', 'T', 'M'): return "Optoma Corporation";
	case PNP_ID('O', 'T', 'T'): return "OPTO22, Inc.";
	case PNP_ID('O', 'U', 'K'): return "OUK Company Ltd";
	case PNP_ID('O', 'V', 'R'): return "Oculus VR, Inc.";
	case PNP_ID('O', 'W', 'L'): return "Mediacom Technologies Pte Ltd";
	case PNP_ID('O', 'X', 'U'): return "Oxus Research S.A.";
	case PNP_ID('O', 'Y', 'O'): return "Shadow Systems";
	case PNP_ID('O', 'Z', 'C'): return "OZ Corporation";
	case PNP_ID('O', 'Z', 'D'): return "OZO Co.Ltd";
	case PNP_ID('O', 'Z', 'O'): return "Tribe Computer Works Inc";
	case PNP_ID('P', 'A', 'C'): return "Pacific Avionics Corporation";
	case PNP_ID('P', 'A', 'D'): return "Promotion and Display Technology Ltd.";
	case PNP_ID('P', 'A', 'E'): return "PreSonus Audio Electronics";
	case PNP_ID('P', 'A', 'K'): return "Many CNC System Co., Ltd.";
	case PNP_ID('P', 'A', 'M'): return "Peter Antesberger Messtechnik";
	case PNP_ID('P', 'A', 'N'): return "The Panda Project";
	case PNP_ID('P', 'A', 'R'): return "Parallan Comp Inc";
	case PNP_ID('P', 'B', 'I'): return "Pitney Bowes";
	case PNP_ID('P', 'B', 'L'): return "Packard Bell Electronics";
	case PNP_ID('P', 'B', 'N'): return "Packard Bell NEC";
	case PNP_ID('P', 'B', 'V'): return "Pitney Bowes";
	case PNP_ID('P', 'C', 'A'): return "Philips BU Add On Card";
	case PNP_ID('P', 'C', 'B'): return "OCTAL S.A.";
	case PNP_ID('P', 'C', 'C'): return "PowerCom Technology Company Ltd";
	case PNP_ID('P', 'C', 'G'): return "First Industrial Computer Inc";
	case PNP_ID('P', 'C', 'I'): return "Pioneer Computer Inc";
	case PNP_ID('P', 'C', 'K'): return "PCBANK21";
	case PNP_ID('P', 'C', 'L'): return "pentel.co.,ltd";
	case PNP_ID('P', 'C', 'M'): return "PCM Systems Corporation";
	case PNP_ID('P', 'C', 'O'): return "Performance Concepts Inc.,";
	case PNP_ID('P', 'C', 'P'): return "Procomp USA Inc";
	case PNP_ID('P', 'C', 'S'): return "TOSHIBA PERSONAL COMPUTER SYSTEM CORPRATION";
	case PNP_ID('P', 'C', 'T'): return "PC-Tel Inc";
	case PNP_ID('P', 'C', 'W'): return "Pacific CommWare Inc";
	case PNP_ID('P', 'C', 'X'): return "PC Xperten";
	case PNP_ID('P', 'D', 'M'): return "Psion Dacom Plc.";
	case PNP_ID('P', 'D', 'N'): return "AT&T Paradyne";
	case PNP_ID('P', 'D', 'R'): return "Pure Data Inc";
	case PNP_ID('P', 'D', 'S'): return "PD Systems International Ltd";
	case PNP_ID('P', 'D', 'T'): return "PDTS - Prozessdatentechnik und Systeme";
	case PNP_ID('P', 'D', 'V'): return "Prodrive B.V.";
	case PNP_ID('P', 'E', 'C'): return "POTRANS Electrical Corp.";
	case PNP_ID('P', 'E', 'G'): return "Pegatron Corporation";
	case PNP_ID('P', 'E', 'I'): return "PEI Electronics Inc";
	case PNP_ID('P', 'E', 'L'): return "Primax Electric Ltd";
	case PNP_ID('P', 'E', 'N'): return "Interactive Computer Products Inc";
	case PNP_ID('P', 'E', 'P'): return "Peppercon AG";
	case PNP_ID('P', 'E', 'R'): return "Perceptive Signal Technologies";
	case PNP_ID('P', 'E', 'T'): return "Practical Electronic Tools";
	case PNP_ID('P', 'F', 'T'): return "Telia ProSoft AB";
	case PNP_ID('P', 'G', 'I'): return "PACSGEAR, Inc.";
	case PNP_ID('P', 'G', 'M'): return "Paradigm Advanced Research Centre";
	case PNP_ID('P', 'G', 'P'): return "propagamma kommunikation";
	case PNP_ID('P', 'G', 'S'): return "Princeton Graphic Systems";
	case PNP_ID('P', 'H', 'C'): return "Pijnenburg Beheer N.V.";
	case PNP_ID('P', 'H', 'E'): return "Philips Medical Systems Boeblingen GmbH";
	case PNP_ID('P', 'H', 'I'): return "DO NOT USE - PHI";
	case PNP_ID('P', 'H', 'L'): return "Philips Consumer Electronics Company";
	case PNP_ID('P', 'H', 'O'): return "Photonics Systems Inc.";
	case PNP_ID('P', 'H', 'S'): return "Philips Communication Systems";
	case PNP_ID('P', 'H', 'Y'): return "Phylon Communications";
	case PNP_ID('P', 'I', 'C'): return "Picturall Ltd.";
	case PNP_ID('P', 'I', 'E'): return "Pacific Image Electronics Company Ltd";
	case PNP_ID('P', 'I', 'M'): return "Prism, LLC";
	case PNP_ID('P', 'I', 'O'): return "Pioneer Electronic Corporation";
	case PNP_ID('P', 'I', 'R'): return "Pico Technology Inc.";
	case PNP_ID('P', 'I', 'S'): return "TECNART CO.,LTD.";
	case PNP_ID('P', 'I', 'X'): return "Pixie Tech Inc";
	case PNP_ID('P', 'J', 'A'): return "Projecta";
	case PNP_ID('P', 'J', 'D'): return "Projectiondesign AS";
	case PNP_ID('P', 'J', 'T'): return "Pan Jit International Inc.";
	case PNP_ID('P', 'K', 'A'): return "Acco UK Ltd.";
	case PNP_ID('P', 'L', 'C'): return "Pro-Log Corporation";
	case PNP_ID('P', 'L', 'F'): return "Panasonic Avionics Corporation";
	case PNP_ID('P', 'L', 'M'): return "PROLINK Microsystems Corp.";
	case PNP_ID('P', 'L', 'T'): return "PT Hartono Istana Teknologi";
	case PNP_ID('P', 'L', 'V'): return "PLUS Vision Corp.";
	case PNP_ID('P', 'L', 'X'): return "Parallax Graphics";
	case PNP_ID('P', 'L', 'Y'): return "Polycom Inc.";
	case PNP_ID('P', 'M', 'C'): return "PMC Consumer Electronics Ltd";
	case PNP_ID('P', 'M', 'D'): return "TDK USA Corporation";
	case PNP_ID('P', 'M', 'M'): return "Point Multimedia System";
	case PNP_ID('P', 'M', 'S'): return "Pabian Embedded Systems";
	case PNP_ID('P', 'M', 'T'): return "Promate Electronic Co., Ltd.";
	case PNP_ID('P', 'M', 'X'): return "Photomatrix";
	case PNP_ID('P', 'N', 'G'): return "Microsoft";
	case PNP_ID('P', 'N', 'L'): return "Panelview, Inc.";
	case PNP_ID('P', 'N', 'P'): return "Microsoft";
	case PNP_ID('P', 'N', 'R'): return "Planar Systems, Inc.";
	case PNP_ID('P', 'N', 'S'): return "PanaScope";
	case PNP_ID('P', 'N', 'T'): return "HOYA Corporation PENTAX Lifecare Division";
	case PNP_ID('P', 'N', 'X'): return "Phoenix Technologies, Ltd.";
	case PNP_ID('P', 'O', 'L'): return "PolyComp (PTY) Ltd.";
	case PNP_ID('P', 'O', 'N'): return "Perpetual Technologies, LLC";
	case PNP_ID('P', 'O', 'R'): return "Portalis LC";
	case PNP_ID('P', 'O', 'S'): return "Positivo Tecnologia S.A.";
	case PNP_ID('P', 'O', 'T'): return "Parrot";
	case PNP_ID('P', 'P', 'C'): return "Phoenixtec Power Company Ltd";
	case PNP_ID('P', 'P', 'D'): return "MEPhI";
	case PNP_ID('P', 'P', 'I'): return "Practical Peripherals";
	case PNP_ID('P', 'P', 'M'): return "Clinton Electronics Corp.";
	case PNP_ID('P', 'P', 'P'): return "Purup Prepress AS";
	case PNP_ID('P', 'P', 'R'): return "PicPro";
	case PNP_ID('P', 'P', 'X'): return "Perceptive Pixel Inc.";
	case PNP_ID('P', 'Q', 'I'): return "Pixel Qi";
	case PNP_ID('P', 'R', 'A'): return "PRO/AUTOMATION";
	case PNP_ID('P', 'R', 'C'): return "PerComm";
	case PNP_ID('P', 'R', 'D'): return "Praim S.R.L.";
	case PNP_ID('P', 'R', 'F'): return "Schneider Electric Japan Holdings, Ltd.";
	case PNP_ID('P', 'R', 'G'): return "The Phoenix Research Group Inc";
	case PNP_ID('P', 'R', 'I'): return "Priva Hortimation BV";
	case PNP_ID('P', 'R', 'M'): return "Prometheus";
	case PNP_ID('P', 'R', 'O'): return "Proteon";
	case PNP_ID('P', 'R', 'P'): return "UEFI Forum";
	case PNP_ID('P', 'R', 'S'): return "Leutron Vision";
	case PNP_ID('P', 'R', 'T'): return "Parade Technologies, Ltd.";
	case PNP_ID('P', 'R', 'X'): return "Proxima Corporation";
	case PNP_ID('P', 'S', 'A'): return "Advanced Signal Processing Technologies";
	case PNP_ID('P', 'S', 'C'): return "Philips Semiconductors";
	case PNP_ID('P', 'S', 'D'): return "Peus-Systems GmbH";
	case PNP_ID('P', 'S', 'E'): return "Practical Solutions Pte., Ltd.";
	case PNP_ID('P', 'S', 'I'): return "PSI-Perceptive Solutions Inc";
	case PNP_ID('P', 'S', 'L'): return "Perle Systems Limited";
	case PNP_ID('P', 'S', 'M'): return "Prosum";
	case PNP_ID('P', 'S', 'T'): return "Global Data SA";
	case PNP_ID('P', 'S', 'Y'): return "Prodea Systems Inc.";
	case PNP_ID('P', 'T', 'A'): return "PAR Tech Inc.";
	case PNP_ID('P', 'T', 'C'): return "PS Technology Corporation";
	case PNP_ID('P', 'T', 'G'): return "Cipher Systems Inc";
	case PNP_ID('P', 'T', 'H'): return "Pathlight Technology Inc";
	case PNP_ID('P', 'T', 'I'): return "Promise Technology Inc";
	case PNP_ID('P', 'T', 'L'): return "Pantel Inc";
	case PNP_ID('P', 'T', 'S'): return "Plain Tree Systems Inc";
	case PNP_ID('P', 'T', 'W'): return "DO NOT USE - PTW";
	case PNP_ID('P', 'T', 'X'): return "Printronix LLC";
	case PNP_ID('P', 'U', 'L'): return "Pulse-Eight Ltd";
	case PNP_ID('P', 'V', 'C'): return "DO NOT USE - PVC";
	case PNP_ID('P', 'V', 'G'): return "Proview Global Co., Ltd";
	case PNP_ID('P', 'V', 'I'): return "Prime view international Co., Ltd";
	case PNP_ID('P', 'V', 'M'): return "Penta Studiotechnik GmbH";
	case PNP_ID('P', 'V', 'N'): return "Pixel Vision";
	case PNP_ID('P', 'V', 'P'): return "Klos Technologies, Inc.";
	case PNP_ID('P', 'V', 'R'): return "Pimax Tech. CO., LTD";
	case PNP_ID('P', 'X', 'C'): return "Phoenix Contact";
	case PNP_ID('P', 'X', 'E'): return "PIXELA CORPORATION";
	case PNP_ID('P', 'X', 'L'): return "The Moving Pixel Company";
	case PNP_ID('P', 'X', 'M'): return "Proxim Inc";
	case PNP_ID('P', 'X', 'N'): return "PixelNext Inc";
	case PNP_ID('P', 'X', 'O'): return "Pixio USA";
	case PNP_ID('Q', 'C', 'C'): return "QuakeCom Company Ltd";
	case PNP_ID('Q', 'C', 'H'): return "Metronics Inc";
	case PNP_ID('Q', 'C', 'I'): return "Quanta Computer Inc";
	case PNP_ID('Q', 'C', 'K'): return "Quick Corporation";
	case PNP_ID('Q', 'C', 'L'): return "Quadrant Components Inc";
	case PNP_ID('Q', 'C', 'P'): return "Qualcomm Inc";
	case PNP_ID('Q', 'D', 'I'): return "Quantum Data Incorporated";
	case PNP_ID('Q', 'D', 'L'): return "QD Laser, Inc.";
	case PNP_ID('Q', 'D', 'M'): return "Quadram";
	case PNP_ID('Q', 'D', 'S'): return "Quanta Display Inc.";
	case PNP_ID('Q', 'F', 'F'): return "Padix Co., Inc.";
	case PNP_ID('Q', 'F', 'I'): return "Quickflex, Inc";
	case PNP_ID('Q', 'L', 'C'): return "Q-Logic";
	case PNP_ID('Q', 'Q', 'Q'): return "Chuomusen Co., Ltd.";
	case PNP_ID('Q', 'S', 'C'): return "QSC, LLC";
	case PNP_ID('Q', 'S', 'I'): return "Quantum Solutions, Inc.";
	case PNP_ID('Q', 'T', 'D'): return "Quantum 3D Inc";
	case PNP_ID('Q', 'T', 'H'): return "Questech Ltd";
	case PNP_ID('Q', 'T', 'I'): return "Quicknet Technologies Inc";
	case PNP_ID('Q', 'T', 'M'): return "Quantum";
	case PNP_ID('Q', 'T', 'R'): return "Qtronix Corporation";
	case PNP_ID('Q', 'U', 'A'): return "Quatographic AG";
	case PNP_ID('Q', 'U', 'E'): return "Questra Consulting";
	case PNP_ID('Q', 'V', 'U'): return "Quartics";
	case PNP_ID('R', 'A', 'C'): return "Racore Computer Products Inc";
	case PNP_ID('R', 'A', 'D'): return "Radisys Corporation";
	case PNP_ID('R', 'A', 'I'): return "Rockwell Automation/Intecolor";
	case PNP_ID('R', 'A', 'N'): return "Rancho Tech Inc";
	case PNP_ID('R', 'A', 'R'): return "Raritan, Inc.";
	case PNP_ID('R', 'A', 'S'): return "RAScom Inc";
	case PNP_ID('R', 'A', 'T'): return "Rent-A-Tech";
	case PNP_ID('R', 'A', 'Y'): return "Raylar Design, Inc.";
	case PNP_ID('R', 'C', 'E'): return "Parc d'Activite des Bellevues";
	case PNP_ID('R', 'C', 'H'): return "Reach Technology Inc";
	case PNP_ID('R', 'C', 'I'): return "RC International";
	case PNP_ID('R', 'C', 'N'): return "Radio Consult SRL";
	case PNP_ID('R', 'C', 'O'): return "Rockwell Collins";
	case PNP_ID('R', 'D', 'I'): return "Rainbow Displays, Inc.";
	case PNP_ID('R', 'D', 'L'): return "Riedel Communications Canada Inc.";
	case PNP_ID('R', 'D', 'M'): return "Tremon Enterprises Company Ltd";
	case PNP_ID('R', 'D', 'N'): return "RADIODATA GmbH";
	case PNP_ID('R', 'D', 'S'): return "Radius Inc";
	case PNP_ID('R', 'E', 'A'): return "Real D";
	case PNP_ID('R', 'E', 'C'): return "ReCom";
	case PNP_ID('R', 'E', 'D'): return "Research Electronics Development Inc";
	case PNP_ID('R', 'E', 'F'): return "Reflectivity, Inc.";
	case PNP_ID('R', 'E', 'H'): return "Rehan Electronics Ltd.";
	case PNP_ID('R', 'E', 'L'): return "Reliance Electric Ind Corporation";
	case PNP_ID('R', 'E', 'M'): return "SCI Systems Inc.";
	case PNP_ID('R', 'E', 'N'): return "Renesas Technology Corp.";
	case PNP_ID('R', 'E', 'S'): return "ResMed Pty Ltd";
	case PNP_ID('R', 'E', 'T'): return "Resonance Technology, Inc.";
	case PNP_ID('R', 'E', 'V'): return "Revolution Display, Inc.";
	case PNP_ID('R', 'E', 'X'): return "RATOC Systems, Inc.";
	case PNP_ID('R', 'F', 'I'): return "RAFI GmbH & Co. KG";
	case PNP_ID('R', 'F', 'X'): return "Redfox Technologies Inc.";
	case PNP_ID('R', 'G', 'B'): return "RGB Spectrum";
	case PNP_ID('R', 'G', 'L'): return "Robertson Geologging Ltd";
	case PNP_ID('R', 'H', 'D'): return "RightHand Technologies";
	case PNP_ID('R', 'H', 'M'): return "Rohm Company Ltd";
	case PNP_ID('R', 'H', 'T'): return "Red Hat, Inc.";
	case PNP_ID('R', 'I', 'C'): return "RICOH COMPANY, LTD.";
	case PNP_ID('R', 'I', 'I'): return "Racal Interlan Inc";
	case PNP_ID('R', 'I', 'O'): return "Rios Systems Company Ltd";
	case PNP_ID('R', 'I', 'T'): return "Ritech Inc";
	case PNP_ID('R', 'I', 'V'): return "Rivulet Communications";
	case PNP_ID('R', 'J', 'A'): return "Roland Corporation";
	case PNP_ID('R', 'J', 'S'): return "Advanced Engineering";
	case PNP_ID('R', 'K', 'C'): return "Reakin Technolohy Corporation";
	case PNP_ID('R', 'L', 'D'): return "MEPCO";
	case PNP_ID('R', 'L', 'N'): return "RadioLAN Inc";
	case PNP_ID('R', 'M', 'C'): return "Raritan Computer, Inc";
	case PNP_ID('R', 'M', 'P'): return "Research Machines";
	case PNP_ID('R', 'M', 'S'): return "Shenzhen Ramos Digital Technology Co., Ltd";
	case PNP_ID('R', 'M', 'T'): return "Roper Mobile";
	case PNP_ID('R', 'N', 'B'): return "Rainbow Technologies";
	case PNP_ID('R', 'N', 'L'): return "Reonel Oy";
	case PNP_ID('R', 'O', 'B'): return "Robust Electronics GmbH";
	case PNP_ID('R', 'O', 'H'): return "Rohm Co., Ltd.";
	case PNP_ID('R', 'O', 'K'): return "Rockwell International";
	case PNP_ID('R', 'O', 'P'): return "Roper International Ltd";
	case PNP_ID('R', 'O', 'S'): return "Rohde & Schwarz";
	case PNP_ID('R', 'P', 'I'): return "RoomPro Technologies";
	case PNP_ID('R', 'P', 'L'): return "Raspberry PI";
	case PNP_ID('R', 'P', 'T'): return "R.P.T.Intergroups";
	case PNP_ID('R', 'R', 'I'): return "Radicom Research Inc";
	case PNP_ID('R', 'R', 'O'): return "AVARRO";
	case PNP_ID('R', 'S', 'C'): return "PhotoTelesis";
	case PNP_ID('R', 'S', 'H'): return "ADC-Centre";
	case PNP_ID('R', 'S', 'I'): return "Rampage Systems Inc";
	case PNP_ID('R', 'S', 'N'): return "Radiospire Networks, Inc.";
	case PNP_ID('R', 'S', 'Q'): return "R Squared";
	case PNP_ID('R', 'S', 'R'): return "Zhong Shan City Richsound Electronic Industrial Ltd.";
	case PNP_ID('R', 'S', 'S'): return "Rockwell Semiconductor Systems";
	case PNP_ID('R', 'S', 'V'): return "Ross Video Ltd";
	case PNP_ID('R', 'S', 'X'): return "Rapid Tech Corporation";
	case PNP_ID('R', 'T', 'C'): return "Relia Technologies";
	case PNP_ID('R', 'T', 'I'): return "Rancho Tech Inc";
	case PNP_ID('R', 'T', 'K'): return "DO NOT USE - RTK";
	case PNP_ID('R', 'T', 'L'): return "Realtek Semiconductor Company Ltd";
	case PNP_ID('R', 'T', 'S'): return "Raintree Systems";
	case PNP_ID('R', 'U', 'N'): return "RUNCO International";
	case PNP_ID('R', 'U', 'P'): return "Ups Manufactoring s.r.l.";
	case PNP_ID('R', 'V', 'C'): return "RSI Systems Inc";
	case PNP_ID('R', 'V', 'I'): return "Realvision Inc";
	case PNP_ID('R', 'V', 'L'): return "Reveal Computer Prod";
	case PNP_ID('R', 'W', 'C'): return "Red Wing Corporation";
	case PNP_ID('R', 'X', 'T'): return "Tectona SoftSolutions (P) Ltd.,";
	case PNP_ID('R', 'Z', 'R'): return "Razer Taiwan Co. Ltd.";
	case PNP_ID('R', 'Z', 'S'): return "Rozsnyó, s.r.o.";
	case PNP_ID('S', 'A', 'A'): return "Sanritz Automation Co.,Ltd.";
	case PNP_ID('S', 'A', 'E'): return "Saab Aerotech";
	case PNP_ID('S', 'A', 'G'): return "Sedlbauer";
	case PNP_ID('S', 'A', 'I'): return "Sage Inc";
	case PNP_ID('S', 'A', 'K'): return "Saitek Ltd";
	case PNP_ID('S', 'A', 'M'): return "Samsung Electric Company";
	case PNP_ID('S', 'A', 'N'): return "Sanyo Electric Co.,Ltd.";
	case PNP_ID('S', 'A', 'S'): return "Stores Automated Systems Inc";
	case PNP_ID('S', 'A', 'T'): return "Shuttle Tech";
	case PNP_ID('S', 'B', 'C'): return "Shanghai Bell Telephone Equip Mfg Co";
	case PNP_ID('S', 'B', 'D'): return "Softbed - Consulting & Development Ltd";
	case PNP_ID('S', 'B', 'I'): return "SMART Technologies Inc.";
	case PNP_ID('S', 'B', 'S'): return "SBS-or Industrial Computers GmbH";
	case PNP_ID('S', 'B', 'T'): return "Senseboard Technologies AB";
	case PNP_ID('S', 'C', 'A'): return "Schneider Consumer Group";
	case PNP_ID('S', 'C', 'B'): return "SeeCubic B.V.";
	case PNP_ID('S', 'C', 'C'): return "SORD Computer Corporation";
	case PNP_ID('S', 'C', 'D'): return "Sanyo Electric Company Ltd";
	case PNP_ID('S', 'C', 'E'): return "Sun Corporation";
	case PNP_ID('S', 'C', 'G'): return "Seco S.p.A.";
	case PNP_ID('S', 'C', 'H'): return "Schlumberger Cards";
	case PNP_ID('S', 'C', 'I'): return "System Craft";
	case PNP_ID('S', 'C', 'L'): return "Sigmacom Co., Ltd.";
	case PNP_ID('S', 'C', 'M'): return "SCM Microsystems Inc";
	case PNP_ID('S', 'C', 'N'): return "Scanport, Inc.";
	case PNP_ID('S', 'C', 'O'): return "SORCUS Computer GmbH";
	case PNP_ID('S', 'C', 'P'): return "Scriptel Corporation";
	case PNP_ID('S', 'C', 'R'): return "Systran Corporation";
	case PNP_ID('S', 'C', 'S'): return "Nanomach Anstalt";
	case PNP_ID('S', 'C', 'T'): return "Smart Card Technology";
	case PNP_ID('S', 'C', 'X'): return "Socionext Inc.";
	case PNP_ID('S', 'D', 'A'): return "SAT (Societe Anonyme)";
	case PNP_ID('S', 'D', 'C'): return "Samsung Display Corp.";
	case PNP_ID('S', 'D', 'D'): return "Intrada-SDD Ltd";
	case PNP_ID('S', 'D', 'E'): return "Sherwood Digital Electronics Corporation";
	case PNP_ID('S', 'D', 'F'): return "SODIFF E&T CO., Ltd.";
	case PNP_ID('S', 'D', 'H'): return "Communications Specialies, Inc.";
	case PNP_ID('S', 'D', 'I'): return "Samtron Displays Inc";
	case PNP_ID('S', 'D', 'K'): return "SAIT-Devlonics";
	case PNP_ID('S', 'D', 'R'): return "SDR Systems";
	case PNP_ID('S', 'D', 'S'): return "SunRiver Data System";
	case PNP_ID('S', 'D', 'T'): return "Siemens AG";
	case PNP_ID('S', 'D', 'X'): return "SDX Business Systems Ltd";
	case PNP_ID('S', 'E', 'A'): return "Seanix Technology Inc.";
	case PNP_ID('S', 'E', 'B'): return "system elektronik GmbH";
	case PNP_ID('S', 'E', 'C'): return "Seiko Epson Corporation";
	case PNP_ID('S', 'E', 'E'): return "SeeColor Corporation";
	case PNP_ID('S', 'E', 'G'): return "DO NOT USE - SEG";
	case PNP_ID('S', 'E', 'I'): return "Seitz & Associates Inc";
	case PNP_ID('S', 'E', 'L'): return "Way2Call Communications";
	case PNP_ID('S', 'E', 'M'): return "Samsung Electronics Company Ltd";
	case PNP_ID('S', 'E', 'N'): return "Sencore";
	case PNP_ID('S', 'E', 'O'): return "SEOS Ltd";
	case PNP_ID('S', 'E', 'P'): return "SEP Eletronica Ltda.";
	case PNP_ID('S', 'E', 'R'): return "Sony Ericsson Mobile Communications Inc.";
	case PNP_ID('S', 'E', 'S'): return "Session Control LLC";
	case PNP_ID('S', 'E', 'T'): return "SendTek Corporation";
	case PNP_ID('S', 'F', 'L'): return "Shiftall Inc.";
	case PNP_ID('S', 'F', 'M'): return "TORNADO Company";
	case PNP_ID('S', 'F', 'T'): return "Mikroforum Ring 3";
	case PNP_ID('S', 'G', 'C'): return "Spectragraphics Corporation";
	case PNP_ID('S', 'G', 'D'): return "Sigma Designs, Inc.";
	case PNP_ID('S', 'G', 'E'): return "Kansai Electric Company Ltd";
	case PNP_ID('S', 'G', 'I'): return "Scan Group Ltd";
	case PNP_ID('S', 'G', 'L'): return "Super Gate Technology Company Ltd";
	case PNP_ID('S', 'G', 'M'): return "SAGEM";
	case PNP_ID('S', 'G', 'N'): return "Shenzhen Soogeen Electronics Co., LTD.";
	case PNP_ID('S', 'G', 'O'): return "Logos Design A/S";
	case PNP_ID('S', 'G', 'T'): return "Stargate Technology";
	case PNP_ID('S', 'G', 'W'): return "Shanghai Guowei Science and Technology Co., Ltd.";
	case PNP_ID('S', 'G', 'X'): return "Silicon Graphics Inc";
	case PNP_ID('S', 'G', 'Z'): return "Systec Computer GmbH";
	case PNP_ID('S', 'H', 'C'): return "ShibaSoku Co., Ltd.";
	case PNP_ID('S', 'H', 'G'): return "Soft & Hardware development Goldammer GmbH";
	case PNP_ID('S', 'H', 'I'): return "Jiangsu Shinco Electronic Group Co., Ltd";
	case PNP_ID('S', 'H', 'P'): return "Sharp Corporation";
	case PNP_ID('S', 'H', 'R'): return "Digital Discovery";
	case PNP_ID('S', 'H', 'T'): return "Shin Ho Tech";
	case PNP_ID('S', 'I', 'A'): return "SIEMENS AG";
	case PNP_ID('S', 'I', 'B'): return "Sanyo Electric Company Ltd";
	case PNP_ID('S', 'I', 'C'): return "Sysmate Corporation";
	case PNP_ID('S', 'I', 'D'): return "Seiko Instruments Information Devices Inc";
	case PNP_ID('S', 'I', 'E'): return "Siemens";
	case PNP_ID('S', 'I', 'G'): return "Sigma Designs Inc";
	case PNP_ID('S', 'I', 'I'): return "Silicon Image, Inc.";
	case PNP_ID('S', 'I', 'L'): return "Silicon Laboratories, Inc";
	case PNP_ID('S', 'I', 'M'): return "S3 Inc";
	case PNP_ID('S', 'I', 'N'): return "Singular Technology Co., Ltd.";
	case PNP_ID('S', 'I', 'R'): return "Sirius Technologies Pty Ltd";
	case PNP_ID('S', 'I', 'S'): return "Silicon Integrated Systems Corporation";
	case PNP_ID('S', 'I', 'T'): return "Sitintel";
	case PNP_ID('S', 'I', 'U'): return "Seiko Instruments USA Inc";
	case PNP_ID('S', 'I', 'X'): return "Zuniq Data Corporation";
	case PNP_ID('S', 'J', 'E'): return "Sejin Electron Inc";
	case PNP_ID('S', 'K', 'D'): return "Schneider & Koch";
	case PNP_ID('S', 'K', 'G'): return "Shenzhen KTC Technology Group";
	case PNP_ID('S', 'K', 'I'): return "LLC SKTB “SKIT”";
	case PNP_ID('S', 'K', 'M'): return "Guangzhou Teclast Information Technology Limited";
	case PNP_ID('S', 'K', 'T'): return "Samsung Electro-Mechanics Company Ltd";
	case PNP_ID('S', 'K', 'W'): return "Skyworth";
	case PNP_ID('S', 'K', 'Y'): return "SKYDATA S.P.A.";
	case PNP_ID('S', 'L', 'A'): return "Systeme Lauer GmbH&Co KG";
	case PNP_ID('S', 'L', 'B'): return "Shlumberger Ltd";
	case PNP_ID('S', 'L', 'C'): return "Syslogic Datentechnik AG";
	case PNP_ID('S', 'L', 'F'): return "StarLeaf";
	case PNP_ID('S', 'L', 'H'): return "Silicon Library Inc.";
	case PNP_ID('S', 'L', 'I'): return "Symbios Logic Inc";
	case PNP_ID('S', 'L', 'K'): return "Silitek Corporation";
	case PNP_ID('S', 'L', 'M'): return "Solomon Technology Corporation";
	case PNP_ID('S', 'L', 'R'): return "Schlumberger Technology Corporate";
	case PNP_ID('S', 'L', 'S'): return "Schnick-Schnack-Systems GmbH";
	case PNP_ID('S', 'L', 'T'): return "Salt Internatioinal Corp.";
	case PNP_ID('S', 'L', 'X'): return "Specialix";
	case PNP_ID('S', 'M', 'A'): return "SMART Modular Technologies";
	case PNP_ID('S', 'M', 'B'): return "Schlumberger";
	case PNP_ID('S', 'M', 'C'): return "Standard Microsystems Corporation";
	case PNP_ID('S', 'M', 'E'): return "Sysmate Company";
	case PNP_ID('S', 'M', 'I'): return "SpaceLabs Medical Inc";
	case PNP_ID('S', 'M', 'K'): return "SMK CORPORATION";
	case PNP_ID('S', 'M', 'L'): return "Sumitomo Metal Industries, Ltd.";
	case PNP_ID('S', 'M', 'M'): return "Shark Multimedia Inc";
	case PNP_ID('S', 'M', 'N'): return "Somnium Space Ltd.";
	case PNP_ID('S', 'M', 'O'): return "STMicroelectronics";
	case PNP_ID('S', 'M', 'P'): return "Simple Computing";
	case PNP_ID('S', 'M', 'R'): return "B.& V. s.r.l.";
	case PNP_ID('S', 'M', 'S'): return "Silicom Multimedia Systems Inc";
	case PNP_ID('S', 'M', 'T'): return "Silcom Manufacturing Tech Inc";
	case PNP_ID('S', 'N', 'C'): return "Sentronic International Corp.";
	case PNP_ID('S', 'N', 'I'): return "Siemens Microdesign GmbH";
	case PNP_ID('S', 'N', 'K'): return "S&K Electronics";
	case PNP_ID('S', 'N', 'N'): return "SUNNY ELEKTRONIK";
	case PNP_ID('S', 'N', 'O'): return "SINOSUN TECHNOLOGY CO., LTD";
	case PNP_ID('S', 'N', 'P'): return "Siemens Nixdorf Info Systems";
	case PNP_ID('S', 'N', 'S'): return "Cirtech (UK) Ltd";
	case PNP_ID('S', 'N', 'T'): return "SuperNet Inc";
	case PNP_ID('S', 'N', 'V'): return "SONOVE GmbH";
	case PNP_ID('S', 'N', 'W'): return "Snell & Wilcox";
	case PNP_ID('S', 'N', 'X'): return "Sonix Comm. Ltd";
	case PNP_ID('S', 'N', 'Y'): return "Sony";
	case PNP_ID('S', 'O', 'C'): return "Santec Corporation";
	case PNP_ID('S', 'O', 'I'): return "Silicon Optix Corporation";
	case PNP_ID('S', 'O', 'L'): return "Solitron Technologies Inc";
	case PNP_ID('S', 'O', 'N'): return "Sony";
	case PNP_ID('S', 'O', 'R'): return "Sorcus Computer GmbH";
	case PNP_ID('S', 'O', 'T'): return "Sotec Company Ltd";
	case PNP_ID('S', 'O', 'Y'): return "SOYO Group, Inc";
	case PNP_ID('S', 'P', 'C'): return "SpinCore Technologies, Inc";
	case PNP_ID('S', 'P', 'E'): return "SPEA Software AG";
	case PNP_ID('S', 'P', 'H'): return "G&W Instruments GmbH";
	case PNP_ID('S', 'P', 'I'): return "SPACE-I Co., Ltd.";
	case PNP_ID('S', 'P', 'K'): return "SpeakerCraft";
	case PNP_ID('S', 'P', 'L'): return "Smart Silicon Systems Pty Ltd";
	case PNP_ID('S', 'P', 'N'): return "Sapience Corporation";
	case PNP_ID('S', 'P', 'O'): return "SAMPO CORPORATION";
	case PNP_ID('S', 'P', 'R'): return "pmns GmbH";
	case PNP_ID('S', 'P', 'S'): return "Synopsys Inc";
	case PNP_ID('S', 'P', 'T'): return "Sceptre Tech Inc";
	case PNP_ID('S', 'P', 'U'): return "SIM2 Multimedia S.P.A.";
	case PNP_ID('S', 'P', 'X'): return "Simplex Time Recorder Co.";
	case PNP_ID('S', 'Q', 'T'): return "Sequent Computer Systems Inc";
	case PNP_ID('S', 'R', 'C'): return "Integrated Tech Express Inc";
	case PNP_ID('S', 'R', 'D'): return "Setred";
	case PNP_ID('S', 'R', 'F'): return "Surf Communication Solutions Ltd";
	case PNP_ID('S', 'R', 'G'): return "Intuitive Surgical, Inc.";
	case PNP_ID('S', 'R', 'S'): return "SR-Systems e.K.";
	case PNP_ID('S', 'R', 'T'): return "SeeReal Technologies GmbH";
	case PNP_ID('S', 'S', 'C'): return "Sierra Semiconductor Inc";
	case PNP_ID('S', 'S', 'D'): return "FlightSafety International";
	case PNP_ID('S', 'S', 'E'): return "Samsung Electronic Co.";
	case PNP_ID('S', 'S', 'G'): return "Steelseries ApS";
	case PNP_ID('S', 'S', 'I'): return "S-S Technology Inc";
	case PNP_ID('S', 'S', 'J'): return "Sankyo Seiki Mfg.co., Ltd";
	case PNP_ID('S', 'S', 'L'): return "Shenzhen South-Top Computer Co., Ltd.";
	case PNP_ID('S', 'S', 'P'): return "Spectrum Signal Proecessing Inc";
	case PNP_ID('S', 'S', 'S'): return "S3 Inc";
	case PNP_ID('S', 'S', 'T'): return "SystemSoft Corporation";
	case PNP_ID('S', 'T', 'A'): return "ST Electronics Systems Assembly Pte Ltd";
	case PNP_ID('S', 'T', 'B'): return "STB Systems Inc";
	case PNP_ID('S', 'T', 'C'): return "STAC Electronics";
	case PNP_ID('S', 'T', 'D'): return "STD Computer Inc";
	case PNP_ID('S', 'T', 'E'): return "SII Ido-Tsushin Inc";
	case PNP_ID('S', 'T', 'F'): return "Starflight Electronics";
	case PNP_ID('S', 'T', 'G'): return "StereoGraphics Corp.";
	case PNP_ID('S', 'T', 'H'): return "Semtech Corporation";
	case PNP_ID('S', 'T', 'I'): return "Smart Tech Inc";
	case PNP_ID('S', 'T', 'K'): return "SANTAK CORP.";
	case PNP_ID('S', 'T', 'L'): return "SigmaTel Inc";
	case PNP_ID('S', 'T', 'M'): return "SGS Thomson Microelectronics";
	case PNP_ID('S', 'T', 'N'): return "Samsung Electronics America";
	case PNP_ID('S', 'T', 'O'): return "Stollmann E+V GmbH";
	case PNP_ID('S', 'T', 'P'): return "StreamPlay Ltd";
	case PNP_ID('S', 'T', 'Q'): return "Synthetel Corporation";
	case PNP_ID('S', 'T', 'R'): return "Starlight Networks Inc";
	case PNP_ID('S', 'T', 'S'): return "SITECSYSTEM CO., LTD.";
	case PNP_ID('S', 'T', 'T'): return "Star Paging Telecom Tech (Shenzhen) Co. Ltd.";
	case PNP_ID('S', 'T', 'U'): return "Sentelic Corporation";
	case PNP_ID('S', 'T', 'V'): return "Beijing Guochengwantong Information Technology Co., Ltd.";
	case PNP_ID('S', 'T', 'W'): return "Starwin Inc.";
	case PNP_ID('S', 'T', 'X'): return "ST-Ericsson";
	case PNP_ID('S', 'T', 'Y'): return "SDS Technologies";
	case PNP_ID('S', 'U', 'B'): return "Subspace Comm. Inc";
	case PNP_ID('S', 'U', 'M'): return "Summagraphics Corporation";
	case PNP_ID('S', 'U', 'N'): return "Sun Electronics Corporation";
	case PNP_ID('S', 'U', 'P'): return "Supra Corporation";
	case PNP_ID('S', 'U', 'R'): return "Surenam Computer Corporation";
	case PNP_ID('S', 'V', 'A'): return "SGEG";
	case PNP_ID('S', 'V', 'C'): return "Intellix Corp.";
	case PNP_ID('S', 'V', 'D'): return "SVD Computer";
	case PNP_ID('S', 'V', 'I'): return "Sun Microsystems";
	case PNP_ID('S', 'V', 'R'): return "Sensics, Inc.";
	case PNP_ID('S', 'V', 'S'): return "SVSI";
	case PNP_ID('S', 'V', 'T'): return "SEVIT Co., Ltd.";
	case PNP_ID('S', 'W', 'C'): return "Software Café";
	case PNP_ID('S', 'W', 'I'): return "Sierra Wireless Inc.";
	case PNP_ID('S', 'W', 'L'): return "Sharedware Ltd";
	case PNP_ID('S', 'W', 'O'): return "Guangzhou Shirui Electronics Co., Ltd.";
	case PNP_ID('S', 'W', 'S'): return "Static";
	case PNP_ID('S', 'W', 'T'): return "Software Technologies Group,Inc.";
	case PNP_ID('S', 'X', 'B'): return "Syntax-Brillian";
	case PNP_ID('S', 'X', 'D'): return "Silex technology, Inc.";
	case PNP_ID('S', 'X', 'G'): return "SELEX GALILEO";
	case PNP_ID('S', 'X', 'I'): return "Silex Inside";
	case PNP_ID('S', 'X', 'L'): return "SolutionInside";
	case PNP_ID('S', 'X', 'T'): return "SHARP TAKAYA ELECTRONIC INDUSTRY CO.,LTD.";
	case PNP_ID('S', 'Y', 'C'): return "Sysmic";
	case PNP_ID('S', 'Y', 'E'): return "SY Electronics Ltd";
	case PNP_ID('S', 'Y', 'K'): return "Stryker Communications";
	case PNP_ID('S', 'Y', 'L'): return "Sylvania Computer Products";
	case PNP_ID('S', 'Y', 'M'): return "Symicron Computer Communications Ltd.";
	case PNP_ID('S', 'Y', 'N'): return "Synaptics Inc";
	case PNP_ID('S', 'Y', 'P'): return "SYPRO Co Ltd";
	case PNP_ID('S', 'Y', 'S'): return "Sysgration Ltd";
	case PNP_ID('S', 'Y', 'T'): return "Seyeon Tech Company Ltd";
	case PNP_ID('S', 'Y', 'V'): return "SYVAX Inc";
	case PNP_ID('S', 'Y', 'X'): return "Prime Systems, Inc.";
	case PNP_ID('S', 'Z', 'M'): return "Shenzhen MTC Co., Ltd";
	case PNP_ID('T', 'A', 'A'): return "Tandberg";
	case PNP_ID('T', 'A', 'B'): return "Todos Data System AB";
	case PNP_ID('T', 'A', 'G'): return "Teles AG";
	case PNP_ID('T', 'A', 'I'): return "Toshiba America Info Systems Inc";
	case PNP_ID('T', 'A', 'M'): return "Tamura Seisakusyo Ltd";
	case PNP_ID('T', 'A', 'S'): return "Taskit Rechnertechnik GmbH";
	case PNP_ID('T', 'A', 'T'): return "Teleliaison Inc";
	case PNP_ID('T', 'A', 'V'): return "Thales Avionics";
	case PNP_ID('T', 'A', 'X'): return "Taxan (Europe) Ltd";
	case PNP_ID('T', 'B', 'B'): return "Triple S Engineering Inc";
	case PNP_ID('T', 'B', 'C'): return "Turbo Communication, Inc";
	case PNP_ID('T', 'B', 'S'): return "Turtle Beach System";
	case PNP_ID('T', 'C', 'C'): return "Tandon Corporation";
	case PNP_ID('T', 'C', 'D'): return "Taicom Data Systems Co., Ltd.";
	case PNP_ID('T', 'C', 'E'): return "Century Corporation";
	case PNP_ID('T', 'C', 'F'): return "Televic Conference";
	case PNP_ID('T', 'C', 'H'): return "Interaction Systems, Inc";
	case PNP_ID('T', 'C', 'I'): return "Tulip Computers Int'l B.V.";
	case PNP_ID('T', 'C', 'J'): return "TEAC America Inc";
	case PNP_ID('T', 'C', 'L'): return "Technical Concepts Ltd";
	case PNP_ID('T', 'C', 'M'): return "3Com Corporation";
	case PNP_ID('T', 'C', 'N'): return "Tecnetics (PTY) Ltd";
	case PNP_ID('T', 'C', 'O'): return "Thomas-Conrad Corporation";
	case PNP_ID('T', 'C', 'R'): return "Thomson Consumer Electronics";
	case PNP_ID('T', 'C', 'S'): return "Tatung Company of America Inc";
	case PNP_ID('T', 'C', 'T'): return "Telecom Technology Centre Co. Ltd.";
	case PNP_ID('T', 'C', 'X'): return "FREEMARS Heavy Industries";
	case PNP_ID('T', 'D', 'C'): return "Teradici";
	case PNP_ID('T', 'D', 'D'): return "Tandberg Data Display AS";
	case PNP_ID('T', 'D', 'G'): return "Six15 Technologies";
	case PNP_ID('T', 'D', 'M'): return "Tandem Computer Europe Inc";
	case PNP_ID('T', 'D', 'P'): return "3D Perception";
	case PNP_ID('T', 'D', 'S'): return "Tri-Data Systems Inc";
	case PNP_ID('T', 'D', 'T'): return "TDT";
	case PNP_ID('T', 'D', 'V'): return "TDVision Systems, Inc.";
	case PNP_ID('T', 'D', 'Y'): return "Tandy Electronics";
	case PNP_ID('T', 'E', 'A'): return "TEAC System Corporation";
	case PNP_ID('T', 'E', 'C'): return "Tecmar Inc";
	case PNP_ID('T', 'E', 'K'): return "Tektronix Inc";
	case PNP_ID('T', 'E', 'L'): return "Promotion and Display Technology Ltd.";
	case PNP_ID('T', 'E', 'N'): return "Tencent";
	case PNP_ID('T', 'E', 'R'): return "TerraTec Electronic GmbH";
	case PNP_ID('T', 'E', 'T'): return "TETRADYNE CO., LTD.";
	case PNP_ID('T', 'E', 'V'): return "Televés, S.A.";
	case PNP_ID('T', 'E', 'Z'): return "Tech Source Inc.";
	case PNP_ID('T', 'G', 'C'): return "Toshiba Global Commerce Solutions, Inc.";
	case PNP_ID('T', 'G', 'I'): return "TriGem Computer Inc";
	case PNP_ID('T', 'G', 'M'): return "TriGem Computer,Inc.";
	case PNP_ID('T', 'G', 'S'): return "Torus Systems Ltd";
	case PNP_ID('T', 'G', 'V'): return "Grass Valley Germany GmbH";
	case PNP_ID('T', 'G', 'W'): return "TECHNOGYM S.p.A.";
	case PNP_ID('T', 'H', 'N'): return "Thundercom Holdings Sdn. Bhd.";
	case PNP_ID('T', 'I', 'C'): return "Trigem KinfoComm";
	case PNP_ID('T', 'I', 'L'): return "Technical Illusions Inc.";
	case PNP_ID('T', 'I', 'P'): return "TIPTEL AG";
	case PNP_ID('T', 'I', 'V'): return "OOO Technoinvest";
	case PNP_ID('T', 'I', 'X'): return "Tixi.Com GmbH";
	case PNP_ID('T', 'K', 'C'): return "Taiko Electric Works.LTD";
	case PNP_ID('T', 'K', 'G'): return "Tek Gear";
	case PNP_ID('T', 'K', 'N'): return "Teknor Microsystem Inc";
	case PNP_ID('T', 'K', 'O'): return "TouchKo, Inc.";
	case PNP_ID('T', 'K', 'S'): return "TimeKeeping Systems, Inc.";
	case PNP_ID('T', 'L', 'A'): return "Ferrari Electronic GmbH";
	case PNP_ID('T', 'L', 'D'): return "Telindus";
	case PNP_ID('T', 'L', 'E'): return "Zhejiang Tianle Digital Electric Co., Ltd.";
	case PNP_ID('T', 'L', 'F'): return "Teleforce.,co,ltd";
	case PNP_ID('T', 'L', 'I'): return "TOSHIBA TELI CORPORATION";
	case PNP_ID('T', 'L', 'K'): return "Telelink AG";
	case PNP_ID('T', 'L', 'L'): return "Thinklogical";
	case PNP_ID('T', 'L', 'N'): return "Techlogix Networx";
	case PNP_ID('T', 'L', 'S'): return "Teleste Educational OY";
	case PNP_ID('T', 'L', 'T'): return "Dai Telecom S.p.A.";
	case PNP_ID('T', 'L', 'V'): return "S3 Inc";
	case PNP_ID('T', 'L', 'X'): return "Telxon Corporation";
	case PNP_ID('T', 'L', 'Y'): return "Truly Semiconductors Ltd.";
	case PNP_ID('T', 'M', 'A'): return "Tianma Microelectronics Ltd.";
	case PNP_ID('T', 'M', 'C'): return "Techmedia Computer Systems Corporation";
	case PNP_ID('T', 'M', 'E'): return "AT&T Microelectronics";
	case PNP_ID('T', 'M', 'I'): return "Texas Microsystem";
	case PNP_ID('T', 'M', 'M'): return "Time Management, Inc.";
	case PNP_ID('T', 'M', 'O'): return "Terumo Corporation";
	case PNP_ID('T', 'M', 'R'): return "Taicom International Inc";
	case PNP_ID('T', 'M', 'S'): return "Trident Microsystems Ltd";
	case PNP_ID('T', 'M', 'T'): return "T-Metrics Inc.";
	case PNP_ID('T', 'M', 'V'): return "TeamViewer Germany GmbH";
	case PNP_ID('T', 'M', 'X'): return "Thermotrex Corporation";
	case PNP_ID('T', 'N', 'C'): return "TNC Industrial Company Ltd";
	case PNP_ID('T', 'N', 'J'): return "DO NOT USE - TNJ";
	case PNP_ID('T', 'N', 'M'): return "TECNIMAGEN SA";
	case PNP_ID('T', 'N', 'Y'): return "Tennyson Tech Pty Ltd";
	case PNP_ID('T', 'O', 'E'): return "TOEI Electronics Co., Ltd.";
	case PNP_ID('T', 'O', 'G'): return "The OPEN Group";
	case PNP_ID('T', 'O', 'L'): return "TCL Corporation";
	case PNP_ID('T', 'O', 'M'): return "Ceton Corporation";
	case PNP_ID('T', 'O', 'N'): return "TONNA";
	case PNP_ID('T', 'O', 'P'): return "Orion Communications Co., Ltd.";
	case PNP_ID('T', 'O', 'S'): return "Dynabook Inc.";
	case PNP_ID('T', 'O', 'U'): return "Touchstone Technology";
	case PNP_ID('T', 'P', 'C'): return "Touch Panel Systems Corporation";
	case PNP_ID('T', 'P', 'D'): return "Times (Shanghai) Computer Co., Ltd.";
	case PNP_ID('T', 'P', 'E'): return "Technology Power Enterprises Inc";
	case PNP_ID('T', 'P', 'J'): return "Junnila";
	case PNP_ID('T', 'P', 'K'): return "TOPRE CORPORATION";
	case PNP_ID('T', 'P', 'R'): return "Topro Technology Inc";
	case PNP_ID('T', 'P', 'S'): return "Teleprocessing Systeme GmbH";
	case PNP_ID('T', 'P', 'T'): return "Thruput Ltd";
	case PNP_ID('T', 'P', 'V'): return "Top Victory Electronics ( Fujian ) Company Ltd";
	case PNP_ID('T', 'P', 'Z'): return "Ypoaz Systems Inc";
	case PNP_ID('T', 'R', 'A'): return "TriTech Microelectronics International";
	case PNP_ID('T', 'R', 'B'): return "Triumph Board a.s.";
	case PNP_ID('T', 'R', 'C'): return "Trioc AB";
	case PNP_ID('T', 'R', 'D'): return "Trident Microsystem Inc";
	case PNP_ID('T', 'R', 'E'): return "Tremetrics";
	case PNP_ID('T', 'R', 'I'): return "Tricord Systems";
	case PNP_ID('T', 'R', 'L'): return "Royal Information";
	case PNP_ID('T', 'R', 'M'): return "Tekram Technology Company Ltd";
	case PNP_ID('T', 'R', 'N'): return "Datacommunicatie Tron B.V.";
	case PNP_ID('T', 'R', 'P'): return "TRAPEZE GROUP";
	case PNP_ID('T', 'R', 'S'): return "Torus Systems Ltd";
	case PNP_ID('T', 'R', 'T'): return "Tritec Electronic AG";
	case PNP_ID('T', 'R', 'U'): return "Aashima Technology B.V.";
	case PNP_ID('T', 'R', 'V'): return "Trivisio Prototyping GmbH";
	case PNP_ID('T', 'R', 'X'): return "Trex Enterprises";
	case PNP_ID('T', 'S', 'B'): return "Toshiba America Info Systems Inc";
	case PNP_ID('T', 'S', 'C'): return "Sanyo Electric Company Ltd";
	case PNP_ID('T', 'S', 'D'): return "TechniSat Digital GmbH";
	case PNP_ID('T', 'S', 'E'): return "Tottori Sanyo Electric";
	case PNP_ID('T', 'S', 'F'): return "Racal-Airtech Software Forge Ltd";
	case PNP_ID('T', 'S', 'G'): return "The Software Group Ltd";
	case PNP_ID('T', 'S', 'H'): return "ELAN MICROELECTRONICS CORPORATION";
	case PNP_ID('T', 'S', 'I'): return "TeleVideo Systems";
	case PNP_ID('T', 'S', 'L'): return "Tottori SANYO Electric Co., Ltd.";
	case PNP_ID('T', 'S', 'P'): return "U.S. Navy";
	case PNP_ID('T', 'S', 'T'): return "Transtream Inc";
	case PNP_ID('T', 'S', 'V'): return "TRANSVIDEO";
	case PNP_ID('T', 'S', 'W'): return "VRSHOW Technology Limited";
	case PNP_ID('T', 'S', 'Y'): return "TouchSystems";
	case PNP_ID('T', 'T', 'A'): return "Topson Technology Co., Ltd.";
	case PNP_ID('T', 'T', 'B'): return "National Semiconductor Japan Ltd";
	case PNP_ID('T', 'T', 'C'): return "Telecommunications Techniques Corporation";
	case PNP_ID('T', 'T', 'E'): return "TTE, Inc.";
	case PNP_ID('T', 'T', 'I'): return "Trenton Terminals Inc";
	case PNP_ID('T', 'T', 'K'): return "Totoku Electric Company Ltd";
	case PNP_ID('T', 'T', 'L'): return "2-Tel B.V";
	case PNP_ID('T', 'T', 'P'): return "Toshiba Corporation";
	case PNP_ID('T', 'T', 'R'): return "Hubei Century Joint Innovation Technology Co.Ltd";
	case PNP_ID('T', 'T', 'S'): return "TechnoTrend Systemtechnik GmbH";
	case PNP_ID('T', 'T', 'X'): return "Taitex Corporation";
	case PNP_ID('T', 'T', 'Y'): return "TRIDELITY Display Solutions GmbH";
	case PNP_ID('T', 'U', 'A'): return "T+A elektroakustik GmbH";
	case PNP_ID('T', 'U', 'T'): return "Tut Systems";
	case PNP_ID('T', 'V', 'D'): return "Tecnovision";
	case PNP_ID('T', 'V', 'I'): return "Truevision";
	case PNP_ID('T', 'V', 'L'): return "Total Vision LTD";
	case PNP_ID('T', 'V', 'M'): return "Taiwan Video & Monitor Corporation";
	case PNP_ID('T', 'V', 'O'): return "TV One Ltd";
	case PNP_ID('T', 'V', 'R'): return "TV Interactive Corporation";
	case PNP_ID('T', 'V', 'S'): return "TVS Electronics Limited";
	case PNP_ID('T', 'V', 'V'): return "TV1 GmbH";
	case PNP_ID('T', 'W', 'A'): return "Tidewater Association";
	case PNP_ID('T', 'W', 'E'): return "Kontron Electronik";
	case PNP_ID('T', 'W', 'H'): return "Twinhead International Corporation";
	case PNP_ID('T', 'W', 'I'): return "Easytel oy";
	case PNP_ID('T', 'W', 'K'): return "TOWITOKO electronics GmbH";
	case PNP_ID('T', 'W', 'X'): return "TEKWorx Limited";
	case PNP_ID('T', 'X', 'L'): return "Trixel Ltd";
	case PNP_ID('T', 'X', 'N'): return "Texas Insturments";
	case PNP_ID('T', 'X', 'T'): return "Textron Defense System";
	case PNP_ID('T', 'Y', 'N'): return "Tyan Computer Corporation";
	case PNP_ID('U', 'A', 'S'): return "Ultima Associates Pte Ltd";
	case PNP_ID('U', 'B', 'I'): return "Ungermann-Bass Inc";
	case PNP_ID('U', 'B', 'L'): return "Ubinetics Ltd.";
	case PNP_ID('U', 'B', 'U'): return "Canonical Ltd.";
	case PNP_ID('U', 'D', 'N'): return "Uniden Corporation";
	case PNP_ID('U', 'E', 'C'): return "Ultima Electronics Corporation";
	case PNP_ID('U', 'E', 'G'): return "Elitegroup Computer Systems Company Ltd";
	case PNP_ID('U', 'E', 'I'): return "Universal Electronics Inc";
	case PNP_ID('U', 'E', 'T'): return "Universal Empowering Technologies";
	case PNP_ID('U', 'F', 'G'): return "UNIGRAF-USA";
	case PNP_ID('U', 'F', 'O'): return "UFO Systems Inc";
	case PNP_ID('U', 'H', 'B'): return "XOCECO";
	case PNP_ID('U', 'I', 'C'): return "Uniform Industrial Corporation";
	case PNP_ID('U', 'J', 'R'): return "Ueda Japan Radio Co., Ltd.";
	case PNP_ID('U', 'L', 'T'): return "Ultra Network Tech";
	case PNP_ID('U', 'M', 'C'): return "United Microelectr Corporation";
	case PNP_ID('U', 'M', 'G'): return "Umezawa Giken Co.,Ltd";
	case PNP_ID('U', 'M', 'M'): return "Universal Multimedia";
	case PNP_ID('U', 'M', 'T'): return "UltiMachine";
	case PNP_ID('U', 'N', 'A'): return "Unisys DSD";
	case PNP_ID('U', 'N', 'B'): return "Unisys Corporation";
	case PNP_ID('U', 'N', 'C'): return "Unisys Corporation";
	case PNP_ID('U', 'N', 'D'): return "Unisys Corporation";
	case PNP_ID('U', 'N', 'E'): return "Unisys Corporation";
	case PNP_ID('U', 'N', 'F'): return "Unisys Corporation";
	case PNP_ID('U', 'N', 'I'): return "Uniform Industry Corp.";
	case PNP_ID('U', 'N', 'M'): return "Unisys Corporation";
	case PNP_ID('U', 'N', 'O'): return "Unisys Corporation";
	case PNP_ID('U', 'N', 'P'): return "Unitop";
	case PNP_ID('U', 'N', 'S'): return "Unisys Corporation";
	case PNP_ID('U', 'N', 'T'): return "Unisys Corporation";
	case PNP_ID('U', 'N', 'Y'): return "Unicate";
	case PNP_ID('U', 'P', 'P'): return "UPPI";
	case PNP_ID('U', 'P', 'S'): return "Systems Enhancement";
	case PNP_ID('U', 'R', 'D'): return "Video Computer S.p.A.";
	case PNP_ID('U', 'S', 'A'): return "Utimaco Safeware AG";
	case PNP_ID('U', 'S', 'D'): return "U.S. Digital Corporation";
	case PNP_ID('U', 'S', 'E'): return "U. S. Electronics Inc.";
	case PNP_ID('U', 'S', 'I'): return "Universal Scientific Industrial Co., Ltd.";
	case PNP_ID('U', 'S', 'R'): return "U.S. Robotics Inc";
	case PNP_ID('U', 'T', 'C'): return "Unicompute Technology Co., Ltd.";
	case PNP_ID('U', 'T', 'D'): return "Up to Date Tech";
	case PNP_ID('U', 'W', 'C'): return "Uniwill Computer Corp.";
	case PNP_ID('V', 'A', 'D'): return "Vaddio, LLC";
	case PNP_ID('V', 'A', 'I'): return "VAIO Corporation";
	case PNP_ID('V', 'A', 'L'): return "Valence Computing Corporation";
	case PNP_ID('V', 'A', 'R'): return "Varian Australia Pty Ltd";
	case PNP_ID('V', 'A', 'T'): return "VADATECH INC";
	case PNP_ID('V', 'A', 'V'): return "aviica";
	case PNP_ID('V', 'B', 'R'): return "VBrick Systems Inc.";
	case PNP_ID('V', 'B', 'T'): return "Valley Board Ltda";
	case PNP_ID('V', 'C', 'C'): return "Virtual Computer Corporation";
	case PNP_ID('V', 'C', 'E'): return "VARCem";
	case PNP_ID('V', 'C', 'I'): return "VistaCom Inc";
	case PNP_ID('V', 'C', 'J'): return "Victor Company of Japan, Limited";
	case PNP_ID('V', 'C', 'M'): return "Vector Magnetics, LLC";
	case PNP_ID('V', 'C', 'X'): return "VCONEX";
	case PNP_ID('V', 'D', 'A'): return "Victor Data Systems";
	case PNP_ID('V', 'D', 'C'): return "VDC Display Systems";
	case PNP_ID('V', 'D', 'M'): return "Vadem";
	case PNP_ID('V', 'D', 'O'): return "Video & Display Oriented Corporation";
	case PNP_ID('V', 'D', 'S'): return "Vidisys GmbH & Company";
	case PNP_ID('V', 'D', 'T'): return "Viditec, Inc.";
	case PNP_ID('V', 'E', 'C'): return "Vector Informatik GmbH";
	case PNP_ID('V', 'E', 'K'): return "Vektrex";
	case PNP_ID('V', 'E', 'S'): return "Vestel Elektronik Sanayi ve Ticaret A. S.";
	case PNP_ID('V', 'F', 'I'): return "VeriFone Inc";
	case PNP_ID('V', 'H', 'I'): return "Macrocad Development Inc.";
	case PNP_ID('V', 'I', 'A'): return "VIA Tech Inc";
	case PNP_ID('V', 'I', 'B'): return "Tatung UK Ltd";
	case PNP_ID('V', 'I', 'C'): return "Victron B.V.";
	case PNP_ID('V', 'I', 'D'): return "Ingram Macrotron Germany";
	case PNP_ID('V', 'I', 'K'): return "Viking Connectors";
	case PNP_ID('V', 'I', 'M'): return "Via Mons Ltd.";
	case PNP_ID('V', 'I', 'N'): return "Vine Micros Ltd";
	case PNP_ID('V', 'I', 'O'): return "Zake IP Holdings LLC (3B tech)";
	case PNP_ID('V', 'I', 'R'): return "Visual Interface, Inc";
	case PNP_ID('V', 'I', 'S'): return "Visioneer";
	case PNP_ID('V', 'I', 'T'): return "Visitech AS";
	case PNP_ID('V', 'I', 'Z'): return "VIZIO, Inc";
	case PNP_ID('V', 'L', 'B'): return "ValleyBoard Ltda.";
	case PNP_ID('V', 'L', 'C'): return "VersaLogic Corporation";
	case PNP_ID('V', 'L', 'K'): return "Vislink International Ltd";
	case PNP_ID('V', 'L', 'M'): return "LENOVO BEIJING CO. LTD.";
	case PNP_ID('V', 'L', 'T'): return "VideoLan Technologies";
	case PNP_ID('V', 'L', 'V'): return "Valve Corporation";
	case PNP_ID('V', 'M', 'I'): return "Vermont Microsystems";
	case PNP_ID('V', 'M', 'L'): return "Vine Micros Limited";
	case PNP_ID('V', 'M', 'W'): return "VMware Inc.,";
	case PNP_ID('V', 'N', 'C'): return "Vinca Corporation";
	case PNP_ID('V', 'N', 'X'): return "Venetex Corporation";
	case PNP_ID('V', 'O', 'B'): return "MaxData Computer AG";
	case PNP_ID('V', 'P', 'I'): return "Video Products Inc";
	case PNP_ID('V', 'P', 'R'): return "Best Buy";
	case PNP_ID('V', 'P', 'X'): return "VPixx Technologies Inc.";
	case PNP_ID('V', 'Q', '@'): return "Vision Quest";
	case PNP_ID('V', 'R', 'C'): return "Virtual Resources Corporation";
	case PNP_ID('V', 'R', 'G'): return "VRgineers, Inc.";
	case PNP_ID('V', 'R', 'M'): return "VRmagic Holding AG";
	case PNP_ID('V', 'R', 'S'): return "VRstudios, Inc.";
	case PNP_ID('V', 'R', 'T'): return "Varjo Technologies";
	case PNP_ID('V', 'S', 'C'): return "ViewSonic Corporation";
	case PNP_ID('V', 'S', 'D'): return "3M";
	case PNP_ID('V', 'S', 'I'): return "VideoServer";
	case PNP_ID('V', 'S', 'N'): return "Ingram Macrotron";
	case PNP_ID('V', 'S', 'P'): return "Vision Systems GmbH";
	case PNP_ID('V', 'S', 'R'): return "V-Star Electronics Inc.";
	case PNP_ID('V', 'T', 'B'): return "Videotechnik Breithaupt";
	case PNP_ID('V', 'T', 'C'): return "VTel Corporation";
	case PNP_ID('V', 'T', 'G'): return "Voice Technologies Group Inc";
	case PNP_ID('V', 'T', 'I'): return "VLSI Tech Inc";
	case PNP_ID('V', 'T', 'K'): return "Viewteck Co., Ltd.";
	case PNP_ID('V', 'T', 'L'): return "Vivid Technology Pte Ltd";
	case PNP_ID('V', 'T', 'M'): return "Miltope Corporation";
	case PNP_ID('V', 'T', 'N'): return "VIDEOTRON CORP.";
	case PNP_ID('V', 'T', 'S'): return "VTech Computers Ltd";
	case PNP_ID('V', 'T', 'V'): return "VATIV Technologies";
	case PNP_ID('V', 'T', 'X'): return "Vestax Corporation";
	case PNP_ID('V', 'U', 'T'): return "Vutrix (UK) Ltd";
	case PNP_ID('V', 'V', 'I'): return "VITEC";
	case PNP_ID('V', 'W', 'B'): return "Vweb Corp.";
	case PNP_ID('W', 'A', 'C'): return "Wacom Tech";
	case PNP_ID('W', 'A', 'L'): return "Wave Access";
	case PNP_ID('W', 'A', 'N'): return "DO NOT USE - WAN";
	case PNP_ID('W', 'A', 'V'): return "Wavephore";
	case PNP_ID('W', 'B', 'N'): return "MicroSoftWare";
	case PNP_ID('W', 'B', 'S'): return "WB Systemtechnik GmbH";
	case PNP_ID('W', 'C', 'I'): return "Wisecom Inc";
	case PNP_ID('W', 'C', 'S'): return "Woodwind Communications Systems Inc";
	case PNP_ID('W', 'D', 'C'): return "Western Digital";
	case PNP_ID('W', 'D', 'E'): return "Westinghouse Digital Electronics";
	case PNP_ID('W', 'E', 'B'): return "WebGear Inc";
	case PNP_ID('W', 'E', 'C'): return "Winbond Electronics Corporation";
	case PNP_ID('W', 'E', 'L'): return "W-DEV";
	case PNP_ID('W', 'E', 'Y'): return "WEY Design AG";
	case PNP_ID('W', 'H', 'I'): return "Whistle Communications";
	case PNP_ID('W', 'I', 'I'): return "Innoware Inc";
	case PNP_ID('W', 'I', 'L'): return "WIPRO Information Technology Ltd";
	case PNP_ID('W', 'I', 'N'): return "Wintop Technology Inc";
	case PNP_ID('W', 'I', 'P'): return "Wipro Infotech";
	case PNP_ID('W', 'K', 'H'): return "Uni-Take Int'l Inc.";
	case PNP_ID('W', 'L', 'D'): return "Wildfire Communications Inc";
	case PNP_ID('W', 'L', 'F'): return "WOLF Advanced Technology";
	case PNP_ID('W', 'M', 'I'): return "Weidmuller Interface GmbH & Co. KG";
	case PNP_ID('W', 'M', 'L'): return "Wolfson Microelectronics Ltd";
	case PNP_ID('W', 'M', 'O'): return "Westermo Teleindustri AB";
	case PNP_ID('W', 'M', 'T'): return "Winmate Communication Inc";
	case PNP_ID('W', 'N', 'I'): return "WillNet Inc.";
	case PNP_ID('W', 'N', 'V'): return "Winnov L.P.";
	case PNP_ID('W', 'N', 'X'): return "Diebold Nixdorf Systems GmbH";
	case PNP_ID('W', 'P', 'A'): return "Matsushita Communication Industrial Co., Ltd.";
	case PNP_ID('W', 'P', 'I'): return "Wearnes Peripherals International (Pte) Ltd";
	case PNP_ID('W', 'R', 'C'): return "WiNRADiO Communications";
	case PNP_ID('W', 'S', 'C'): return "CIS Technology Inc";
	case PNP_ID('W', 'S', 'P'): return "Wireless And Smart Products Inc.";
	case PNP_ID('W', 'S', 'T'): return "Wistron Corporation";
	case PNP_ID('W', 'T', 'C'): return "ACC Microelectronics";
	case PNP_ID('W', 'T', 'I'): return "WorkStation Tech";
	case PNP_ID('W', 'T', 'K'): return "Wearnes Thakral Pte";
	case PNP_ID('W', 'T', 'S'): return "Restek Electric Company Ltd";
	case PNP_ID('W', 'V', 'M'): return "Wave Systems Corporation";
	case PNP_ID('W', 'V', 'V'): return "WolfVision GmbH";
	case PNP_ID('W', 'W', 'P'): return "Wipotec Wiege- und Positioniersysteme GmbH";
	case PNP_ID('W', 'W', 'V'): return "World Wide Video, Inc.";
	case PNP_ID('W', 'X', 'T'): return "Woxter Technology Co. Ltd";
	case PNP_ID('W', 'Y', 'R'): return "WyreStorm Technologies LLC";
	case PNP_ID('W', 'Y', 'S'): return "Wyse Technology";
	case PNP_ID('W', 'Y', 'T'): return "Wooyoung Image & Information Co.,Ltd.";
	case PNP_ID('X', 'A', 'C'): return "XAC Automation Corp";
	case PNP_ID('X', 'A', 'D'): return "Alpha Data";
	case PNP_ID('X', 'D', 'M'): return "XDM Ltd.";
	case PNP_ID('X', 'E', 'R'): return "DO NOT USE - XER";
	case PNP_ID('X', 'E', 'S'): return "Extreme Engineering Solutions, Inc.";
	case PNP_ID('X', 'F', 'G'): return "Jan Strapko - FOTO";
	case PNP_ID('X', 'F', 'O'): return "EXFO Electro Optical Engineering";
	case PNP_ID('X', 'I', 'N'): return "Xinex Networks Inc";
	case PNP_ID('X', 'I', 'O'): return "Xiotech Corporation";
	case PNP_ID('X', 'I', 'R'): return "Xirocm Inc";
	case PNP_ID('X', 'I', 'T'): return "Xitel Pty ltd";
	case PNP_ID('X', 'L', 'X'): return "Xilinx, Inc.";
	case PNP_ID('X', 'M', 'M'): return "C3PO S.L.";
	case PNP_ID('X', 'N', 'T'): return "XN Technologies, Inc.";
	case PNP_ID('X', 'O', 'C'): return "DO NOT USE - XOC";
	case PNP_ID('X', 'Q', 'U'): return "SHANGHAI SVA-DAV ELECTRONICS CO., LTD";
	case PNP_ID('X', 'R', 'C'): return "Xircom Inc";
	case PNP_ID('X', 'R', 'O'): return "XORO ELECTRONICS (CHENGDU) LIMITED";
	case PNP_ID('X', 'S', 'N'): return "Xscreen AS";
	case PNP_ID('X', 'S', 'T'): return "XS Technologies Inc";
	case PNP_ID('X', 'S', 'Y'): return "XSYS";
	case PNP_ID('X', 'T', 'D'): return "Icuiti Corporation";
	case PNP_ID('X', 'T', 'E'): return "X2E GmbH";
	case PNP_ID('X', 'T', 'L'): return "Crystal Computer";
	case PNP_ID('X', 'T', 'N'): return "X-10 (USA) Inc";
	case PNP_ID('X', 'Y', 'C'): return "Xycotec Computer GmbH";
	case PNP_ID('X', 'Y', 'E'): return "Shenzhen Zhuona Technology Co., Ltd.";
	case PNP_ID('Y', 'E', 'D'): return "Y-E Data Inc";
	case PNP_ID('Y', 'H', 'Q'): return "Yokogawa Electric Corporation";
	case PNP_ID('Y', 'H', 'W'): return "Exacom SA";
	case PNP_ID('Y', 'M', 'H'): return "Yamaha Corporation";
	case PNP_ID('Y', 'O', 'W'): return "American Biometric Company";
	case PNP_ID('Z', 'A', 'N'): return "Zandar Technologies plc";
	case PNP_ID('Z', 'A', 'X'): return "Zefiro Acoustics";
	case PNP_ID('Z', 'A', 'Z'): return "ZeeVee, Inc.";
	case PNP_ID('Z', 'B', 'R'): return "Zebra Technologies International, LLC";
	case PNP_ID('Z', 'B', 'X'): return "Zebax Technologies";
	case PNP_ID('Z', 'C', 'T'): return "ZeitControl cardsystems GmbH";
	case PNP_ID('Z', 'D', 'S'): return "Zenith Data Systems";
	case PNP_ID('Z', 'E', 'N'): return "ZENIC Inc.";
	case PNP_ID('Z', 'G', 'T'): return "Zenith Data Systems";
	case PNP_ID('Z', 'I', 'C'): return "Nationz Technologies Inc.";
	case PNP_ID('Z', 'M', 'C'): return "HangZhou ZMCHIVIN";
	case PNP_ID('Z', 'M', 'T'): return "Zalman Tech Co., Ltd.";
	case PNP_ID('Z', 'M', 'Z'): return "Z Microsystems";
	case PNP_ID('Z', 'N', 'I'): return "Zetinet Inc";
	case PNP_ID('Z', 'N', 'X'): return "Znyx Adv. Systems";
	case PNP_ID('Z', 'O', 'W'): return "Zowie Intertainment, Inc";
	case PNP_ID('Z', 'R', 'N'): return "Zoran Corporation";
	case PNP_ID('Z', 'S', 'E'): return "Zenith Data Systems";
	case PNP_ID('Z', 'T', 'C'): return "ZyDAS Technology Corporation";
	case PNP_ID('Z', 'T', 'E'): return "ZTE Corporation";
	case PNP_ID('Z', 'T', 'I'): return "Zoom Telephonics Inc";
	case PNP_ID('Z', 'T', 'M'): return "ZT Group Int'l Inc.";
	case PNP_ID('Z', 'T', 'T'): return "Z3 Technology";
	case PNP_ID('Z', 'W', 'E'): return "Shenzhen Zowee Technology Co., LTD";
	case PNP_ID('Z', 'Y', 'D'): return "Zydacron Inc";
	case PNP_ID('Z', 'Y', 'P'): return "Zypcom Inc";
	case PNP_ID('Z', 'Y', 'T'): return "Zytex Computers";
	case PNP_ID('Z', 'Y', 'X'): return "Zyxel";
	case PNP_ID('Z', 'Z', 'Z'): return "Boca Research Inc";
	}
	return NULL;
}
#undef PNP_ID
