/* Generated by wayland-scanner 1.23.0 */

#ifndef WLR_VIRTUAL_POINTER_UNSTABLE_V1_SERVER_PROTOCOL_H
#define WLR_VIRTUAL_POINTER_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_wlr_virtual_pointer_unstable_v1 The wlr_virtual_pointer_unstable_v1 protocol
 * @section page_ifaces_wlr_virtual_pointer_unstable_v1 Interfaces
 * - @subpage page_iface_zwlr_virtual_pointer_v1 - virtual pointer
 * - @subpage page_iface_zwlr_virtual_pointer_manager_v1 - virtual pointer manager
 * @section page_copyright_wlr_virtual_pointer_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2019 Josef Gajdusek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_output;
struct wl_seat;
struct zwlr_virtual_pointer_manager_v1;
struct zwlr_virtual_pointer_v1;

#ifndef ZWLR_VIRTUAL_POINTER_V1_INTERFACE
#define ZWLR_VIRTUAL_POINTER_V1_INTERFACE
/**
 * @page page_iface_zwlr_virtual_pointer_v1 zwlr_virtual_pointer_v1
 * @section page_iface_zwlr_virtual_pointer_v1_desc Description
 *
 * This protocol allows clients to emulate a physical pointer device. The
 * requests are mostly mirror opposites of those specified in wl_pointer.
 * @section page_iface_zwlr_virtual_pointer_v1_api API
 * See @ref iface_zwlr_virtual_pointer_v1.
 */
/**
 * @defgroup iface_zwlr_virtual_pointer_v1 The zwlr_virtual_pointer_v1 interface
 *
 * This protocol allows clients to emulate a physical pointer device. The
 * requests are mostly mirror opposites of those specified in wl_pointer.
 */
extern const struct wl_interface zwlr_virtual_pointer_v1_interface;
#endif
#ifndef ZWLR_VIRTUAL_POINTER_MANAGER_V1_INTERFACE
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zwlr_virtual_pointer_manager_v1 zwlr_virtual_pointer_manager_v1
 * @section page_iface_zwlr_virtual_pointer_manager_v1_desc Description
 *
 * This object allows clients to create individual virtual pointer objects.
 * @section page_iface_zwlr_virtual_pointer_manager_v1_api API
 * See @ref iface_zwlr_virtual_pointer_manager_v1.
 */
/**
 * @defgroup iface_zwlr_virtual_pointer_manager_v1 The zwlr_virtual_pointer_manager_v1 interface
 *
 * This object allows clients to create individual virtual pointer objects.
 */
extern const struct wl_interface zwlr_virtual_pointer_manager_v1_interface;
#endif

#ifndef ZWLR_VIRTUAL_POINTER_V1_ERROR_ENUM
#define ZWLR_VIRTUAL_POINTER_V1_ERROR_ENUM
enum zwlr_virtual_pointer_v1_error {
	/**
	 * client sent invalid axis enumeration value
	 */
	ZWLR_VIRTUAL_POINTER_V1_ERROR_INVALID_AXIS = 0,
	/**
	 * client sent invalid axis source enumeration value
	 */
	ZWLR_VIRTUAL_POINTER_V1_ERROR_INVALID_AXIS_SOURCE = 1,
};
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 * Validate a zwlr_virtual_pointer_v1 error value.
 *
 * @return true on success, false on error.
 * @ref zwlr_virtual_pointer_v1_error
 */
static inline bool
zwlr_virtual_pointer_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWLR_VIRTUAL_POINTER_V1_ERROR_INVALID_AXIS:
		return version >= 1;
	case ZWLR_VIRTUAL_POINTER_V1_ERROR_INVALID_AXIS_SOURCE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWLR_VIRTUAL_POINTER_V1_ERROR_ENUM */

/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 * @struct zwlr_virtual_pointer_v1_interface
 */
struct zwlr_virtual_pointer_v1_interface {
	/**
	 * pointer relative motion event
	 *
	 * The pointer has moved by a relative amount to the previous
	 * request.
	 *
	 * Values are in the global compositor space.
	 * @param time timestamp with millisecond granularity
	 * @param dx displacement on the x-axis
	 * @param dy displacement on the y-axis
	 */
	void (*motion)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t time,
		       wl_fixed_t dx,
		       wl_fixed_t dy);
	/**
	 * pointer absolute motion event
	 *
	 * The pointer has moved in an absolute coordinate frame.
	 *
	 * Value of x can range from 0 to x_extent, value of y can range
	 * from 0 to y_extent.
	 * @param time timestamp with millisecond granularity
	 * @param x position on the x-axis
	 * @param y position on the y-axis
	 * @param x_extent extent of the x-axis
	 * @param y_extent extent of the y-axis
	 */
	void (*motion_absolute)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t time,
				uint32_t x,
				uint32_t y,
				uint32_t x_extent,
				uint32_t y_extent);
	/**
	 * button event
	 *
	 * A button was pressed or released.
	 * @param time timestamp with millisecond granularity
	 * @param button button that produced the event
	 * @param state physical state of the button
	 */
	void (*button)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t time,
		       uint32_t button,
		       uint32_t state);
	/**
	 * axis event
	 *
	 * Scroll and other axis requests.
	 * @param time timestamp with millisecond granularity
	 * @param axis axis type
	 * @param value length of vector in touchpad coordinates
	 */
	void (*axis)(struct wl_client *client,
		     struct wl_resource *resource,
		     uint32_t time,
		     uint32_t axis,
		     wl_fixed_t value);
	/**
	 * end of a pointer event sequence
	 *
	 * Indicates the set of events that logically belong together.
	 */
	void (*frame)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * axis source event
	 *
	 * Source information for scroll and other axis.
	 * @param axis_source source of the axis event
	 */
	void (*axis_source)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t axis_source);
	/**
	 * axis stop event
	 *
	 * Stop notification for scroll and other axes.
	 * @param time timestamp with millisecond granularity
	 * @param axis the axis stopped with this event
	 */
	void (*axis_stop)(struct wl_client *client,
			  struct wl_resource *resource,
			  uint32_t time,
			  uint32_t axis);
	/**
	 * axis click event
	 *
	 * Discrete step information for scroll and other axes.
	 *
	 * This event allows the client to extend data normally sent using
	 * the axis event with discrete value.
	 * @param time timestamp with millisecond granularity
	 * @param axis axis type
	 * @param value length of vector in touchpad coordinates
	 * @param discrete number of steps
	 */
	void (*axis_discrete)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t time,
			      uint32_t axis,
			      wl_fixed_t value,
			      int32_t discrete);
	/**
	 * destroy the virtual pointer object
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_MOTION_ABSOLUTE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_FRAME_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_STOP_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_AXIS_DISCRETE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_v1
 */
#define ZWLR_VIRTUAL_POINTER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 * @struct zwlr_virtual_pointer_manager_v1_interface
 */
struct zwlr_virtual_pointer_manager_v1_interface {
	/**
	 * Create a new virtual pointer
	 *
	 * Creates a new virtual pointer. The optional seat is a
	 * suggestion to the compositor.
	 */
	void (*create_virtual_pointer)(struct wl_client *client,
				       struct wl_resource *resource,
				       struct wl_resource *seat,
				       uint32_t id);
	/**
	 * destroy the virtual pointer manager
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * Create a new virtual pointer
	 *
	 * Creates a new virtual pointer. The seat and the output
	 * arguments are optional. If the seat argument is set, the
	 * compositor should assign the input device to the requested seat.
	 * If the output argument is set, the compositor should map the
	 * input device to the requested output.
	 * @since 2
	 */
	void (*create_virtual_pointer_with_output)(struct wl_client *client,
						   struct wl_resource *resource,
						   struct wl_resource *seat,
						   struct wl_resource *output,
						   uint32_t id);
};


/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 */
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_CREATE_VIRTUAL_POINTER_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 */
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_virtual_pointer_manager_v1
 */
#define ZWLR_VIRTUAL_POINTER_MANAGER_V1_CREATE_VIRTUAL_POINTER_WITH_OUTPUT_SINCE_VERSION 2

#ifdef  __cplusplus
}
#endif

#endif
