# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network nat gateway update",
)
class Update(AAZCommand):
    """Update a NAT gateway.

    :example: Update a NAT gateway.
        az network nat gateway update -g MyResourceGroup --name MyNatGateway --idle-timeout 5
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/natgateways/{}", "2022-01-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="Name of the NAT gateway.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.idle_timeout = AAZIntArg(
            options=["--idle-timeout"],
            help="Idle timeout in minutes.",
            nullable=True,
        )
        _args_schema.pip_addresses = AAZListArg(
            options=["--pip-addresses"],
            help="Space-separated list of public IP addresses (Names or IDs).",
            nullable=True,
        )
        _args_schema.pip_prefixes = AAZListArg(
            options=["--pip-prefixes"],
            help="Space-separated list of public IP prefixes (Names or IDs).",
            nullable=True,
        )

        pip_addresses = cls._args_schema.pip_addresses
        pip_addresses.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.pip_addresses.Element
        _element.id = AAZStrArg(
            options=["id"],
            nullable=True,
        )

        pip_prefixes = cls._args_schema.pip_prefixes
        pip_prefixes.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.pip_prefixes.Element
        _element.id = AAZStrArg(
            options=["id"],
            nullable=True,
        )

        # define Arg Group "Parameters"
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.NatGatewaysGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.NatGatewaysCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class NatGatewaysGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "natGatewayName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_nat_gateway_read(cls._schema_on_200)

            return cls._schema_on_200

    class NatGatewaysCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/natGateways/{natGatewayName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "natGatewayName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_nat_gateway_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout")
                properties.set_prop("publicIpAddresses", AAZListType, ".pip_addresses")
                properties.set_prop("publicIpPrefixes", AAZListType, ".pip_prefixes")

            public_ip_addresses = _builder.get(".properties.publicIpAddresses")
            if public_ip_addresses is not None:
                public_ip_addresses.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.publicIpAddresses[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")

            public_ip_prefixes = _builder.get(".properties.publicIpPrefixes")
            if public_ip_prefixes is not None:
                public_ip_prefixes.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.publicIpPrefixes[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_nat_gateway_read = None

    @classmethod
    def _build_schema_nat_gateway_read(cls, _schema):
        if cls._schema_nat_gateway_read is not None:
            _schema.etag = cls._schema_nat_gateway_read.etag
            _schema.id = cls._schema_nat_gateway_read.id
            _schema.location = cls._schema_nat_gateway_read.location
            _schema.name = cls._schema_nat_gateway_read.name
            _schema.properties = cls._schema_nat_gateway_read.properties
            _schema.sku = cls._schema_nat_gateway_read.sku
            _schema.tags = cls._schema_nat_gateway_read.tags
            _schema.type = cls._schema_nat_gateway_read.type
            _schema.zones = cls._schema_nat_gateway_read.zones
            return

        cls._schema_nat_gateway_read = _schema_nat_gateway_read = AAZObjectType()

        nat_gateway_read = _schema_nat_gateway_read
        nat_gateway_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        nat_gateway_read.id = AAZStrType()
        nat_gateway_read.location = AAZStrType()
        nat_gateway_read.name = AAZStrType(
            flags={"read_only": True},
        )
        nat_gateway_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        nat_gateway_read.sku = AAZObjectType()
        nat_gateway_read.tags = AAZDictType()
        nat_gateway_read.type = AAZStrType(
            flags={"read_only": True},
        )
        nat_gateway_read.zones = AAZListType()

        properties = _schema_nat_gateway_read.properties
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.public_ip_addresses = AAZListType(
            serialized_name="publicIpAddresses",
        )
        properties.public_ip_prefixes = AAZListType(
            serialized_name="publicIpPrefixes",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        public_ip_addresses = _schema_nat_gateway_read.properties.public_ip_addresses
        public_ip_addresses.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(public_ip_addresses.Element)

        public_ip_prefixes = _schema_nat_gateway_read.properties.public_ip_prefixes
        public_ip_prefixes.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(public_ip_prefixes.Element)

        subnets = _schema_nat_gateway_read.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(subnets.Element)

        sku = _schema_nat_gateway_read.sku
        sku.name = AAZStrType()

        tags = _schema_nat_gateway_read.tags
        tags.Element = AAZStrType()

        zones = _schema_nat_gateway_read.zones
        zones.Element = AAZStrType()

        _schema.etag = cls._schema_nat_gateway_read.etag
        _schema.id = cls._schema_nat_gateway_read.id
        _schema.location = cls._schema_nat_gateway_read.location
        _schema.name = cls._schema_nat_gateway_read.name
        _schema.properties = cls._schema_nat_gateway_read.properties
        _schema.sku = cls._schema_nat_gateway_read.sku
        _schema.tags = cls._schema_nat_gateway_read.tags
        _schema.type = cls._schema_nat_gateway_read.type
        _schema.zones = cls._schema_nat_gateway_read.zones

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id


__all__ = ["Update"]
