/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import tim.prune.data.DataPoint;
import tim.prune.data.SourceInfo;
import tim.prune.save.xml.GpxSlicer;
import tim.prune.save.xml.TagReceiver;

public class GpxCacher
implements TagReceiver {
    private final SourceInfo _sourceInfo;
    private String _headerString = null;
    private String[] _strings = null;
    private int _pointNum = 0;

    public GpxCacher(SourceInfo sourceInfo) {
        this._sourceInfo = sourceInfo;
        this._strings = new String[sourceInfo.getNumPoints()];
        this._pointNum = 0;
        File file = sourceInfo.getFile();
        String string = file.getName().toLowerCase();
        if (file.exists() && file.canRead()) {
            GpxSlicer gpxSlicer = new GpxSlicer(this);
            InputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                if (string.endsWith(".gpx") || string.endsWith(".xml")) {
                    inputStream = new FileInputStream(sourceInfo.getFile());
                } else if (string.endsWith(".zip")) {
                    inputStream = GpxCacher.getZipInputStream(sourceInfo.getFile());
                } else if (string.endsWith(".gz")) {
                    inputStream = new GZIPInputStream(new FileInputStream(sourceInfo.getFile()));
                } else {
                    System.out.println("GpxCacher unrecognised file type: " + sourceInfo.getFile().getName());
                }
                if (inputStream != null) {
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    gpxSlicer.slice(bufferedInputStream);
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void reportTag(String string) {
        if (this._headerString == null) {
            this._headerString = string;
        } else if (this._strings != null) {
            if (this._pointNum < this._strings.length) {
                this._strings[this._pointNum] = string;
                ++this._pointNum;
            } else {
                this._strings = null;
            }
        }
    }

    public String getHeaderString() {
        return this._headerString;
    }

    public String getSourceString(DataPoint dataPoint) {
        if (this._sourceInfo != dataPoint.getSourceInfo()) {
            return null;
        }
        int n = dataPoint.getOriginalIndex();
        if (this._strings != null && n >= 0 && n < this._strings.length) {
            return this._strings[n];
        }
        return null;
    }

    private static InputStream getZipInputStream(File file) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            while (zipInputStream.available() > 0) {
                String string;
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                String string2 = zipEntry.toString();
                if (string2 == null || string2.length() <= 4 || !(string = string2.substring(string2.length() - 4).toLowerCase()).equals(".gpx") && !string.equals(".xml")) continue;
                return zipInputStream;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

