/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.AsyncCache;
import io.micronaut.cache.SyncCache;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

@Internal
public class DelegatingAsyncBlockingCache<C>
implements AsyncCache<C> {
    private final SyncCache<C> delegate;

    public DelegatingAsyncBlockingCache(SyncCache<C> delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> CompletableFuture<Optional<T>> get(Object key, Argument<T> requiredType) {
        try {
            return CompletableFuture.completedFuture(this.delegate.get(key, requiredType));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    @Override
    public <T> CompletableFuture<T> get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
        try {
            return CompletableFuture.completedFuture(this.delegate.get(key, requiredType, supplier));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    @Override
    public <T> CompletableFuture<Optional<T>> putIfAbsent(Object key, T value) {
        try {
            return CompletableFuture.completedFuture(this.delegate.putIfAbsent(key, value));
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public C getNativeCache() {
        return this.delegate.getNativeCache();
    }

    @Override
    public CompletableFuture<Boolean> put(Object key, Object value) {
        try {
            this.delegate.put(key, value);
            return CompletableFuture.completedFuture(true);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    @Override
    public CompletableFuture<Boolean> invalidate(Object key) {
        try {
            this.delegate.invalidate(key);
            return CompletableFuture.completedFuture(true);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    @Override
    public CompletableFuture<Boolean> invalidateAll() {
        try {
            this.delegate.invalidateAll();
            return CompletableFuture.completedFuture(true);
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    private <T> CompletableFuture<T> handleException(Exception e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }
}

