/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.SaveToFile;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class SaveAction
extends SaveActionBase {
    private static final SaveAction instance = new SaveAction();
    private final PropertyChangeListener updateOnRequireSaveChange = evt -> {
        if (AbstractModifiableLayer.REQUIRES_SAVE_TO_DISK_PROP.equals(evt.getPropertyName())) {
            this.updateEnabledState();
        }
    };

    private SaveAction() {
        super(I18n.tr("Save", new Object[0]), "save", I18n.tr("Save the current data.", new Object[0]), Shortcut.registerShortcut("system:save", I18n.tr("File: {0}", I18n.tr("Save", new Object[0])), 83, 5006), true);
        this.setHelpId(HelpUtil.ht("/Action/Save"));
    }

    public static SaveAction getInstance() {
        return instance;
    }

    @Override
    protected JosmAction.LayerChangeAdapter buildLayerChangeAdapter() {
        return new JosmAction.LayerChangeAdapter(){

            @Override
            public void layerAdded(LayerManager.LayerAddEvent e) {
                Layer l = e.getAddedLayer();
                if (l instanceof AbstractModifiableLayer) {
                    l.addPropertyChangeListener(SaveAction.this.updateOnRequireSaveChange);
                }
                super.layerAdded(e);
            }

            @Override
            public void layerRemoving(LayerManager.LayerRemoveEvent e) {
                Layer l = e.getRemovedLayer();
                if (l instanceof AbstractModifiableLayer) {
                    l.removePropertyChangeListener(SaveAction.this.updateOnRequireSaveChange);
                }
                super.layerRemoving(e);
            }
        };
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        Layer activeLayer = this.getLayerManager().getActiveLayer();
        boolean en = activeLayer != null && activeLayer.isSavable() && (activeLayer.getAssociatedFile() == null || !(activeLayer instanceof SaveToFile) || ((SaveToFile)((Object)activeLayer)).requiresSaveToFile());
        GuiHelper.runInEDT(() -> this.setEnabled(en));
    }

    @Override
    public File getFile(Layer layer) {
        File f = layer.getAssociatedFile();
        if (f != null && !f.exists()) {
            f = null;
        }
        if (!(f == null || !(layer instanceof GpxLayer) || ((GpxLayer)layer).data != null && "JOSM GPX export".equals(((GpxLayer)layer).data.creator) || Config.getPref().getBoolean("gpx.export.overwrite", false))) {
            JPanel p = new JPanel(new GridBagLayout());
            JLabel label = new JLabel("<html>" + I18n.tr("The file \"{0}\" will be modified.<br>Would you like to overwrite the existing file?", f.getName()) + "</html>");
            label.setHorizontalAlignment(0);
            JCheckBox remember = new JCheckBox(I18n.tr("Always overwrite GPX files without asking", new Object[0]));
            remember.setHorizontalAlignment(0);
            p.add((Component)label, GBC.eol().fill(2).insets(5, 5, 5, 10));
            p.add((Component)remember, GBC.eop().fill(2));
            ExtendedDialog dialog = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Overwrite", new Object[0]), I18n.tr("Overwrite", new Object[0]), I18n.tr("Save As...", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("save", "save_as", "cancel").setContent(p);
            int val = dialog.showDialog().getValue();
            if (val == 1) {
                Config.getPref().putBoolean("gpx.export.overwrite", remember.isSelected());
            } else if (val == 2) {
                f = null;
            } else {
                return null;
            }
        }
        return f == null ? layer.createAndOpenSaveFileChooser() : f;
    }
}

