/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.svg2svg;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.transcoder.svg2svg.PrettyPrinter;
import org.apache.batik.xml.XMLUtilities;

public class OutputManager {
    protected PrettyPrinter prettyPrinter;
    protected Writer writer;
    protected int level;
    protected StringBuffer margin = new StringBuffer();
    protected int line = 1;
    protected int column;
    protected List xmlSpace = new LinkedList();
    protected boolean canIndent;
    protected List startingLines;
    protected boolean lineAttributes;

    public OutputManager(PrettyPrinter prettyPrinter, Writer writer) {
        this.xmlSpace.add(Boolean.FALSE);
        this.canIndent = true;
        this.startingLines = new LinkedList();
        this.lineAttributes = false;
        this.prettyPrinter = prettyPrinter;
        this.writer = writer;
    }

    public void printCharacter(char c) throws IOException {
        if (c == '\n') {
            this.printNewline();
        } else {
            ++this.column;
            this.writer.write(c);
        }
    }

    public void printNewline() throws IOException {
        String string = this.prettyPrinter.getNewline();
        for (int i = 0; i < string.length(); ++i) {
            this.writer.write(string.charAt(i));
        }
        this.column = 0;
        ++this.line;
    }

    public void printString(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.printCharacter(string.charAt(i));
        }
    }

    public void printCharacters(char[] cArray) throws IOException {
        for (int i = 0; i < cArray.length; ++i) {
            this.printCharacter(cArray[i]);
        }
    }

    public void printSpaces(char[] cArray, boolean bl) throws IOException {
        if (this.prettyPrinter.getFormat()) {
            if (!bl) {
                this.printCharacter(' ');
            }
        } else {
            this.printCharacters(cArray);
        }
    }

    public void printTopSpaces(char[] cArray) throws IOException {
        if (this.prettyPrinter.getFormat()) {
            int n = this.newlines(cArray);
            for (int i = 0; i < n; ++i) {
                this.printNewline();
            }
        } else {
            this.printCharacters(cArray);
        }
    }

    public void printComment(char[] cArray) throws IOException {
        if (this.prettyPrinter.getFormat()) {
            if (this.canIndent) {
                this.printNewline();
                this.printString(this.margin.toString());
            }
            this.printString("<!--");
            if (this.column + cArray.length + 3 < this.prettyPrinter.getDocumentWidth()) {
                this.printCharacters(cArray);
            } else {
                this.formatText(cArray, this.margin.toString(), false);
                this.printCharacter(' ');
            }
            if (this.column + 3 > this.prettyPrinter.getDocumentWidth()) {
                this.printNewline();
                this.printString(this.margin.toString());
            }
            this.printString("-->");
        } else {
            this.printString("<!--");
            this.printCharacters(cArray);
            this.printString("-->");
        }
    }

    public void printXMLDecl(char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, char c, char[] cArray5, char[] cArray6, char[] cArray7, char[] cArray8, char c2, char[] cArray9, char[] cArray10, char[] cArray11, char[] cArray12, char c3, char[] cArray13) throws IOException {
        this.printString("<?xml");
        this.printSpaces(cArray, false);
        this.printString("version");
        if (cArray2 != null) {
            this.printSpaces(cArray2, true);
        }
        this.printCharacter('=');
        if (cArray3 != null) {
            this.printSpaces(cArray3, true);
        }
        this.printCharacter(c);
        this.printCharacters(cArray4);
        this.printCharacter(c);
        if (cArray5 != null) {
            this.printSpaces(cArray5, false);
            if (cArray8 != null) {
                this.printString("encoding");
                if (cArray6 != null) {
                    this.printSpaces(cArray6, true);
                }
                this.printCharacter('=');
                if (cArray7 != null) {
                    this.printSpaces(cArray7, true);
                }
                this.printCharacter(c2);
                this.printCharacters(cArray8);
                this.printCharacter(c2);
                if (cArray9 != null) {
                    this.printSpaces(cArray9, cArray12 == null);
                }
            }
            if (cArray12 != null) {
                this.printString("standalone");
                if (cArray10 != null) {
                    this.printSpaces(cArray10, true);
                }
                this.printCharacter('=');
                if (cArray11 != null) {
                    this.printSpaces(cArray11, true);
                }
                this.printCharacter(c3);
                this.printCharacters(cArray12);
                this.printCharacter(c3);
                if (cArray13 != null) {
                    this.printSpaces(cArray13, true);
                }
            }
        }
        this.printString("?>");
    }

    public void printPI(char[] cArray, char[] cArray2, char[] cArray3) throws IOException {
        if (this.prettyPrinter.getFormat() && this.canIndent) {
            this.printNewline();
            this.printString(this.margin.toString());
        }
        this.printString("<?");
        this.printCharacters(cArray);
        this.printSpaces(cArray2, false);
        this.printCharacters(cArray3);
        this.printString("?>");
    }

    public void printDoctypeStart(char[] cArray, char[] cArray2, char[] cArray3, String string, char[] cArray4, char[] cArray5, char c, char[] cArray6, char[] cArray7, char c2, char[] cArray8) throws IOException {
        if (this.prettyPrinter.getFormat()) {
            this.printString("<!DOCTYPE");
            this.printCharacter(' ');
            this.printCharacters(cArray2);
            if (cArray3 != null) {
                this.printCharacter(' ');
                this.printString(string);
                this.printCharacter(' ');
                this.printCharacter(c);
                this.printCharacters(cArray5);
                this.printCharacter(c);
                if (cArray6 != null && cArray7 != null) {
                    if (this.column + cArray7.length + 3 > this.prettyPrinter.getDocumentWidth()) {
                        this.printNewline();
                        for (int i = 0; i < this.prettyPrinter.getTabulationWidth(); ++i) {
                            this.printCharacter(' ');
                        }
                    } else {
                        this.printCharacter(' ');
                    }
                    this.printCharacter(c2);
                    this.printCharacters(cArray7);
                    this.printCharacter(c2);
                    this.printCharacter(' ');
                }
            }
        } else {
            this.printString("<!DOCTYPE");
            this.printSpaces(cArray, false);
            this.printCharacters(cArray2);
            if (cArray3 != null) {
                this.printSpaces(cArray3, false);
                this.printString(string);
                this.printSpaces(cArray4, false);
                this.printCharacter(c);
                this.printCharacters(cArray5);
                this.printCharacter(c);
                if (cArray6 != null) {
                    this.printSpaces(cArray6, cArray7 == null);
                    if (cArray7 != null) {
                        this.printCharacter(c2);
                        this.printCharacters(cArray7);
                        this.printCharacter(c2);
                        if (cArray8 != null) {
                            this.printSpaces(cArray8, true);
                        }
                    }
                }
            }
        }
    }

    public void printDoctypeEnd(char[] cArray) throws IOException {
        if (cArray != null) {
            this.printSpaces(cArray, true);
        }
        this.printCharacter('>');
    }

    public void printParameterEntityReference(char[] cArray) throws IOException {
        this.printCharacter('%');
        this.printCharacters(cArray);
        this.printCharacter(';');
    }

    public void printEntityReference(char[] cArray, boolean bl) throws IOException {
        if (this.prettyPrinter.getFormat() && this.xmlSpace.get(0) != Boolean.TRUE && bl) {
            this.printNewline();
            this.printString(this.margin.toString());
        }
        this.printCharacter('&');
        this.printCharacters(cArray);
        this.printCharacter(';');
    }

    public void printCharacterEntityReference(char[] cArray, boolean bl, boolean bl2) throws IOException {
        if (this.prettyPrinter.getFormat() && this.xmlSpace.get(0) != Boolean.TRUE) {
            if (bl) {
                this.printNewline();
                this.printString(this.margin.toString());
            } else if (bl2) {
                int n = this.column + cArray.length + 3;
                if (n > this.prettyPrinter.getDocumentWidth()) {
                    this.printNewline();
                    this.printString(this.margin.toString());
                } else {
                    this.printCharacter(' ');
                }
            }
        }
        this.printString("&#");
        this.printCharacters(cArray);
        this.printCharacter(';');
    }

    public void printElementStart(char[] cArray, List list, char[] cArray2) throws IOException {
        AttributeInfo attributeInfo;
        Iterator iterator;
        this.xmlSpace.add(0, this.xmlSpace.get(0));
        this.startingLines.add(0, new Integer(this.line));
        if (this.prettyPrinter.getFormat() && this.canIndent) {
            this.printNewline();
            this.printString(this.margin.toString());
        }
        this.printCharacter('<');
        this.printCharacters(cArray);
        if (this.prettyPrinter.getFormat()) {
            iterator = list.iterator();
            if (iterator.hasNext()) {
                attributeInfo = (AttributeInfo)iterator.next();
                if (attributeInfo.isAttribute("xml:space")) {
                    this.xmlSpace.set(0, attributeInfo.value.equals("preserve") ? Boolean.TRUE : Boolean.FALSE);
                }
                this.printCharacter(' ');
                this.printCharacters(attributeInfo.name);
                this.printCharacter('=');
                this.printCharacter(attributeInfo.delimiter);
                this.printString(attributeInfo.value);
                this.printCharacter(attributeInfo.delimiter);
            }
            while (iterator.hasNext()) {
                attributeInfo = (AttributeInfo)iterator.next();
                if (attributeInfo.isAttribute("xml:space")) {
                    this.xmlSpace.set(0, attributeInfo.value.equals("preserve") ? Boolean.TRUE : Boolean.FALSE);
                }
                int n = attributeInfo.name.length + attributeInfo.value.length() + 4;
                if (this.lineAttributes || n + this.column > this.prettyPrinter.getDocumentWidth()) {
                    this.printNewline();
                    this.printString(this.margin.toString());
                    for (int i = 0; i < cArray.length + 2; ++i) {
                        this.printCharacter(' ');
                    }
                } else {
                    this.printCharacter(' ');
                }
                this.printCharacters(attributeInfo.name);
                this.printCharacter('=');
                this.printCharacter(attributeInfo.delimiter);
                this.printString(attributeInfo.value);
                this.printCharacter(attributeInfo.delimiter);
            }
        } else {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                attributeInfo = (AttributeInfo)iterator.next();
                if (attributeInfo.isAttribute("xml:space")) {
                    this.xmlSpace.set(0, attributeInfo.value.equals("preserve") ? Boolean.TRUE : Boolean.FALSE);
                }
                this.printSpaces(attributeInfo.space, false);
                this.printCharacters(attributeInfo.name);
                if (attributeInfo.space1 != null) {
                    this.printSpaces(attributeInfo.space1, true);
                }
                this.printCharacter('=');
                if (attributeInfo.space2 != null) {
                    this.printSpaces(attributeInfo.space2, true);
                }
                this.printCharacter(attributeInfo.delimiter);
                this.printString(attributeInfo.value);
                this.printCharacter(attributeInfo.delimiter);
            }
        }
        if (cArray2 != null) {
            this.printSpaces(cArray2, true);
        }
        ++this.level;
        for (int i = 0; i < this.prettyPrinter.getTabulationWidth(); ++i) {
            this.margin.append(' ');
        }
        this.canIndent = true;
    }

    public void printElementEnd(char[] cArray, char[] cArray2) throws IOException {
        for (int i = 0; i < this.prettyPrinter.getTabulationWidth(); ++i) {
            this.margin.deleteCharAt(0);
        }
        --this.level;
        if (cArray != null) {
            if (this.prettyPrinter.getFormat() && this.xmlSpace.get(0) != Boolean.TRUE && (this.line != (Integer)this.startingLines.get(0) || this.column + cArray.length + 3 >= this.prettyPrinter.getDocumentWidth())) {
                this.printNewline();
                this.printString(this.margin.toString());
            }
            this.printString("</");
            this.printCharacters(cArray);
            if (cArray2 != null) {
                this.printSpaces(cArray2, true);
            }
            this.printCharacter('>');
        } else {
            this.printString("/>");
        }
        this.startingLines.remove(0);
        this.xmlSpace.remove(0);
    }

    public boolean printCharacterData(char[] cArray, boolean bl, boolean bl2) throws IOException {
        if (!this.prettyPrinter.getFormat()) {
            this.printCharacters(cArray);
            return false;
        }
        this.canIndent = true;
        if (this.isWhiteSpace(cArray)) {
            int n = this.newlines(cArray);
            for (int i = 0; i < n - 1; ++i) {
                this.printNewline();
            }
            return true;
        }
        if (this.xmlSpace.get(0) == Boolean.TRUE) {
            this.printCharacters(cArray);
            this.canIndent = false;
            return false;
        }
        if (bl) {
            this.printNewline();
            this.printString(this.margin.toString());
        }
        return this.formatText(cArray, this.margin.toString(), bl2);
    }

    public void printCDATASection(char[] cArray) throws IOException {
        this.printString("<![CDATA[");
        this.printCharacters(cArray);
        this.printString("]]>");
    }

    public void printNotation(char[] cArray, char[] cArray2, char[] cArray3, String string, char[] cArray4, char[] cArray5, char c, char[] cArray6, char[] cArray7, char c2, char[] cArray8) throws IOException {
        this.writer.write("<!NOTATION");
        this.printSpaces(cArray, false);
        this.writer.write(cArray2);
        this.printSpaces(cArray3, false);
        this.writer.write(string);
        this.printSpaces(cArray4, false);
        this.writer.write(c);
        this.writer.write(cArray5);
        this.writer.write(c);
        if (cArray6 != null) {
            this.printSpaces(cArray6, false);
            if (cArray7 != null) {
                this.writer.write(c2);
                this.writer.write(cArray7);
                this.writer.write(c2);
            }
        }
        if (cArray8 != null) {
            this.printSpaces(cArray8, true);
        }
        this.writer.write(62);
    }

    public void printAttlistStart(char[] cArray, char[] cArray2) throws IOException {
        this.writer.write("<!ATTLIST");
        this.printSpaces(cArray, false);
        this.writer.write(cArray2);
    }

    public void printAttlistEnd(char[] cArray) throws IOException {
        if (cArray != null) {
            this.printSpaces(cArray, false);
        }
        this.writer.write(62);
    }

    public void printAttName(char[] cArray, char[] cArray2, char[] cArray3) throws IOException {
        this.printSpaces(cArray, false);
        this.writer.write(cArray2);
        this.printSpaces(cArray3, false);
    }

    public void printEnumeration(List list) throws IOException {
        this.writer.write(40);
        Iterator iterator = list.iterator();
        NameInfo nameInfo = (NameInfo)iterator.next();
        if (nameInfo.space1 != null) {
            this.printSpaces(nameInfo.space1, true);
        }
        this.writer.write(nameInfo.name);
        if (nameInfo.space2 != null) {
            this.printSpaces(nameInfo.space2, true);
        }
        while (iterator.hasNext()) {
            this.writer.write(124);
            nameInfo = (NameInfo)iterator.next();
            if (nameInfo.space1 != null) {
                this.printSpaces(nameInfo.space1, true);
            }
            this.writer.write(nameInfo.name);
            if (nameInfo.space2 == null) continue;
            this.printSpaces(nameInfo.space2, true);
        }
        this.writer.write(41);
    }

    protected int newlines(char[] cArray) {
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\n') continue;
            ++n;
        }
        return n;
    }

    protected boolean isWhiteSpace(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (XMLUtilities.isXMLSpace(cArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean formatText(char[] cArray, String string, boolean bl) throws IOException {
        int n = 0;
        boolean bl2 = bl;
        block0: while (n < cArray.length) {
            while (n < cArray.length) {
                if (XMLUtilities.isXMLSpace(cArray[n])) {
                    bl2 = true;
                    ++n;
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer();
                while (n < cArray.length && !XMLUtilities.isXMLSpace(cArray[n])) {
                    stringBuffer.append(cArray[n++]);
                }
                if (stringBuffer.length() == 0) {
                    return bl2;
                }
                if (bl2) {
                    int n2 = this.column + stringBuffer.length();
                    if (n2 >= this.prettyPrinter.getDocumentWidth() - 1 && (string.length() + stringBuffer.length() < this.prettyPrinter.getDocumentWidth() - 1 || string.length() < this.column)) {
                        this.printNewline();
                        this.printString(string);
                    } else if (this.column > string.length()) {
                        this.printCharacter(' ');
                    }
                }
                this.printString(stringBuffer.toString());
                bl2 = false;
                continue block0;
            }
            break block0;
        }
        return bl2;
    }

    public static class AttributeInfo {
        public char[] space;
        public char[] name;
        public char[] space1;
        public char[] space2;
        public String value;
        public char delimiter;
        public boolean entityReferences;

        public AttributeInfo(char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, String string, char c, boolean bl) {
            this.space = cArray;
            this.name = cArray2;
            this.space1 = cArray3;
            this.space2 = cArray4;
            this.value = string;
            this.delimiter = c;
            this.entityReferences = bl;
        }

        public boolean isAttribute(String string) {
            if (this.name.length == string.length()) {
                for (int i = 0; i < this.name.length; ++i) {
                    if (this.name[i] == string.charAt(i)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class NameInfo {
        public char[] space1;
        public char[] name;
        public char[] space2;

        public NameInfo(char[] cArray, char[] cArray2, char[] cArray3) {
            this.space1 = cArray;
            this.name = cArray2;
            this.space2 = cArray3;
        }
    }
}

