# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
ShapeFix module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_shapefix.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ShapeFix
else:
    import _ShapeFix

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ShapeFix.delete_SwigPyIterator

    def value(self):
        return _ShapeFix.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _ShapeFix.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _ShapeFix.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _ShapeFix.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _ShapeFix.SwigPyIterator_equal(self, x)

    def copy(self):
        return _ShapeFix.SwigPyIterator_copy(self)

    def next(self):
        return _ShapeFix.SwigPyIterator_next(self)

    def __next__(self):
        return _ShapeFix.SwigPyIterator___next__(self)

    def previous(self):
        return _ShapeFix.SwigPyIterator_previous(self)

    def advance(self, n):
        return _ShapeFix.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _ShapeFix.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _ShapeFix.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _ShapeFix.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _ShapeFix.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _ShapeFix.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _ShapeFix.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _ShapeFix:
_ShapeFix.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _ShapeFix.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.ShapeBuild
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Geom2d
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.TopTools
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.ShapeExtend
import OCC.Core.TColGeom
import OCC.Core.ShapeAnalysis
import OCC.Core.Adaptor3d
import OCC.Core.Adaptor2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.IntRes2d
import OCC.Core.ShapeConstruct
import OCC.Core.BRepBuilderAPI

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_ShapeFix_Edge_Create():
    return _ShapeFix.Handle_ShapeFix_Edge_Create()

def Handle_ShapeFix_Edge_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_Edge_DownCast(t)

def Handle_ShapeFix_Edge_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_Edge_IsNull(t)

def Handle_ShapeFix_EdgeProjAux_Create():
    return _ShapeFix.Handle_ShapeFix_EdgeProjAux_Create()

def Handle_ShapeFix_EdgeProjAux_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_EdgeProjAux_DownCast(t)

def Handle_ShapeFix_EdgeProjAux_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_EdgeProjAux_IsNull(t)

def Handle_ShapeFix_Root_Create():
    return _ShapeFix.Handle_ShapeFix_Root_Create()

def Handle_ShapeFix_Root_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_Root_DownCast(t)

def Handle_ShapeFix_Root_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_Root_IsNull(t)

def Handle_ShapeFix_ComposeShell_Create():
    return _ShapeFix.Handle_ShapeFix_ComposeShell_Create()

def Handle_ShapeFix_ComposeShell_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_ComposeShell_DownCast(t)

def Handle_ShapeFix_ComposeShell_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_ComposeShell_IsNull(t)

def Handle_ShapeFix_Face_Create():
    return _ShapeFix.Handle_ShapeFix_Face_Create()

def Handle_ShapeFix_Face_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_Face_DownCast(t)

def Handle_ShapeFix_Face_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_Face_IsNull(t)

def Handle_ShapeFix_FixSmallFace_Create():
    return _ShapeFix.Handle_ShapeFix_FixSmallFace_Create()

def Handle_ShapeFix_FixSmallFace_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_FixSmallFace_DownCast(t)

def Handle_ShapeFix_FixSmallFace_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_FixSmallFace_IsNull(t)

def Handle_ShapeFix_FixSmallSolid_Create():
    return _ShapeFix.Handle_ShapeFix_FixSmallSolid_Create()

def Handle_ShapeFix_FixSmallSolid_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_FixSmallSolid_DownCast(t)

def Handle_ShapeFix_FixSmallSolid_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_FixSmallSolid_IsNull(t)

def Handle_ShapeFix_Shape_Create():
    return _ShapeFix.Handle_ShapeFix_Shape_Create()

def Handle_ShapeFix_Shape_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_Shape_DownCast(t)

def Handle_ShapeFix_Shape_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_Shape_IsNull(t)

def Handle_ShapeFix_Shell_Create():
    return _ShapeFix.Handle_ShapeFix_Shell_Create()

def Handle_ShapeFix_Shell_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_Shell_DownCast(t)

def Handle_ShapeFix_Shell_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_Shell_IsNull(t)

def Handle_ShapeFix_Solid_Create():
    return _ShapeFix.Handle_ShapeFix_Solid_Create()

def Handle_ShapeFix_Solid_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_Solid_DownCast(t)

def Handle_ShapeFix_Solid_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_Solid_IsNull(t)

def Handle_ShapeFix_SplitCommonVertex_Create():
    return _ShapeFix.Handle_ShapeFix_SplitCommonVertex_Create()

def Handle_ShapeFix_SplitCommonVertex_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_SplitCommonVertex_DownCast(t)

def Handle_ShapeFix_SplitCommonVertex_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_SplitCommonVertex_IsNull(t)

def Handle_ShapeFix_Wire_Create():
    return _ShapeFix.Handle_ShapeFix_Wire_Create()

def Handle_ShapeFix_Wire_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_Wire_DownCast(t)

def Handle_ShapeFix_Wire_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_Wire_IsNull(t)

def Handle_ShapeFix_Wireframe_Create():
    return _ShapeFix.Handle_ShapeFix_Wireframe_Create()

def Handle_ShapeFix_Wireframe_DownCast(t):
    return _ShapeFix.Handle_ShapeFix_Wireframe_DownCast(t)

def Handle_ShapeFix_Wireframe_IsNull(t):
    return _ShapeFix.Handle_ShapeFix_Wireframe_IsNull(t)
class ShapeFix_DataMapOfShapeBox2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_begin(self)

    def end(self):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_end(self)

    def cbegin(self):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_cbegin(self)

    def cend(self):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_cend(self)

    def __init__(self, *args):
        _ShapeFix.ShapeFix_DataMapOfShapeBox2d_swiginit(self, _ShapeFix.new_ShapeFix_DataMapOfShapeBox2d(*args))

    def Exchange(self, theOther):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_Exchange(self, theOther)

    def Assign(self, theOther):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_Assign(self, theOther)

    def Set(self, theOther):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_Set(self, theOther)

    def ReSize(self, N):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_ReSize(self, N)

    def Bind(self, theKey, theItem):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_Bind(self, theKey, theItem)

    def Bound(self, theKey, theItem):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_Bound(self, theKey, theItem)

    def IsBound(self, theKey):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_IsBound(self, theKey)

    def UnBind(self, theKey):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_UnBind(self, theKey)

    def Seek(self, theKey):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_Seek(self, theKey)

    def Find(self, *args):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_Find(self, *args)

    def ChangeSeek(self, theKey):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_ChangeFind(self, theKey)

    def __call__(self, *args):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d___call__(self, *args)

    def Clear(self, *args):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_Clear(self, *args)
    __swig_destroy__ = _ShapeFix.delete_ShapeFix_DataMapOfShapeBox2d

    def Size(self):
        return _ShapeFix.ShapeFix_DataMapOfShapeBox2d_Size(self)

# Register ShapeFix_DataMapOfShapeBox2d in _ShapeFix:
_ShapeFix.ShapeFix_DataMapOfShapeBox2d_swigregister(ShapeFix_DataMapOfShapeBox2d)
class ShapeFix_SequenceOfWireSegment(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_begin(self)

    def end(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_end(self)

    def cbegin(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_cbegin(self)

    def cend(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_cend(self)

    def __init__(self, *args):
        _ShapeFix.ShapeFix_SequenceOfWireSegment_swiginit(self, _ShapeFix.new_ShapeFix_SequenceOfWireSegment(*args))

    def Size(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Size(self)

    def Length(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Length(self)

    def Lower(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Lower(self)

    def Upper(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Upper(self)

    def IsEmpty(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_IsEmpty(self)

    def Reverse(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Reverse(self)

    def Exchange(self, I, J):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Exchange(self, I, J)

    @staticmethod
    def delNode(theNode, theAl):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_delNode(theNode, theAl)

    def Clear(self, theAllocator=0):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Clear(self, theAllocator)

    def Assign(self, theOther):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Assign(self, theOther)

    def Set(self, theOther):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Set(self, theOther)

    def Remove(self, *args):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Remove(self, *args)

    def Append(self, *args):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Append(self, *args)

    def Prepend(self, *args):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Prepend(self, *args)

    def InsertBefore(self, *args):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_InsertAfter(self, *args)

    def Split(self, theIndex, theSeq):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Split(self, theIndex, theSeq)

    def First(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_First(self)

    def ChangeFirst(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_ChangeFirst(self)

    def Last(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Last(self)

    def ChangeLast(self):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_ChangeLast(self)

    def Value(self, theIndex):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _ShapeFix.ShapeFix_SequenceOfWireSegment_SetValue(self, theIndex, theItem)
    __swig_destroy__ = _ShapeFix.delete_ShapeFix_SequenceOfWireSegment

    def __len__(self):
        return self.Size()


# Register ShapeFix_SequenceOfWireSegment in _ShapeFix:
_ShapeFix.ShapeFix_SequenceOfWireSegment_swigregister(ShapeFix_SequenceOfWireSegment)
class shapefix(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def EncodeRegularity(*args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        tolang: float (optional, default to 1.0e-10)

        Return
        -------
        None

        Description
        -----------
        Runs encoderegularity from breplib taking into account shared components of assemblies, so that each component is processed only once.

        """
        return _ShapeFix.shapefix_EncodeRegularity(*args)

    @staticmethod
    def FixVertexPosition(*args):
        r"""

        Parameters
        ----------
        theshape: TopoDS_Shape
        theTolerance: float
        thecontext: ShapeBuild_ReShape

        Return
        -------
        bool

        Description
        -----------
        Fix position of the vertices having tolerance more tnan specified one.;.

        """
        return _ShapeFix.shapefix_FixVertexPosition(*args)

    @staticmethod
    def LeastEdgeSize(*args):
        r"""

        Parameters
        ----------
        theshape: TopoDS_Shape

        Return
        -------
        float

        Description
        -----------
        Calculate size of least edge;.

        """
        return _ShapeFix.shapefix_LeastEdgeSize(*args)

    @staticmethod
    def RemoveSmallEdges(*args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        Tolerance: float
        context: ShapeBuild_ReShape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Removes edges which are less than given tolerance from shape with help of shapefix_wire::fixsmall().

        """
        return _ShapeFix.shapefix_RemoveSmallEdges(*args)

    @staticmethod
    def SameParameter(*args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        enforce: bool
        preci: float (optional, default to 0.0)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())
        theMsgReg: ShapeExtend_BasicMsgRegistrator (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Runs sameparameter from breplib with these adaptations: <enforce> forces computations, else they are made only on edges with flag sameparameter false <preci>, if not precised, is taken for each edge as its own tolerance returns true when done, false if an exception has been raised in case of exception anyway, as many edges as possible have been processed. the passed progress indicator allows user to consult the current progress stage and abort algorithm if needed.

        """
        return _ShapeFix.shapefix_SameParameter(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _ShapeFix.shapefix_swiginit(self, _ShapeFix.new_shapefix())
    __swig_destroy__ = _ShapeFix.delete_shapefix

# Register shapefix in _ShapeFix:
_ShapeFix.shapefix_swigregister(shapefix)
class ShapeFix_Edge(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeFix.ShapeFix_Edge_swiginit(self, _ShapeFix.new_ShapeFix_Edge(*args))

    def FixAddCurve3d(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        Tries to build 3d curve of the edge if missing use: it is to be called after fixremovecurve3d (if removed) or in any case when edge can have no 3d curve returns: true if 3d curve was added, else false status: ok: 3d curve exists fail1: breplib::buildcurve3d() has failed done1: 3d curve was added.

        """
        return _ShapeFix.ShapeFix_Edge_FixAddCurve3d(self, *args)

    def FixAddPCurve(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face
        isSeam: bool
        prec: float (optional, default to 0.0)

        Return
        -------
        bool

        Description
        -----------
        See method below for information.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location
        isSeam: bool
        prec: float (optional, default to 0.0)

        Return
        -------
        bool

        Description
        -----------
        See method below for information.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face
        isSeam: bool
        surfana: ShapeAnalysis_Surface
        prec: float (optional, default to 0.0)

        Return
        -------
        bool

        Description
        -----------
        See method below for information.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location
        isSeam: bool
        surfana: ShapeAnalysis_Surface
        prec: float (optional, default to 0.0)

        Return
        -------
        bool

        Description
        -----------
        Adds pcurve(s) of the edge if missing (by projecting 3d curve) parameter isseam indicates if the edge is a seam. the parameter <prec> defines the precision for calculations. if it is 0 (default), the tolerance of the edge is taken. remark: this method is rather for internal use since it accepts parameter <surfana> for optimization of computations use: it is to be called after fixremovepcurve (if removed) or in any case when edge can have no pcurve returns: true if pcurve was added, else false status: ok: pcurve exists fail1: no 3d curve fail2: fail during projecting done1: pcurve was added done2: specific case of pcurve going through degenerated point on sphere encountered during projection (see class shapeconstruct_projectcurveonsurface for more info).

        """
        return _ShapeFix.ShapeFix_Edge_FixAddPCurve(self, *args)

    def FixRemoveCurve3d(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        Removes 3d curve of the edge if it does not match the vertices returns: true, if does not match, removed (status done) false, (status ok) if matches or (status fail) if no 3d curve, nothing done.

        """
        return _ShapeFix.ShapeFix_Edge_FixRemoveCurve3d(self, *args)

    def FixRemovePCurve(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location

        Return
        -------
        bool

        Description
        -----------
        Removes the pcurve(s) of the edge if it does not match the vertices check is done use: it is to be called when pcurve of an edge can be wrong (e.g., after import from iges) returns: true, if does not match, removed (status done) false, (status ok) if matches or (status fail) if no pcurve, nothing done.

        """
        return _ShapeFix.ShapeFix_Edge_FixRemovePCurve(self, *args)

    def FixReversed2d(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge
        surface: Geom_Surface
        location: TopLoc_Location

        Return
        -------
        bool

        Description
        -----------
        Fixes edge if pcurve is directed opposite to 3d curve check is done by call to the function shapeanalysis_edge::checkcurve3dwithpcurve() warning: for seam edge this method will check and fix the pcurve in only one direction. hence, it should be called twice for seam edge: once with edge orientation forward and once with reversed. returns: false if nothing done, true if reversed (status done) status: ok - pcurve ok, nothing done fail1 - no pcurve fail2 - no 3d curve done1 - pcurve was reversed.

        """
        return _ShapeFix.ShapeFix_Edge_FixReversed2d(self, *args)

    def FixSameParameter(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge
        tolerance: float (optional, default to 0.0)

        Return
        -------
        bool

        Description
        -----------
        Tries to make edge sameparameter and sets corresponding tolerance and sameparameter flag. first, it makes edge same range if samerange flag is not set. //! if flag sameparameter is set, this method calls the function shapeanalysis_edge::checksameparameter() that calculates the maximal deviation of pcurves of the edge from its 3d curve. if deviation > tolerance, the tolerance of edge is increased to a value of deviation. if deviation < tolerance nothing happens. //! if flag sameparameter is not set, this method chooses the best variant (one that has minimal tolerance), either a. only after computing deviation (as above) or b. after calling standard procedure breplib::sameparameter and computing deviation (as above). if <tolerance> > 0, it is used as parameter for breplib::sameparameter, otherwise, tolerance of the edge is used. //! use: is to be called after all pcurves and 3d curve of the edge are correctly computed remark: sameparameter flag is always set to true after this method returns: true, if something done, else false status: ok - edge was initially sameparameter, nothing is done fail1 - computation of deviation of pcurves from 3d curve has failed fail2 - breplib::sameparameter() has failed done1 - tolerance of the edge was increased done2 - flag sameparameter was set to true (only if breplib::sameparameter() did not set it) done3 - edge was modified by breplib::sameparameter() to sameparameter done4 - not used anymore done5 - if the edge resulting from breplib has been chosen, i.e. variant b. above (only for edges with not set sameparameter).

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face
        tolerance: float (optional, default to 0.0)

        Return
        -------
        bool

        Description
        -----------
        Tries to make edge sameparameter and sets corresponding tolerance and sameparameter flag. first, it makes edge same range if samerange flag is not set. //! if flag sameparameter is set, this method calls the function shapeanalysis_edge::checksameparameter() that calculates the maximal deviation of pcurves of the edge from its 3d curve. if deviation > tolerance, the tolerance of edge is increased to a value of deviation. if deviation < tolerance nothing happens. //! if flag sameparameter is not set, this method chooses the best variant (one that has minimal tolerance), either a. only after computing deviation (as above) or b. after calling standard procedure breplib::sameparameter and computing deviation (as above). if <tolerance> > 0, it is used as parameter for breplib::sameparameter, otherwise, tolerance of the edge is used. //! use: is to be called after all pcurves and 3d curve of the edge are correctly computed remark: sameparameter flag is always set to true after this method returns: true, if something done, else false status: ok - edge was initially sameparameter, nothing is done fail1 - computation of deviation of pcurves from 3d curve has failed fail2 - breplib::sameparameter() has failed done1 - tolerance of the edge was increased done2 - flag sameparameter was set to true (only if breplib::sameparameter() did not set it) done3 - edge was modified by breplib::sameparameter() to sameparameter done4 - not used anymore done5 - if the edge resulting from breplib has been chosen, i.e. variant b. above (only for edges with not set sameparameter).

        """
        return _ShapeFix.ShapeFix_Edge_FixSameParameter(self, *args)

    def FixVertexTolerance(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        edge: TopoDS_Edge

        Return
        -------
        bool

        Description
        -----------
        Increases the tolerances of the edge vertices to comprise the ends of 3d curve and pcurve on the given face (first method) or all pcurves stored in an edge (second one) returns: true, if tolerances have been increased, otherwise false status: ok: the original tolerances have not been changed done1: the tolerance of first vertex has been increased done2: the tolerance of last vertex has been increased.

        """
        return _ShapeFix.ShapeFix_Edge_FixVertexTolerance(self, *args)

    def Projector(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeConstruct_ProjectCurveOnSurface>

        Description
        -----------
        Returns the projector used for recomputing missing pcurves can be used for adjusting parameters of projector.

        """
        return _ShapeFix.ShapeFix_Edge_Projector(self, *args)

    def SetContext(self, *args):
        r"""

        Parameters
        ----------
        context: ShapeBuild_ReShape

        Return
        -------
        None

        Description
        -----------
        Sets context.

        """
        return _ShapeFix.ShapeFix_Edge_SetContext(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Returns the status (in the form of true/false) of last fix.

        """
        return _ShapeFix.ShapeFix_Edge_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_Edge_DownCast(t)


    __repr__ = _dumps_object

    @methodnotwrapped
    def Context(self):
    	pass

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_Edge

# Register ShapeFix_Edge in _ShapeFix:
_ShapeFix.ShapeFix_Edge_swigregister(ShapeFix_Edge)
class ShapeFix_EdgeConnect(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeFix.ShapeFix_EdgeConnect_swiginit(self, _ShapeFix.new_ShapeFix_EdgeConnect(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        aFirst: TopoDS_Edge
        aSecond: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        Adds information on connectivity between start vertex of second edge and end vertex of first edge, taking edges orientation into account.

        Parameters
        ----------
        aShape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Adds connectivity information for the whole shape. note: edges in wires must be well ordered note: flag closed should be set for closed wires.

        """
        return _ShapeFix.ShapeFix_EdgeConnect_Add(self, *args)

    def Build(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Builds shared vertices, updates their positions and tolerances.

        """
        return _ShapeFix.ShapeFix_EdgeConnect_Build(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears internal data structure.

        """
        return _ShapeFix.ShapeFix_EdgeConnect_Clear(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_EdgeConnect

# Register ShapeFix_EdgeConnect in _ShapeFix:
_ShapeFix.ShapeFix_EdgeConnect_swigregister(ShapeFix_EdgeConnect)
class ShapeFix_EdgeProjAux(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        F: TopoDS_Face
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeFix.ShapeFix_EdgeProjAux_swiginit(self, _ShapeFix.new_ShapeFix_EdgeProjAux(*args))

    def Compute(self, *args):
        r"""

        Parameters
        ----------
        preci: float

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_EdgeProjAux_Compute(self, *args)

    def FirstParam(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_EdgeProjAux_FirstParam(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        E: TopoDS_Edge

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_EdgeProjAux_Init(self, *args)

    def IsFirstDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_EdgeProjAux_IsFirstDone(self, *args)

    def IsIso(self, *args):
        r"""

        Parameters
        ----------
        C: Geom2d_Curve

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_EdgeProjAux_IsIso(self, *args)

    def IsLastDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_EdgeProjAux_IsLastDone(self, *args)

    def LastParam(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_EdgeProjAux_LastParam(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_EdgeProjAux_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_EdgeProjAux

# Register ShapeFix_EdgeProjAux in _ShapeFix:
_ShapeFix.ShapeFix_EdgeProjAux_swigregister(ShapeFix_EdgeProjAux)
class ShapeFix_FaceConnect(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeFix.ShapeFix_FaceConnect_swiginit(self, _ShapeFix.new_ShapeFix_FaceConnect(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        aFirst: TopoDS_Face
        aSecond: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_FaceConnect_Add(self, *args)

    def Build(self, *args):
        r"""

        Parameters
        ----------
        shell: TopoDS_Shell
        sewtoler: float
        fixtoler: float

        Return
        -------
        TopoDS_Shell

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_FaceConnect_Build(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears internal data structure.

        """
        return _ShapeFix.ShapeFix_FaceConnect_Clear(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_FaceConnect

# Register ShapeFix_FaceConnect in _ShapeFix:
_ShapeFix.ShapeFix_FaceConnect_swigregister(ShapeFix_FaceConnect)
class ShapeFix_FreeBounds(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        shape: TopoDS_Shape
        sewtoler: float
        closetoler: float
        splitclosed: bool
        splitopen: bool

        Return
        -------
        None

        Description
        -----------
        Builds forecasting free bounds of the <shape> and connects open wires with tolerance <closetoler>. <shape> should be a compound of faces. tolerance <closetoler> should be greater than tolerance <sewtoler> used for initializing sewing analyzer, otherwise connection of open wires is not performed.

        Parameters
        ----------
        shape: TopoDS_Shape
        closetoler: float
        splitclosed: bool
        splitopen: bool

        Return
        -------
        None

        Description
        -----------
        Builds actual free bounds of the <shape> and connects open wires with tolerance <closetoler>. <shape> should be a compound of shells.

        """
        _ShapeFix.ShapeFix_FreeBounds_swiginit(self, _ShapeFix.new_ShapeFix_FreeBounds(*args))

    def GetClosedWires(self, *args):
        r"""
        Return
        -------
        TopoDS_Compound

        Description
        -----------
        Returns compound of closed wires out of free edges.

        """
        return _ShapeFix.ShapeFix_FreeBounds_GetClosedWires(self, *args)

    def GetOpenWires(self, *args):
        r"""
        Return
        -------
        TopoDS_Compound

        Description
        -----------
        Returns compound of open wires out of free edges.

        """
        return _ShapeFix.ShapeFix_FreeBounds_GetOpenWires(self, *args)

    def GetShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns modified source shape.

        """
        return _ShapeFix.ShapeFix_FreeBounds_GetShape(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_FreeBounds

# Register ShapeFix_FreeBounds in _ShapeFix:
_ShapeFix.ShapeFix_FreeBounds_swigregister(ShapeFix_FreeBounds)
class ShapeFix_IntersectionTool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        context: ShapeBuild_ReShape
        preci: float
        maxtol: float (optional, default to 1.0)

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _ShapeFix.ShapeFix_IntersectionTool_swiginit(self, _ShapeFix.new_ShapeFix_IntersectionTool(*args))

    def Context(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeBuild_ReShape>

        Description
        -----------
        Returns context.

        """
        return _ShapeFix.ShapeFix_IntersectionTool_Context(self, *args)

    def CutEdge(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge
        pend: float
        cut: float
        face: TopoDS_Face

        Return
        -------
        iscutline: bool

        Description
        -----------
        Cut edge by parameters pend and cut.

        """
        return _ShapeFix.ShapeFix_IntersectionTool_CutEdge(self, *args)

    def FixIntersectingWires(self, *args):
        r"""

        Parameters
        ----------
        face: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_IntersectionTool_FixIntersectingWires(self, *args)

    def FixSelfIntersectWire(self, *args):
        r"""

        Parameters
        ----------
        sewd: ShapeExtend_WireData
        face: TopoDS_Face

        Return
        -------
        NbSplit: int
        NbCut: int
        NbRemoved: int

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_IntersectionTool_FixSelfIntersectWire(self, *args)

    def SplitEdge(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge
        param: float
        vert: TopoDS_Vertex
        face: TopoDS_Face
        newE1: TopoDS_Edge
        newE2: TopoDS_Edge
        preci: float

        Return
        -------
        bool

        Description
        -----------
        Split edge on two new edges using new vertex 'vert' and 'param' - parameter for splitting the 'face' is necessary for pcurves and using transferparameterproj.

        """
        return _ShapeFix.ShapeFix_IntersectionTool_SplitEdge(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_IntersectionTool

# Register ShapeFix_IntersectionTool in _ShapeFix:
_ShapeFix.ShapeFix_IntersectionTool_swigregister(ShapeFix_IntersectionTool)
class ShapeFix_Root(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor (no context is created).

        """
        _ShapeFix.ShapeFix_Root_swiginit(self, _ShapeFix.new_ShapeFix_Root(*args))

    def Context(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeBuild_ReShape>

        Description
        -----------
        Returns context.

        """
        return _ShapeFix.ShapeFix_Root_Context(self, *args)

    def LimitTolerance(self, *args):
        r"""

        Parameters
        ----------
        toler: float

        Return
        -------
        float

        Description
        -----------
        Returns tolerance limited by [mymintol,mymaxtol].

        """
        return _ShapeFix.ShapeFix_Root_LimitTolerance(self, *args)

    def MaxTolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns maximal allowed tolerance.

        """
        return _ShapeFix.ShapeFix_Root_MaxTolerance(self, *args)

    def MinTolerance(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns minimal allowed tolerance.

        """
        return _ShapeFix.ShapeFix_Root_MinTolerance(self, *args)

    def MsgRegistrator(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeExtend_BasicMsgRegistrator>

        Description
        -----------
        Returns message registrator.

        """
        return _ShapeFix.ShapeFix_Root_MsgRegistrator(self, *args)

    def Precision(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns basic precision value.

        """
        return _ShapeFix.ShapeFix_Root_Precision(self, *args)

    def SendFail(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        message: Message_Msg

        Return
        -------
        None

        Description
        -----------
        Sends a fail to be attached to the shape. calls sendmsg with gravity set to message_fail.

        Parameters
        ----------
        message: Message_Msg

        Return
        -------
        None

        Description
        -----------
        Calls previous method for myshape.

        """
        return _ShapeFix.ShapeFix_Root_SendFail(self, *args)

    def SendMsg(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        message: Message_Msg
        gravity: Message_Gravity (optional, default to Message_Info)

        Return
        -------
        None

        Description
        -----------
        Sends a message to be attached to the shape. calls corresponding message of message registrator.

        Parameters
        ----------
        message: Message_Msg
        gravity: Message_Gravity (optional, default to Message_Info)

        Return
        -------
        None

        Description
        -----------
        Sends a message to be attached to myshape. calls previous method.

        """
        return _ShapeFix.ShapeFix_Root_SendMsg(self, *args)

    def SendWarning(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        message: Message_Msg

        Return
        -------
        None

        Description
        -----------
        Sends a warning to be attached to the shape. calls sendmsg with gravity set to message_warning.

        Parameters
        ----------
        message: Message_Msg

        Return
        -------
        None

        Description
        -----------
        Calls previous method for myshape.

        """
        return _ShapeFix.ShapeFix_Root_SendWarning(self, *args)

    def Set(self, *args):
        r"""

        Parameters
        ----------
        Root: ShapeFix_Root

        Return
        -------
        None

        Description
        -----------
        Copy all fields from another root object.

        """
        return _ShapeFix.ShapeFix_Root_Set(self, *args)

    def SetContext(self, *args):
        r"""

        Parameters
        ----------
        context: ShapeBuild_ReShape

        Return
        -------
        None

        Description
        -----------
        Sets context.

        """
        return _ShapeFix.ShapeFix_Root_SetContext(self, *args)

    def SetMaxTolerance(self, *args):
        r"""

        Parameters
        ----------
        maxtol: float

        Return
        -------
        None

        Description
        -----------
        Sets maximal allowed tolerance.

        """
        return _ShapeFix.ShapeFix_Root_SetMaxTolerance(self, *args)

    def SetMinTolerance(self, *args):
        r"""

        Parameters
        ----------
        mintol: float

        Return
        -------
        None

        Description
        -----------
        Sets minimal allowed tolerance.

        """
        return _ShapeFix.ShapeFix_Root_SetMinTolerance(self, *args)

    def SetMsgRegistrator(self, *args):
        r"""

        Parameters
        ----------
        msgreg: ShapeExtend_BasicMsgRegistrator

        Return
        -------
        None

        Description
        -----------
        Sets message registrator.

        """
        return _ShapeFix.ShapeFix_Root_SetMsgRegistrator(self, *args)

    def SetPrecision(self, *args):
        r"""

        Parameters
        ----------
        preci: float

        Return
        -------
        None

        Description
        -----------
        Sets basic precision value.

        """
        return _ShapeFix.ShapeFix_Root_SetPrecision(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_Root_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_Root

# Register ShapeFix_Root in _ShapeFix:
_ShapeFix.ShapeFix_Root_swigregister(ShapeFix_Root)
class ShapeFix_ShapeTolerance(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeFix.ShapeFix_ShapeTolerance_swiginit(self, _ShapeFix.new_ShapeFix_ShapeTolerance(*args))

    def LimitTolerance(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        tmin: float
        tmax: float (optional, default to 0.0)
        styp: TopAbs_ShapeEnum (optional, default to TopAbs_SHAPE)

        Return
        -------
        bool

        Description
        -----------
        Limits tolerances in a shape as follows: tmin = tmax -> as settolerance (forces) tmin = 0 -> maximum tolerance will be <tmax> tmax = 0 or not given (more generally, tmax < tmin) -> <tmax> ignored, minimum will be <tmin> else, maximum will be <max> and minimum will be <min> styp = vertex: only vertices are set styp = edge: only edges are set styp = face: only faces are set styp = wire: to have edges and their vertices set styp = other value: all (vertices,edges,faces) are set returns true if at least one tolerance of the sub-shape has been modified.

        """
        return _ShapeFix.ShapeFix_ShapeTolerance_LimitTolerance(self, *args)

    def SetTolerance(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        preci: float
        styp: TopAbs_ShapeEnum (optional, default to TopAbs_SHAPE)

        Return
        -------
        None

        Description
        -----------
        Sets (enforces) tolerances in a shape to the given value styp = vertex: only vertices are set styp = edge: only edges are set styp = face: only faces are set styp = wire: to have edges and their vertices set styp = other value: all (vertices,edges,faces) are set.

        """
        return _ShapeFix.ShapeFix_ShapeTolerance_SetTolerance(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_ShapeTolerance

# Register ShapeFix_ShapeTolerance in _ShapeFix:
_ShapeFix.ShapeFix_ShapeTolerance_swigregister(ShapeFix_ShapeTolerance)
class ShapeFix_SplitTool(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _ShapeFix.ShapeFix_SplitTool_swiginit(self, _ShapeFix.new_ShapeFix_SplitTool(*args))

    def CutEdge(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge
        pend: float
        cut: float
        face: TopoDS_Face

        Return
        -------
        iscutline: bool

        Description
        -----------
        Cut edge by parameters pend and cut.

        """
        return _ShapeFix.ShapeFix_SplitTool_CutEdge(self, *args)

    def SplitEdge(self, *args):
        r"""

        Parameters
        ----------
        edge: TopoDS_Edge
        param: float
        vert: TopoDS_Vertex
        face: TopoDS_Face
        newE1: TopoDS_Edge
        newE2: TopoDS_Edge
        tol3d: float
        tol2d: float

        Return
        -------
        bool

        Description
        -----------
        Split edge on two new edges using new vertex 'vert' and 'param' - parameter for splitting the 'face' is necessary for pcurves and using transferparameterproj.

        Parameters
        ----------
        edge: TopoDS_Edge
        param1: float
        param2: float
        vert: TopoDS_Vertex
        face: TopoDS_Face
        newE1: TopoDS_Edge
        newE2: TopoDS_Edge
        tol3d: float
        tol2d: float

        Return
        -------
        bool

        Description
        -----------
        Split edge on two new edges using new vertex 'vert' and 'param1' and 'param2' - parameter for splitting and cutting the 'face' is necessary for pcurves and using transferparameterproj.

        Parameters
        ----------
        edge: TopoDS_Edge
        fp: float
        V1: TopoDS_Vertex
        lp: float
        V2: TopoDS_Vertex
        face: TopoDS_Face
        SeqE: TopTools_SequenceOfShape
        context: ShapeBuild_ReShape
        tol3d: float
        tol2d: float

        Return
        -------
        aNum: int

        Description
        -----------
        Split edge on two new edges using two new vertex v1 and v2 and two parameters for splitting - fp and lp correspondingly the 'face' is necessary for pcurves and using transferparameterproj anum - number of edge in seqe which corresponding to [fp,lp].

        """
        return _ShapeFix.ShapeFix_SplitTool_SplitEdge(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_SplitTool

# Register ShapeFix_SplitTool in _ShapeFix:
_ShapeFix.ShapeFix_SplitTool_swigregister(ShapeFix_SplitTool)
class ShapeFix_WireVertex(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeFix.ShapeFix_WireVertex_swiginit(self, _ShapeFix.new_ShapeFix_WireVertex(*args))

    def Analyzer(self, *args):
        r"""
        Return
        -------
        ShapeAnalysis_WireVertex

        Description
        -----------
        Returns internal analyzer.

        """
        return _ShapeFix.ShapeFix_WireVertex_Analyzer(self, *args)

    def Fix(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Fixes all statuses except 'disjoined', i.e. the cases in which a common value has been set, with or without changing parameters returns the count of fixed vertices, 0 if none.

        """
        return _ShapeFix.ShapeFix_WireVertex_Fix(self, *args)

    def FixSame(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Fixes 'same' or 'close' status (same vertex may be set, without changing parameters) returns the count of fixed vertices, 0 if none.

        """
        return _ShapeFix.ShapeFix_WireVertex_FixSame(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        wire: TopoDS_Wire
        preci: float

        Return
        -------
        None

        Description
        -----------
        Loads the wire, ininializes internal analyzer (shapeanalysis_wirevertex) with the given precision, and performs analysis.

        Parameters
        ----------
        sbwd: ShapeExtend_WireData
        preci: float

        Return
        -------
        None

        Description
        -----------
        Loads the wire, ininializes internal analyzer (shapeanalysis_wirevertex) with the given precision, and performs analysis.

        Parameters
        ----------
        sawv: ShapeAnalysis_WireVertex

        Return
        -------
        None

        Description
        -----------
        Loads all the data on wire, already analysed by shapeanalysis_wirevertex.

        """
        return _ShapeFix.ShapeFix_WireVertex_Init(self, *args)

    def Wire(self, *args):
        r"""
        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Returns resulting wire (fixed).

        """
        return _ShapeFix.ShapeFix_WireVertex_Wire(self, *args)

    def WireData(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeExtend_WireData>

        Description
        -----------
        Returns data on wire (fixed).

        """
        return _ShapeFix.ShapeFix_WireVertex_WireData(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_WireVertex

# Register ShapeFix_WireVertex in _ShapeFix:
_ShapeFix.ShapeFix_WireVertex_swigregister(ShapeFix_WireVertex)
class ShapeFix_ComposeShell(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates empty tool.

        """
        _ShapeFix.ShapeFix_ComposeShell_swiginit(self, _ShapeFix.new_ShapeFix_ComposeShell(*args))

    def GetClosedMode(self):
        r"""GetClosedMode(ShapeFix_ComposeShell self) -> Standard_Boolean"""
        return _ShapeFix.ShapeFix_ComposeShell_GetClosedMode(self)

    def SetClosedMode(self, value):
        r"""SetClosedMode(ShapeFix_ComposeShell self, Standard_Boolean value)"""
        return _ShapeFix.ShapeFix_ComposeShell_SetClosedMode(self, value)

    def DispatchWires(self, *args):
        r"""

        Parameters
        ----------
        faces: TopTools_SequenceOfShape
        wires: ShapeFix_SequenceOfWireSegment

        Return
        -------
        None

        Description
        -----------
        Creates new faces from the set of (closed) wires. each wire is put on corresponding patch in the composite surface, and all pcurves on the initial (pseudo)face are reassigned to that surface. if several wires are one inside another, single face is created.

        """
        return _ShapeFix.ShapeFix_ComposeShell_DispatchWires(self, *args)

    def GetTransferParamTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeAnalysis_TransferParameters>

        Description
        -----------
        Gets tool for transfer parameters from 3d to 2d and vice versa.

        """
        return _ShapeFix.ShapeFix_ComposeShell_GetTransferParamTool(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        Grid: ShapeExtend_CompositeSurface
        L: TopLoc_Location
        Face: TopoDS_Face
        Prec: float

        Return
        -------
        None

        Description
        -----------
        Initializes with composite surface, face and precision. here face defines both set of wires and way of getting pcurves. precision is used (together with tolerance of edges) for handling subtle cases, such as tangential intersections.

        """
        return _ShapeFix.ShapeFix_ComposeShell_Init(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Performs the work on already loaded data.

        """
        return _ShapeFix.ShapeFix_ComposeShell_Perform(self, *args)

    def Result(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns resulting shell or face (or null shape if not done).

        """
        return _ShapeFix.ShapeFix_ComposeShell_Result(self, *args)

    def SetTransferParamTool(self, *args):
        r"""

        Parameters
        ----------
        TransferParam: ShapeAnalysis_TransferParameters

        Return
        -------
        None

        Description
        -----------
        Sets tool for transfer parameters from 3d to 2d and vice versa.

        """
        return _ShapeFix.ShapeFix_ComposeShell_SetTransferParamTool(self, *args)

    def SplitEdges(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Splits edges in the original shape by grid. this is a part of perform() which does not produce any resulting shape; the only result is filled context where splittings are recorded. //! note: if edge is split, it is replaced by wire, and order of edges in the wire corresponds to forward orientation of the edge.

        """
        return _ShapeFix.ShapeFix_ComposeShell_SplitEdges(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Queries status of last call to perform() ok: nothing done (some kind of error) done1: splitting is done, at least one new face created done2: splitting is done, several new faces obtained fail1: misoriented wire encountered (handled) fail2: recoverable parity error fail3: edge with no pcurve on supporting face fail4: unrecoverable algorithm error (parity check).

        """
        return _ShapeFix.ShapeFix_ComposeShell_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_ComposeShell_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_ComposeShell

# Register ShapeFix_ComposeShell in _ShapeFix:
_ShapeFix.ShapeFix_ComposeShell_swigregister(ShapeFix_ComposeShell)
class ShapeFix_Face(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty tool.

        Parameters
        ----------
        face: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Creates a tool and loads a face.

        """
        _ShapeFix.ShapeFix_Face_swiginit(self, _ShapeFix.new_ShapeFix_Face(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        wire: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Add a wire to current face using brep_builder. wire is added without taking into account orientation of face (as if face were forward).

        """
        return _ShapeFix.ShapeFix_Face_Add(self, *args)

    def GetAutoCorrectPrecisionMode(self):
        r"""GetAutoCorrectPrecisionMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetAutoCorrectPrecisionMode(self)

    def SetAutoCorrectPrecisionMode(self, value):
        r"""SetAutoCorrectPrecisionMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetAutoCorrectPrecisionMode(self, value)

    def ClearModes(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets all modes to default.

        """
        return _ShapeFix.ShapeFix_Face_ClearModes(self, *args)

    def Face(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        Returns a face which corresponds to the current state warning: the finally produced face may be another one ... but with the same support.

        """
        return _ShapeFix.ShapeFix_Face_Face(self, *args)

    def FixAddNaturalBound(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Adds natural boundary on face if it is missing. two cases are supported: - face has no wires - face lies on geometrically double-closed surface (sphere or torus) and none of wires is left-oriented returns true if natural boundary was added.

        """
        return _ShapeFix.ShapeFix_Face_FixAddNaturalBound(self, *args)

    def GetFixAddNaturalBoundMode(self):
        r"""GetFixAddNaturalBoundMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetFixAddNaturalBoundMode(self)

    def SetFixAddNaturalBoundMode(self, value):
        r"""SetFixAddNaturalBoundMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetFixAddNaturalBoundMode(self, value)

    def FixIntersectingWires(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Detects and fixes the special case when face has more than one wire and this wires have intersection point.

        """
        return _ShapeFix.ShapeFix_Face_FixIntersectingWires(self, *args)

    def GetFixIntersectingWiresMode(self):
        r"""GetFixIntersectingWiresMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetFixIntersectingWiresMode(self)

    def SetFixIntersectingWiresMode(self, value):
        r"""SetFixIntersectingWiresMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetFixIntersectingWiresMode(self, value)

    def FixLoopWire(self, *args):
        r"""

        Parameters
        ----------
        aResWires: TopTools_SequenceOfShape

        Return
        -------
        bool

        Description
        -----------
        Detects if wire has a loop and fixes this situation by splitting on the few parts. if wire has a loops and it was split status was set to value shapeextend_done6.

        """
        return _ShapeFix.ShapeFix_Face_FixLoopWire(self, *args)

    def GetFixLoopWiresMode(self):
        r"""GetFixLoopWiresMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetFixLoopWiresMode(self)

    def SetFixLoopWiresMode(self, value):
        r"""SetFixLoopWiresMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetFixLoopWiresMode(self, value)

    def FixMissingSeam(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Detects and fixes the special case when face on a closed surface is given by two wires closed in 3d but with gap in 2d. in that case it creates a new wire from the two, and adds a missing seam edge returns true if missing seam was added.

        """
        return _ShapeFix.ShapeFix_Face_FixMissingSeam(self, *args)

    def GetFixMissingSeamMode(self):
        r"""GetFixMissingSeamMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetFixMissingSeamMode(self)

    def SetFixMissingSeamMode(self, value):
        r"""SetFixMissingSeamMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetFixMissingSeamMode(self, value)

    def FixOrientation(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Fixes orientation of wires on the face it tries to make all wires lie outside all others (according to orientation) by reversing orientation of some of them. if face lying on sphere or torus has single wire and addnaturalboundmode is true, that wire is not reversed in any case (supposing that natural bound will be added). returns true if wires were reversed.

        Parameters
        ----------
        MapWires: TopTools_DataMapOfShapeListOfShape

        Return
        -------
        bool

        Description
        -----------
        Fixes orientation of wires on the face it tries to make all wires lie outside all others (according to orientation) by reversing orientation of some of them. if face lying on sphere or torus has single wire and addnaturalboundmode is true, that wire is not reversed in any case (supposing that natural bound will be added). returns true if wires were reversed outwires return information about out wires + list of internal wires for each (for performing split face).

        """
        return _ShapeFix.ShapeFix_Face_FixOrientation(self, *args)

    def GetFixOrientationMode(self):
        r"""GetFixOrientationMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetFixOrientationMode(self)

    def SetFixOrientationMode(self, value):
        r"""SetFixOrientationMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetFixOrientationMode(self, value)

    def FixPeriodicDegenerated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Fixes topology for a specific case when face is composed by a single wire belting a periodic surface. in that case a degenerated edge is reconstructed in the degenerated pole of the surface. initial wire gets consistent orientation. must be used in couple and before fixmissingseam routine.

        """
        return _ShapeFix.ShapeFix_Face_FixPeriodicDegenerated(self, *args)

    def GetFixPeriodicDegeneratedMode(self):
        r"""GetFixPeriodicDegeneratedMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetFixPeriodicDegeneratedMode(self)

    def SetFixPeriodicDegeneratedMode(self, value):
        r"""SetFixPeriodicDegeneratedMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetFixPeriodicDegeneratedMode(self, value)

    def FixSmallAreaWire(self, *args):
        r"""

        Parameters
        ----------
        theIsRemoveSmallFace: bool

        Return
        -------
        bool

        Description
        -----------
        Detects wires with small area (that is less than 100*precision::pconfusion(). removes these wires if they are internal. returns: true if at least one small wire removed, false if does nothing.

        """
        return _ShapeFix.ShapeFix_Face_FixSmallAreaWire(self, *args)

    def GetFixSmallAreaWireMode(self):
        r"""GetFixSmallAreaWireMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetFixSmallAreaWireMode(self)

    def SetFixSmallAreaWireMode(self, value):
        r"""SetFixSmallAreaWireMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetFixSmallAreaWireMode(self, value)

    def FixSplitFace(self, *args):
        r"""

        Parameters
        ----------
        MapWires: TopTools_DataMapOfShapeListOfShape

        Return
        -------
        bool

        Description
        -----------
        Split face if there are more than one out wire using inrormation after fixorientation().

        """
        return _ShapeFix.ShapeFix_Face_FixSplitFace(self, *args)

    def GetFixSplitFaceMode(self):
        r"""GetFixSplitFaceMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetFixSplitFaceMode(self)

    def SetFixSplitFaceMode(self, value):
        r"""SetFixSplitFaceMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetFixSplitFaceMode(self, value)

    def GetFixWireMode(self):
        r"""GetFixWireMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetFixWireMode(self)

    def SetFixWireMode(self, value):
        r"""SetFixWireMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetFixWireMode(self, value)

    def FixWireTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeFix_Wire>

        Description
        -----------
        Returns tool for fixing wires.

        """
        return _ShapeFix.ShapeFix_Face_FixWireTool(self, *args)

    def FixWiresTwoCoincEdges(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        If wire contains two coincidence edges it must be removed queries on status after perform().

        """
        return _ShapeFix.ShapeFix_Face_FixWiresTwoCoincEdges(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        face: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Loads a whole face already created, with its wires, sense and location.

        Parameters
        ----------
        surf: Geom_Surface
        preci: float
        fwd: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Starts the creation of the face by default it will be forward, or reversed if <fwd> is false.

        Parameters
        ----------
        surf: ShapeAnalysis_Surface
        preci: float
        fwd: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Starts the creation of the face by default it will be forward, or reversed if <fwd> is false.

        """
        return _ShapeFix.ShapeFix_Face_Init(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Performs all the fixes, depending on modes function status returns the status of last call to perform() shapeextend_ok: face was ok, nothing done shapeextend_done1: some wires are fixed shapeextend_done2: orientation of wires fixed shapeextend_done3: missing seam added shapeextend_done4: small area wire removed shapeextend_done5: natural bounds added shapeextend_fail1: some fails during fixing wires shapeextend_fail2: cannot fix orientation of wires shapeextend_fail3: cannot add missing seam shapeextend_fail4: cannot remove small area wire.

        """
        return _ShapeFix.ShapeFix_Face_Perform(self, *args)

    def GetRemoveSmallAreaFaceMode(self):
        r"""GetRemoveSmallAreaFaceMode(ShapeFix_Face self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Face_GetRemoveSmallAreaFaceMode(self)

    def SetRemoveSmallAreaFaceMode(self, value):
        r"""SetRemoveSmallAreaFaceMode(ShapeFix_Face self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Face_SetRemoveSmallAreaFaceMode(self, value)

    def Result(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns resulting shape (face or shell if split) to be used instead of face() if fixmissingseam involved.

        """
        return _ShapeFix.ShapeFix_Face_Result(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Returns the status of last call to perform() shapeextend_ok: face was ok, nothing done shapeextend_done1: some wires are fixed shapeextend_done2: orientation of wires fixed shapeextend_done3: missing seam added shapeextend_done4: small area wire removed shapeextend_done5: natural bounds added shapeextend_done8: face may be splited shapeextend_fail1: some fails during fixing wires shapeextend_fail2: cannot fix orientation of wires shapeextend_fail3: cannot add missing seam shapeextend_fail4: cannot remove small area wire.

        """
        return _ShapeFix.ShapeFix_Face_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_Face_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_Face

# Register ShapeFix_Face in _ShapeFix:
_ShapeFix.ShapeFix_Face_swigregister(ShapeFix_Face)
class ShapeFix_FixSmallFace(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeFix.ShapeFix_FixSmallFace_swiginit(self, _ShapeFix.new_ShapeFix_FixSmallFace(*args))

    def ComputeSharedEdgeForStripFace(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        F1: TopoDS_Face
        tol: float

        Return
        -------
        TopoDS_Edge

        Description
        -----------
        Compute average edge for strip face.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_ComputeSharedEdgeForStripFace(self, *args)

    def FixFace(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        TopoDS_Face

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_FixFace(self, *args)

    def FixPinFace(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_FixPinFace(self, *args)

    def FixShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_FixShape(self, *args)

    def FixSplitFace(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_FixSplitFace(self, *args)

    def FixSpotFace(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Fixing case of spot face, if tol = -1 used local tolerance.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_FixSpotFace(self, *args)

    def FixStripFace(self, *args):
        r"""

        Parameters
        ----------
        wasdone: bool (optional, default to Standard_False)

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Fixing case of strip face, if tol = -1 used local tolerance.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_FixStripFace(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_Init(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Fixing case of spot face.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_Perform(self, *args)

    def RemoveFacesInCaseOfSpot(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        Remove spot face from compound.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_RemoveFacesInCaseOfSpot(self, *args)

    def RemoveFacesInCaseOfStrip(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face

        Return
        -------
        bool

        Description
        -----------
        Remove strip face from compound.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_RemoveFacesInCaseOfStrip(self, *args)

    def ReplaceInCaseOfStrip(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        tol: float

        Return
        -------
        bool

        Description
        -----------
        Replace veretces and edges.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_ReplaceInCaseOfStrip(self, *args)

    def ReplaceVerticesInCaseOfSpot(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        tol: float

        Return
        -------
        bool

        Description
        -----------
        Compute average vertex and replacing vertices by new one.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_ReplaceVerticesInCaseOfSpot(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_Shape(self, *args)

    def SplitOneFace(self, *args):
        r"""

        Parameters
        ----------
        F: TopoDS_Face
        theSplittedFaces: TopoDS_Compound

        Return
        -------
        bool

        Description
        -----------
        Compute data for face splitting.

        """
        return _ShapeFix.ShapeFix_FixSmallFace_SplitOneFace(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_FixSmallFace_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_FixSmallFace

# Register ShapeFix_FixSmallFace in _ShapeFix:
_ShapeFix.ShapeFix_FixSmallFace_swigregister(ShapeFix_FixSmallFace)
class ShapeFix_FixSmallSolid(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Construct.

        """
        _ShapeFix.ShapeFix_FixSmallSolid_swiginit(self, _ShapeFix.new_ShapeFix_FixSmallSolid(*args))

    def Merge(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theContext: ShapeBuild_ReShape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Merge small solids in the given shape to adjacent non-small ones.

        """
        return _ShapeFix.ShapeFix_FixSmallSolid_Merge(self, *args)

    def Remove(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theContext: ShapeBuild_ReShape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Remove small solids from the given shape.

        """
        return _ShapeFix.ShapeFix_FixSmallSolid_Remove(self, *args)

    def SetFixMode(self, *args):
        r"""

        Parameters
        ----------
        theMode: int

        Return
        -------
        None

        Description
        -----------
        Set working mode for operator: - themode = 0 use both widthfactorthreshold and volumethreshold parameters - themode = 1 use only widthfactorthreshold parameter - themode = 2 use only volumethreshold parameter.

        """
        return _ShapeFix.ShapeFix_FixSmallSolid_SetFixMode(self, *args)

    def SetVolumeThreshold(self, *args):
        r"""

        Parameters
        ----------
        theThreshold: float (optional, default to -1.0)

        Return
        -------
        None

        Description
        -----------
        Set or clear volume threshold for small solids.

        """
        return _ShapeFix.ShapeFix_FixSmallSolid_SetVolumeThreshold(self, *args)

    def SetWidthFactorThreshold(self, *args):
        r"""

        Parameters
        ----------
        theThreshold: float (optional, default to -1.0)

        Return
        -------
        None

        Description
        -----------
        Set or clear width factor threshold for small solids.

        """
        return _ShapeFix.ShapeFix_FixSmallSolid_SetWidthFactorThreshold(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_FixSmallSolid_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_FixSmallSolid

# Register ShapeFix_FixSmallSolid in _ShapeFix:
_ShapeFix.ShapeFix_FixSmallSolid_swigregister(ShapeFix_FixSmallSolid)
class ShapeFix_Shape(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initislises by shape.

        """
        _ShapeFix.ShapeFix_Shape_swiginit(self, _ShapeFix.new_ShapeFix_Shape(*args))

    def FixEdgeTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeFix_Edge>

        Description
        -----------
        Returns tool for fixing edges.

        """
        return _ShapeFix.ShapeFix_Shape_FixEdgeTool(self, *args)

    def FixFaceTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeFix_Face>

        Description
        -----------
        Returns tool for fixing faces.

        """
        return _ShapeFix.ShapeFix_Shape_FixFaceTool(self, *args)

    def GetFixFreeFaceMode(self):
        r"""GetFixFreeFaceMode(ShapeFix_Shape self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Shape_GetFixFreeFaceMode(self)

    def SetFixFreeFaceMode(self, value):
        r"""SetFixFreeFaceMode(ShapeFix_Shape self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Shape_SetFixFreeFaceMode(self, value)

    def GetFixFreeShellMode(self):
        r"""GetFixFreeShellMode(ShapeFix_Shape self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Shape_GetFixFreeShellMode(self)

    def SetFixFreeShellMode(self, value):
        r"""SetFixFreeShellMode(ShapeFix_Shape self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Shape_SetFixFreeShellMode(self, value)

    def GetFixFreeWireMode(self):
        r"""GetFixFreeWireMode(ShapeFix_Shape self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Shape_GetFixFreeWireMode(self)

    def SetFixFreeWireMode(self, value):
        r"""SetFixFreeWireMode(ShapeFix_Shape self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Shape_SetFixFreeWireMode(self, value)

    def GetFixSameParameterMode(self):
        r"""GetFixSameParameterMode(ShapeFix_Shape self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Shape_GetFixSameParameterMode(self)

    def SetFixSameParameterMode(self, value):
        r"""SetFixSameParameterMode(ShapeFix_Shape self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Shape_SetFixSameParameterMode(self, value)

    def FixShellTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeFix_Shell>

        Description
        -----------
        Returns tool for fixing shells.

        """
        return _ShapeFix.ShapeFix_Shape_FixShellTool(self, *args)

    def GetFixSolidMode(self):
        r"""GetFixSolidMode(ShapeFix_Shape self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Shape_GetFixSolidMode(self)

    def SetFixSolidMode(self, value):
        r"""SetFixSolidMode(ShapeFix_Shape self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Shape_SetFixSolidMode(self, value)

    def FixSolidTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeFix_Solid>

        Description
        -----------
        Returns tool for fixing solids.

        """
        return _ShapeFix.ShapeFix_Shape_FixSolidTool(self, *args)

    def GetFixVertexPositionMode(self):
        r"""GetFixVertexPositionMode(ShapeFix_Shape self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Shape_GetFixVertexPositionMode(self)

    def SetFixVertexPositionMode(self, value):
        r"""SetFixVertexPositionMode(ShapeFix_Shape self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Shape_SetFixVertexPositionMode(self, value)

    def GetFixVertexTolMode(self):
        r"""GetFixVertexTolMode(ShapeFix_Shape self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Shape_GetFixVertexTolMode(self)

    def SetFixVertexTolMode(self, value):
        r"""SetFixVertexTolMode(ShapeFix_Shape self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Shape_SetFixVertexTolMode(self, value)

    def FixWireTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeFix_Wire>

        Description
        -----------
        Returns tool for fixing wires.

        """
        return _ShapeFix.ShapeFix_Shape_FixWireTool(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Initislises by shape.

        """
        return _ShapeFix.ShapeFix_Shape_Init(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Iterates on sub- shape and performs fixes.

        """
        return _ShapeFix.ShapeFix_Shape_Perform(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns resulting shape.

        """
        return _ShapeFix.ShapeFix_Shape_Shape(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Returns the status of the last fix. this can be a combination of the following flags: shapeextend_done1: some free edges were fixed shapeextend_done2: some free wires were fixed shapeextend_done3: some free faces were fixed shapeextend_done4: some free shells were fixed shapeextend_done5: some free solids were fixed shapeextend_done6: shapes in compound(s) were fixed.

        """
        return _ShapeFix.ShapeFix_Shape_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_Shape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_Shape

# Register ShapeFix_Shape in _ShapeFix:
_ShapeFix.ShapeFix_Shape_swigregister(ShapeFix_Shape)
class ShapeFix_Shell(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        shape: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        Initializes by shell.

        """
        _ShapeFix.ShapeFix_Shell_swiginit(self, _ShapeFix.new_ShapeFix_Shell(*args))

    def ErrorFaces(self, *args):
        r"""
        Return
        -------
        TopoDS_Compound

        Description
        -----------
        Returns not oriented subset of faces.

        """
        return _ShapeFix.ShapeFix_Shell_ErrorFaces(self, *args)

    def GetFixFaceMode(self):
        r"""GetFixFaceMode(ShapeFix_Shell self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Shell_GetFixFaceMode(self)

    def SetFixFaceMode(self, value):
        r"""SetFixFaceMode(ShapeFix_Shell self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Shell_SetFixFaceMode(self, value)

    def FixFaceOrientation(self, *args):
        r"""

        Parameters
        ----------
        shell: TopoDS_Shell
        isAccountMultiConex: bool (optional, default to Standard_True)
        NonManifold: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Fixes orientation of faces in shell. changes orientation of face in the shell, if it is oriented opposite to neighbouring faces. if it is not possible to orient all faces in the shell (like in case of mebious band), this method orients only subset of faces. other faces are stored in error compound. modes: isaccountmulticonex - mode for account cases of multiconnexity. if this mode is equal to standard_true, separate shells will be created in the cases of multiconnexity. if this mode is equal to standard_false, one shell will be created without account of multiconnexity.by defautt - standard_true; nonmanifold - mode for creation of non-manifold shells. if this mode is equal to standard_true one non-manifold will be created from shell contains multishared edges. else if this mode is equal to standard_false only manifold shells will be created. by default - standard_false.

        """
        return _ShapeFix.ShapeFix_Shell_FixFaceOrientation(self, *args)

    def FixFaceTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeFix_Face>

        Description
        -----------
        Returns tool for fixing faces.

        """
        return _ShapeFix.ShapeFix_Shell_FixFaceTool(self, *args)

    def GetFixOrientationMode(self):
        r"""GetFixOrientationMode(ShapeFix_Shell self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Shell_GetFixOrientationMode(self)

    def SetFixOrientationMode(self, value):
        r"""SetFixOrientationMode(ShapeFix_Shell self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Shell_SetFixOrientationMode(self, value)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        shell: TopoDS_Shell

        Return
        -------
        None

        Description
        -----------
        Initializes by shell.

        """
        return _ShapeFix.ShapeFix_Shell_Init(self, *args)

    def NbShells(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of obtainrd shells;.

        """
        return _ShapeFix.ShapeFix_Shell_NbShells(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Iterates on subshapes and performs fixes (for each face calls shapefix_face::perform and then calls fixfaceorientation). the passed progress indicator allows user to consult the current progress stage and abort algorithm if needed.

        """
        return _ShapeFix.ShapeFix_Shell_Perform(self, *args)

    def SetNonManifoldFlag(self, *args):
        r"""

        Parameters
        ----------
        isNonManifold: bool

        Return
        -------
        None

        Description
        -----------
        Sets nonmanifold flag.

        """
        return _ShapeFix.ShapeFix_Shell_SetNonManifoldFlag(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        In case of multiconnexity returns compound of fixed shells else returns one shell..

        """
        return _ShapeFix.ShapeFix_Shell_Shape(self, *args)

    def Shell(self, *args):
        r"""
        Return
        -------
        TopoDS_Shell

        Description
        -----------
        Returns fixed shell (or subset of oriented faces).

        """
        return _ShapeFix.ShapeFix_Shell_Shell(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Returns the status of the last fix.

        """
        return _ShapeFix.ShapeFix_Shell_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_Shell_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_Shell

# Register ShapeFix_Shell in _ShapeFix:
_ShapeFix.ShapeFix_Shell_swigregister(ShapeFix_Shell)
class ShapeFix_Solid(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor;.

        Parameters
        ----------
        solid: TopoDS_Solid

        Return
        -------
        None

        Description
        -----------
        Initializes by solid.

        """
        _ShapeFix.ShapeFix_Solid_swiginit(self, _ShapeFix.new_ShapeFix_Solid(*args))

    def GetCreateOpenSolidMode(self):
        r"""GetCreateOpenSolidMode(ShapeFix_Solid self) -> Standard_Boolean"""
        return _ShapeFix.ShapeFix_Solid_GetCreateOpenSolidMode(self)

    def SetCreateOpenSolidMode(self, value):
        r"""SetCreateOpenSolidMode(ShapeFix_Solid self, Standard_Boolean value)"""
        return _ShapeFix.ShapeFix_Solid_SetCreateOpenSolidMode(self, value)

    def GetFixShellMode(self):
        r"""GetFixShellMode(ShapeFix_Solid self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Solid_GetFixShellMode(self)

    def SetFixShellMode(self, value):
        r"""SetFixShellMode(ShapeFix_Solid self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Solid_SetFixShellMode(self, value)

    def GetFixShellOrientationMode(self):
        r"""GetFixShellOrientationMode(ShapeFix_Solid self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Solid_GetFixShellOrientationMode(self)

    def SetFixShellOrientationMode(self, value):
        r"""SetFixShellOrientationMode(ShapeFix_Solid self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Solid_SetFixShellOrientationMode(self, value)

    def FixShellTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeFix_Shell>

        Description
        -----------
        Returns tool for fixing shells.

        """
        return _ShapeFix.ShapeFix_Solid_FixShellTool(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        solid: TopoDS_Solid

        Return
        -------
        None

        Description
        -----------
        Initializes by solid .

        """
        return _ShapeFix.ShapeFix_Solid_Init(self, *args)

    def Perform(self, *args):
        r"""

        Parameters
        ----------
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Iterates on shells and performs fixes (calls shapefix_shell for each subshell). the passed progress indicator allows user to consult the current progress stage and abort algorithm if needed.

        """
        return _ShapeFix.ShapeFix_Solid_Perform(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        In case of multiconnexity returns compound of fixed solids else returns one solid.

        """
        return _ShapeFix.ShapeFix_Solid_Shape(self, *args)

    def Solid(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns resulting solid.

        """
        return _ShapeFix.ShapeFix_Solid_Solid(self, *args)

    def SolidFromShell(self, *args):
        r"""

        Parameters
        ----------
        shell: TopoDS_Shell

        Return
        -------
        TopoDS_Solid

        Description
        -----------
        Calls makesolid and orients the solid to be 'not infinite'.

        """
        return _ShapeFix.ShapeFix_Solid_SolidFromShell(self, *args)

    def Status(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Returns the status of the last fix.

        """
        return _ShapeFix.ShapeFix_Solid_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_Solid_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_Solid

# Register ShapeFix_Solid in _ShapeFix:
_ShapeFix.ShapeFix_Solid_swigregister(ShapeFix_Solid)
class ShapeFix_SplitCommonVertex(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeFix.ShapeFix_SplitCommonVertex_swiginit(self, _ShapeFix.new_ShapeFix_SplitCommonVertex(*args))

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_SplitCommonVertex_Init(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_SplitCommonVertex_Perform(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_SplitCommonVertex_Shape(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_SplitCommonVertex_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_SplitCommonVertex

# Register ShapeFix_SplitCommonVertex in _ShapeFix:
_ShapeFix.ShapeFix_SplitCommonVertex_swigregister(ShapeFix_SplitCommonVertex)
class ShapeFix_Wire(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor, creates clear object with default flags.

        Parameters
        ----------
        wire: TopoDS_Wire
        face: TopoDS_Face
        prec: float

        Return
        -------
        None

        Description
        -----------
        Create new object with default flags and prepare it for use (loads analyzer with all the data for the wire and face).

        """
        _ShapeFix.ShapeFix_Wire_swiginit(self, _ShapeFix.new_ShapeFix_Wire(*args))

    def Analyzer(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeAnalysis_Wire>

        Description
        -----------
        Returns field analyzer (working tool).

        """
        return _ShapeFix.ShapeFix_Wire_Analyzer(self, *args)

    def ClearModes(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets all modes to default.

        """
        return _ShapeFix.ShapeFix_Wire_ClearModes(self, *args)

    def ClearStatuses(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears all statuses.

        """
        return _ShapeFix.ShapeFix_Wire_ClearStatuses(self, *args)

    def GetClosedWireMode(self):
        r"""GetClosedWireMode(ShapeFix_Wire self) -> Standard_Boolean"""
        return _ShapeFix.ShapeFix_Wire_GetClosedWireMode(self)

    def SetClosedWireMode(self, value):
        r"""SetClosedWireMode(ShapeFix_Wire self, Standard_Boolean value)"""
        return _ShapeFix.ShapeFix_Wire_SetClosedWireMode(self, value)

    def Face(self, *args):
        r"""
        Return
        -------
        TopoDS_Face

        Description
        -----------
        Returns working face (analyzer.face()).

        """
        return _ShapeFix.ShapeFix_Wire_Face(self, *args)

    def GetFixAddCurve3dMode(self):
        r"""GetFixAddCurve3dMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixAddCurve3dMode(self)

    def SetFixAddCurve3dMode(self, value):
        r"""SetFixAddCurve3dMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixAddCurve3dMode(self, value)

    def GetFixAddPCurveMode(self):
        r"""GetFixAddPCurveMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixAddPCurveMode(self)

    def SetFixAddPCurveMode(self, value):
        r"""SetFixAddPCurveMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixAddPCurveMode(self, value)

    def FixClosed(self, *args):
        r"""

        Parameters
        ----------
        prec: float (optional, default to -1.0)

        Return
        -------
        bool

        Description
        -----------
        Fixes a wire to be well closed it performs fixconnected, fixdegenerated and fixlacking between last and first edges (independingly on flag closedmode and modes for these fixings) if <prec> is -1 then maxtolerance() is taken.

        """
        return _ShapeFix.ShapeFix_Wire_FixClosed(self, *args)

    def FixConnected(self, *args):
        r"""

        Parameters
        ----------
        prec: float (optional, default to -1.0)

        Return
        -------
        bool

        Description
        -----------
        Applies fixconnected(num) to all edges in the wire connection between first and last edges is treated only if flag closedmode is true if <prec> is -1 then maxtolerance() is taken.

        Parameters
        ----------
        num: int
        prec: float

        Return
        -------
        bool

        Description
        -----------
        Fixes connected edges (preceding and current) forces vertices (end of preceding-begin of current) to be the same one tests with starting preci or, if given greater, <prec> if <prec> is -1 then maxtolerance() is taken.

        """
        return _ShapeFix.ShapeFix_Wire_FixConnected(self, *args)

    def GetFixConnectedMode(self):
        r"""GetFixConnectedMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixConnectedMode(self)

    def SetFixConnectedMode(self, value):
        r"""SetFixConnectedMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixConnectedMode(self, value)

    def FixDegenerated(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Applies fixdegenerated(num) to all edges in the wire connection between first and last edges is treated only if flag closedmode is true.

        Parameters
        ----------
        num: int

        Return
        -------
        bool

        Description
        -----------
        Fixes degenerated edge checks an <num-th> edge or a point between <num>th-1 and <num>th edges for a singularity on a supporting surface. if singularity is detected, either adds new degenerated edge (before <num>th), or makes <num>th edge to be degenerated.

        """
        return _ShapeFix.ShapeFix_Wire_FixDegenerated(self, *args)

    def GetFixDegeneratedMode(self):
        r"""GetFixDegeneratedMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixDegeneratedMode(self)

    def SetFixDegeneratedMode(self, value):
        r"""SetFixDegeneratedMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixDegeneratedMode(self, value)

    def FixEdgeCurves(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Groups the fixes dealing with 3d and pcurves of the edges. the order of the fixes and the default behaviour are: shapefix_edge::fixreversed2d shapefix_edge::fixremovepcurve (only if forced) shapefix_edge::fixaddpcurve shapefix_edge::fixremovecurve3d (only if forced) shapefix_edge::fixaddcurve3d fixseam, fixshifted, shapefix_edge::fixsameparameter.

        """
        return _ShapeFix.ShapeFix_Wire_FixEdgeCurves(self, *args)

    def GetFixEdgeCurvesMode(self):
        r"""GetFixEdgeCurvesMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixEdgeCurvesMode(self)

    def SetFixEdgeCurvesMode(self, value):
        r"""SetFixEdgeCurvesMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixEdgeCurvesMode(self, value)

    def FixEdgeTool(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeFix_Edge>

        Description
        -----------
        Returns tool for fixing wires.

        """
        return _ShapeFix.ShapeFix_Wire_FixEdgeTool(self, *args)

    def FixGap2d(self, *args):
        r"""

        Parameters
        ----------
        num: int
        convert: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Fixes gap between ends of pcurves on num-1 and num-th edges. myprecision is used to detect the gap. if convert is true, converts pcurves to bsplines to bend.

        """
        return _ShapeFix.ShapeFix_Wire_FixGap2d(self, *args)

    def FixGap3d(self, *args):
        r"""

        Parameters
        ----------
        num: int
        convert: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Fixes gap between ends of 3d curves on num-1 and num-th edges. myprecision is used to detect the gap. if convert is true, converts curves to bsplines to bend.

        """
        return _ShapeFix.ShapeFix_Wire_FixGap3d(self, *args)

    def FixGaps2d(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Fixes gaps between ends of pcurves on adjacent edges myprecision is used to detect the gaps.

        """
        return _ShapeFix.ShapeFix_Wire_FixGaps2d(self, *args)

    def GetFixGaps2dMode(self):
        r"""GetFixGaps2dMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixGaps2dMode(self)

    def SetFixGaps2dMode(self, value):
        r"""SetFixGaps2dMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixGaps2dMode(self, value)

    def FixGaps3d(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Fixes gaps between ends of 3d curves on adjacent edges myprecision is used to detect the gaps.

        """
        return _ShapeFix.ShapeFix_Wire_FixGaps3d(self, *args)

    def GetFixGaps3dMode(self):
        r"""GetFixGaps3dMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixGaps3dMode(self)

    def SetFixGaps3dMode(self, value):
        r"""SetFixGaps3dMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixGaps3dMode(self, value)

    def GetFixGapsByRangesMode(self):
        r"""GetFixGapsByRangesMode(ShapeFix_Wire self) -> Standard_Boolean"""
        return _ShapeFix.ShapeFix_Wire_GetFixGapsByRangesMode(self)

    def SetFixGapsByRangesMode(self, value):
        r"""SetFixGapsByRangesMode(ShapeFix_Wire self, Standard_Boolean value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixGapsByRangesMode(self, value)

    def GetFixIntersectingEdgesMode(self):
        r"""GetFixIntersectingEdgesMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixIntersectingEdgesMode(self)

    def SetFixIntersectingEdgesMode(self, value):
        r"""SetFixIntersectingEdgesMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixIntersectingEdgesMode(self, value)

    def FixLacking(self, *args):
        r"""

        Parameters
        ----------
        force: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Applies fixlacking(num) to all edges in the wire connection between first and last edges is treated only if flag closedmode is true if <force> is false (default), test for connectness is done with precision of vertex between edges, else it is done with minimal value of vertex tolerance and analyzer.precision(). hence, <force> will lead to inserting lacking edges in replacement of vertices which have big tolerances.

        Parameters
        ----------
        num: int
        force: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Fixes lacking edge test if two adjucent edges are disconnected in 2d (while connected in 3d), and in that case either increase tolerance of the vertex or add a new edge (straight in 2d space), in order to close wire in 2d. returns true if edge was added or tolerance was increased.

        """
        return _ShapeFix.ShapeFix_Wire_FixLacking(self, *args)

    def GetFixLackingMode(self):
        r"""GetFixLackingMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixLackingMode(self)

    def SetFixLackingMode(self, value):
        r"""SetFixLackingMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixLackingMode(self, value)

    def GetFixNonAdjacentIntersectingEdgesMode(self):
        r"""GetFixNonAdjacentIntersectingEdgesMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixNonAdjacentIntersectingEdgesMode(self)

    def SetFixNonAdjacentIntersectingEdgesMode(self, value):
        r"""SetFixNonAdjacentIntersectingEdgesMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixNonAdjacentIntersectingEdgesMode(self, value)

    def FixNotchedEdges(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_FixNotchedEdges(self, *args)

    def GetFixNotchedEdgesMode(self):
        r"""GetFixNotchedEdgesMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixNotchedEdgesMode(self)

    def SetFixNotchedEdgesMode(self, value):
        r"""SetFixNotchedEdgesMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixNotchedEdgesMode(self, value)

    def GetFixRemoveCurve3dMode(self):
        r"""GetFixRemoveCurve3dMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixRemoveCurve3dMode(self)

    def SetFixRemoveCurve3dMode(self, value):
        r"""SetFixRemoveCurve3dMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixRemoveCurve3dMode(self, value)

    def GetFixRemovePCurveMode(self):
        r"""GetFixRemovePCurveMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixRemovePCurveMode(self)

    def SetFixRemovePCurveMode(self, value):
        r"""SetFixRemovePCurveMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixRemovePCurveMode(self, value)

    def FixReorder(self, *args):
        r"""

        Parameters
        ----------
        theModeBoth: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Performs an analysis and reorders edges in the wire using class wireorder. flag <themodeboth> determines the use of miscible mode if necessary.

        Parameters
        ----------
        wi: ShapeAnalysis_WireOrder

        Return
        -------
        bool

        Description
        -----------
        Reorder edges in the wire as determined by wireorder that should be filled and computed before.

        """
        return _ShapeFix.ShapeFix_Wire_FixReorder(self, *args)

    def GetFixReorderMode(self):
        r"""GetFixReorderMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixReorderMode(self)

    def SetFixReorderMode(self, value):
        r"""SetFixReorderMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixReorderMode(self, value)

    def GetFixReversed2dMode(self):
        r"""GetFixReversed2dMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixReversed2dMode(self)

    def SetFixReversed2dMode(self, value):
        r"""SetFixReversed2dMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixReversed2dMode(self, value)

    def GetFixSameParameterMode(self):
        r"""GetFixSameParameterMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixSameParameterMode(self)

    def SetFixSameParameterMode(self, value):
        r"""SetFixSameParameterMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixSameParameterMode(self, value)

    def FixSeam(self, *args):
        r"""

        Parameters
        ----------
        num: int

        Return
        -------
        bool

        Description
        -----------
        Fixes a seam edge a seam edge has two pcurves, one for forward. one for reversed the forward pcurve must be set as first //! note that correct order of pcurves in the seam edge depends on its orientation (i.e., on orientation of the wire, method of exploration of edges etc.). since wire represented by the shapeextend_wiredata is always forward (orientation is accounted by edges), it will work correct if: 1. wire created from shapeextend_wiredata with methods shapeextend_wiredata::wire..() is added into the forward face (orientation can be applied later) 2. wire is extracted from the face with orientation not composed with orientation of the face.

        """
        return _ShapeFix.ShapeFix_Wire_FixSeam(self, *args)

    def GetFixSeamMode(self):
        r"""GetFixSeamMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixSeamMode(self)

    def SetFixSeamMode(self, value):
        r"""SetFixSeamMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixSeamMode(self, value)

    def GetFixSelfIntersectingEdgeMode(self):
        r"""GetFixSelfIntersectingEdgeMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixSelfIntersectingEdgeMode(self)

    def SetFixSelfIntersectingEdgeMode(self, value):
        r"""SetFixSelfIntersectingEdgeMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixSelfIntersectingEdgeMode(self, value)

    def FixSelfIntersection(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Applies fixselfintersectingedge(num) and fixintersectingedges(num) to all edges in the wire and fixintersectingedges(num1, num2) for all pairs num1 and num2 such that num2 >= num1 + 2 and removes wrong edges if any.

        """
        return _ShapeFix.ShapeFix_Wire_FixSelfIntersection(self, *args)

    def GetFixSelfIntersectionMode(self):
        r"""GetFixSelfIntersectionMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixSelfIntersectionMode(self)

    def SetFixSelfIntersectionMode(self, value):
        r"""SetFixSelfIntersectionMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixSelfIntersectionMode(self, value)

    def FixShifted(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Fixes edges which have pcurves shifted by whole parameter range on the closed surface (the case may occur if pcurve of edge was computed by projecting 3d curve, which goes along the seam). it compares each two consequent edges and tries to connect them if distance between ends is near to range of the surface. it also can detect and fix the case if all pcurves are connected, but lie out of parametric bounds of the surface. in addition to fixshifted from shapefix_wire, more sophisticated check of degenerate points is performed, and special cases like sphere given by two meridians are treated.

        """
        return _ShapeFix.ShapeFix_Wire_FixShifted(self, *args)

    def GetFixShiftedMode(self):
        r"""GetFixShiftedMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixShiftedMode(self)

    def SetFixShiftedMode(self, value):
        r"""SetFixShiftedMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixShiftedMode(self, value)

    def FixSmall(self, *args):
        r"""

        Parameters
        ----------
        lockvtx: bool
        precsmall: float (optional, default to 0.0)

        Return
        -------
        int

        Description
        -----------
        Applies fixsmall(num) to all edges in the wire.

        Parameters
        ----------
        num: int
        lockvtx: bool
        precsmall: float

        Return
        -------
        bool

        Description
        -----------
        Fixes null length edge to be removed if an edge has null length (regarding preci, or <precsmall> - what is smaller), it should be removed it can be with no problem if its two vertices are the same else, if lockvtx is false, it is removed and its end vertex is put on the preceding edge but if lockvtx is true, this edge must be kept ...

        """
        return _ShapeFix.ShapeFix_Wire_FixSmall(self, *args)

    def GetFixSmallMode(self):
        r"""GetFixSmallMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixSmallMode(self)

    def SetFixSmallMode(self, value):
        r"""SetFixSmallMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixSmallMode(self, value)

    def GetFixTailMode(self):
        r"""GetFixTailMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixTailMode(self)

    def SetFixTailMode(self, value):
        r"""SetFixTailMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixTailMode(self, value)

    def FixTails(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_FixTails(self, *args)

    def GetFixVertexToleranceMode(self):
        r"""GetFixVertexToleranceMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetFixVertexToleranceMode(self)

    def SetFixVertexToleranceMode(self, value):
        r"""SetFixVertexToleranceMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetFixVertexToleranceMode(self, value)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        wire: TopoDS_Wire
        face: TopoDS_Face
        prec: float

        Return
        -------
        None

        Description
        -----------
        Load analyzer with all the data for the wire and face and drops all fixing statuses.

        Parameters
        ----------
        saw: ShapeAnalysis_Wire

        Return
        -------
        None

        Description
        -----------
        Load analyzer with all the data already prepared and drops all fixing statuses if analyzer contains face, there is no need to set it by setface or setsurface.

        """
        return _ShapeFix.ShapeFix_Wire_Init(self, *args)

    def IsLoaded(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Tells if the wire is loaded.

        """
        return _ShapeFix.ShapeFix_Wire_IsLoaded(self, *args)

    def IsReady(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Tells if the wire and face are loaded.

        """
        return _ShapeFix.ShapeFix_Wire_IsReady(self, *args)

    def LastFixStatus(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Queries the status of last call to methods fix... of advanced level for details see corresponding methods; universal statuses are: ok: problem not detected; nothing done done: problem was detected and successfully fixed fail: problem cannot be fixed.

        """
        return _ShapeFix.ShapeFix_Wire_LastFixStatus(self, *args)

    def Load(self, *args):
        r"""

        Parameters
        ----------
        wire: TopoDS_Wire

        Return
        -------
        None

        Description
        -----------
        Load data for the wire, and drops all fixing statuses.

        Parameters
        ----------
        sbwd: ShapeExtend_WireData

        Return
        -------
        None

        Description
        -----------
        Load data for the wire, and drops all fixing statuses.

        """
        return _ShapeFix.ShapeFix_Wire_Load(self, *args)

    def GetModifyGeometryMode(self):
        r"""GetModifyGeometryMode(ShapeFix_Wire self) -> Standard_Boolean"""
        return _ShapeFix.ShapeFix_Wire_GetModifyGeometryMode(self)

    def SetModifyGeometryMode(self, value):
        r"""SetModifyGeometryMode(ShapeFix_Wire self, Standard_Boolean value)"""
        return _ShapeFix.ShapeFix_Wire_SetModifyGeometryMode(self, value)

    def GetModifyRemoveLoopMode(self):
        r"""GetModifyRemoveLoopMode(ShapeFix_Wire self) -> Standard_Integer"""
        return _ShapeFix.ShapeFix_Wire_GetModifyRemoveLoopMode(self)

    def SetModifyRemoveLoopMode(self, value):
        r"""SetModifyRemoveLoopMode(ShapeFix_Wire self, Standard_Integer value)"""
        return _ShapeFix.ShapeFix_Wire_SetModifyRemoveLoopMode(self, value)

    def GetModifyTopologyMode(self):
        r"""GetModifyTopologyMode(ShapeFix_Wire self) -> Standard_Boolean"""
        return _ShapeFix.ShapeFix_Wire_GetModifyTopologyMode(self)

    def SetModifyTopologyMode(self, value):
        r"""SetModifyTopologyMode(ShapeFix_Wire self, Standard_Boolean value)"""
        return _ShapeFix.ShapeFix_Wire_SetModifyTopologyMode(self, value)

    def NbEdges(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of edges in the working wire.

        """
        return _ShapeFix.ShapeFix_Wire_NbEdges(self, *args)

    def Perform(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        This method performs all the available fixes. if some fix is turned on or off explicitly by the fix..mode() flag, this fix is either called or not depending on that flag. else (i.e. if flag is default) fix is called depending on the situation: some fixes are not called or are limited if order of edges in the wire is not ok, or depending on modes //! the order of the fixes and default behaviour of perform() are: fixreorder fixsmall (with lockvtx true if ! topomode or if wire is not ordered) fixconnected (if wire is ordered) fixedgecurves (without fixshifted if wire is not ordered) fixdegenerated (if wire is ordered) fixselfintersection (if wire is ordered and closedmode is true) fixlacking (if wire is ordered).

        """
        return _ShapeFix.ShapeFix_Wire_Perform(self, *args)

    def GetPreferencePCurveMode(self):
        r"""GetPreferencePCurveMode(ShapeFix_Wire self) -> Standard_Boolean"""
        return _ShapeFix.ShapeFix_Wire_GetPreferencePCurveMode(self)

    def SetPreferencePCurveMode(self, value):
        r"""SetPreferencePCurveMode(ShapeFix_Wire self, Standard_Boolean value)"""
        return _ShapeFix.ShapeFix_Wire_SetPreferencePCurveMode(self, value)

    def SetFace(self, *args):
        r"""

        Parameters
        ----------
        face: TopoDS_Face

        Return
        -------
        None

        Description
        -----------
        Set working face for the wire.

        """
        return _ShapeFix.ShapeFix_Wire_SetFace(self, *args)

    def SetMaxTailAngle(self, *args):
        r"""

        Parameters
        ----------
        theMaxTailAngle: float

        Return
        -------
        None

        Description
        -----------
        Sets the maximal allowed angle of the tails in radians.

        """
        return _ShapeFix.ShapeFix_Wire_SetMaxTailAngle(self, *args)

    def SetMaxTailWidth(self, *args):
        r"""

        Parameters
        ----------
        theMaxTailWidth: float

        Return
        -------
        None

        Description
        -----------
        Sets the maximal allowed width of the tails.

        """
        return _ShapeFix.ShapeFix_Wire_SetMaxTailWidth(self, *args)

    def SetSurface(self, *args):
        r"""

        Parameters
        ----------
        surf: Geom_Surface

        Return
        -------
        None

        Description
        -----------
        Set surface for the wire.

        Parameters
        ----------
        surf: Geom_Surface
        loc: TopLoc_Location

        Return
        -------
        None

        Description
        -----------
        Set surface for the wire.

        """
        return _ShapeFix.ShapeFix_Wire_SetSurface(self, *args)

    def StatusClosed(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusClosed(self, *args)

    def StatusConnected(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusConnected(self, *args)

    def StatusDegenerated(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusDegenerated(self, *args)

    def StatusEdgeCurves(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusEdgeCurves(self, *args)

    def StatusFixTails(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusFixTails(self, *args)

    def StatusGaps2d(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusGaps2d(self, *args)

    def StatusGaps3d(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusGaps3d(self, *args)

    def StatusLacking(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusLacking(self, *args)

    def StatusNotches(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusNotches(self, *args)

    def StatusRemovedSegment(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Querying the status of performed api fixing procedures each status..() methods gives information about the last call to the corresponding fix..() method of api level: ok: no problems detected; nothing done done: some problem(s) was(were) detected and successfully fixed fail: some problem(s) cannot be fixed.

        """
        return _ShapeFix.ShapeFix_Wire_StatusRemovedSegment(self, *args)

    def StatusReorder(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusReorder(self, *args)

    def StatusSelfIntersection(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusSelfIntersection(self, *args)

    def StatusSmall(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wire_StatusSmall(self, *args)

    def Wire(self, *args):
        r"""
        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Makes the resulting wire (by basic brep_builder).

        """
        return _ShapeFix.ShapeFix_Wire_Wire(self, *args)

    def WireAPIMake(self, *args):
        r"""
        Return
        -------
        TopoDS_Wire

        Description
        -----------
        Makes the resulting wire (by brepapi_makewire).

        """
        return _ShapeFix.ShapeFix_Wire_WireAPIMake(self, *args)

    def WireData(self, *args):
        r"""
        Return
        -------
        opencascade::handle<ShapeExtend_WireData>

        Description
        -----------
        Returns working wire.

        """
        return _ShapeFix.ShapeFix_Wire_WireData(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_Wire_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_Wire

# Register ShapeFix_Wire in _ShapeFix:
_ShapeFix.ShapeFix_Wire_swigregister(ShapeFix_Wire)
class ShapeFix_Wireframe(ShapeFix_Root):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _ShapeFix.ShapeFix_Wireframe_swiginit(self, _ShapeFix.new_ShapeFix_Wireframe(*args))

    def CheckSmallEdges(self, *args):
        r"""

        Parameters
        ----------
        theSmallEdges: TopTools_MapOfShape
        theEdgeToFaces: TopTools_DataMapOfShapeListOfShape
        theFaceWithSmall: TopTools_DataMapOfShapeListOfShape
        theMultyEdges: TopTools_MapOfShape

        Return
        -------
        bool

        Description
        -----------
        Auxiliary tool for fixsmalledges which checks for small edges and fills the maps. returns true if at least one small edge has been found.

        """
        return _ShapeFix.ShapeFix_Wireframe_CheckSmallEdges(self, *args)

    def ClearStatuses(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears all statuses.

        """
        return _ShapeFix.ShapeFix_Wireframe_ClearStatuses(self, *args)

    def FixSmallEdges(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Fixes small edges in shape by merging adjacent edges if precision is 0.0, uses precision::confusion().

        """
        return _ShapeFix.ShapeFix_Wireframe_FixSmallEdges(self, *args)

    def FixWireGaps(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Fixes gaps between ends of curves of adjacent edges (both 3d and pcurves) in wires if precision is 0.0, uses precision::confusion().

        """
        return _ShapeFix.ShapeFix_Wireframe_FixWireGaps(self, *args)

    def LimitAngle(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Get limit angle for merging edges.

        """
        return _ShapeFix.ShapeFix_Wireframe_LimitAngle(self, *args)

    def Load(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        Loads a shape, resets statuses.

        """
        return _ShapeFix.ShapeFix_Wireframe_Load(self, *args)

    def MergeSmallEdges(self, *args):
        r"""

        Parameters
        ----------
        theSmallEdges: TopTools_MapOfShape
        theEdgeToFaces: TopTools_DataMapOfShapeListOfShape
        theFaceWithSmall: TopTools_DataMapOfShapeListOfShape
        theMultyEdges: TopTools_MapOfShape
        theModeDrop: bool (optional, default to Standard_False)
        theLimitAngle: float (optional, default to -1)

        Return
        -------
        bool

        Description
        -----------
        Auxiliary tool for fixsmalledges which merges small edges. if themodedrop is equal to standard_true then small edges, which cannot be connected with adjacent edges are dropped. otherwise they are kept. thelimitangle specifies maximum allowed tangency discontinuity between adjacent edges. if thelimitangle is equal to -1, this angle is not taken into account.

        """
        return _ShapeFix.ShapeFix_Wireframe_MergeSmallEdges(self, *args)

    def GetModeDropSmallEdges(self):
        r"""GetModeDropSmallEdges(ShapeFix_Wireframe self) -> Standard_Boolean"""
        return _ShapeFix.ShapeFix_Wireframe_GetModeDropSmallEdges(self)

    def SetModeDropSmallEdges(self, value):
        r"""SetModeDropSmallEdges(ShapeFix_Wireframe self, Standard_Boolean value)"""
        return _ShapeFix.ShapeFix_Wireframe_SetModeDropSmallEdges(self, value)

    def SetLimitAngle(self, *args):
        r"""

        Parameters
        ----------
        theLimitAngle: float

        Return
        -------
        None

        Description
        -----------
        Set limit angle for merging edges.

        """
        return _ShapeFix.ShapeFix_Wireframe_SetLimitAngle(self, *args)

    def Shape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _ShapeFix.ShapeFix_Wireframe_Shape(self, *args)

    def StatusSmallEdges(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Decodes the status of the last fixsmalledges. ok - no small edges were found done1 - some small edges were fixed fail1 - failed to fix some small edges.

        """
        return _ShapeFix.ShapeFix_Wireframe_StatusSmallEdges(self, *args)

    def StatusWireGaps(self, *args):
        r"""

        Parameters
        ----------
        status: ShapeExtend_Status

        Return
        -------
        bool

        Description
        -----------
        Decodes the status of the last fixwiregaps. ok - no gaps were found done1 - some gaps in 3d were fixed done2 - some gaps in 2d were fixed fail1 - failed to fix some gaps in 3d fail2 - failed to fix some gaps in 2d.

        """
        return _ShapeFix.ShapeFix_Wireframe_StatusWireGaps(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeFix_Wireframe_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeFix.delete_ShapeFix_Wireframe

# Register ShapeFix_Wireframe in _ShapeFix:
_ShapeFix.ShapeFix_Wireframe_swigregister(ShapeFix_Wireframe)

@classnotwrapped
class ShapeFix_WireSegment:
	pass





@deprecated
def shapefix_EncodeRegularity(*args):
	return shapefix.EncodeRegularity(*args)

@deprecated
def shapefix_FixVertexPosition(*args):
	return shapefix.FixVertexPosition(*args)

@deprecated
def shapefix_LeastEdgeSize(*args):
	return shapefix.LeastEdgeSize(*args)

@deprecated
def shapefix_RemoveSmallEdges(*args):
	return shapefix.RemoveSmallEdges(*args)

@deprecated
def shapefix_SameParameter(*args):
	return shapefix.SameParameter(*args)



