# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
XSControl module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_xscontrol.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _XSControl
else:
    import _XSControl

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _XSControl.delete_SwigPyIterator

    def value(self):
        return _XSControl.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _XSControl.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _XSControl.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _XSControl.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _XSControl.SwigPyIterator_equal(self, x)

    def copy(self):
        return _XSControl.SwigPyIterator_copy(self)

    def next(self):
        return _XSControl.SwigPyIterator_next(self)

    def __next__(self):
        return _XSControl.SwigPyIterator___next__(self)

    def previous(self):
        return _XSControl.SwigPyIterator_previous(self)

    def advance(self, n):
        return _XSControl.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _XSControl.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _XSControl.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _XSControl.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _XSControl.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _XSControl.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _XSControl.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _XSControl:
_XSControl.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _XSControl.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.IFSelect
import OCC.Core.Interface
import OCC.Core.TCollection
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.MoniTool
import OCC.Core.TopoDS
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.Transfer
import OCC.Core.TopTools
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Geom2d

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_XSControl_ConnectedShapes_Create():
    return _XSControl.Handle_XSControl_ConnectedShapes_Create()

def Handle_XSControl_ConnectedShapes_DownCast(t):
    return _XSControl.Handle_XSControl_ConnectedShapes_DownCast(t)

def Handle_XSControl_ConnectedShapes_IsNull(t):
    return _XSControl.Handle_XSControl_ConnectedShapes_IsNull(t)

def Handle_XSControl_Controller_Create():
    return _XSControl.Handle_XSControl_Controller_Create()

def Handle_XSControl_Controller_DownCast(t):
    return _XSControl.Handle_XSControl_Controller_DownCast(t)

def Handle_XSControl_Controller_IsNull(t):
    return _XSControl.Handle_XSControl_Controller_IsNull(t)

def Handle_XSControl_SelectForTransfer_Create():
    return _XSControl.Handle_XSControl_SelectForTransfer_Create()

def Handle_XSControl_SelectForTransfer_DownCast(t):
    return _XSControl.Handle_XSControl_SelectForTransfer_DownCast(t)

def Handle_XSControl_SelectForTransfer_IsNull(t):
    return _XSControl.Handle_XSControl_SelectForTransfer_IsNull(t)

def Handle_XSControl_SignTransferStatus_Create():
    return _XSControl.Handle_XSControl_SignTransferStatus_Create()

def Handle_XSControl_SignTransferStatus_DownCast(t):
    return _XSControl.Handle_XSControl_SignTransferStatus_DownCast(t)

def Handle_XSControl_SignTransferStatus_IsNull(t):
    return _XSControl.Handle_XSControl_SignTransferStatus_IsNull(t)

def Handle_XSControl_TransferReader_Create():
    return _XSControl.Handle_XSControl_TransferReader_Create()

def Handle_XSControl_TransferReader_DownCast(t):
    return _XSControl.Handle_XSControl_TransferReader_DownCast(t)

def Handle_XSControl_TransferReader_IsNull(t):
    return _XSControl.Handle_XSControl_TransferReader_IsNull(t)

def Handle_XSControl_TransferWriter_Create():
    return _XSControl.Handle_XSControl_TransferWriter_Create()

def Handle_XSControl_TransferWriter_DownCast(t):
    return _XSControl.Handle_XSControl_TransferWriter_DownCast(t)

def Handle_XSControl_TransferWriter_IsNull(t):
    return _XSControl.Handle_XSControl_TransferWriter_IsNull(t)

def Handle_XSControl_Vars_Create():
    return _XSControl.Handle_XSControl_Vars_Create()

def Handle_XSControl_Vars_DownCast(t):
    return _XSControl.Handle_XSControl_Vars_DownCast(t)

def Handle_XSControl_Vars_IsNull(t):
    return _XSControl.Handle_XSControl_Vars_IsNull(t)

def Handle_XSControl_WorkSession_Create():
    return _XSControl.Handle_XSControl_WorkSession_Create()

def Handle_XSControl_WorkSession_DownCast(t):
    return _XSControl.Handle_XSControl_WorkSession_DownCast(t)

def Handle_XSControl_WorkSession_IsNull(t):
    return _XSControl.Handle_XSControl_WorkSession_IsNull(t)
class xscontrol(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Session(*args):
        r"""

        Parameters
        ----------
        pilot: IFSelect_SessionPilot

        Return
        -------
        opencascade::handle<XSControl_WorkSession>

        Description
        -----------
        Returns the worksession of a sessionpilot, but casts it as from xscontrol: it then gives access to control & transfers.

        """
        return _XSControl.xscontrol_Session(*args)

    @staticmethod
    def Vars(*args):
        r"""

        Parameters
        ----------
        pilot: IFSelect_SessionPilot

        Return
        -------
        opencascade::handle<XSControl_Vars>

        Description
        -----------
        Returns the vars of a sessionpilot, it is brought by session it provides access to external variables.

        """
        return _XSControl.xscontrol_Vars(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _XSControl.xscontrol_swiginit(self, _XSControl.new_xscontrol())
    __swig_destroy__ = _XSControl.delete_xscontrol

# Register xscontrol in _XSControl:
_XSControl.xscontrol_swigregister(xscontrol)
class XSControl_ConnectedShapes(OCC.Core.IFSelect.IFSelect_SelectExplore):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a selection connectedshapes. it remains to be set a transferreader.

        Parameters
        ----------
        TR: XSControl_TransferReader

        Return
        -------
        None

        Description
        -----------
        Creates a selection connectedshapes, which will work with the current transferprocess brought by the transferreader.

        """
        _XSControl.XSControl_ConnectedShapes_swiginit(self, _XSControl.new_XSControl_ConnectedShapes(*args))

    @staticmethod
    def AdjacentEntities(*args):
        r"""

        Parameters
        ----------
        ashape: TopoDS_Shape
        TP: Transfer_TransientProcess
        type: TopAbs_ShapeEnum

        Return
        -------
        opencascade::handle<TColStd_HSequenceOfTransient>

        Description
        -----------
        This functions considers a shape from a transfer and performs the search function explained above.

        """
        return _XSControl.XSControl_ConnectedShapes_AdjacentEntities(*args)

    def SetReader(self, *args):
        r"""

        Parameters
        ----------
        TR: XSControl_TransferReader

        Return
        -------
        None

        Description
        -----------
        Sets a transferreader to sort entities: it brings the transferprocess which may change, while the transferreader does not.

        """
        return _XSControl.XSControl_ConnectedShapes_SetReader(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_XSControl_ConnectedShapes_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_ConnectedShapes

# Register XSControl_ConnectedShapes in _XSControl:
_XSControl.XSControl_ConnectedShapes_swigregister(XSControl_ConnectedShapes)
class XSControl_Controller(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def ActorRead(self, *args):
        r"""

        Parameters
        ----------
        model: Interface_InterfaceModel

        Return
        -------
        opencascade::handle<Transfer_ActorOfTransientProcess>

        Description
        -----------
        Returns the actor for read attached to the pair (norm,appli) it can be adapted for data of the input model, as required can be read from field then adapted with model as required.

        """
        return _XSControl.XSControl_Controller_ActorRead(self, *args)

    def ActorWrite(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Transfer_ActorOfFinderProcess>

        Description
        -----------
        Returns the actor for write attached to the pair (norm,appli) read from field. can be redefined.

        """
        return _XSControl.XSControl_Controller_ActorWrite(self, *args)

    def AdaptorSession(self, *args):
        r"""
        Return
        -------
        NCollection_DataMap<TCollection_AsciiString, opencascade::handle<Standard_Transient>>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Controller_AdaptorSession(self, *args)

    def AddSessionItem(self, *args):
        r"""

        Parameters
        ----------
        theItem: Standard_Transient
        theName: str
        toApply: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Records a session item, to be added for customisation of the work session. it must have a specific name. <setapplied> is used if <item> is a generalmodifier, to decide if set to true, <item> will be applied to the hook list 'send'. else, it is not applied to any hook list. remark: this method is to be called at create time, the recorded items will be used by customise warning: if <name> conflicts, the last recorded item is kept.

        """
        return _XSControl.XSControl_Controller_AddSessionItem(self, *args)

    def AutoRecord(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Records <self> is a general dictionary under short and long names (see method name).

        """
        return _XSControl.XSControl_Controller_AutoRecord(self, *args)

    def Customise(self, *args):
        r"""

        Parameters
        ----------
        WS: XSControl_WorkSession

        Return
        -------
        None

        Description
        -----------
        Customises a worksession, by adding to it the recorded items (by addsessionitem).

        """
        return _XSControl.XSControl_Controller_Customise(self, *args)

    def IsModeWrite(self, *args):
        r"""

        Parameters
        ----------
        modetrans: int
        shape: bool (optional, default to Standard_True)

        Return
        -------
        bool

        Description
        -----------
        Tells if a value of <modetrans> is a good value(within bounds) actually only for shapes.

        """
        return _XSControl.XSControl_Controller_IsModeWrite(self, *args)

    def ModeWriteBounds(self, *args):
        r"""

        Parameters
        ----------
        shape: bool (optional, default to Standard_True)

        Return
        -------
        modemin: int
        modemax: int

        Description
        -----------
        Returns recorded min and max values for modetrans (write) actually only for shapes returns true if bounds are set, false else (then, free value).

        """
        return _XSControl.XSControl_Controller_ModeWriteBounds(self, *args)

    def ModeWriteHelp(self, *args):
        r"""

        Parameters
        ----------
        modetrans: int
        shape: bool (optional, default to Standard_True)

        Return
        -------
        str

        Description
        -----------
        Returns the help line recorded for a value of modetrans empty if help not defined or not within bounds or if values are free.

        """
        return _XSControl.XSControl_Controller_ModeWriteHelp(self, *args)

    def Name(self, *args):
        r"""

        Parameters
        ----------
        rsc: bool (optional, default to Standard_False)

        Return
        -------
        str

        Description
        -----------
        Returns a name, as given when initializing: rsc = false (d): true name attached to the norm (long name) rsc = true: name of the resource set (i.e. short name).

        """
        return _XSControl.XSControl_Controller_Name(self, *args)

    def NewModel(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_InterfaceModel>

        Description
        -----------
        Creates a new empty model ready to receive data of the norm used to write data from imagine to an interface file.

        """
        return _XSControl.XSControl_Controller_NewModel(self, *args)

    def Protocol(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_Protocol>

        Description
        -----------
        Returns the protocol attached to the norm (from field).

        """
        return _XSControl.XSControl_Controller_Protocol(self, *args)

    def RecognizeWriteShape(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        modetrans: int (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Tells if a shape is valid for a transfer to a model asks the actorwrite (through a shapemapper).

        """
        return _XSControl.XSControl_Controller_RecognizeWriteShape(self, *args)

    def RecognizeWriteTransient(self, *args):
        r"""

        Parameters
        ----------
        obj: Standard_Transient
        modetrans: int (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Tells if <obj> (an application object) is a valid candidate for a transfer to a model. by default, asks the actorwrite if known (through a transientmapper). can be redefined.

        """
        return _XSControl.XSControl_Controller_RecognizeWriteTransient(self, *args)

    def Record(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        None

        Description
        -----------
        Records <self> in a general dictionary under a name error if <name> already used for another one.

        """
        return _XSControl.XSControl_Controller_Record(self, *args)

    @staticmethod
    def Recorded(*args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        opencascade::handle<XSControl_Controller>

        Description
        -----------
        Returns the controller attached to a given name returns a null handle if <name> is unknown.

        """
        return _XSControl.XSControl_Controller_Recorded(*args)

    def SessionItem(self, *args):
        r"""

        Parameters
        ----------
        theName: str

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns an item given its name to record in a session if <name> is unknown, returns a null handle.

        """
        return _XSControl.XSControl_Controller_SessionItem(self, *args)

    def SetModeWrite(self, *args):
        r"""

        Parameters
        ----------
        modemin: int
        modemax: int
        shape: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Sets mininum and maximum values for modetrans (write) erases formerly recorded bounds and values actually only for shape then, for each value a little help can be attached.

        """
        return _XSControl.XSControl_Controller_SetModeWrite(self, *args)

    def SetModeWriteHelp(self, *args):
        r"""

        Parameters
        ----------
        modetrans: int
        help: str
        shape: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Attaches a short line of help to a value of modetrans (write).

        """
        return _XSControl.XSControl_Controller_SetModeWriteHelp(self, *args)

    def SetNames(self, *args):
        r"""

        Parameters
        ----------
        theLongName: str
        theShortName: str

        Return
        -------
        None

        Description
        -----------
        Changes names if a name is empty, the formerly set one remains remark: does not call record or autorecord.

        """
        return _XSControl.XSControl_Controller_SetNames(self, *args)

    def TransferWriteShape(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        FP: Transfer_FinderProcess
        model: Interface_InterfaceModel
        modetrans: int (optional, default to 0)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        IFSelect_ReturnStatus

        Description
        -----------
        Takes one shape and transfers it to an interfacemodel (already created, e.g. by newmodel) default uses actorwrite; can be redefined as necessary returned value is a status, as follows: done ok , void: no result , fail: fail (e.g. exception) error: bad conditions , bad model or null model.

        """
        return _XSControl.XSControl_Controller_TransferWriteShape(self, *args)

    def TransferWriteTransient(self, *args):
        r"""

        Parameters
        ----------
        obj: Standard_Transient
        FP: Transfer_FinderProcess
        model: Interface_InterfaceModel
        modetrans: int (optional, default to 0)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        IFSelect_ReturnStatus

        Description
        -----------
        Takes one transient object and transfers it to an interfacemodel (already created, e.g. by newmodel) (result is recorded in the model by addwithrefs) fp records produced results and checks //! default uses actorwrite; can be redefined as necessary returned value is a status, as follows: 0 ok , 1 no result , 2 fail (e.g. exception raised) -1 bad conditions , -2 bad model or null model for type of object not recognized: should return 1.

        """
        return _XSControl.XSControl_Controller_TransferWriteTransient(self, *args)

    def WorkLibrary(self, *args):
        r"""
        Return
        -------
        opencascade::handle<IFSelect_WorkLibrary>

        Description
        -----------
        Returns the worklibrary attached to the norm. remark that it has to be in phase with the protocol (read from field).

        """
        return _XSControl.XSControl_Controller_WorkLibrary(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_XSControl_Controller_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_Controller

# Register XSControl_Controller in _XSControl:
_XSControl.XSControl_Controller_swigregister(XSControl_Controller)
class XSControl_FuncShape(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def FileAndVar(*args):
        r"""

        Parameters
        ----------
        session: XSControl_WorkSession
        file: str
        var: str
        def: str
        resfile: str
        resvar: str

        Return
        -------
        bool

        Description
        -----------
        Analyses given file name and variable name, with a default name for variables. returns resulting file name and variable name plus status 'file to read'(true) or 'already read'(false) in the latter case, empty resfile means no file available //! if <file> is null or empty or equates '.', considers session and returned status is false else, returns resfile = file and status is true if <var> is neither null nor empty, resvar = var else, the root part of <resfile> is considered, if defined else, <def> is taken.

        """
        return _XSControl.XSControl_FuncShape_FileAndVar(*args)

    @staticmethod
    def Init(*args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Defines and loads all functions which work on shapes for xscontrol (as actfunc).

        """
        return _XSControl.XSControl_FuncShape_Init(*args)

    @staticmethod
    def MoreShapes(*args):
        r"""

        Parameters
        ----------
        session: XSControl_WorkSession
        list: TopTools_HSequenceOfShape
        name: str

        Return
        -------
        int

        Description
        -----------
        Analyses a name as designating shapes from a vars or from xstep transfer (last transfer on reading). <name> can be: '*': all the root shapes produced by last transfer (read) i.e. considers roots of the transientprocess a name: a name of a variable draw //! returns the count of designated shapes. their list is put in <list>. if <list> is null, it is firstly created. then it is completed (append without clear) by the shapes found returns 0 if no shape could be found.

        """
        return _XSControl.XSControl_FuncShape_MoreShapes(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _XSControl.XSControl_FuncShape_swiginit(self, _XSControl.new_XSControl_FuncShape())
    __swig_destroy__ = _XSControl.delete_XSControl_FuncShape

# Register XSControl_FuncShape in _XSControl:
_XSControl.XSControl_FuncShape_swigregister(XSControl_FuncShape)
class XSControl_Functions(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Init(*args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Defines and loads all functions for xscontrol (as actfunc).

        """
        return _XSControl.XSControl_Functions_Init(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _XSControl.XSControl_Functions_swiginit(self, _XSControl.new_XSControl_Functions())
    __swig_destroy__ = _XSControl.delete_XSControl_Functions

# Register XSControl_Functions in _XSControl:
_XSControl.XSControl_Functions_swigregister(XSControl_Functions)
class XSControl_Reader(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a reader from scratch (creates an empty worksession) a worksession or a controller must be provided before running.

        Parameters
        ----------
        norm: str

        Return
        -------
        None

        Description
        -----------
        Creates a reader from scratch, with a norm name which identifies a controller.

        Parameters
        ----------
        WS: XSControl_WorkSession
        scratch: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates a reader from an already existing session, with a controller already set virtual destructor.

        """
        _XSControl.XSControl_Reader_swiginit(self, _XSControl.new_XSControl_Reader(*args))

    def ClearShapes(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the list of shapes that may have accumulated in calls to transferone or transferroot.c.

        """
        return _XSControl.XSControl_Reader_ClearShapes(self, *args)

    def GetStatsTransfer(self, *args):
        r"""

        Parameters
        ----------
        list: TColStd_HSequenceOfTransient

        Return
        -------
        nbMapped: int
        nbWithResult: int
        nbWithFail: int

        Description
        -----------
        Gives statistics about transfer.

        """
        return _XSControl.XSControl_Reader_GetStatsTransfer(self, *args)

    def GiveList(self, *args):
        r"""

        Parameters
        ----------
        first: str (optional, default to )
        second: str (optional, default to )

        Return
        -------
        opencascade::handle<TColStd_HSequenceOfTransient>

        Description
        -----------
        Returns a list of entities from the iges or step file according to the following rules: - if first and second are empty strings, the whole file is selected. - if first is an entity number or label, the entity referred to is selected. - if first is a list of entity numbers/labels separated by commas, the entities referred to are selected, - if first is the name of a selection in the worksession and second is not defined, the list contains the standard output for that selection. - if first is the name of a selection and second is defined, the criterion defined by second is applied to the result of the first selection. a selection is an operator which computes a list of entities from a list given in input according to its type. if no list is specified, the selection computes its list of entities from the whole model. a selection can be: - a predefined selection (xst-transferrable-mode) - a filter based on a signature a signature is an operator which returns a string from an entity according to its type. for example: - 'xst-type' (cdl) - 'iges-level' - 'step-type'. for example, if you wanted to select only the advanced_faces in a step file you would use the following code: example reader.givelist('xst-transferrable-roots','step-type(advanced_face)'); warning if the value given to second is incorrect, it will simply be ignored.

        Parameters
        ----------
        first: str
        ent: Standard_Transient

        Return
        -------
        opencascade::handle<TColStd_HSequenceOfTransient>

        Description
        -----------
        Computes a list of entities from the model as follows <first> being a selection, <ent> being an entity or a list of entities (as a hsequenceoftransient): the standard result of this selection applied to this list if <first> is erroneous, a null handle is returned.

        """
        return _XSControl.XSControl_Reader_GiveList(self, *args)

    def Model(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_InterfaceModel>

        Description
        -----------
        Returns the model. it can then be consulted (header, product).

        """
        return _XSControl.XSControl_Reader_Model(self, *args)

    def NbRootsForTransfer(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Determines the list of root entities which are candidate for a transfer to a shape, and returns the number of entities in the list.

        """
        return _XSControl.XSControl_Reader_NbRootsForTransfer(self, *args)

    def NbShapes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of shapes produced by translation.

        """
        return _XSControl.XSControl_Reader_NbShapes(self, *args)

    def OneShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns all of the results in a single shape which is: - a null shape if there are no results, - a shape if there is one result, - a compound containing the resulting shapes if there are more than one.

        """
        return _XSControl.XSControl_Reader_OneShape(self, *args)

    def PrintCheckLoad(self, *args):
        r"""

        Parameters
        ----------
        failsonly: bool
        mode: IFSelect_PrintCount

        Return
        -------
        None

        Description
        -----------
        Prints the check list attached to loaded data, on the standard trace file (starts at std::cout) all messages or fails only, according to <failsonly> mode = 0: per entity, prints messages mode = 1: per message, just gives count of entities per check mode = 2: also gives entity numbers.

        """
        return _XSControl.XSControl_Reader_PrintCheckLoad(self, *args)

    def PrintCheckTransfer(self, *args):
        r"""

        Parameters
        ----------
        failsonly: bool
        mode: IFSelect_PrintCount

        Return
        -------
        None

        Description
        -----------
        Displays check results for the last translation of iges or step entities to open cascade entities. only fail messages are displayed if failsonly is true. all messages are displayed if failsonly is false. mode determines the contents and the order of the messages according to the terms of the ifselect_printcount enumeration.

        """
        return _XSControl.XSControl_Reader_PrintCheckTransfer(self, *args)

    def PrintStatsTransfer(self, *args):
        r"""

        Parameters
        ----------
        what: int
        mode: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Displays the statistics for the last translation. what defines the kind of statistics that are displayed as follows: - 0 gives general statistics (number of translated roots, number of warnings, number of fail messages), - 1 gives root results, - 2 gives statistics for all checked entities, - 3 gives the list of translated entities, - 4 gives warning and fail messages, - 5 gives fail messages only. the use of mode depends on the value of what. if what is 0, mode is ignored. if what is 1, 2 or 3, mode defines the following: - 0 lists the numbers of iges or step entities in the respective model - 1 gives the number, identifier, type and result type for each iges or step entity and/or its status (fail, warning, etc.) - 2 gives maximum information for each iges or step entity (i.e. checks) - 3 gives the number of entities per type of iges or step entity - 4 gives the number of iges or step entities per result type and/or status - 5 gives the number of pairs (iges or step or result type and status) - 6 gives the number of pairs (iges or step or result type and status) and the list of entity numbers in the iges or step model. if what is 4 or 5, mode defines the warning and fail messages as follows: - if mode is 0 all warnings and checks per entity are returned - if mode is 2 the list of entities per warning is returned. if mode is not set, only the list of all entities per warning is given.

        """
        return _XSControl.XSControl_Reader_PrintStatsTransfer(self, *args)

    def ReadFile(self, *args):
        r"""

        Parameters
        ----------
        filename: str

        Return
        -------
        IFSelect_ReturnStatus

        Description
        -----------
        Loads a file and returns the read status zero for a model which compies with the controller.

        """
        return _XSControl.XSControl_Reader_ReadFile(self, *args)

    def ReadStream(self, *args):
        r"""

        Parameters
        ----------
        theName: str
        theIStream: std::istream

        Return
        -------
        IFSelect_ReturnStatus

        Description
        -----------
        Loads a file from stream and returns the read status.

        """
        return _XSControl.XSControl_Reader_ReadStream(self, *args)

    def RootForTransfer(self, *args):
        r"""

        Parameters
        ----------
        num: int (optional, default to 1)

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns an iges or step root entity for translation. the entity is identified by its rank in a list.

        """
        return _XSControl.XSControl_Reader_RootForTransfer(self, *args)

    def SetNorm(self, *args):
        r"""

        Parameters
        ----------
        norm: str

        Return
        -------
        bool

        Description
        -----------
        Sets a specific norm to <self> returns true if done, false if <norm> is not available.

        """
        return _XSControl.XSControl_Reader_SetNorm(self, *args)

    def SetWS(self, *args):
        r"""

        Parameters
        ----------
        WS: XSControl_WorkSession
        scratch: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Sets a specific session to <self>.

        """
        return _XSControl.XSControl_Reader_SetWS(self, *args)

    def Shape(self, *args):
        r"""

        Parameters
        ----------
        num: int (optional, default to 1)

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the shape resulting from a translation and identified by the rank num. num equals 1 by default. in other words, the first shape resulting from the translation is returned.

        """
        return _XSControl.XSControl_Reader_Shape(self, *args)

    def TransferEntity(self, *args):
        r"""

        Parameters
        ----------
        start: Standard_Transient
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Translates an iges or step entity in the model. true is returned if a shape is produced; otherwise, false is returned.

        """
        return _XSControl.XSControl_Reader_TransferEntity(self, *args)

    def TransferList(self, *args):
        r"""

        Parameters
        ----------
        list: TColStd_HSequenceOfTransient
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        int

        Description
        -----------
        Translates a list of entities. returns the number of iges or step entities that were successfully translated. the list can be produced with givelist. warning - this function does not clear the existing output shapes.

        """
        return _XSControl.XSControl_Reader_TransferList(self, *args)

    def TransferOne(self, *args):
        r"""

        Parameters
        ----------
        num: int
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Translates an iges or step entity identified by the rank num in the model. false is returned if no shape is produced.

        """
        return _XSControl.XSControl_Reader_TransferOne(self, *args)

    def TransferOneRoot(self, *args):
        r"""

        Parameters
        ----------
        num: int (optional, default to 1)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        bool

        Description
        -----------
        Translates a root identified by the rank num in the model. false is returned if no shape is produced.

        """
        return _XSControl.XSControl_Reader_TransferOneRoot(self, *args)

    def TransferRoots(self, *args):
        r"""

        Parameters
        ----------
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        int

        Description
        -----------
        Translates all translatable roots and returns the number of successful translations. warning - this function clears existing output shapes first.

        """
        return _XSControl.XSControl_Reader_TransferRoots(self, *args)

    def WS(self, *args):
        r"""
        Return
        -------
        opencascade::handle<XSControl_WorkSession>

        Description
        -----------
        Returns the session used in <self>.

        """
        return _XSControl.XSControl_Reader_WS(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_Reader

# Register XSControl_Reader in _XSControl:
_XSControl.XSControl_Reader_swigregister(XSControl_Reader)
class XSControl_SelectForTransfer(OCC.Core.IFSelect.IFSelect_SelectExtract):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a selectfortransfer, non initialised it sorts nothing, unless an actor has been defined.

        Parameters
        ----------
        TR: XSControl_TransferReader

        Return
        -------
        None

        Description
        -----------
        Creates a selectfortransfer, which will work with the currently defined actor brought by the transferreader.

        """
        _XSControl.XSControl_SelectForTransfer_swiginit(self, _XSControl.new_XSControl_SelectForTransfer(*args))

    def Actor(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Transfer_ActorOfTransientProcess>

        Description
        -----------
        Returns the actor used as precised one. returns a null handle for a creation from a transferreader without any further setting.

        """
        return _XSControl.XSControl_SelectForTransfer_Actor(self, *args)

    def Reader(self, *args):
        r"""
        Return
        -------
        opencascade::handle<XSControl_TransferReader>

        Description
        -----------
        Returns the reader (if created with a reader) returns a null handle if not created with a reader.

        """
        return _XSControl.XSControl_SelectForTransfer_Reader(self, *args)

    def SetActor(self, *args):
        r"""

        Parameters
        ----------
        act: Transfer_ActorOfTransientProcess

        Return
        -------
        None

        Description
        -----------
        Sets a precise actor to sort entities this definition oversedes the creation with a transferreader.

        """
        return _XSControl.XSControl_SelectForTransfer_SetActor(self, *args)

    def SetReader(self, *args):
        r"""

        Parameters
        ----------
        TR: XSControl_TransferReader

        Return
        -------
        None

        Description
        -----------
        Sets a transferreader to sort entities: it brings the actor, which may change, while the transferreader does not.

        """
        return _XSControl.XSControl_SelectForTransfer_SetReader(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_XSControl_SelectForTransfer_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_SelectForTransfer

# Register XSControl_SelectForTransfer in _XSControl:
_XSControl.XSControl_SelectForTransfer_swigregister(XSControl_SelectForTransfer)
class XSControl_SignTransferStatus(OCC.Core.IFSelect.IFSelect_Signature):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a signtransferstatus, not initialised it gives nothing (empty string).

        Parameters
        ----------
        TR: XSControl_TransferReader

        Return
        -------
        None

        Description
        -----------
        Creates a signtransferstatus, which will work on the current transientprocess brought by the transferreader (its mapreader).

        """
        _XSControl.XSControl_SignTransferStatus_swiginit(self, _XSControl.new_XSControl_SignTransferStatus(*args))

    def Map(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Transfer_TransientProcess>

        Description
        -----------
        Returns the transientprocess used as precised one returns a null handle for a creation from a transferreader without any further setting.

        """
        return _XSControl.XSControl_SignTransferStatus_Map(self, *args)

    def Reader(self, *args):
        r"""
        Return
        -------
        opencascade::handle<XSControl_TransferReader>

        Description
        -----------
        Returns the reader (if created with a reader) returns a null handle if not created with a reader.

        """
        return _XSControl.XSControl_SignTransferStatus_Reader(self, *args)

    def SetMap(self, *args):
        r"""

        Parameters
        ----------
        TP: Transfer_TransientProcess

        Return
        -------
        None

        Description
        -----------
        Sets a precise map to sign entities this definition oversedes the creation with a transferreader.

        """
        return _XSControl.XSControl_SignTransferStatus_SetMap(self, *args)

    def SetReader(self, *args):
        r"""

        Parameters
        ----------
        TR: XSControl_TransferReader

        Return
        -------
        None

        Description
        -----------
        Sets a transferreader to work.

        """
        return _XSControl.XSControl_SignTransferStatus_SetReader(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_XSControl_SignTransferStatus_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_SignTransferStatus

# Register XSControl_SignTransferStatus in _XSControl:
_XSControl.XSControl_SignTransferStatus_swigregister(XSControl_SignTransferStatus)
class XSControl_TransferReader(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a transferreader, empty.

        """
        _XSControl.XSControl_TransferReader_swiginit(self, _XSControl.new_XSControl_TransferReader(*args))

    def Actor(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Transfer_ActorOfTransientProcess>

        Description
        -----------
        Returns the actor, determined by the controller, or if this one is unknown, directly set. once it has been defined, it can then be edited.

        """
        return _XSControl.XSControl_TransferReader_Actor(self, *args)

    def BeginTransfer(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Defines a new transferprocess for reading transfer returns true if done, false if data are not properly defined (the model, the actor for read).

        """
        return _XSControl.XSControl_TransferReader_BeginTransfer(self, *args)

    def CheckList(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient
        theLevel: int (optional, default to 0)

        Return
        -------
        Interface_CheckIterator

        Description
        -----------
        Returns the checklist resulting from transferring <ent>, i.e. stored in its recorded form resultfrommodel (empty if transfer successful or not recorded ...) //! if <ent> is the model, returns the complete cumulated check-list, <level> is ignored //! if <ent> is an entity of the model, <level> applies as follows <level>: -1 for <ent> only, last transfer (transientprocess) <level>: 0 for <ent> only (d) 1 for <ent> and its immediate subtransfers, if any 2 for <ent> and subtransferts at all levels.

        """
        return _XSControl.XSControl_TransferReader_CheckList(self, *args)

    def CheckedList(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient
        WithCheck: Interface_CheckStatus (optional, default to Interface_CheckAny)
        theResult: bool (optional, default to Standard_True)

        Return
        -------
        opencascade::handle<TColStd_HSequenceOfTransient>

        Description
        -----------
        Returns the list of starting entities to which a given check status is attached, in final results <ent> can be an entity, or the model to query all entities below, 'entities' are, either <ent> plus its sub-transferred, or all the entities of the model //! <check> = -2 , all entities whatever the check (see result) <check> = -1 , entities with no fail (warning allowed) <check> = 0 , entities with no check at all <check> = 1 , entities with warning but no fail <check> = 2 , entities with fail <result>: if true, only entities with an attached result remark: result true and check=0 will give an empty list.

        """
        return _XSControl.XSControl_TransferReader_CheckedList(self, *args)

    def Clear(self, *args):
        r"""

        Parameters
        ----------
        theMode: int

        Return
        -------
        None

        Description
        -----------
        Clears data, according mode: -1 all 0 nothing done +1 final results +2 working data (model, context, transfer process).

        """
        return _XSControl.XSControl_TransferReader_Clear(self, *args)

    def ClearResult(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient
        theMode: int

        Return
        -------
        bool

        Description
        -----------
        Clears recorded result for an entity, according mode <mode> = -1: true, complete, clearing (erasing result) <mode> >= 0: simple 'stripping', see resultfrommodel, in particular, 0 for simple internal strip, 10 for all but final result, 11 for all: just label, status and filename are kept returns true when done, false if nothing was to clear.

        """
        return _XSControl.XSControl_TransferReader_ClearResult(self, *args)

    def Context(self, *args):
        r"""
        Return
        -------
        NCollection_DataMap<TCollection_AsciiString, opencascade::handle<Standard_Transient>>

        Description
        -----------
        Returns (modifiable) the whole definition of context rather for internal use (ex.: preparing and setting in once).

        """
        return _XSControl.XSControl_TransferReader_Context(self, *args)

    def EntitiesFromShapeList(self, *args):
        r"""

        Parameters
        ----------
        theRes: TopTools_HSequenceOfShape
        theMode: int (optional, default to 0)

        Return
        -------
        opencascade::handle<TColStd_HSequenceOfTransient>

        Description
        -----------
        Returns the list of entities from which some shapes were produced: it corresponds to a loop on entityfromshaperesult, but is optimised.

        """
        return _XSControl.XSControl_TransferReader_EntitiesFromShapeList(self, *args)

    def EntityFromResult(self, *args):
        r"""

        Parameters
        ----------
        theRes: Standard_Transient
        theMode: int (optional, default to 0)

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns an entity from which a given result was produced. if <mode> = 0 (d), searches in last root transfers if <mode> = 1, searches in last (root & sub) transfers if <mode> = 2, searches in root recorded results if <mode> = 3, searches in all (root & sub) recordeds <res> can be, either a transient object (result itself) or a binder. for a binder of shape, calls entityfromshaperesult returns a null handle if <res> not recorded.

        """
        return _XSControl.XSControl_TransferReader_EntityFromResult(self, *args)

    def EntityFromShapeResult(self, *args):
        r"""

        Parameters
        ----------
        theRes: TopoDS_Shape
        theMode: int (optional, default to 0)

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns an entity from which a given shape result was produced returns a null handle if <res> not recorded or not a shape.

        """
        return _XSControl.XSControl_TransferReader_EntityFromShapeResult(self, *args)

    def FileName(self, *args):
        r"""
        Return
        -------
        str

        Description
        -----------
        Returns actual value of file name.

        """
        return _XSControl.XSControl_TransferReader_FileName(self, *args)

    def FinalEntityLabel(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        str

        Description
        -----------
        Returns the label attached to an entity recorded for final, or an empty string if not recorded.

        """
        return _XSControl.XSControl_TransferReader_FinalEntityLabel(self, *args)

    def FinalEntityNumber(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        int

        Description
        -----------
        Returns the number attached to the entity recorded for final, or zero if not recorded (looks in the resultfrommodel).

        """
        return _XSControl.XSControl_TransferReader_FinalEntityNumber(self, *args)

    def FinalResult(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        opencascade::handle<Transfer_ResultFromModel>

        Description
        -----------
        Returns the final result recorded for an entity, as such.

        """
        return _XSControl.XSControl_TransferReader_FinalResult(self, *args)

    def GetContext(self, *args):
        r"""

        Parameters
        ----------
        theName: str
        theType: Standard_Type
        theCtx: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Returns the context attached to a name, if set and if it is kind of the type, else a null handle returns true if ok, false if no context.

        """
        return _XSControl.XSControl_TransferReader_GetContext(self, *args)

    def HasChecks(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient
        FailsOnly: bool

        Return
        -------
        bool

        Description
        -----------
        Returns true if an entity (with a final result) has checks: - failsonly = false: any kind of check message - failsonly = true: fails only returns false if <ent> is not recorded.

        """
        return _XSControl.XSControl_TransferReader_HasChecks(self, *args)

    def HasResult(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Returns true if a final result is recorded and brings an effective result (else, it brings only fail messages).

        """
        return _XSControl.XSControl_TransferReader_HasResult(self, *args)

    def IsMarked(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Returns true if an entity has been asked for transfert, hence it is marked, as: recorded (a computation has ran, with or without an effective result), or skipped (case ignored).

        """
        return _XSControl.XSControl_TransferReader_IsMarked(self, *args)

    def IsRecorded(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Returns true if a final result is recorded for an entity remark that it can bring no effective result if transfer has completely failed (finalresult brings only fail messages ...).

        """
        return _XSControl.XSControl_TransferReader_IsRecorded(self, *args)

    def IsSkipped(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Returns true if an entity is noted as skipped.

        """
        return _XSControl.XSControl_TransferReader_IsSkipped(self, *args)

    def LastCheckList(self, *args):
        r"""
        Return
        -------
        Interface_CheckIterator

        Description
        -----------
        Returns the checklist resulting from last transferread i.e. from transientprocess itself, recorded from last clear.

        """
        return _XSControl.XSControl_TransferReader_LastCheckList(self, *args)

    def LastTransferList(self, *args):
        r"""

        Parameters
        ----------
        theRoots: bool

        Return
        -------
        opencascade::handle<TColStd_HSequenceOfTransient>

        Description
        -----------
        Returns the list of entities recorded as lastly transferred i.e. from transientprocess itself, recorded from last clear if <roots> is true , considers only roots of transfer if <roots> is false, considers all entities bound with result.

        """
        return _XSControl.XSControl_TransferReader_LastTransferList(self, *args)

    def Model(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_InterfaceModel>

        Description
        -----------
        Returns the currently set interfacemodel.

        """
        return _XSControl.XSControl_TransferReader_Model(self, *args)

    @staticmethod
    def PrintStatsOnList(*args):
        r"""

        Parameters
        ----------
        theTP: Transfer_TransientProcess
        theList: TColStd_HSequenceOfTransient
        theWhat: int
        theMode: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Works as printstatsprocess, but displays data only on the entities which are in <list> (filter).

        """
        return _XSControl.XSControl_TransferReader_PrintStatsOnList(*args)

    @staticmethod
    def PrintStatsProcess(*args):
        r"""

        Parameters
        ----------
        theTP: Transfer_TransientProcess
        theWhat: int
        theMode: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        This routines prints statistics about a transientprocess it can be called, by a transferreader, or isolately prints are done on the default trace file <what> defines what kind of statistics are to be printed: 0: basic figures 1: root results 2: all recorded (roots, intermediate, checked entities) 3: abnormal records 4: check messages (warnings and fails) 5: fail messages //! <mode> is used according <what>: <what> = 0: <mode> is ignored <what> = 1,2,3: <mode> as follows: 0 (d): just lists numbers of concerned entities in the model 1: for each entity, gives number,label, type and result type and/or status (fail/warning...) 2: for each entity, gives maximal information (i.e. checks) 3: counts per type of starting entity (class type) 4: counts per result type and/or status 5: counts per couple (starting type / result type/status) 6: idem plus gives for each item, the list of numbers of entities in the starting model //! <what> = 4,5: modes relays on an enum printcount: 0 (d): itemsbyentity (sequential list by entity) 1: countbyitem 2: shortbyitem (count + 5 first numbers) 3: listbyitem (count + entity numbers) 4: entitiesbyitem (count + entity numbers and labels).

        """
        return _XSControl.XSControl_TransferReader_PrintStatsProcess(*args)

    def Recognize(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Tells if an entity is recognized as a valid candidate for transfer. calls method recognize from the actor (if known).

        """
        return _XSControl.XSControl_TransferReader_Recognize(self, *args)

    def RecordResult(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Records a final result of transferring an entity this result is recorded as a resultfrommodel, taken from the transientprocess returns true if a result is available, false else.

        """
        return _XSControl.XSControl_TransferReader_RecordResult(self, *args)

    def RecordedList(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfTransient>

        Description
        -----------
        Returns the list of entities to which a final result is attached (i.e. processed by recordresult).

        """
        return _XSControl.XSControl_TransferReader_RecordedList(self, *args)

    def ResultFromNumber(self, *args):
        r"""

        Parameters
        ----------
        theNum: int

        Return
        -------
        opencascade::handle<Transfer_ResultFromModel>

        Description
        -----------
        Returns the final result recorded for a number of entity (internal use). null if out of range.

        """
        return _XSControl.XSControl_TransferReader_ResultFromNumber(self, *args)

    def SetActor(self, *args):
        r"""

        Parameters
        ----------
        theActor: Transfer_ActorOfTransientProcess

        Return
        -------
        None

        Description
        -----------
        Sets the actor directly: this value will be used if the controller is not set.

        """
        return _XSControl.XSControl_TransferReader_SetActor(self, *args)

    def SetContext(self, *args):
        r"""

        Parameters
        ----------
        theName: str
        theCtx: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        Sets a context: according to receiving appli, to be interpreted by the actor.

        """
        return _XSControl.XSControl_TransferReader_SetContext(self, *args)

    def SetController(self, *args):
        r"""

        Parameters
        ----------
        theControl: XSControl_Controller

        Return
        -------
        None

        Description
        -----------
        Sets a controller. it is required to generate the actor. elsewhere, the actor must be provided directly.

        """
        return _XSControl.XSControl_TransferReader_SetController(self, *args)

    def SetFileName(self, *args):
        r"""

        Parameters
        ----------
        theName: str

        Return
        -------
        None

        Description
        -----------
        Sets a new value for (loaded) file name.

        """
        return _XSControl.XSControl_TransferReader_SetFileName(self, *args)

    def SetGraph(self, *args):
        r"""

        Parameters
        ----------
        theGraph: Interface_HGraph

        Return
        -------
        None

        Description
        -----------
        Sets a graph and its interfacemodel (calls setmodel).

        """
        return _XSControl.XSControl_TransferReader_SetGraph(self, *args)

    def SetModel(self, *args):
        r"""

        Parameters
        ----------
        theModel: Interface_InterfaceModel

        Return
        -------
        None

        Description
        -----------
        Sets an interfacemodel. this causes former results, computed from another one, to be lost (see also clear).

        """
        return _XSControl.XSControl_TransferReader_SetModel(self, *args)

    def SetTransientProcess(self, *args):
        r"""

        Parameters
        ----------
        theTP: Transfer_TransientProcess

        Return
        -------
        None

        Description
        -----------
        Forces the transientprocess remark: it also changes the model and the actor, from those recorded in the new transientprocess.

        """
        return _XSControl.XSControl_TransferReader_SetTransientProcess(self, *args)

    def ShapeResult(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the resulting object as a shape null shape if no result or result not a shape.

        """
        return _XSControl.XSControl_TransferReader_ShapeResult(self, *args)

    def ShapeResultList(self, *args):
        r"""

        Parameters
        ----------
        theRec: bool

        Return
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        Description
        -----------
        Returns a list of result shapes if <rec> is true , sees recordedlist if <rec> is false, sees lasttransferlist (last root transfers) for each one, if it is a shape, it is cumulated to the list if no shape is found, returns an empty sequence.

        """
        return _XSControl.XSControl_TransferReader_ShapeResultList(self, *args)

    def Skip(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Note that an entity has been required for transfer but no result at all is available (typically: case not implemented) it is not an error, but it gives a specific status: skipped returns true if done, false if <ent> is not in starting model.

        """
        return _XSControl.XSControl_TransferReader_Skip(self, *args)

    def TransferClear(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient
        theLevel: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Clears the results attached to an entity if <ents> equates the starting model, clears all results.

        """
        return _XSControl.XSControl_TransferReader_TransferClear(self, *args)

    def TransferList(self, *args):
        r"""

        Parameters
        ----------
        theList: TColStd_HSequenceOfTransient
        theRec: bool (optional, default to Standard_True)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        int

        Description
        -----------
        Commands the transfer on reading for a list of entities to data for imagine, using the selected actor for read returns count of transferred entities, ok or with fails (0/1) if <rec> is true (d), the results are recorded by recordresult.

        """
        return _XSControl.XSControl_TransferReader_TransferList(self, *args)

    def TransferOne(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient
        theRec: bool (optional, default to Standard_True)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        int

        Description
        -----------
        Commands the transfer on reading for an entity to data for imagine, using the selected actor for read returns count of transferred entities, ok or with fails (0/1) if <rec> is true (d), the result is recorded by recordresult.

        """
        return _XSControl.XSControl_TransferReader_TransferOne(self, *args)

    def TransferRoots(self, *args):
        r"""

        Parameters
        ----------
        theGraph: Interface_Graph
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        int

        Description
        -----------
        Transfers the content of the current interface model to data handled by imagine, starting from its roots (determined by the graph <g>), using the selected actor for read returns the count of performed root transfers (i.e. 0 if none) or -1 if no actor is defined.

        """
        return _XSControl.XSControl_TransferReader_TransferRoots(self, *args)

    def TransientProcess(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Transfer_TransientProcess>

        Description
        -----------
        Returns the currently used transientprocess it is computed from the model by transferreadroots, or by begintransferread.

        """
        return _XSControl.XSControl_TransferReader_TransientProcess(self, *args)

    def TransientResult(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns the resulting object as a transient null handle if no result or result not transient.

        """
        return _XSControl.XSControl_TransferReader_TransientResult(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_XSControl_TransferReader_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_TransferReader

# Register XSControl_TransferReader in _XSControl:
_XSControl.XSControl_TransferReader_swigregister(XSControl_TransferReader)
class XSControl_TransferWriter(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a transferwriter, empty, ready to run with an empty finderprocess (but no controller, etc).

        """
        _XSControl.XSControl_TransferWriter_swiginit(self, _XSControl.new_XSControl_TransferWriter(*args))

    def CheckList(self, *args):
        r"""
        Return
        -------
        Interface_CheckIterator

        Description
        -----------
        Returns the check-list of last transfer (write), i.e. the check-list currently recorded in the finderprocess.

        """
        return _XSControl.XSControl_TransferWriter_CheckList(self, *args)

    def Clear(self, *args):
        r"""

        Parameters
        ----------
        theMode: int

        Return
        -------
        None

        Description
        -----------
        Clears recorded data according a mode 0 clears finderprocess (results, checks) -1 create a new finderprocess.

        """
        return _XSControl.XSControl_TransferWriter_Clear(self, *args)

    def Controller(self, *args):
        r"""
        Return
        -------
        opencascade::handle<XSControl_Controller>

        Description
        -----------
        Returns the currently used controller.

        """
        return _XSControl.XSControl_TransferWriter_Controller(self, *args)

    def FinderProcess(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Transfer_FinderProcess>

        Description
        -----------
        Returns the finderprocess itself.

        """
        return _XSControl.XSControl_TransferWriter_FinderProcess(self, *args)

    def PrintStats(self, *args):
        r"""

        Parameters
        ----------
        theWhat: int
        theMode: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Prints statistics on current trace file, according what,mode see printstatsprocess for details.

        """
        return _XSControl.XSControl_TransferWriter_PrintStats(self, *args)

    def RecognizeShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape

        Return
        -------
        bool

        Description
        -----------
        Tells if a shape is valid for a transfer to a model asks the controller (recognizewriteshape).

        """
        return _XSControl.XSControl_TransferWriter_RecognizeShape(self, *args)

    def RecognizeTransient(self, *args):
        r"""

        Parameters
        ----------
        theObj: Standard_Transient

        Return
        -------
        bool

        Description
        -----------
        Tells if a transient object (from an application) is a valid candidate for a transfer to a model asks the controller (recognizewritetransient) if <obj> is a hshape, calls recognizeshape.

        """
        return _XSControl.XSControl_TransferWriter_RecognizeTransient(self, *args)

    def ResultCheckList(self, *args):
        r"""

        Parameters
        ----------
        theModel: Interface_InterfaceModel

        Return
        -------
        Interface_CheckIterator

        Description
        -----------
        Returns the check-list of last transfer (write), but tries to bind to each check, the resulting entity in the model instead of keeping the original mapper, whenever known.

        """
        return _XSControl.XSControl_TransferWriter_ResultCheckList(self, *args)

    def SetController(self, *args):
        r"""

        Parameters
        ----------
        theCtl: XSControl_Controller

        Return
        -------
        None

        Description
        -----------
        Sets a new controller, also sets a new finderprocess.

        """
        return _XSControl.XSControl_TransferWriter_SetController(self, *args)

    def SetFinderProcess(self, *args):
        r"""

        Parameters
        ----------
        theFP: Transfer_FinderProcess

        Return
        -------
        None

        Description
        -----------
        Sets a new finderprocess and forgets the former one.

        """
        return _XSControl.XSControl_TransferWriter_SetFinderProcess(self, *args)

    def SetTransferMode(self, *args):
        r"""

        Parameters
        ----------
        theMode: int

        Return
        -------
        None

        Description
        -----------
        Changes the transfer mode.

        """
        return _XSControl.XSControl_TransferWriter_SetTransferMode(self, *args)

    def TransferMode(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the current transfer mode (an integer) it will be interpreted by the controller to run transfers this call form could be later replaced by more specific ones (parameters suited for each norm / transfer case).

        """
        return _XSControl.XSControl_TransferWriter_TransferMode(self, *args)

    def TransferWriteShape(self, *args):
        r"""

        Parameters
        ----------
        theModel: Interface_InterfaceModel
        theShape: TopoDS_Shape
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        IFSelect_ReturnStatus

        Description
        -----------
        Transfers a shape from cascade to a model of current norm, according to the last call to settransfermode works by calling the controller returns status: =0 if ok, >0 if error during transfer, <0 if transfer badly initialised.

        """
        return _XSControl.XSControl_TransferWriter_TransferWriteShape(self, *args)

    def TransferWriteTransient(self, *args):
        r"""

        Parameters
        ----------
        theModel: Interface_InterfaceModel
        theObj: Standard_Transient
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        IFSelect_ReturnStatus

        Description
        -----------
        Transfers a transient object (from an application) to a model of current norm, according to the last call to settransfermode works by calling the controller returns status: =0 if ok, >0 if error during transfer, <0 if transfer badly initialised.

        """
        return _XSControl.XSControl_TransferWriter_TransferWriteTransient(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_XSControl_TransferWriter_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_TransferWriter

# Register XSControl_TransferWriter in _XSControl:
_XSControl.XSControl_TransferWriter_swigregister(XSControl_TransferWriter)
class XSControl_Utils(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The only use of this, is to allow a frontal to get one distinct 'utils' set per separate engine.

        """
        _XSControl.XSControl_Utils_swiginit(self, _XSControl.new_XSControl_Utils(*args))

    def AppendCStr(self, *args):
        r"""

        Parameters
        ----------
        seqval: TColStd_HSequenceOfHAsciiString
        strval: str

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_AppendCStr(self, *args)

    def AppendEStr(self, *args):
        r"""

        Parameters
        ----------
        seqval: TColStd_HSequenceOfHExtendedString
        strval: Standard_ExtString

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_AppendEStr(self, *args)

    def AppendShape(self, *args):
        r"""

        Parameters
        ----------
        seqv: TopTools_HSequenceOfShape
        shape: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_AppendShape(self, *args)

    def AppendTra(self, *args):
        r"""

        Parameters
        ----------
        seqval: TColStd_HSequenceOfTransient
        traval: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_AppendTra(self, *args)

    def ArrToSeq(self, *args):
        r"""

        Parameters
        ----------
        arr: Standard_Transient

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_ArrToSeq(self, *args)

    def AsciiToExtended(self, *args):
        r"""

        Parameters
        ----------
        str: str

        Return
        -------
        Standard_ExtString

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_AsciiToExtended(self, *args)

    def BinderShape(self, *args):
        r"""

        Parameters
        ----------
        tr: Standard_Transient

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        From a transient, returns a shape. in fact, recognizes shapebinder shapemapper and hshape.

        """
        return _XSControl.XSControl_Utils_BinderShape(self, *args)

    def CStrValue(self, *args):
        r"""

        Parameters
        ----------
        list: Standard_Transient
        num: int

        Return
        -------
        str

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_CStrValue(self, *args)

    def CompoundFromSeq(self, *args):
        r"""

        Parameters
        ----------
        seqval: TopTools_HSequenceOfShape

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Converts a list of shapes to a compound (a kind of shape).

        """
        return _XSControl.XSControl_Utils_CompoundFromSeq(self, *args)

    def DateString(self, *args):
        r"""

        Parameters
        ----------
        yy: int
        mm: int
        dd: int
        hh: int
        mn: int
        ss: int

        Return
        -------
        str

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_DateString(self, *args)

    def DateValues(self, *args):
        r"""

        Parameters
        ----------
        text: str

        Return
        -------
        yy: int
        mm: int
        dd: int
        hh: int
        mn: int
        ss: int

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_DateValues(self, *args)

    def EStrValue(self, *args):
        r"""

        Parameters
        ----------
        list: Standard_Transient
        num: int

        Return
        -------
        Standard_ExtString

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_EStrValue(self, *args)

    def ExtendedToAscii(self, *args):
        r"""

        Parameters
        ----------
        str: Standard_ExtString

        Return
        -------
        str

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_ExtendedToAscii(self, *args)

    def IsAscii(self, *args):
        r"""

        Parameters
        ----------
        str: Standard_ExtString

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_IsAscii(self, *args)

    def IsKind(self, *args):
        r"""

        Parameters
        ----------
        item: Standard_Transient
        what: Standard_Type

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_IsKind(self, *args)

    def NewSeqCStr(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfHAsciiString>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_NewSeqCStr(self, *args)

    def NewSeqEStr(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfHExtendedString>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_NewSeqEStr(self, *args)

    def NewSeqShape(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TopTools_HSequenceOfShape>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_NewSeqShape(self, *args)

    def NewSeqTra(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HSequenceOfTransient>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_NewSeqTra(self, *args)

    def SeqIntValue(self, *args):
        r"""

        Parameters
        ----------
        list: TColStd_HSequenceOfInteger
        num: int

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_SeqIntValue(self, *args)

    def SeqLength(self, *args):
        r"""

        Parameters
        ----------
        list: Standard_Transient

        Return
        -------
        int

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_SeqLength(self, *args)

    def SeqToArr(self, *args):
        r"""

        Parameters
        ----------
        seq: Standard_Transient
        first: int (optional, default to 1)

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_SeqToArr(self, *args)

    def ShapeBinder(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        hs: bool (optional, default to Standard_True)

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Creates a transient object from a shape: it is either a binder (used by functions which require a transient but can process a shape, such as viewing functions) or a hshape (according to hs) default is a hshape.

        """
        return _XSControl.XSControl_Utils_ShapeBinder(self, *args)

    def ShapeType(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        compound: bool

        Return
        -------
        TopAbs_ShapeEnum

        Description
        -----------
        Returns the type of a shape: true type if <compound> is false if <compound> is true and <shape> is a compound, iterates on its items. if all are of the same type, returns this type. else, returns compound. if it is empty, returns shape for a null shape, returns shape.

        """
        return _XSControl.XSControl_Utils_ShapeType(self, *args)

    def ShapeValue(self, *args):
        r"""

        Parameters
        ----------
        seqv: TopTools_HSequenceOfShape
        num: int

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_ShapeValue(self, *args)

    def SortedCompound(self, *args):
        r"""

        Parameters
        ----------
        shape: TopoDS_Shape
        type: TopAbs_ShapeEnum
        explore: bool
        compound: bool

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        From a shape, builds a compound as follows: explores it level by level if <explore> is false, only compound items. else, all items adds to the result, shapes which comply to <type> + if <type> is wire, considers free edges (and makes wires) + if <type> is shell, considers free faces (and makes shells) if <compound> is true, gathers items in compounds which correspond to starting compound,solid or shell containers, or items directly contained in a compound.

        """
        return _XSControl.XSControl_Utils_SortedCompound(self, *args)

    def ToAString(self, *args):
        r"""

        Parameters
        ----------
        strcon: str

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_ToAString(self, *args)

    def ToCString(self, *args):
        r"""

        Parameters
        ----------
        strval: TCollection_HAsciiString

        Return
        -------
        str

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        strval: str

        Return
        -------
        str

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_ToCString(self, *args)

    def ToEString(self, *args):
        r"""

        Parameters
        ----------
        strval: TCollection_HExtendedString

        Return
        -------
        Standard_ExtString

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        strval: str

        Return
        -------
        Standard_ExtString

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_ToEString(self, *args)

    def ToHString(self, *args):
        r"""

        Parameters
        ----------
        strcon: str

        Return
        -------
        opencascade::handle<TCollection_HAsciiString>

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        strcon: Standard_ExtString

        Return
        -------
        opencascade::handle<TCollection_HExtendedString>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_ToHString(self, *args)

    def ToXString(self, *args):
        r"""

        Parameters
        ----------
        strcon: Standard_ExtString

        Return
        -------
        TCollection_ExtendedString

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_ToXString(self, *args)

    def TraValue(self, *args):
        r"""

        Parameters
        ----------
        list: Standard_Transient
        num: int

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Utils_TraValue(self, *args)

    def TraceLine(self, *args):
        r"""

        Parameters
        ----------
        line: str

        Return
        -------
        None

        Description
        -----------
        Just prints a line into the current trace file. this allows to better characterise the various trace outputs, as desired.

        """
        return _XSControl.XSControl_Utils_TraceLine(self, *args)

    def TraceLines(self, *args):
        r"""

        Parameters
        ----------
        lines: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        Just prints a line or a set of lines into the current trace file. <lines> can be a hascii/extendedstring (produces a print without ending line) or a hsequence or harray1 of .. (one new line per item).

        """
        return _XSControl.XSControl_Utils_TraceLines(self, *args)

    def TypeName(self, *args):
        r"""

        Parameters
        ----------
        item: Standard_Transient
        nopk: bool (optional, default to Standard_False)

        Return
        -------
        str

        Description
        -----------
        Returns the name of the dynamic type of an object, i.e.: if it is a type, its name if it is a object not a type, the name of its dynamictype if it is null, an empty string if <nopk> is false (d), gives complete name if <nopk> is true, returns class name without package.

        """
        return _XSControl.XSControl_Utils_TypeName(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_Utils

# Register XSControl_Utils in _XSControl:
_XSControl.XSControl_Utils_swigregister(XSControl_Utils)
class XSControl_Vars(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _XSControl.XSControl_Vars_swiginit(self, _XSControl.new_XSControl_Vars(*args))

    def Get(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_Get(self, *args)

    def GetCurve(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        opencascade::handle<Geom_Curve>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_GetCurve(self, *args)

    def GetCurve2d(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        opencascade::handle<Geom2d_Curve>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_GetCurve2d(self, *args)

    def GetGeom(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        opencascade::handle<Geom_Geometry>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_GetGeom(self, *args)

    def GetPoint(self, *args):
        r"""

        Parameters
        ----------
        name: str
        pnt: gp_Pnt

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_GetPoint(self, *args)

    def GetPoint2d(self, *args):
        r"""

        Parameters
        ----------
        name: str
        pnt: gp_Pnt2d

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_GetPoint2d(self, *args)

    def GetShape(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        TopoDS_Shape

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_GetShape(self, *args)

    def GetSurface(self, *args):
        r"""

        Parameters
        ----------
        name: str

        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_GetSurface(self, *args)

    def Set(self, *args):
        r"""

        Parameters
        ----------
        name: str
        val: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_Set(self, *args)

    def SetPoint(self, *args):
        r"""

        Parameters
        ----------
        name: str
        val: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_SetPoint(self, *args)

    def SetPoint2d(self, *args):
        r"""

        Parameters
        ----------
        name: str
        val: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_SetPoint2d(self, *args)

    def SetShape(self, *args):
        r"""

        Parameters
        ----------
        name: str
        val: TopoDS_Shape

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_Vars_SetShape(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_XSControl_Vars_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_Vars

# Register XSControl_Vars in _XSControl:
_XSControl.XSControl_Vars_swigregister(XSControl_Vars)
class XSControl_WorkSession(OCC.Core.IFSelect.IFSelect_WorkSession):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _XSControl.XSControl_WorkSession_swiginit(self, _XSControl.new_XSControl_WorkSession(*args))

    def ClearContext(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the whole current context (nullifies it).

        """
        return _XSControl.XSControl_WorkSession_ClearContext(self, *args)

    def Context(self, *args):
        r"""
        Return
        -------
        NCollection_DataMap<TCollection_AsciiString, opencascade::handle<Standard_Transient>>

        Description
        -----------
        Returns the current context list, null if not defined the context is given to the transientprocess for transferread.

        """
        return _XSControl.XSControl_WorkSession_Context(self, *args)

    def InitTransferReader(self, *args):
        r"""

        Parameters
        ----------
        theMode: int

        Return
        -------
        None

        Description
        -----------
        Sets a transfer reader, by internal ways, according mode: 0 recreates it clear, 1 clears it (does not recreate) 2 aligns roots of transientprocess from final results 3 aligns final results from roots of transientprocess 4 begins a new transfer (by begintransfer) 5 recreates transferreader then begins a new transfer.

        """
        return _XSControl.XSControl_WorkSession_InitTransferReader(self, *args)

    def MapReader(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Transfer_TransientProcess>

        Description
        -----------
        Returns the transientprocess(internal data for transferreader).

        """
        return _XSControl.XSControl_WorkSession_MapReader(self, *args)

    def NewModel(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Interface_InterfaceModel>

        Description
        -----------
        Produces and returns a new model well conditioned it is produced by the norm controller it can be null (if this function is not implemented).

        """
        return _XSControl.XSControl_WorkSession_NewModel(self, *args)

    def NormAdaptor(self, *args):
        r"""
        Return
        -------
        opencascade::handle<XSControl_Controller>

        Description
        -----------
        Returns the norm controller itself.

        """
        return _XSControl.XSControl_WorkSession_NormAdaptor(self, *args)

    def Result(self, *args):
        r"""

        Parameters
        ----------
        theEnt: Standard_Transient
        theMode: int

        Return
        -------
        opencascade::handle<Standard_Transient>

        Description
        -----------
        Returns the result attached to a starting entity if <mode> = 0, returns final result if <mode> = 1, considers last result if <mode> = 2, considers final, else if absent, last returns it as transient, if result is not transient returns the binder <mode> = 10,11,12 idem but returns the binder itself (if it is not, e.g. shape, returns the binder) <mode> = 20, returns the resultfrommodel.

        """
        return _XSControl.XSControl_WorkSession_Result(self, *args)

    def SelectNorm(self, *args):
        r"""

        Parameters
        ----------
        theNormName: str

        Return
        -------
        bool

        Description
        -----------
        Selects a norm defined by its name. a norm is described and handled by a controller returns true if done, false if <normname> is unknown //! the current profile for this norm is taken.

        """
        return _XSControl.XSControl_WorkSession_SelectNorm(self, *args)

    def SelectedNorm(self, *args):
        r"""

        Parameters
        ----------
        theRsc: bool (optional, default to Standard_False)

        Return
        -------
        str

        Description
        -----------
        Returns the name of the last selected norm. if none is defined, returns an empty string by default, returns the complete name of the norm if <rsc> is true, returns the short name used for resource.

        """
        return _XSControl.XSControl_WorkSession_SelectedNorm(self, *args)

    def SetAllContext(self, *args):
        r"""

        Parameters
        ----------
        theContext: Standard_Transient

        Return
        -------
        None

        Description
        -----------
        Sets the current context list, as a whole sets it to the transferreader.

        """
        return _XSControl.XSControl_WorkSession_SetAllContext(self, *args)

    def SetController(self, *args):
        r"""

        Parameters
        ----------
        theCtl: XSControl_Controller

        Return
        -------
        None

        Description
        -----------
        Selects a norm defined by its controller itself.

        """
        return _XSControl.XSControl_WorkSession_SetController(self, *args)

    def SetMapReader(self, *args):
        r"""

        Parameters
        ----------
        theTP: Transfer_TransientProcess

        Return
        -------
        bool

        Description
        -----------
        Changes the map reader, i.e. considers that the new one defines the relevant read results (forgets the former ones) returns true when done, false in case of bad definition, i.e. if model from tp differs from that of session.

        """
        return _XSControl.XSControl_WorkSession_SetMapReader(self, *args)

    def SetMapWriter(self, *args):
        r"""

        Parameters
        ----------
        theFP: Transfer_FinderProcess

        Return
        -------
        bool

        Description
        -----------
        Changes the map reader, i.e. considers that the new one defines the relevant read results (forgets the former ones) returns true when done, false if <fp> is null.

        """
        return _XSControl.XSControl_WorkSession_SetMapWriter(self, *args)

    def SetTransferReader(self, *args):
        r"""

        Parameters
        ----------
        theTR: XSControl_TransferReader

        Return
        -------
        None

        Description
        -----------
        Sets a transfer reader, which manages transfers on reading.

        """
        return _XSControl.XSControl_WorkSession_SetTransferReader(self, *args)

    def SetVars(self, *args):
        r"""

        Parameters
        ----------
        theVars: XSControl_Vars

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_WorkSession_SetVars(self, *args)

    def TransferReadOne(self, *args):
        r"""

        Parameters
        ----------
        theEnts: Standard_Transient
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        int

        Description
        -----------
        Commands the transfer of, either one entity, or a list i.e. calls the transferreader after having analysed <ents> it is cumulated from the last begintransfer <ents> is processed by givelist, hence: - <ents> a selection: its selectionresult - <ents> a hsequenceoftransient: this list - <ents> the model: in this specific case, all the roots, with no cumulation of former transfers (transferreadroots).

        """
        return _XSControl.XSControl_WorkSession_TransferReadOne(self, *args)

    def TransferReadRoots(self, *args):
        r"""

        Parameters
        ----------
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        int

        Description
        -----------
        Commands the transfer of all the root entities of the model i.e. calls transferroot from the transferreader with the graph no cumulation with former calls to transferreadone.

        """
        return _XSControl.XSControl_WorkSession_TransferReadRoots(self, *args)

    def TransferReader(self, *args):
        r"""
        Return
        -------
        opencascade::handle<XSControl_TransferReader>

        Description
        -----------
        Returns the transfer reader, null if not set.

        """
        return _XSControl.XSControl_WorkSession_TransferReader(self, *args)

    def TransferWriteCheckList(self, *args):
        r"""
        Return
        -------
        Interface_CheckIterator

        Description
        -----------
        Returns the check-list of last transfer (write) it is recorded in the finderprocess, but it must be bound with resulting entities (in the resulting file model) rather than with original objects (in fact, their mappers).

        """
        return _XSControl.XSControl_WorkSession_TransferWriteCheckList(self, *args)

    def TransferWriteShape(self, *args):
        r"""

        Parameters
        ----------
        theShape: TopoDS_Shape
        theCompGraph: bool (optional, default to Standard_True)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        IFSelect_ReturnStatus

        Description
        -----------
        Transfers a shape from cascade to a model of current norm, according to the last call to setmodewriteshape returns status :done if ok, fail if error during transfer, error if transfer badly initialised.

        """
        return _XSControl.XSControl_WorkSession_TransferWriteShape(self, *args)

    def TransferWriter(self, *args):
        r"""
        Return
        -------
        opencascade::handle<XSControl_TransferWriter>

        Description
        -----------
        Returns the transfer reader, null if not set.

        """
        return _XSControl.XSControl_WorkSession_TransferWriter(self, *args)

    def Vars(self, *args):
        r"""
        Return
        -------
        opencascade::handle<XSControl_Vars>

        Description
        -----------
        No available documentation.

        """
        return _XSControl.XSControl_WorkSession_Vars(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_XSControl_WorkSession_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_WorkSession

# Register XSControl_WorkSession in _XSControl:
_XSControl.XSControl_WorkSession_swigregister(XSControl_WorkSession)
class XSControl_Writer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates a writer from scratch.

        Parameters
        ----------
        norm: str

        Return
        -------
        None

        Description
        -----------
        Creates a writer from scratch, with a norm name which identifie a controller.

        Parameters
        ----------
        WS: XSControl_WorkSession
        scratch: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Creates a writer from an already existing session if <scratch> is true (d), clears already recorded data.

        """
        _XSControl.XSControl_Writer_swiginit(self, _XSControl.new_XSControl_Writer(*args))

    def Model(self, *args):
        r"""

        Parameters
        ----------
        newone: bool (optional, default to Standard_False)

        Return
        -------
        opencascade::handle<Interface_InterfaceModel>

        Description
        -----------
        Returns the produced model. produces a new one if not yet done or if <newone> is true this method allows for instance to edit product or header data before writing.

        """
        return _XSControl.XSControl_Writer_Model(self, *args)

    def PrintStatsTransfer(self, *args):
        r"""

        Parameters
        ----------
        what: int
        mode: int (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        Prints statistics about transfer.

        """
        return _XSControl.XSControl_Writer_PrintStatsTransfer(self, *args)

    def SetNorm(self, *args):
        r"""

        Parameters
        ----------
        norm: str

        Return
        -------
        bool

        Description
        -----------
        Sets a specific norm to <self> returns true if done, false if <norm> is not available.

        """
        return _XSControl.XSControl_Writer_SetNorm(self, *args)

    def SetWS(self, *args):
        r"""

        Parameters
        ----------
        WS: XSControl_WorkSession
        scratch: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Sets a specific session to <self>.

        """
        return _XSControl.XSControl_Writer_SetWS(self, *args)

    def TransferShape(self, *args):
        r"""

        Parameters
        ----------
        sh: TopoDS_Shape
        mode: int (optional, default to 0)
        theProgress: Message_ProgressRange (optional, default to Message_ProgressRange())

        Return
        -------
        IFSelect_ReturnStatus

        Description
        -----------
        Transfers a shape according to the mode.

        """
        return _XSControl.XSControl_Writer_TransferShape(self, *args)

    def WS(self, *args):
        r"""
        Return
        -------
        opencascade::handle<XSControl_WorkSession>

        Description
        -----------
        Returns the session used in <self>.

        """
        return _XSControl.XSControl_Writer_WS(self, *args)

    def WriteFile(self, *args):
        r"""

        Parameters
        ----------
        filename: str

        Return
        -------
        IFSelect_ReturnStatus

        Description
        -----------
        Writes the produced model.

        """
        return _XSControl.XSControl_Writer_WriteFile(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _XSControl.delete_XSControl_Writer

# Register XSControl_Writer in _XSControl:
_XSControl.XSControl_Writer_swigregister(XSControl_Writer)



@deprecated
def xscontrol_Session(*args):
	return xscontrol.Session(*args)

@deprecated
def xscontrol_Vars(*args):
	return xscontrol.Vars(*args)

@deprecated
def XSControl_ConnectedShapes_AdjacentEntities(*args):
	return XSControl_ConnectedShapes.AdjacentEntities(*args)

@deprecated
def XSControl_Controller_Recorded(*args):
	return XSControl_Controller.Recorded(*args)

@deprecated
def XSControl_FuncShape_FileAndVar(*args):
	return XSControl_FuncShape.FileAndVar(*args)

@deprecated
def XSControl_FuncShape_Init(*args):
	return XSControl_FuncShape.Init(*args)

@deprecated
def XSControl_FuncShape_MoreShapes(*args):
	return XSControl_FuncShape.MoreShapes(*args)

@deprecated
def XSControl_Functions_Init(*args):
	return XSControl_Functions.Init(*args)

@deprecated
def XSControl_TransferReader_PrintStatsOnList(*args):
	return XSControl_TransferReader.PrintStatsOnList(*args)

@deprecated
def XSControl_TransferReader_PrintStatsProcess(*args):
	return XSControl_TransferReader.PrintStatsProcess(*args)



