/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDAppearance;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;

public class PDChoiceField
extends PDVariableText {
    public static final int FLAG_COMBO = 131072;
    public static final int FLAG_EDIT = 262144;
    private PDAppearance appearance;

    public PDChoiceField(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
    }

    private void setListboxValue(String value) throws IOException {
        COSString fieldValue = new COSString(value);
        this.getDictionary().setItem(COSName.V, (COSBase)fieldValue);
        if (this.appearance == null) {
            this.appearance = new PDAppearance(this.getAcroForm(), this);
        }
        this.appearance.setAppearanceValue(value);
    }

    @Override
    public void setValue(String optionValue) throws IOException {
        boolean isEditable;
        int indexSelected = -1;
        COSArray options = (COSArray)this.getDictionary().getDictionaryObject(COSName.OPT);
        int fieldFlags = this.getFieldFlags();
        boolean bl = isEditable = (0x20000 & fieldFlags) != 0 && (0x40000 & fieldFlags) != 0;
        if (options.size() == 0 && !isEditable) {
            throw new IOException("Error: You cannot set a value for a choice field if there are no options.");
        }
        for (int i = 0; i < options.size() && indexSelected == -1; ++i) {
            COSBase option = options.getObject(i);
            if (option instanceof COSArray) {
                COSArray keyValuePair = (COSArray)option;
                COSString key = (COSString)keyValuePair.getObject(0);
                COSString value = (COSString)keyValuePair.getObject(1);
                if (!optionValue.equals(key.getString()) && !optionValue.equals(value.getString())) continue;
                if ((0x20000 & fieldFlags) != 0) {
                    super.setValue(value.getString());
                } else {
                    COSArray indexEntries = new COSArray();
                    indexEntries.add(COSInteger.get(i));
                    this.getDictionary().setItem(COSName.I, (COSBase)indexEntries);
                    this.setListboxValue(value.getString());
                }
                this.getDictionary().setItem(COSName.V, (COSBase)key);
                indexSelected = i;
                continue;
            }
            COSString value = (COSString)option;
            if (!optionValue.equals(value.getString())) continue;
            super.setValue(optionValue);
            indexSelected = i;
        }
        if (indexSelected == -1 && isEditable) {
            super.setValue(optionValue);
        } else {
            if (indexSelected == -1) {
                throw new IOException("Error: '" + optionValue + "' was not an available option.");
            }
            COSArray indexArray = (COSArray)this.getDictionary().getDictionaryObject(COSName.I);
            if (indexArray != null) {
                indexArray.clear();
                indexArray.add(COSInteger.get(indexSelected));
            }
        }
    }

    public COSArray getSelectedOptions() {
        return (COSArray)this.getDictionary().getDictionaryObject(COSName.I);
    }

    public int getTopIndex() {
        return this.getDictionary().getInt(COSName.getPDFName("TI"), 0);
    }

    public COSArray getOptions() {
        return (COSArray)this.getDictionary().getDictionaryObject(COSName.OPT);
    }
}

