/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;

public class BasicAuthenticator
extends AuthenticatorBase {
    private final Log log = LogFactory.getLog(BasicAuthenticator.class);
    private Charset charset = StandardCharsets.ISO_8859_1;
    private String charsetString = null;
    private boolean trimCredentials = false;

    public String getCharset() {
        return this.charsetString;
    }

    public void setCharset(String string) {
        if (string == null || string.isEmpty()) {
            this.charset = StandardCharsets.ISO_8859_1;
        } else if ("UTF-8".equalsIgnoreCase(string)) {
            this.charset = StandardCharsets.UTF_8;
        } else {
            throw new IllegalArgumentException(sm.getString("basicAuthenticator.invalidCharset"));
        }
        this.charsetString = string;
    }

    @Deprecated
    public boolean getTrimCredentials() {
        return this.trimCredentials;
    }

    @Deprecated
    public void setTrimCredentials(boolean bl) {
        this.trimCredentials = bl;
    }

    @Override
    protected boolean doAuthenticate(Request request, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        block6: {
            if (this.checkForCachedAuthentication(request, httpServletResponse, true)) {
                return true;
            }
            MessageBytes messageBytes = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
            if (messageBytes != null) {
                messageBytes.toBytes();
                object = messageBytes.getByteChunk();
                BasicCredentials basicCredentials = null;
                try {
                    basicCredentials = new BasicCredentials((ByteChunk)object, this.charset, this.getTrimCredentials());
                    String string = basicCredentials.getUsername();
                    String string2 = basicCredentials.getPassword();
                    Principal principal = this.context.getRealm().authenticate(string, string2);
                    if (principal != null) {
                        this.register(request, httpServletResponse, principal, "BASIC", string, string2);
                        return true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!this.log.isDebugEnabled()) break block6;
                    this.log.debug((Object)sm.getString("basicAuthenticator.invalidAuthorization", new Object[]{illegalArgumentException.getMessage()}));
                }
            }
        }
        object = new StringBuilder(16);
        ((StringBuilder)object).append("Basic realm=\"");
        ((StringBuilder)object).append(BasicAuthenticator.getRealmName(this.context));
        ((StringBuilder)object).append('\"');
        if (this.charsetString != null && !this.charsetString.isEmpty()) {
            ((StringBuilder)object).append(", charset=");
            ((StringBuilder)object).append(this.charsetString);
        }
        httpServletResponse.setHeader("WWW-Authenticate", ((StringBuilder)object).toString());
        httpServletResponse.sendError(401);
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "BASIC";
    }

    @Override
    protected boolean isPreemptiveAuthPossible(Request request) {
        MessageBytes messageBytes = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        return messageBytes != null && messageBytes.startsWithIgnoreCase("basic ", 0);
    }

    public static class BasicCredentials {
        private static final String METHOD = "basic ";
        private final Charset charset;
        private final boolean trimCredentials;
        private final ByteChunk authorization;
        private final int initialOffset;
        private int base64blobOffset;
        private int base64blobLength;
        private String username = null;
        private String password = null;

        public BasicCredentials(ByteChunk byteChunk, Charset charset) throws IllegalArgumentException {
            this(byteChunk, charset, false);
        }

        @Deprecated
        public BasicCredentials(ByteChunk byteChunk, Charset charset, boolean bl) throws IllegalArgumentException {
            this.authorization = byteChunk;
            this.initialOffset = byteChunk.getStart();
            this.charset = charset;
            this.trimCredentials = bl;
            this.parseMethod();
            byte[] byArray = this.parseBase64();
            this.parseCredentials(byArray);
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        private void parseMethod() throws IllegalArgumentException {
            if (!this.authorization.startsWithIgnoreCase(METHOD, 0)) {
                throw new IllegalArgumentException(AuthenticatorBase.sm.getString("basicAuthenticator.notBasic"));
            }
            this.base64blobOffset = this.initialOffset + METHOD.length();
            this.base64blobLength = this.authorization.getLength() - METHOD.length();
        }

        private byte[] parseBase64() throws IllegalArgumentException {
            byte[] byArray = new byte[this.base64blobLength];
            System.arraycopy(this.authorization.getBuffer(), this.base64blobOffset, byArray, 0, this.base64blobLength);
            byte[] byArray2 = Base64.getDecoder().decode(byArray);
            this.authorization.setStart(this.initialOffset);
            if (byArray2 == null) {
                throw new IllegalArgumentException(AuthenticatorBase.sm.getString("basicAuthenticator.notBase64"));
            }
            return byArray2;
        }

        private void parseCredentials(byte[] byArray) throws IllegalArgumentException {
            int n = -1;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 58) continue;
                n = i;
                break;
            }
            if (n < 0) {
                this.username = new String(byArray, this.charset);
            } else {
                this.username = new String(byArray, 0, n, this.charset);
                this.password = new String(byArray, n + 1, byArray.length - n - 1, this.charset);
                if (this.password.length() > 1 && this.trimCredentials) {
                    this.password = this.password.trim();
                }
            }
            if (this.username.length() > 1 && this.trimCredentials) {
                this.username = this.username.trim();
            }
        }
    }
}

