/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class Ranges {
    private final String units;
    private final List<Entry> entries;

    private Ranges(String string, List<Entry> list) {
        this.units = string == null ? null : string.toLowerCase(Locale.ENGLISH);
        this.entries = Collections.unmodifiableList(list);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String getUnits() {
        return this.units;
    }

    public static Ranges parse(StringReader stringReader) throws IOException {
        SkipResult skipResult;
        String string = HttpParser.readToken(stringReader);
        if (string == null || string.length() == 0) {
            return null;
        }
        if (HttpParser.skipConstant(stringReader, "=") != SkipResult.FOUND) {
            return null;
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        do {
            long l = HttpParser.readLong(stringReader);
            if (HttpParser.skipConstant(stringReader, "-") != SkipResult.FOUND) {
                return null;
            }
            long l2 = HttpParser.readLong(stringReader);
            if (l == -1L && l2 == -1L) {
                return null;
            }
            arrayList.add(new Entry(l, l2));
            skipResult = HttpParser.skipConstant(stringReader, ",");
            if (skipResult != SkipResult.NOT_FOUND) continue;
            return null;
        } while (skipResult == SkipResult.FOUND);
        return new Ranges(string, arrayList);
    }

    public static class Entry {
        private final long start;
        private final long end;

        public Entry(long l, long l2) {
            this.start = l;
            this.end = l2;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

