/* Generated by wayland-scanner 1.23.0 */

#ifndef SECURITY_CONTEXT_V1_SERVER_PROTOCOL_H
#define SECURITY_CONTEXT_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_security_context_v1 The security_context_v1 protocol
 * @section page_ifaces_security_context_v1 Interfaces
 * - @subpage page_iface_wp_security_context_manager_v1 - client security context manager
 * - @subpage page_iface_wp_security_context_v1 - client security context
 * @section page_copyright_security_context_v1 Copyright
 * <pre>
 *
 * Copyright © 2021 Simon Ser
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wp_security_context_manager_v1;
struct wp_security_context_v1;

#ifndef WP_SECURITY_CONTEXT_MANAGER_V1_INTERFACE
#define WP_SECURITY_CONTEXT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_security_context_manager_v1 wp_security_context_manager_v1
 * @section page_iface_wp_security_context_manager_v1_desc Description
 *
 * This interface allows a client to register a new Wayland connection to
 * the compositor and attach a security context to it.
 *
 * This is intended to be used by sandboxes. Sandbox engines attach a
 * security context to all connections coming from inside the sandbox. The
 * compositor can then restrict the features that the sandboxed connections
 * can use.
 *
 * Compositors should forbid nesting multiple security contexts by not
 * exposing wp_security_context_manager_v1 global to clients with a security
 * context attached, or by sending the nested protocol error. Nested
 * security contexts are dangerous because they can potentially allow
 * privilege escalation of a sandboxed client.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_wp_security_context_manager_v1_api API
 * See @ref iface_wp_security_context_manager_v1.
 */
/**
 * @defgroup iface_wp_security_context_manager_v1 The wp_security_context_manager_v1 interface
 *
 * This interface allows a client to register a new Wayland connection to
 * the compositor and attach a security context to it.
 *
 * This is intended to be used by sandboxes. Sandbox engines attach a
 * security context to all connections coming from inside the sandbox. The
 * compositor can then restrict the features that the sandboxed connections
 * can use.
 *
 * Compositors should forbid nesting multiple security contexts by not
 * exposing wp_security_context_manager_v1 global to clients with a security
 * context attached, or by sending the nested protocol error. Nested
 * security contexts are dangerous because they can potentially allow
 * privilege escalation of a sandboxed client.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface wp_security_context_manager_v1_interface;
#endif
#ifndef WP_SECURITY_CONTEXT_V1_INTERFACE
#define WP_SECURITY_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_wp_security_context_v1 wp_security_context_v1
 * @section page_iface_wp_security_context_v1_desc Description
 *
 * The security context allows a client to register a new client and attach
 * security context metadata to the connections.
 *
 * When both are set, the combination of the application ID and the sandbox
 * engine must uniquely identify an application. The same application ID
 * will be used across instances (e.g. if the application is restarted, or
 * if the application is started multiple times).
 *
 * When both are set, the combination of the instance ID and the sandbox
 * engine must uniquely identify a running instance of an application.
 * @section page_iface_wp_security_context_v1_api API
 * See @ref iface_wp_security_context_v1.
 */
/**
 * @defgroup iface_wp_security_context_v1 The wp_security_context_v1 interface
 *
 * The security context allows a client to register a new client and attach
 * security context metadata to the connections.
 *
 * When both are set, the combination of the application ID and the sandbox
 * engine must uniquely identify an application. The same application ID
 * will be used across instances (e.g. if the application is restarted, or
 * if the application is started multiple times).
 *
 * When both are set, the combination of the instance ID and the sandbox
 * engine must uniquely identify a running instance of an application.
 */
extern const struct wl_interface wp_security_context_v1_interface;
#endif

#ifndef WP_SECURITY_CONTEXT_MANAGER_V1_ERROR_ENUM
#define WP_SECURITY_CONTEXT_MANAGER_V1_ERROR_ENUM
enum wp_security_context_manager_v1_error {
	/**
	 * listening socket FD is invalid
	 */
	WP_SECURITY_CONTEXT_MANAGER_V1_ERROR_INVALID_LISTEN_FD = 1,
	/**
	 * nested security contexts are forbidden
	 */
	WP_SECURITY_CONTEXT_MANAGER_V1_ERROR_NESTED = 2,
};
/**
 * @ingroup iface_wp_security_context_manager_v1
 * Validate a wp_security_context_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref wp_security_context_manager_v1_error
 */
static inline bool
wp_security_context_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_SECURITY_CONTEXT_MANAGER_V1_ERROR_INVALID_LISTEN_FD:
		return version >= 1;
	case WP_SECURITY_CONTEXT_MANAGER_V1_ERROR_NESTED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_SECURITY_CONTEXT_MANAGER_V1_ERROR_ENUM */

/**
 * @ingroup iface_wp_security_context_manager_v1
 * @struct wp_security_context_manager_v1_interface
 */
struct wp_security_context_manager_v1_interface {
	/**
	 * destroy the manager object
	 *
	 * Destroy the manager. This doesn't destroy objects created with
	 * the manager.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a new security context
	 *
	 * Creates a new security context with a socket listening FD.
	 *
	 * The compositor will accept new client connections on listen_fd.
	 * listen_fd must be ready to accept new connections when this
	 * request is sent by the client. In other words, the client must
	 * call bind(2) and listen(2) before sending the FD.
	 *
	 * close_fd is a FD closed by the client when the compositor should
	 * stop accepting new connections on listen_fd.
	 *
	 * The compositor must continue to accept connections on listen_fd
	 * when the Wayland client which created the security context
	 * disconnects.
	 *
	 * After sending this request, closing listen_fd and close_fd
	 * remains the only valid operation on them.
	 * @param listen_fd listening socket FD
	 * @param close_fd FD closed when done
	 */
	void (*create_listener)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t id,
				int32_t listen_fd,
				int32_t close_fd);
};


/**
 * @ingroup iface_wp_security_context_manager_v1
 */
#define WP_SECURITY_CONTEXT_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_security_context_manager_v1
 */
#define WP_SECURITY_CONTEXT_MANAGER_V1_CREATE_LISTENER_SINCE_VERSION 1

#ifndef WP_SECURITY_CONTEXT_V1_ERROR_ENUM
#define WP_SECURITY_CONTEXT_V1_ERROR_ENUM
enum wp_security_context_v1_error {
	/**
	 * security context has already been committed
	 */
	WP_SECURITY_CONTEXT_V1_ERROR_ALREADY_USED = 1,
	/**
	 * metadata has already been set
	 */
	WP_SECURITY_CONTEXT_V1_ERROR_ALREADY_SET = 2,
	/**
	 * metadata is invalid
	 */
	WP_SECURITY_CONTEXT_V1_ERROR_INVALID_METADATA = 3,
};
/**
 * @ingroup iface_wp_security_context_v1
 * Validate a wp_security_context_v1 error value.
 *
 * @return true on success, false on error.
 * @ref wp_security_context_v1_error
 */
static inline bool
wp_security_context_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WP_SECURITY_CONTEXT_V1_ERROR_ALREADY_USED:
		return version >= 1;
	case WP_SECURITY_CONTEXT_V1_ERROR_ALREADY_SET:
		return version >= 1;
	case WP_SECURITY_CONTEXT_V1_ERROR_INVALID_METADATA:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WP_SECURITY_CONTEXT_V1_ERROR_ENUM */

/**
 * @ingroup iface_wp_security_context_v1
 * @struct wp_security_context_v1_interface
 */
struct wp_security_context_v1_interface {
	/**
	 * destroy the security context object
	 *
	 * Destroy the security context object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * set the sandbox engine
	 *
	 * Attach a unique sandbox engine name to the security context.
	 * The name should follow the reverse-DNS style (e.g.
	 * "org.flatpak").
	 *
	 * A list of well-known engines is maintained at:
	 * https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/security-context/engines.md
	 *
	 * It is a protocol error to call this request twice. The
	 * already_set error is sent in this case.
	 * @param name the sandbox engine name
	 */
	void (*set_sandbox_engine)(struct wl_client *client,
				   struct wl_resource *resource,
				   const char *name);
	/**
	 * set the application ID
	 *
	 * Attach an application ID to the security context.
	 *
	 * The application ID is an opaque, sandbox-specific identifier for
	 * an application. See the well-known engines document for more
	 * details:
	 * https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/security-context/engines.md
	 *
	 * The compositor may use the application ID to group clients
	 * belonging to the same security context application.
	 *
	 * Whether this request is optional or not depends on the sandbox
	 * engine used.
	 *
	 * It is a protocol error to call this request twice. The
	 * already_set error is sent in this case.
	 * @param app_id the application ID
	 */
	void (*set_app_id)(struct wl_client *client,
			   struct wl_resource *resource,
			   const char *app_id);
	/**
	 * set the instance ID
	 *
	 * Attach an instance ID to the security context.
	 *
	 * The instance ID is an opaque, sandbox-specific identifier for a
	 * running instance of an application. See the well-known engines
	 * document for more details:
	 * https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/security-context/engines.md
	 *
	 * Whether this request is optional or not depends on the sandbox
	 * engine used.
	 *
	 * It is a protocol error to call this request twice. The
	 * already_set error is sent in this case.
	 * @param instance_id the instance ID
	 */
	void (*set_instance_id)(struct wl_client *client,
				struct wl_resource *resource,
				const char *instance_id);
	/**
	 * register the security context
	 *
	 * Atomically register the new client and attach the security
	 * context metadata.
	 *
	 * If the provided metadata is inconsistent or does not match with
	 * out of band metadata (see
	 * https://gitlab.freedesktop.org/wayland/wayland-protocols/-/blob/main/staging/security-context/engines.md),
	 * the invalid_metadata error may be sent eventually.
	 *
	 * It's a protocol error to send any request other than "destroy"
	 * after this request. In this case, the already_used error is
	 * sent.
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource);
};


/**
 * @ingroup iface_wp_security_context_v1
 */
#define WP_SECURITY_CONTEXT_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_security_context_v1
 */
#define WP_SECURITY_CONTEXT_V1_SET_SANDBOX_ENGINE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_security_context_v1
 */
#define WP_SECURITY_CONTEXT_V1_SET_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_wp_security_context_v1
 */
#define WP_SECURITY_CONTEXT_V1_SET_INSTANCE_ID_SINCE_VERSION 1
/**
 * @ingroup iface_wp_security_context_v1
 */
#define WP_SECURITY_CONTEXT_V1_COMMIT_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
