// Generated from libavfilter/opencl/overlay.cl
const char *ff_source_overlay_cl =
"/*\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"__kernel void overlay_no_alpha(__write_only image2d_t dst,\n"
"                               __read_only  image2d_t main,\n"
"                               __read_only  image2d_t overlay,\n"
"                               int x_position,\n"
"                               int y_position)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_FILTER_NEAREST);\n"
"\n"
"    int2 overlay_size = get_image_dim(overlay);\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    if (loc.x <  x_position ||\n"
"        loc.y <  y_position ||\n"
"        loc.x >= overlay_size.x + x_position ||\n"
"        loc.y >= overlay_size.y + y_position) {\n"
"        float4 val = read_imagef(main, sampler, loc);\n"
"        write_imagef(dst, loc, val);\n"
"    } else {\n"
"        int2 loc_overlay = (int2)(x_position, y_position);\n"
"        float4 val       = read_imagef(overlay, sampler, loc - loc_overlay);\n"
"        write_imagef(dst, loc, val);\n"
"    }\n"
"}\n"
"\n"
"__kernel void overlay_internal_alpha(__write_only image2d_t dst,\n"
"                                     __read_only  image2d_t main,\n"
"                                     __read_only  image2d_t overlay,\n"
"                                     int x_position,\n"
"                                     int y_position)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_FILTER_NEAREST);\n"
"\n"
"    int2 overlay_size = get_image_dim(overlay);\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    if (loc.x <  x_position ||\n"
"        loc.y <  y_position ||\n"
"        loc.x >= overlay_size.x + x_position ||\n"
"        loc.y >= overlay_size.y + y_position) {\n"
"        float4 val = read_imagef(main, sampler, loc);\n"
"        write_imagef(dst, loc, val);\n"
"    } else {\n"
"        int2 loc_overlay  = (int2)(x_position, y_position);\n"
"        float4 in_main    = read_imagef(main,    sampler, loc);\n"
"        float4 in_overlay = read_imagef(overlay, sampler, loc - loc_overlay);\n"
"        float4 val        = in_overlay * in_overlay.w + in_main * (1.0f - in_overlay.w);\n"
"        write_imagef(dst, loc, val);\n"
"    }\n"
"}\n"
"\n"
"__kernel void overlay_external_alpha(__write_only image2d_t dst,\n"
"                                     __read_only  image2d_t main,\n"
"                                     __read_only  image2d_t overlay,\n"
"                                     __read_only  image2d_t alpha,\n"
"                                     int x_position,\n"
"                                     int y_position,\n"
"                                     int alpha_adj_x,\n"
"                                     int alpha_adj_y)\n"
"{\n"
"    const sampler_t sampler = (CLK_NORMALIZED_COORDS_FALSE |\n"
"                               CLK_FILTER_NEAREST);\n"
"\n"
"    int2 overlay_size = get_image_dim(overlay);\n"
"    int2 loc = (int2)(get_global_id(0), get_global_id(1));\n"
"\n"
"    if (loc.x <  x_position ||\n"
"        loc.y <  y_position ||\n"
"        loc.x >= overlay_size.x + x_position ||\n"
"        loc.y >= overlay_size.y + y_position) {\n"
"        float4 val = read_imagef(main, sampler, loc);\n"
"        write_imagef(dst, loc, val);\n"
"    } else {\n"
"        int2 loc_overlay  = (int2)(x_position, y_position);\n"
"        float4 in_main    = read_imagef(main,    sampler, loc);\n"
"        float4 in_overlay = read_imagef(overlay, sampler, loc - loc_overlay);\n"
"\n"
"        int2 loc_alpha    = (int2)(loc.x * alpha_adj_x,\n"
"                                   loc.y * alpha_adj_y) - loc_overlay;\n"
"        float4 in_alpha   = read_imagef(alpha,   sampler, loc_alpha);\n"
"\n"
"        float4 val = in_overlay * in_alpha.x + in_main * (1.0f - in_alpha.x);\n"
"        write_imagef(dst, loc, val);\n"
"    }\n"
"}\n"
;
