/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.AddOperation;
import com.github.fge.jsonpatch.CopyOperation;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.MoveOperation;
import com.github.fge.jsonpatch.RemoveOperation;
import com.github.fge.jsonpatch.ReplaceOperation;

final class DiffOperation {
    private final Type type;
    private final JsonPointer from;
    private final JsonNode oldValue;
    private final JsonPointer path;
    private final JsonNode value;

    static DiffOperation add(JsonPointer path, JsonNode value) {
        return new DiffOperation(Type.ADD, null, null, path, value);
    }

    static DiffOperation copy(JsonPointer from, JsonPointer path, JsonNode value) {
        return new DiffOperation(Type.COPY, from, null, path, value);
    }

    static DiffOperation move(JsonPointer from, JsonNode oldValue, JsonPointer path, JsonNode value) {
        return new DiffOperation(Type.MOVE, from, oldValue, path, value);
    }

    static DiffOperation remove(JsonPointer from, JsonNode oldValue) {
        return new DiffOperation(Type.REMOVE, from, oldValue, null, null);
    }

    static DiffOperation replace(JsonPointer from, JsonNode oldValue, JsonNode value) {
        return new DiffOperation(Type.REPLACE, from, oldValue, null, value);
    }

    private DiffOperation(Type type, JsonPointer from, JsonNode oldValue, JsonPointer path, JsonNode value) {
        this.type = type;
        this.from = from;
        this.oldValue = oldValue;
        this.path = path;
        this.value = value;
    }

    Type getType() {
        return this.type;
    }

    JsonPointer getFrom() {
        return this.from;
    }

    JsonNode getOldValue() {
        return this.oldValue;
    }

    JsonPointer getPath() {
        return this.path;
    }

    JsonNode getValue() {
        return this.value;
    }

    JsonPatchOperation asJsonPatchOperation() {
        return this.type.toOperation(this);
    }

    static enum Type {
        ADD{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new AddOperation(op.path, op.value);
            }
        }
        ,
        COPY{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new CopyOperation(op.from, op.path);
            }
        }
        ,
        MOVE{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new MoveOperation(op.from, op.path);
            }
        }
        ,
        REMOVE{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new RemoveOperation(op.from);
            }
        }
        ,
        REPLACE{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new ReplaceOperation(op.from, op.value);
            }
        };


        abstract JsonPatchOperation toOperation(DiffOperation var1);
    }
}

