/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.AlertService;
import org.opensearch.alerting.InputService;
import org.opensearch.alerting.MonitorMetadataService;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.TriggerService;
import org.opensearch.alerting.WorkflowMetadataService;
import org.opensearch.alerting.WorkflowService;
import org.opensearch.alerting.action.DocLevelMonitorFanOutAction;
import org.opensearch.alerting.action.ExecuteMonitorAction;
import org.opensearch.alerting.action.ExecuteWorkflowAction;
import org.opensearch.alerting.action.GetDestinationsAction;
import org.opensearch.alerting.action.GetEmailAccountAction;
import org.opensearch.alerting.action.GetEmailGroupAction;
import org.opensearch.alerting.action.GetRemoteIndexesAction;
import org.opensearch.alerting.action.SearchEmailAccountAction;
import org.opensearch.alerting.action.SearchEmailGroupAction;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.core.JobRunner;
import org.opensearch.alerting.core.JobSweeper;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsAction;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsTransportAction;
import org.opensearch.alerting.core.lock.LockService;
import org.opensearch.alerting.core.resthandler.RestScheduledJobStatsHandler;
import org.opensearch.alerting.core.schedule.JobScheduler;
import org.opensearch.alerting.core.settings.LegacyOpenDistroScheduledJobSettings;
import org.opensearch.alerting.core.settings.ScheduledJobSettings;
import org.opensearch.alerting.resthandler.RestAcknowledgeAlertAction;
import org.opensearch.alerting.resthandler.RestAcknowledgeChainedAlertAction;
import org.opensearch.alerting.resthandler.RestDeleteMonitorAction;
import org.opensearch.alerting.resthandler.RestDeleteWorkflowAction;
import org.opensearch.alerting.resthandler.RestExecuteMonitorAction;
import org.opensearch.alerting.resthandler.RestExecuteWorkflowAction;
import org.opensearch.alerting.resthandler.RestGetAlertsAction;
import org.opensearch.alerting.resthandler.RestGetDestinationsAction;
import org.opensearch.alerting.resthandler.RestGetEmailAccountAction;
import org.opensearch.alerting.resthandler.RestGetEmailGroupAction;
import org.opensearch.alerting.resthandler.RestGetFindingsAction;
import org.opensearch.alerting.resthandler.RestGetMonitorAction;
import org.opensearch.alerting.resthandler.RestGetRemoteIndexesAction;
import org.opensearch.alerting.resthandler.RestGetWorkflowAction;
import org.opensearch.alerting.resthandler.RestGetWorkflowAlertsAction;
import org.opensearch.alerting.resthandler.RestIndexMonitorAction;
import org.opensearch.alerting.resthandler.RestIndexWorkflowAction;
import org.opensearch.alerting.resthandler.RestSearchEmailAccountAction;
import org.opensearch.alerting.resthandler.RestSearchEmailGroupAction;
import org.opensearch.alerting.resthandler.RestSearchMonitorAction;
import org.opensearch.alerting.script.TriggerScript;
import org.opensearch.alerting.service.DeleteMonitorService;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.settings.LegacyOpenDistroAlertingSettings;
import org.opensearch.alerting.settings.LegacyOpenDistroDestinationSettings;
import org.opensearch.alerting.transport.TransportAcknowledgeAlertAction;
import org.opensearch.alerting.transport.TransportAcknowledgeChainedAlertAction;
import org.opensearch.alerting.transport.TransportDeleteMonitorAction;
import org.opensearch.alerting.transport.TransportDeleteWorkflowAction;
import org.opensearch.alerting.transport.TransportDocLevelMonitorFanOutAction;
import org.opensearch.alerting.transport.TransportExecuteMonitorAction;
import org.opensearch.alerting.transport.TransportExecuteWorkflowAction;
import org.opensearch.alerting.transport.TransportGetAlertsAction;
import org.opensearch.alerting.transport.TransportGetDestinationsAction;
import org.opensearch.alerting.transport.TransportGetEmailAccountAction;
import org.opensearch.alerting.transport.TransportGetEmailGroupAction;
import org.opensearch.alerting.transport.TransportGetFindingsSearchAction;
import org.opensearch.alerting.transport.TransportGetMonitorAction;
import org.opensearch.alerting.transport.TransportGetRemoteIndexesAction;
import org.opensearch.alerting.transport.TransportGetWorkflowAction;
import org.opensearch.alerting.transport.TransportGetWorkflowAlertsAction;
import org.opensearch.alerting.transport.TransportIndexMonitorAction;
import org.opensearch.alerting.transport.TransportIndexWorkflowAction;
import org.opensearch.alerting.transport.TransportSearchEmailAccountAction;
import org.opensearch.alerting.transport.TransportSearchEmailGroupAction;
import org.opensearch.alerting.transport.TransportSearchMonitorAction;
import org.opensearch.alerting.util.DocLevelMonitorQueries;
import org.opensearch.alerting.util.destinationmigration.DestinationMigrationCoordinator;
import org.opensearch.client.AdminClient;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.aggregation.bucketselectorext.BucketSelectorExtAggregationBuilder;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.ChainedAlertTrigger;
import org.opensearch.commons.alerting.model.ClusterMetricsInput;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.QueryLevelTrigger;
import org.opensearch.commons.alerting.model.SearchInput;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.monitor.jvm.JvmStats;
import org.opensearch.painless.spi.PainlessExtension;
import org.opensearch.painless.spi.Whitelist;
import org.opensearch.painless.spi.WhitelistLoader;
import org.opensearch.percolator.PercolatorPluginExt;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ReloadablePlugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptService;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 w2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001wB\u0005\u00a2\u0006\u0002\u0010\u0007Jl\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010A\u001a\u00020B2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00108\u001a\u0002092\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RH\u0016J\u001e\u0010T\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020W\u0012\u0006\b\u0001\u0012\u00020X0V0UH\u0016J\u001e\u0010Y\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030[\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\0U0ZH\u0016J\u0012\u0010]\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030[0UH\u0016J\u000e\u0010^\u001a\b\u0012\u0004\u0012\u00020_0UH\u0016J\u000e\u0010`\u001a\b\u0012\u0004\u0012\u00020a0UH\u0016JN\u0010b\u001a\b\u0012\u0004\u0012\u00020c0U2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020m2\b\u0010O\u001a\u0004\u0018\u00010P2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020o0RH\u0016J\u0012\u0010p\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030q0UH\u0016J\u0010\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020uH\u0016J\u0010\u0010v\u001a\u00020s2\u0006\u0010d\u001a\u00020eH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001a\u00108\u001a\u000209X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u00a8\u0006x"}, d2={"Lorg/opensearch/alerting/AlertingPlugin;", "Lorg/opensearch/painless/spi/PainlessExtension;", "Lorg/opensearch/plugins/ActionPlugin;", "Lorg/opensearch/plugins/ScriptPlugin;", "Lorg/opensearch/plugins/ReloadablePlugin;", "Lorg/opensearch/plugins/SearchPlugin;", "Lorg/opensearch/percolator/PercolatorPluginExt;", "()V", "alertIndices", "Lorg/opensearch/alerting/alerts/AlertIndices;", "getAlertIndices", "()Lorg/opensearch/alerting/alerts/AlertIndices;", "setAlertIndices", "(Lorg/opensearch/alerting/alerts/AlertIndices;)V", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "setClusterService", "(Lorg/opensearch/cluster/service/ClusterService;)V", "destinationMigrationCoordinator", "Lorg/opensearch/alerting/util/destinationmigration/DestinationMigrationCoordinator;", "getDestinationMigrationCoordinator", "()Lorg/opensearch/alerting/util/destinationmigration/DestinationMigrationCoordinator;", "setDestinationMigrationCoordinator", "(Lorg/opensearch/alerting/util/destinationmigration/DestinationMigrationCoordinator;)V", "docLevelMonitorQueries", "Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "getDocLevelMonitorQueries", "()Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "setDocLevelMonitorQueries", "(Lorg/opensearch/alerting/util/DocLevelMonitorQueries;)V", "runner", "Lorg/opensearch/alerting/MonitorRunnerService;", "getRunner", "()Lorg/opensearch/alerting/MonitorRunnerService;", "setRunner", "(Lorg/opensearch/alerting/MonitorRunnerService;)V", "scheduledJobIndices", "Lorg/opensearch/alerting/core/ScheduledJobIndices;", "getScheduledJobIndices", "()Lorg/opensearch/alerting/core/ScheduledJobIndices;", "setScheduledJobIndices", "(Lorg/opensearch/alerting/core/ScheduledJobIndices;)V", "scheduler", "Lorg/opensearch/alerting/core/schedule/JobScheduler;", "getScheduler", "()Lorg/opensearch/alerting/core/schedule/JobScheduler;", "setScheduler", "(Lorg/opensearch/alerting/core/schedule/JobScheduler;)V", "sweeper", "Lorg/opensearch/alerting/core/JobSweeper;", "getSweeper", "()Lorg/opensearch/alerting/core/JobSweeper;", "setSweeper", "(Lorg/opensearch/alerting/core/JobSweeper;)V", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "getThreadPool", "()Lorg/opensearch/threadpool/ThreadPool;", "setThreadPool", "(Lorg/opensearch/threadpool/ThreadPool;)V", "createComponents", "", "", "client", "Lorg/opensearch/client/Client;", "resourceWatcherService", "Lorg/opensearch/watcher/ResourceWatcherService;", "scriptService", "Lorg/opensearch/script/ScriptService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "environment", "Lorg/opensearch/env/Environment;", "nodeEnvironment", "Lorg/opensearch/env/NodeEnvironment;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "repositoriesServiceSupplier", "Ljava/util/function/Supplier;", "Lorg/opensearch/repositories/RepositoriesService;", "getActions", "", "Lorg/opensearch/plugins/ActionPlugin$ActionHandler;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/action/ActionResponse;", "getContextWhitelists", "", "Lorg/opensearch/script/ScriptContext;", "Lorg/opensearch/painless/spi/Whitelist;", "getContexts", "getNamedXContent", "Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "getPipelineAggregations", "Lorg/opensearch/plugins/SearchPlugin$PipelineAggregationSpec;", "getRestHandlers", "Lorg/opensearch/rest/RestHandler;", "settings", "Lorg/opensearch/common/settings/Settings;", "restController", "Lorg/opensearch/rest/RestController;", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "indexScopedSettings", "Lorg/opensearch/common/settings/IndexScopedSettings;", "settingsFilter", "Lorg/opensearch/common/settings/SettingsFilter;", "nodesInCluster", "Lorg/opensearch/cluster/node/DiscoveryNodes;", "getSettings", "Lorg/opensearch/common/settings/Setting;", "onIndexModule", "", "indexModule", "Lorg/opensearch/index/IndexModule;", "reload", "Companion", "opensearch-alerting"})
public final class AlertingPlugin
extends PercolatorPluginExt
implements PainlessExtension,
ActionPlugin,
ScriptPlugin,
ReloadablePlugin,
SearchPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public MonitorRunnerService runner;
    public JobScheduler scheduler;
    public JobSweeper sweeper;
    public ScheduledJobIndices scheduledJobIndices;
    public DocLevelMonitorQueries docLevelMonitorQueries;
    public ThreadPool threadPool;
    public AlertIndices alertIndices;
    public ClusterService clusterService;
    public DestinationMigrationCoordinator destinationMigrationCoordinator;
    @JvmField
    @NotNull
    public static final String OPEN_SEARCH_DASHBOARDS_USER_AGENT = "OpenSearch-Dashboards";
    @JvmField
    @NotNull
    public static final String[] UI_METADATA_EXCLUDE;
    @JvmField
    @NotNull
    public static final String MONITOR_BASE_URI;
    @JvmField
    @NotNull
    public static final String WORKFLOW_BASE_URI;
    @JvmField
    @NotNull
    public static final String REMOTE_BASE_URI;
    @JvmField
    @NotNull
    public static final String DESTINATION_BASE_URI;
    @JvmField
    @NotNull
    public static final String LEGACY_OPENDISTRO_MONITOR_BASE_URI;
    @JvmField
    @NotNull
    public static final String LEGACY_OPENDISTRO_DESTINATION_BASE_URI;
    @JvmField
    @NotNull
    public static final String EMAIL_ACCOUNT_BASE_URI;
    @JvmField
    @NotNull
    public static final String EMAIL_GROUP_BASE_URI;
    @JvmField
    @NotNull
    public static final String LEGACY_OPENDISTRO_EMAIL_ACCOUNT_BASE_URI;
    @JvmField
    @NotNull
    public static final String LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI;
    @JvmField
    @NotNull
    public static final String FINDING_BASE_URI;
    @JvmField
    @NotNull
    public static final List<String> ALERTING_JOB_TYPES;

    @NotNull
    public Map<ScriptContext<?>, List<Whitelist>> getContextWhitelists() {
        String[] stringArray = new String[]{"org.opensearch.alerting.txt"};
        Whitelist whitelist = WhitelistLoader.loadFromResourceFiles(((Object)((Object)this)).getClass(), (String[])stringArray);
        return MapsKt.mapOf((Pair)TuplesKt.to(TriggerScript.Companion.getCONTEXT(), (Object)CollectionsKt.listOf((Object)whitelist)));
    }

    @NotNull
    public final MonitorRunnerService getRunner() {
        MonitorRunnerService monitorRunnerService = this.runner;
        if (monitorRunnerService != null) {
            return monitorRunnerService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"runner");
        return null;
    }

    public final void setRunner(@NotNull MonitorRunnerService monitorRunnerService) {
        Intrinsics.checkNotNullParameter((Object)((Object)monitorRunnerService), (String)"<set-?>");
        this.runner = monitorRunnerService;
    }

    @NotNull
    public final JobScheduler getScheduler() {
        JobScheduler jobScheduler = this.scheduler;
        if (jobScheduler != null) {
            return jobScheduler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scheduler");
        return null;
    }

    public final void setScheduler(@NotNull JobScheduler jobScheduler) {
        Intrinsics.checkNotNullParameter((Object)jobScheduler, (String)"<set-?>");
        this.scheduler = jobScheduler;
    }

    @NotNull
    public final JobSweeper getSweeper() {
        JobSweeper jobSweeper = this.sweeper;
        if (jobSweeper != null) {
            return jobSweeper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sweeper");
        return null;
    }

    public final void setSweeper(@NotNull JobSweeper jobSweeper) {
        Intrinsics.checkNotNullParameter((Object)jobSweeper, (String)"<set-?>");
        this.sweeper = jobSweeper;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        ScheduledJobIndices scheduledJobIndices = this.scheduledJobIndices;
        if (scheduledJobIndices != null) {
            return scheduledJobIndices;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scheduledJobIndices");
        return null;
    }

    public final void setScheduledJobIndices(@NotNull ScheduledJobIndices scheduledJobIndices) {
        Intrinsics.checkNotNullParameter((Object)scheduledJobIndices, (String)"<set-?>");
        this.scheduledJobIndices = scheduledJobIndices;
    }

    @NotNull
    public final DocLevelMonitorQueries getDocLevelMonitorQueries() {
        DocLevelMonitorQueries docLevelMonitorQueries = this.docLevelMonitorQueries;
        if (docLevelMonitorQueries != null) {
            return docLevelMonitorQueries;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"docLevelMonitorQueries");
        return null;
    }

    public final void setDocLevelMonitorQueries(@NotNull DocLevelMonitorQueries docLevelMonitorQueries) {
        Intrinsics.checkNotNullParameter((Object)docLevelMonitorQueries, (String)"<set-?>");
        this.docLevelMonitorQueries = docLevelMonitorQueries;
    }

    @NotNull
    public final ThreadPool getThreadPool() {
        ThreadPool threadPool = this.threadPool;
        if (threadPool != null) {
            return threadPool;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"threadPool");
        return null;
    }

    public final void setThreadPool(@NotNull ThreadPool threadPool) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"<set-?>");
        this.threadPool = threadPool;
    }

    @NotNull
    public final AlertIndices getAlertIndices() {
        AlertIndices alertIndices = this.alertIndices;
        if (alertIndices != null) {
            return alertIndices;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"alertIndices");
        return null;
    }

    public final void setAlertIndices(@NotNull AlertIndices alertIndices) {
        Intrinsics.checkNotNullParameter((Object)alertIndices, (String)"<set-?>");
        this.alertIndices = alertIndices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        ClusterService clusterService = this.clusterService;
        if (clusterService != null) {
            return clusterService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
        return null;
    }

    public final void setClusterService(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"<set-?>");
        this.clusterService = clusterService;
    }

    @NotNull
    public final DestinationMigrationCoordinator getDestinationMigrationCoordinator() {
        DestinationMigrationCoordinator destinationMigrationCoordinator = this.destinationMigrationCoordinator;
        if (destinationMigrationCoordinator != null) {
            return destinationMigrationCoordinator;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"destinationMigrationCoordinator");
        return null;
    }

    public final void setDestinationMigrationCoordinator(@NotNull DestinationMigrationCoordinator destinationMigrationCoordinator) {
        Intrinsics.checkNotNullParameter((Object)((Object)destinationMigrationCoordinator), (String)"<set-?>");
        this.destinationMigrationCoordinator = destinationMigrationCoordinator;
    }

    @NotNull
    public List<RestHandler> getRestHandlers(@NotNull Settings settings, @NotNull RestController restController, @NotNull ClusterSettings clusterSettings, @NotNull IndexScopedSettings indexScopedSettings, @NotNull SettingsFilter settingsFilter, @Nullable IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<DiscoveryNodes> nodesInCluster) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)restController, (String)"restController");
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        Intrinsics.checkNotNullParameter((Object)indexScopedSettings, (String)"indexScopedSettings");
        Intrinsics.checkNotNullParameter((Object)settingsFilter, (String)"settingsFilter");
        Intrinsics.checkNotNullParameter(nodesInCluster, (String)"nodesInCluster");
        Object[] objectArray = new BaseRestHandler[]{new RestGetMonitorAction(), new RestDeleteMonitorAction(), new RestIndexMonitorAction(), new RestIndexWorkflowAction(), new RestSearchMonitorAction(settings, this.getClusterService()), new RestExecuteMonitorAction(), new RestExecuteWorkflowAction(), new RestAcknowledgeAlertAction(), new RestAcknowledgeChainedAlertAction(), new RestScheduledJobStatsHandler("_alerting"), new RestSearchEmailAccountAction(), new RestGetEmailAccountAction(), new RestSearchEmailGroupAction(), new RestGetEmailGroupAction(), new RestGetDestinationsAction(), new RestGetAlertsAction(), new RestGetWorkflowAlertsAction(), new RestGetFindingsAction(), new RestGetWorkflowAction(), new RestDeleteWorkflowAction(), new RestGetRemoteIndexesAction()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        Object[] objectArray = new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler((ActionType)ScheduledJobsStatsAction.Companion.getINSTANCE(), ScheduledJobsStatsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.INDEX_MONITOR_ACTION_TYPE, TransportIndexMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_MONITOR_ACTION_TYPE, TransportGetMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ExecuteMonitorAction.Companion.getINSTANCE(), TransportExecuteMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.SEARCH_MONITORS_ACTION_TYPE, TransportSearchMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.DELETE_MONITOR_ACTION_TYPE, TransportDeleteMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.ACKNOWLEDGE_ALERTS_ACTION_TYPE, TransportAcknowledgeAlertAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.ACKNOWLEDGE_CHAINED_ALERTS_ACTION_TYPE, TransportAcknowledgeChainedAlertAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetEmailAccountAction.Companion.getINSTANCE(), TransportGetEmailAccountAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchEmailAccountAction.Companion.getINSTANCE(), TransportSearchEmailAccountAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetEmailGroupAction.Companion.getINSTANCE(), TransportGetEmailGroupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchEmailGroupAction.Companion.getINSTANCE(), TransportSearchEmailGroupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDestinationsAction.Companion.getINSTANCE(), TransportGetDestinationsAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_ALERTS_ACTION_TYPE, TransportGetAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_WORKFLOW_ALERTS_ACTION_TYPE, TransportGetWorkflowAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_FINDINGS_ACTION_TYPE, TransportGetFindingsSearchAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.INDEX_WORKFLOW_ACTION_TYPE, TransportIndexWorkflowAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_WORKFLOW_ACTION_TYPE, TransportGetWorkflowAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.DELETE_WORKFLOW_ACTION_TYPE, TransportDeleteWorkflowAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ExecuteWorkflowAction.Companion.getINSTANCE(), TransportExecuteWorkflowAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetRemoteIndexesAction.Companion.getINSTANCE(), TransportGetRemoteIndexesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DocLevelMonitorFanOutAction.Companion.getINSTANCE(), TransportDocLevelMonitorFanOutAction.class, new Class[0])};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        Object[] objectArray = new NamedXContentRegistry.Entry[]{Monitor.Companion.getXCONTENT_REGISTRY(), SearchInput.Companion.getXCONTENT_REGISTRY(), DocLevelMonitorInput.Companion.getXCONTENT_REGISTRY(), QueryLevelTrigger.Companion.getXCONTENT_REGISTRY(), BucketLevelTrigger.Companion.getXCONTENT_REGISTRY(), ClusterMetricsInput.Companion.getXCONTENT_REGISTRY(), DocumentLevelTrigger.Companion.getXCONTENT_REGISTRY(), ChainedAlertTrigger.Companion.getXCONTENT_REGISTRY(), Workflow.Companion.getXCONTENT_REGISTRY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Collection<Object> createComponents(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ResourceWatcherService resourceWatcherService, @NotNull ScriptService scriptService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull Environment environment, @NotNull NodeEnvironment nodeEnvironment, @NotNull NamedWriteableRegistry namedWriteableRegistry, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<RepositoriesService> repositoriesServiceSupplier) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)resourceWatcherService, (String)"resourceWatcherService");
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)nodeEnvironment, (String)"nodeEnvironment");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(repositoriesServiceSupplier, (String)"repositoriesServiceSupplier");
        Settings settings = environment.settings();
        LockService lockService = new LockService(client, clusterService);
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settings");
        this.setAlertIndices(new AlertIndices(settings, client, threadPool, clusterService));
        AlertService alertService = new AlertService(client, xContentRegistry, this.getAlertIndices());
        TriggerService triggerService = new TriggerService(scriptService);
        MonitorRunnerService monitorRunnerService = MonitorRunnerService.INSTANCE.registerClusterService(clusterService).registerClient(client).registerNamedXContentRegistry(xContentRegistry).registerindexNameExpressionResolver(indexNameExpressionResolver).registerScriptService(scriptService).registerSettings(settings).registerThreadPool(threadPool).registerAlertIndices(this.getAlertIndices()).registerInputService(new InputService(client, scriptService, namedWriteableRegistry, xContentRegistry, clusterService, settings)).registerTriggerService(triggerService).registerAlertService(alertService).registerDocLevelMonitorQueries(new DocLevelMonitorQueries(client, clusterService));
        JvmStats jvmStats = JvmStats.jvmStats();
        Intrinsics.checkNotNullExpressionValue((Object)jvmStats, (String)"jvmStats()");
        this.setRunner(monitorRunnerService.registerJvmStats(jvmStats).registerWorkflowService(new WorkflowService(client, xContentRegistry)).registerLockService(lockService).registerConsumers().registerDestinationSettings());
        AdminClient adminClient = client.admin();
        Intrinsics.checkNotNullExpressionValue((Object)adminClient, (String)"client.admin()");
        this.setScheduledJobIndices(new ScheduledJobIndices(adminClient, clusterService));
        this.setDocLevelMonitorQueries(new DocLevelMonitorQueries(client, clusterService));
        this.setScheduler(new JobScheduler(threadPool, (JobRunner)this.getRunner()));
        Settings settings2 = environment.settings();
        Intrinsics.checkNotNullExpressionValue((Object)settings2, (String)"environment.settings()");
        this.setSweeper(new JobSweeper(settings2, client, clusterService, threadPool, xContentRegistry, this.getScheduler(), ALERTING_JOB_TYPES));
        this.setDestinationMigrationCoordinator(new DestinationMigrationCoordinator(client, clusterService, threadPool, this.getScheduledJobIndices()));
        this.setThreadPool(threadPool);
        this.setClusterService(clusterService);
        MonitorMetadataService.INSTANCE.initialize(client, clusterService, xContentRegistry, settings);
        WorkflowMetadataService.INSTANCE.initialize(client, clusterService, xContentRegistry, settings);
        DeleteMonitorService.INSTANCE.initialize(client, lockService);
        Object[] objectArray = new Object[]{this.getSweeper(), this.getScheduler(), this.getRunner(), this.getScheduledJobIndices(), this.getDocLevelMonitorQueries(), this.getDestinationMigrationCoordinator(), lockService, alertService, triggerService};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Setting<?>> getSettings() {
        Object[] objectArray = new Setting[]{ScheduledJobSettings.Companion.getREQUEST_TIMEOUT(), ScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS(), ScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT(), ScheduledJobSettings.Companion.getSWEEP_PERIOD(), ScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE(), ScheduledJobSettings.Companion.getSWEEPER_ENABLED(), LegacyOpenDistroScheduledJobSettings.Companion.getREQUEST_TIMEOUT(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEP_PERIOD(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEPER_ENABLED(), AlertingSettings.Companion.getINPUT_TIMEOUT(), AlertingSettings.Companion.getINDEX_TIMEOUT(), AlertingSettings.Companion.getBULK_TIMEOUT(), AlertingSettings.Companion.getALERT_BACKOFF_MILLIS(), AlertingSettings.Companion.getALERT_BACKOFF_COUNT(), AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_MILLIS(), AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_COUNT(), AlertingSettings.Companion.getALERT_HISTORY_ENABLED(), AlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD(), AlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE(), AlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS(), AlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD(), AlertingSettings.Companion.getALERTING_MAX_MONITORS(), AlertingSettings.Companion.getPERCOLATE_QUERY_DOCS_SIZE_MEMORY_PERCENTAGE_LIMIT(), AlertingSettings.Companion.getDOC_LEVEL_MONITOR_FAN_OUT_NODES(), AlertingSettings.Companion.getDOC_LEVEL_MONITOR_SHARD_FETCH_SIZE(), AlertingSettings.Companion.getPERCOLATE_QUERY_MAX_NUM_DOCS_IN_MEMORY(), AlertingSettings.Companion.getREQUEST_TIMEOUT(), AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE(), AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), AlertingSettings.Companion.getMAX_ACTIONABLE_ALERT_COUNT(), LegacyOpenDistroAlertingSettings.Companion.getINPUT_TIMEOUT(), LegacyOpenDistroAlertingSettings.Companion.getINDEX_TIMEOUT(), LegacyOpenDistroAlertingSettings.Companion.getBULK_TIMEOUT(), LegacyOpenDistroAlertingSettings.Companion.getALERT_BACKOFF_MILLIS(), LegacyOpenDistroAlertingSettings.Companion.getALERT_BACKOFF_COUNT(), LegacyOpenDistroAlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_MILLIS(), LegacyOpenDistroAlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_COUNT(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_ENABLED(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD(), LegacyOpenDistroAlertingSettings.Companion.getALERTING_MAX_MONITORS(), LegacyOpenDistroAlertingSettings.Companion.getREQUEST_TIMEOUT(), LegacyOpenDistroAlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE(), LegacyOpenDistroAlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), AlertingSettings.Companion.getDOC_LEVEL_MONITOR_FETCH_ONLY_QUERY_FIELDS_ENABLED(), DestinationSettings.Companion.getEMAIL_USERNAME(), DestinationSettings.Companion.getEMAIL_PASSWORD(), DestinationSettings.Companion.getALLOW_LIST(), DestinationSettings.Companion.getHOST_DENY_LIST(), LegacyOpenDistroDestinationSettings.Companion.getEMAIL_USERNAME(), LegacyOpenDistroDestinationSettings.Companion.getEMAIL_PASSWORD(), LegacyOpenDistroDestinationSettings.Companion.getALLOW_LIST(), LegacyOpenDistroDestinationSettings.Companion.getHOST_DENY_LIST(), AlertingSettings.Companion.getFINDING_HISTORY_ENABLED(), AlertingSettings.Companion.getFINDING_HISTORY_MAX_DOCS(), AlertingSettings.Companion.getFINDING_HISTORY_INDEX_MAX_AGE(), AlertingSettings.Companion.getFINDING_HISTORY_ROLLOVER_PERIOD(), AlertingSettings.Companion.getFINDING_HISTORY_RETENTION_PERIOD(), AlertingSettings.Companion.getFINDINGS_INDEXING_BATCH_SIZE(), AlertingSettings.Companion.getCROSS_CLUSTER_MONITORING_ENABLED()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void onIndexModule(@NotNull IndexModule indexModule) {
        Intrinsics.checkNotNullParameter((Object)indexModule, (String)"indexModule");
        if (Intrinsics.areEqual((Object)indexModule.getIndex().getName(), (Object)".opendistro-alerting-config")) {
            indexModule.addIndexOperationListener((IndexingOperationListener)this.getSweeper());
        }
    }

    @NotNull
    public List<ScriptContext<?>> getContexts() {
        return CollectionsKt.listOf(TriggerScript.Companion.getCONTEXT());
    }

    public void reload(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.getRunner().reloadDestinationSettings(settings);
    }

    @NotNull
    public List<SearchPlugin.PipelineAggregationSpec> getPipelineAggregations() {
        return CollectionsKt.listOf((Object)new SearchPlugin.PipelineAggregationSpec(BucketSelectorExtAggregationBuilder.Companion.getNAME(), AlertingPlugin::getPipelineAggregations$lambda$0, AlertingPlugin::getPipelineAggregations$lambda$1));
    }

    private static final PipelineAggregationBuilder getPipelineAggregations$lambda$0(StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        return (PipelineAggregationBuilder)new BucketSelectorExtAggregationBuilder(sin);
    }

    private static final PipelineAggregationBuilder getPipelineAggregations$lambda$1(XContentParser parser, String agg_name) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)agg_name, (String)"agg_name");
        return (PipelineAggregationBuilder)BucketSelectorExtAggregationBuilder.Companion.parse(agg_name, parser);
    }

    static {
        Object[] objectArray = new String[]{"monitor.ui_metadata"};
        UI_METADATA_EXCLUDE = objectArray;
        MONITOR_BASE_URI = "/_plugins/_alerting/monitors";
        WORKFLOW_BASE_URI = "/_plugins/_alerting/workflows";
        REMOTE_BASE_URI = "/_plugins/_alerting/remote";
        DESTINATION_BASE_URI = "/_plugins/_alerting/destinations";
        LEGACY_OPENDISTRO_MONITOR_BASE_URI = "/_opendistro/_alerting/monitors";
        LEGACY_OPENDISTRO_DESTINATION_BASE_URI = "/_opendistro/_alerting/destinations";
        EMAIL_ACCOUNT_BASE_URI = DESTINATION_BASE_URI + "/email_accounts";
        EMAIL_GROUP_BASE_URI = DESTINATION_BASE_URI + "/email_groups";
        LEGACY_OPENDISTRO_EMAIL_ACCOUNT_BASE_URI = LEGACY_OPENDISTRO_DESTINATION_BASE_URI + "/email_accounts";
        LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI = LEGACY_OPENDISTRO_DESTINATION_BASE_URI + "/email_groups";
        FINDING_BASE_URI = "/_plugins/_alerting/findings";
        objectArray = new String[]{"monitor", "workflow"};
        ALERTING_JOB_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00128\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/alerting/AlertingPlugin$Companion;", "", "()V", "ALERTING_JOB_TYPES", "", "", "DESTINATION_BASE_URI", "EMAIL_ACCOUNT_BASE_URI", "EMAIL_GROUP_BASE_URI", "FINDING_BASE_URI", "LEGACY_OPENDISTRO_DESTINATION_BASE_URI", "LEGACY_OPENDISTRO_EMAIL_ACCOUNT_BASE_URI", "LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI", "LEGACY_OPENDISTRO_MONITOR_BASE_URI", "MONITOR_BASE_URI", "OPEN_SEARCH_DASHBOARDS_USER_AGENT", "REMOTE_BASE_URI", "UI_METADATA_EXCLUDE", "", "[Ljava/lang/String;", "WORKFLOW_BASE_URI", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

