/*
 * v4l2-hdmi.h - HDMI extensions to the V4L2 API
 *
 * Copyright 2011 Tandberg Telecom AS.  All rights reserved.
 *
 * This program is free software; you may redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#ifndef _V4L2_HDMI_H_
#define _V4L2_HDMI_H_

#ifdef __KERNEL__
#include <linux/ioctl.h>
#include <linux/videodev2.h>
#else
#include <sys/ioctl.h>
/*
  videodev2.h, including patched version from released os
 */
#include "videodev2.h"
#endif


/* data[0] == 0 if format is invalid, == 1 if format is valid. */
#define V4L2_EVENT_FMT_CHANGED (V4L2_EVENT_PRIVATE_START + 0)

/* data[0] == 0 if EDID was not found, == 1 if EDID was found.
 * data[1] == EDID segment that was found. */
#define V4L2_EVENT_EDID        (V4L2_EVENT_PRIVATE_START + 1)

/* data[0] == cec tx status field */
#define V4L2_EVENT_CEC_TX      (V4L2_EVENT_PRIVATE_START + 2)

/* data[0] == cec rx status field */
#define V4L2_EVENT_CEC_RX      (V4L2_EVENT_PRIVATE_START + 3)

/* data[0] == hotplug present or not */
#define V4L2_EVENT_TX_HOTPLUG  (V4L2_EVENT_PRIVATE_START + 4)

struct v4l2_edid {
	__u32 port;
	__u32 segment;
	__u8 edid[256];
};

struct v4l2_cec_cap {
	__u32 logicaldevices;
	__u32 reserved[7];
};

struct v4l2_cec_cmd {
	__u32 cmd;
	__u32 reserved[7];
	union {
		struct {
			__u32 id;
			__u32 enable;
			__u32 addr;
		} conf;
		struct {
			__u32 len;
			__u8  msg[16];
			__u32 status;
		} data;
		__u32 raw[8];
	};
};

/* cec commands */
#define V4L2_CEC_CMD_CONF  (0)
#define V4L2_CEC_CMD_TX    (1)
#define V4L2_CEC_CMD_RX    (2)

/* cec status field */
#define V4L2_CEC_TX_STATUS_OK            (1 << 0)
#define V4L2_CEC_TX_STATUS_ARB_LOST      (1 << 1)
#define V4L2_CEC_TX_STATUS_RETRY_TIMEOUT (1 << 2)
#define V4L2_CEC_RX_STATUS_READY         (1 << 0)

/* ioctls */

/* set a new EDID segment for a receiver */
#define V4L2_S_EDID		 _IOW('a', 1, struct v4l2_edid)
/* get the CEC capabilities */
#define V4L2_CEC_CAP		 _IOR('a', 2, struct v4l2_cec_cap)
/* issue a CEC command */
#define V4L2_CEC_CMD		_IOWR('a', 3, struct v4l2_cec_cmd)
/* request a new EDID segment */
#define V4L2_REQ_EDID_SEGMENT	 _IOW('a', 4, int)
/* get a EDID segment */
#define V4L2_G_EDID		_IOWR('a', 5, struct v4l2_edid)

/* controls */
#define V4L2_CID_DV_CID_CUSTOM_BASE		(V4L2_CID_USER_BASE | 0xf000)
/* hdmi or dvi-d mode */
#define V4L2_CID_DV_TX_DVI_HDMI_MODE		(V4L2_CID_DV_CID_CUSTOM_BASE + 0)
/* audio sample frequency */
#define V4L2_CID_DV_TX_AUDIO_SAMPLE_FREQ	(V4L2_CID_DV_CID_CUSTOM_BASE + 1)
/* audio word length */
#define V4L2_CID_DV_TX_AUDIO_WORD_LEN		(V4L2_CID_DV_CID_CUSTOM_BASE + 2)
/* audio channel count */
#define V4L2_CID_DV_TX_AUDIO_CH_COUNT		(V4L2_CID_DV_CID_CUSTOM_BASE + 3)
/* audio i2s format */
#define V4L2_CID_DV_TX_AUDIO_I2S_FORMAT		(V4L2_CID_DV_CID_CUSTOM_BASE + 4)
/* to be hooked up to events */
/* hotplug present or not */
#define V4L2_CID_DV_TX_HOTPLUG			(V4L2_CID_DV_CID_CUSTOM_BASE + 5)
/* rx sense */
#define V4L2_CID_DV_TX_RXSENSE			(V4L2_CID_DV_CID_CUSTOM_BASE + 6)
/* edid present */
#define V4L2_CID_DV_TX_EDID_SEGMENT0_PRESENT	(V4L2_CID_DV_CID_CUSTOM_BASE + 7)
/* audio channel mapping - refer to CEA 861D */
#define V4L2_CID_DV_TX_AUDIO_CH_MAP		(V4L2_CID_DV_CID_CUSTOM_BASE + 8)
/* cable detect */
#define V4L2_CID_DV_CABLE_DETECT		(V4L2_CID_DV_CID_CUSTOM_BASE + 9)
/* 5v from source detected */
#define V4L2_CID_DV_RX_TX_POWER			(V4L2_CID_DV_CID_CUSTOM_BASE + 10)
/* dvi-a sync detection */
#define V4L2_CID_DV_SYNC_DETECT			(V4L2_CID_DV_CID_CUSTOM_BASE + 11)
/* analog sampling phase */
#define V4L2_CID_DV_RX_ANALOG_SAMPLING_PHASE	(V4L2_CID_DV_CID_CUSTOM_BASE + 12)
/* free run color manual */
#define V4L2_CID_FREE_RUN_COLOR_MANUAL		(V4L2_CID_DV_CID_CUSTOM_BASE + 13)
/* free run color */
#define V4L2_CID_FREE_RUN_COLOR			(V4L2_CID_DV_CID_CUSTOM_BASE + 14)
/* hdmi/dvi-d RGB limited range */
#define V4L2_CID_RGB_QUANTIZATION_RANGE		(V4L2_CID_DV_CID_CUSTOM_BASE + 15)

/*
 *	D V	P R E S E T	V A L U E S
 */
#define		V4L2_DV_PRESET_MASK		0xf0000000

/* 0x00000000 - 0x000000ff reserved for CEA 861 formats */
#define		V4L2_DV_CEA_861_FORMAT		0x00000000

/* 0x10000000 - 0x100000ff reserved for DMT formats */
#define		V4L2_DV_DMT_FORMAT		0x10000000

#define		V4L2_DV_DMT_640X350P85		(V4L2_DV_DMT_FORMAT + 0x01)
#define		V4L2_DV_DMT_640X400P85		(V4L2_DV_DMT_FORMAT + 0x02)
#define		V4L2_DV_DMT_720X400P85		(V4L2_DV_DMT_FORMAT + 0x03)
#define		V4L2_DV_DMT_640X480P60		(V4L2_DV_DMT_FORMAT + 0x04)
#define		V4L2_DV_DMT_640X480P72		(V4L2_DV_DMT_FORMAT + 0x05)
#define		V4L2_DV_DMT_640X480P75		(V4L2_DV_DMT_FORMAT + 0x06)
#define		V4L2_DV_DMT_640X480P85		(V4L2_DV_DMT_FORMAT + 0x07)
#define		V4L2_DV_DMT_800X600P56		(V4L2_DV_DMT_FORMAT + 0x08)
#define		V4L2_DV_DMT_800X600P60		(V4L2_DV_DMT_FORMAT + 0x09)
#define		V4L2_DV_DMT_800X600P72		(V4L2_DV_DMT_FORMAT + 0x0a)
#define		V4L2_DV_DMT_800X600P75		(V4L2_DV_DMT_FORMAT + 0x0b)
#define		V4L2_DV_DMT_800X600P85		(V4L2_DV_DMT_FORMAT + 0x0c)
#define		V4L2_DV_DMT_800X600P120RB	(V4L2_DV_DMT_FORMAT + 0x0d)
#define		V4L2_DV_DMT_848X480P60		(V4L2_DV_DMT_FORMAT + 0x0e)
#define		V4L2_DV_DMT_1024X768I43		(V4L2_DV_DMT_FORMAT + 0x0f)
#define		V4L2_DV_DMT_1024X768P60		(V4L2_DV_DMT_FORMAT + 0x10)
#define		V4L2_DV_DMT_1024X768P70		(V4L2_DV_DMT_FORMAT + 0x11)
#define		V4L2_DV_DMT_1024X768P75		(V4L2_DV_DMT_FORMAT + 0x12)
#define		V4L2_DV_DMT_1024X768P85		(V4L2_DV_DMT_FORMAT + 0x13)
#define		V4L2_DV_DMT_1024X768P120RB	(V4L2_DV_DMT_FORMAT + 0x14)
#define		V4L2_DV_DMT_1152X864P75		(V4L2_DV_DMT_FORMAT + 0x15)
#define		V4L2_DV_DMT_1280X768P60RB	(V4L2_DV_DMT_FORMAT + 0x16)
#define		V4L2_DV_DMT_1280X768P60		(V4L2_DV_DMT_FORMAT + 0x17)
#define		V4L2_DV_DMT_1280X768P75		(V4L2_DV_DMT_FORMAT + 0x18)
#define		V4L2_DV_DMT_1280X768P85		(V4L2_DV_DMT_FORMAT + 0x19)
#define		V4L2_DV_DMT_1280X768P120RB	(V4L2_DV_DMT_FORMAT + 0x1a)
#define		V4L2_DV_DMT_1280X800P60RB	(V4L2_DV_DMT_FORMAT + 0x1b)
#define		V4L2_DV_DMT_1280X800P60		(V4L2_DV_DMT_FORMAT + 0x1c)
#define		V4L2_DV_DMT_1280X800P75		(V4L2_DV_DMT_FORMAT + 0x1d)
#define		V4L2_DV_DMT_1280X800P85		(V4L2_DV_DMT_FORMAT + 0x1e)
#define		V4L2_DV_DMT_1280X800P120RB	(V4L2_DV_DMT_FORMAT + 0x1f)
#define		V4L2_DV_DMT_1280X960P60		(V4L2_DV_DMT_FORMAT + 0x20)
#define		V4L2_DV_DMT_1280X960P85		(V4L2_DV_DMT_FORMAT + 0x21)
#define		V4L2_DV_DMT_1280X960P120RB	(V4L2_DV_DMT_FORMAT + 0x22)
#define		V4L2_DV_DMT_1280X1024P60	(V4L2_DV_DMT_FORMAT + 0x23)
#define		V4L2_DV_DMT_1280X1024P75	(V4L2_DV_DMT_FORMAT + 0x24)
#define		V4L2_DV_DMT_1280X1024P85	(V4L2_DV_DMT_FORMAT + 0x25)
#define		V4L2_DV_DMT_1280X1024P120RB	(V4L2_DV_DMT_FORMAT + 0x26)
#define		V4L2_DV_DMT_1360X768P60		(V4L2_DV_DMT_FORMAT + 0x27)
#define		V4L2_DV_DMT_1360X768P120RB	(V4L2_DV_DMT_FORMAT + 0x28)
#define		V4L2_DV_DMT_1400X1050P60RB	(V4L2_DV_DMT_FORMAT + 0x29)
#define		V4L2_DV_DMT_1400X1050P60	(V4L2_DV_DMT_FORMAT + 0x2a)
#define		V4L2_DV_DMT_1400X1050P75	(V4L2_DV_DMT_FORMAT + 0x2b)
#define		V4L2_DV_DMT_1400X1050P85	(V4L2_DV_DMT_FORMAT + 0x2c)
#define		V4L2_DV_DMT_1400X1050P120RB	(V4L2_DV_DMT_FORMAT + 0x2d)
#define		V4L2_DV_DMT_1440X900P60RB	(V4L2_DV_DMT_FORMAT + 0x2e)
#define		V4L2_DV_DMT_1440X900P60		(V4L2_DV_DMT_FORMAT + 0x2f)
#define		V4L2_DV_DMT_1440X900P75		(V4L2_DV_DMT_FORMAT + 0x30)
#define		V4L2_DV_DMT_1440X900P85		(V4L2_DV_DMT_FORMAT + 0x31)
#define		V4L2_DV_DMT_1440X900P120RB	(V4L2_DV_DMT_FORMAT + 0x32)
#define		V4L2_DV_DMT_1600X1200P60	(V4L2_DV_DMT_FORMAT + 0x33)
#define		V4L2_DV_DMT_1600X1200P65	(V4L2_DV_DMT_FORMAT + 0x34)
#define		V4L2_DV_DMT_1600X1200P70	(V4L2_DV_DMT_FORMAT + 0x35)
#define		V4L2_DV_DMT_1600X1200P75	(V4L2_DV_DMT_FORMAT + 0x36)
#define		V4L2_DV_DMT_1600X1200P85	(V4L2_DV_DMT_FORMAT + 0x37)
#define		V4L2_DV_DMT_1600X1200P120RB	(V4L2_DV_DMT_FORMAT + 0x38)
#define		V4L2_DV_DMT_1680X1050P60RB	(V4L2_DV_DMT_FORMAT + 0x39)
#define		V4L2_DV_DMT_1680X1050P60	(V4L2_DV_DMT_FORMAT + 0x3a)
#define		V4L2_DV_DMT_1680X1050P75	(V4L2_DV_DMT_FORMAT + 0x3b)
#define		V4L2_DV_DMT_1680X1050P85	(V4L2_DV_DMT_FORMAT + 0x3c)
#define		V4L2_DV_DMT_1680X1050P120RB	(V4L2_DV_DMT_FORMAT + 0x3d)
#define		V4L2_DV_DMT_1792X1344P60	(V4L2_DV_DMT_FORMAT + 0x3e)
#define		V4L2_DV_DMT_1792X1344P75	(V4L2_DV_DMT_FORMAT + 0x3f)
#define		V4L2_DV_DMT_1792X1344P120RB	(V4L2_DV_DMT_FORMAT + 0x40)
#define		V4L2_DV_DMT_1856X1392P60	(V4L2_DV_DMT_FORMAT + 0x41)
#define		V4L2_DV_DMT_1856X1392P75	(V4L2_DV_DMT_FORMAT + 0x42)
#define		V4L2_DV_DMT_1856X1392P120RB	(V4L2_DV_DMT_FORMAT + 0x43)
#define		V4L2_DV_DMT_1920X1200P60RB	(V4L2_DV_DMT_FORMAT + 0x44)
#define		V4L2_DV_DMT_1920X1200P60	(V4L2_DV_DMT_FORMAT + 0x45)
#define		V4L2_DV_DMT_1920X1200P75	(V4L2_DV_DMT_FORMAT + 0x46)
#define		V4L2_DV_DMT_1920X1200P85	(V4L2_DV_DMT_FORMAT + 0x47)
#define		V4L2_DV_DMT_1920X1200P120RB	(V4L2_DV_DMT_FORMAT + 0x48)
#define		V4L2_DV_DMT_1920X1440P60	(V4L2_DV_DMT_FORMAT + 0x49)
#define		V4L2_DV_DMT_1920X1440P75	(V4L2_DV_DMT_FORMAT + 0x4a)
#define		V4L2_DV_DMT_1920X1440P120RB	(V4L2_DV_DMT_FORMAT + 0x4b)
#define		V4L2_DV_DMT_2560X1600P60RB	(V4L2_DV_DMT_FORMAT + 0x4c)
#define		V4L2_DV_DMT_2560X1600P60	(V4L2_DV_DMT_FORMAT + 0x4d)
#define		V4L2_DV_DMT_2560X1600P75	(V4L2_DV_DMT_FORMAT + 0x4e)
#define		V4L2_DV_DMT_2560X1600P85	(V4L2_DV_DMT_FORMAT + 0x4f)
#define		V4L2_DV_DMT_2560X1600P120RB	(V4L2_DV_DMT_FORMAT + 0x50)
#define		V4L2_DV_DMT_1366X768P60		(V4L2_DV_DMT_FORMAT + 0x51)
#define		V4L2_DV_DMT_1920X1080P60	(V4L2_DV_DMT_FORMAT + 0x52)

/* CVT format */
#define		V4L2_DV_CVT_FORMAT		0x20000000
/* GTF format */
#define		V4L2_DV_GTF_FORMAT		0x30000000
/* Special formats that doesn't follow any standard */
#define		V4L2_DV_SPECIAL_FORMAT		0xe0000000
/* Error codes */
#define		V4L2_DV_UNSUPPORTED_SIGNAL	0xf0000000

#endif
