/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedExtensions;
import org.openapitools.openapidiff.core.model.ChangedOperation;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffResult;
import org.openapitools.openapidiff.core.model.Endpoint;
import org.openapitools.openapidiff.core.utils.EndpointUtils;

public class ChangedOpenApi
implements ComposedChanged {
    private OpenAPI oldSpecOpenApi;
    private OpenAPI newSpecOpenApi;
    private List<Endpoint> newEndpoints;
    private List<Endpoint> missingEndpoints;
    private List<ChangedOperation> changedOperations;
    private List<ChangedSchema> changedSchemas;
    private ChangedExtensions changedExtensions;

    public List<Endpoint> getDeprecatedEndpoints() {
        return this.changedOperations.stream().filter(ChangedOperation::isDeprecated).map(c -> EndpointUtils.convert2Endpoint(c.getPathUrl(), c.getHttpMethod(), c.getNewOperation())).collect(Collectors.toList());
    }

    @Override
    public List<Changed> getChangedElements() {
        return Stream.concat(Stream.concat(this.changedOperations.stream(), Stream.of(this.changedExtensions)), this.changedSchemas.stream()).collect(Collectors.toList());
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.newEndpoints.isEmpty() && this.missingEndpoints.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (this.missingEndpoints.isEmpty()) {
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.INCOMPATIBLE;
    }

    public OpenAPI getOldSpecOpenApi() {
        return this.oldSpecOpenApi;
    }

    public OpenAPI getNewSpecOpenApi() {
        return this.newSpecOpenApi;
    }

    public List<Endpoint> getNewEndpoints() {
        return this.newEndpoints;
    }

    public List<Endpoint> getMissingEndpoints() {
        return this.missingEndpoints;
    }

    public List<ChangedOperation> getChangedOperations() {
        return this.changedOperations;
    }

    public ChangedExtensions getChangedExtensions() {
        return this.changedExtensions;
    }

    public List<ChangedSchema> getChangedSchemas() {
        return this.changedSchemas;
    }

    public ChangedOpenApi setOldSpecOpenApi(OpenAPI oldSpecOpenApi) {
        this.oldSpecOpenApi = oldSpecOpenApi;
        return this;
    }

    public ChangedOpenApi setNewSpecOpenApi(OpenAPI newSpecOpenApi) {
        this.newSpecOpenApi = newSpecOpenApi;
        return this;
    }

    public ChangedOpenApi setNewEndpoints(List<Endpoint> newEndpoints) {
        this.newEndpoints = newEndpoints;
        return this;
    }

    public ChangedOpenApi setMissingEndpoints(List<Endpoint> missingEndpoints) {
        this.missingEndpoints = missingEndpoints;
        return this;
    }

    public ChangedOpenApi setChangedOperations(List<ChangedOperation> changedOperations) {
        this.changedOperations = changedOperations;
        return this;
    }

    public ChangedOpenApi setChangedExtensions(ChangedExtensions changedExtensions) {
        this.changedExtensions = changedExtensions;
        return this;
    }

    public ChangedOpenApi setChangedSchemas(List<ChangedSchema> changedSchemas) {
        this.changedSchemas = changedSchemas;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedOpenApi that = (ChangedOpenApi)o;
        return Objects.equals(this.oldSpecOpenApi, that.oldSpecOpenApi) && Objects.equals(this.newSpecOpenApi, that.newSpecOpenApi) && Objects.equals(this.newEndpoints, that.newEndpoints) && Objects.equals(this.missingEndpoints, that.missingEndpoints) && Objects.equals(this.changedOperations, that.changedOperations) && Objects.equals(this.changedExtensions, that.changedExtensions);
    }

    public int hashCode() {
        return Objects.hash(this.oldSpecOpenApi, this.newSpecOpenApi, this.newEndpoints, this.missingEndpoints, this.changedOperations, this.changedExtensions);
    }

    public String toString() {
        return "ChangedOpenApi(oldSpecOpenApi=" + this.getOldSpecOpenApi() + ", newSpecOpenApi=" + this.getNewSpecOpenApi() + ", newEndpoints=" + this.getNewEndpoints() + ", missingEndpoints=" + this.getMissingEndpoints() + ", changedOperations=" + this.getChangedOperations() + ", changedExtensions=" + this.getChangedExtensions() + ")";
    }
}

