/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.store.IndexIntervalManager;
import com.amazon.randomcutforest.tree.AbstractNodeStore;
import com.amazon.randomcutforest.tree.BoundingBox;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Stack;

public class NodeStoreSmall
extends AbstractNodeStore {
    private final byte[] parentIndex;
    private final char[] leftIndex;
    private final char[] rightIndex;
    public final byte[] cutDimension;
    private final byte[] mass;

    public NodeStoreSmall(AbstractNodeStore.Builder builder) {
        super(builder);
        this.mass = new byte[this.capacity];
        Arrays.fill(this.mass, (byte)0);
        if (builder.storeParent) {
            this.parentIndex = new byte[this.capacity];
            Arrays.fill(this.parentIndex, (byte)this.capacity);
        } else {
            this.parentIndex = null;
        }
        if (builder.leftIndex == null) {
            this.leftIndex = new char[this.capacity];
            this.rightIndex = new char[this.capacity];
            this.cutDimension = new byte[this.capacity];
            Arrays.fill(this.leftIndex, (char)this.capacity);
            Arrays.fill(this.rightIndex, (char)this.capacity);
        } else {
            int i;
            CommonUtils.checkArgument(builder.leftIndex.length == this.capacity, " incorrect length");
            CommonUtils.checkArgument(builder.rightIndex.length == this.capacity, " incorrect length");
            this.leftIndex = CommonUtils.toCharArray(builder.leftIndex);
            this.rightIndex = CommonUtils.toCharArray(builder.rightIndex);
            this.cutDimension = CommonUtils.toByteArray(builder.cutDimension);
            BitSet bits = new BitSet(this.capacity);
            if (builder.root != Null) {
                bits.set(builder.root);
            }
            for (i = 0; i < this.leftIndex.length; ++i) {
                if (!this.isInternal(this.leftIndex[i])) continue;
                bits.set(this.leftIndex[i]);
                if (this.parentIndex == null) continue;
                this.parentIndex[this.leftIndex[i]] = (byte)i;
            }
            for (i = 0; i < this.rightIndex.length; ++i) {
                if (!this.isInternal(this.rightIndex[i])) continue;
                bits.set(this.rightIndex[i]);
                if (this.parentIndex == null) continue;
                this.parentIndex[this.rightIndex[i]] = (byte)i;
            }
            this.freeNodeManager = new IndexIntervalManager(this.capacity, this.capacity, bits);
        }
    }

    @Override
    public int addNode(Stack<int[]> pathToRoot, float[] point, long sequenceIndex, int pointIndex, int childIndex, int childMassIfLeaf, int cutDimension, float cutValue, BoundingBox box) {
        int parentIndex;
        int index = this.freeNodeManager.takeIndex();
        this.cutValue[index] = cutValue;
        this.cutDimension[index] = (byte)cutDimension;
        if (this.leftOf(cutValue, cutDimension, point)) {
            this.leftIndex[index] = (char)(pointIndex + this.capacity + 1);
            this.rightIndex[index] = (char)childIndex;
        } else {
            this.rightIndex[index] = (char)(pointIndex + this.capacity + 1);
            this.leftIndex[index] = (char)childIndex;
        }
        this.mass[index] = (byte)(((childMassIfLeaf > 0 ? childMassIfLeaf : this.getMass(childIndex)) + 1) % (this.capacity + 1));
        int n = parentIndex = pathToRoot.size() == 0 ? Null : ((int[])pathToRoot.lastElement())[0];
        if (this.parentIndex != null) {
            this.parentIndex[index] = (byte)parentIndex;
            if (!this.isLeaf(childIndex)) {
                this.parentIndex[childIndex] = (byte)index;
            }
        }
        if (parentIndex != Null) {
            this.spliceEdge(parentIndex, childIndex, index);
        }
        return index;
    }

    @Override
    public void assignInPartialTree(int node, float[] point, int childReference) {
        if (this.leftOf(node, point)) {
            this.leftIndex[node] = (char)childReference;
        } else {
            this.rightIndex[node] = (char)childReference;
        }
    }

    @Override
    public int getLeftIndex(int index) {
        return this.leftIndex[index];
    }

    @Override
    public int getRightIndex(int index) {
        return this.rightIndex[index];
    }

    @Override
    public int getParentIndex(int index) {
        CommonUtils.checkArgument(this.parentIndex != null, "incorrect call");
        return this.parentIndex[index];
    }

    @Override
    public void setRoot(int index) {
        if (!this.isLeaf(index) && this.parentIndex != null) {
            this.parentIndex[index] = (byte)this.capacity;
        }
    }

    @Override
    protected void decreaseMassOfInternalNode(int node) {
        this.mass[node] = (byte)(((this.mass[node] & 0xFF) + this.capacity) % (this.capacity + 1));
    }

    @Override
    protected void increaseMassOfInternalNode(int node) {
        this.mass[node] = (byte)(((this.mass[node] & 0xFF) + 1) % (this.capacity + 1));
    }

    @Override
    public void deleteInternalNode(int index) {
        this.leftIndex[index] = (char)this.capacity;
        this.rightIndex[index] = (char)this.capacity;
        if (this.parentIndex != null) {
            this.parentIndex[index] = (byte)this.capacity;
        }
        this.freeNodeManager.releaseIndex(index);
    }

    @Override
    public int getMass(int index) {
        return this.mass[index] != 0 ? this.mass[index] & 0xFF : this.capacity + 1;
    }

    @Override
    public void spliceEdge(int parent, int node, int newNode) {
        assert (!this.isLeaf(newNode));
        if (node == this.leftIndex[parent]) {
            this.leftIndex[parent] = (char)newNode;
        } else {
            this.rightIndex[parent] = (char)newNode;
        }
        if (this.parentIndex != null && this.isInternal(node)) {
            this.parentIndex[node] = (byte)newNode;
        }
    }

    @Override
    public void replaceParentBySibling(int grandParent, int parent, int node) {
        int sibling = this.getSibling(node, parent);
        if (parent == this.leftIndex[grandParent]) {
            this.leftIndex[grandParent] = (char)sibling;
        } else {
            this.rightIndex[grandParent] = (char)sibling;
        }
        if (this.parentIndex != null && this.isInternal(sibling)) {
            this.parentIndex[sibling] = (byte)grandParent;
        }
    }

    @Override
    public int getCutDimension(int index) {
        return this.cutDimension[index] & 0xFF;
    }

    @Override
    public int[] getCutDimension() {
        return CommonUtils.toIntArray(this.cutDimension);
    }

    @Override
    public int[] getLeftIndex() {
        return CommonUtils.toIntArray(this.leftIndex);
    }

    @Override
    public int[] getRightIndex() {
        return CommonUtils.toIntArray(this.rightIndex);
    }
}

