function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import PropTypes from 'prop-types';
import React from 'react';
import { KuiButton, KuiButtonIcon, KuiButtonGroup } from '../button';
export function KuiPagerButtonGroup(_ref) {
  let {
    className,
    onPrevious,
    onNext,
    hasNext,
    hasPrevious,
    ...rest
  } = _ref;
  return /*#__PURE__*/React.createElement(KuiButtonGroup, _extends({
    isUnited: true,
    className: className
  }, rest), /*#__PURE__*/React.createElement(KuiButton, {
    "aria-label": "Show previous page",
    "data-test-subj": "pagerPreviousButton",
    buttonType: "basic",
    onClick: onPrevious,
    disabled: !hasPrevious,
    icon: /*#__PURE__*/React.createElement(KuiButtonIcon, {
      type: "previous"
    })
  }), /*#__PURE__*/React.createElement(KuiButton, {
    "aria-label": "Show next page",
    "data-test-subj": "pagerNextButton",
    buttonType: "basic",
    onClick: onNext,
    disabled: !hasNext,
    icon: /*#__PURE__*/React.createElement(KuiButtonIcon, {
      type: "next"
    })
  }));
}
KuiPagerButtonGroup.propTypes = {
  onPrevious: PropTypes.func.isRequired,
  onNext: PropTypes.func.isRequired,
  hasNext: PropTypes.bool.isRequired,
  hasPrevious: PropTypes.bool.isRequired,
  className: PropTypes.string
};
