"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspaceIdConsumerWrapper = void 0;
var _utils = require("../../../../core/server/utils");
var _server = require("../../../../core/server");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class WorkspaceIdConsumerWrapper {
  formatWorkspaceIdParams(request, options) {
    const {
      workspaces,
      ...others
    } = options || {};
    const workspaceState = (0, _utils.getWorkspaceState)(request);
    const workspaceIdParsedFromRequest = workspaceState === null || workspaceState === void 0 ? void 0 : workspaceState.requestWorkspaceId;
    const workspaceIdsInUserOptions = options === null || options === void 0 ? void 0 : options.workspaces;
    let finalWorkspaces = [];
    if (options !== null && options !== void 0 && options.hasOwnProperty('workspaces')) {
      finalWorkspaces = workspaceIdsInUserOptions || [];
    } else if (workspaceIdParsedFromRequest) {
      finalWorkspaces = [workspaceIdParsedFromRequest];
    }
    return {
      ...others,
      ...(finalWorkspaces.length ? {
        workspaces: finalWorkspaces
      } : {})
    };
  }
  isWorkspaceType(type) {
    if (Array.isArray(type)) {
      return type.every(item => item === _server.WORKSPACE_TYPE);
    }
    return type === _server.WORKSPACE_TYPE;
  }
  constructor(isPermissionControlEnabled) {
    this.isPermissionControlEnabled = isPermissionControlEnabled;
    _defineProperty(this, "wrapperFactory", wrapperOptions => {
      return {
        ...wrapperOptions.client,
        create: (type, attributes, options = {}) => wrapperOptions.client.create(type, attributes, this.formatWorkspaceIdParams(wrapperOptions.request, options)),
        bulkCreate: (objects, options = {}) => wrapperOptions.client.bulkCreate(objects, this.formatWorkspaceIdParams(wrapperOptions.request, options)),
        checkConflicts: (objects = [], options = {}) => wrapperOptions.client.checkConflicts(objects, this.formatWorkspaceIdParams(wrapperOptions.request, options)),
        delete: wrapperOptions.client.delete,
        find: options => {
          const findOptions = this.formatWorkspaceIdParams(wrapperOptions.request, options);
          if (this.isWorkspaceType(findOptions.type)) {
            return wrapperOptions.client.find(findOptions);
          }

          // if workspace is enabled, we always find by workspace
          if (!findOptions.workspaces || findOptions.workspaces.length === 0) {
            findOptions.workspaces = [_server.PUBLIC_WORKSPACE_ID];
          }

          // `PUBLIC_WORKSPACE_ID` includes both saved objects without any workspace and with `PUBLIC_WORKSPACE_ID` workspace
          const index = findOptions.workspaces ? findOptions.workspaces.indexOf(_server.PUBLIC_WORKSPACE_ID) : -1;
          if (!findOptions.workspacesSearchOperator && findOptions.workspaces && index !== -1) {
            findOptions.workspacesSearchOperator = 'OR';
            // remove this deletion logic when public workspace becomes to real
            if (this.isPermissionControlEnabled) {
              // remove public workspace to make sure we can pass permission control validation, more details in `WorkspaceSavedObjectsClientWrapper`
              findOptions.workspaces.splice(index, 1);
            }
          }
          if (findOptions.workspaces && findOptions.workspaces.length === 0) {
            delete findOptions.workspaces;
          }
          return wrapperOptions.client.find(findOptions);
        },
        bulkGet: wrapperOptions.client.bulkGet,
        get: wrapperOptions.client.get,
        update: wrapperOptions.client.update,
        bulkUpdate: wrapperOptions.client.bulkUpdate,
        addToNamespaces: wrapperOptions.client.addToNamespaces,
        deleteFromNamespaces: wrapperOptions.client.deleteFromNamespaces,
        deleteByWorkspace: wrapperOptions.client.deleteByWorkspace
      };
    });
  }
}
exports.WorkspaceIdConsumerWrapper = WorkspaceIdConsumerWrapper;