"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrincipalsFromRequest = exports.generateRandomId = void 0;
var _crypto = _interopRequireDefault(require("crypto"));
var _server = require("../../../core/server");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Generate URL friendly random ID
 */
const generateRandomId = size => {
  return _crypto.default.randomBytes(size).toString('base64url').slice(0, size);
};
exports.generateRandomId = generateRandomId;
const getPrincipalsFromRequest = (request, auth) => {
  const payload = {};
  const authInfoResp = auth === null || auth === void 0 ? void 0 : auth.get(request);
  if ((authInfoResp === null || authInfoResp === void 0 ? void 0 : authInfoResp.status) === _server.AuthStatus.unknown) {
    /**
     * Login user have access to all the workspaces when no authentication is presented.
     */
    return payload;
  }
  if ((authInfoResp === null || authInfoResp === void 0 ? void 0 : authInfoResp.status) === _server.AuthStatus.authenticated) {
    var _authInfo$authInfo, _authInfo$authInfo2;
    const authInfo = authInfoResp === null || authInfoResp === void 0 ? void 0 : authInfoResp.state;
    if (authInfo !== null && authInfo !== void 0 && (_authInfo$authInfo = authInfo.authInfo) !== null && _authInfo$authInfo !== void 0 && _authInfo$authInfo.backend_roles) {
      payload[_server.PrincipalType.Groups] = authInfo.authInfo.backend_roles;
    }
    if (authInfo !== null && authInfo !== void 0 && (_authInfo$authInfo2 = authInfo.authInfo) !== null && _authInfo$authInfo2 !== void 0 && _authInfo$authInfo2.user_name) {
      payload[_server.PrincipalType.Users] = [authInfo.authInfo.user_name];
    }
    return payload;
  }
  if ((authInfoResp === null || authInfoResp === void 0 ? void 0 : authInfoResp.status) === _server.AuthStatus.unauthenticated) {
    throw new Error('NOT_AUTHORIZED');
  }
  throw new Error('UNEXPECTED_AUTHORIZATION_STATUS');
};
exports.getPrincipalsFromRequest = getPrincipalsFromRequest;