"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolutionOptions = exports.VISUALIZATION = exports.SAVED_VISUALIZATION = exports.REDUX_SLICE_METRICS = exports.PPL_DATASOURCES_REQUEST = exports.OBSERVABILITY_CUSTOM_METRIC = exports.METRIC_EXPLORER_BASE_PATH = exports.AGGREGATION_OPTIONS = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const METRIC_EXPLORER_BASE_PATH = exports.METRIC_EXPLORER_BASE_PATH = 'observability-metrics#/';

// requests constants
const VISUALIZATION = exports.VISUALIZATION = 'viz';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = 'savedVisualization';
const PPL_DATASOURCES_REQUEST = exports.PPL_DATASOURCES_REQUEST = 'show datasources | where CONNECTOR_TYPE="PROMETHEUS" | fields DATASOURCE_NAME';

// redux

const OBSERVABILITY_CUSTOM_METRIC = exports.OBSERVABILITY_CUSTOM_METRIC = 'CUSTOM_METRICS';
const REDUX_SLICE_METRICS = exports.REDUX_SLICE_METRICS = 'metrics';
const resolutionOptions = exports.resolutionOptions = [{
  value: 's',
  text: 'seconds'
}, {
  value: 'm',
  text: 'minutes'
}, {
  value: 'h',
  text: 'hours'
}, {
  value: 'd',
  text: 'days'
},
// { value: 'M', text: 'Months' }, // commenting it here as prometheus doesn't have support
// { value: 'q', text: 'quarters' },
{
  value: 'y',
  text: 'years'
}];
const AGGREGATION_OPTIONS = exports.AGGREGATION_OPTIONS = [{
  value: 'avg',
  text: 'avg()'
}, {
  value: 'sum',
  text: 'sum()'
}, {
  value: 'count',
  text: 'count()'
}, {
  value: 'min',
  text: 'min()'
}, {
  value: 'max',
  text: 'max()'
}];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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