"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEventAnalyticsRouter = void 0;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const registerEventAnalyticsRouter = ({
  router,
  savedObjectFacet
}) => {
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}`,
    validate: {}
  }, async (context, req, res) => {
    var _savedRes$data, _savedRes$data2;
    const savedRes = await savedObjectFacet.getSavedObject(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 || (_savedRes$data = savedRes.data) === null || _savedRes$data === void 0 ? void 0 : _savedRes$data.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data2 = savedRes.data) === null || _savedRes$data2 === void 0 ? void 0 : _savedRes$data2.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectId}`,
    validate: {
      params: _configSchema.schema.object({
        objectId: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data3, _savedRes$data4;
    const savedRes = await savedObjectFacet.getSavedObjectById(req, req.params.objectId);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success || (savedRes === null || savedRes === void 0 || (_savedRes$data3 = savedRes.data) === null || _savedRes$data3 === void 0 ? void 0 : _savedRes$data3.statusCode) === 404) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data4 = savedRes.data) === null || _savedRes$data4 === void 0 ? void 0 : _savedRes$data4.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data5;
    const savedRes = await savedObjectFacet.createSavedQuery(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data5 = savedRes.data) === null || _savedRes$data5 === void 0 ? void 0 : _savedRes$data5.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          userConfigs: _configSchema.schema.maybe(_configSchema.schema.string()),
          subType: _configSchema.schema.maybe(_configSchema.schema.string()),
          units_of_measure: _configSchema.schema.maybe(_configSchema.schema.string()),
          selected_labels: _configSchema.schema.maybe(_configSchema.schema.object({
            label: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))
          }))
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data6;
    const savedRes = await savedObjectFacet.createSavedVisualization(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data6 = savedRes.data) === null || _savedRes$data6 === void 0 ? void 0 : _savedRes$data6.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_QUERY}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data7;
    const savedRes = await savedObjectFacet.updateSavedQuery(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data7 = savedRes.data) === null || _savedRes$data7 === void 0 ? void 0 : _savedRes$data7.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}${_shared.SAVED_VISUALIZATION}`,
    validate: {
      body: _configSchema.schema.object({
        object_id: _configSchema.schema.string(),
        object: _configSchema.schema.object({
          query: _configSchema.schema.string(),
          selected_date_range: _configSchema.schema.object({
            start: _configSchema.schema.string(),
            end: _configSchema.schema.string(),
            text: _configSchema.schema.string()
          }),
          selected_timestamp: _configSchema.schema.object({
            name: _configSchema.schema.string(),
            type: _configSchema.schema.string()
          }),
          selected_fields: _configSchema.schema.object({
            tokens: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            })),
            text: _configSchema.schema.string()
          }),
          type: _configSchema.schema.string(),
          name: _configSchema.schema.string(),
          description: _configSchema.schema.string(),
          application_id: _configSchema.schema.maybe(_configSchema.schema.string()),
          userConfigs: _configSchema.schema.maybe(_configSchema.schema.string()),
          subType: _configSchema.schema.maybe(_configSchema.schema.string()),
          units_of_measure: _configSchema.schema.maybe(_configSchema.schema.string()),
          selected_labels: _configSchema.schema.maybe(_configSchema.schema.object({
            labels: _configSchema.schema.arrayOf(_configSchema.schema.object({}, {
              unknowns: 'allow'
            }))
          }))
        })
      })
    }
  }, async (context, req, res) => {
    var _updateRes$data;
    const updateRes = await savedObjectFacet.updateSavedVisualization(req);
    const result = {
      body: {
        ...updateRes.data
      }
    };
    if (updateRes.success) return res.ok(result);
    result.statusCode = (updateRes === null || updateRes === void 0 || (_updateRes$data = updateRes.data) === null || _updateRes$data === void 0 ? void 0 : _updateRes$data.statusCode) || 500;
    result.message = (updateRes === null || updateRes === void 0 ? void 0 : updateRes.data) || '';
    return res.custom(result);
  });
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        name: _configSchema.schema.string(),
        index: _configSchema.schema.string(),
        type: _configSchema.schema.string(),
        dsl_type: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data8;
    const savedRes = await savedObjectFacet.createSavedTimestamp(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data8 = savedRes.data) === null || _savedRes$data8 === void 0 ? void 0 : _savedRes$data8.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.put({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/timestamp`,
    validate: {
      body: _configSchema.schema.object({
        objectId: _configSchema.schema.string(),
        timestamp: _configSchema.schema.object({
          name: _configSchema.schema.string(),
          index: _configSchema.schema.string(),
          type: _configSchema.schema.string(),
          dsl_type: _configSchema.schema.string()
        })
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data9;
    const savedRes = await savedObjectFacet.updateSavedTimestamp(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data9 = savedRes.data) === null || _savedRes$data9 === void 0 ? void 0 : _savedRes$data9.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
  router.delete({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/{objectIdList}`,
    validate: {
      params: _configSchema.schema.object({
        objectIdList: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _deleteResponse$data;
    const deleteResponse = await savedObjectFacet.deleteSavedObject(req);
    const result = {
      body: {
        ...deleteResponse.data
      }
    };
    if (deleteResponse.success) return res.ok(result);
    result.statusCode = (deleteResponse === null || deleteResponse === void 0 || (_deleteResponse$data = deleteResponse.data) === null || _deleteResponse$data === void 0 ? void 0 : _deleteResponse$data.statusCode) || 500;
    result.message = (deleteResponse === null || deleteResponse === void 0 ? void 0 : deleteResponse.data) || '';
    return res.custom(result);
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.EVENT_ANALYTICS}${_shared.SAVED_OBJECTS}/addSampleSavedObjects/{sampleRequestor}`,
    validate: {
      params: _configSchema.schema.object({
        sampleRequestor: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    var _savedRes$data10;
    const savedRes = await savedObjectFacet.createSampleSavedObjects(req);
    const result = {
      body: {
        ...savedRes.data
      }
    };
    if (savedRes.success) return res.ok(result);
    result.statusCode = (savedRes === null || savedRes === void 0 || (_savedRes$data10 = savedRes.data) === null || _savedRes$data10 === void 0 ? void 0 : _savedRes$data10.statusCode) || 500;
    result.message = (savedRes === null || savedRes === void 0 ? void 0 : savedRes.data) || '';
    return res.custom(result);
  });
};
exports.registerEventAnalyticsRouter = registerEventAnalyticsRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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