"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPplRoute = registerPplRoute;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerPplRoute({
  router,
  facet
}) {
  router.post({
    path: `${_shared.PPL_BASE}${_shared.PPL_SEARCH}`,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        format: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    const queryRes = await facet.describeQuery(req);
    if (queryRes.success) {
      const result = {
        body: {
          ...queryRes.data
        }
      };
      return res.ok(result);
    }
    return res.custom({
      statusCode: queryRes.data.statusCode || queryRes.data.status || 500,
      body: queryRes.data.body || queryRes.data.message || ''
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9zaGFyZWQiLCJyZWdpc3RlclBwbFJvdXRlIiwicm91dGVyIiwiZmFjZXQiLCJwb3N0IiwicGF0aCIsIlBQTF9CQVNFIiwiUFBMX1NFQVJDSCIsInZhbGlkYXRlIiwiYm9keSIsInNjaGVtYSIsIm9iamVjdCIsInF1ZXJ5Iiwic3RyaW5nIiwiZm9ybWF0IiwiY29udGV4dCIsInJlcSIsInJlcyIsInF1ZXJ5UmVzIiwiZGVzY3JpYmVRdWVyeSIsInN1Y2Nlc3MiLCJyZXN1bHQiLCJkYXRhIiwib2siLCJjdXN0b20iLCJzdGF0dXNDb2RlIiwic3RhdHVzIiwibWVzc2FnZSJdLCJzb3VyY2VzIjpbInBwbC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IHNjaGVtYSB9IGZyb20gJ0Bvc2QvY29uZmlnLXNjaGVtYSc7XG5pbXBvcnQgeyBJUm91dGVyLCBJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZSwgUmVzcG9uc2VFcnJvciB9IGZyb20gJy4uLy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XG5pbXBvcnQgeyBQUExGYWNldCB9IGZyb20gJy4uL3NlcnZpY2VzL2ZhY2V0cy9wcGxfZmFjZXQnO1xuaW1wb3J0IHsgUFBMX0JBU0UsIFBQTF9TRUFSQ0ggfSBmcm9tICcuLi8uLi9jb21tb24vY29uc3RhbnRzL3NoYXJlZCc7XG5cbmV4cG9ydCBmdW5jdGlvbiByZWdpc3RlclBwbFJvdXRlKHsgcm91dGVyLCBmYWNldCB9OiB7IHJvdXRlcjogSVJvdXRlcjsgZmFjZXQ6IFBQTEZhY2V0IH0pIHtcbiAgcm91dGVyLnBvc3QoXG4gICAge1xuICAgICAgcGF0aDogYCR7UFBMX0JBU0V9JHtQUExfU0VBUkNIfWAsXG4gICAgICB2YWxpZGF0ZToge1xuICAgICAgICBib2R5OiBzY2hlbWEub2JqZWN0KHtcbiAgICAgICAgICBxdWVyeTogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICAgIGZvcm1hdDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB9KSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBhc3luYyAoY29udGV4dCwgcmVxLCByZXMpOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPGFueSB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgICBjb25zdCBxdWVyeVJlczogYW55ID0gYXdhaXQgZmFjZXQuZGVzY3JpYmVRdWVyeShyZXEpO1xuICAgICAgaWYgKHF1ZXJ5UmVzLnN1Y2Nlc3MpIHtcbiAgICAgICAgY29uc3QgcmVzdWx0OiBhbnkgPSB7XG4gICAgICAgICAgYm9keToge1xuICAgICAgICAgICAgLi4ucXVlcnlSZXMuZGF0YSxcbiAgICAgICAgICB9LFxuICAgICAgICB9O1xuICAgICAgICByZXR1cm4gcmVzLm9rKHJlc3VsdCk7XG4gICAgICB9XG4gICAgICByZXR1cm4gcmVzLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IHF1ZXJ5UmVzLmRhdGEuc3RhdHVzQ29kZSB8fCBxdWVyeVJlcy5kYXRhLnN0YXR1cyB8fCA1MDAsXG4gICAgICAgIGJvZHk6IHF1ZXJ5UmVzLmRhdGEuYm9keSB8fCBxdWVyeVJlcy5kYXRhLm1lc3NhZ2UgfHwgJycsXG4gICAgICB9KTtcbiAgICB9XG4gICk7XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLGFBQUEsR0FBQUMsT0FBQTtBQUdBLElBQUFDLE9BQUEsR0FBQUQsT0FBQTtBQVJBO0FBQ0E7QUFDQTtBQUNBOztBQU9PLFNBQVNFLGdCQUFnQkEsQ0FBQztFQUFFQyxNQUFNO0VBQUVDO0FBQTRDLENBQUMsRUFBRTtFQUN4RkQsTUFBTSxDQUFDRSxJQUFJLENBQ1Q7SUFDRUMsSUFBSSxFQUFHLEdBQUVDLGdCQUFTLEdBQUVDLGtCQUFXLEVBQUM7SUFDaENDLFFBQVEsRUFBRTtNQUNSQyxJQUFJLEVBQUVDLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztRQUNsQkMsS0FBSyxFQUFFRixvQkFBTSxDQUFDRyxNQUFNLENBQUMsQ0FBQztRQUN0QkMsTUFBTSxFQUFFSixvQkFBTSxDQUFDRyxNQUFNLENBQUM7TUFDeEIsQ0FBQztJQUNIO0VBQ0YsQ0FBQyxFQUNELE9BQU9FLE9BQU8sRUFBRUMsR0FBRyxFQUFFQyxHQUFHLEtBQWtFO0lBQ3hGLE1BQU1DLFFBQWEsR0FBRyxNQUFNZixLQUFLLENBQUNnQixhQUFhLENBQUNILEdBQUcsQ0FBQztJQUNwRCxJQUFJRSxRQUFRLENBQUNFLE9BQU8sRUFBRTtNQUNwQixNQUFNQyxNQUFXLEdBQUc7UUFDbEJaLElBQUksRUFBRTtVQUNKLEdBQUdTLFFBQVEsQ0FBQ0k7UUFDZDtNQUNGLENBQUM7TUFDRCxPQUFPTCxHQUFHLENBQUNNLEVBQUUsQ0FBQ0YsTUFBTSxDQUFDO0lBQ3ZCO0lBQ0EsT0FBT0osR0FBRyxDQUFDTyxNQUFNLENBQUM7TUFDaEJDLFVBQVUsRUFBRVAsUUFBUSxDQUFDSSxJQUFJLENBQUNHLFVBQVUsSUFBSVAsUUFBUSxDQUFDSSxJQUFJLENBQUNJLE1BQU0sSUFBSSxHQUFHO01BQ25FakIsSUFBSSxFQUFFUyxRQUFRLENBQUNJLElBQUksQ0FBQ2IsSUFBSSxJQUFJUyxRQUFRLENBQUNJLElBQUksQ0FBQ0ssT0FBTyxJQUFJO0lBQ3ZELENBQUMsQ0FBQztFQUNKLENBQ0YsQ0FBQztBQUNIIn0=