"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLFacet = void 0;
var _ppl_datasource = require("../../adaptors/ppl_datasource");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class PPLFacet {
  constructor(client) {
    this.client = client;
    _defineProperty(this, "fetch", async (request, format, responseFormat) => {
      const res = {
        success: false,
        data: {}
      };
      try {
        const params = {
          body: {
            query: request.body.query
          }
        };
        if (request.body.format !== 'jdbc') {
          params.format = request.body.format;
        }
        const queryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        const pplDataSource = new _ppl_datasource.PPLDataSource(queryRes, request.body.format);
        res.success = true;
        res.data = pplDataSource.getDataSource();
      } catch (err) {
        console.error('PPL query fetch err: ', err);
        res.data = err;
      }
      return res;
    });
    _defineProperty(this, "describeQuery", async request => {
      return this.fetch(request, 'ppl.pplQuery', 'json');
    });
    this.client = client;
  }
}
exports.PPLFacet = PPLFacet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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