
use builtin;
use str;

set edit:completion:arg-completer[uv] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'uv'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'uv'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand pip 'Resolve and install Python packages'
            cand tool 'Run and manage executable Python packages'
            cand toolchain 'Manage Python installations'
            cand run 'Run a command in the project environment'
            cand sync 'Sync the project''s dependencies with the environment'
            cand lock 'Resolve the project requirements into a lockfile'
            cand add 'Add one or more packages to the project requirements'
            cand remove 'Remove one or more packages from the project requirements'
            cand venv 'Create a virtual environment'
            cand cache 'Manage the cache'
            cand self 'Manage the `uv` executable'
            cand clean 'Clear the cache, removing all entries or those linked to specific packages'
            cand version 'Display uv''s version'
            cand generate-shell-completion 'Generate shell completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;pip'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand compile 'Compile a `requirements.in` file to a `requirements.txt` file'
            cand sync 'Sync an environment with a `requirements.txt` file'
            cand install 'Install packages into an environment'
            cand uninstall 'Uninstall packages from an environment'
            cand freeze 'List, in requirements format, packages installed in an environment'
            cand list 'List, in tabular format, packages installed in an environment'
            cand show 'Show information about one or more installed packages'
            cand tree 'Display the dependency tree for an environment'
            cand check 'Verify installed packages have compatible dependencies'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;pip;compile'= {
            cand -c 'Constrain versions using the given requirements files'
            cand --constraint 'Constrain versions using the given requirements files'
            cand --override 'Override versions using the given requirements files'
            cand --extra 'Include optional dependencies from the extra group name; may be provided more than once. Only applies to `pyproject.toml`, `setup.py`, and `setup.cfg` sources'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -o 'Write the compiled requirements to the given `requirements.txt` file'
            cand --output-file 'Write the compiled requirements to the given `requirements.txt` file'
            cand --annotation-style 'Choose the style of the annotation comments, which indicate the source of each package'
            cand --custom-compile-command 'Change header comment to reflect custom command wrapping `uv pip compile`'
            cand --python 'The Python interpreter against which to compile the requirements.'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --only-binary 'Only use pre-built wheels; don''t build source distributions'
            cand -p 'The minimum Python version that should be supported by the compiled requirements (e.g., `3.7` or `3.7.9`)'
            cand --python-version 'The minimum Python version that should be supported by the compiled requirements (e.g., `3.7` or `3.7.9`)'
            cand --python-platform 'The platform for which requirements should be resolved'
            cand --no-emit-package 'Specify a package to omit from the output resolution. Its dependencies will still be included in the resolution. Equivalent to pip-compile''s `--unsafe-package` option'
            cand --resolver 'resolver'
            cand --max-rounds 'max-rounds'
            cand --cert 'cert'
            cand --client-cert 'client-cert'
            cand --trusted-host 'trusted-host'
            cand --config 'config'
            cand --pip-args 'pip-args'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-extras 'Include all optional dependencies. Only applies to `pyproject.toml`, `setup.py`, and `setup.cfg` sources'
            cand --no-all-extras 'no-all-extras'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --no-upgrade 'no-upgrade'
            cand --pre 'pre'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --no-deps 'Ignore package dependencies, instead only add those packages explicitly listed on the command line to the resulting the requirements file'
            cand --deps 'deps'
            cand --no-strip-extras 'Include extras in the output file'
            cand --strip-extras 'strip-extras'
            cand --no-strip-markers 'Include environment markers in the output file'
            cand --strip-markers 'strip-markers'
            cand --no-annotate 'Exclude comment annotations indicating the source of each package'
            cand --annotate 'annotate'
            cand --no-header 'Exclude the comment header at the top of the generated output file'
            cand --header 'header'
            cand --system 'Install packages into the system Python'
            cand --no-system 'no-system'
            cand --generate-hashes 'Include distribution hashes in the output file'
            cand --no-generate-hashes 'no-generate-hashes'
            cand --legacy-setup-py 'Use legacy `setuptools` behavior when building source distributions without a `pyproject.toml`'
            cand --no-legacy-setup-py 'no-legacy-setup-py'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --universal 'Perform a universal resolution, attempting to generate a single `requirements.txt` output file that is compatible with all operating systems, architectures, and Python implementations'
            cand --no-universal 'no-universal'
            cand --emit-index-url 'Include `--index-url` and `--extra-index-url` entries in the generated output file'
            cand --no-emit-index-url 'no-emit-index-url'
            cand --emit-find-links 'Include `--find-links` entries in the generated output file'
            cand --no-emit-find-links 'no-emit-find-links'
            cand --emit-build-options 'Include `--no-binary` and `--only-binary` entries in the generated output file'
            cand --no-emit-build-options 'no-emit-build-options'
            cand --emit-marker-expression 'Whether to emit a marker string indicating when it is known that the resulting set of pinned dependencies is valid'
            cand --no-emit-marker-expression 'no-emit-marker-expression'
            cand --emit-index-annotation 'Include comment annotations indicating the index used to resolve each package (e.g., `# from https://pypi.org/simple`)'
            cand --no-emit-index-annotation 'no-emit-index-annotation'
            cand --allow-unsafe 'allow-unsafe'
            cand --no-allow-unsafe 'no-allow-unsafe'
            cand --reuse-hashes 'reuse-hashes'
            cand --no-reuse-hashes 'no-reuse-hashes'
            cand --emit-trusted-host 'emit-trusted-host'
            cand --no-emit-trusted-host 'no-emit-trusted-host'
            cand --no-config 'no-config'
            cand --emit-options 'emit-options'
            cand --no-emit-options 'no-emit-options'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;sync'= {
            cand -c 'Constrain versions using the given requirements files'
            cand --constraint 'Constrain versions using the given requirements files'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand -p 'The Python interpreter into which packages should be installed.'
            cand --python 'The Python interpreter into which packages should be installed.'
            cand --target 'Install packages into the specified directory, rather than into the virtual environment or system Python interpreter. The packages will be installed at the top-level of the directory'
            cand --prefix 'Install packages into `lib`, `bin`, and other top-level folders under the specified directory, as if a virtual environment were created at the specified location'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --only-binary 'Only use pre-built wheels; don''t build source distributions'
            cand --python-version 'The minimum Python version that should be supported by the requirements (e.g., `3.7` or `3.7.9`)'
            cand --python-platform 'The platform for which requirements should be installed'
            cand --trusted-host 'trusted-host'
            cand --python-executable 'python-executable'
            cand --cert 'cert'
            cand --client-cert 'client-cert'
            cand --config 'config'
            cand --pip-args 'pip-args'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed'
            cand --no-reinstall 'no-reinstall'
            cand --compile-bytecode 'Compile Python files to bytecode'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --require-hashes 'Require a matching hash for each requirement'
            cand --no-require-hashes 'no-require-hashes'
            cand --system 'Install packages into the system Python'
            cand --no-system 'no-system'
            cand --break-system-packages 'Allow `uv` to modify an `EXTERNALLY-MANAGED` Python installation'
            cand --no-break-system-packages 'no-break-system-packages'
            cand --legacy-setup-py 'Use legacy `setuptools` behavior when building source distributions without a `pyproject.toml`'
            cand --no-legacy-setup-py 'no-legacy-setup-py'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --allow-empty-requirements 'Allow sync of empty requirements, which will clear the environment of all packages'
            cand --no-allow-empty-requirements 'no-allow-empty-requirements'
            cand --strict 'Validate the virtual environment after completing the installation, to detect packages with missing dependencies or other issues'
            cand --no-strict 'no-strict'
            cand --dry-run 'Perform a dry run, i.e., don''t actually install anything but resolve the dependencies and print the resulting plan'
            cand -a 'a'
            cand --ask 'ask'
            cand --user 'user'
            cand --no-config 'no-config'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;install'= {
            cand -r 'Install all packages listed in the given `requirements.txt` files'
            cand --requirement 'Install all packages listed in the given `requirements.txt` files'
            cand -e 'Install the editable package based on the provided local file path'
            cand --editable 'Install the editable package based on the provided local file path'
            cand -c 'Constrain versions using the given requirements files'
            cand --constraint 'Constrain versions using the given requirements files'
            cand --override 'Override versions using the given requirements files'
            cand --extra 'Include optional dependencies from the extra group name; may be provided more than once. Only applies to `pyproject.toml`, `setup.py`, and `setup.cfg` sources'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter into which packages should be installed.'
            cand --python 'The Python interpreter into which packages should be installed.'
            cand --target 'Install packages into the specified directory, rather than into the virtual environment or system Python interpreter. The packages will be installed at the top-level of the directory'
            cand --prefix 'Install packages into `lib`, `bin`, and other top-level folders under the specified directory, as if a virtual environment were created at the specified location'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --only-binary 'Only use pre-built wheels; don''t build source distributions'
            cand --python-version 'The minimum Python version that should be supported by the requirements (e.g., `3.7` or `3.7.9`)'
            cand --python-platform 'The platform for which requirements should be installed'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-extras 'Include all optional dependencies. Only applies to `pyproject.toml`, `setup.py`, and `setup.cfg` sources'
            cand --no-all-extras 'no-all-extras'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --compile-bytecode 'Compile Python files to bytecode'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --no-deps 'Ignore package dependencies, instead only installing those packages explicitly listed on the command line or in the requirements files'
            cand --deps 'deps'
            cand --require-hashes 'Require a matching hash for each requirement'
            cand --no-require-hashes 'no-require-hashes'
            cand --system 'Install packages into the system Python'
            cand --no-system 'no-system'
            cand --break-system-packages 'Allow `uv` to modify an `EXTERNALLY-MANAGED` Python installation'
            cand --no-break-system-packages 'no-break-system-packages'
            cand --legacy-setup-py 'Use legacy `setuptools` behavior when building source distributions without a `pyproject.toml`'
            cand --no-legacy-setup-py 'no-legacy-setup-py'
            cand --no-build-isolation 'Disable isolation when building source distributions'
            cand --build-isolation 'build-isolation'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --strict 'Validate the virtual environment after completing the installation, to detect packages with missing dependencies or other issues'
            cand --no-strict 'no-strict'
            cand --dry-run 'Perform a dry run, i.e., don''t actually install anything but resolve the dependencies and print the resulting plan'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand --user 'user'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;uninstall'= {
            cand -r 'Uninstall all packages listed in the given requirements files'
            cand --requirement 'Uninstall all packages listed in the given requirements files'
            cand -p 'The Python interpreter from which packages should be uninstalled.'
            cand --python 'The Python interpreter from which packages should be uninstalled.'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for remote requirements files'
            cand --target 'Uninstall packages from the specified `--target` directory'
            cand --prefix 'Uninstall packages from the specified `--prefix` directory'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --system 'Use the system Python to uninstall packages'
            cand --no-system 'no-system'
            cand --break-system-packages 'Allow `uv` to modify an `EXTERNALLY-MANAGED` Python installation'
            cand --no-break-system-packages 'no-break-system-packages'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;freeze'= {
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --exclude-editable 'Exclude any editable packages from output'
            cand --strict 'Validate the virtual environment, to detect packages with missing dependencies or other issues'
            cand --no-strict 'no-strict'
            cand --system 'List packages for the system Python'
            cand --no-system 'no-system'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;list'= {
            cand --exclude 'Exclude the specified package(s) from the output'
            cand --format 'Select the output format between: `columns` (default), `freeze`, or `json`'
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -e 'Only include editable projects'
            cand --editable 'Only include editable projects'
            cand --exclude-editable 'Exclude any editable packages from output'
            cand --strict 'Validate the virtual environment, to detect packages with missing dependencies or other issues'
            cand --no-strict 'no-strict'
            cand --system 'List packages for the system Python'
            cand --no-system 'no-system'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand --outdated 'outdated'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;show'= {
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --strict 'Validate the virtual environment, to detect packages with missing dependencies or other issues'
            cand --no-strict 'no-strict'
            cand --system 'List packages for the system Python'
            cand --no-system 'no-system'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;tree'= {
            cand -d 'Maximum display depth of the dependency tree'
            cand --depth 'Maximum display depth of the dependency tree'
            cand --prune 'Prune the given package from the display of the dependency tree'
            cand --package 'Display only the specified packages'
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --no-dedupe 'Do not de-duplicate repeated dependencies. Usually, when a package has already displayed its dependencies, further occurrences will not re-display its dependencies, and will include a (*) to indicate it has already been shown. This flag will cause those duplicates to be repeated'
            cand --invert 'Show the reverse dependencies for the given package. This flag will invert the tree and display the packages that depend on the given package'
            cand --strict 'Validate the virtual environment, to detect packages with missing dependencies or other issues'
            cand --no-strict 'no-strict'
            cand --system 'List packages for the system Python'
            cand --no-system 'no-system'
            cand --disable-pip-version-check 'disable-pip-version-check'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;check'= {
            cand -p 'The Python interpreter for which packages should be listed.'
            cand --python 'The Python interpreter for which packages should be listed.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --system 'List packages for the system Python'
            cand --no-system 'no-system'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;pip;help'= {
            cand compile 'Compile a `requirements.in` file to a `requirements.txt` file'
            cand sync 'Sync an environment with a `requirements.txt` file'
            cand install 'Install packages into an environment'
            cand uninstall 'Uninstall packages from an environment'
            cand freeze 'List, in requirements format, packages installed in an environment'
            cand list 'List, in tabular format, packages installed in an environment'
            cand show 'Show information about one or more installed packages'
            cand tree 'Display the dependency tree for an environment'
            cand check 'Verify installed packages have compatible dependencies'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;pip;help;compile'= {
        }
        &'uv;pip;help;sync'= {
        }
        &'uv;pip;help;install'= {
        }
        &'uv;pip;help;uninstall'= {
        }
        &'uv;pip;help;freeze'= {
        }
        &'uv;pip;help;list'= {
        }
        &'uv;pip;help;show'= {
        }
        &'uv;pip;help;tree'= {
        }
        &'uv;pip;help;check'= {
        }
        &'uv;pip;help;help'= {
        }
        &'uv;tool'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand run 'Run a tool'
            cand install 'Install a tool'
            cand list 'List installed tools'
            cand uninstall 'Uninstall a tool'
            cand dir 'Show the tools directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;tool;run'= {
            cand --from 'Use the given package to provide the command'
            cand --with 'Include the following extra requirements'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter to use to build the run environment.'
            cand --python 'The Python interpreter to use to build the run environment.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --compile-bytecode 'Compile Python files to bytecode'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;tool;install'= {
            cand --from 'The package to install commands from'
            cand --with 'Include the following extra requirements'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter to use to build the tool environment.'
            cand --python 'The Python interpreter to use to build the tool environment.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --compile-bytecode 'Compile Python files to bytecode'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand --force 'Force installation of the tool'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;tool;list'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;tool;uninstall'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;tool;dir'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;tool;help'= {
            cand run 'Run a tool'
            cand install 'Install a tool'
            cand list 'List installed tools'
            cand uninstall 'Uninstall a tool'
            cand dir 'Show the tools directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;tool;help;run'= {
        }
        &'uv;tool;help;install'= {
        }
        &'uv;tool;help;list'= {
        }
        &'uv;tool;help;uninstall'= {
        }
        &'uv;tool;help;dir'= {
        }
        &'uv;tool;help;help'= {
        }
        &'uv;toolchain'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand list 'List the available toolchains'
            cand install 'Download and install toolchains'
            cand find 'Search for a toolchain'
            cand dir 'Show the toolchains directory'
            cand uninstall 'Uninstall toolchains'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;toolchain;list'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-versions 'List all toolchain versions, including outdated patch versions'
            cand --all-platforms 'List toolchains for all platforms'
            cand --only-installed 'Only show installed toolchains, exclude available downloads'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;toolchain;install'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -f 'Force the installation of the toolchain, even if it is already installed'
            cand --force 'Force the installation of the toolchain, even if it is already installed'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;toolchain;find'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'uv;toolchain;dir'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;toolchain;uninstall'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;toolchain;help'= {
            cand list 'List the available toolchains'
            cand install 'Download and install toolchains'
            cand find 'Search for a toolchain'
            cand dir 'Show the toolchains directory'
            cand uninstall 'Uninstall toolchains'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;toolchain;help;list'= {
        }
        &'uv;toolchain;help;install'= {
        }
        &'uv;toolchain;help;find'= {
        }
        &'uv;toolchain;help;dir'= {
        }
        &'uv;toolchain;help;uninstall'= {
        }
        &'uv;toolchain;help;help'= {
        }
        &'uv;run'= {
            cand --extra 'Include optional dependencies from the extra group name; may be provided more than once. Only applies to `pyproject.toml`, `setup.py`, and `setup.cfg` sources'
            cand --with 'Run with the given packages installed'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --package 'Run the command in a specific package in the workspace'
            cand -p 'The Python interpreter to use to build the run environment.'
            cand --python 'The Python interpreter to use to build the run environment.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-extras 'Include all optional dependencies. Only applies to `pyproject.toml`, `setup.py`, and `setup.cfg` sources'
            cand --no-all-extras 'no-all-extras'
            cand --dev 'Include development dependencies'
            cand --no-dev 'Omit development dependencies'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --compile-bytecode 'Compile Python files to bytecode'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;sync'= {
            cand --extra 'Include optional dependencies from the extra group name; may be provided more than once. Only applies to `pyproject.toml`, `setup.py`, and `setup.cfg` sources'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter to use to build the run environment.'
            cand --python 'The Python interpreter to use to build the run environment.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --all-extras 'Include all optional dependencies. Only applies to `pyproject.toml`, `setup.py`, and `setup.cfg` sources'
            cand --no-all-extras 'no-all-extras'
            cand --dev 'Include development dependencies'
            cand --no-dev 'Omit development dependencies'
            cand --no-clean 'Does not clean the environment. Without this flag any extraneous installations will be removed'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed'
            cand --no-reinstall 'no-reinstall'
            cand --compile-bytecode 'Compile Python files to bytecode'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;lock'= {
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand -p 'The Python interpreter to use to build the run environment.'
            cand --python 'The Python interpreter to use to build the run environment.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --no-upgrade 'no-upgrade'
            cand --pre 'pre'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;add'= {
            cand --optional 'Add the requirements to the specified optional dependency group'
            cand --editable 'Add the requirements as editables'
            cand --rev 'Specific commit to use when adding from Git'
            cand --tag 'Tag to use when adding from git'
            cand --branch 'Branch to use when adding from git'
            cand --extra 'Extras to activate for the dependency; may be provided more than once'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand -P 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --upgrade-package 'Allow upgrades for a specific package, ignoring pinned versions in any existing output file'
            cand --reinstall-package 'Reinstall a specific package, regardless of whether it''s already installed'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --resolution 'The strategy to use when selecting between the different compatible versions for a given package requirement'
            cand --prerelease 'The strategy to use when considering pre-release versions'
            cand -C 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --config-setting 'Settings to pass to the PEP 517 build backend, specified as `KEY=VALUE` pairs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --no-build-package 'Don''t build source distributions for a specific package'
            cand --no-binary-package 'Don''t install pre-built wheels for a specific package'
            cand --refresh-package 'Refresh cached data for a specific package'
            cand --package 'Add the dependency to a specific package in the workspace'
            cand -p 'The Python interpreter into which packages should be installed.'
            cand --python 'The Python interpreter into which packages should be installed.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --dev 'Add the requirements as development dependencies'
            cand --raw-sources 'Add source requirements to the `project.dependencies` section of the `pyproject.toml`'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand -U 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --upgrade 'Allow package upgrades, ignoring pinned versions in any existing output file'
            cand --no-upgrade 'no-upgrade'
            cand --reinstall 'Reinstall all packages, regardless of whether they''re already installed'
            cand --no-reinstall 'no-reinstall'
            cand --pre 'pre'
            cand --compile-bytecode 'Compile Python files to bytecode'
            cand --no-compile-bytecode 'no-compile-bytecode'
            cand --no-build 'Don''t build source distributions'
            cand --build 'build'
            cand --no-binary 'Don''t install pre-built wheels'
            cand --binary 'binary'
            cand --refresh 'Refresh all cached data'
            cand --no-refresh 'no-refresh'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;remove'= {
            cand --optional 'Remove the requirements from the specified optional dependency group'
            cand --package 'Remove the dependency from a specific package in the workspace'
            cand -p 'The Python interpreter into which packages should be installed.'
            cand --python 'The Python interpreter into which packages should be installed.'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --dev 'Remove the requirements from development dependencies'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;venv'= {
            cand -p 'The Python interpreter to use for the virtual environment.'
            cand --python 'The Python interpreter to use for the virtual environment.'
            cand --prompt 'Provide an alternative prompt prefix for the virtual environment.'
            cand -i 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --index-url 'The URL of the Python package index (by default: <https://pypi.org/simple>)'
            cand --extra-index-url 'Extra URLs of package indexes to use, in addition to `--index-url`'
            cand -f 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --find-links 'Locations to search for candidate distributions, beyond those found in the indexes'
            cand --index-strategy 'The strategy to use when resolving against multiple index URLs'
            cand --keyring-provider 'Attempt to use `keyring` for authentication for index URLs'
            cand --exclude-newer 'Limit candidate packages to those that were uploaded prior to the given date'
            cand --link-mode 'The method to use when installing packages from the global cache'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand --system 'Use the system Python to uninstall packages'
            cand --no-system 'no-system'
            cand --seed 'Install seed packages (one or more of: `pip`, `setuptools`, and `wheel`) into the virtual environment'
            cand --allow-existing 'Preserve any existing files or directories at the target path'
            cand --system-site-packages 'Give the virtual environment access to the system site packages directory'
            cand --no-index 'Ignore the registry index (e.g., PyPI), instead relying on direct URL dependencies and those discovered via `--find-links`'
            cand --clear 'clear'
            cand --no-seed 'no-seed'
            cand --no-pip 'no-pip'
            cand --no-setuptools 'no-setuptools'
            cand --no-wheel 'no-wheel'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;cache'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand clean 'Clear the cache, removing all entries or those linked to specific packages'
            cand prune 'Prune all unreachable objects from the cache'
            cand dir 'Show the cache directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;cache;clean'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;cache;prune'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;cache;dir'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;cache;help'= {
            cand clean 'Clear the cache, removing all entries or those linked to specific packages'
            cand prune 'Prune all unreachable objects from the cache'
            cand dir 'Show the cache directory'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;cache;help;clean'= {
        }
        &'uv;cache;help;prune'= {
        }
        &'uv;cache;help;dir'= {
        }
        &'uv;cache;help;help'= {
        }
        &'uv;self'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand update 'Update `uv` to the latest version'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;self;update'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;self;help'= {
            cand update 'Update `uv` to the latest version'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;self;help;update'= {
        }
        &'uv;self;help;help'= {
        }
        &'uv;clean'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;version'= {
            cand --output-format 'output-format'
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;generate-shell-completion'= {
            cand --color 'Control colors in output'
            cand --toolchain-preference 'Whether to prefer Python toolchains from uv or on the system'
            cand --toolchain-fetch 'Whether to automatically download Python toolchains when required'
            cand --cache-dir 'Path to the cache directory'
            cand --config-file 'The path to a `uv.toml` file to use for configuration'
            cand -q 'Do not print any output'
            cand --quiet 'Do not print any output'
            cand -v 'Use verbose output'
            cand --verbose 'Use verbose output'
            cand --no-color 'Disable colors; provided for compatibility with `pip`'
            cand --native-tls 'Whether to load TLS certificates from the platform''s native certificate store'
            cand --no-native-tls 'no-native-tls'
            cand --offline 'Disable network access, relying only on locally cached data and locally available files'
            cand --no-offline 'no-offline'
            cand --preview 'Whether to enable experimental, preview features'
            cand --no-preview 'no-preview'
            cand --isolated 'Avoid discovering a `pyproject.toml` or `uv.toml` file in the current directory or any parent directories'
            cand --show-settings 'Show the resolved settings for the current command'
            cand -n 'Avoid reading from or writing to the cache'
            cand --no-cache 'Avoid reading from or writing to the cache'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
        }
        &'uv;help'= {
            cand pip 'Resolve and install Python packages'
            cand tool 'Run and manage executable Python packages'
            cand toolchain 'Manage Python installations'
            cand run 'Run a command in the project environment'
            cand sync 'Sync the project''s dependencies with the environment'
            cand lock 'Resolve the project requirements into a lockfile'
            cand add 'Add one or more packages to the project requirements'
            cand remove 'Remove one or more packages from the project requirements'
            cand venv 'Create a virtual environment'
            cand cache 'Manage the cache'
            cand self 'Manage the `uv` executable'
            cand clean 'Clear the cache, removing all entries or those linked to specific packages'
            cand version 'Display uv''s version'
            cand generate-shell-completion 'Generate shell completion'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'uv;help;pip'= {
            cand compile 'Compile a `requirements.in` file to a `requirements.txt` file'
            cand sync 'Sync an environment with a `requirements.txt` file'
            cand install 'Install packages into an environment'
            cand uninstall 'Uninstall packages from an environment'
            cand freeze 'List, in requirements format, packages installed in an environment'
            cand list 'List, in tabular format, packages installed in an environment'
            cand show 'Show information about one or more installed packages'
            cand tree 'Display the dependency tree for an environment'
            cand check 'Verify installed packages have compatible dependencies'
        }
        &'uv;help;pip;compile'= {
        }
        &'uv;help;pip;sync'= {
        }
        &'uv;help;pip;install'= {
        }
        &'uv;help;pip;uninstall'= {
        }
        &'uv;help;pip;freeze'= {
        }
        &'uv;help;pip;list'= {
        }
        &'uv;help;pip;show'= {
        }
        &'uv;help;pip;tree'= {
        }
        &'uv;help;pip;check'= {
        }
        &'uv;help;tool'= {
            cand run 'Run a tool'
            cand install 'Install a tool'
            cand list 'List installed tools'
            cand uninstall 'Uninstall a tool'
            cand dir 'Show the tools directory'
        }
        &'uv;help;tool;run'= {
        }
        &'uv;help;tool;install'= {
        }
        &'uv;help;tool;list'= {
        }
        &'uv;help;tool;uninstall'= {
        }
        &'uv;help;tool;dir'= {
        }
        &'uv;help;toolchain'= {
            cand list 'List the available toolchains'
            cand install 'Download and install toolchains'
            cand find 'Search for a toolchain'
            cand dir 'Show the toolchains directory'
            cand uninstall 'Uninstall toolchains'
        }
        &'uv;help;toolchain;list'= {
        }
        &'uv;help;toolchain;install'= {
        }
        &'uv;help;toolchain;find'= {
        }
        &'uv;help;toolchain;dir'= {
        }
        &'uv;help;toolchain;uninstall'= {
        }
        &'uv;help;run'= {
        }
        &'uv;help;sync'= {
        }
        &'uv;help;lock'= {
        }
        &'uv;help;add'= {
        }
        &'uv;help;remove'= {
        }
        &'uv;help;venv'= {
        }
        &'uv;help;cache'= {
            cand clean 'Clear the cache, removing all entries or those linked to specific packages'
            cand prune 'Prune all unreachable objects from the cache'
            cand dir 'Show the cache directory'
        }
        &'uv;help;cache;clean'= {
        }
        &'uv;help;cache;prune'= {
        }
        &'uv;help;cache;dir'= {
        }
        &'uv;help;self'= {
            cand update 'Update `uv` to the latest version'
        }
        &'uv;help;self;update'= {
        }
        &'uv;help;clean'= {
        }
        &'uv;help;version'= {
        }
        &'uv;help;generate-shell-completion'= {
        }
        &'uv;help;help'= {
        }
    ]
    $completions[$command]
}
