/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils_7;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ReflectionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getApplicationProtocols;
    private static final Method setApplicationProtocols;
    private static final Method getEnableRetransmissions;
    private static final Method setEnableRetransmissions;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getMaximumPacketSize;
    private static final Method setMaximumPacketSize;
    private static final Method getNamedGroups;
    private static final Method setNamedGroups;
    private static final Method getServerNames;
    private static final Method setServerNames;
    private static final Method getSignatureSchemes;
    private static final Method setSignatureSchemes;
    private static final Method getSNIMatchers;
    private static final Method setSNIMatchers;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;

    SSLParametersUtil() {
    }

    static BCSSLParameters getParameters(ProvSSLParameters provSSLParameters) {
        BCSSLParameters bCSSLParameters = new BCSSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            bCSSLParameters.setNeedClientAuth(true);
        } else {
            bCSSLParameters.setWantClientAuth(provSSLParameters.getWantClientAuth());
        }
        bCSSLParameters.setEndpointIdentificationAlgorithm(provSSLParameters.getEndpointIdentificationAlgorithm());
        bCSSLParameters.setAlgorithmConstraints(provSSLParameters.getAlgorithmConstraints());
        bCSSLParameters.setServerNames(provSSLParameters.getServerNames());
        bCSSLParameters.setSNIMatchers(provSSLParameters.getSNIMatchers());
        bCSSLParameters.setUseCipherSuitesOrder(provSSLParameters.getUseCipherSuitesOrder());
        bCSSLParameters.setApplicationProtocols(provSSLParameters.getApplicationProtocols());
        bCSSLParameters.setEnableRetransmissions(provSSLParameters.getEnableRetransmissions());
        bCSSLParameters.setMaximumPacketSize(provSSLParameters.getMaximumPacketSize());
        bCSSLParameters.setSignatureSchemes(provSSLParameters.getSignatureSchemes());
        bCSSLParameters.setNamedGroups(provSSLParameters.getNamedGroups());
        return bCSSLParameters;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters provSSLParameters) {
        String[] stringArray;
        SSLParameters sSLParameters = new SSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            sSLParameters.setNeedClientAuth(true);
        } else {
            sSLParameters.setWantClientAuth(provSSLParameters.getWantClientAuth());
        }
        if (null != setAlgorithmConstraints) {
            SSLParametersUtil.set(sSLParameters, setAlgorithmConstraints, JsseUtils_7.exportAlgorithmConstraintsDynamic(provSSLParameters.getAlgorithmConstraints()));
        }
        if (null != setEndpointIdentificationAlgorithm) {
            SSLParametersUtil.set(sSLParameters, setEndpointIdentificationAlgorithm, provSSLParameters.getEndpointIdentificationAlgorithm());
        }
        if (null != setServerNames && null != (stringArray = provSSLParameters.getServerNames())) {
            SSLParametersUtil.set(sSLParameters, setServerNames, JsseUtils_8.exportSNIServerNamesDynamic(stringArray));
        }
        if (null != setSNIMatchers && null != (stringArray = provSSLParameters.getSNIMatchers())) {
            SSLParametersUtil.set(sSLParameters, setSNIMatchers, JsseUtils_8.exportSNIMatchersDynamic(stringArray));
        }
        if (null != setUseCipherSuitesOrder) {
            SSLParametersUtil.set(sSLParameters, setUseCipherSuitesOrder, provSSLParameters.getUseCipherSuitesOrder());
        }
        if (null != setApplicationProtocols && null != (stringArray = provSSLParameters.getApplicationProtocols())) {
            SSLParametersUtil.set(sSLParameters, setApplicationProtocols, stringArray);
        }
        if (null != setEnableRetransmissions) {
            SSLParametersUtil.set(sSLParameters, setEnableRetransmissions, provSSLParameters.getEnableRetransmissions());
        }
        if (null != setMaximumPacketSize) {
            SSLParametersUtil.set(sSLParameters, setMaximumPacketSize, provSSLParameters.getMaximumPacketSize());
        }
        if (null != setSignatureSchemes) {
            SSLParametersUtil.set(sSLParameters, setSignatureSchemes, provSSLParameters.getSignatureSchemes());
        }
        if (null != setNamedGroups) {
            SSLParametersUtil.set(sSLParameters, setNamedGroups, provSSLParameters.getNamedGroups());
        }
        return sSLParameters;
    }

    static BCSSLParameters importSSLParameters(SSLParameters sSLParameters) {
        String[] stringArray;
        BCSSLParameters bCSSLParameters = new BCSSLParameters(sSLParameters.getCipherSuites(), sSLParameters.getProtocols());
        if (sSLParameters.getNeedClientAuth()) {
            bCSSLParameters.setNeedClientAuth(true);
        } else {
            bCSSLParameters.setWantClientAuth(sSLParameters.getWantClientAuth());
        }
        if (null != getEndpointIdentificationAlgorithm && null != (stringArray = (String)SSLParametersUtil.get(sSLParameters, getEndpointIdentificationAlgorithm))) {
            bCSSLParameters.setEndpointIdentificationAlgorithm((String)stringArray);
        }
        if (null != getAlgorithmConstraints && null != (stringArray = SSLParametersUtil.get(sSLParameters, getAlgorithmConstraints))) {
            bCSSLParameters.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraintsDynamic(stringArray));
        }
        if (null != getServerNames && null != (stringArray = SSLParametersUtil.get(sSLParameters, getServerNames))) {
            bCSSLParameters.setServerNames(JsseUtils_8.importSNIServerNamesDynamic(stringArray));
        }
        if (null != getSNIMatchers && null != (stringArray = SSLParametersUtil.get(sSLParameters, getSNIMatchers))) {
            bCSSLParameters.setSNIMatchers(JsseUtils_8.importSNIMatchersDynamic(stringArray));
        }
        if (null != getUseCipherSuitesOrder) {
            bCSSLParameters.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(sSLParameters, getUseCipherSuitesOrder));
        }
        if (null != getApplicationProtocols && null != (stringArray = (String[])SSLParametersUtil.get(sSLParameters, getApplicationProtocols))) {
            bCSSLParameters.setApplicationProtocols(stringArray);
        }
        if (null != getEnableRetransmissions) {
            bCSSLParameters.setEnableRetransmissions((Boolean)SSLParametersUtil.get(sSLParameters, getEnableRetransmissions));
        }
        if (null != getMaximumPacketSize) {
            bCSSLParameters.setMaximumPacketSize((Integer)SSLParametersUtil.get(sSLParameters, getMaximumPacketSize));
        }
        if (null != getSignatureSchemes) {
            bCSSLParameters.setSignatureSchemes((String[])SSLParametersUtil.get(sSLParameters, getSignatureSchemes));
        }
        if (null != getNamedGroups) {
            bCSSLParameters.setNamedGroups((String[])SSLParametersUtil.get(sSLParameters, getNamedGroups));
        }
        return bCSSLParameters;
    }

    static void setParameters(ProvSSLParameters provSSLParameters, BCSSLParameters bCSSLParameters) {
        Collection<BCSNIMatcher> collection;
        List<BCSNIServerName> list;
        BCAlgorithmConstraints bCAlgorithmConstraints;
        String[] stringArray;
        String[] stringArray2 = bCSSLParameters.getCipherSuites();
        if (null != stringArray2) {
            provSSLParameters.setCipherSuites(stringArray2);
        }
        if (null != (stringArray = bCSSLParameters.getProtocols())) {
            provSSLParameters.setProtocols(stringArray);
        }
        if (bCSSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(bCSSLParameters.getWantClientAuth());
        }
        String string = bCSSLParameters.getEndpointIdentificationAlgorithm();
        if (null != string) {
            provSSLParameters.setEndpointIdentificationAlgorithm(string);
        }
        if (null != (bCAlgorithmConstraints = bCSSLParameters.getAlgorithmConstraints())) {
            provSSLParameters.setAlgorithmConstraints(bCAlgorithmConstraints);
        }
        if (null != (list = bCSSLParameters.getServerNames())) {
            provSSLParameters.setServerNames(list);
        }
        if (null != (collection = bCSSLParameters.getSNIMatchers())) {
            provSSLParameters.setSNIMatchers(collection);
        }
        provSSLParameters.setUseCipherSuitesOrder(bCSSLParameters.getUseCipherSuitesOrder());
        String[] stringArray3 = bCSSLParameters.getApplicationProtocols();
        if (null != stringArray3) {
            provSSLParameters.setApplicationProtocols(stringArray3);
        }
        provSSLParameters.setEnableRetransmissions(bCSSLParameters.getEnableRetransmissions());
        provSSLParameters.setMaximumPacketSize(bCSSLParameters.getMaximumPacketSize());
        provSSLParameters.setSignatureSchemes(bCSSLParameters.getSignatureSchemes());
        provSSLParameters.setNamedGroups(bCSSLParameters.getNamedGroups());
    }

    static void setSSLParameters(ProvSSLParameters provSSLParameters, SSLParameters sSLParameters) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3 = sSLParameters.getCipherSuites();
        if (null != stringArray3) {
            provSSLParameters.setCipherSuites(stringArray3);
        }
        if (null != (stringArray2 = sSLParameters.getProtocols())) {
            provSSLParameters.setProtocols(stringArray2);
        }
        if (sSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(sSLParameters.getWantClientAuth());
        }
        if (null != getEndpointIdentificationAlgorithm && null != (stringArray = (String)SSLParametersUtil.get(sSLParameters, getEndpointIdentificationAlgorithm))) {
            provSSLParameters.setEndpointIdentificationAlgorithm((String)stringArray);
        }
        if (null != getAlgorithmConstraints && null != (stringArray = SSLParametersUtil.get(sSLParameters, getAlgorithmConstraints))) {
            provSSLParameters.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraintsDynamic(stringArray));
        }
        if (null != getServerNames && null != (stringArray = SSLParametersUtil.get(sSLParameters, getServerNames))) {
            provSSLParameters.setServerNames(JsseUtils_8.importSNIServerNamesDynamic(stringArray));
        }
        if (null != getSNIMatchers && null != (stringArray = SSLParametersUtil.get(sSLParameters, getSNIMatchers))) {
            provSSLParameters.setSNIMatchers(JsseUtils_8.importSNIMatchersDynamic(stringArray));
        }
        if (null != getUseCipherSuitesOrder) {
            provSSLParameters.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.get(sSLParameters, getUseCipherSuitesOrder));
        }
        if (null != getApplicationProtocols && null != (stringArray = (String[])SSLParametersUtil.get(sSLParameters, getApplicationProtocols))) {
            provSSLParameters.setApplicationProtocols(stringArray);
        }
        if (null != getEnableRetransmissions) {
            provSSLParameters.setEnableRetransmissions((Boolean)SSLParametersUtil.get(sSLParameters, getEnableRetransmissions));
        }
        if (null != getMaximumPacketSize) {
            provSSLParameters.setMaximumPacketSize((Integer)SSLParametersUtil.get(sSLParameters, getMaximumPacketSize));
        }
        if (null != getSignatureSchemes) {
            provSSLParameters.setSignatureSchemes((String[])SSLParametersUtil.get(sSLParameters, getSignatureSchemes));
        }
        if (null != getNamedGroups) {
            provSSLParameters.setNamedGroups((String[])SSLParametersUtil.get(sSLParameters, getNamedGroups));
        }
    }

    private static Object get(Object object, Method method) {
        return ReflectionUtil.invokeGetter(object, method);
    }

    private static void set(Object object, Method method, Object object2) {
        ReflectionUtil.invokeSetter(object, method, object2);
    }

    static {
        Method[] methodArray = ReflectionUtil.getMethods("javax.net.ssl.SSLParameters");
        getAlgorithmConstraints = ReflectionUtil.findMethod(methodArray, "getAlgorithmConstraints");
        setAlgorithmConstraints = ReflectionUtil.findMethod(methodArray, "setAlgorithmConstraints");
        getApplicationProtocols = ReflectionUtil.findMethod(methodArray, "getApplicationProtocols");
        setApplicationProtocols = ReflectionUtil.findMethod(methodArray, "setApplicationProtocols");
        getEnableRetransmissions = ReflectionUtil.findMethod(methodArray, "getEnableRetransmissions");
        setEnableRetransmissions = ReflectionUtil.findMethod(methodArray, "setEnableRetransmissions");
        getEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methodArray, "getEndpointIdentificationAlgorithm");
        setEndpointIdentificationAlgorithm = ReflectionUtil.findMethod(methodArray, "setEndpointIdentificationAlgorithm");
        getMaximumPacketSize = ReflectionUtil.findMethod(methodArray, "getMaximumPacketSize");
        setMaximumPacketSize = ReflectionUtil.findMethod(methodArray, "setMaximumPacketSize");
        getNamedGroups = ReflectionUtil.findMethod(methodArray, "getNamedGroups");
        setNamedGroups = ReflectionUtil.findMethod(methodArray, "setNamedGroups");
        getServerNames = ReflectionUtil.findMethod(methodArray, "getServerNames");
        setServerNames = ReflectionUtil.findMethod(methodArray, "setServerNames");
        getSignatureSchemes = ReflectionUtil.findMethod(methodArray, "getSignatureSchemes");
        setSignatureSchemes = ReflectionUtil.findMethod(methodArray, "setSignatureSchemes");
        getSNIMatchers = ReflectionUtil.findMethod(methodArray, "getSNIMatchers");
        setSNIMatchers = ReflectionUtil.findMethod(methodArray, "setSNIMatchers");
        getUseCipherSuitesOrder = ReflectionUtil.findMethod(methodArray, "getUseCipherSuitesOrder");
        setUseCipherSuitesOrder = ReflectionUtil.findMethod(methodArray, "setUseCipherSuitesOrder");
    }
}

