"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tracing = void 0;
const core = require("@opencensus/core");
const default_config_1 = require("./config/default-config");
const constants_1 = require("./constants");
const plugin_loader_1 = require("./instrumentation/plugin-loader");
class Tracing {
    constructor() {
        this.configLocal = {};
        this.tracer = new core.CoreTracer();
        this.defaultPlugins = plugin_loader_1.PluginLoader.defaultPluginsFromArray(constants_1.Constants.DEFAULT_INSTRUMENTATION_MODULES);
    }
    static get instance() {
        return this.singletonInstance || (this.singletonInstance = new this());
    }
    get active() {
        return this.activeLocal;
    }
    get config() {
        return this.configLocal;
    }
    start(userConfig) {
        this.configLocal = Object.assign(default_config_1.defaultConfig, { plugins: this.defaultPlugins }, userConfig);
        this.logger =
            this.configLocal.logger || core.logger.logger(this.configLocal.logLevel);
        this.configLocal.logger = this.logger;
        this.logger.debug('config: %o', this.configLocal);
        this.pluginLoader = new plugin_loader_1.PluginLoader(this.logger, this.tracer);
        this.pluginLoader.loadPlugins(this.configLocal.plugins);
        if (!this.configLocal.exporter) {
            const exporter = new core.ConsoleExporter(this.configLocal);
            this.registerExporter(exporter);
        }
        else {
            this.registerExporter(this.configLocal.exporter);
        }
        this.activeLocal = true;
        this.tracer.start(this.configLocal);
        return this;
    }
    stop() {
        this.activeLocal = false;
        this.tracer.stop();
        this.pluginLoader.unloadPlugins();
        this.configLocal = {};
    }
    get exporter() {
        return this.configLocal.exporter;
    }
    registerExporter(exporter) {
        if (this.configLocal.exporter) {
            this.unregisterExporter(this.configLocal.exporter);
        }
        if (exporter) {
            this.configLocal.exporter = exporter;
            this.tracer.registerSpanEventListener(exporter);
        }
        return this;
    }
    unregisterExporter(exporter) {
        this.tracer.unregisterSpanEventListener(exporter);
        this.configLocal.exporter = undefined;
        return this;
    }
}
exports.Tracing = Tracing;
//# sourceMappingURL=data:application/json;base64,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