# This file has been autogenerated by the pywayland scanner

# Copyright © 2023 Carlos Garnacho
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..xdg_shell import XdgToplevel
from .xdg_dialog_v1 import XdgDialogV1


class XdgWmDialogV1(Interface):
    """Create dialogs related to other toplevels

    The :class:`XdgWmDialogV1` interface is exposed as a global object allowing
    to register surfaces with a
    :class:`~pywayland.protocol.xdg_shell.XdgToplevel` role as "dialogs"
    relative to another toplevel.

    The compositor may let this relation influence how the surface is placed,
    displayed or interacted with.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "xdg_wm_dialog_v1"
    version = 1

    class error(enum.IntEnum):
        already_used = 0


class XdgWmDialogV1Proxy(Proxy[XdgWmDialogV1]):
    interface = XdgWmDialogV1

    @XdgWmDialogV1.request()
    def destroy(self) -> None:
        """Destroy the dialog manager object

        Destroys the :class:`XdgWmDialogV1` object. This does not affect the
        :class:`~pywayland.protocol.dialog_v1.XdgDialogV1` objects generated
        through it.
        """
        self._marshal(0)
        self._destroy()

    @XdgWmDialogV1.request(
        Argument(ArgumentType.NewId, interface=XdgDialogV1),
        Argument(ArgumentType.Object, interface=XdgToplevel),
    )
    def get_xdg_dialog(self, toplevel: XdgToplevel) -> Proxy[XdgDialogV1]:
        """Create a dialog object

        Creates a :class:`~pywayland.protocol.dialog_v1.XdgDialogV1` object for
        the given toplevel. See the interface description for more details.

        Compositors must raise an already_used error if clients attempt to
        create multiple :class:`~pywayland.protocol.dialog_v1.XdgDialogV1`
        objects for the same
        :class:`~pywayland.protocol.xdg_shell.XdgToplevel`.

        :param toplevel:
        :type toplevel:
            :class:`~pywayland.protocol.xdg_shell.XdgToplevel`
        :returns:
            :class:`~pywayland.protocol.dialog_v1.XdgDialogV1`
        """
        id = self._marshal_constructor(1, XdgDialogV1, toplevel)
        return id


class XdgWmDialogV1Resource(Resource):
    interface = XdgWmDialogV1


class XdgWmDialogV1Global(Global):
    interface = XdgWmDialogV1


XdgWmDialogV1._gen_c()
XdgWmDialogV1.proxy_class = XdgWmDialogV1Proxy
XdgWmDialogV1.resource_class = XdgWmDialogV1Resource
XdgWmDialogV1.global_class = XdgWmDialogV1Global
