# This file has been autogenerated by the pywayland scanner

# Copyright © 2013-2014 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface
from .wp_presentation_feedback import WpPresentationFeedback


class WpPresentation(Interface):
    """Timed presentation related :class:`~pywayland.protocol.wayland.WlSurface` requests

    The main feature of this interface is accurate presentation timing feedback
    to ensure smooth video playback while maintaining audio/video
    synchronization. Some features use the concept of a presentation clock,
    which is defined in the presentation.clock_id event.

    A content update for a :class:`~pywayland.protocol.wayland.WlSurface` is
    submitted by a :func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>` request. Request 'feedback'
    associates with the :func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>` and provides feedback on the
    content update, particularly the final realized presentation time.



    When the final realized presentation time is available, e.g. after a
    framebuffer flip completes, the requested presentation_feedback.presented
    events are sent. The final presentation time can differ from the
    compositor's predicted display update time and the update's target time,
    especially when the compositor misses its target vertical blanking period.
    """

    name = "wp_presentation"
    version = 1

    class error(enum.IntEnum):
        invalid_timestamp = 0
        invalid_flag = 1


class WpPresentationProxy(Proxy[WpPresentation]):
    interface = WpPresentation

    @WpPresentation.request()
    def destroy(self) -> None:
        """Unbind from the presentation interface

        Informs the server that the client will no longer be using this
        protocol object. Existing objects created by this object are not
        affected.
        """
        self._marshal(0)
        self._destroy()

    @WpPresentation.request(
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.NewId, interface=WpPresentationFeedback),
    )
    def feedback(self, surface: WlSurface) -> Proxy[WpPresentationFeedback]:
        """Request presentation feedback information

        Request presentation feedback for the current content submission on the
        given surface. This creates a new presentation_feedback object, which
        will deliver the feedback information once. If multiple
        presentation_feedback objects are created for the same submission, they
        will all deliver the same information.

        For details on what information is returned, see the
        presentation_feedback interface.

        :param surface:
            target surface
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.presentation_time.WpPresentationFeedback`
            -- new feedback object
        """
        callback = self._marshal_constructor(1, WpPresentationFeedback, surface)
        return callback


class WpPresentationResource(Resource):
    interface = WpPresentation

    @WpPresentation.event(
        Argument(ArgumentType.Uint),
    )
    def clock_id(self, clk_id: int) -> None:
        """Clock id for timestamps

        This event tells the client in which clock domain the compositor
        interprets the timestamps used by the presentation extension. This
        clock is called the presentation clock.

        The compositor sends this event when the client binds to the
        presentation interface. The presentation clock does not change during
        the lifetime of the client connection.

        The clock identifier is platform dependent. On POSIX platforms, the
        identifier value is one of the clockid_t values accepted by
        clock_gettime(). clock_gettime() is defined by POSIX.1-2001.

        Timestamps in this clock domain are expressed as tv_sec_hi, tv_sec_lo,
        tv_nsec triples, each component being an unsigned 32-bit value. Whole
        seconds are in tv_sec which is a 64-bit value combined from tv_sec_hi
        and tv_sec_lo, and the additional fractional part in tv_nsec as
        nanoseconds. Hence, for valid timestamps tv_nsec must be in [0,
        999999999].

        Note that clock_id applies only to the presentation clock, and implies
        nothing about e.g. the timestamps used in the Wayland core protocol
        input events.

        Compositors should prefer a clock which does not jump and is not slewed
        e.g. by NTP. The absolute value of the clock is irrelevant. Precision
        of one millisecond or better is recommended. Clients must be able to
        query the current clock value directly, not by asking the compositor.

        :param clk_id:
            platform clock identifier
        :type clk_id:
            `ArgumentType.Uint`
        """
        self._post_event(0, clk_id)


class WpPresentationGlobal(Global):
    interface = WpPresentation


WpPresentation._gen_c()
WpPresentation.proxy_class = WpPresentationProxy
WpPresentation.resource_class = WpPresentationResource
WpPresentation.global_class = WpPresentationGlobal
