/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cache.common.tier;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.opensearch.common.cache.stats.DefaultCacheStatsHolder;

public class TieredSpilloverCacheStatsHolder
extends DefaultCacheStatsHolder {
    private boolean diskCacheEnabled;
    public static final String TIER_DIMENSION_NAME = "tier";
    public static final String TIER_DIMENSION_VALUE_ON_HEAP = "on_heap";
    public static final String TIER_DIMENSION_VALUE_DISK = "disk";

    public TieredSpilloverCacheStatsHolder(List<String> originalDimensionNames, boolean diskCacheEnabled) {
        super(TieredSpilloverCacheStatsHolder.getDimensionNamesWithTier(originalDimensionNames), "tiered_spillover");
        this.diskCacheEnabled = diskCacheEnabled;
    }

    private static List<String> getDimensionNamesWithTier(List<String> dimensionNames) {
        ArrayList<String> dimensionNamesWithTier = new ArrayList<String>(dimensionNames);
        dimensionNamesWithTier.add(TIER_DIMENSION_NAME);
        return dimensionNamesWithTier;
    }

    List<String> getDimensionsWithTierValue(List<String> initialDimensions, String tierValue) {
        ArrayList<String> result = new ArrayList<String>(initialDimensions);
        result.add(tierValue);
        return result;
    }

    private String validateTierDimensionValue(List<String> dimensionValues) {
        String tierDimensionValue = dimensionValues.get(dimensionValues.size() - 1);
        assert (tierDimensionValue.equals(TIER_DIMENSION_VALUE_ON_HEAP) || tierDimensionValue.equals(TIER_DIMENSION_VALUE_DISK)) : "Invalid tier dimension value";
        return tierDimensionValue;
    }

    public void incrementHits(List<String> dimensionValues) {
        this.validateTierDimensionValue(dimensionValues);
        super.incrementHits(dimensionValues);
    }

    public void incrementMisses(List<String> dimensionValues) {
        String tierValue = this.validateTierDimensionValue(dimensionValues);
        Consumer<DefaultCacheStatsHolder.Node> missIncrementer = node -> {
            if (tierValue.equals(TIER_DIMENSION_VALUE_ON_HEAP) && this.diskCacheEnabled) {
                if (node.isAtLowestLevel()) {
                    node.incrementMisses();
                }
            } else {
                node.incrementMisses();
            }
        };
        this.internalIncrement(dimensionValues, missIncrementer, true);
    }

    public void incrementEvictions(List<String> dimensionValues) {
        String tierValue = this.validateTierDimensionValue(dimensionValues);
        Consumer<DefaultCacheStatsHolder.Node> evictionsIncrementer = node -> {
            if (tierValue.equals(TIER_DIMENSION_VALUE_ON_HEAP) && this.diskCacheEnabled) {
                if (node.isAtLowestLevel()) {
                    node.incrementEvictions();
                }
            } else {
                node.incrementEvictions();
            }
        };
        this.internalIncrement(dimensionValues, evictionsIncrementer, true);
    }

    public void incrementSizeInBytes(List<String> dimensionValues, long amountBytes) {
        this.validateTierDimensionValue(dimensionValues);
        super.incrementSizeInBytes(dimensionValues, amountBytes);
    }

    public void decrementSizeInBytes(List<String> dimensionValues, long amountBytes) {
        this.validateTierDimensionValue(dimensionValues);
        super.decrementSizeInBytes(dimensionValues, amountBytes);
    }

    public void incrementItems(List<String> dimensionValues) {
        this.validateTierDimensionValue(dimensionValues);
        super.incrementItems(dimensionValues);
    }

    public void decrementItems(List<String> dimensionValues) {
        this.validateTierDimensionValue(dimensionValues);
        super.decrementItems(dimensionValues);
    }

    void setDiskCacheEnabled(boolean diskCacheEnabled) {
        this.diskCacheEnabled = diskCacheEnabled;
    }
}

